/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.IniFile;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Properties;

public class EgCheckDBUser {
    String domain = null;
    private EgConfigInfo configInfo = new EgConfigInfo("manager");
    public Connection conn = null;
    public Statement stmt = null;
    public String host;
    public String sid;
    public String port;
    public String url;
    public String user;
    public String password;
    public String createUserName;
    public String ntlmV2;
    public String errorMsg = null;
    public boolean canContinue = false;
    public static IniFile iniFile;
    public static IniFile iniDBFile;
    public String dbDriver;
    public String dbUrl;
    public String dbsqlUrl;
    String urlWithSvcName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        PrintStream printStream = null;
        try {
            System.setProperty("jsse.enableCBCProtection", "false");
            printStream = new PrintStream(new FileOutputStream(EgConfigInfo.egMgrErrorFile, true));
            System.setOut(printStream);
            System.setErr(printStream);
            System.out.println("==============EgCheckDBUser starts==============");
            if (stringArray.length != 12) {
                System.out.println("Please pass 12 arguments to execute ...");
                return;
            }
            EgCheckDBUser egCheckDBUser = new EgCheckDBUser(stringArray);
            if (!egCheckDBUser.canContinue) {
                System.out.println(egCheckDBUser.errorMsg);
                return;
            }
            int n = egCheckDBUser.connect();
            if (n != 0) {
                String string = egCheckDBUser.getUrlWithServiceName();
                if (string.equalsIgnoreCase("SQLSERVER")) {
                    System.out.println(egCheckDBUser.errorMsg);
                } else if (egCheckDBUser.errorMsg.indexOf("ORA-01017") >= 0) {
                    System.out.println("Oracle User " + egCheckDBUser.user + " does not exist! or invalid USERNAME/PASSWORD (ORA-01017)");
                } else {
                    n = egCheckDBUser.connect(string);
                    if (n == 0) {
                        iniDBFile.setValue("DB_PROPERTIES", "sql.url", string);
                        iniDBFile.saveFile();
                    } else if (egCheckDBUser.errorMsg.indexOf("ORA-12514") >= 0) {
                        System.out.println("Database connection failed due to invalid SID/SERVICENAME (ORA-12514)");
                    } else if (egCheckDBUser.errorMsg.indexOf("ORA-12505") >= 0) {
                        System.out.println("Database connection failed due to invalid SID/SERVICENAME (ORA-12505)");
                    } else if (egCheckDBUser.errorMsg.indexOf("ORA-01017") >= 0) {
                        System.out.println("User " + egCheckDBUser.user + " does not exist! or invalid USERNAME/PASSWORD (ORA-01017)");
                    } else {
                        System.out.println("ERROR:" + egCheckDBUser.errorMsg);
                    }
                }
            }
            String string = n == 1 ? "1" : (n == 2 ? "2" : "0");
            System.out.println("result-------:" + string);
            iniFile.setValue("CHECK DB RESULT", "DBUser", string);
            iniFile.saveFile();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (printStream != null) {
                System.out.println("==============EgCheckDBUser ends==============");
                printStream.close();
            }
        }
    }

    public void createSetupFile() {
        iniFile = new IniFile(this.configInfo.getSetupFile(), true);
        iniDBFile = new IniFile(this.configInfo.getDbFile(), true);
    }

    public EgCheckDBUser(String[] stringArray) {
        if (!stringArray[0].equals("-host") && stringArray[2].equals("-port") && stringArray[4].equals("-sid") && stringArray[6].equals("-username") && stringArray[8].equals("-password") && stringArray[10].equals("-ntlmv2")) {
            this.errorMsg = "Usage java UserCreate -host <DBHostName> -port <portNo> -sid <SID> -username <username>  -password <password> -ntlmv2 <true / false>";
            this.canContinue = false;
            return;
        }
        this.canContinue = true;
        this.host = stringArray[1];
        this.port = stringArray[3];
        this.sid = stringArray[5];
        this.user = stringArray[7];
        int n = this.user.indexOf("\\");
        if (n < 0) {
            n = this.user.indexOf("/");
        }
        if (n > 0) {
            this.domain = this.user.substring(0, n);
            this.user = this.user.substring(n + 1);
        }
        this.password = stringArray[9];
        this.ntlmV2 = stringArray[11];
        this.createSetupFile();
    }

    void closeConnection() {
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (Exception exception) {
            this.errorMsg = "Error When the connection is closed ...!";
            return;
        }
    }

    public void getsqlInfo() {
        int n;
        int n2 = this.dbUrl.indexOf(";charset");
        if (n2 > (n = this.dbUrl.lastIndexOf("/"))) {
            this.dbsqlUrl = this.dbUrl.substring(0, n);
            this.dbsqlUrl = this.dbsqlUrl + this.dbUrl.substring(n2);
        } else {
            this.dbsqlUrl = this.dbUrl;
        }
        System.out.println(this.dbsqlUrl);
    }

    public void getInfo() {
        try {
            this.dbDriver = iniDBFile.getValue("DB_PROPERTIES", "sql.driver");
            this.dbUrl = iniDBFile.getValue("DB_PROPERTIES", "sql.url");
        }
        catch (Exception exception) {
            System.out.println("Exception " + exception);
        }
    }

    public int connect() {
        try {
            this.getInfo();
            this.getsqlInfo();
            Class.forName(this.dbDriver).newInstance();
            if (this.password.equals("NULL") || this.password.equals("null") || this.password.equals("none") || this.password.equals("NONE")) {
                this.password = "";
            }
            if (this.domain == null || this.domain.equalsIgnoreCase("none")) {
                this.conn = DriverManager.getConnection(this.dbUrl, this.user, this.password);
            } else {
                Properties properties = new Properties();
                properties.put("user", this.user);
                properties.put("password", this.password);
                properties.put("domain", this.domain);
                if (this.ntlmV2 != null && this.ntlmV2.equals("true")) {
                    properties.put("useNTLMv2", this.ntlmV2);
                }
                this.conn = DriverManager.getConnection(this.dbUrl, properties);
            }
        }
        catch (Exception exception) {
            this.errorMsg = exception.getMessage();
            if (this.errorMsg.indexOf("Cannot open user defaul") >= 0) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public String getUrlWithServiceName() {
        int n = this.dbUrl.indexOf("sqlserver");
        if (n == -1) {
            int n2 = this.dbUrl.lastIndexOf(":");
            String string = this.dbUrl.substring(n2 + 1);
            this.urlWithSvcName = this.dbUrl.substring(0, n2) + "/" + string;
        } else {
            this.urlWithSvcName = "SQLSERVER";
        }
        return this.urlWithSvcName;
    }

    public int connect(String string) {
        try {
            System.out.println(string + " " + this.user + " *****");
            Class.forName(this.dbDriver);
            this.conn = DriverManager.getConnection(string, this.user, this.password);
        }
        catch (Exception exception) {
            this.errorMsg = exception.getMessage();
            if (this.errorMsg.indexOf("Cannot open user defaul") >= 0) {
                return 2;
            }
            return 1;
        }
        return 0;
    }
}

