/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigFilesSync;
import com.eg.EgConfigInfo;
import com.eg.EgInstallInfo;
import com.eg.IniFile;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;

public class EgVirtualComponentInfo {
    public static final String esxServercomp = "Virtual_Components";
    public static final String cloudServercomp = "Cloud_Components";
    private static IniFile virCompFilePtr;
    private static String whoami;
    private static File virFile;
    private static String virFileName;
    public static String syncFlag;
    public static Hashtable virtualComponentsMap;
    public static Hashtable cloudComponentsMap;
    public static long lastModifiedTime;
    public static long lastSize;

    public static void main(String[] stringArray) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EgVirtualComponentInfo(String string) {
        whoami = string;
        if (virFile == null) {
            String string2 = syncFlag;
            synchronized (string2) {
                if (virFile == null) {
                    EgConfigInfo egConfigInfo = new EgConfigInfo(string);
                    virFileName = egConfigInfo.getVirtualComponentFile(string);
                    egConfigInfo = null;
                    File file = new File(virFileName);
                    lastModifiedTime = this.lastModified();
                    lastSize = this.lastSize();
                    virCompFilePtr = new IniFile(virFileName);
                    virFile = file;
                    virtualComponentsMap = null;
                    cloudComponentsMap = null;
                }
            }
        }
    }

    public long lastModified() {
        return IniFile.getLastModified(virFileName);
    }

    public long lastSize() {
        return IniFile.getLastSize(virFileName);
    }

    public void release() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForUpdate() {
        long l = this.lastModified();
        long l2 = this.lastSize();
        if (l == lastModifiedTime && l2 == lastSize) {
            return false;
        }
        String string = syncFlag;
        synchronized (string) {
            l = this.lastModified();
            l2 = this.lastSize();
            if (l == lastModifiedTime && l2 == lastSize) {
                return false;
            }
            lastModifiedTime = l;
            lastSize = l2;
            virCompFilePtr = new IniFile(virFileName);
            virtualComponentsMap = null;
            cloudComponentsMap = null;
            return true;
        }
    }

    public Hashtable getVirtualComponentsMap() {
        return this.getVirtualComponentsMap(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getVirtualComponentsMap(boolean bl) {
        if (bl) {
            this.checkForUpdate();
        }
        String string = syncFlag;
        synchronized (string) {
            if (virtualComponentsMap != null) {
                return virtualComponentsMap;
            }
            virtualComponentsMap = new Hashtable();
            String[] stringArray = virCompFilePtr.getVariables(esxServercomp);
            if (stringArray == null || stringArray.length == 0) {
                return virtualComponentsMap;
            }
            Vector vector = virCompFilePtr.getAllValues(esxServercomp);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = (String)vector.get(i);
                virtualComponentsMap.put(stringArray[i], string2);
            }
            return virtualComponentsMap;
        }
    }

    public Hashtable getCloudComponentsMap() {
        return this.getCloudComponentsMap(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getCloudComponentsMap(boolean bl) {
        if (bl) {
            this.checkForUpdate();
        }
        String string = syncFlag;
        synchronized (string) {
            if (cloudComponentsMap != null) {
                return cloudComponentsMap;
            }
            cloudComponentsMap = new Hashtable();
            String[] stringArray = virCompFilePtr.getVariables(cloudServercomp);
            if (stringArray == null || stringArray.length == 0) {
                return cloudComponentsMap;
            }
            Vector vector = virCompFilePtr.getAllValues(cloudServercomp);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = (String)vector.get(i);
                cloudComponentsMap.put(stringArray[i], string2);
            }
            return cloudComponentsMap;
        }
    }

    public Vector getVirtualComponentsFor(String string) {
        return this.getVirtualComponentsFor(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getVirtualComponentsFor(String string, boolean bl) {
        if (bl) {
            this.checkForUpdate();
        }
        Vector<String> vector = new Vector<String>();
        String string2 = syncFlag;
        synchronized (string2) {
            String[] stringArray = virCompFilePtr.getVariables(esxServercomp);
            if (stringArray != null) {
                for (String string3 : stringArray) {
                    String string4 = virCompFilePtr.getValue(esxServercomp, string3);
                    if (!string4.equals(string)) continue;
                    vector.add(string3);
                }
            }
        }
        return vector;
    }

    public Vector getCloudComponentsFor(String string) {
        return this.getCloudComponentsFor(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getCloudComponentsFor(String string, boolean bl) {
        if (bl) {
            this.checkForUpdate();
        }
        Vector<String> vector = new Vector<String>();
        String string2 = syncFlag;
        synchronized (string2) {
            String[] stringArray = virCompFilePtr.getVariables(cloudServercomp);
            if (stringArray != null) {
                for (String string3 : stringArray) {
                    String string4 = virCompFilePtr.getValue(cloudServercomp, string3);
                    if (!string4.equals(string)) continue;
                    vector.add(string3);
                }
            }
        }
        return vector;
    }

    private boolean isDiff(Vector vector, Vector vector2) {
        if (vector == null && vector2 == null) {
            return false;
        }
        if (vector == null && vector2 != null) {
            return true;
        }
        if (vector != null && vector2 == null) {
            return true;
        }
        if (vector.size() != vector2.size()) {
            return true;
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            if (vector2.contains(string)) continue;
            return true;
        }
        return false;
    }

    public void updateVirtualComponents(Vector vector, Vector vector2, String string) {
        if (!this.isDiff(vector, vector2)) {
            return;
        }
        IniFile iniFile = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_virtualcomponents.ini");
        boolean bl = false;
        if (vector != null) {
            iniFile.deleteValues(esxServercomp, vector);
            bl = true;
        }
        if (vector2 != null) {
            int n = vector2.size();
            Vector<String> vector3 = new Vector<String>();
            for (int i = 0; i < n; ++i) {
                vector3.add(string);
            }
            iniFile.setValues(esxServercomp, vector2, vector3, false);
            bl = true;
        }
        if (bl) {
            iniFile.saveFile();
            EgConfigFilesSync.releaseInstance(iniFile);
            this.checkForUpdate();
        } else {
            EgConfigFilesSync.releaseInstance(iniFile);
        }
    }

    public void updateCloudComponents(Vector vector, Vector vector2, String string) {
        if (!this.isDiff(vector, vector2)) {
            return;
        }
        IniFile iniFile = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_virtualcomponents.ini");
        boolean bl = false;
        if (vector != null) {
            iniFile.deleteValues(cloudServercomp, vector);
            bl = true;
        }
        if (vector2 != null) {
            int n = vector2.size();
            for (int i = 0; i < n; ++i) {
                String string2 = (String)vector2.get(i);
                iniFile.setValue(cloudServercomp, string2, string);
                bl = true;
            }
        }
        if (bl) {
            iniFile.saveFile();
            EgConfigFilesSync.releaseInstance(iniFile);
            this.checkForUpdate();
        } else {
            EgConfigFilesSync.releaseInstance(iniFile);
        }
    }

    static {
        virFile = null;
        syncFlag = new String("EgVirComp");
        virtualComponentsMap = new Hashtable();
        cloudComponentsMap = new Hashtable();
    }
}

