/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.EgSSL;
import com.eg.MyHostnameVerifier;
import com.eg.MyX509TrustManager;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

class IISServerHelperThread
extends Thread {
    private String hostIp;
    private int portNo;
    public Socket sd;
    private int timeOut;
    private PrintWriter pw;
    private BufferedReader br;
    private int webContentSize;
    public boolean status;
    public boolean done;
    public boolean isIIS = false;
    public boolean isNginx = false;
    public String serverHeader = null;
    public boolean isWebServer;

    public IISServerHelperThread(String string, int n, int n2, int n3) {
        this.hostIp = string;
        this.portNo = n;
        this.timeOut = n2;
        this.webContentSize = n3;
        this.setName("IISServerHelperThread");
        this.start();
    }

    @Override
    public void run() {
        String string;
        boolean bl = false;
        if (EgConfigInfo.todie) {
            return;
        }
        try {
            this.sd = new Socket();
            int n = this.timeOut / 4;
            if (n < 400) {
                n = 400;
            }
            this.sd.connect(new InetSocketAddress(this.hostIp, this.portNo), n);
            this.sd.setSoTimeout(this.timeOut);
        }
        catch (Exception exception) {
            this.status = false;
            this.done = true;
            this.cleanup();
            return;
        }
        this.status = true;
        if (this.portNo == 443) {
            bl = true;
        }
        if (!bl) {
            try {
                this.pw = new PrintWriter(this.sd.getOutputStream(), false);
                this.pw.print("GET / HTTP/1.0\r\n\r\n");
                this.pw.flush();
                this.br = new BufferedReader(new InputStreamReader(this.sd.getInputStream()));
                Object var2_4 = null;
                int n = 0;
                if (this.br != null) {
                    string = this.br.readLine();
                    while (string != null) {
                        try {
                            n += string.length();
                            if (string.startsWith("Server:")) {
                                this.serverHeader = string;
                            }
                            string = this.br.readLine();
                        }
                        catch (Exception exception) {
                            System.out.println("Exception Happenend");
                            break;
                        }
                    }
                }
                if (n < this.webContentSize) {
                    this.status = false;
                    this.done = true;
                    this.cleanup();
                } else {
                    if (this.serverHeader != null && (this.serverHeader.indexOf("Microsoft") >= 0 || this.serverHeader.indexOf("IIS") >= 0)) {
                        this.isIIS = true;
                    }
                    this.done = true;
                    this.cleanup();
                }
            }
            catch (Exception exception) {
                this.status = false;
                this.done = true;
                this.cleanup();
            }
        }
        if (bl) {
            try {
                EgSSL egSSL = EgSSL.getInstance();
                egSSL.enableSSL();
                System.setProperty("org.apache.axis.components.net.SecureSocketFactory", "org.apache.axis.components.net.SunFakeTrustSocketFactory");
                SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                string = null;
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
                HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
                URL uRL = new URL("https://" + this.hostIp + ":" + this.portNo);
                URLConnection uRLConnection = uRL.openConnection();
                String string2 = uRLConnection.getHeaderField("Server");
                if (string2 != null) {
                    if (string2.indexOf("Microsoft") >= 0 || string2.indexOf("IIS") >= 0) {
                        System.out.println("serverHeader is " + string2);
                        this.isIIS = true;
                    }
                    this.done = true;
                    this.cleanup();
                }
            }
            catch (Exception exception) {
                System.out.println("[IISServerDiscovery] Exception_1 status = " + this.status);
                this.status = false;
                this.done = true;
                this.cleanup();
            }
        }
    }

    public void cleanup() {
        try {
            if (this.pw != null) {
                this.pw.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.br != null) {
                this.br.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.sd != null) {
                this.sd.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

