/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.DBConnectionThread;
import com.eg.EgConfigInfo;
import com.eg.EgDateInfo;
import com.eg.EgInstallInfo;
import com.egurkha.util.StringUtils;
import egurkha.TransactionBean;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class UIUserCreation
extends EgConfigInfo {
    Connection conn = null;
    Statement stmt = null;
    String host;
    String sid;
    String port;
    String dbaUser;
    String dbaPassword;
    String userName;
    String password;
    String dbconnection;
    String defaultTspace;
    String tempTspace;
    String selVersion;
    String sysPassword;
    TransactionBean trans = new TransactionBean();
    EgDateInfo dateInfo = new EgDateInfo();
    String pathDir = "";
    String fileName;
    String query_string = "";
    String size_alloc = "unlimited";
    public String errorMsg = null;
    public String version = null;
    boolean isConnected;
    boolean isUserExist;
    public boolean isSuccessful = false;
    public boolean pwd_flag = false;

    public static void main(String[] stringArray) {
        System.setProperty("jsse.enableCBCProtection", "false");
        UIUserCreation uIUserCreation = new UIUserCreation(stringArray);
        if (!uIUserCreation.isSuccessful) {
            return;
        }
        if (!uIUserCreation.execute()) {
            return;
        }
    }

    boolean initialize(String[] stringArray) {
        if (!this.pwd_flag) {
            if (!(stringArray[0].equals("-host") && stringArray[2].equals("-port") && stringArray[4].equals("-sid") && stringArray[6].equals("-dbauser") && stringArray[8].equals("-dbapassword") && stringArray[10].equals("-username") && stringArray[12].equals("-userpassword") && stringArray[14].equals("-defaulttablespace") && stringArray[16].equals("-temptablespace") && stringArray[18].equals("-version"))) {
                System.out.println("Usage java UIUserCreation -host <hostname>  -port <portNo> -sid<Database Instance Name> -dbauser <DbUser>  -dbapassword <UserPasswd> -username <user name>  -userpassword  <password for user >-defaulttablepspace <default Table space> -temptablespace -version <Oracle version>");
                this.errorMsg = "Passed parameters not correct. ";
                return false;
            }
            return true;
        }
        if (!(stringArray[0].equals("-host") && stringArray[2].equals("-port") && stringArray[4].equals("-sid") && stringArray[6].equals("-dbauser") && stringArray[8].equals("-dbapassword") && stringArray[10].equals("-username") && stringArray[12].equals("-userpassword") && stringArray[14].equals("-defaulttablespace") && stringArray[16].equals("-temptablespace") && stringArray[18].equals("-version") && stringArray[20].equals("-syspassword"))) {
            System.out.println("Usage java UIUserCreation -host <hostname>  -port <portNo> -sid<Database Instance Name> -dbauser <DbUser>  -dbapassword <UserPasswd> -username <user name>  -userpassword  <password for user >-defaulttablepspace <default Table space> -temptablespace -version <Oracle version>  -syspassword <password for sys>");
            this.errorMsg = "Passed parameters not correct. ";
            return false;
        }
        return true;
    }

    public boolean execute() {
        boolean bl = false;
        this.isSuccessful = this.validateUser(this.userName);
        if (!this.isSuccessful) {
            return false;
        }
        this.isSuccessful = this.createUser();
        return this.isSuccessful;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public UIUserCreation(String[] stringArray) {
        String string = EgInstallInfo.getInstallDir();
        this.trans.createFile("eg_services.ini");
        String string2 = this.trans.getStrValue("MISC_ARGS", "ManagerOS");
        this.pathDir = string2.equalsIgnoreCase("WINDOWS") ? string + "\\bin\\database\\uiscripts\\" : string + "/bin/database/uiscripts/";
        if (stringArray.length == 22 && stringArray[19].equals("Oracle 7.x")) {
            this.pwd_flag = true;
        } else if (stringArray.length < 20 || stringArray.length == 21) {
            this.errorMsg = "Inadequate parameters. ";
            return;
        }
        this.isSuccessful = this.initialize(stringArray);
        if (!this.isSuccessful) {
            return;
        }
        this.host = stringArray[1];
        this.port = stringArray[3];
        this.sid = stringArray[5];
        this.dbaUser = stringArray[7];
        this.dbaPassword = stringArray[9];
        this.userName = stringArray[11];
        this.password = stringArray[13];
        this.defaultTspace = stringArray[15];
        this.tempTspace = stringArray[17];
        this.selVersion = stringArray[19];
        if (stringArray.length == 22) {
            if (stringArray.length == 22 && this.selVersion.equals("Oracle 7.x")) {
                this.sysPassword = stringArray[21];
            } else {
                this.dbconnection = stringArray[21];
            }
        }
        this.isConnected = false;
        this.isUserExist = false;
    }

    boolean validateUser(String string) {
        boolean bl = false;
        if (!this.connect()) {
            return false;
        }
        if (this.checkUserInDatabase(string)) {
            this.errorMsg = "User " + string + " already exists. ";
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    public boolean checkUserInDatabase(String string) {
        Statement statement = null;
        boolean bl = false;
        try {
            statement = this.conn.createStatement();
            ResultSet resultSet = null;
            try {
                resultSet = statement.executeQuery("SELECT username FROM dba_users");
            }
            catch (SQLException sQLException) {
                this.errorMsg = "Error in query.";
                sQLException.printStackTrace();
                bl = false;
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    String string2 = resultSet.getString(1);
                    if (!string.equalsIgnoreCase(string2)) continue;
                    bl = true;
                    break;
                }
            }
            resultSet.close();
            if (resultSet != null) {
                resultSet = null;
            }
        }
        catch (SQLException sQLException) {
            this.errorMsg = "Error in query.";
            bl = false;
            sQLException.printStackTrace();
        }
        catch (Exception exception) {
            this.errorMsg = "Exception thrown.";
            bl = false;
            exception.printStackTrace();
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    boolean createUser() {
        block67: {
            ResultSet resultSet = null;
            ResultSet resultSet2 = null;
            boolean bl = false;
            if (!this.connect()) {
                this.errorMsg = "Connection to database failed.";
                return false;
            }
            try {
                String string;
                this.stmt = this.conn.createStatement();
                if (this.version.equals("Oracle7.x")) {
                    String[] stringArray = new String[]{"orascript7.x1.sql", "orascript7.x2.sql"};
                    String string2 = "SELECT * FROM dba_roles WHERE role = 'SELECT_CATALOG_ROLE'";
                    try {
                        resultSet2 = this.stmt.executeQuery(string2);
                        if (!resultSet2.next()) {
                            for (int i = 0; i < stringArray.length; ++i) {
                                String string3;
                                int n;
                                this.fileName = stringArray[i];
                                Vector vector = this.getData(this.fileName);
                                if (vector == null) {
                                    this.errorMsg = "File  " + this.pathDir + this.fileName + "  doesn't exist.";
                                    this.closeConnection();
                                    return false;
                                }
                                int n2 = vector.size();
                                if (this.fileName.equals("orascript7.x1.sql")) {
                                    for (n = 0; n < n2; ++n) {
                                        string3 = (String)vector.get(n);
                                        String string4 = this.conn.nativeSQL(string3);
                                        try {
                                            boolean bl2 = this.stmt.execute(string4);
                                            continue;
                                        }
                                        catch (SQLException sQLException) {
                                            this.errorMsg = "Error in query.";
                                            sQLException.printStackTrace();
                                        }
                                    }
                                    continue;
                                }
                                for (n = 0; n < n2; ++n) {
                                    string2 = (String)vector.get(n);
                                    string3 = this.conn.nativeSQL(string2);
                                    try {
                                        boolean bl3 = this.stmt.execute(string3);
                                        continue;
                                    }
                                    catch (SQLException sQLException) {
                                        sQLException.printStackTrace();
                                        SQLException sQLException2 = sQLException;
                                        while ((sQLException2 = sQLException.getNextException()) != null) {
                                            sQLException2.printStackTrace();
                                        }
                                        this.errorMsg = "Error in query.";
                                        this.closeConnection();
                                        return false;
                                    }
                                }
                            }
                            string2 = "SELECT * FROM dba_views WHERE view_name = 'V_$TABLESPACE'";
                            try {
                                resultSet = this.stmt.executeQuery(string2);
                                if (!resultSet.next()) {
                                    try {
                                        this.query_string = "CREATE VIEW v_$tablespace AS SELECT ts#,name FROM ts$ WHERE online$=1";
                                        this.stmt.executeQuery(this.query_string);
                                    }
                                    catch (SQLException sQLException) {
                                        this.errorMsg = "Error in " + this.query_string;
                                        sQLException.printStackTrace();
                                        this.closeConnection();
                                        return false;
                                    }
                                }
                                resultSet.close();
                                if (resultSet != null) {
                                    resultSet = null;
                                }
                            }
                            catch (SQLException sQLException) {
                                this.errorMsg = "Error in check view query.";
                                sQLException.printStackTrace();
                                this.closeConnection();
                                return false;
                            }
                            string2 = "SELECT * FROM dba_synonyms WHERE synonym_name = 'V$TABLESPACE'";
                            try {
                                resultSet = this.stmt.executeQuery(string2);
                                if (!resultSet.next()) {
                                    try {
                                        this.query_string = "CREATE PUBLIC SYNONYM v$tablespace FOR v_$tablespace";
                                        this.stmt.executeQuery(this.query_string);
                                    }
                                    catch (SQLException sQLException) {
                                        this.errorMsg = "Error in " + this.query_string;
                                        sQLException.printStackTrace();
                                        this.closeConnection();
                                        return false;
                                    }
                                }
                                resultSet.close();
                                if (resultSet != null) {
                                    resultSet = null;
                                }
                            }
                            catch (SQLException sQLException) {
                                this.errorMsg = "Error in check synonym query.";
                                sQLException.printStackTrace();
                                this.closeConnection();
                                return false;
                            }
                            try {
                                this.query_string = "GRANT SELECT ON v_$tablespace TO select_catalog_role";
                                resultSet = this.stmt.executeQuery(this.query_string);
                            }
                            catch (SQLException sQLException) {
                                this.errorMsg = "Error in " + this.query_string;
                                sQLException.printStackTrace();
                                this.closeConnection();
                                return false;
                            }
                        }
                        resultSet2.close();
                        if (resultSet2 != null) {
                            resultSet2 = null;
                        }
                        String string5 = "SELECT role FROM dba_roles WHERE role='EGURKHAROLE'";
                        try {
                            resultSet = this.stmt.executeQuery(string5);
                            if (!resultSet.next()) {
                                string5 = "CREATE role eGurkhaRole";
                                try {
                                    this.stmt.execute(string5);
                                }
                                catch (SQLException sQLException) {
                                    this.errorMsg = "Error in create egurkharole query.";
                                    sQLException.printStackTrace();
                                    this.closeConnection();
                                    return false;
                                }
                                string5 = "GRANT connect,resource, select_catalog_role TO eGurkhaRole";
                                try {
                                    this.stmt.execute(string5);
                                }
                                catch (SQLException sQLException) {
                                    this.errorMsg = "Error in grant connect, resource, select_catalog_role query.";
                                    sQLException.printStackTrace();
                                    this.closeConnection();
                                    return false;
                                }
                            }
                            resultSet.close();
                            if (resultSet != null) {
                                resultSet = null;
                            }
                        }
                        catch (SQLException sQLException) {
                            this.errorMsg = "Error in check role query.";
                            sQLException.printStackTrace();
                            this.closeConnection();
                            return false;
                        }
                        string5 = "CREATE USER " + this.userName + " IDENTIFIED BY \"" + this.password + "\"  DEFAULT TABLESPACE " + this.defaultTspace + "  TEMPORARY TABLESPACE " + this.tempTspace + " QUOTA " + this.size_alloc + " ON " + this.defaultTspace;
                        try {
                            this.stmt.execute(string5);
                        }
                        catch (SQLException sQLException) {
                            this.errorMsg = "Error in create user query. Invalid default/temporary tablespace.";
                            sQLException.printStackTrace();
                            this.closeConnection();
                            return false;
                        }
                        string5 = "GRANT eGurkhaRole TO " + this.userName;
                        try {
                            this.stmt.execute(string5);
                        }
                        catch (SQLException sQLException) {
                            this.errorMsg = "Error in " + string5;
                            sQLException.printStackTrace();
                            this.closeConnection();
                            return false;
                        }
                        try {
                            if (this.stmt != null) {
                                this.stmt.close();
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        this.errorMsg = "File  " + this.pathDir + this.fileName + "  doesn't exist.";
                        return false;
                    }
                    try {
                        if (this.stmt != null) {
                            this.stmt.close();
                        }
                        break block67;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break block67;
                }
                if (!StringUtils.isNull((String)this.version) && !this.version.equals("Oracle12.x")) {
                    string = "SELECT role FROM dba_roles WHERE role='EGURKHAROLE'";
                    try {
                        resultSet = this.stmt.executeQuery(string);
                        if (!resultSet.next()) {
                            string = "CREATE role eGurkhaRole ";
                            try {
                                this.stmt.execute(string);
                            }
                            catch (SQLException sQLException) {
                                this.errorMsg = "Error in create role query.";
                                sQLException.printStackTrace();
                                this.closeConnection();
                                return false;
                            }
                            string = "GRANT connect,resource,select_catalog_role TO eGurkhaRole";
                            try {
                                this.stmt.execute(string);
                            }
                            catch (SQLException sQLException) {
                                this.errorMsg = "Error in grant connect, resource, select_catalog_role query.";
                                sQLException.printStackTrace();
                                this.closeConnection();
                                return false;
                            }
                        }
                        resultSet.close();
                        if (resultSet != null) {
                            resultSet = null;
                        }
                    }
                    catch (SQLException sQLException) {
                        this.errorMsg = "Error in check role query.";
                        sQLException.printStackTrace();
                        this.closeConnection();
                        return false;
                    }
                }
                string = "CREATE USER " + this.userName + " IDENTIFIED BY \"" + this.password + "\" DEFAULT TABLESPACE " + this.defaultTspace + "  TEMPORARY TABLESPACE " + this.tempTspace + " QUOTA " + this.size_alloc + " ON " + this.defaultTspace;
                try {
                    this.stmt.execute(string);
                }
                catch (SQLException sQLException) {
                    this.errorMsg = "Error in create user query. Invalid default/temporary tablespace.";
                    sQLException.printStackTrace();
                    this.closeConnection();
                    return false;
                }
                string = !StringUtils.isNull((String)this.version) && !this.version.equals("Oracle12.x") ? "GRANT eGurkhaRole TO " + this.userName : "GRANT connect,resource,select_catalog_role TO " + this.userName;
                try {
                    this.stmt.execute(string);
                }
                catch (SQLException sQLException) {
                    this.errorMsg = "Error in " + string;
                    sQLException.printStackTrace();
                    this.closeConnection();
                    return false;
                }
                try {
                    if (this.stmt != null) {
                        this.stmt.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.closeConnection();
                this.errorMsg = "Error in createUser()";
                return false;
            }
        }
        this.closeConnection();
        return true;
    }

    void closeConnection() {
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (this.conn != null) {
                this.conn.close();
            }
            this.isConnected = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    boolean connect() {
        if (this.isConnected) {
            return true;
        }
        if (this.checkVersion(this.dbaUser, this.dbaPassword, this.selVersion)) {
            if (this.version.equals("Oracle7.x")) {
                try {
                    Class.forName("oracle.jdbc.driver.OracleDriver");
                    this.conn = DriverManager.getConnection("jdbc:oracle:thin:@" + this.host + ":" + this.port + ":" + this.sid, "sys", this.sysPassword);
                    this.isConnected = true;
                }
                catch (Exception exception) {
                    this.errorMsg = "Connection to database failed. Invalid SYS password.";
                    exception.printStackTrace();
                    this.isConnected = false;
                }
                return this.isConnected;
            }
            try {
                Class.forName("oracle.jdbc.driver.OracleDriver");
                String string = "jdbc:oracle:thin:@" + this.host + ":" + this.port + ":" + this.sid;
                if (!StringUtils.isNull((String)this.selVersion) && this.selVersion.equals("Oracle12.x") && !StringUtils.isNull((String)this.dbconnection) && this.dbconnection.equals("pdb")) {
                    string = "jdbc:oracle:thin:@" + this.host + ":" + this.port + "/" + this.sid;
                }
                this.conn = DriverManager.getConnection(string, this.dbaUser, this.dbaPassword);
                this.isConnected = true;
            }
            catch (Exception exception) {
                this.errorMsg = "Connection to database failed.Invalid DB admin/password.";
                exception.printStackTrace();
                this.isConnected = false;
            }
            return this.isConnected;
        }
        return false;
    }

    boolean checkVersion(String string, String string2, String string3) {
        ResultSet resultSet = null;
        Statement statement = null;
        String string4 = "";
        String string5 = "";
        String string6 = string3;
        try {
            DBConnectionThread dBConnectionThread;
            boolean bl;
            Class.forName("oracle.jdbc.driver.OracleDriver");
            String string7 = this.host + ":" + this.port + ":" + this.sid;
            if (!StringUtils.isNull((String)string3) && string3.equals("Oracle12.x") && !StringUtils.isNull((String)this.dbconnection) && this.dbconnection.equals("pdb")) {
                string7 = this.host + ":" + this.port + "/" + this.sid;
            }
            if (!(bl = this.checkForTimeout(dBConnectionThread = new DBConnectionThread(string7, string, string2)))) {
                this.errorMsg = "Connection refused.Invalid hostname/portno/sid or invalid DB admin/password.";
                return false;
            }
            this.conn = dBConnectionThread.conn;
            if (this.conn == null) {
                this.errorMsg = "Connection refused.Invalid hostname/portno/sid or invalid DB admin/password.";
                return false;
            }
            statement = this.conn.createStatement();
            resultSet = statement.executeQuery("SELECT * FROM v$version");
            if (resultSet != null) {
                while (resultSet.next()) {
                    string4 = resultSet.getString(1);
                    if (string4.indexOf("Release") <= 0) continue;
                    string5 = string4.substring(string4.indexOf("Release") + 7, string4.indexOf("-"));
                    string5 = string5.trim();
                    string5 = string5.substring(0, string5.indexOf(".") + 1);
                    string5 = "Oracle" + string5 + "x";
                    if (!string5.equals("Oracle 7.x") && (string3.equals("Above") || string3.equals("Oracle12.x"))) {
                        this.version = string5;
                        continue;
                    }
                    if (string5.equals(string3)) {
                        this.version = string3;
                        break;
                    }
                    this.errorMsg = string3 + "  not found on  " + this.host;
                    this.closeConnection();
                    return false;
                }
            }
            resultSet.close();
            if (resultSet != null) {
                // empty if block
            }
            resultSet = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.closeConnection();
            return true;
        }
        catch (Exception exception) {
            this.errorMsg = "Error in query.";
            exception.printStackTrace();
            return false;
        }
    }

    public Vector getData(String string) {
        String string2 = this.pathDir + string;
        BufferedReader bufferedReader = null;
        Object var4_4 = null;
        boolean bl = true;
        String string3 = " Null";
        String string4 = "";
        boolean bl2 = false;
        Vector<String> vector = new Vector<String>();
        try {
            bufferedReader = new BufferedReader(new FileReader(string2));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        try {
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.length() <= 0 || (string4 = string4 + " " + string3).indexOf(";") == -1) continue;
                String string5 = string4.replace(';', ' ');
                vector.addElement(string5);
                string4 = "";
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector;
    }

    private boolean checkForTimeout(DBConnectionThread dBConnectionThread) {
        long l;
        long l2 = 10000L;
        long l3 = 0L;
        long l4 = 100L;
        do {
            this.suspendForPeriod(l4, dBConnectionThread);
            if (dBConnectionThread.done) {
                return true;
            }
            if ((l3 += l4) >= l2) {
                dBConnectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                dBConnectionThread.stop();
                return false;
            }
            l = l4 * 2L;
            if (l2 - l3 >= l) continue;
            l = l2 - l3;
        } while ((l4 = l) > 0L);
        dBConnectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        dBConnectionThread.stop();
        return false;
    }

    public void suspendForPeriod(long l, DBConnectionThread dBConnectionThread) {
        long l2 = this.dateInfo.egetUTCDate() + l;
        while (l > 0L) {
            if (l < EgConfigInfo.minSleep) {
                l = EgConfigInfo.minSleep;
            }
            try {
                DBConnectionThread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = this.dateInfo.egetUTCDate();
            l = l2 - l3;
        }
    }
}

