/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pdfbox.contentstream.PDFGraphicsStreamEngine;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDPattern;
import org.apache.pdfbox.pdmodel.graphics.form.PDTransparencyGroup;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import org.apache.pdfbox.pdmodel.graphics.state.PDSoftMask;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.Vector;

public final class ExtractImages {
    private static final String PASSWORD = "-password";
    private static final String PREFIX = "-prefix";
    private static final String DIRECTJPEG = "-directJPEG";
    private static final List<String> JPEG = Arrays.asList(COSName.DCT_DECODE.getName(), COSName.DCT_DECODE_ABBREVIATION.getName());
    private boolean directJPEG;
    private String prefix;
    private final Set<COSStream> seen = new HashSet<COSStream>();
    private int imageCounter = 1;

    private ExtractImages() {
    }

    public static void main(String[] args) throws IOException {
        System.setProperty("apple.awt.UIElement", "true");
        ExtractImages extractor = new ExtractImages();
        extractor.run(args);
    }

    private void run(String[] args) throws IOException {
        if (args.length < 1 || args.length > 4) {
            ExtractImages.usage();
        } else {
            String pdfFile = null;
            String password = "";
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals(PASSWORD)) {
                    if (++i >= args.length) {
                        ExtractImages.usage();
                    }
                    password = args[i];
                    continue;
                }
                if (args[i].equals(PREFIX)) {
                    if (++i >= args.length) {
                        ExtractImages.usage();
                    }
                    this.prefix = args[i];
                    continue;
                }
                if (args[i].equals(DIRECTJPEG)) {
                    this.directJPEG = true;
                    continue;
                }
                if (pdfFile != null) continue;
                pdfFile = args[i];
            }
            if (pdfFile == null) {
                ExtractImages.usage();
            } else {
                if (this.prefix == null && pdfFile.length() > 4) {
                    this.prefix = pdfFile.substring(0, pdfFile.length() - 4);
                }
                this.extract(pdfFile, password);
            }
        }
    }

    private static void usage() {
        String message = "Usage: java " + ExtractImages.class.getName() + " [options] <inputfile>\n\nOptions:\n  -password <password>   : Password to decrypt document\n  -prefix <image-prefix> : Image prefix (default to pdf name)\n  -directJPEG            : Forces the direct extraction of JPEG/JPX images                            regardless of colorspace or masking\n  <inputfile>            : The PDF document to use\n";
        System.err.println(message);
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extract(String pdfFile, String password) throws IOException {
        PDDocument document = null;
        try {
            document = PDDocument.load(new File(pdfFile), password);
            AccessPermission ap = document.getCurrentAccessPermission();
            if (!ap.canExtractContent()) {
                throw new IOException("You do not have permission to extract images");
            }
            for (PDPage page : document.getPages()) {
                ImageGraphicsEngine extractor = new ImageGraphicsEngine(page);
                extractor.run();
            }
        }
        finally {
            if (document != null) {
                document.close();
            }
        }
    }

    private boolean hasMasks(PDImage pdImage) throws IOException {
        if (pdImage instanceof PDImageXObject) {
            PDImageXObject ximg = (PDImageXObject)pdImage;
            return ximg.getMask() != null || ximg.getSoftMask() != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write2file(PDImage pdImage, String prefix, boolean directJPEG) throws IOException {
        String suffix = pdImage.getSuffix();
        if (suffix == null || "jb2".equals(suffix)) {
            suffix = "png";
        } else if ("jpx".equals(suffix)) {
            suffix = "jp2";
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(prefix + "." + suffix);
            BufferedImage image = pdImage.getImage();
            if (image != null) {
                if ("jpg".equals(suffix)) {
                    String colorSpaceName = pdImage.getColorSpace().getName();
                    if (directJPEG || !this.hasMasks(pdImage) && (PDDeviceGray.INSTANCE.getName().equals(colorSpaceName) || PDDeviceRGB.INSTANCE.getName().equals(colorSpaceName))) {
                        InputStream data = pdImage.createInputStream(JPEG);
                        IOUtils.copy(data, out);
                        IOUtils.closeQuietly(data);
                    } else {
                        ImageIOUtil.writeImage(image, suffix, out);
                    }
                } else if ("jp2".equals(suffix)) {
                    String colorSpaceName = pdImage.getColorSpace().getName();
                    if (directJPEG || !this.hasMasks(pdImage) && (PDDeviceGray.INSTANCE.getName().equals(colorSpaceName) || PDDeviceRGB.INSTANCE.getName().equals(colorSpaceName))) {
                        InputStream data = pdImage.createInputStream(Arrays.asList(COSName.JPX_DECODE.getName()));
                        IOUtils.copy(data, out);
                        IOUtils.closeQuietly(data);
                    } else {
                        ImageIOUtil.writeImage(image, "jpeg2000", out);
                    }
                } else {
                    ImageIOUtil.writeImage(image, suffix, out);
                }
            }
            out.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private class ImageGraphicsEngine
    extends PDFGraphicsStreamEngine {
        protected ImageGraphicsEngine(PDPage page) throws IOException {
            super(page);
        }

        public void run() throws IOException {
            PDPage page = this.getPage();
            this.processPage(page);
            PDResources res = page.getResources();
            for (COSName name : res.getExtGStateNames()) {
                PDTransparencyGroup group;
                PDSoftMask softMask = res.getExtGState(name).getSoftMask();
                if (softMask == null || (group = softMask.getGroup()) == null) continue;
                res.getExtGState(name).copyIntoGraphicsState(this.getGraphicsState());
                this.processSoftMask(group);
            }
        }

        @Override
        public void drawImage(PDImage pdImage) throws IOException {
            if (pdImage instanceof PDImageXObject) {
                if (pdImage.isStencil()) {
                    this.processColor(this.getGraphicsState().getNonStrokingColor());
                }
                PDImageXObject xobject = (PDImageXObject)pdImage;
                if (ExtractImages.this.seen.contains(xobject.getCOSObject())) {
                    return;
                }
                ExtractImages.this.seen.add(xobject.getCOSObject());
            }
            String name = ExtractImages.this.prefix + "-" + ExtractImages.this.imageCounter;
            ExtractImages.this.imageCounter++;
            System.out.println("Writing image: " + name);
            ExtractImages.this.write2file(pdImage, name, ExtractImages.this.directJPEG);
        }

        @Override
        public void appendRectangle(Point2D p0, Point2D p1, Point2D p2, Point2D p3) throws IOException {
        }

        @Override
        public void clip(int windingRule) throws IOException {
        }

        @Override
        public void moveTo(float x, float y) throws IOException {
        }

        @Override
        public void lineTo(float x, float y) throws IOException {
        }

        @Override
        public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) throws IOException {
        }

        @Override
        public Point2D getCurrentPoint() throws IOException {
            return new Point2D.Float(0.0f, 0.0f);
        }

        @Override
        public void closePath() throws IOException {
        }

        @Override
        public void endPath() throws IOException {
        }

        @Override
        protected void showGlyph(Matrix textRenderingMatrix, PDFont font, int code, String unicode, Vector displacement) throws IOException {
            RenderingMode renderingMode = this.getGraphicsState().getTextState().getRenderingMode();
            if (renderingMode.isFill()) {
                this.processColor(this.getGraphicsState().getNonStrokingColor());
            }
            if (renderingMode.isStroke()) {
                this.processColor(this.getGraphicsState().getStrokingColor());
            }
        }

        @Override
        public void strokePath() throws IOException {
            this.processColor(this.getGraphicsState().getStrokingColor());
        }

        @Override
        public void fillPath(int windingRule) throws IOException {
            this.processColor(this.getGraphicsState().getNonStrokingColor());
        }

        @Override
        public void fillAndStrokePath(int windingRule) throws IOException {
            this.processColor(this.getGraphicsState().getNonStrokingColor());
        }

        @Override
        public void shadingFill(COSName shadingName) throws IOException {
        }

        private void processColor(PDColor color) throws IOException {
            PDPattern pattern;
            PDAbstractPattern abstractPattern;
            if (color.getColorSpace() instanceof PDPattern && (abstractPattern = (pattern = (PDPattern)color.getColorSpace()).getPattern(color)) instanceof PDTilingPattern) {
                this.processTilingPattern((PDTilingPattern)abstractPattern, null, null);
            }
        }
    }
}

