/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.ws;

import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ws.Argument;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Calendar;
import javax.xml.bind.DatatypeConverter;
import org.doublecloud.ws.util.ReflectUtil;
import org.doublecloud.ws.util.TypeUtil;
import org.doublecloud.ws.util.XmlUtil;

public abstract class XmlGen {
    public abstract Object fromXML(String var1, InputStream var2) throws Exception;

    public static String toXML(String methodName, Argument[] paras, String vimNameSpace) {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body>");
        sb.append("<" + methodName + vimNameSpace);
        int i = 0;
        while (i < paras.length) {
            String key = paras[i].getName();
            String type = paras[i].getType();
            Object obj = paras[i].getValue();
            sb.append(XmlGen.toXML(key, type, obj));
            ++i;
        }
        sb.append("</" + methodName + ">");
        sb.append("</soapenv:Body></soapenv:Envelope>");
        return sb.toString();
    }

    private static String toXML(String tag, String type, Object obj) {
        if (obj == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (TypeUtil.isBasicType(type)) {
            XmlGen.toXML(sb, tag, obj.getClass(), obj);
        } else {
            Class<?> clazz = TypeUtil.getVimClass(type);
            XmlGen.toXML(sb, tag, clazz, obj);
        }
        return sb.toString();
    }

    private static void toXML(StringBuffer sb, String tagName, Class<?> type, Object obj) {
        Class<?> clazz = obj.getClass();
        if (clazz.isArray()) {
            if (obj.getClass() == TypeUtil.INT_ARRAY_CLASS) {
                int[] objs = (int[])obj;
                int i = 0;
                while (i < objs.length) {
                    sb.append("<" + tagName + ">");
                    sb.append(objs[i]);
                    sb.append("</" + tagName + ">");
                    ++i;
                }
            } else if (obj.getClass() == TypeUtil.BYTE_ARRAY_CLASS) {
                byte[] objs = (byte[])obj;
                int i = 0;
                while (i < objs.length) {
                    sb.append("<" + tagName + ">");
                    sb.append(objs[i]);
                    sb.append("</" + tagName + ">");
                    ++i;
                }
            } else if (obj.getClass() == TypeUtil.LONG_ARRAY_CLASS) {
                long[] objs = (long[])obj;
                int i = 0;
                while (i < objs.length) {
                    sb.append("<" + tagName + ">");
                    sb.append(objs[i]);
                    sb.append("</" + tagName + ">");
                    ++i;
                }
            } else {
                Object[] objs = (Object[])obj;
                int i = 0;
                while (i < objs.length) {
                    XmlGen.toXML(sb, tagName, type.getComponentType(), objs[i]);
                    ++i;
                }
            }
        } else if (clazz == ManagedObjectReference.class) {
            ManagedObjectReference mor = (ManagedObjectReference)obj;
            if (clazz == type) {
                sb.append("<" + tagName + " type=\"" + mor.type + "\">");
            } else {
                sb.append("<" + tagName + " xsi:type=\"ManagedObjectReference\" type=\"" + mor.type + "\">");
            }
            sb.append(mor.val);
            sb.append("</" + tagName + ">");
        } else if (clazz.getCanonicalName().startsWith("java.lang")) {
            if (clazz != type) {
                sb.append("<" + tagName + " xsi:type=\"" + TypeUtil.getXSIType(obj) + "\">");
            } else {
                sb.append("<" + tagName + ">");
            }
            if (clazz == String.class) {
                String temp = (String)obj;
                obj = XmlUtil.escapeForXML(temp);
            }
            sb.append(obj);
            sb.append("</" + tagName + ">");
        } else if (clazz.isEnum()) {
            sb.append("<" + tagName + ">" + obj + "</" + tagName + ">");
        } else if (obj instanceof Calendar) {
            sb.append("<" + tagName + " xsi:type=\"xsd:dateTime\">" + DatatypeConverter.printDateTime((Calendar)((Calendar)obj)) + "</" + tagName + ">");
        } else {
            if (clazz == type) {
                sb.append("<" + tagName + ">");
            } else {
                String nameSpaceType = clazz.getSimpleName();
                sb.append("<" + tagName + " xsi:type=\"" + nameSpaceType + "\">");
            }
            Field[] fields = ReflectUtil.getAllFields(clazz);
            int i = 0;
            while (i < fields.length) {
                Field f = fields[i];
                String fName = f.getName();
                Object value = null;
                try {
                    value = f.get(obj);
                }
                catch (IllegalAccessException iae) {
                    iae.printStackTrace();
                }
                if (value != null) {
                    Class<?> fType = f.getType();
                    XmlGen.toXML(sb, fName, fType, value);
                }
                ++i;
            }
            sb.append("</" + tagName + ">");
        }
    }

    public static ManagedObjectReference createMOR(String type, String value) {
        ManagedObjectReference mor = new ManagedObjectReference();
        mor.val = value;
        mor.type = type;
        return mor;
    }
}

