/*
 * Decompiled with CFR 0.152.
 */
package Acme.JPM.Filters;

import Acme.JPM.Filters.ImageFilterPlus;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

public class CompositeFilter
extends ImageFilterPlus {
    private ImageFilterPlus filterOne;
    private ImageFilterPlus filterTwo;
    private ImageFilter instanceOne;
    private ImageFilter instanceTwo;

    public CompositeFilter(ImageProducer producer, ImageFilterPlus filterOne, ImageFilterPlus filterTwo) {
        super(producer);
        this.filterOne = filterOne;
        this.filterTwo = filterTwo;
        filterOne.setSource(producer);
        FilteredImageSource producerOne = new FilteredImageSource(producer, filterOne);
        filterTwo.setSource(producerOne);
    }

    public ImageFilter getFilterInstance(ImageConsumer consumer) {
        CompositeFilter instance = (CompositeFilter)this.clone();
        instance.instanceTwo = this.filterTwo.getFilterInstance(consumer);
        instance.instanceOne = this.filterOne.getFilterInstance(this.instanceTwo);
        return instance;
    }

    public void setColorModel(ColorModel model) {
        this.instanceOne.setColorModel(model);
    }

    public void setDimensions(int width, int height) {
        this.instanceOne.setDimensions(width, height);
    }

    public void setHints(int hintflags) {
        this.instanceOne.setHints(hintflags);
    }

    public void setProperties(Hashtable props) {
        this.instanceOne.setProperties(props);
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        this.instanceOne.setPixels(x, y, w, h, model, pixels, off, scansize);
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        this.instanceOne.setPixels(x, y, w, h, model, pixels, off, scansize);
    }

    public void imageComplete(int status) {
        this.instanceOne.imageComplete(status);
    }
}

