/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.Grid;
import com.objectplanet.chart.Legend;
import com.objectplanet.chart.LegendRenderer;
import com.objectplanet.chart.LineChartRenderer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class LineChart
extends Chart {
    public static final int SAMPLE_HIGHLIGHT_CIRCLE = 0;
    public static final int SAMPLE_HIGHLIGHT_CIRCLE_OPAQUE = 1;
    public static final int SAMPLE_HIGHLIGHT_CIRCLE_FILLED = 2;
    public static final int SAMPLE_HIGHLIGHT_SQUARE = 3;
    public static final int SAMPLE_HIGHLIGHT_SQUARE_OPAQUE = 4;
    public static final int SAMPLE_HIGHLIGHT_SQUARE_FILLED = 5;
    public static final int SAMPLE_HIGHLIGHT_DIAMOND = 6;
    public static final int SAMPLE_HIGHLIGHT_DIAMOND_OPAQUE = 7;
    public static final int SAMPLE_HIGHLIGHT_DIAMOND_FILLED = 8;
    public static final int BEHIND_LINE_LAYOUT = 0;
    public static final int SAME_LEVEL_LINE_LAYOUT = 1;
    public static final int LINE_STYLE_LINE = 0;
    public static final int LINE_STYLE_TUBE = 1;
    private boolean a2;
    private int[] aS;
    private double[] a6;
    private boolean[] a5;
    private float[][] a8;
    private int[] aX;
    private boolean aR;
    private int a4;
    private boolean[][] a1;
    private boolean[] aW;
    private int[] a7;
    private int[] ba;
    private boolean[] a3;
    private boolean[] aY;
    private String aU;
    private String[] aZ;
    private String[][] a9;
    private boolean aQ;
    int[][] aV;
    Color[] aT;
    Color[] a0;

    public LineChart() {
        this(1, 5, 100.0);
    }

    public LineChart(int n, int n2, double d) {
        this(n, n2, d, 0.0);
    }

    public LineChart(int n, int n2, double d, double d2) {
        super(n2);
        this.grid = new Grid(this);
        this.legend = new Legend();
        this.legendRenderer = new LegendRenderer(this);
        this.renderer = new LineChartRenderer(this);
        this.chartType = "line";
        this.setAutomaticRepaintOn(false);
        this.a1 = new boolean[n][n2];
        this.aW = new boolean[n];
        this.a7 = new int[n];
        this.ba = new int[n];
        this.ba = new int[n];
        this.a3 = new boolean[n];
        this.a5 = new boolean[n];
        this.aS = new int[n];
        this.aX = new int[n];
        this.a6 = new double[n];
        this.a8 = new float[n][];
        for (int i = 0; i < this.ba.length; ++i) {
            this.ba[i] = 6;
            this.a3[i] = true;
            this.a5[i] = true;
            this.aS[i] = 2;
            this.a6[i] = 1.0;
        }
        this.a9 = new String[n][n2];
        this.aZ = new String[n];
        this.aY = new boolean[n];
        this.aV = null;
        this.aT = null;
        this.setSeriesCount(n);
        this.setRange(0, d);
        this.setLowerRange(0, d2);
        this.setSampleColors(null);
        this.S = 1;
        this.Z = 2;
        this.R = 3;
        this.a2 = false;
        this.u = true;
        this.aQ = true;
        this.setAutomaticRepaintOn(true);
    }

    public void reset() {
        super.reset();
        this.S = 1;
        this.Z = 2;
        this.R = 3;
        this.a2 = false;
        this.u = true;
        this.aV = null;
        this.aT = null;
        this.a0 = null;
    }

    public String[] getLegendLabels() {
        String[] stringArray = this.legend.getLegendLabels();
        if (stringArray != null) {
            return stringArray;
        }
        return this.getSeriesLabels();
    }

    protected double getHighestValue(int n) {
        if (this.aR) {
            return Math.max(super.getHighestValue(n), this.getMaxValue(-2));
        }
        return super.getHighestValue(n);
    }

    public double getMaxValue(int n) {
        if (n >= -1 || !this.aR) {
            return super.getMaxValue(n);
        }
        double d = 0.0;
        int n2 = this.getSampleCount();
        int n3 = this.getSeriesCount();
        for (int i = 0; i < n2; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < n3; ++j) {
                ChartSample chartSample = this.getSample(j, i);
                if (chartSample == null || chartSample.value == null || chartSample.value.isNaN() || !(chartSample.value > 0.0)) continue;
                d2 += chartSample.value.doubleValue();
            }
            d = Math.max(d, d2);
        }
        return d;
    }

    public void setSampleColors(Color[] colorArray) {
        super.setSampleColors(colorArray);
        if (colorArray == null) {
            this.setSampleColor(2, new Color(132, 255, 198));
        }
        this.autoRepaint();
    }

    public int getValuePosition(double d) {
        return this.grid.a(0, d, this.getGraphBounds());
    }

    public Point getSamplePoint(int n, int n2) {
        try {
            int n3 = ((LineChartRenderer)this.renderer).samplePoints[n][n2][0];
            int n4 = ((LineChartRenderer)this.renderer).samplePoints[n][n2][1];
            return new Point(n3 - (this.display3dOn ? this.renderer.depth3dPoint.x : 0), n4);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setAutoLabelSpacingOn(boolean bl) {
        if (this.a2 != bl) {
            this.a2 = bl;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public boolean isAutoLabelSpacingOn() {
        return this.a2;
    }

    public void setStackedOn(boolean bl) {
        if (this.aR != bl) {
            this.aR = bl;
            this.needRender = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public boolean isStackedOn() {
        return this.aR;
    }

    public void setLineWidth(int n) {
        this.setLineWidth(-1, n);
    }

    public void setLineWidth(int n, int n2) {
        if (n >= 0 && n < this.aS.length) {
            this.aS[n] = n2;
        } else if (n < 0) {
            for (int i = 0; i < this.aS.length; ++i) {
                this.aS[i] = n2;
            }
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public int getLineWidth() {
        return this.getLineWidth(0);
    }

    public int getLineWidth(int n) {
        if (n >= 0 && n < this.aS.length) {
            return this.aS[n];
        }
        return this.aS[0];
    }

    public void setLineStyle(int n, int n2) {
        if (n >= 0 && n < this.aX.length) {
            this.aX[n] = n2;
        } else if (n < 0) {
            for (int i = 0; i < this.aX.length; ++i) {
                this.aX[i] = n2;
            }
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public int getLineStyle(int n) {
        if (n >= 0 && n < this.aX.length) {
            return this.aX[n];
        }
        return this.aX[0];
    }

    public void setLine3DDepth(int n, double d) {
        if (n >= 0 && n < this.a6.length) {
            this.a6[n] = d;
        } else if (n < 0) {
            for (int i = 0; i < this.a6.length; ++i) {
                this.a6[i] = d;
            }
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public double getLine3DDepth(int n) {
        if (n >= 0 && n < this.aS.length) {
            return this.a6[n];
        }
        return this.a6[0];
    }

    public void setOutlineOn(int n, boolean bl) {
        if (n >= 0) {
            if (this.a5[n] != bl) {
                this.a5[n] = bl;
                this.needRender = true;
                this.autoRepaint();
            }
        } else if (n < 0) {
            for (int i = 0; i < this.a5.length; ++i) {
                this.a5[i] = bl;
            }
        }
    }

    public boolean isOutlineOn(int n) {
        return this.a5[n];
    }

    public void setLineStroke(int n, float[] fArray) {
        int n2 = fArray.length % 2 == 0 ? fArray.length : fArray.length + 1;
        this.a8[n] = new float[n2];
        if (n >= 0 && n < this.a8.length) {
            for (int i = 0; i < fArray.length; ++i) {
                this.a8[n][i] = Math.abs(fArray[i]);
            }
            if (this.a8[n][n2 - 1] == 0.0f) {
                this.a8[n][n2 - 1] = this.a8[n][n2 - 2];
            }
        } else if (n < 0) {
            for (int i = 0; i < this.a8.length; ++i) {
                for (int j = 0; j < fArray.length; ++j) {
                    this.a8[i][j] = Math.abs(fArray[j]);
                }
                if (this.a8[i][n2 - 1] != 0.0f) continue;
                this.a8[i][n2 - 1] = this.a8[i][n2 - 2];
            }
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public float[] getLineStroke(int n) {
        if (this.a8 == null || this.a8.length == 0) {
            return new float[]{0.0f};
        }
        if (n >= 0 && n < this.a8.length) {
            return this.a8[n];
        }
        return this.a8[0];
    }

    public void setLine3DLayout(int n) {
        this.a4 = n;
        this.needRender = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public int getLine3DLayout() {
        return this.a4;
    }

    public void setSampleHighlightOn(boolean bl) {
        for (int i = 0; i < this.a1.length; ++i) {
            this.aW[i] = bl;
            for (int j = 0; j < this.a1[i].length; ++j) {
                this.a1[i][j] = bl;
            }
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public void setSampleHighlightOn(int n, boolean bl) {
        try {
            this.aW[n] = bl;
            for (int i = 0; i < this.a1[n].length; ++i) {
                this.a1[n][i] = bl;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public void setSampleHighlightOn(int n, int n2, boolean bl) {
        try {
            this.a1[n][n2] = bl;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series or index: " + n + ", " + n2);
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public boolean isSampleHighlightOn(int n) {
        try {
            return this.aW[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid serie: , " + n);
        }
    }

    public boolean isSampleHighlightOn(int n, int n2) {
        if (this.a1 != null && n < this.a1.length && n2 < this.a1[n].length) {
            return this.a1[n][n2];
        }
        return false;
    }

    public void setSampleHighlightStyle(int n, int n2) {
        for (int i = 0; i < this.a7.length; ++i) {
            this.setSampleHighlightStyle(i, n, n2);
        }
    }

    public void setSampleHighlightStyle(int n, int n2, int n3) {
        this.ba[n] = Math.max(0, n3);
        this.a7[n] = n2;
        this.needRender = true;
        this.autoRepaint();
    }

    public int getSampleHighlightStyle(int n) {
        try {
            return this.a7[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
    }

    public int getSampleHighlightSize(int n) {
        try {
            return this.ba[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
    }

    public void setSampleHighlightImage(int n, int n2, String string) {
        if (n >= -1 && n < 1000 && n2 >= -1 && n <= 1000) {
            if (n == -1 && n2 == -1) {
                this.aU = string;
            } else if (n2 == -1) {
                int n3 = Math.max(this.a9.length, n + 1);
                if (n >= this.aZ.length) {
                    String[] stringArray = new String[n3];
                    for (int i = 0; i < this.aZ.length; ++i) {
                        stringArray[i] = this.aZ[i];
                    }
                    this.aZ = stringArray;
                }
                this.aZ[n] = string;
            } else {
                int n4 = Math.max(this.a9.length, n + 1);
                int n5 = Math.max(this.a9[0].length, n2 + 1);
                if (n >= this.a9.length || n2 >= this.a9[0].length) {
                    String[][] stringArray = new String[n4][n5];
                    for (int i = 0; i < this.a9.length; ++i) {
                        for (int j = 0; j < this.a9[0].length; ++j) {
                            stringArray[i][j] = this.a9[i][j];
                        }
                    }
                    this.a9 = stringArray;
                }
                this.a9[n][n2] = string;
            }
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public String getSampleHighlightImage(int n, int n2) {
        if (n == -1 && n2 == -1) {
            return this.aU;
        }
        if (n >= 0 && n < this.aZ.length && n2 == -1) {
            return this.aZ[n];
        }
        if (n >= 0 && n < this.a9.length && n2 >= 0 && n2 < this.a9[0].length) {
            return this.a9[n][n2];
        }
        return null;
    }

    public String getLegendImage(int n) {
        String string = super.getLegendImage(n);
        if (string == null) {
            string = this.getSampleHighlightImage(n, -1);
        }
        return string;
    }

    public void setSeriesLineOn(boolean bl) {
        for (int i = 0; i < this.a3.length; ++i) {
            this.a3[i] = bl;
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public void setSeriesLineOn(int n, boolean bl) {
        if (this.a3[n] != bl) {
            this.a3[n] = bl;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public boolean isSeriesLineOn(int n) {
        if (this.a3 != null && n < this.a3.length) {
            return this.a3[n];
        }
        return true;
    }

    public void setConnectedLinesOn(int n, boolean bl) {
        if (n >= 0 && n < this.aY.length) {
            this.aY[n] = bl;
        } else if (n == -1) {
            for (int i = 0; i < this.aY.length; ++i) {
                this.aY[i] = bl;
            }
        }
        this.needRender = true;
        this.autoRepaint();
    }

    public boolean isConnectedLinesOn(int n) {
        if (n >= 0 && n < this.aY.length) {
            return this.aY[n];
        }
        if (n == -1) {
            boolean bl = false;
            for (int i = 0; i < this.aY.length; ++i) {
                if (!this.aY[i]) continue;
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public void setArea(int n, int n2, int n3) {
        if (n2 < 0 || n3 < 0 || n2 >= this.getSeriesCount() || n3 >= this.getSeriesCount() || n2 == n3) {
            return;
        }
        if (this.aV == null) {
            this.aV = new int[n + 1][2];
            for (int i = 0; i < this.aV.length; ++i) {
                this.aV[i][0] = -1;
                this.aV[i][1] = -1;
            }
        }
        if (n >= this.aV.length) {
            int[][] nArray = new int[n + 1][2];
            System.arraycopy(this.aV, 0, nArray, 0, this.aV.length);
            for (int i = this.aV.length; i < nArray.length - 1; ++i) {
                nArray[i][0] = -1;
                nArray[i][1] = -1;
            }
            this.aV = nArray;
        }
        this.aV[n][0] = n2;
        this.aV[n][1] = n3;
        this.needRender = true;
        this.autoRepaint();
    }

    public int[] getArea(int n) {
        if (this.aV == null || n >= this.aV.length) {
            return new int[]{-1, -1};
        }
        return this.aV[n];
    }

    public void setAreaColor(int n, Color color) {
        if (this.aT == null) {
            this.aT = new Color[n + 1];
        }
        if (n >= this.aT.length) {
            Color[] colorArray = new Color[n + 1];
            System.arraycopy(this.aT, 0, colorArray, 0, this.aT.length);
            this.aT = colorArray;
        }
        this.aT[n] = color;
        this.needRender = true;
        this.autoRepaint();
    }

    public Color getAreaColor(int n) {
        if (this.aT == null || n >= this.aT.length) {
            return null;
        }
        return this.aT[n];
    }

    public void setAreaColor2(int n, Color color) {
        if (this.a0 == null) {
            this.a0 = new Color[n + 1];
        }
        if (n >= this.a0.length) {
            Color[] colorArray = new Color[n + 1];
            System.arraycopy(this.a0, 0, colorArray, 0, this.a0.length);
            this.a0 = colorArray;
        }
        this.a0[n] = color;
        this.needRender = true;
        this.autoRepaint();
    }

    public Color getAreaColor2(int n) {
        if (this.a0 == null || n >= this.a0.length) {
            return null;
        }
        return this.a0[n];
    }

    public void setRightToLeftScrollingOn(boolean bl) {
        this.grid.setRightToLeftScrollingOn(bl);
        this.setVisibleSamples(this.visibleSamples[0], this.visibleSamples[1]);
        this.needChartCalculation = true;
        this.needRender = true;
        this.autoRepaint();
    }

    public boolean isRightToLeftScrollingOn() {
        return this.grid.isRightToLeftScrollingOn();
    }

    public boolean isMissingValuesInterpolated() {
        return this.aQ;
    }

    public void setMissingValuesInterpolated(boolean bl) {
        this.aQ = bl;
    }

    protected void checkDataIntegrity() {
        int n;
        super.checkDataIntegrity();
        this.renderer.checkDataIntegrity();
        int n2 = this.getSeriesCount();
        int n3 = this.getSampleCount();
        int n4 = this.a1 != null ? this.a1.length : 1;
        int n5 = n = n4 > 0 && this.a1 != null ? this.a1[0].length : 0;
        if (n2 != n4 || n3 != n) {
            boolean[][] blArray = new boolean[n2][n3];
            boolean[] blArray2 = new boolean[n2];
            for (int i = 0; i < n2; ++i) {
                if (i >= n4 || this.aW == null) continue;
                try {
                    blArray2[i] = this.aW[i];
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (int j = 0; j < n3; ++j) {
                    try {
                        if (j < n) {
                            blArray[i][j] = this.a1[i][j];
                            continue;
                        }
                        blArray[i][j] = this.aW[i];
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.a1 = blArray;
            this.aW = blArray2;
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            boolean[] blArray3 = new boolean[n2];
            boolean[] blArray4 = new boolean[n2];
            int[] nArray3 = new int[n2];
            int[] nArray4 = new int[n2];
            double[] dArray = new double[n2];
            float[][] fArrayArray = new float[n2][];
            boolean[] blArray5 = new boolean[n2];
            for (int i = 0; i < n2; ++i) {
                if (i < n4 && this.a7 != null && this.ba != null && this.a3 != null && this.aY != null && this.aS != null && this.a8 != null && this.a5 != null && this.a6 != null && this.aX != null) {
                    nArray[i] = this.a7[i];
                    nArray2[i] = this.ba[i];
                    blArray3[i] = this.a3[i];
                    blArray4[i] = this.aY[i];
                    nArray3[i] = this.aS[i];
                    nArray4[i] = this.aX[i];
                    dArray[i] = this.a6[i];
                    fArrayArray[i] = this.a8[i];
                    blArray5[i] = this.a5[i];
                    continue;
                }
                nArray2[i] = 6;
                nArray3[i] = 2;
                dArray[i] = 1.0;
                blArray3[i] = true;
                blArray5[i] = true;
            }
            this.a7 = nArray;
            this.ba = nArray2;
            this.a3 = blArray3;
            this.aY = blArray4;
            this.aS = nArray3;
            this.aX = nArray4;
            this.a6 = dArray;
            this.a8 = fArrayArray;
            this.a5 = blArray5;
            this.needChartCalculation = true;
        }
    }

    public ChartSample checkSelection(Point point) {
        return this.renderer.checkSelection(point);
    }

    protected void paintLine(Graphics graphics, int n, Rectangle rectangle, Rectangle rectangle2, Color color, boolean bl) {
        ((LineChartRenderer)this.renderer).paintLine(graphics, n, rectangle, rectangle2, color, bl);
    }

    protected void paint3DLine(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, boolean bl, boolean bl2, boolean bl3) {
        ((LineChartRenderer)this.renderer).paint3DLine(graphics, n, n2, n3, n4, n5, color, bl, bl2, bl3);
    }

    protected void paintSampleHighlight(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
        ((LineChartRenderer)this.renderer).paintSampleHighlight(graphics, n, n2, n3, n4, color);
    }
}

