/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.ovm.mgr.ws.client;

import com.oracle.ovm.mgr.ws.client.OvmWsClient;
import com.oracle.ovm.mgr.ws.client.OvmWsRestClient;
import com.oracle.ovm.mgr.ws.client.OvmWsSoapClient;

public final class OvmWsClientFactory {
    public static OvmWsClient getOvmWsClient(String wsImplementationType) {
        WebServiceImpl impl = null;
        try {
            impl = WebServiceImpl.valueOf(wsImplementationType);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Unknown Web Service Implementation Type: " + wsImplementationType, ex);
        }
        return OvmWsClientFactory.getOvmWsClient(impl);
    }

    public static OvmWsClient getOvmWsClient(WebServiceImpl implementation) {
        switch (implementation) {
            case SOAP: {
                return new OvmWsSoapClient();
            }
            case REST: {
                return new OvmWsRestClient();
            }
        }
        throw new IllegalArgumentException("Unknown Web Service Implementation Type: " + (Object)((Object)implementation));
    }

    public static <S> S getWebServiceClient(Class<S> wsApiClass, WebServiceImpl implementation) {
        if (OvmWsClient.class.isAssignableFrom(wsApiClass)) {
            return (S)OvmWsClientFactory.getOvmWsClient(implementation);
        }
        String implName = wsApiClass.getCanonicalName();
        if (implName.endsWith("Client")) {
            implName = implName.substring(0, implName.length() - 6);
        }
        switch (implementation) {
            case REST: {
                implName = implName + "RestClient";
                break;
            }
            case SOAP: {
                implName = implName + "SoapClient";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Web Service Implementation Type: " + (Object)((Object)implementation));
            }
        }
        try {
            Class<?> implClass = Class.forName(implName);
            if (!wsApiClass.isAssignableFrom(implClass)) {
                throw new IllegalArgumentException("Web Service implementation class " + implName + " does not implement the indicated interface " + wsApiClass.getCanonicalName());
            }
            return (S)implClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("No such Web Service implementation class: " + implName);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Cannot instantiate Web Service implementation class " + implName, e);
        }
    }

    private OvmWsClientFactory() {
    }

    public static enum WebServiceImpl {
        SOAP,
        REST;

    }
}

