/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.ovm.mgr.ws.sample;

import com.oracle.ovm.mgr.ws.client.OvmWsClient;
import com.oracle.ovm.mgr.ws.client.OvmWsClientFactory;
import com.oracle.ovm.mgr.ws.model.AffinityGroup;
import com.oracle.ovm.mgr.ws.model.Assembly;
import com.oracle.ovm.mgr.ws.model.AssemblyVirtualDisk;
import com.oracle.ovm.mgr.ws.model.AssemblyVm;
import com.oracle.ovm.mgr.ws.model.BaseObject;
import com.oracle.ovm.mgr.ws.model.Cluster;
import com.oracle.ovm.mgr.ws.model.ClusterHeartbeatDevice;
import com.oracle.ovm.mgr.ws.model.ClusterStorageFs;
import com.oracle.ovm.mgr.ws.model.ControlDomain;
import com.oracle.ovm.mgr.ws.model.Cpu;
import com.oracle.ovm.mgr.ws.model.EthernetPort;
import com.oracle.ovm.mgr.ws.model.FileServer;
import com.oracle.ovm.mgr.ws.model.FileServerPlugin;
import com.oracle.ovm.mgr.ws.model.FileSystem;
import com.oracle.ovm.mgr.ws.model.FileSystemMount;
import com.oracle.ovm.mgr.ws.model.Id;
import com.oracle.ovm.mgr.ws.model.Job;
import com.oracle.ovm.mgr.ws.model.JobError;
import com.oracle.ovm.mgr.ws.model.Network;
import com.oracle.ovm.mgr.ws.model.Repository;
import com.oracle.ovm.mgr.ws.model.ResourceGroup;
import com.oracle.ovm.mgr.ws.model.Server;
import com.oracle.ovm.mgr.ws.model.ServerPool;
import com.oracle.ovm.mgr.ws.model.ServerPoolNetworkPolicy;
import com.oracle.ovm.mgr.ws.model.ServerPoolPolicy;
import com.oracle.ovm.mgr.ws.model.StorageElement;
import com.oracle.ovm.mgr.ws.model.VirtualDisk;
import com.oracle.ovm.mgr.ws.model.VirtualNic;
import com.oracle.ovm.mgr.ws.model.VlanInterface;
import com.oracle.ovm.mgr.ws.model.Vm;
import com.oracle.ovm.mgr.ws.model.VmDiskMapping;
import com.oracle.ovm.mgr.ws.model.WsException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class WsDevClient {
    private OvmWsClient api;
    private Id<Vm> testVmId;
    private Id<ServerPool> testPoolId;
    private Id<AffinityGroup> testAffinityGroupId;
    private Id<Cluster> testClusterId;
    private Id<ClusterHeartbeatDevice> testHeartbeatDeviceId;
    private Id<Network> testNetworkId;
    private Id<Network> testServerLocalNetworkId;
    private Id<Server> testServerId;
    private Id<Assembly> testAssemblyId;
    private Id<Repository> testRepoId;
    private Id<ResourceGroup> testResourceGroupId;
    private Id<Vm> importedAssemblyVmId;
    private Job repoPresentJob;

    public static void main(String[] args) {
        WsDevClient wsClient = new WsDevClient();
        wsClient.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(new KeyManager[0], new TrustManager[]{new InsecureTrustManager()}, new SecureRandom());
            SSLContext.setDefault(ctx);
            HostnameVerifier hv = new HostnameVerifier(){

                @Override
                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
            ResourceBundle rootProps = ResourceBundle.getBundle("com.oracle.ovm.mgr.ws.sample.WsDevClient");
            ResourceBundle userProps = null;
            try {
                userProps = ResourceBundle.getBundle("com.oracle.ovm.mgr.ws.sample.WsDevClient_" + System.getProperty("user.name"));
            }
            catch (MissingResourceException ex) {
                System.out.println(ex);
                System.out.println("Warning: No user-overridden properties found.  Using default values.  This is unlikely to work and is not recommended!");
            }
            String wsimpl = this.getProperty("wsimpl", rootProps, userProps);
            String dialect = this.getProperty("dialect", rootProps, userProps);
            String hostname = this.getProperty("hostname", rootProps, userProps);
            String port = this.getProperty("port", rootProps, userProps);
            String username = this.getProperty("username", rootProps, userProps);
            String password = this.getProperty("password", rootProps, userProps);
            String testRepo = this.getProperty("testRepo", rootProps, userProps);
            String testResourceGroupName = this.getProperty("testResourceGroup", rootProps, userProps);
            String testVmName = this.getProperty("testVmName", rootProps, userProps);
            String debugStr = this.getProperty("debugHttpTraffic", rootProps, userProps);
            String testServerName = this.getProperty("testServerName", rootProps, userProps);
            String testServerPoolName = this.getProperty("testServerPoolName", rootProps, userProps);
            String testServerPoolIp = this.getProperty("testServerPoolVirtualIp", rootProps, userProps);
            String testClusterName = this.getProperty("testClusterName", rootProps, userProps);
            String testAffinityGroupName = this.getProperty("testAffinityGroupName", rootProps, userProps);
            String clusterHeartbeatDeviceName = this.getProperty("clusterHeartbeatDeviceName", rootProps, userProps);
            ClusterHeartbeatDevice.ClusterHeartbeatStorageType clusterHeartbeatStorageDeviceType = ClusterHeartbeatDevice.ClusterHeartbeatStorageType.valueOf(this.getProperty("clusterHeartbeatStorageDeviceType", rootProps, userProps));
            String clusterHeartbeatStorageElementId = this.getProperty("clusterHeartbeatStorageElementId", rootProps, userProps);
            String clusterHeartbeatNetworkFileSystemId = this.getProperty("clusterHeartbeatNetworkFileSystemId", rootProps, userProps);
            String testNetworkName = this.getProperty("testNetworkName", rootProps, userProps);
            String assemblyUrl = this.getProperty("assemblyUrl", rootProps, userProps);
            boolean debug = debugStr.equalsIgnoreCase("true");
            this.api = OvmWsClientFactory.getOvmWsClient(wsimpl);
            this.api.setDebug(debug);
            this.api.setDialect(dialect);
            this.api.initialize(hostname, port, true);
            this.api.login(username, password, Locale.getDefault());
            System.out.println("Starting Ovm Api Test Using " + wsimpl + " Implementation\n");
            ResourceGroup testResourceGroup = new ResourceGroup();
            if (testResourceGroupName == null || testResourceGroupName.isEmpty()) {
                testResourceGroupName = "TestResourceGroup";
            }
            testResourceGroup.setName(testResourceGroupName);
            Job resourceGroupCreateJob = this.api.resourceGroupCreate(testResourceGroup);
            this.testResourceGroupId = this.waitForJobComplete(this.api, resourceGroupCreateJob, ResourceGroup.class);
            this.printId("ResourceGroup", this.testResourceGroupId);
            List<Id<Network>> networkIds = this.api.networkGetIds();
            for (Id<Network> networkId : networkIds) {
                this.printId("Network", networkId);
            }
            List<Network> networks = this.api.networkGetAll();
            for (Network network : networks) {
                this.printNetwork(network);
            }
            List<Id<Vm>> vmIds = this.api.vmGetIds();
            for (Id<Vm> id : vmIds) {
                this.printId("VM", id);
            }
            List<Vm> vms = this.api.vmGetAll();
            for (Vm vm : vms) {
                this.printVm(vm);
            }
            List<String> osTypes = this.api.vmGetSupportedOsTypes();
            System.out.println("Supported OS Types:");
            for (String os : osTypes) {
                System.out.println("\t" + os);
            }
            System.out.println("");
            List<Id<Server>> servIds = this.api.serverGetIds();
            for (Id<Server> serverId : servIds) {
                this.printId("Server", serverId);
            }
            List<Server> servers = this.api.serverGetAll();
            Server testServer = null;
            for (Server server : servers) {
                if (testServerName.equals(server.getName())) {
                    testServer = server;
                }
                this.printServer(server);
            }
            List<ControlDomain> controlDomains = this.api.controlDomainGetAll();
            for (ControlDomain controlDomain : controlDomains) {
                this.printControlDomain(controlDomain);
            }
            List<Cpu> cpus = this.api.cpuGetAll();
            for (Cpu cpu : cpus) {
                this.printCpu(cpu);
            }
            List<Id<EthernetPort>> ethernetPortIds = this.api.ethernetPortGetIds();
            for (Id<EthernetPort> ethernetPortId : ethernetPortIds) {
                this.printId("EthernetPort", ethernetPortId);
            }
            List<EthernetPort> ethernetPorts = this.api.ethernetPortGetAll();
            for (EthernetPort ethernetPort : ethernetPorts) {
                this.printEthernetPort(ethernetPort);
            }
            List<Id<VirtualDisk>> virtualDiskIds = this.api.virtualDiskGetIds();
            for (Id<VirtualDisk> virtualDiskId : virtualDiskIds) {
                this.printId("VirtualDisk", virtualDiskId);
            }
            List<VirtualDisk> virtualDisks = this.api.virtualDiskGetAll();
            for (VirtualDisk virtualDisk : virtualDisks) {
                this.printVirtualDisk(virtualDisk);
            }
            List<Id<VirtualNic>> virtualNicIds = this.api.virtualNicGetIds();
            for (Id<VirtualNic> virtualNicId : virtualNicIds) {
                this.printId("VirtualNic", virtualNicId);
            }
            VirtualNic availableVirtualNic = null;
            List<VirtualNic> virtualNics = this.api.virtualNicGetAll();
            for (VirtualNic virtualNic : virtualNics) {
                this.printVirtualNic(virtualNic);
                if (availableVirtualNic != null || virtualNic.getVmId() != null) continue;
                availableVirtualNic = virtualNic;
            }
            List<Id<Repository>> repoIds = this.api.repositoryGetIds();
            for (Id<Repository> repoId : repoIds) {
                this.printId("Repository", repoId);
            }
            List<Repository> repos = this.api.repositoryGetAll();
            for (Repository repo : repos) {
                this.printRepository(repo);
                if (!repo.getId().getValue().equals(testRepo)) continue;
                this.testRepoId = repo.getId();
            }
            List<Id<ResourceGroup>> resourceGroupIds = this.api.resourceGroupGetIds();
            for (Id<ResourceGroup> resourceGroupId : resourceGroupIds) {
                this.printId("ResourceGroup", resourceGroupId);
                if (!resourceGroupId.getName().equals(testResourceGroupName)) continue;
                this.testResourceGroupId = resourceGroupId;
            }
            List<Id<ServerPool>> serverPoolIds = this.api.serverPoolGetIds();
            for (Id<ServerPool> serverPoolId : serverPoolIds) {
                this.printId("ServerPool", serverPoolId);
            }
            List<ServerPool> serverPools = this.api.serverPoolGetAll();
            for (ServerPool serverPool : serverPools) {
                this.printServerPool(serverPool);
            }
            List<Id<Cluster>> clusterIds = this.api.clusterGetIds();
            for (Id<Cluster> clusterId : clusterIds) {
                this.printId("Cluster", clusterId);
            }
            List<Cluster> clusters = this.api.clusterGetAll();
            for (Cluster cluster : clusters) {
                this.printCluster(cluster);
            }
            List<Id<ClusterHeartbeatDevice>> deviceIds = this.api.clusterHeartbeatDeviceGetIds();
            for (Id<ClusterHeartbeatDevice> deviceId : deviceIds) {
                this.printId("Cluster Heartbeat Device", deviceId);
            }
            List<ClusterHeartbeatDevice> devices = this.api.clusterHeartbeatDeviceGetAll();
            for (ClusterHeartbeatDevice device : devices) {
                this.printClusterHeartbeatDevice(device);
            }
            List<Id<ClusterStorageFs>> clusterStorageFsIds = this.api.clusterStorageFsGetIds();
            for (Id<ClusterStorageFs> clusterStorageFsId : clusterStorageFsIds) {
                this.printId("Cluster Storage FS", clusterStorageFsId);
            }
            List<ClusterStorageFs> clusterStorageFsList = this.api.clusterStorageFsGetAll();
            for (ClusterStorageFs clusterStorageFs : clusterStorageFsList) {
                this.printClusterStorageFs(clusterStorageFs);
            }
            List<Id<AffinityGroup>> affinityGroupIds = this.api.affinityGroupGetIds();
            for (Id<AffinityGroup> groupId : affinityGroupIds) {
                this.printId("AffinityGroup", groupId);
            }
            List<AffinityGroup> affinityGroups = this.api.affinityGroupGetAll();
            for (AffinityGroup affinityGroup : affinityGroups) {
                this.printAffinityGroup(affinityGroup);
            }
            List<Id<Assembly>> assemblyIds = this.api.assemblyGetIds();
            for (Id<Assembly> assemblyId : assemblyIds) {
                this.printId("Assembly", assemblyId);
            }
            List<Assembly> assemblies = this.api.assemblyGetAll();
            for (Assembly assembly : assemblies) {
                this.printAssembly(assembly);
            }
            List<Id<AssemblyVm>> assemblyVmIds = this.api.assemblyVmGetIds();
            for (Id<AssemblyVm> assemblyVmId : assemblyVmIds) {
                this.printId("Assembly VM", assemblyVmId);
            }
            List<AssemblyVm> assemblyVms = this.api.assemblyVmGetAll();
            for (AssemblyVm assemblyVm : assemblyVms) {
                this.printAssemblyVm(assemblyVm);
            }
            List<Id<AssemblyVirtualDisk>> assemblyVirtualDiskIds = this.api.assemblyVirtualDiskGetIds();
            for (Id<AssemblyVirtualDisk> assemblyVirtualDiskId : assemblyVirtualDiskIds) {
                this.printId("Assembly Virtual Disk", assemblyVirtualDiskId);
            }
            List<AssemblyVirtualDisk> assemblyVirtualDisks = this.api.assemblyVirtualDiskGetAll();
            for (AssemblyVirtualDisk assemblyVirtualDisk : assemblyVirtualDisks) {
                this.printAssemblyVirtualDisk(assemblyVirtualDisk);
            }
            FileSystem clusterHeartbeatNetworkFileSystem = null;
            List<Id<FileSystem>> fileSystemIds = this.api.fileSystemGetIds();
            for (Id<FileSystem> fileSystemId : fileSystemIds) {
                this.printId("File System", fileSystemId);
            }
            List<FileSystem> fileSystems = this.api.fileSystemGetAll();
            for (FileSystem fileSystem : fileSystems) {
                if (fileSystem.getId().getValue().equals(clusterHeartbeatNetworkFileSystemId)) {
                    clusterHeartbeatNetworkFileSystem = fileSystem;
                }
                this.printFileSystem(fileSystem);
            }
            List<Id<FileSystemMount>> fileSystemMountIds = this.api.fileSystemMountGetIds();
            for (Id<FileSystemMount> fileSystemMountId : fileSystemMountIds) {
                this.printId("FileSystemMount", fileSystemMountId);
            }
            List<FileSystemMount> fileSystemMounts = this.api.fileSystemMountGetAll();
            for (FileSystemMount fileSystemMount : fileSystemMounts) {
                this.printFileSystemMount(fileSystemMount);
            }
            List<Id<FileServer>> fileServerIds = this.api.fileServerGetIds();
            for (Id<FileServer> fileServerId : fileServerIds) {
                this.printId("File Server", fileServerId);
            }
            List<FileServer> fileServers = this.api.fileServerGetAll();
            for (FileServer fileServer : fileServers) {
                this.printFileServer(fileServer);
            }
            List<Id<FileServerPlugin>> fileServerPluginIds = this.api.fileServerPluginGetIds();
            for (Id<FileServerPlugin> fileServerPluginId : fileServerPluginIds) {
                this.printId("File Server Plug-in", fileServerPluginId);
            }
            List<FileServerPlugin> fileServerPlugins = this.api.fileServerPluginGetAll();
            for (FileServerPlugin fileServerPlugin : fileServerPlugins) {
                this.printFileServerPlugin(fileServerPlugin);
                boolean generic = fileServerPlugin.isGenericPlugin();
            }
            StorageElement clusterHeartbeatStorageElement = null;
            List<Id<StorageElement>> storagEelementIds = this.api.storageElementGetIds();
            for (Id<StorageElement> storageElementId : storagEelementIds) {
                this.printId("Storage Element", storageElementId);
            }
            List<StorageElement> storageElements = this.api.storageElementGetAll();
            for (StorageElement storageElement : storageElements) {
                if (!storageElement.getId().getValue().equals(clusterHeartbeatStorageElementId)) continue;
                clusterHeartbeatStorageElement = storageElement;
            }
            if (this.testRepoId == null) {
                throw new Exception("Repository for VM creation (with id " + testRepo + ") not found.  Exiting.");
            }
            if (testServer == null) {
                throw new Exception("Server for VM creation (with name " + testServerName + ") not found.  Exiting.");
            }
            this.testServerId = testServer.getId();
            if (clusterHeartbeatStorageDeviceType == ClusterHeartbeatDevice.ClusterHeartbeatStorageType.NFS && clusterHeartbeatNetworkFileSystem == null) {
                throw new Exception("File System for Cluster Heartbeat Device creation (with id " + clusterHeartbeatNetworkFileSystemId + ") not found.  Exiting.");
            }
            if (clusterHeartbeatStorageDeviceType == ClusterHeartbeatDevice.ClusterHeartbeatStorageType.STORAGE_ELEMENT && clusterHeartbeatStorageElement == null) {
                throw new Exception("Storage Element for Cluster Heartbeat Device creation (with id " + clusterHeartbeatStorageElementId + ") not found.  Exiting.");
            }
            Repository testRepository = this.api.repositoryGetById(this.testRepoId);
            if (testRepository.getPresentedServerIds() == null || !testRepository.getPresentedServerIds().contains(this.testServerId)) {
                this.repoPresentJob = this.api.repositoryPresent(this.testRepoId, this.testServerId);
                System.out.println("present repository job id: " + this.repoPresentJob.getId());
                this.waitForJobComplete(this.api, this.repoPresentJob);
            }
            Network network = new Network();
            network.setDescription("Creating a test network named " + testNetworkName);
            network.setName(testNetworkName);
            Job networkCreateJob = this.api.networkCreate(network);
            System.out.println("create network job id: " + networkCreateJob.getId());
            this.testNetworkId = this.waitForJobComplete(this.api, networkCreateJob, Network.class);
            network = this.api.networkGetById(this.testNetworkId);
            System.out.println("Our newly created test network:");
            this.printNetwork(network);
            Network serverLocalNetwork = new Network();
            serverLocalNetwork.setName("MyTestServerLocalNetwork");
            this.testServerId = testServer.getId();
            serverLocalNetwork.setServerId(this.testServerId);
            Job localNetworkCreateJob = this.api.serverCreateNetwork(this.testServerId, serverLocalNetwork);
            System.out.println("create server local network job id: " + networkCreateJob.getId());
            this.testServerLocalNetworkId = this.waitForJobComplete(this.api, localNetworkCreateJob, Network.class);
            serverLocalNetwork = this.api.networkGetById(this.testServerLocalNetworkId);
            System.out.println("Our newly created test server local network:");
            this.printNetwork(serverLocalNetwork);
            Job jobGroup = new Job();
            jobGroup.setName("test job group");
            jobGroup.setDescription("test job group description");
            Id<Job> jobGroupId = this.api.jobCreateGroup(jobGroup);
            this.api.jobAddChildToGroup(jobGroupId, networkCreateJob.getId());
            this.api.jobAddChildToGroup(jobGroupId, localNetworkCreateJob.getId());
            jobGroup = this.api.jobGetById(jobGroupId);
            this.printJob(jobGroup);
            this.api.jobDelete(jobGroup.getId());
            ServerPool testPool = new ServerPool();
            testPool.setName(testServerPoolName);
            testPool.setVirtualIp(testServerPoolIp);
            Job serverPoolCreateJob = this.api.serverPoolCreate(testPool);
            System.out.println("create server pool job id: " + serverPoolCreateJob.getId());
            this.testPoolId = this.waitForJobComplete(this.api, serverPoolCreateJob, ServerPool.class);
            if (this.testPoolId != null) {
                Job resourceGroupAddResourceJob = this.api.resourceGroupAddResource(this.testResourceGroupId, this.testPoolId);
                System.out.println("resource group add resource job id: " + resourceGroupAddResourceJob.getId());
                Id<ResourceGroup> resourceGroupId = this.waitForJobComplete(this.api, resourceGroupAddResourceJob, ResourceGroup.class);
                if (resourceGroupId != null) {
                    ResourceGroup resourceGroup = this.api.resourceGroupGetById(resourceGroupId);
                    this.printResourceGroup(resourceGroup);
                }
            }
            testPool = this.api.serverPoolGetById(this.testPoolId);
            System.out.println("Our newly created test server pool:");
            this.printServerPool(testPool);
            Cluster testCluster = new Cluster();
            testCluster.setName(testClusterName);
            Job clusterCreateJob = this.api.serverPoolCreateCluster(this.testPoolId, testCluster);
            System.out.println("create cluster job id: " + clusterCreateJob.getId());
            this.testClusterId = this.waitForJobComplete(this.api, clusterCreateJob, Cluster.class);
            testCluster = this.api.clusterGetById(this.testClusterId);
            System.out.println("Our newly created test cluster:");
            this.printCluster(testCluster);
            ClusterHeartbeatDevice hbDevice = new ClusterHeartbeatDevice();
            hbDevice.setName(clusterHeartbeatDeviceName);
            hbDevice.setStorageType(clusterHeartbeatStorageDeviceType);
            switch (clusterHeartbeatStorageDeviceType) {
                case NFS: {
                    hbDevice.setNetworkFileSystemId(clusterHeartbeatNetworkFileSystem.getId());
                    break;
                }
                case STORAGE_ELEMENT: {
                    hbDevice.setStorageElementId(clusterHeartbeatStorageElement.getId());
                    break;
                }
                default: {
                    throw new Exception("Invalid cluster heartbeat storage device type: " + (Object)((Object)clusterHeartbeatStorageDeviceType));
                }
            }
            Job hbDeviceCreateJob = this.api.clusterCreateHeartbeatDevice(this.testClusterId, hbDevice);
            System.out.println("create cluster heartbeat device job id: " + hbDeviceCreateJob.getId());
            this.testHeartbeatDeviceId = this.waitForJobComplete(this.api, hbDeviceCreateJob, ClusterHeartbeatDevice.class);
            hbDevice = this.api.clusterHeartbeatDeviceGetById(this.testHeartbeatDeviceId);
            System.out.println("Our newly created heartbeat device:");
            this.printClusterHeartbeatDevice(hbDevice);
            if (testServer.getServerPoolId() != null) {
                System.out.println("Test server (" + testServerName + ") is a member of pool ID: " + testServer.getServerPoolId());
                System.out.println("Attempting to remove server from pool");
                Id<ServerPool> testServerPoolId = testServer.getServerPoolId();
                Job job = this.api.serverPoolRemoveServer(testServerPoolId, testServer.getId());
                System.out.println("remove server from pool job id: " + job.getId());
                this.waitForJobComplete(this.api, job);
                job = this.api.jobGetById(job.getId());
                if (job.getJobRunState() != Job.JobRunState.SUCCESS) {
                    throw new Exception("Could not remove server from its current pool.");
                }
            }
            System.out.println("Adding test server " + testServer.getName() + " to our test pool");
            Job job = this.api.serverPoolAddServer(this.testPoolId, testServer.getId());
            System.out.println("add server to pool job id: " + job.getId());
            this.waitForJobComplete(this.api, job);
            testPool = this.api.serverPoolGetById(this.testPoolId);
            System.out.println("Our modified test server pool (with server added):");
            this.printServerPool(testPool);
            testCluster = this.api.clusterGetById(this.testClusterId);
            System.out.println("Our modified test cluster (with server added):");
            this.printCluster(testCluster);
            if (testPool.getServerIds() == null) throw new Exception("No servers in test pool.  Cleaning up and exiting.");
            if (testPool.getServerIds().isEmpty()) {
                throw new Exception("No servers in test pool.  Cleaning up and exiting.");
            }
            Vm testVm = new Vm();
            testVm.setVmDomainType(Vm.VmDomainType.XEN_HVM);
            testVm.setName(testVmName);
            testVm.setRepositoryId(this.testRepoId);
            Job vmCreateJob = this.api.vmCreate(testVm, this.testPoolId);
            System.out.println("create vm job id: " + vmCreateJob.getId());
            this.testVmId = this.waitForJobComplete(this.api, vmCreateJob, Vm.class);
            testVm = this.api.vmGetById(this.testVmId);
            System.out.println("Our newly created test Vm:");
            this.printVm(testVm);
            testVm.setVmDomainType(Vm.VmDomainType.XEN_PVM);
            Job vmModifyJob = this.api.vmModify(testVm);
            System.out.println("modify vm job id: " + vmModifyJob.getId());
            this.waitForJobComplete(this.api, vmModifyJob);
            testVm = this.api.vmGetById(this.testVmId);
            System.out.println("Our test Vm with a new domain type:");
            this.printVm(testVm);
            Job vmClearServerPoolIdJob = this.api.serverPoolRemoveVm(this.testPoolId, this.testVmId);
            System.out.println("clear server pool job id: " + vmClearServerPoolIdJob.getId());
            this.waitForJobComplete(this.api, vmClearServerPoolIdJob);
            testVm = this.api.vmGetById(this.testVmId);
            System.out.println("Our test Vm with no server and no server pool:");
            this.printVm(testVm);
            if (testVm.getServerPoolId() != null) {
                throw new Exception("VM has a server pool but shouldn't.  Cleaning up and exiting");
            }
            if (testVm.getServerId() != null) {
                throw new Exception("VM has a server but shouldn't.  Cleaning up and exiting");
            }
            Job vmRestoreServerPoolIdJob = this.api.serverPoolAddVm(this.testPoolId, this.testVmId);
            System.out.println("restore server pool job id: " + vmRestoreServerPoolIdJob.getId());
            this.waitForJobComplete(this.api, vmRestoreServerPoolIdJob);
            testVm = this.api.vmGetById(this.testVmId);
            System.out.println("Our test Vm with no server and a restored server pool:");
            this.printVm(testVm);
            if (!testVm.getServerPoolId().equals(this.testPoolId)) {
                throw new Exception("VM does not have the server pool it should.  Cleaning up and exiting");
            }
            if (testVm.getServerId() != null) {
                throw new Exception("VM has a server but should not.  Cleaning up and exiting");
            }
            if (this.testVmId != null) {
                VirtualNic virtualNic = new VirtualNic();
                Job createVirtualNicJob = this.api.vmCreateVirtualNic(this.testVmId, virtualNic);
                System.out.println("add virtual nic job id: " + createVirtualNicJob.getId());
                this.waitForJobComplete(this.api, createVirtualNicJob);
                testVm = this.api.vmGetById(this.testVmId);
                List<Id<VirtualNic>> vnicIds = testVm.getVirtualNicIds();
                Id<VirtualNic> vnicId = null;
                if (vnicIds == null) throw new Exception("Vnic was not created on the vm.  Cleaning up and exiting");
                if (vnicIds.size() <= 0) {
                    throw new Exception("Vnic was not created on the vm.  Cleaning up and exiting");
                }
                vnicId = vnicIds.get(vnicIds.size() - 1);
                System.out.println("Our test Vm with an new virtual nic:");
                this.printVm(testVm);
                Job deleteVirtualNicJob = this.api.vmDeleteVirtualNic(this.testVmId, vnicId);
                System.out.println("delete virtual nic job id: " + deleteVirtualNicJob.getId());
                this.waitForJobComplete(this.api, deleteVirtualNicJob);
                testVm = this.api.vmGetById(this.testVmId);
                System.out.println("Our test Vm with the vnic deleted:");
                this.printVm(testVm);
            }
            if (testVm != null) {
                Job killJob = this.api.vmKill(testVm.getId());
                System.out.println("vm kill job id: " + killJob.getId());
                this.waitForJobComplete(this.api, killJob);
            }
            AffinityGroup group = new AffinityGroup();
            group.setName(testAffinityGroupName);
            group.setVmAffinityType(AffinityGroup.AffinityType.ANTI_AFFINITY);
            group.setServerAffinityType(AffinityGroup.AffinityType.NO_AFFINITY);
            Job createAffinityGroupJob = this.api.serverPoolCreateAffinityGroup(this.testPoolId, group);
            System.out.println("create affinityGroup job id: " + createAffinityGroupJob.getId());
            this.testAffinityGroupId = this.waitForJobComplete(this.api, createAffinityGroupJob, AffinityGroup.class);
            group = this.api.affinityGroupGetById(this.testAffinityGroupId);
            this.printAffinityGroup(group);
            Job addVmToGroupJob = this.api.affinityGroupAddVm(this.testAffinityGroupId, testVm.getId());
            System.out.println("add vm to affinityGroup job id: " + addVmToGroupJob.getId());
            this.waitForJobComplete(this.api, addVmToGroupJob);
            group = this.api.affinityGroupGetById(this.testAffinityGroupId);
            System.out.println("Our test Affinity group with our test vm added:");
            this.printAffinityGroup(group);
            Job removeVmFromGroupJob = this.api.affinityGroupRemoveVm(this.testAffinityGroupId, this.testVmId);
            System.out.println("remove vm from affinityGroup job id: " + removeVmFromGroupJob.getId());
            this.waitForJobComplete(this.api, removeVmFromGroupJob);
            group = this.api.affinityGroupGetById(this.testAffinityGroupId);
            System.out.println("Our test Affinity group with our test vm removed:");
            this.printAffinityGroup(group);
            Job importAssemblyJob = this.api.repositoryImportAssembly(this.testRepoId, assemblyUrl, null);
            System.out.println("import assembly job id: " + importAssemblyJob.getId());
            this.testAssemblyId = this.waitForJobComplete(this.api, importAssemblyJob, Assembly.class);
            Assembly assembly = this.api.assemblyGetById(this.testAssemblyId);
            System.out.println("Our imported assembly:");
            this.printAssembly(assembly);
            System.out.println("Assembly VMs");
            assemblyVms = this.api.assemblyVmGetListById(assembly.getAssemblyVmIds());
            Id<AssemblyVm> testAssemblyVmId = null;
            for (AssemblyVm assemblyVm : assemblyVms) {
                if (testAssemblyVmId == null) {
                    testAssemblyVmId = assemblyVm.getId();
                }
                this.printAssemblyVm(assemblyVm);
            }
            System.out.println("Assembly Disks");
            assemblyVirtualDisks = this.api.assemblyVirtualDiskGetListById(assembly.getAssemblyVirtualDiskIds());
            for (AssemblyVirtualDisk assemblyVirtualDisk : assemblyVirtualDisks) {
                this.printAssemblyVirtualDisk(assemblyVirtualDisk);
            }
            if (testAssemblyVmId == null) return;
            Job importVmFromAssemblyJob = this.api.vmCreateFromAssemblyVm(testAssemblyVmId);
            System.out.println("import vm from assembly job id: " + importVmFromAssemblyJob.getId());
            this.importedAssemblyVmId = this.waitForJobComplete(this.api, importVmFromAssemblyJob, Vm.class);
            Vm vm = this.api.vmGetById(this.importedAssemblyVmId);
            System.out.println("Our imported vm:");
            this.printVm(vm);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\nException occurred during processing.  Calling cleanup routine.");
            return;
        }
        finally {
            try {
                this.cleanup();
                System.out.println("Ovm Api Test Finished");
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("\nException occurred during cleanup.  Bailing out.");
            }
            finally {
                try {
                    this.api.logout();
                }
                catch (WsException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void cleanup() throws WsException {
        if (this.testAssemblyId != null) {
            Job assemblyDeleteJob = this.api.repositoryDeleteAssembly(this.testRepoId, this.testAssemblyId);
            System.out.println("delete assembly job id: " + assemblyDeleteJob.getId());
            this.waitForJobComplete(this.api, assemblyDeleteJob);
            this.testAssemblyId = null;
        }
        if (this.importedAssemblyVmId != null) {
            Vm importedAssemblyVm = this.api.vmGetById(this.importedAssemblyVmId);
            List<Id<VmDiskMapping>> diskMappingIds = importedAssemblyVm.getVmDiskMappingIds();
            List<VmDiskMapping> diskMappings = this.api.vmDiskMappingGetListById(diskMappingIds);
            Job job = this.api.vmDelete(this.importedAssemblyVmId);
            System.out.println("delete vm (imported from assembly) job id: " + job.getId());
            this.waitForJobComplete(this.api, job);
            this.importedAssemblyVmId = null;
            for (VmDiskMapping diskMapping : diskMappings) {
                Job virtualDiskDeleteJob = this.api.repositoryDeleteVirtualDisk(this.testRepoId, diskMapping.getVirtualDiskId());
                System.out.println("delete virtual disk (imported from assembly) job id: " + job.getId());
                this.waitForJobComplete(this.api, virtualDiskDeleteJob);
            }
        }
        if (this.testAffinityGroupId != null) {
            Job affinityGroupDeleteJob = this.api.serverPoolDeleteAffinityGroup(this.testPoolId, this.testAffinityGroupId);
            System.out.println("delete affinityGroup job id: " + affinityGroupDeleteJob.getId());
            this.waitForJobComplete(this.api, affinityGroupDeleteJob);
            this.testAffinityGroupId = null;
        }
        if (this.testVmId != null) {
            Job vmDeleteJob = this.api.vmDelete(this.testVmId);
            System.out.println("delete vm job id: " + vmDeleteJob.getId());
            this.waitForJobComplete(this.api, vmDeleteJob);
            this.testVmId = null;
        }
        if (this.testResourceGroupId != null) {
            ResourceGroup resourceGroup = this.api.resourceGroupGetById(this.testResourceGroupId);
            List<Id<? extends BaseObject>> resourcesIds = resourceGroup.getResourceIds();
            if (resourcesIds != null && !resourcesIds.isEmpty()) {
                for (Id<? extends BaseObject> id : resourcesIds) {
                    Job resourceGroupRemoveResourceJob = this.api.resourceGroupRemoveResource(resourceGroup.getId(), id);
                    System.out.println("resource group remove resource  job id: " + resourceGroupRemoveResourceJob.getId());
                    this.waitForJobComplete(this.api, resourceGroupRemoveResourceJob);
                }
            }
            Job resourceGroupDeleteJob = this.api.resourceGroupDelete(this.testResourceGroupId);
            System.out.println("resource group delete  job id: " + resourceGroupDeleteJob.getId());
            this.waitForJobComplete(this.api, resourceGroupDeleteJob);
        }
        if (this.testPoolId != null) {
            ServerPool serverPool = this.api.serverPoolGetById(this.testPoolId);
            List<Id<Server>> serverIds = serverPool.getServerIds();
            if (serverIds != null && !serverIds.isEmpty()) {
                System.out.println("Removing all servers from pool " + serverPool.getName());
                for (Id<? extends BaseObject> id : serverIds) {
                    if (id.equals(serverPool.getMasterServerId())) continue;
                    System.out.println("  Removing server: " + id);
                    Job job = this.api.serverPoolRemoveServer(serverPool.getId(), id);
                    this.waitForJobComplete(this.api, job);
                }
                if (serverPool.getMasterServerId() != null) {
                    System.out.println("  Removing master server: " + serverPool.getMasterServerId());
                    Job job = this.api.serverPoolRemoveServer(serverPool.getId(), serverPool.getMasterServerId());
                    this.waitForJobComplete(this.api, job);
                }
            }
            if (this.testHeartbeatDeviceId != null) {
                Job hbDeviceDeleteJob = this.api.clusterDeleteHeartbeatDevice(this.testClusterId, this.testHeartbeatDeviceId);
                System.out.println("delete cluster heartbeat device job id: " + hbDeviceDeleteJob.getId());
                this.waitForJobComplete(this.api, hbDeviceDeleteJob);
                this.testHeartbeatDeviceId = null;
            }
            if (this.testClusterId != null) {
                Job clusterDeleteJob = this.api.serverPoolDeleteCluster(this.testPoolId, this.testClusterId);
                System.out.println("delete cluster job id: " + clusterDeleteJob.getId());
                this.waitForJobComplete(this.api, clusterDeleteJob);
                this.testClusterId = null;
            }
            Job serverPoolDeleteJob = this.api.serverPoolDelete(this.testPoolId);
            System.out.println("delete server pool job id: " + serverPoolDeleteJob.getId());
            this.waitForJobComplete(this.api, serverPoolDeleteJob);
            this.testPoolId = null;
            if (this.testServerLocalNetworkId != null) {
                Job job = this.api.serverDeleteNetwork(this.testServerId, this.testServerLocalNetworkId);
                System.out.println("delete local network job id: " + job.getId());
                this.waitForJobComplete(this.api, job);
            }
            if (this.testNetworkId != null) {
                Job job = this.api.networkDelete(this.testNetworkId);
                System.out.println("delete network job id: " + job.getId());
                this.waitForJobComplete(this.api, job);
            }
        }
        if (this.repoPresentJob != null) {
            Job repoUnpresentJob = this.api.repositoryUnpresent(this.testRepoId, this.testServerId);
            System.out.println("unpresent repository job id: " + repoUnpresentJob.getId());
            this.waitForJobComplete(this.api, repoUnpresentJob);
        }
        System.out.println("Cleanup finished");
    }

    private String getProperty(String key, ResourceBundle ... bundles) {
        String value = null;
        MissingResourceException missingResourceEx = null;
        for (ResourceBundle bundle : bundles) {
            if (bundle == null) continue;
            try {
                value = bundle.getString(key);
            }
            catch (MissingResourceException ex) {
                missingResourceEx = ex;
            }
        }
        if (value == null) {
            throw missingResourceEx;
        }
        return value;
    }

    private void printVm(Vm vm) {
        System.out.println("Vm id: " + vm.getId());
        System.out.println("\tServer id: " + vm.getServerId());
        System.out.println("\tRepository id: " + vm.getRepositoryId());
        System.out.println("\tdomain type: " + (Object)((Object)vm.getVmDomainType()));
        System.out.println("\tname: " + vm.getName());
        System.out.println("\tdescription: " + vm.getDescription());
        System.out.println("\tGeneration: " + vm.getGeneration());
        System.out.println("\trun state: " + (Object)((Object)vm.getVmRunState()));
        System.out.println("\tmouse type: " + (Object)((Object)vm.getVmMouseType()));
        System.out.println("\tos type: " + vm.getOsType());
        System.out.println("\tboot order: " + vm.getBootOrder());
        System.out.println("\tha enabled: " + vm.getHighAvailability());
        System.out.println("\tcpus: " + vm.getCpuCount() + " cpu limit: " + vm.getCpuCountLimit());
        System.out.println("\tmem: " + vm.getMemory() + " mem limit: " + vm.getMemoryLimit());
        System.out.println("\tpriority: " + vm.getCpuPriority());
        System.out.println("\tcpu util cap: " + vm.getCpuUtilizationCap());
        System.out.println("\tkeymap: " + vm.getKeymapName());
        System.out.println("\tnet install path: " + vm.getNetworkInstallPath());
        if (vm.getVmRunState() != Vm.VmRunState.TEMPLATE) {
            System.out.println("\tstart policy: " + (Object)((Object)vm.getVmStartPolicy()));
        }
        System.out.println("\tarch: " + vm.getArchitecture());
        System.out.println("\tguest driver rev: " + vm.getGuestDriverVersion());
        System.out.println("\tkernel rev: " + vm.getKernelVersion());
        System.out.println("\tos rev: " + vm.getOsVersion());
        System.out.println("\tssl vnc port: " + vm.getSslVncPort());
        System.out.println("\tssl tty port: " + vm.getSslTtyPort());
        System.out.println("\tvm api rev: " + vm.getVmApiVersion());
        System.out.println("\tserver pool id: " + vm.getServerPoolId());
        System.out.println("\tserver id: " + vm.getServerId());
        System.out.println("\tAffinity groups:");
        List<Id<AffinityGroup>> affinityGroupIds = vm.getAffinityGroupIds();
        if (affinityGroupIds != null) {
            for (Id<AffinityGroup> affinityGroupId : affinityGroupIds) {
                System.out.println("\t\tAffinity group id: " + affinityGroupId);
            }
        }
        System.out.println("\tVirtual Nics:");
        List<Id<VirtualNic>> virtualNicIds = vm.getVirtualNicIds();
        if (virtualNicIds != null) {
            for (Id<VirtualNic> virtualNicId : virtualNicIds) {
                System.out.println("\t\tVirtualNic id: " + virtualNicId);
            }
        }
        System.out.println("\tVmDiskMappings:");
        List<Id<VmDiskMapping>> vmDiskMappingIds = vm.getVmDiskMappingIds();
        if (vmDiskMappingIds != null) {
            for (Id<VmDiskMapping> vmDiskMappingId : vmDiskMappingIds) {
                System.out.println("\t\tVmDiskMapping id: " + vmDiskMappingId);
            }
        }
        System.out.println("");
    }

    private void printServer(Server server) {
        System.out.println("Server id: " + server.getId());
        System.out.println("\tname: " + server.getName());
        System.out.println("\tdescription: " + server.getDescription());
        System.out.println("\tGeneration: " + server.getGeneration());
        System.out.println("\tServerPool id: " + server.getServerPoolId());
        System.out.println("\tCluster id: " + server.getClusterId());
        System.out.println("\tCpuCompatibilityGroup id: " + server.getCpuCompatibilityGroupId());
        System.out.println("\tServerController id: " + server.getServerControllerId());
        System.out.println("\tVms:");
        List<Id<Vm>> vmIds = server.getVmIds();
        if (vmIds != null) {
            for (Id<Vm> vmId : vmIds) {
                System.out.println("\t\tVm id: " + vmId);
            }
        }
        System.out.println("\tFile System Mounts:");
        List<Id<FileSystemMount>> fileSystemMountIds = server.getFileSystemMountIds();
        if (fileSystemMountIds != null) {
            for (Id<FileSystemMount> fileSystemMountId : fileSystemMountIds) {
                System.out.println("\t\tFile System Mount id: " + fileSystemMountId);
            }
        }
        System.out.println("\tFile Server Plug-in Ids:");
        List<Id<FileServerPlugin>> fileServerPluginIds = server.getFileServerPluginIds();
        if (fileServerPluginIds != null) {
            for (Id<FileServerPlugin> fileServerPluginId : fileServerPluginIds) {
                System.out.println("\t\tFile Server Plug-in id: " + fileServerPluginId);
            }
        }
        System.out.println("\tControl Domains:");
        List<Id<ControlDomain>> controlDomainIds = server.getControlDomainIds();
        if (controlDomainIds != null) {
            for (Id<ControlDomain> controlDomainId : controlDomainIds) {
                System.out.println("\t\tControlDomain id: " + controlDomainId);
            }
        }
        System.out.println("\tCpus:");
        List<Id<Cpu>> cpuIds = server.getCpuIds();
        if (cpuIds != null) {
            for (Id<Cpu> cpuId : cpuIds) {
                System.out.println("\t\tCpu id: " + cpuId);
            }
        }
        System.out.println("");
    }

    private void printVirtualDisk(VirtualDisk virtualDisk) {
        System.out.println("VirtualDisk id: " + virtualDisk.getId());
        System.out.println("\tname: " + virtualDisk.getName());
        System.out.println("\tdescription: " + virtualDisk.getDescription());
        System.out.println("\tGeneration: " + virtualDisk.getGeneration());
        System.out.println("\tdisk type: " + (Object)((Object)virtualDisk.getDiskType()));
        System.out.println("\tsize: " + virtualDisk.getSize());
        System.out.println("\ton disk size: " + virtualDisk.getOnDiskSize());
        System.out.println("\tpath: " + virtualDisk.getPath());
        System.out.println("\trepository id: " + virtualDisk.getRepositoryId());
        System.out.println("\tVmDiskMappings:");
        List<Id<VmDiskMapping>> vmDiskMappingIds = virtualDisk.getVmDiskMappingIds();
        if (vmDiskMappingIds != null) {
            for (Id<VmDiskMapping> vmDiskMappingId : vmDiskMappingIds) {
                System.out.println("\t\tVmDiskMapping id: " + vmDiskMappingId);
            }
        }
        System.out.println("");
    }

    private void printControlDomain(ControlDomain controlDomain) {
        System.out.println("\tControl Domain id: " + controlDomain.getId());
        System.out.println("\tOS name: " + controlDomain.getOsName());
        System.out.println("\tOS type: " + controlDomain.getOsType());
        System.out.println("\tOS major version: " + controlDomain.getOsMajorVersion());
        System.out.println("\tOS minor version: " + controlDomain.getOsMinorVersion());
        System.out.println("\tOS kernel version: " + controlDomain.getOsKernelVersion());
        System.out.println("\tOS kernel release: " + controlDomain.getOsKernelRelease());
        System.out.println("\tOracle VM version: " + controlDomain.getOvmVersion());
        System.out.println("\trpm version: " + controlDomain.getRpmVersion());
        System.out.println("\tagent version: " + controlDomain.getAgentVersion());
        System.out.println("\tcpu count: " + controlDomain.getCpuCount());
        System.out.println("\tmemory size: " + controlDomain.getMemory());
        System.out.println("\tserver id: " + controlDomain.getServerId());
        System.out.println("");
    }

    private void printCpu(Cpu cpu) {
        System.out.println("\tCpu id: " + cpu.getId());
        System.out.println("\tmodel name: " + cpu.getModelName());
        System.out.println("\tvendor id: " + cpu.getVendorId());
        System.out.println("\tcpu family: " + cpu.getCpuFamily());
        System.out.println("\tcpu model: " + cpu.getCpuModel());
        System.out.println("\tlevel 2 cache size: " + cpu.getLevelTwoCacheSize());
        System.out.println("\tcpu number: " + cpu.getCpuNumber());
        System.out.println("\tvirtual cpu number: " + cpu.getVirtualCpuNumber());
        System.out.println("\tcpu flags: " + cpu.getFlags());
        System.out.println("\tserver id: " + cpu.getServerId());
        System.out.println("");
    }

    private void printVirtualNic(VirtualNic virtualNic) {
        System.out.println("Virtual Nic id: " + virtualNic.getId());
        System.out.println("\tname: " + virtualNic.getName());
        System.out.println("\tdescription: " + virtualNic.getDescription());
        System.out.println("\tGeneration: " + virtualNic.getGeneration());
        System.out.println("\tvm id: " + virtualNic.getVmId());
        System.out.println("\tnetwork id: " + virtualNic.getNetworkId());
        System.out.println("");
    }

    public void printRepository(Repository repository) {
        System.out.println("Repository id: " + repository.getId());
        System.out.println("\tname: " + repository.getName());
        System.out.println("\tdescription: " + repository.getDescription());
        System.out.println("\tGeneration: " + repository.getGeneration());
        System.out.println("\tfile system id: " + repository.getFileSystemId());
        System.out.println("\tmanager uuid: " + repository.getManagerUuid());
        System.out.println("\trefreshed: " + repository.getRefreshed());
        System.out.println("\tshare path: " + repository.getSharePath());
        System.out.println("\tAssemblies:");
        if (repository.getAssemblyIds() != null) {
            for (Id<Assembly> id : repository.getAssemblyIds()) {
                System.out.println("\t\tassembly id: " + id);
            }
        }
        System.out.println("\tPresented Servers:");
        if (repository.getPresentedServerIds() != null) {
            for (Id<BaseObject> id : repository.getPresentedServerIds()) {
                System.out.println("\t\tserver id: " + id);
            }
        }
        System.out.println("\tVms:");
        List<Id<Vm>> vmIds = repository.getVmIds();
        if (vmIds != null) {
            for (Id<Vm> vmId : vmIds) {
                System.out.println("\t\tvm id: " + vmId);
            }
        }
        System.out.println("\tVirtualDisks:");
        List<Id<VirtualDisk>> list = repository.getVirtualDiskIds();
        if (list != null) {
            for (Id<VirtualDisk> virtualDiskId : list) {
                System.out.println("\t\tvirtual disk id: " + virtualDiskId);
            }
        }
        System.out.println("");
    }

    public void printResourceGroup(ResourceGroup resourceGroup) {
        System.out.println("Resource Group name: " + resourceGroup.getName());
        System.out.println("Resource Group Id:   " + resourceGroup.getId());
        List<Id<? extends BaseObject>> groupedObjects = resourceGroup.getResourceIds();
        if (groupedObjects != null) {
            for (Id<? extends BaseObject> objectId : resourceGroup.getResourceIds()) {
                System.out.println("Resource Group resource id:" + objectId);
            }
        }
    }

    public void printServerPool(ServerPool serverPool) throws WsException {
        System.out.println("ServerPool id: " + serverPool.getId());
        System.out.println("\tname: " + serverPool.getName());
        System.out.println("\tdescription: " + serverPool.getDescription());
        System.out.println("\tGeneration: " + serverPool.getGeneration());
        System.out.println("\tvirtualIp: " + serverPool.getVirtualIp());
        System.out.println("\tkeymap: " + serverPool.getKeymap());
        System.out.println("\tsecureVmMigrate: " + serverPool.getSecureVmMigrate());
        System.out.println("\tcluster id: " + serverPool.getClusterId());
        System.out.println("\tVm start policy: " + (Object)((Object)serverPool.getVmStartPolicy()));
        List<Id<Server>> serverIds = serverPool.getServerIds();
        if (serverIds == null) {
            System.out.println("\tServers: None");
        } else {
            System.out.println("\tServers:");
            for (Id<Server> serverId : serverIds) {
                if (serverId.equals(serverPool.getMasterServerId())) {
                    System.out.println("\t\tserver id: " + serverId + "  (Master)");
                    continue;
                }
                System.out.println("\t\tserver id: " + serverId);
            }
        }
        System.out.println("\tVms:");
        List<Id<Vm>> vmIds = serverPool.getVmIds();
        if (vmIds != null) {
            for (Id<Vm> vmId : vmIds) {
                System.out.println("\t\tvm id: " + vmId);
            }
        }
        System.out.println("\tUnassigned Vms:");
        List<Id<Vm>> unassignedVmIds = serverPool.getUnassignedVmIds();
        if (unassignedVmIds != null) {
            for (Id<Vm> vmId : unassignedVmIds) {
                System.out.println("\t\tvm id: " + vmId);
            }
        }
        System.out.println("\tAffinity Groups:");
        List<Id<AffinityGroup>> affinityGroupIds = serverPool.getAffinityGroupIds();
        if (affinityGroupIds != null) {
            for (Id<AffinityGroup> affinityGroupId : affinityGroupIds) {
                System.out.println("\t\taffinity group id: " + affinityGroupId);
            }
        }
        Id<ServerPoolPolicy> serverPoolPolicyId = serverPool.getServerPoolPolicyId();
        System.out.println("\tPolicy id: " + serverPoolPolicyId);
        if (serverPoolPolicyId != null) {
            ServerPoolPolicy policy = this.api.serverPoolPolicyGetById(serverPoolPolicyId);
            System.out.println("\t\tMode: " + (Object)((Object)policy.getMode()));
            System.out.println("\t\tEnabled: " + policy.isEnabled());
            System.out.println("\t\tPeriod: " + policy.getPeriodMinutes());
            System.out.println("\t\tCpu threshold: " + policy.getThreshold());
            List<Id<Server>> servers = policy.getServerIds();
            System.out.println("\t\tServers: ");
            if (servers != null) {
                for (Id<Server> id : servers) {
                    System.out.println("\t\t\tserver id: " + id);
                }
            } else {
                System.out.println("\t\t\tNone");
            }
            List<Id<ServerPoolNetworkPolicy>> networkPolicies = policy.getServerPoolNetworkPolicyIds();
            System.out.println("\t\tNetworkPolicies: ");
            if (networkPolicies != null) {
                for (Id<ServerPoolNetworkPolicy> id : networkPolicies) {
                    System.out.println("\t\t\tnetworkpolicy id: " + id);
                    ServerPoolNetworkPolicy networkPolicy = this.api.serverPoolNetworkPolicyGetById(id);
                    System.out.println("\t\t\t\tEnable: " + networkPolicy.isEnabled());
                    System.out.println("\t\t\t\tThreshold: " + networkPolicy.getThreshold());
                    System.out.println("\t\t\t\tNetwork id: " + networkPolicy.getNetworkId());
                }
            } else {
                System.out.println("\t\t\tNone");
            }
        }
        System.out.println("");
    }

    public void printCluster(Cluster cluster) {
        System.out.println("Cluster id: " + cluster.getId());
        System.out.println("\tname: " + cluster.getName());
        System.out.println("\tdescription: " + cluster.getDescription());
        System.out.println("\tGeneration: " + cluster.getGeneration());
        System.out.println("\tserver pool id: " + cluster.getServerPoolId());
        System.out.println("\tServers:");
        List<Id<Server>> serverIds = cluster.getServerIds();
        if (serverIds != null) {
            for (Id<Server> serverId : serverIds) {
                System.out.println("\t\tserver id: " + serverId);
            }
        }
        System.out.println("\tHeartbeat devices:");
        List<Id<ClusterHeartbeatDevice>> deviceIds = cluster.getHeartbeatDeviceIds();
        if (deviceIds != null) {
            for (Id<ClusterHeartbeatDevice> deviceId : deviceIds) {
                System.out.println("\t\theartbeat device id: " + deviceId);
            }
        }
        System.out.println("");
    }

    public void printClusterHeartbeatDevice(ClusterHeartbeatDevice device) {
        System.out.println("Cluster Storage id: " + device.getId());
        System.out.println("\tname: " + device.getName());
        System.out.println("\tdescription: " + device.getDescription());
        System.out.println("\tGeneration: " + device.getGeneration());
        System.out.println("\tcluster id: " + device.getClusterId());
        System.out.println("\tcluster network file system id: " + device.getNetworkFileSystemId());
        System.out.println("\tcluster storage element id: " + device.getStorageElementId());
        System.out.println("\tcluster storage fs id: " + device.getClusterStorageFsId());
        System.out.println("\tstorage type: " + (Object)((Object)device.getStorageType()));
        System.out.println("");
    }

    public void printClusterStorageFs(ClusterStorageFs clusterStorageFs) {
        System.out.println("Cluster Storage id: " + clusterStorageFs.getId());
        System.out.println("\tname: " + clusterStorageFs.getName());
        System.out.println("\tdescription: " + clusterStorageFs.getDescription());
        System.out.println("\tGeneration: " + clusterStorageFs.getGeneration());
        System.out.println("\tcluster heartbeat device id: " + clusterStorageFs.getClusterHeartbeatDeviceId());
        System.out.println("");
    }

    public <T> void printId(String text, Id<T> id) {
        System.out.println("Id<" + text + ">:");
        System.out.println("\tName:\t" + id.getName());
        System.out.println("\tType:\t" + id.getType());
        System.out.println("\tURI:\t" + id.getUri());
        System.out.println("\tValue:\t" + id.getValue());
        System.out.println("");
    }

    private void printAffinityGroup(AffinityGroup group) {
        System.out.println("AffinityGroup Id: " + group.getId());
        System.out.println("\tName: " + group.getName());
        System.out.println("\tDescription: " + group.getDescription());
        System.out.println("\tGeneration: " + group.getGeneration());
        System.out.println("\tVM Affinity type: " + (Object)((Object)group.getVmAffinityType()));
        System.out.println("\tServer Affinity type: " + (Object)((Object)group.getServerAffinityType()));
        System.out.println("\tServer Pool Id: " + group.getServerPoolId());
        System.out.println("\tVMs:");
        if (group.getVmIds() != null) {
            for (Id<Vm> id : group.getVmIds()) {
                System.out.println("\t\tvm id: " + id);
            }
        }
        System.out.println("\tServers:");
        if (group.getServerIds() != null) {
            for (Id<BaseObject> id : group.getServerIds()) {
                System.out.println("\t\tserver id: " + id);
            }
        }
        System.out.println();
    }

    private void printNetwork(Network network) {
        System.out.println("Network id: " + network.getId());
        System.out.println("\tname: " + network.getName());
        System.out.println("\tdescription: " + network.getDescription());
        System.out.println("\tGeneration: " + network.getGeneration());
        System.out.println("\tserver local: " + network.getServerLocal());
        List<Network.Role> networkRoles = network.getRoles();
        if (networkRoles != null) {
            for (Network.Role networkRole : networkRoles) {
                System.out.println("\trole: " + (Object)((Object)networkRole));
            }
        }
        System.out.println("\tVirtual Nics:");
        List<Id<VirtualNic>> virtualNicIds = network.getVirtualNicIds();
        if (virtualNicIds != null) {
            for (Id<VirtualNic> virtualNicId : virtualNicIds) {
                System.out.println("\t\tvirtual nic id: " + virtualNicId);
            }
        }
        System.out.println("\tVlanInterfaces:");
        List<Id<VlanInterface>> vlanInterfaceIds = network.getVlanInterfaceIds();
        if (vlanInterfaceIds != null) {
            for (Id<VlanInterface> vlanInterfaceId : vlanInterfaceIds) {
                System.out.println("\t\tvlan interface id: " + vlanInterfaceId);
            }
        }
        System.out.println("");
    }

    private void printEthernetPort(EthernetPort ethernetPort) {
        System.out.println("EthernetPort id: " + ethernetPort.getId());
        System.out.println("\tname: " + ethernetPort.getName());
        System.out.println("\tdescription: " + ethernetPort.getDescription());
        System.out.println("\tGeneration: " + ethernetPort.getGeneration());
        System.out.println("\tServer id: " + ethernetPort.getServerId());
        EthernetPort.PortType portType = ethernetPort.getPortType();
        if (portType != null) {
            System.out.println("\tPort type: " + portType.toString());
        }
        System.out.println("\tmtu: " + ethernetPort.getMtu());
        System.out.println("\tmac: " + ethernetPort.getMacAddress());
        switch (portType) {
            case BOND: 
            case AGGREGATION: {
                System.out.println("\tBond Members: ");
                List<Id<EthernetPort>> physicalPortIds = ethernetPort.getPhysicalPortIds();
                for (Id<EthernetPort> physicalPortId : physicalPortIds) {
                    System.out.println("\t\t" + physicalPortId);
                }
                break;
            }
            case PHYSICAL: {
                System.out.println("\tbond port id: " + ethernetPort.getBondPortId());
            }
        }
    }

    private void printAssembly(Assembly assembly) {
        System.out.println("Assembly Id: " + assembly.getId());
        System.out.println("\tName: " + assembly.getName());
        System.out.println("\tDescription: " + assembly.getDescription());
        System.out.println("\tGeneration: " + assembly.getGeneration());
        System.out.println("\tOrigin: " + assembly.getOrigin());
        System.out.println("\tRepository Id: " + assembly.getRepositoryId());
        System.out.println("\tLocales:");
        if (assembly.getLocales() != null) {
            for (String string : assembly.getLocales()) {
                System.out.println("\t\tlocale: " + string);
            }
        }
        System.out.println("\tAssembly VMs:");
        if (assembly.getAssemblyVmIds() != null) {
            for (Id id : assembly.getAssemblyVmIds()) {
                System.out.println("\t\tassembly vm id: " + id);
            }
        }
        System.out.println("\tAssembly Virtual Disks:");
        if (assembly.getAssemblyVirtualDiskIds() != null) {
            for (Id id : assembly.getAssemblyVirtualDiskIds()) {
                System.out.println("\t\tassembly virtual disk id: " + id);
            }
        }
        System.out.println();
    }

    private void printAssemblyVm(AssemblyVm assemblyVm) {
        System.out.println("Assembly Vm Id: " + assemblyVm.getId());
        System.out.println("\tName: " + assemblyVm.getName());
        System.out.println("\tDescription: " + assemblyVm.getDescription());
        System.out.println("\tGeneration: " + assemblyVm.getGeneration());
        System.out.println("\tAssembly Id: " + assemblyVm.getAssemblyId());
        System.out.println("\tAssembly Virtual Disks:");
        if (assemblyVm.getAssemblyVirtualDiskIds() != null) {
            for (Id<AssemblyVirtualDisk> virtualDiskId : assemblyVm.getAssemblyVirtualDiskIds()) {
                System.out.println("\t\tassembly virtual disk id: " + virtualDiskId);
            }
        }
        System.out.println();
    }

    private void printAssemblyVirtualDisk(AssemblyVirtualDisk assemblyVirtualDisk) {
        System.out.println("Assembly Virtual Disk Id: " + assemblyVirtualDisk.getId());
        System.out.println("\tName: " + assemblyVirtualDisk.getName());
        System.out.println("\tDescription: " + assemblyVirtualDisk.getDescription());
        System.out.println("\tGeneration: " + assemblyVirtualDisk.getGeneration());
        System.out.println("\tAssembly Id: " + assemblyVirtualDisk.getAssemblyId());
        System.out.println("\tCapacity: " + assemblyVirtualDisk.getCapacity());
        System.out.println("\tPopulated size: " + assemblyVirtualDisk.getPopulatedSize());
        System.out.println("\tFormat: " + assemblyVirtualDisk.getFormat());
        System.out.println("\tAssembly VMs:");
        if (assemblyVirtualDisk.getAssemblyVmIds() != null) {
            for (Id<AssemblyVm> vmId : assemblyVirtualDisk.getAssemblyVmIds()) {
                System.out.println("\t\tassembly vm id: " + vmId);
            }
        }
        System.out.println();
    }

    private void printFileServer(FileServer fileServer) {
        System.out.println("File Server Id: " + fileServer.getId());
        System.out.println("\tName: " + fileServer.getName());
        System.out.println("\tFile type:" + (Object)((Object)fileServer.getFileServerType()));
        System.out.println("\tStorage description: " + fileServer.getStorageDescription());
        System.out.println("\tAccess Host: " + fileServer.getAccessHost());
        System.out.println("\tFile Systems:");
        if (fileServer.getFileSystemIds() != null) {
            for (Id<FileSystem> id : fileServer.getFileSystemIds()) {
                System.out.println("\t\tFile System id: " + id);
            }
        }
        System.out.println("\tAdmin Servers:");
        if (fileServer.getAdminServerIds() != null) {
            for (Id<BaseObject> id : fileServer.getAdminServerIds()) {
                System.out.println("\t\tadmin Server id: " + id);
            }
        }
        System.out.println();
    }

    private void printFileServerPlugin(FileServerPlugin fileServerPlugin) {
        System.out.println("File Server Plug-in Id: " + fileServerPlugin.getId());
        System.out.println("\tName: " + fileServerPlugin.getPluginName());
        System.out.println("\tDescription: " + fileServerPlugin.getPluginDescription());
        System.out.println("\tGeneration: " + fileServerPlugin.getGeneration());
        System.out.println("\tVendor: " + fileServerPlugin.getPluginVendor());
        System.out.println("\tVersion: " + fileServerPlugin.getPluginVersion());
        System.out.println("\tExtra Help Information: " + fileServerPlugin.getExtraInfoHelpText());
        System.out.println("\tBacking Device Type: " + (Object)((Object)fileServerPlugin.getBackingDeviceType()));
        System.out.println("\tGeneric Plug-in: " + fileServerPlugin.isGenericPlugin());
        System.out.println("\tCluster Required: " + fileServerPlugin.isClusterRequired());
        System.out.println("\tFile Servers:");
        if (fileServerPlugin.getFileServerIds() != null) {
            for (Id<FileServer> fileServerId : fileServerPlugin.getFileServerIds()) {
                System.out.println("\t\tFile Server id: " + fileServerId);
            }
        }
        System.out.println();
    }

    private void printFileSystem(FileSystem fileSystem) {
        System.out.println("FileSystem Id: " + fileSystem.getId());
        System.out.println("\tName: " + fileSystem.getName());
        System.out.println("\tDescription: " + fileSystem.getDescription());
        System.out.println("\tGeneration: " + fileSystem.getGeneration());
        System.out.println("\tPath: " + fileSystem.getPath());
        System.out.println("\tSize: " + fileSystem.getSize());
        System.out.println("\tFree Size: " + fileSystem.getFreeSize());
        System.out.println("\tFile Servers:");
        if (fileSystem.getFileServerIds() != null) {
            for (Id<FileServer> id : fileSystem.getFileServerIds()) {
                System.out.println("\t\tfile server id: " + id);
            }
        }
        System.out.println("\tFile System Mounts:");
        if (fileSystem.getFileSystemMountIds() != null) {
            for (Id<BaseObject> id : fileSystem.getFileSystemMountIds()) {
                System.out.println("\t\tfile system mount id: " + id);
            }
        }
        System.out.println("\tRepositories:");
        if (fileSystem.getRepositoryIds() != null) {
            for (Id<BaseObject> id : fileSystem.getRepositoryIds()) {
                System.out.println("\t\trepository id: " + id);
            }
        }
        System.out.println();
    }

    private void printFileSystemMount(FileSystemMount fileSystemMount) {
        System.out.println("FileSystemMount Id: " + fileSystemMount.getId());
        System.out.println("\tName: " + fileSystemMount.getName());
        System.out.println("\tDescription: " + fileSystemMount.getDescription());
        System.out.println("\tAbsolute Path: " + fileSystemMount.getAbsolutePath());
        System.out.println("\tShare Path: " + fileSystemMount.getSharePath());
        System.out.println("\tOptions: " + fileSystemMount.getOptions());
        Id<FileSystem> fileSystemId = fileSystemMount.getFileSystemId();
        System.out.println("\tFile System Id:" + fileSystemId);
        Id<Server> serverId = fileSystemMount.getServerId();
        System.out.println("\tServer Id:" + serverId);
        System.out.println();
    }

    private void printJob(Job job) {
        JobError error;
        System.out.println("Job Id: " + job.getId());
        System.out.println("\tUser: " + job.getUser());
        System.out.println("\tStart Time: " + job.getStartTime());
        System.out.println("\tEnd Time: " + job.getEndTime());
        System.out.println("\tRun State: " + (Object)((Object)job.getJobRunState()));
        System.out.println("\tGroup: " + job.isJobGroup());
        System.out.println("\tResult Id: " + job.getResultId());
        try {
            String transcript = this.api.jobGetDebugTranscript(job.getId());
            System.out.println(transcript);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<Id<Job>> jobChildren = job.getChildJobIds();
        if (jobChildren != null) {
            for (Id<Job> childJob : jobChildren) {
                System.out.println("\tChildJob: " + childJob);
            }
        }
        if ((error = job.getError()) != null) {
            System.out.println("\tError Type: " + (Object)((Object)error.getType()));
            System.out.println("\tError Message: " + error.getMessage());
        }
        System.out.println();
    }

    public void waitForJobComplete(OvmWsClient api, Job job) throws WsException {
        this.waitForJobComplete(api, job, null);
    }

    public <T> Id<T> waitForJobComplete(OvmWsClient api, Job job, Class<T> type) throws WsException {
        while (!job.isSummaryDone()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!(job = api.jobGetById(job.getId())).getJobRunState().equals((Object)Job.JobRunState.FAILURE)) continue;
            JobError error = job.getError();
            if (error != null) {
                System.out.println("    error type: " + (Object)((Object)error.getType()));
                System.out.println("    error message: " + error.getMessage());
            }
            System.out.println("    transcript: " + api.jobGetDebugTranscript(job.getId()));
        }
        Id resultId = job.getResultId();
        if (type == null) {
            return resultId;
        }
        Id typedResultId = resultId;
        return typedResultId;
    }

    private static class InsecureTrustManager
    implements X509TrustManager {
        private InsecureTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

