/*
 * Decompiled with CFR 0.152.
 */
package com.xensource.xenapi;

import com.xensource.xenapi.APIVersion;
import com.xensource.xenapi.Session;
import com.xensource.xenapi.Types;
import java.net.URL;
import java.util.Map;
import java.util.TimeZone;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcHttpClientConfig;

public class Connection {
    public static final String BINDINGS_VERSION = "7.4.0";
    private APIVersion apiVersion;
    protected static final int DEFAULT_REPLY_TIMEOUT = 600;
    protected static final int DEFAULT_CONNECTION_TIMEOUT = 5;
    @Deprecated
    protected int _replyWait = 600;
    @Deprecated
    protected int _connWait = 5;
    private String sessionReference;
    private final XmlRpcClient client;
    private XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();

    public APIVersion getAPIVersion() {
        return this.apiVersion;
    }

    public Connection(URL uRL) {
        this.client = this.getClientFromURL(uRL, 600, 5);
    }

    public Connection(URL uRL, int n, int n2) {
        this.client = this.getClientFromURL(uRL, n, n2);
    }

    public Connection(URL uRL, String string) {
        this.client = this.getClientFromURL(uRL, 600, 5);
        this.sessionReference = string;
    }

    public Connection(URL uRL, String string, int n, int n2) {
        this.client = this.getClientFromURL(uRL, n, n2);
        this.sessionReference = string;
    }

    public XmlRpcClientConfigImpl getConfig() {
        return this.config;
    }

    private XmlRpcClient getClientFromURL(URL uRL, int n, int n2) {
        this.config.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.config.setServerURL(uRL);
        this.config.setReplyTimeout(n * 1000);
        this.config.setConnectionTimeout(n2 * 1000);
        XmlRpcClient xmlRpcClient = new XmlRpcClient();
        xmlRpcClient.setConfig((XmlRpcClientConfig)this.config);
        return xmlRpcClient;
    }

    public String getSessionReference() {
        return this.sessionReference;
    }

    protected Map dispatch(String string, Object[] objectArray) throws XmlRpcException, Types.XenAPIException {
        Map map = (Map)this.client.execute(string, objectArray);
        if (string.equals("session.login_with_password") && map.get("Status").equals("Success")) {
            Session session = Types.toSession(map.get("Value"));
            this.sessionReference = session.ref;
            this.setAPIVersion(session);
        } else if (string.equals("session.slave_local_login_with_password") && map.get("Status").equals("Success")) {
            this.sessionReference = Types.toSession(map.get((Object)"Value")).ref;
            this.apiVersion = APIVersion.latest();
        } else if (string.equals("session.logout")) {
            Object[] objectArray2;
            if (map.get("Status").equals("Failure") && (objectArray2 = (Object[])map.get("ErrorDescription")).length == 2 && objectArray2[0].equals("HOST_IS_SLAVE")) {
                try {
                    XmlRpcHttpClientConfig xmlRpcHttpClientConfig = (XmlRpcHttpClientConfig)this.client.getClientConfig();
                    URL uRL = xmlRpcHttpClientConfig.getServerURL();
                    URL uRL2 = new URL(uRL.getProtocol(), (String)objectArray2[1], uRL.getPort(), uRL.getFile());
                    Connection connection = new Connection(uRL2, this.sessionReference, xmlRpcHttpClientConfig.getReplyTimeout(), xmlRpcHttpClientConfig.getConnectionTimeout());
                    Session.logout(connection);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.sessionReference = null;
        }
        return Types.checkResponse(map);
    }

    private void setAPIVersion(Session session) throws Types.XenAPIException, XmlRpcException {
        try {
            long l = session.getThisHost(this).getAPIVersionMajor(this);
            long l2 = session.getThisHost(this).getAPIVersionMinor(this);
            this.apiVersion = APIVersion.fromMajorMinor(l, l2);
        }
        catch (Types.BadServerResponse badServerResponse) {
            this.apiVersion = APIVersion.UNKNOWN;
        }
    }
}

