/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.ovf.CimBoolean;
import com.vmware.vcloud.api.rest.schema.ovf.CimString;
import com.vmware.vcloud.api.rest.schema.ovf.RASDType;
import com.vmware.vcloud.api.rest.schema.ovf.ResourceType;
import com.vmware.vcloud.sdk.HardwareItem;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.constants.IpAddressAllocationModeType;
import com.vmware.vcloud.sdk.constants.NetworkAdapterType;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class VirtualNetworkCard
extends HardwareItem {
    public VirtualNetworkCard(RASDType virtualNetworkCardItem) {
        super(virtualNetworkCardItem);
    }

    public VirtualNetworkCard(Integer nicId, Boolean isConnected, String networkName, Boolean isPrimaryNetworkConnection, IpAddressAllocationModeType ipAddressingMode, String ipAddress) {
        super(new RASDType());
        this.init(nicId, isConnected, networkName, isPrimaryNetworkConnection, ipAddressingMode, ipAddress, NetworkAdapterType.E1000);
    }

    public VirtualNetworkCard(Integer nicId, Boolean isConnected, String networkName, Boolean isPrimaryNetworkConnection, IpAddressAllocationModeType ipAddressingMode, String ipAddress, NetworkAdapterType adapterType) {
        super(new RASDType());
        this.init(nicId, isConnected, networkName, isPrimaryNetworkConnection, ipAddressingMode, ipAddress, adapterType);
    }

    private void init(Integer nicId, Boolean isConnected, String networkName, Boolean isPrimaryNetworkConnection, IpAddressAllocationModeType ipAddressingMode, String ipAddress, NetworkAdapterType adapterType) {
        CimString networkConfig = new CimString();
        networkConfig.setValue(networkName);
        Map cimAttributes = networkConfig.getOtherAttributes();
        cimAttributes.put(new QName("http://www.vmware.com/vcloud/v1.5", "ipAddress", "vcloud"), ipAddress);
        cimAttributes.put(new QName("http://www.vmware.com/vcloud/v1.5", "primaryNetworkConnection", "vcloud"), isPrimaryNetworkConnection.toString());
        cimAttributes.put(new QName("http://www.vmware.com/vcloud/v1.5", "ipAddressingMode", "vcloud"), ipAddressingMode.value());
        CimString elementName = new CimString();
        elementName.setValue("");
        CimString instanceId = new CimString();
        instanceId.setValue("");
        CimString nicIndex = new CimString();
        nicIndex.setValue(nicId.toString());
        CimBoolean connected = new CimBoolean();
        connected.setValue(isConnected.booleanValue());
        ResourceType networkResourceType = new ResourceType();
        networkResourceType.setValue("10");
        CimString resourceSubType = new CimString();
        resourceSubType.setValue(adapterType.value());
        RASDType networkCard = this.getItemResource();
        networkCard.setElementName(elementName);
        networkCard.setInstanceID(instanceId);
        networkCard.setResourceType(networkResourceType);
        networkCard.setResourceSubType(resourceSubType);
        networkCard.setAddressOnParent(nicIndex);
        networkCard.setAutomaticAllocation(connected);
        List networkAttributes = networkCard.getConnection();
        networkAttributes.add(networkConfig);
    }

    public void resetMacAddress() {
        this.getItemResource().setAddress(null);
    }

    public String getMacAddress() {
        return this.getItemResource().getAddress().getValue();
    }

    private String getConnectionAttributeValue(String attributeName) throws VCloudException {
        List connectionCimStrings;
        if (this.getItemResource().getResourceType().getValue().equals("10") && (connectionCimStrings = this.getItemResource().getConnection()).size() > 0) {
            return this.getCimStringAttributeValue((CimString)this.getItemResource().getConnection().get(0), attributeName);
        }
        throw new VCloudException(attributeName + " - " + SdkUtil.getI18nString(SdkMessage.RESOURCE_NOT_FOUND_MSG));
    }

    public String getIpAddress() throws VCloudException {
        return this.getConnectionAttributeValue("ipAddress");
    }

    public void updateIpAddress(String ipAddress) throws VCloudException {
        if (this.getItemResource().getConnection().size() == 0) {
            throw new VCloudException("Nic does not contain Ip for update");
        }
        Map connectionAttributes = ((CimString)this.getItemResource().getConnection().get(0)).getOtherAttributes();
        for (QName attr : connectionAttributes.keySet()) {
            if (!attr.getLocalPart().equals("ipAddress")) continue;
            connectionAttributes.put(attr, ipAddress);
        }
    }

    public void updateNetwork(String networkName) throws VCloudException {
        if (this.getItemResource().getConnection().size() == 0) {
            throw new VCloudException("Nic does not contain network for update");
        }
        ((CimString)this.getItemResource().getConnection().get(0)).setValue(networkName);
    }

    public String getNetwork() throws VCloudException {
        if (this.getItemResource().getConnection().size() == 0) {
            throw new VCloudException("Nic is not attached to any network");
        }
        return ((CimString)this.getItemResource().getConnection().get(0)).getValue();
    }

    public boolean isPrimaryNetworkConnection() throws VCloudException {
        return Boolean.parseBoolean(this.getConnectionAttributeValue("primaryNetworkConnection"));
    }

    public String getIpAddressingMode() throws VCloudException {
        return this.getConnectionAttributeValue("ipAddressingMode");
    }

    public boolean isConnected() throws VCloudException {
        return this.getItemResource().getAutomaticAllocation().isValue();
    }
}

