/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin.extensions;

import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.api.rest.schema.extension.StrandedItemType;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.Task;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrandedItem
extends VcloudEntity<StrandedItemType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");

    StrandedItem(VcloudClient client, StrandedItemType strandedItemResource) {
        super(client, strandedItemResource);
    }

    public static StrandedItem getStrandedItemByReference(VcloudClient client, ReferenceType reference) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + reference.getHref());
        return new StrandedItem(client, (StrandedItemType)StrandedItem.getResourceByReference(client, reference));
    }

    public static StrandedItem getStrandedItemById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new StrandedItem(client, (StrandedItemType)StrandedItem.getEntityById(client, vCloudId, "application/vnd.vmware.admin.strandedItem+xml"));
    }

    public Task delete() throws VCloudException {
        String deleteUrl = this.getReference().getHref();
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.delete(this.getVcloudClient(), deleteUrl, 202));
    }

    public static Task delete(VcloudClient client, ReferenceType strandedItemRef) throws VCloudException {
        String strandedItemUrl = strandedItemRef.getHref();
        return new Task(client, (TaskType)SdkUtil.delete(client, strandedItemUrl, 202));
    }

    public Task forceDelete() throws VCloudException {
        String forceDelURL = this.getReference().getHref() + "/action/forceDelete";
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), forceDelURL, null, null, 202));
    }

    public static Task forceDelete(VcloudClient client, ReferenceType strandedItemRef) throws VCloudException {
        String forceDeleteURL = strandedItemRef.getHref() + "/action/forceDelete";
        return new Task(client, (TaskType)SdkUtil.post(client, forceDeleteURL, null, null, 202));
    }
}

