#import "EGPluginEventsHandler.h"
#import <eGMobileAPM/eGMobileAPM-Swift.h>



@interface EGPluginEventsHandler ()

@property (strong, nonatomic) EGPluginCallValidator *callValidator;

@end

@implementation EGPluginEventsHandler

- (instancetype)initWithCallValidator:(EGPluginCallValidator *)validator {
    if (self = [super init]) {
        _callValidator = validator;
    }
    
    return self;
}

#pragma mark - FlutterPlugin -

+ (void)registerWithRegistrar:(nonnull NSObject<FlutterPluginRegistrar> *)registrar {}

- (void)handleMethodCall:(FlutterMethodCall *)call result:(FlutterResult)result {

    if ([self.callValidator eventMethodSupported:call.method]) {
        // Validate arguments
        NSError *validationError = nil;
        if (![self.callValidator argumentsValid:call.arguments
                                           call:call.method       
                                          error:&validationError]) {
            result(validationError.localizedDescription);
            return;
        }
        
        // Handle call
        // HTTP monitor
        
        if ([call.method isEqualToString:kHTTPRequestMethodName]) {
            [self handleHTTPRequestCall:call.arguments result:result];
        }
        
        if ([call.method isEqualToString:kLogScreenName]) {
            [self handleHTTPRequestCall:call.arguments result:result];
        }
        
        if ([call.method isEqualToString:kHTTPResponseMethodName]) {
            [self handleHTTPResponseCall:call.arguments result:result];
        }
        
    } else {
        result(FlutterMethodNotImplemented);
    }
}

#pragma mark - Call handlers -
#pragma mark - HTTP monitor

- (void)handleHTTPRequestCall:(EGPluginMethodArgumentsList *)arguments result:(FlutterResult)result {
    // Build event payload
    NSDictionary *payload = @{ @"uuid"          : arguments[@"uid"],
                               @"url"           : arguments[@"url"],
                               @"method"        : arguments[@"method"],
                               @"body"          : [self unwrapData:arguments[@"body"]],
                               @"hasLargeBody"  : @(NO),
                               @"headers"       : arguments[@"headers"] };
    [egAPM.sharedInstance sendEventWithMonitorID:@"http-request" eventID:@"http-request" payload:payload];
    result(@"Ok");
}


- (void)handleHTTPResponseCall:(EGPluginMethodArgumentsList *)arguments result:(FlutterResult)result {
    // Build event payload
    NSDictionary *payload = @{ @"uuid"              : arguments[@"uid"],
                               @"statusCode"        : arguments[@"code"],
                               @"body"              : [self unwrapData:arguments[@"body"]],
                               @"hasLargeBody"      : @(NO),
                               @"headers"           : arguments[@"headers"],
                               @"responseDuration"  : arguments[@"tookMs"],
                               @"error"             : @"" };
    [egAPM.sharedInstance sendEventWithMonitorID:@"http-response" eventID:@"http-response" payload:payload];
    result(@"Ok");
}

#pragma mark - Tools

- (NSData *)unwrapData:(id)flutterData {
    NSData *unwrappedData = [NSData data];
    if ([flutterData isKindOfClass:[FlutterStandardTypedData class]]) {
        unwrappedData = [(FlutterStandardTypedData *)flutterData data];
    }
    
    return unwrappedData;
}

@end
