import 'package:plugin_platform_interface/plugin_platform_interface.dart';

import 'eginnovations_method_channel.dart';

abstract class EginnovationsPlatform extends PlatformInterface {
  /// Constructs a EginnovationsPlatform.
  EginnovationsPlatform() : super(token: _token);

  static final Object _token = Object();

  static EginnovationsPlatform _instance = MethodChannelEginnovations();

  /// The default instance of [EginnovationsPlatform] to use.
  ///
  /// Defaults to [MethodChannelEginnovations].
  static EginnovationsPlatform get instance => _instance;
  
  /// Platform-specific implementations should set this with their own
  /// platform-specific class that extends [EginnovationsPlatform] when
  /// they register themselves.
  static set instance(EginnovationsPlatform instance) {
    PlatformInterface.verifyToken(instance, _token);
    _instance = instance;
  }

  Future<String?> getPlatformVersion() {
    throw UnimplementedError('platformVersion() has not been implemented.');
  }
}
