/*******************************************************************************
 *      File name               :   MakePurchase.java
 *      Purpose                 :   creates delay with database for JtmDemo
 *      Creation Date           :   27-03-2012
 ******************************************************************************/

package app.com.src;
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*; 
import java.sql.* ;
import com.eg.EgDbInfo;
import egurkha.EgDbAdapterUI;
import com.eg.EgDbAdapterTypeUI;
import com.eg.EgDbInfo;

public class MakePurchase extends HttpServlet
{
	ResultSet rs=null;
	PreparedStatement ps = null;
	
	public void doPost(HttpServletRequest request,HttpServletResponse response)
						throws ServletException,IOException
	{
		HttpSession session = request.getSession(true); 
		PrintWriter out = response.getWriter();
		response.setContentType("text/html");
		String finish=request.getParameter("finish");
		if(finish!=null)
		{
			if(finish.equals("true"))
			{
				checkOut();
			}
			else
			{
				return;
			}
		}
	}
	public void checkOut()
	{
		try
		{
			Thread.sleep(40);
		}
		catch(InterruptedException e)
		{
			e.printStackTrace();
		}
		addItems();
	}
	public void addItems()
	{
		try
		{
			Thread.sleep(50);
		}
		catch(InterruptedException e)
		{
			e.printStackTrace();
		}
		updateItems();
	}
	public void updateItems()
	{
		try
		{
			Thread.sleep(70);
		}
		catch(InterruptedException e)
		{
			e.printStackTrace();
		}
		addToList();
	}
	public void addToList()
	{
		try
		{
			Thread.sleep(63);
		}
		catch(InterruptedException e)
		{
			e.printStackTrace();
		}
		customerAuthentication();
	}
	public void customerAuthentication()
	{
		try
		{
			Thread.sleep(53);
		}
		catch(InterruptedException e)
		{
			e.printStackTrace();
		}
		validateName();
	}
	public void validateName()
	{
		try
		{
			Thread.sleep(75);
		}
		catch(InterruptedException e)
		{
			e.printStackTrace();
		}
		searchWithDB();
	}
	public void searchWithDB()
	{
		String query="";
		if(EgDbInfo.checkDBType().equals("EgMsSqlAdapter"))
		{
			query=" SELECT top 10000 t.TEXT AS sqlstatement, s.execution_count AS ExecutionCount, s.max_elapsed_time AS MaxElapsedTime, s.creation_time AS LogCreatedOn, Datediff(MINUTE,a.last_batch, Getdate()) RunningTime,a.spid,a.blocked,a.waittime,Db_name(a.dbid) AS dbname,a.last_batch,a.hostname,a.program_name,a.nt_username,a.loginame FROM sys.dm_exec_query_stats s CROSS APPLY sys.sysprocesses A CROSS APPLY sys.Dm_exec_sql_text(s.sql_handle) t ORDER BY s.max_elapsed_time DESC,ExecutionCount DESC";
		}
		else
		{
			query = "select username, user_id, created,(select count(*) from all_constraints where owner = all_users.username) cons,(select count(*) from all_tables where owner=username) tables from all_users";
			
			/*
			query=" select u.username, u.user_id, u.created, a.concnt, b.tabcnt from all_users u, (select owner, count(CONSTRAINT_NAME) concnt from all_constraints group by owner) a,(select owner, count(TABLE_NAME) tabcnt from all_tables group by owner) b where u.username = a.owner (+) and u.username = b.owner (+)";
			*/
		}

		EgDbAdapterUI egDb = EgDbAdapterTypeUI.getObject();
		try
		{
			Connection conn = egDb.setConnection1();
			if(conn!=null)
			{
				rs = dbSelect(query,conn);
			}
			rs.close();
		}
		catch(Exception e)
		{
			System.out.println("Exception occured!!!!");
			e.printStackTrace();
		}
		finally
		{
			egDb.releaseConnection(false);
			EgDbAdapterTypeUI.releaseObject(egDb);
		}
		validUser();
	}
	public void validUser()
	{
		try
		{
			Thread.sleep(70);
		}
		catch(InterruptedException e)
		{
			e.printStackTrace();
		}
		calculateTotal();
	}
	public void calculateTotal()
	{
		try
		{
			Thread.sleep(40);
		}
		catch(InterruptedException e)
		{
			e.printStackTrace();
		}
		makePayment();
	}
	public void makePayment()
	{
		try
		{
			Thread.sleep(65);
		}
		catch(InterruptedException e)
		{
			e.printStackTrace();
		}
		payMode();
	}
	public void payMode()
	{
		try
		{
			Thread.sleep(56);
		}
		catch(InterruptedException e)
		{
			e.printStackTrace();
		}
		billPay();
	}
	public void billPay()
	{
		try
		{
			Thread.sleep(45);
		}
		catch(InterruptedException e)
		{
			e.printStackTrace();
		}
		return;
	}

	public ResultSet dbSelect(String query,Connection conn)
	{
		try
		{
			if (rs != null)
			{
				try
				{
					rs.close();
				}
				catch (Exception e)
				{
				}
				rs = null;
			}
			if (ps != null)
			{
				try
				{
					ps.close();
				}
				catch (Exception ex)
				{
				}
			}
			try
			{
				Thread.sleep(100);
			}
			catch(InterruptedException e)
			{
				e.printStackTrace();
			}

			ps = conn.prepareStatement(query);
			rs = ps.executeQuery();
		}
		catch (SQLException e)
		{
			System.out.println("Error in dbselect:" + e);
		}
		return rs;
	}


	public void doGet(HttpServletRequest request,HttpServletResponse response)
						throws ServletException,IOException
	{
		doPost(request,response);
	}
}