import React from "react";
import Mitt from "../mitt";
import StorybookSwitcher from "./storybook";
/**
 * A plugin which provides .storybookSwitcher() on eG.
 */
export default (function () { return function () {
    var emitter = Mitt();
    return {
        onCommand: function (command) {
            if (command.type !== "storybook")
                return;
            // relay this payload on to the emitter
            emitter.emit("storybook", command.payload);
        },
        features: {
            storybookSwitcher: function (storybookUi) { return function (WrappedComponent) { return function (props) { return (<StorybookSwitcher storybookUi={storybookUi} emitter={emitter}>
          <WrappedComponent {...props}/>
        </StorybookSwitcher>); }; }; },
        },
    };
}; });
