
import { eG } from "../eg-core-client"


/**
 * Sends API request/response information.
 */
export default () => (eg: eG) => {
  return {
    features: {
      apiResponse: (request, response, duration) => {
       if (request.url != null && request.url.indexOf(eg.host) > -1) {
         return;
        }
        const ok = 
        
          response &&
          response.status &&
          typeof response.status === "number" &&
          response.status >= 200 &&
          response.status <= 299
          console.log("ok ----"+ok)
          console.log("request.url ----" + request.url);
          console.log("isRemoteCall(request.url) ----" + !isLocalCall(request.url));
          console.log("duration ----" + duration);
        const important = !ok
        if(!isLocalCall(request.url)) {
           let httpInformation = getHTTPJSONData(request, response, duration)
           eg.send("HTTP", httpInformation, important)
        } else {
          let pageInformation = getPageJSONData(request, response, duration)
          eg.send("Page", pageInformation, important)
        }
      },
    },
  }
}


function isLocalCall(hostname){
  var isLocal = false;
  console.log('hostname:::'+hostname);
  isLocal = ( "undefined" === typeof(hostname) 
      || (hostname.startsWith('file://'))
      || (hostname.indexOf('localhost') > -1)
      || (hostname.indexOf('127.0.0.1') > -1)
      || (hostname.indexOf('192.168.') > -1)
      || (hostname.indexOf('10.0.') > -1)
      || (hostname.indexOf('.local') > -1)
      || ['localhost', '127.0.0.1', '192.168.','10.0.', '::1'].includes(hostname)
    )
    // console.log('isLocal:::'+isLocal);
  return isLocal;
}

function getHTTPJSONData(request, response, duration) {
  return {"url":request.url, "httpMethod": request.method, "statusCode": response.status, "bytesSent":(request.data!=null?request.data.toString().length:0), "bytesReceived":response.body.toString().length, "startTime": 0, "endTime": 0, "executionTime": duration, "errorCode":"", "errorMessage":""}
  
}

function getPageJSONData(request, response, duration) {
  return {"page":request.url,"title":"", "httpMethod": request.method, "statusCode": response.status, "bytesSent":(request.data!=null?request.data.toString().length:0), "bytesReceived":response.body.toString().length, "startTime": 0, "endTime": 0, "executionTime": duration, "errorCode":"", "errorMessage":""}
  
}