<%
/*
 *   File			:	EgConfigureVCTaskspJson.jsp
 *   Purpose		:	Processing page for configuring tasks for vCenter server
*/
%>
<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "java.util.*" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgServicesInfo" %>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.egurkha.admin.AuditLogThread" %>
<%@ page import = "net.sf.json.*" %>

<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%
	JSONObject rootJson = new JSONObject();
	String strIncludedTasks = request.getParameter("strIncludedTasks");
	String strExcludedTasks = request.getParameter("strExcludedTasks");
	String descriptor = request.getParameter("descriptor");
	String strTestAndDescriptor = "VCTaskEvtTest:"+descriptor.trim();
	String taskEntry = "";

	ArrayList aListIncludedTasks = new ArrayList();
	ArrayList aListExcludedTasks = new ArrayList();

	StringTokenizer eTokens = new StringTokenizer(strExcludedTasks,",");
	while (eTokens.hasMoreTokens())
	{
		String thisToken = eTokens.nextToken().trim();
		aListExcludedTasks.add(thisToken);
	}

	StringTokenizer iTokens = new StringTokenizer(strIncludedTasks,",");
	while (iTokens.hasMoreTokens())
	{
		String token = iTokens.nextToken().trim();
		aListIncludedTasks.add(token);
	}

	if (aListExcludedTasks.size() == 0)
	{
		taskEntry = "all:none";
	}
	else if (aListIncludedTasks.size() == 0)
	{
		taskEntry = "none:all";
	}
	else if (aListIncludedTasks.size() >= aListExcludedTasks.size())
	{
		taskEntry = "all:"+strExcludedTasks;
	}
	else if (aListIncludedTasks.size() < aListExcludedTasks.size())
	{
		taskEntry = strIncludedTasks+":none";
	}
	IniFile ini = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_tests.ini",true);
	ini.setValue("VCTaskFilterTypes",strTestAndDescriptor,taskEntry);
	ini.saveFile(); 
	EgConfigFilesSync.releaseInstance(ini);

	//auditlog - starts
	
	EgServicesInfo serviceInfo = new EgServicesInfo("manager");
	boolean isAuditLogEnabled = serviceInfo.isAuditlogEnabled();
	if (isAuditLogEnabled)
	{
		String prevIncludedTasks = request.getParameter("prevIncludedTasks");
		String prevExcludedTasks = request.getParameter("prevExcludedTasks");

		prevIncludedTasks = (prevIncludedTasks !=null)?prevIncludedTasks:"";
		prevExcludedTasks = (prevExcludedTasks !=null)?prevExcludedTasks:"";

		ArrayList aListprevIncludedTasks = new ArrayList();
		ArrayList aListprevExcludedTasks = new ArrayList(); 

		StringTokenizer iTok = new StringTokenizer(prevIncludedTasks,",");
		while (iTok.hasMoreTokens())
		{
			String prevInclTasks = iTok.nextToken().trim();
			aListprevIncludedTasks.add(prevInclTasks);
		}

		StringTokenizer eTok = new StringTokenizer(prevExcludedTasks,",");
		while (eTok.hasMoreTokens())
		{
			String prevExclTasks = eTok.nextToken().trim();
			aListprevExcludedTasks.add(prevExclTasks);
		}

		ArrayList aListNewInclTask = (ArrayList)aListprevExcludedTasks.clone();
		aListNewInclTask.removeAll(aListExcludedTasks);
		ArrayList aListNewExclTask = (ArrayList)aListprevIncludedTasks.clone();
		aListNewExclTask.removeAll(aListIncludedTasks);

		boolean allowAuditLogOperation = true;

		if (aListNewInclTask.isEmpty() && aListNewExclTask.isEmpty())
		{
			allowAuditLogOperation = false;
		}

		if (allowAuditLogOperation)
		{
			AuditLogThread auditLogThread = new AuditLogThread();
			auditLogThread.setValue("Category","Admin");
			auditLogThread.setValue("User_id",_user.getLoginID());
			auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
			auditLogThread.setValue("Session_id",session.getId());
			auditLogThread.setValue("Module","vCenter Tasks");
			auditLogThread.setValue("Description","vCenter Tasks have been configured with "+descriptor);

			if (!aListNewInclTask.isEmpty() && !aListNewExclTask.isEmpty())
			{
				auditLogThread.setValue("Activity","Included/Excluded Tasks");
			}
			else if (!aListNewInclTask.isEmpty() && aListNewExclTask.isEmpty())
			{
				auditLogThread.setValue("Activity","Included Tasks");
			}
			else if (aListNewInclTask.isEmpty() && !aListNewExclTask.isEmpty())
			{
				auditLogThread.setValue("Activity","Excluded Tasks");
			}

			for (int i=0; i<aListNewInclTask.size(); i++)
			{
				String inclTasks = (String)aListNewInclTask.get(i);
				if (inclTasks != null && 
					!inclTasks.equalsIgnoreCase("null") && 
					inclTasks.trim().length() > 0)
				{
					auditLogThread.setCurrentValue("INCLUDED TASK(S)",inclTasks);
				}
			}

			for (int i=0; i<aListNewExclTask.size(); i++)
			{
				String exclTasks = (String)aListNewExclTask.get(i);
				if (exclTasks != null && 
					!exclTasks.equalsIgnoreCase("null") && 
					exclTasks.trim().length() > 0)
				{
					auditLogThread.setCurrentValue("EXCLUDED TASK(S)",exclTasks);
				}
			}

			auditLogThread.sendItToDB();
		}
	}
	//for auditlog - ends

	rootJson.put("success","true");
	System.out.println("rootJson__________"+rootJson);
	out.println(rootJson.toString());
%>



