<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page import="com.eg.*"%>
<%@ page import="com.egurkha.*"%>
<%@ page import="com.egurkha.util.*"%>
<%@ page import="egurkha.reporter.*"%>
<%@ page import="java.text.*"%>
<%@ page import="net.sf.json.*"%>

<%@ page language="java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	JSONObject rootJson = new JSONObject();

	String username = request.getParameter("username");
	String selectedCompType = request.getParameter("usercmdtype");

	selectedCompType = (selectedCompType == null  || selectedCompType.trim().length()==0 ||  selectedCompType.trim().equalsIgnoreCase("null")) ? "-1" : selectedCompType;

	boolean isValidUser = username != null && (username=username.trim()).length()>0 && 
		!username.equalsIgnoreCase("null") && !username.equalsIgnoreCase("-1") && 
		!username.equalsIgnoreCase("egenterprise");

	boolean isUsersCreated = false;
	String defaultSelType = isValidUser ? "Select a component type" : "Not Applicable";

	JSONArray commandtype = new JSONArray();
	JSONObject commandtypeObj = new JSONObject();
	commandtypeObj.put("displayField",_mapping.getTextDescription("admin.remote."+defaultSelType));
	commandtypeObj.put("valueField","-1");
	commandtype.add(commandtypeObj);
	Vector virtualization_platforms=null;
	IniFile uiIni=null;
	ErUserData userData = null;
	if(isValidUser)
	{
		userData = new ErUserData(username,false);
		IniFile egInfra=new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_infrastructure.ini");
		virtualization_platforms=egInfra.getVariables("VIRTUALIZATION_PLATFORMS",true);
		uiIni=new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_ui.ini");
		//code for component type list box
		Hashtable order = new Hashtable();
		Vector serverTypesForUser = userData.getServerTypes();
		for(int i=0;i<serverTypesForUser.size();i++)
		{
			String compType = (String)serverTypesForUser.get(i);
			order.put(_mapping.getComponentTypeDescription(compType),compType);
		}
		ArrayList lablesInOrder=new ArrayList();
		lablesInOrder.addAll(order.keySet());
		Collections.sort(lablesInOrder,String.CASE_INSENSITIVE_ORDER);
		for(int i=0;i<lablesInOrder.size();i++)
		{
			String label = (String)lablesInOrder.get(i);
			String compType = (String)order.get(label);
			commandtypeObj.put("displayField",_mapping.getComponentTypeDescription(compType));
			commandtypeObj.put("valueField",compType);
			commandtype.add(commandtypeObj);
		}
	}
	rootJson.put("commandtype",commandtype);

	JSONArray disabledCommands = new JSONArray();
	JSONArray allCommandsObj = new JSONArray();
	JSONObject allCmdObj = new JSONObject();

	String checkEnabledTasks = "";
	String checkDisabledTasks = "";
	if(isValidUser && !selectedCompType.equalsIgnoreCase("-1"))
	{
		IniFile userCommandsIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_usercommands.ini");
		ArrayList permittedCommandIds = new ArrayList();
		String alreadyPermittedOsCmds = userCommandsIni.getValue("ALLOWED_COMMANDS",username);
		alreadyPermittedOsCmds = alreadyPermittedOsCmds.trim();

		if(alreadyPermittedOsCmds != null && (alreadyPermittedOsCmds=alreadyPermittedOsCmds.trim()).length()>0 && !alreadyPermittedOsCmds.equalsIgnoreCase("null"))
		{
			boolean found=false;
			String searchKey=","+selectedCompType+"|";
			String array[]=StringUtils.getTokens(alreadyPermittedOsCmds,"#");
			for(int i=0;i<array.length;i++)
			{
				String str=","+array[i];
				if(str.startsWith(searchKey))
				{
					str=array[i];
					alreadyPermittedOsCmds=str.substring(str.indexOf("|")+1);
					found=true;
				}
			}
			if(found)
			{
				permittedCommandIds = StringUtils.myTokenizer(alreadyPermittedOsCmds,",");
			}
			if(permittedCommandIds == null)
			{
				permittedCommandIds = new ArrayList();
			}
		}
		Set uniqueOSNames=new TreeSet();
		String key=selectedCompType+":";
		List userServers=null;
		if(userData !=null)
		{
			userServers=userData.usr.getServers(false);
		}
		if(userServers != null)
		{
			EgExternalInfo e = new EgExternalInfo("manager");
			Iterator itr = userServers.iterator();
			while(itr.hasNext())
			{
				String hostName = (String)itr.next();
				if(hostName.startsWith(key))
				{
					int idx=hostName.indexOf(":");
					String compType=hostName.substring(0,idx);
					hostName=hostName.substring(idx+1);
					hostName=hostName.substring(0,hostName.indexOf(":"));

					boolean isAgentBased=isServerAgentBased(hostName,compType);
					String internalAgentHostName = e.getAgentFor(hostName,true);
					if(internalAgentHostName == null || internalAgentHostName.trim().length()==0 || internalAgentHostName.trim().equalsIgnoreCase("null"))
					{
						internalAgentHostName=hostName;
					}
					String agentOS = null;
					if(isAgentBased)
					{	
						agentOS = AgentConfig.getAgentConfig().getAgentOS(internalAgentHostName);
					}
					else
					{
						String rmtOrExtAgentIp = null;
						String remoteAgent = e.getRemoteAgentForHost(hostName);					
						if(!StringUtils.isNull(remoteAgent))
						{
							rmtOrExtAgentIp = remoteAgent;
						}
						else
						{
							String[] externalAgentsArr = e.getExternalAgentsForHost(hostName);
							if(externalAgentsArr != null)
							{
								String externalAgent = externalAgentsArr[0];
								if(externalAgent != null && !(externalAgent.trim().equals("")))
								{
									rmtOrExtAgentIp = externalAgent;
								}
							}	
						}
						if(!StringUtils.isNull(rmtOrExtAgentIp))
						{
							agentOS = AgentConfig.getAgentConfig().getAgentOS(rmtOrExtAgentIp);
						}
					}
					if(agentOS == null)
					{
						continue;
					}
					if(agentOS.toUpperCase().indexOf("AIX")>-1)
					{
						uniqueOSNames.add("AIX");
					}
					else if(agentOS.toUpperCase().indexOf("HPUX")>-1)
					{
						uniqueOSNames.add("HPUX");
					}
					else if(agentOS.toUpperCase().indexOf("LINUX")>-1)
					{
						uniqueOSNames.add("Linux");
					}
					else if(agentOS.toUpperCase().indexOf("SOLARIS")>-1) 
					{
						uniqueOSNames.add("Solaris");
					}
					else if(agentOS.toUpperCase().indexOf("WINDOWS")>-1)
					{
						uniqueOSNames.add("Windows");
					}
				}
			}
		}
		boolean isMultpleOSFound=(uniqueOSNames.size()>1);
		String osname[]=(String[])uniqueOSNames.toArray(new String[uniqueOSNames.size()]);
		for(int i=0;i<osname.length;i++)
		{
			Hashtable cmdMap = new Hashtable();
			String thisOS=osname[i];
			String groupName=thisOS+" Operating System";
			String subject=thisOS.toUpperCase()+"_COMMANDS";
			Vector cmdIds = uiIni.getVariables(subject,true);
			Vector cmdLabels = uiIni.getAllValues(subject);
			if(cmdLabels != null)
			{
				for(int j=0;j<cmdLabels.size();j++)
				{
					String str = (String)cmdLabels.get(j);
					str = str.substring(0,str.indexOf("|"));
					cmdLabels.set(j,str);
				}
			}
			if(cmdIds != null)
			{
				int cmdCount = cmdIds.size();
				for(int j=0;j<cmdCount;j++)
				{
					String cmdId = (String)cmdIds.get(j);
					String cmdLabel =(String)cmdLabels.get(j);
					cmdMap.put(cmdLabel,cmdId);
				}
			}
			List cmdList = new ArrayList(cmdMap.keySet());
			Collections.sort(cmdList,String.CASE_INSENSITIVE_ORDER);
			Iterator itr = cmdList.iterator();
			while(itr.hasNext())
			{
				String displayCmd = (String)itr.next();
				String actualCmd = (String)cmdMap.get(displayCmd);
				if(isMultpleOSFound)
				{
					allCmdObj.put("displayField",displayCmd+" ("+thisOS+")");
				}
				else
				{
					allCmdObj.put("displayField",displayCmd);
				}
				allCmdObj.put("valueField",actualCmd);
				allCmdObj.put("groupField",groupName);
				allCommandsObj.add(allCmdObj);
				if(!permittedCommandIds.contains(actualCmd))
				{
					disabledCommands.add(actualCmd);
					checkDisabledTasks += ","+actualCmd;
				}
				else
				{
					checkEnabledTasks += ","+actualCmd;
				}
			}
			if(subject.equalsIgnoreCase("WINDOWS_COMMANDS"))
			{
				Vector cmdIds1 = uiIni.getVariables("WINDOWS_RCA_COMMANDS",true);
				Vector cmdLabels1 = uiIni.getAllValues("WINDOWS_RCA_COMMANDS");
				if(cmdIds1 != null && !cmdIds1.isEmpty())
				{
					cmdMap.clear();
					cmdIds.clear();
					cmdLabels.clear();
					for(int j=0;j<cmdLabels1.size();j++)
					{
						String str = (String)cmdLabels1.get(j);
						str = str.substring(0,str.indexOf("|"));
						if(!cmdLabels.contains(str))
						{
							cmdIds.add(cmdIds1.get(i));
							cmdLabels.add(str);
							cmdMap.put(str,cmdIds1.get(i));
						}
					}
					cmdList = new ArrayList(cmdMap.keySet());
					Collections.sort(cmdList,String.CASE_INSENSITIVE_ORDER);
					itr = cmdList.iterator();
					while(itr.hasNext())
					{
						String displayCmd = (String)itr.next();
						String actualCmd = (String)cmdMap.get(displayCmd);
						allCmdObj.put("displayField",displayCmd);
						allCmdObj.put("valueField",actualCmd);
						allCmdObj.put("groupField",groupName);
						allCommandsObj.add(allCmdObj);
						if(!permittedCommandIds.contains(actualCmd))
						{
							disabledCommands.add(actualCmd);
							checkDisabledTasks += ","+actualCmd;
						}
						else
						{
							checkEnabledTasks += ","+actualCmd;
						}
					}
				}
			}
			Set compTypeSpecifcTasks=new TreeSet();
			Vector vars = uiIni.getVariables("COMP_TYPE_TEST_NAME_RC",true);
			Vector vals = uiIni.getAllValues("COMP_TYPE_TEST_NAME_RC");
			if(vars != null && !vars.isEmpty())
			{
				for(int j=0;j<vars.size();j++)
				{
					String str = (String)vars.get(j);
					if(str.startsWith(key))
					{
						String val=(String)vals.get(j);
						String arr[]=StringUtils.getTokens(val,",");
						compTypeSpecifcTasks.addAll(Arrays.asList(arr));
					}
				}
			}
			if(!compTypeSpecifcTasks.isEmpty())
			{
				String compTypeLabel=_mapping.getComponentTypeDescription(selectedCompType);
				Vector cmdIds2 = uiIni.getVariables("WINDOWS_COMMANDS_REMOTE_CONTROL",true);
				Vector cmdLabels2 = uiIni.getAllValues("WINDOWS_COMMANDS_REMOTE_CONTROL");
				if(cmdIds2 != null && !cmdIds2.isEmpty())
				{
					cmdMap.clear();
					cmdIds.clear();
					cmdLabels.clear();
					for(int j=0;j<cmdLabels2.size();j++)
					{
						String cmdIdNow = (String)cmdIds2.get(j);
						if(compTypeSpecifcTasks.contains(cmdIdNow))
						{
							continue;
						}
						String str = (String)cmdLabels2.get(j);
						if(!cmdLabels.contains(str))
						{
							cmdIds.add(cmdIds2.get(j));
							cmdLabels.add(str);
							cmdMap.put(str,cmdIds2.get(j));
						}
					}
					cmdList = new ArrayList(cmdMap.keySet());
					Collections.sort(cmdList,String.CASE_INSENSITIVE_ORDER);
					itr = cmdList.iterator();
					while(itr.hasNext())
					{
						String displayCmd = (String)itr.next();
						String actualCmd = (String)cmdMap.get(displayCmd);
						allCmdObj.put("displayField",displayCmd);
						allCmdObj.put("valueField",actualCmd);
						allCmdObj.put("groupField",compTypeLabel);
						allCommandsObj.add(allCmdObj);
						if(!permittedCommandIds.contains(actualCmd))
						{
							disabledCommands.add(actualCmd);
							checkDisabledTasks += ","+actualCmd;
						}
						else
						{
							checkEnabledTasks += ","+actualCmd;
						}
					}
				}
			}
			if(virtualization_platforms.contains(selectedCompType))
			{
				if(uniqueOSNames.contains("Windows"))
				{
					Vector cmdIds1 = uiIni.getVariables("WINDOWS_VMAGENT_COMMANDS",true);
					Vector cmdLabels1 = uiIni.getAllValues("WINDOWS_VMAGENT_COMMANDS");
					if(cmdIds1 != null && !cmdIds1.isEmpty())
					{
						cmdMap.clear();
						cmdIds.clear();
						cmdLabels.clear();
						for(int j=0;j<cmdLabels1.size();j++)
						{
							String str = (String)cmdLabels1.get(j);
							str = str.substring(0,str.indexOf("|"));
							if(!cmdLabels.contains(str))
							{
								cmdIds.add(cmdIds1.get(i));
								cmdLabels.add(str);
								cmdMap.put(str,cmdIds1.get(i));
							}
						}
						cmdList = new ArrayList(cmdMap.keySet());
						Collections.sort(cmdList,String.CASE_INSENSITIVE_ORDER);
						itr = cmdList.iterator();
						while(itr.hasNext())
						{
							String displayCmd = (String)itr.next();
							String actualCmd = (String)cmdMap.get(displayCmd);
							allCmdObj.put("displayField",displayCmd);
							allCmdObj.put("valueField",actualCmd);
							allCmdObj.put("groupField","Windows VM Agent");
							allCommandsObj.add(allCmdObj);
							if(!permittedCommandIds.contains(actualCmd))
							{
								disabledCommands.add(actualCmd);
								checkDisabledTasks += ","+actualCmd;
							}
							else
							{
								checkEnabledTasks += ","+actualCmd;
							}
						}

					}
				}
				if(uniqueOSNames.contains("Linux"))
				{
					Vector cmdIds1 = uiIni.getVariables("LINUX_VMAGENT_COMMANDS",true);
					Vector cmdLabels1 = uiIni.getAllValues("LINUX_VMAGENT_COMMANDS");
					if(cmdIds1 != null && !cmdIds1.isEmpty())
					{
						cmdMap.clear();
						cmdIds.clear();
						cmdLabels.clear();
						for(int j=0;j<cmdLabels1.size();j++)
						{
							String str = (String)cmdLabels1.get(j);
							str = str.substring(0,str.indexOf("|"));
							if(!cmdLabels.contains(str))
							{
								cmdIds.add(cmdIds1.get(i));
								cmdLabels.add(str);
								cmdMap.put(str,cmdIds1.get(i));
							}
						}
						cmdList = new ArrayList(cmdMap.keySet());
						Collections.sort(cmdList,String.CASE_INSENSITIVE_ORDER);
						itr = cmdList.iterator();
						while(itr.hasNext())
						{
							String displayCmd = (String)itr.next();
							String actualCmd = (String)cmdMap.get(displayCmd);
							allCmdObj.put("displayField",displayCmd);
							allCmdObj.put("valueField",actualCmd);
							allCmdObj.put("groupField","Linux VM Agent");
							allCommandsObj.add(allCmdObj);
							if(!permittedCommandIds.contains(actualCmd))
							{
								disabledCommands.add(actualCmd);
								checkDisabledTasks += ","+actualCmd;
							}
							else
							{
								checkEnabledTasks += ","+actualCmd;
							}
						}
					}
				}
			}
		}
	}

	rootJson.put("selectedCommand",selectedCompType);
	rootJson.put("allCommands",allCommandsObj);
	rootJson.put("disabledCommands",disabledCommands);
	rootJson.put("checkEnabledTasks",checkEnabledTasks);
	rootJson.put("checkDisabledTasks",checkDisabledTasks);

	String userStatus = request.getParameter("accountType");
	//userStatus = "active";//we support only this user type
	EgUuidInfo egUuidInfo = new EgUuidInfo();
	IniFile inifile = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_services.ini");
	String managerModel = inifile.getValue("MISC_ARGS","eGMgrModel");
	String session_userid = (String)session.getAttribute("sess_userid");
	if(userStatus == null || userStatus.trim().length() == 0)
	{
		userStatus = "active";
	}
	boolean hasAllComponentAccess=true;
	if(hasAllComponentAccess)
	{
		if(managerModel != null && managerModel.equalsIgnoreCase("msp"))
		{
			IniFile inifile1 = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_uuid.ini");
			String topLevelOrgs[] = inifile1.getVariables("ORG_UUID");
			ArrayList superOrgs = new ArrayList();
			if(topLevelOrgs != null && topLevelOrgs.length>0)
			{
				superOrgs.addAll(Arrays.asList(topLevelOrgs));
			}
			JSONArray exportDataArr = new JSONArray();
			for(int i=0;i<superOrgs.size();i++)
			{
				JSONObject exportDataObj = new JSONObject();
				String optVar = "";
				String optVal = "";
				String strDbChild = "";
				String orgname = (String)superOrgs.get(i);
				String uvalidtill = egUuidInfo.getExpiryDateOfUser(orgname);
				boolean isDisabled = false;

				if(uvalidtill != null)
				{
					if(uvalidtill.trim().length() == 0)
					{
						continue;
					}
					if(uvalidtill.indexOf("9999-12-12 23:59:59") == -1)
					{
						uvalidtill = uvalidtill.substring(0,10);
						uvalidtill = com.egurkha.util.DateUtil.changeDateFormat(uvalidtill,"yyyy-MM-dd","MM/dd/yyyy");
					}
					else
					{
						uvalidtill = "12/12/9999";
					}

					java.util.Date today = new java.util.Date();
					SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
					java.util.Date uvalidtilldate = new java.util.Date();

					try
					{
						uvalidtilldate = formatter.parse(uvalidtill+" 23:59:59");
					}
					catch(Exception e){}

					if(userStatus.equalsIgnoreCase("active"))
					{
						if(!uvalidtill.equalsIgnoreCase("12/12/9999") && uvalidtilldate.compareTo(today) < 0)
						{
							continue;
						}
					}
					else if(userStatus.equalsIgnoreCase("expired"))
					{
						if(uvalidtill.equalsIgnoreCase("12/12/9999") || uvalidtilldate.compareTo(today) > 0)
						{
							isDisabled = true;
							exportDataObj.put("cls","disabledNode");
						}
					}
				}
				else
				{
					if(userStatus.equalsIgnoreCase("expired"))
					{
						isDisabled = true;
						exportDataObj.put("cls","disabledNode");
					}
				}

				optVar = (String)superOrgs.get(i);
				optVal = (String)superOrgs.get(i);

				JSONArray rootUserObjectArray = new JSONArray();
				if(userStatus.equalsIgnoreCase("expired"))
				{
					TreeSet expiredUserSet = egUuidInfo.getAllExpiredUsers();
					if(expiredUserSet != null && !expiredUserSet.isEmpty())
					{
						rootUserObjectArray = egUuidInfo.buildTreeJsonForExpiredUsers(orgname,"customizedCmd",expiredUserSet);
					}
				}
				else
				{
					rootUserObjectArray = egUuidInfo.buildTreeJsonForAllUsers(orgname,session_userid,"customizedCmd",userStatus);
				}
				if(orgname.equalsIgnoreCase("egenterprise"))
				{
					if(!rootUserObjectArray.isEmpty())
					{
						exportDataObj.put("text",_mapping.getTextDescription("admin.user.egenterprise"));
						exportDataObj.put("id",optVar);
						exportDataObj.put("iconCls","iconDomain");
						exportDataObj.put("expanded",true);
						exportDataObj.put("children",rootUserObjectArray);
						exportDataArr.add(exportDataObj);
					}
				}
				else
				{
					if(userStatus.equalsIgnoreCase("expired") && isDisabled)
					{
						if(rootUserObjectArray.isEmpty())
						{
							continue;
						}
					}
					exportDataObj.put("text",optVal);
					exportDataObj.put("id",optVar);
					exportDataObj.put("iconCls","iconDomain");
					exportDataObj.put("expanded",true);
					exportDataObj.put("children",rootUserObjectArray);
					exportDataArr.add(exportDataObj);
				}
			}
			rootJson.put("exportDataArr",exportDataArr);
			rootJson.put("RootNodeText","Choose Organization / Organizational Unit / User");

			if(!exportDataArr.isEmpty())
			{
				isUsersCreated = true;
			}
		}
		else
		{
			JSONArray exportDataArr = new JSONArray();
			JSONObject exportDataObj = new JSONObject();

			if(userStatus.equalsIgnoreCase("expired"))
			{
				exportDataObj.put("cls","disabledNode");
			}

			exportDataObj.put("text",_mapping.getTextDescription("admin.user.egenterprise"));
			exportDataObj.put("id","egenterprise");
			exportDataObj.put("iconCls","iconDomain");
			exportDataObj.put("expanded",true);

			JSONArray rootUserObjectArray = new JSONArray();
			if(userStatus.equalsIgnoreCase("expired"))
			{
				TreeSet expiredUserSet = egUuidInfo.getAllExpiredUsers();
				if(expiredUserSet != null && !expiredUserSet.isEmpty())
				{
					rootUserObjectArray = egUuidInfo.buildTreeJsonForExpiredUsers("egenterprise","customizedCmd",expiredUserSet);
				}
			}
			else
			{
				rootUserObjectArray = egUuidInfo.buildTreeJsonForAllUsers("egenterprise",session_userid,"customizedCmd",userStatus);
			}
			exportDataObj.put("children",rootUserObjectArray);
			exportDataArr.add(exportDataObj);
			if(!rootUserObjectArray.isEmpty())
			{
				isUsersCreated = true;
				rootJson.put("exportDataArr",exportDataArr);
				rootJson.put("RootNodeText","Choose Organizational Unit / User");
			}
		}
	}
	else
	{
		String orgname = "";
		boolean isSuperOrg = egUuidInfo.isSuperOrg(session_userid);
		boolean isOrg = egUuidInfo.isOrg(session_userid);
		if(isSuperOrg)
		{
			orgname = session_userid;
		}
		else if(isOrg)
		{
			orgname = session_userid;
		}
		else
		{
			orgname = egUuidInfo.getDirectDependentOU(session_userid);
		}

		JSONArray rootUserObjectArray = new JSONArray();
		if(userStatus.equalsIgnoreCase("expired"))
		{
			TreeSet expiredUserSet = egUuidInfo.getAllExpiredUsers();
			if(expiredUserSet != null && !expiredUserSet.isEmpty())
			{
				rootUserObjectArray = egUuidInfo.buildTreeJsonForExpiredUsers(orgname,"customizedCmd",expiredUserSet);
			}
		}
		else
		{
			rootUserObjectArray = egUuidInfo.buildTreeJsonForAllUsers(orgname,session_userid,"customizedCmd",userStatus);
		}

		rootJson.put("exportDataArr",rootUserObjectArray);
		rootJson.put("RootNodeText","Choose Organizational Unit / User");

		if(!rootUserObjectArray.isEmpty())
		{
			isUsersCreated = true;
		}
	}

	if(isUsersCreated)
	{
		rootJson.put("isUsersCreated",new Boolean(true));
	}
	else
	{
		String message = "<div class='egFlexCenterByColumnWise' style='height:90%'><div class='iconExclamation'></div><div class='commonErrorMsgText'>" + _mapping.getTextDescription("admin.user.No users have been configured") + ".</div></div>";
		rootJson.put("message",message);
		rootJson.put("isUsersCreated",new Boolean(false));
	}

	//session.setAttribute("adminLastAccessedURL","/final/admin/EgAssociateCommands.jsp");
	rootJson.put("status",new Boolean(true));
	out.println(rootJson.toString());
%>
<%!

	private boolean isServerAgentBased(String hostName, String hostType)
	{
		boolean isAgentBasedServer = false;
		try
		{
			com.eg.EgExternalInfo extInfo = new com.eg.EgExternalInfo("manager");
			EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
			String[] extTypes = specsInfo.getAllExternalServerTypes();
			List extCompTypes = new ArrayList();
			if (extTypes != null)
			{
				extCompTypes = new ArrayList(Arrays.asList(extTypes));
			}

			String agentType = "Agent-based";
			if(hostType.equals("Real_user_monitor"))
			{
				agentType = "Agentless";
				//ip = "Not Applicable";
			}
			if(extInfo.isRemoteBased(hostName))
			{
				agentType = "Agentless";
			}
			else if (extCompTypes.contains(hostType))
			{
				agentType = "External Agent";
			}

			if(agentType != null && agentType.equalsIgnoreCase("Agent-based")){
					isAgentBasedServer = true;
			} else{
					isAgentBasedServer = false;
			}
			
		}
		catch(Exception e)
		{
			System.out.println("Exception in isServerAgentBased() hostName---> "+e.getMessage());
			e.printStackTrace();
		}
		finally
		{
			
		}
		return isAgentBasedServer;
	}
%>


