
<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page import = "java.util.*" %>
<%@ page import="com.eg.EgRoleInfo"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import="com.eg.EgName"%>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import="com.eg.EgSpecsInfo"%>
<%@ page import="com.eg.EgThresholdInfo"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import="com.egurkha.ini.*" %>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import="com.eg.EgTablesInfo"%>
<%@ page import ="egurkha.EgDbAdapterUI"%>
<%@ page import ="egurkha.EgDbAdapterC"%>
<%@ page import ="com.eg.EgDbAdapterTypeC"%>
<%@ page import ="com.eg.EgDbAdapterTypeUI"%>
<%@ page import="com.eg.EgDbInfo"%>
<%@ page import="java.sql.*" %>
<%@ page import="net.sf.json.*"%>


<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	//This flag governs whether all running tests to be visible in the default descriptor threshold UI. If false, only the chosen test and its descriptors are eligible for configuration.
	boolean isMuliple = false;
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	JSONObject rootJson= new JSONObject();
	JSONObject screenLabels= new JSONObject();
	JSONObject hiddenObj= new JSONObject();
	JSONObject measureDataObj = new JSONObject();

	screenLabels.put("title","DESCRIPTOR THRESHOLDS");
	rootJson.put("isMultiple",isMuliple);

	IniUI iniUI = IniUI.getInstance();
	EgDbAdapterUI egDb;
	IniFile defaultIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_thresholds.ini");
	String defaultThreshold = null;
	String subject = "DESCRIPTOR_DEFAULT_THRESHOLDS";
	String[] globalVars = defaultIni.getVariables(subject);

	//user language
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}
	String loginId = _user.getLoginID();
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	EgRoleInfo roleInfo = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	EgTablesInfo tablesInfo = new EgTablesInfo("manager");
	String[] arrComponentTypes = roleInfo.getServerTypes();
	ArrayList aListComponentTypes = null;
	if (arrComponentTypes != null)
	{
		aListComponentTypes = new ArrayList(Arrays.asList(arrComponentTypes));
	}

	String strTestName = request.getParameter("testName");
	String strDescName = request.getParameter("descName");
	String o_strTestName = request.getParameter("old_testName");
	String strComeFrom = request.getParameter("comeFrom");
	String from = request.getParameter("from");
	String isBack = "false";
	if(from != null && from.equals("defaultThreshPage"))
	{
		isBack = "true";
	}

	if(!StringUtils.isNull(strDescName))
	{
		strDescName = StringUtils.decodeSecurityChar(strDescName);
	}

	String isNewMon = request.getParameter("isNewMon");
	if (!StringUtils.isNull(isNewMon))
	{
		if(!StringUtils.isNull(strDescName) && strDescName.equals("NONE"))
		{
			strDescName = "";
		}
	}
	String strComponentType = null;
	String strComponentName = null;
	String strTestState = null;
	String strLayerName = null;
	String fromMon = null;
	String measCount = "";
	boolean isMonBack = false;
	boolean isUserDefinedDescriptor = false;

	if(StringUtils.isNull(strComeFrom))
	{
		fromMon = (String) session.getAttribute("fromMon");
		fromMon = (fromMon!=null && fromMon.length()>0 ? fromMon:"");
		strComeFrom = "";
		from="monitorThreshPage";

		if(!StringUtils.isNull(fromMon) && fromMon.equalsIgnoreCase("yes"))
		{
			if(StringUtils.isNull(strTestName))
			{
				strTestName = (String) session.getAttribute("testName");
			}

			if(StringUtils.isNull(strDescName))
			{
				strDescName = (String) session.getAttribute("descName");
			}
			strComponentType = (String) session.getAttribute("componentType");
			strComponentName = (String) session.getAttribute("componentName");
			strTestState = (String) session.getAttribute("testState");
			strLayerName = (String) session.getAttribute("layerName");
			isMonBack = true;
			strComeFrom = "";
			from="monitorThreshPage";
		}
	}

	if(!StringUtils.isNull(strComeFrom))
	{
		session.removeAttribute("fromMon");
		session.removeAttribute("componentType");
		session.removeAttribute("componentName");
		session.removeAttribute("testName");
		session.removeAttribute("descName");
		session.removeAttribute("testState");
		session.removeAttribute("layerName");
		isMonBack = false;
	}

	ArrayList allArrListEnabledPerformanceTests = new ArrayList();
	ArrayList aListHostLevelTests = new ArrayList();
	String strMessage = "";
	if (o_strTestName == null)
	{
		o_strTestName = strTestName;
	}

	if (strTestName != null && !strTestName.equalsIgnoreCase(o_strTestName))
	{
		strDescName = "";
	}

	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	if(aListComponentTypes != null && aListComponentTypes.size() > 0)
	{
		String[] arrHostTests = specsInfo.getDefaultTestsForServer("Host_system");
		if (arrHostTests != null)
		{
			aListHostLevelTests = new ArrayList(Arrays.asList(arrHostTests));
		}

		if (isMuliple)
		{
			for(int t=0;t<aListComponentTypes.size();t++)
			{
				String strCompType = (String) aListComponentTypes.get(t);
				ArrayList aListEnabledPerformanceTests = specsInfo.getEnabledTests(strCompType,false);

				if (aListEnabledPerformanceTests != null)
				{
					for (int i=0;i<aListEnabledPerformanceTests.size();i++)
					{
						String test_name = (String)aListEnabledPerformanceTests.get(i);
						boolean isInfoBased = false;
						boolean isDynamicMeasureTest = false;
						String info = getInfo(test_name);
						if (info == null || info.equals("")) //No table exists in database for the testname.
						{
							isInfoBased = false;
						}
						else
						{
							if ((info.startsWith("+") && !info.equals("+")) || 
								(info.indexOf("+") > 0 && !info.endsWith("+")))
							{
								isInfoBased = true;
							}
						}
						if(!isInfoBased)
						{
							continue;
						}
						if(!allArrListEnabledPerformanceTests.contains(test_name))
						{
							allArrListEnabledPerformanceTests.add(test_name);
						}
					}
				}
			}
		}
	}
	
	if(globalVars != null && globalVars.length > 0)
	{
		for(int t=0;t<globalVars.length;t++)
		{
			String tmpTestName = globalVars[t];
			if(tmpTestName != null && tmpTestName.indexOf(":") != -1)
			{
				String tmpInfoVal = tmpTestName.substring(tmpTestName.indexOf(":")+1);
				if(!StringUtils.isNull(tmpInfoVal))
				{
					tmpTestName = tmpTestName.substring(0,tmpTestName.indexOf(":"));
					if(!allArrListEnabledPerformanceTests.contains(tmpTestName))
					{
						allArrListEnabledPerformanceTests.add(tmpTestName);
					}
				}
			}
		}
	}

	ArrayList  arrDescList = new ArrayList();
	Hashtable ht = new Hashtable();
	Hashtable ht_measure_last = new Hashtable();
	boolean isConnected = false;
	boolean isHasSpecificData = false;
	ResultSet rs = null;
	ResultSet rs1 = null;
	int ind = -1;
	if(!StringUtils.isNull(strTestName))
	{
		rootJson.put("testName",strTestName);
		rootJson.put("displayTestName",_mapping.getTestDescription(strTestName));
		egDb=EgDbAdapterTypeUI.getObject();
		String status = egDb.setConnection();
		if(status.equals("CONNECTED"))
		{
			isConnected = true;
		}
		if(isConnected)
		{
			String query;
			String measure_last_query="";
			if(EgDbInfo.isSqlAdapter)
			{
				query = "SELECT distinct(info), test_name " +
				"FROM metatest WITH (NOLOCK) WHERE test_name='"+strTestName+"'";
			}
			else
			{
				query = "SELECT distinct(info), test_name " +
				"FROM metatest WHERE test_name='"+strTestName+"'";
			}
			ArrayList testAl = new ArrayList();
			ArrayList infoArrList = new ArrayList();
			ArrayList measure_last_test = new ArrayList();
			try
			{
				rs = egDb.SelectExec(query);
				while(rs.next())
				{
					String test = rs.getString(2);	
					if(test.equals
						("WebSiteTransactionTest"))
						continue;
					if(test.equals
						("WebLogicEjbTest"))
						continue;
					if(test.equals
						("WsEjbTest"))
						continue;
					if(EgInstallInfo.isConfigTest(test))
						continue;
					String info = rs.getString(1);
					if(info.length() < 2)
						continue;
					info = info.substring(1);
					infoArrList.add(info);
					int index = testAl.indexOf(test);
					if(index >= 0)
					{
						String temp = (String) ht.get(test);
						ht.put(test, temp+","+info);
						continue;
					}
					testAl.add(test);
					ht.put(test, info);
				}
				rs.close();
				if(infoArrList != null && infoArrList.size() > 0)
				{
					if(EgDbInfo.isSqlAdapter)
					{
						measure_last_query = "SELECT test_name,info FROM measure_last WITH (NOLOCK) WHERE test_name='"+strTestName+"'";
					}
					else
					{
						measure_last_query = "SELECT test_name,info FROM measure_last WHERE test_name='"+strTestName+"'";
					}
					rs1 = egDb.SelectExec(measure_last_query);
					while(rs1.next())
					{
						String test = rs1.getString(1);	
						if(test.equals
							("WebSiteTransactionTest"))
							continue;
						if(test.equals
							("WebLogicEjbTest"))
							continue;
						if(test.equals
							("WsEjbTest"))
							continue;
						if(EgInstallInfo.isConfigTest(test))
							continue;
						String info = rs1.getString(2);
						String sid = null;
						ind = info.indexOf("+");
						sid = info.substring(0,ind);
						if(!StringUtils.isNull(sid))
							info = info.substring(ind);
						if(info.length() < 2)
							continue;
						info = info.substring(1);
						if(!infoArrList.contains(info))
						{
							continue;
						}
						int index = measure_last_test.indexOf(test);
						if(index >= 0)
						{
							String temp = (String) ht_measure_last.get(test);
							ht_measure_last.put(test, temp+","+info);
							continue;
						}
						measure_last_test.add(test);
						ht_measure_last.put(test, info);
					}
					rs1.close();
				}
				egDb.releaseConnection(false);
				EgDbAdapterTypeUI.releaseObject(egDb);
			}
			catch(Exception e)
			{
				if(rs != null)
					rs.close();
				if(rs1 != null)
					rs1.close();
				egDb.releaseConnection(true);
				EgDbAdapterTypeUI.releaseObject(egDb);
			}
		}

		if(ht_measure_last != null && ht_measure_last.size() > 0)
		{
			String htVal = (String) ht_measure_last.get(strTestName);
			ArrayList tempList = StringUtils.egTokenizer(htVal,",");
			if(tempList != null && !tempList.isEmpty())
			{
				for(int e=0;e<tempList.size();e++)
				{
					String tempInfo = (String) tempList.get(e);
					if(tempInfo != null && !arrDescList.contains(tempInfo))
					{
						arrDescList.add(tempInfo);
					}
				}
			}
		}
		if(!StringUtils.isNull(strTestName))
		{
			ArrayList userDefinedInfo = new ArrayList();
			if(globalVars != null && globalVars.length > 0)
			{
				for(int g=0;g<globalVars.length;g++)
				{
					String strVarData = globalVars[g];
					if(strVarData != null && strVarData.startsWith(strTestName))// && arrDescList.contains(tempInfo))
					{
						if(strVarData != null && strVarData.indexOf(":") != -1)
						{
							String strTempInfo = strVarData.substring(strVarData.indexOf(":")+1);
							if(!arrDescList.contains(strTempInfo))
							{
								userDefinedInfo.add(strTempInfo);
								arrDescList.add(strTempInfo);
							}
						}
					}
				}
			}

			if(StringUtils.isNull(strDescName) && (arrDescList != null && arrDescList.size() > 0))
			{
				strDescName = (String) arrDescList.get(0);
			}

			if(!StringUtils.isNull(strDescName) && userDefinedInfo != null && userDefinedInfo.contains(strDescName))
			{
				isUserDefinedDescriptor = true;
			}

		}

		if(!StringUtils.isNull(strTestName) && !StringUtils.isNull(strDescName))
		{
			String strVariable = strTestName+":"+strDescName;
			defaultThreshold = defaultIni.getValue(subject,strVariable);
			if(defaultThreshold.trim().length() == 0){
				strVariable = strTestName+":"+StringUtils.encodeSecurityChar(strDescName);
				defaultThreshold = defaultIni.getValue(subject,strVariable);
			}
			if(!StringUtils.isNull(defaultThreshold) && (!isUserDefinedDescriptor || strDescName.indexOf("*") != -1))
			{
				isHasSpecificData = true;
			}
			if(StringUtils.isNull(defaultThreshold))
			{
				List filterKeysList = Arrays.asList(globalVars);
				ArrayList filterKeys = new ArrayList();
				for (int fk = 0; fk < filterKeysList.size(); fk++)
				{
					String key = (String) filterKeysList.get(fk);
					if (!com.egurkha.util.StringUtils.isNull(key) && key.startsWith(strTestName+":") && key.indexOf("*") != -1)
					{
						String wildCardStr = key.substring(key.indexOf(":")+1);
						if (!com.egurkha.util.StringUtils.isNull(wildCardStr) && !filterKeys.contains(wildCardStr))
						{
							filterKeys.add(wildCardStr);
						}
					}
				}

				if (filterKeys != null && filterKeys.size() > 0)
				{
					for (int k=0;k<filterKeys.size() ;k++ )
					{
						String searchString = (String) filterKeys.get(k);
						if (com.egurkha.util.EgUtilities.isMatch(strDescName, searchString) )
						{
							defaultThreshold = defaultIni.getValue(subject,strTestName+":"+searchString);
							break;
						}
					}
				}
				if(StringUtils.isNull(defaultThreshold))
				{
					defaultThreshold = defaultIni.getValue("DEFAULT_THRESHOLDS",strTestName);
				}
			}
		}
	}

	rootJson.put("isSpecificDescriptor",isHasSpecificData);
	if (strTestName != null && strTestName.length() > 0 && aListHostLevelTests != null && aListHostLevelTests.contains(strTestName))
	{
		strMessage = "Changes made to default threshold will be applied to all component types to which this test is mapped";
	}

	/*
		NetworkTest=
		Avg_delay:mix:-1:-/-/0.3&3*sqc:longterm:HML,
		Min_delay:mix:-1:-1:immediate:HML,
		Pkt_loss_pct:mix:-1:60/-/-:shortterm:HML,
		Availability:mix:1/-/-:-1:immediate:HML
	*/
	String pageDescURL = "listSearch.jsp?title=DESCRIPTOR THRESHOLDS&backButton="+isBack+"&subtitle=false&searchBox=false";

	if (!StringUtils.isNull(isNewMon))
	{
		String strServer = request.getParameter("strServer");
		String component = request.getParameter("component");
		hiddenObj.put("strServer",strServer);
		hiddenObj.put("component",component);
	}


	hiddenObj.put("strTestName",strTestName);
	hiddenObj.put("old_testName",strTestName);
	hiddenObj.put("strDescName",strDescName);
	hiddenObj.put("comeFrom",strComeFrom);
	hiddenObj.put("from",from);
	hiddenObj.put("fromMon",fromMon);
	hiddenObj.put("isUserDefinedDescriptor",isUserDefinedDescriptor);
	if(isMonBack)
	{
		rootJson.put("monitor_page","true");
		screenLabels.put("monitor_label","Click here to go to the layer model");

		String qryTestVal = null;
		if(!StringUtils.isNull(strDescName) && !strDescName.equals("NONE"))
		{
			qryTestVal = strTestName+"- "+strDescName;
		}
		else
		{
			qryTestVal = strTestName+"- ";
		}
		String monURL = "/final/servlet/com.eg.EgDashboardController?from=list&comptype="+EgURLEncoder.encode(strComponentType,"UTF-8")+"&host="+EgURLEncoder.encode(strComponentName,"UTF-8")+"&tab=LayerModel&comesFrom=LayerModel&site=NULL&host="+EgURLEncoder.encode(strComponentName,"UTF-8")+"&layer="+strLayerName+"&qctr=2&comptype="+EgURLEncoder.encode(strComponentType,"UTF-8")+"&fromalarm=null&msmt_host=&test="+EgURLEncoder.encode(qryTestVal,"UTF-8")+"&tstate="+strTestState+"&checkedAll=true&showDashBoardLink=true";
		session.setAttribute("monitorLastSession",monURL);
		session.setAttribute("fromAdmin","Yes");
			rootJson.put("monitor_url",monURL);

	}

	/*if(StringUtils.isNull(fromMon) || fromMon.equalsIgnoreCase("No"))
	{
		JSONArray testsArr = new JSONArray();
		if (allArrListEnabledPerformanceTests != null && !allArrListEnabledPerformanceTests.isEmpty())
		{
			allArrListEnabledPerformanceTests = sorter.getSortedTestList(allArrListEnabledPerformanceTests);
			JSONObject testsObj = new JSONObject();
			testsObj.put("displayField",_mapping.getTextDescription("admin.common.Please choose a test name"));
			testsObj.put("valueField","-1");
			testsArr.add(testsObj);
			for (int i=0; i<allArrListEnabledPerformanceTests.size(); i++)
			{
				EgName nameObj = (EgName)allArrListEnabledPerformanceTests.get(i);
				String tmpVal = nameObj.getActualName();
				String tmpDis = nameObj.getLocalName();
				testsObj.put("displayField",tmpDis);
				testsObj.put("valueField",tmpVal);
				testsArr.add(testsObj);

				if (strTestName != null && strTestName.equals(tmpVal))
				{
					rootJson.put("selectedTest",strTestName);
				}
				else
				{
				}
			}
		}
		else
		{
			JSONObject testsObj = new JSONObject();
			testsObj.put("displayField",_mapping.getTextDescription("admin.common.Not Applicable"));
			testsObj.put("valueField","-1");
			testsArr.add(testsObj);

		}
		rootJson.put("testsArr",testsArr);
	}
	else*/
	{
		rootJson.put("selectedTest",strTestName);
	}

	if(StringUtils.isNull(fromMon) || fromMon.equalsIgnoreCase("No"))
	{
		JSONArray descsArr = new JSONArray();

		if (arrDescList != null && !arrDescList.isEmpty())
		{
			JSONObject descsObj = new JSONObject();
			if (arrDescList.size() > 1 )
			{ 
				descsObj.put("displayField",_mapping.getTextDescription("admin.common.Please choose a descriptor name"));
				descsObj.put("valueField","-1");
				descsArr.add(descsObj);
			}

			for (int i=0; i<arrDescList.size(); i++)
			{
				String tmpDis = (String)arrDescList.get(i);
				descsObj.put("displayField",tmpDis);
				descsObj.put("valueField",tmpDis);
				descsArr.add(descsObj);

				if (strDescName != null && strDescName.equals(tmpDis))
				{
					rootJson.put("selectedDesc",strDescName);
				}
			}
		}
		else
		{
			JSONObject descsObj = new JSONObject();
			descsObj.put("displayField",_mapping.getTextDescription("admin.common.Not Applicable"));
			descsObj.put("valueField","-1");
			descsArr.add(descsObj);
		}
		rootJson.put("descsArr",descsArr);
	}
	else
	{
		rootJson.put("selectedDesc",strDescName);
	}

	if ((strTestName != null && !strTestName.equals("-1")) && (!StringUtils.isNull(strDescName) && !strDescName.equals("-1")))
	{
		if (strMessage != null && strMessage.length() > 0)
		{
			rootJson.put("hTest_msg",strMessage);
		}
		boolean heading_flag = false;
		ArrayList aListTestWithNoThresholds = new ArrayList();
		boolean cellFlag = false;
		StringTokenizer st = new StringTokenizer(defaultThreshold,",");
		measCount = Integer.toString(st.countTokens());
		JSONArray threshValArr = new JSONArray();
		JSONArray measureValArr = new JSONArray();
		JSONObject hiddenDataObj = new JSONObject();

		while (st.hasMoreTokens())
		{
			JSONObject measHiddenObj = new JSONObject();
			measHiddenObj.put("comeFrom",strComeFrom);
			measHiddenObj.put("testName",strTestName);
			measHiddenObj.put("strTestName",strTestName);
			measHiddenObj.put("old_testName",strTestName);
			measHiddenObj.put("strDescName",strDescName);
			measHiddenObj.put("comeFrom",strComeFrom);
			measHiddenObj.put("from",from);
			measHiddenObj.put("fromMon",fromMon);
			measHiddenObj.put("isUserDefinedDescriptor",isUserDefinedDescriptor);

			String strTok = st.nextToken();
			StringTokenizer st1 = new StringTokenizer(strTok,":");
			while (st1.hasMoreTokens())
			{
				JSONObject threshValObj = new JSONObject();
				JSONObject tmpObject = new JSONObject();
				String measure = st1.nextToken();
				String policy = st1.nextToken();
				String min = st1.nextToken();
				String max = st1.nextToken();
				String alarmPolicy = st1.nextToken();
				threshValObj.put("AlarmPolicy",alarmPolicy);
				String lastToken = st1.nextToken();
				String unit = tablesInfo.getUnitForMeasure(strTestName,measure);
				measHiddenObj.put("alarmPolicy", alarmPolicy);
				measHiddenObj.put("measure", measure);

				String absMinCritical = "-";
				String relMinCritical = "-";

				String absMinMajor = "-";
				String relMinMajor = "-";

				String absMinMinor = "-";
				String relMinMinor = "-";

				String absMaxCritical = "-";
				String relMaxCritical = "-";

				String absMaxMajor = "-";
				String relMaxMajor = "-";

				String absMaxMinor = "-";
				String relMaxMinor = "-";

				if (policy.equalsIgnoreCase("none"))
				{
					policy = "mix";
				}
				else if (policy.equalsIgnoreCase("absolute"))
				{
					if (!min.equals("-1"))
					{
						StringTokenizer stAbsMin = new StringTokenizer(min,"/");
						absMinCritical = stAbsMin.nextToken();
						absMinMajor = stAbsMin.nextToken();
						absMinMinor = stAbsMin.nextToken();
					}

					if (!max.equals("-1"))
					{
						StringTokenizer stAbsMax = new StringTokenizer(max,"/");
						absMaxCritical = stAbsMax.nextToken();
						absMaxMajor = stAbsMax.nextToken();
						absMaxMinor = stAbsMax.nextToken();
					}
				}
				else if (policy.equalsIgnoreCase("relative"))
				{
					if (!min.equals("-1"))
					{
						StringTokenizer stRelMin = new StringTokenizer(min,"/");
						relMinCritical = stRelMin.nextToken();
						relMinMajor = stRelMin.nextToken();
						relMinMinor = stRelMin.nextToken();
					}

					if (!max.equals("-1"))
					{
						StringTokenizer stRelMax = new StringTokenizer(max,"/");
						relMaxCritical = stRelMax.nextToken();
						relMaxMajor = stRelMax.nextToken();
						relMaxMinor = stRelMax.nextToken();
					}
				}
				else if (policy.equalsIgnoreCase("mix"))
				{
					Vector vec = getAbsAndRel(min);
					String absA = (String) vec.get(0);
					String relA = (String) vec.get(1);
					Vector vec1 = getAbsAndRel(max);
					String absB = (String) vec1.get(0);
					String relB = (String) vec1.get(1);

					if (!absA.equals("none"))
					{
						StringTokenizer stmixMin = new StringTokenizer(absA,"/");
						absMinCritical = stmixMin.nextToken();
						absMinMajor = stmixMin.nextToken();
						absMinMinor = stmixMin.nextToken();
					}

					if (!absB.equals("none"))
					{
						StringTokenizer stmixMax = new StringTokenizer(absB,"/");
						absMaxCritical = stmixMax.nextToken();
						absMaxMajor = stmixMax.nextToken();
						absMaxMinor = stmixMax.nextToken();
					}

					if (!relA.equals("none"))
					{
						StringTokenizer stRelMin = new StringTokenizer(relA,"/");
						relMinCritical = stRelMin.nextToken();
						relMinMajor = stRelMin.nextToken();
						relMinMinor = stRelMin.nextToken();
					}

					if (!relB.equals("none"))
					{
						StringTokenizer stmixMax = new StringTokenizer(relB,"/");
						relMaxCritical = stmixMax.nextToken();
						relMaxMajor = stmixMax.nextToken();
						relMaxMinor = stmixMax.nextToken();
					}
				}

				measHiddenObj.put("absMinCritical", absMinCritical);
				measHiddenObj.put("relMinCritical", relMinCritical);
				measHiddenObj.put("absMinMajor", absMinMajor);
				measHiddenObj.put("relMinMajor", relMinMajor);
				measHiddenObj.put("absMinMinor", absMinMinor);
				measHiddenObj.put("relMinMinor", relMinMinor);
				measHiddenObj.put("absMaxCritical", absMaxCritical);
				measHiddenObj.put("relMaxCritical", relMaxCritical);
				measHiddenObj.put("absMaxMajor", absMaxMajor);
				measHiddenObj.put("relMaxMajor", relMaxMajor);
				measHiddenObj.put("absMaxMinor", absMaxMinor);
				measHiddenObj.put("relMaxMinor", relMaxMinor);
				hiddenDataObj.put(measure,measHiddenObj);
				String minCritical = getThresholdValue("min",absMinCritical,relMinCritical);
				String minMajor = getThresholdValue("min",absMinMajor,relMinMajor);
				String minMinor = getThresholdValue("min",absMinMinor,relMinMinor);

				String maxCritical = getThresholdValue("max",absMaxCritical,relMaxCritical);
				String maxMajor = getThresholdValue("max",absMaxMajor,relMaxMajor);
				String maxMinor = getThresholdValue("max",absMaxMinor,relMaxMinor);

				if (minCritical.equals("-")  && minMajor.equals("-") && minMinor.equals("-") && 
				maxCritical.equals("-") && maxMajor.equals("-") && maxMinor.equals("-"))
				{
					aListTestWithNoThresholds.add(measure);
					continue;
				}

				if (!heading_flag)
				{
					heading_flag = true;
				}
				String tmpThreshData = mappingInfo.getMeasureDescription(strTestName,measure)+"("+unit+")";
				tmpObject.put("measure",tmpThreshData);

				String tmpMinThresh  = "";
				if(!minCritical.equals("-") || !minMajor.equals("-") || !minMinor.equals("-"))
				{
					tmpMinThresh = minCritical+"$"+minMajor+"$"+minMinor;
				}
				tmpObject.put("MinThresh",tmpMinThresh);
				String tmpMaxThresh = "";

				if(!maxCritical.equals("-") || !maxMajor.equals("-") || !maxMinor.equals("-"))
				{					tmpMaxThresh = maxCritical+"$"+maxMajor+"$"+maxMinor;

				}
				tmpObject.put("MaxThresh",tmpMaxThresh);
				tmpObject.put("alarmPolicy",alarmPolicy);

				threshValArr.add(tmpObject);

				String tempThresh = "";
				boolean isMinData = false;
				if(!minCritical.equals("-")  || !minMajor.equals("-") || !minMinor.equals("-"))
				{
					tempThresh += "Min|"+minCritical+"|"+minMajor+"|"+minMinor;
					isMinData = true;
				}

				if(!maxCritical.equals("-") || !maxMajor.equals("-") || !maxMinor.equals("-"))
				{
					if (isMinData)
					{
						tempThresh += "#Max|"+maxCritical+"|"+maxMajor+"|"+maxMinor;
					}
					else
					{
						tempThresh += "Max|"+maxCritical+"|"+maxMajor+"|"+maxMinor;
					}
				}
				measureDataObj.put(mappingInfo.getMeasureDescription(strTestName,measure),measure);
				threshValObj.put("Measure",mappingInfo.getMeasureDescription(strTestName,measure)+"  ("+unit+")");
				threshValObj.put("Threshold",tempThresh);
				measureValArr.add(threshValObj);
			}
		}
		rootJson.put("hiddenDataObj",hiddenDataObj);
		rootJson.put("measureValArr",measureValArr);
		rootJson.put("threshValArr",threshValArr);

		hiddenObj.put("measCount",measCount);
		if (aListTestWithNoThresholds != null && !aListTestWithNoThresholds.isEmpty())
		{
			JSONArray noMeasureValArr = new JSONArray();

			int d=0;
			while(d<aListTestWithNoThresholds.size())
			{
				JSONObject noMeasureThreshValObj = new JSONObject();
				String strMeasure1 = "";
				String strMeasure2 = "";
				String strMeasure = (String)aListTestWithNoThresholds.get(d);
				int count = d;
				if(!StringUtils.isNull(strMeasure))
				{
					measureDataObj.put(mappingInfo.getMeasureDescription(strTestName,strMeasure),strMeasure);
					strMeasure = mappingInfo.getMeasureDescription(strTestName,strMeasure);
				}
				else
					strMeasure = "";
				count = d+1;
				if(count < aListTestWithNoThresholds.size())
				{
					strMeasure1 = (String)aListTestWithNoThresholds.get(count);
					if(!StringUtils.isNull(strMeasure1))
					{
						measureDataObj.put(mappingInfo.getMeasureDescription(strTestName,strMeasure1),strMeasure1);
						strMeasure1 = mappingInfo.getMeasureDescription(strTestName,strMeasure1);
					}
				}
				count = d+2;
				if(count < aListTestWithNoThresholds.size())
				{
					strMeasure2 = (String)aListTestWithNoThresholds.get(count);
					if(!StringUtils.isNull(strMeasure2))
					{
						measureDataObj.put(mappingInfo.getMeasureDescription(strTestName,strMeasure2),strMeasure2);
						strMeasure2 = mappingInfo.getMeasureDescription(strTestName,strMeasure2);
					}
				}

				noMeasureThreshValObj.put("Measure1",strMeasure);
				noMeasureThreshValObj.put("Measure2",strMeasure1);
				noMeasureThreshValObj.put("Measure3",strMeasure2);
				noMeasureValArr.add(noMeasureThreshValObj);
				d = count+1;
			}
			rootJson.put("noMeasureValArr",noMeasureValArr);

		}

		if(isHasSpecificData)
		{
			rootJson.put("isSpecificDescriptor",isHasSpecificData);
		}
	}

	rootJson.put("screenLabels",screenLabels);
	rootJson.put("measureDataObj",measureDataObj);
	rootJson.put("hiddenObj",hiddenObj);
	out.println(rootJson.toString());

%>
<%!
	int alarmPolicyLength = 15;

	private String get1(String H)
	{
		String h;
		if (!(H.equals("-")))
		{
			if (H.indexOf("&") > -1)
			{
				StringTokenizer st = new StringTokenizer(H,"&");
				H = st.nextToken();
				h = st.nextToken();
			}
			else
			{
				if (H.indexOf("sqc") > -1)
				{
					h = H;
					H = "-";
				}
				else
				{
					h = "-";
				}
			}
		}
		else
		{
			h = "-";
		}
		return(H+"_"+h);
	}

	private Vector getAbsAndRel(String format)
	{
		Vector vect = new Vector();
		StringTokenizer stok1 = new StringTokenizer(format,"/");
		if (!format.equals("-1") && stok1.countTokens() == 3)
		{
			String H1 = stok1.nextToken();
			String h2=get1(H1);
			String M = stok1.nextToken();
			String m1=get1(M);
			String L = stok1.nextToken();
			String l1=get1(L);
			StringTokenizer h1 = new StringTokenizer(h2,"_");
			String High= h1.nextToken();
			String high = h1.nextToken();
			StringTokenizer m = new StringTokenizer(m1,"_");
			String Mid = m.nextToken();
			String mid = m.nextToken();
			StringTokenizer l = new StringTokenizer(l1,"_");
			String Low = l.nextToken();
			String low = l.nextToken();
			StringBuffer sb2 = new StringBuffer();
			StringBuffer sb1 = new StringBuffer();
			String s1 = null;
			if (High.equals("-") && Mid.equals("-") && Low.equals("-"))
			{
				s1 = "none";
			}
			else
			{
				sb1.append(High);
				sb1.append("/");
				sb1.append(Mid);
				sb1.append("/");
				sb1.append(Low);
				s1 = sb1.toString();
			}
			String s2 = null;
			if (high.equals("-") && mid.equals("-") && low.equals("-"))
			{
				vect.add(s1);
				vect.add("none");
			}
			else
			{
				sb2.append(high);
				sb2.append("/");
				sb2.append(mid);
				sb2.append("/");
				sb2.append(low);
				s2 = sb2.toString();
				vect.add(s1);
				vect.add(s2);
			}
		}
		else
		{
			vect.add("none");
			vect.add("none");
		}
		return vect;
	}

	private String getThresholdValue(String grpFunction, String absValue,String relValue)
	{
		String strValue = "-";

		if (absValue.equals("-") && relValue.equals("-"))
		{
			strValue = "-";
		}
		else if (!absValue.equals("-") && !relValue.equals("-"))
		{
			strValue = grpFunction+"("+absValue+", "+getRelativeThreshold(relValue)+")";
		}
		else if (!absValue.equals("-"))
		{
			strValue = absValue;
		}
		else if (!relValue.equals("-"))
		{
			strValue = getRelativeThreshold(relValue);
		}

		return strValue;
	}

	private String getRelativeThreshold(String relValue)
	{
		//relValue: 3*sqc
		String strValue = "";
		if (relValue.indexOf("*") != -1)
		{
			int idx = relValue.indexOf("*");
			String s1 = relValue.substring(0,idx);
			double d_value = Double.valueOf(s1.trim()).doubleValue();
			d_value = d_value * 100;
			int i_value = (new Double(d_value)).intValue();
			strValue = Integer.toString(i_value) + "% of auto";
		}
		else
		{
			strValue = "auto";
		}
		return strValue;
	}

	private String getInfo(String configTest)
	{
		String str = null;
		boolean isConnected = false;
		EgDbAdapterUI egDbUI = null;
		try
		{
			egDbUI = EgDbAdapterTypeUI.getObject();
			String status = egDbUI.setConnection();
			if (status != null && status.equals("CONNECTED"))
			{
				isConnected = true;
			}
			if(isConnected)
			{
				String query;
				if(EgDbInfo.isSqlAdapter)
				{
					query = "SELECT top 1 info from " +configTest;
				}
				else
				{
					query = "SELECT info from " +configTest+" WHERE rownum=1";
				}
				str = egDbUI.getFirstValueOfInfoColumn(query);
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			egDbUI.release_Connection(false);
			EgDbAdapterTypeUI.releaseObject(egDbUI);
		}
		return str;
	}
%>



