<%
/********************************************************************************
 *      File name               :       EgDispAutoTopology.jsp
 *      Purpose                 :       To display all topologies.
 *      Version                 :       5.7
 *      Creation Date           :       27-02-2013					
 ******************************************************************************/
%>

<%@ include file="EgTrackerA.jsp" %>
<%//@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.eg.EgTesterInfo" %>
<%@ page import ="com.eg.EgURLEncoder" %>
<%@ page import="java.util.*" %>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import="com.eg.EgGroupInfo" %>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.egurkha.*"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ taglib prefix ="egui" uri = "../WEB-INF/eg-taglib.tld"%>
<jsp:useBean id="zoneI" class="egurkha.ZoneInfoBean" scope="page" />
<jsp:useBean id="user" class="egurkha.UserBean" scope="page"/>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	ArrayList indexList = new ArrayList();
	ArrayList compList = new ArrayList();
	Hashtable topologyComponents = new Hashtable();
	Hashtable topologyLinesToSave = new Hashtable();
	Hashtable TopoWithStartComp = new Hashtable();
	ArrayList topologyNamesList = new ArrayList();
	
	ArrayList finalTopologyList  = new ArrayList();
	Hashtable topoCompToDisplay = new Hashtable();
	
	public Hashtable getStartComponent()
	{
		String topoFile = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		IniFile autoTopoIni = new IniFile(topoFile);
		topologyLinesToSave = new Hashtable();
		finalTopologyList  = new ArrayList();
		topoCompToDisplay = new Hashtable();
		TopoWithStartComp = new Hashtable();
		topologyComponents = new Hashtable();
		topologyNamesList = new ArrayList();

		Hashtable finalTopo = new Hashtable();
		String[] vars = autoTopoIni.getVariables("Topo_Auto");
		List list = Arrays.asList(vars);
		Vector startComponents = new Vector(list);

		if(vars != null && vars.length > 0)
		{
			for (int i=0;i<vars.length;i++)
			{
				String var = vars[i];
				String val = autoTopoIni.getValue("Topo_Auto",var);
				if(val != null && val.length() > 0)
				{
					if(val.indexOf(",") > -1)
					{
						StringTokenizer stc = new StringTokenizer(val, ",");
						while (stc.hasMoreTokens())
						{
							String token = stc.nextToken();
							if(token != null && token.length() > 0)
							{
								if(token.endsWith(":L"))
								{
									token = token.substring(0,token.indexOf(":L"));
								}
								else if(token.endsWith(":N"))
								{
									token = token.substring(0,token.indexOf(":N"));
								}
								int tokenIndex = startComponents.indexOf(token);
								if(tokenIndex > -1)
								{
									if(!indexList.contains(tokenIndex+""))
									{
										indexList.add(tokenIndex+"");
									}
								}
							}
						}
					}
					else
					{
						if(val.endsWith(":L"))
						{
							val = val.substring(0,val.indexOf(":L"));
						}
						else if(val.endsWith(":N"))
						{
							val = val.substring(0,val.indexOf(":N"));
						}
						int valIndex = startComponents.indexOf(val);
						if(valIndex > -1)
						{
							if(!indexList.contains(valIndex+""))
							{
								indexList.add(valIndex+"");
							}
						}
					}
				}
			}		
			int tcount = 0;
			for (int j=0;j<vars.length;j++)
			{
				if(indexList != null && indexList.size() > 0 && indexList.contains(j+""))
				{
					continue;
				}
				String var = vars[j];
				if(var != null && var.length() > 0)
				{
					if(var.endsWith(":L"))
					{
						var = var.substring(0,var.indexOf(":L"));
					}
					else if(var.endsWith(":N"))
					{
						var = var.substring(0,var.indexOf(":N"));
					}
				}

				String val = autoTopoIni.getValue("Topo_Auto",var);
				/*ArrayList deletedList = getDeletedComponents(var,"null");
				if(deletedList.contains(var))
					continue;*/
				
				tcount ++;
				compList = new ArrayList();
				String topoName = "AUTO_TOPOLOGY_"+(tcount);
				compList.add(var);
				Hashtable ht = getCompleteTopology(var, topoName);
				finalTopo.put(var, ht);				
				topologyComponents.put(topoName, compList);
				
				//autoTopoIni.setValue("AUTO_TOPOLOGY_LIST", topoName, topoName);
				if(!topologyNamesList.contains(topoName))
					topologyNamesList.add(topoName);
				TopoWithStartComp.put(var,topoName);
			}
			//autoTopoIni.saveFile();
		}
		return finalTopo;
	}

	public Hashtable getCompleteTopology(String varKey, String topologyName)
	{
		String topoFile = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		IniFile autoTopoIni = new IniFile(topoFile);
		if(varKey != null && varKey.length() > 0)
		{
			if(varKey.endsWith(":L"))
			{
				varKey = varKey.substring(0,varKey.indexOf(":L"));
			}
			else if(varKey.endsWith(":N"))
			{
				varKey = varKey.substring(0,varKey.indexOf(":N"));
			}
		}

		String val = autoTopoIni.getValue("Topo_Auto",varKey);
		
		/*ArrayList deletedList = getDeletedComponents(varKey,val);
		StringTokenizer stDel = new StringTokenizer(val,",");
		StringBuffer tmpBuffer = new StringBuffer();
		String resultStr = "";
		while(stDel.hasMoreTokens())
		{
			String tok = (String)stDel.nextToken();
			String tt=tok;
			if(tok.endsWith(":L") || tok.endsWith(":N"))
				tt = tok.substring(0,tok.lastIndexOf(":"));
			if(!deletedList.contains(tt))
			{
				resultStr = resultStr+","+tok;
			}
		}
		if(resultStr.startsWith(","))
			resultStr=resultStr.substring(resultStr.indexOf(",")+1);
		resultStr = resultStr.trim();
		if(resultStr.length()>0)
		{
			val = resultStr;
		}
		else val="";*/
		
		if(val != null && val.length() > 0)
		{
			//autoTopoIni.setValue(topologyName, varKey, val);
			if(topologyLinesToSave.containsKey(topologyName))
			{
				Hashtable linesTable = (Hashtable)topologyLinesToSave.get(topologyName);
				linesTable.put(varKey,val);
				topologyLinesToSave.put(topologyName,linesTable);
			}
			else
			{
				Hashtable linesTable = new Hashtable();
				linesTable.put(varKey,val);
				topologyLinesToSave.put(topologyName,linesTable);
			}
			
			if(val.indexOf(",") > -1)
			{
				StringTokenizer stc = new StringTokenizer(val, ",");
				Hashtable ht1 = new Hashtable();
				while (stc.hasMoreTokens())
				{
					String token = stc.nextToken();
					if(token != null && token.length() > 0)
					{
						String str = "";
						if(token.endsWith(":L"))
						{
							str = token.substring(0,token.indexOf(":L"));
						}
						else if(val.endsWith(":N"))
						{
							str = token.substring(0,token.indexOf(":N"));
						}
						if(!compList.contains(str))
						{
							compList.add(str);
						}
						Hashtable ht = getCompleteTopology(token, topologyName);
						if(ht != null)
						{
							ht1.put(token, ht);
						}
					}
				}
				return ht1;
			}
			else
			{
				Hashtable ht1 = new Hashtable();
				String str = "";
				if(val.endsWith(":L"))
				{
					str = val.substring(0,val.indexOf(":L"));
				}
				else if(val.endsWith(":N"))
				{
					str = val.substring(0,val.indexOf(":N"));
				}
				if(!compList.contains(str))
				{
					compList.add(str);
				}
				Hashtable ht = getCompleteTopology(val, topologyName);
				if(ht != null)
				{
					ht1.put(val, ht);
				}
				return ht1;
			}
		}
		return new Hashtable();
	}
%>

<%
	
	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
	boolean isMSIE6 = ( ua != null && ua.indexOf( "MSIE 6.0" ) != -1 );
	
	boolean isDouble=EgDbInfo.doubleByteEnabled;
	String [] groups = zoneI.getZoneNames();
	boolean segLimitExceed = false;
	if(!user.checkSegmentCount())
	{
		segLimitExceed = true;
	}
	
	String topoFile = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
	IniFile autoTopoIni = EgConfigFilesSync.getInstance(topoFile,true);

	EgGroupInfo groupinfo = new EgGroupInfo();
	Hashtable topoTable = getStartComponent(); // Returns all topologies with all its levels
	
	Hashtable finaltopoTable = new Hashtable();
	String secondKey="";
	Hashtable addedTables =null;
	ArrayList secondKeyList = new ArrayList();
	ArrayList thirdKeyList = new ArrayList();
	
	long t1 = System.currentTimeMillis();
	//compare second Level Component
	Enumeration allKeys = topoTable.keys();
	while(allKeys.hasMoreElements())
	{
		String startComp = (String)allKeys.nextElement();
		Hashtable secondLevelTable = (Hashtable)topoTable.get(startComp);
		Enumeration e = secondLevelTable.keys();
		String secondLevelKey="";
		while(e.hasMoreElements())
		{
			secondLevelKey = (String)e.nextElement();
			if(secondKeyList.contains(secondLevelKey))
				continue;
			
			secondKeyList.add(secondLevelKey);
			ArrayList resultList = new ArrayList();		
			addedTables = joinTopologies(topoTable,finaltopoTable,resultList,secondLevelKey,TopoWithStartComp);
		}
	}

	//compare Third Level Components
	Enumeration Keys = topoTable.keys();
	while(Keys.hasMoreElements())
	{
		String startComp = (String)Keys.nextElement();
		Hashtable secondLevelTable = (Hashtable)topoTable.get(startComp);
		Enumeration e = secondLevelTable.keys();
		String secondLevelKey="";
		while(e.hasMoreElements())
		{
			secondLevelKey = (String)e.nextElement();			
			Hashtable thirdLevelTable = (Hashtable)secondLevelTable.get(secondLevelKey);
			if(thirdLevelTable!=null && thirdLevelTable.size()>0)
			{
				String thirdLevelKey="";
				Enumeration et = thirdLevelTable.keys();
				while(et.hasMoreElements())
				{
					thirdLevelKey = (String)et.nextElement();
					if(thirdKeyList.contains(thirdLevelKey))
						continue;
					
					thirdKeyList.add(thirdLevelKey);
					ArrayList resultList = new ArrayList();		
					addedTables = joinTopologies(topoTable,finaltopoTable,resultList,thirdLevelKey,TopoWithStartComp);
				}
			}
		}
	}
	
	ArrayList combinedTopologies = new ArrayList();
	ArrayList topologyNameList = new ArrayList();
	Hashtable mainTable = new Hashtable();	
	if(addedTables!=null && addedTables.size()>0)
	{
		int cnt=0;
		Enumeration addEnum = addedTables.keys();
		while(addEnum.hasMoreElements())
		{
			Hashtable LinesToAdd = new Hashtable();
			String levelComp = (String)addEnum.nextElement();
			ArrayList topoNameList = (ArrayList)addedTables.get(levelComp);
			if(topoNameList.size()==1 || topoNameList.size()==0)
				continue;
			
			String topoName="";
			for(int k=0;k<topoNameList.size();k++)
			{
				String name = (String)topoNameList.get(k);
				topoName = topoName+"#"+name;
			}
			topoName = topoName.trim();
			if(topoName.startsWith("#"))
				topoName=topoName.substring(topoName.indexOf("#")+1);			

			if(topologyNameList.contains(topoName))
				continue;
			
			cnt++;
			topologyNameList.add(topoName);
			String name = topoName;
			if(name!=null && name.indexOf("#")>-1)
			{
				StringTokenizer strTok = new StringTokenizer(name,"#");
				while(strTok.hasMoreTokens())
				{
					String token = (String)strTok.nextToken();
					if(!combinedTopologies.contains(token))
						combinedTopologies.add(token);
					
					if(topologyLinesToSave!=null && topologyLinesToSave.containsKey(token))
					{
						Hashtable lineTable = (Hashtable)topologyLinesToSave.get(token);
						Enumeration topoKey = lineTable.keys();
						while(topoKey.hasMoreElements())
						{
							String lineVar = (String)topoKey.nextElement();							
							String lineVal = (String)lineTable.get(lineVar);
							LinesToAdd.put(lineVar,lineVal);							
						}
					}

				}
			}				
			mainTable.put("Auto_topology_"+cnt,LinesToAdd);
		}
	}
	
	int count = mainTable.size();
	Hashtable finalTable = new Hashtable();
	if(combinedTopologies!=null && combinedTopologies.size()>0)
	{
		int cnt=count;
		if(topologyNamesList!=null && topologyNamesList.size()>0)
		{
			for(int v=0;v<topologyNamesList.size();v++)
			{
				String variable = (String)topologyNamesList.get(v);
				Hashtable LinesToAdd = new Hashtable();
				if(!combinedTopologies.contains(variable))
				{
					if(topologyLinesToSave!=null && topologyLinesToSave.containsKey(variable))
					{
						Hashtable lineTable = (Hashtable)topologyLinesToSave.get(variable);
						Enumeration topoKey = lineTable.keys();
						while(topoKey.hasMoreElements())
						{
							String lineVar = (String)topoKey.nextElement();
							String lineVal = (String)lineTable.get(lineVar);
							LinesToAdd.put(lineVar,lineVal);			
						}
					}
					cnt = cnt+1;
					mainTable.put("Auto_topology_"+cnt,LinesToAdd);
				}
			}
		}
	}

	String[] autovars = autoTopoIni.getVariables("INCOMPLETE_SEGMENT");
	ArrayList modifyTopologyList = new ArrayList();
	Hashtable modifiedTopoLines = new Hashtable();
	if(autovars!=null && autovars.length>0)
	{
		for(int v=0;v<autovars.length;v++)
		{
			String variable = autovars[v];			
			if(variable.startsWith("AUTO_TOPOLOGY_"))
			{
				if(!modifyTopologyList.contains(variable))
					modifyTopologyList.add(variable);
				
				String[] lines = autoTopoIni.getLinesUnderSubject(variable);
				if(lines!=null && lines.length>0)
				{
					for(int l=0;l<lines.length;l++)
					{
						String line = lines[l];					
						if(modifiedTopoLines.containsKey(variable))
						{
							ArrayList arr = (ArrayList)modifiedTopoLines.get(variable);
							if(!arr.contains(line))
								arr.add(line);
							modifiedTopoLines.put(variable,(ArrayList)arr);
						}
						else
						{
							ArrayList arr = new ArrayList();
							if(!arr.contains(line))
								arr.add(line);
							modifiedTopoLines.put(variable,(ArrayList)arr);
						}
					}
				}
			}
		}		
	}
	
	int mcount=0;
	if(mainTable!=null && mainTable.size()>0)
	{
		topoCompToDisplay = new Hashtable();
		finalTopologyList = new ArrayList();
		Enumeration mainKeys = mainTable.keys();
		while(mainKeys.hasMoreElements())
		{
			String topologyName = (String)mainKeys.nextElement();			
			Hashtable topoLines = (Hashtable)mainTable.get(topologyName);
			if(topoLines!=null && topoLines.size()>0)
			{
				mcount++;
				if(modifyTopologyList.contains("AUTO_TOPOLOGY_"+mcount))
				{
					String allLines[] = autoTopoIni.getLinesUnderSubject("AUTO_TOPOLOGY_"+mcount);
					autoTopoIni.deleteSubject("AUTO_TOPOLOGY_"+mcount);			
					if(allLines!=null && allLines.length>0)
					{
						ArrayList componentList = new ArrayList();
						for(int a=0;a<allLines.length;a++)
						{
							String line = allLines[a];
							String lineVar = line.substring(0,line.indexOf("="));
							String lineVal = line.substring(line.indexOf("=")+1);

							/*ArrayList deletedList = getDeletedComponents(lineVar,lineVal);			
							if(deletedList!=null && deletedList.contains(lineVar))
								continue;*/
							
							if(!componentList.contains(lineVar))
								componentList.add(lineVar);
							String resultStr = "";
							if(!lineVal.equals("null"))	
							{
								if(lineVal.indexOf(",")==-1)
								{
									String val=lineVal;
									if(lineVal.endsWith(":L") || lineVal.endsWith(":N"))
										val = lineVal.substring(0,lineVal.lastIndexOf(":"));

									//if(deletedList!=null && !deletedList.contains(val))
									//{
										resultStr = lineVal;
										if(!componentList.contains(val))
											componentList.add(val);
									//}
										
								}
								else 
								{
									StringTokenizer stVal = new StringTokenizer(lineVal,",");
									while(stVal.hasMoreTokens())
									{
										String tok = (String)stVal.nextToken();
										String tt=tok;
										if(tok.endsWith(":L") || tok.endsWith(":N"))
											tt = tok.substring(0,tok.lastIndexOf(":"));
										//if(deletedList!=null && !deletedList.contains(tt))
										//{
											resultStr = resultStr+","+tok;
											if(!componentList.contains(tt))
												componentList.add(tt);
										//}
									}
								}								
							}
							if(resultStr.startsWith(","))
								resultStr = resultStr.substring(resultStr.indexOf(",")+1);
							resultStr = resultStr.trim();
							if(resultStr.length()>0)
							{
								autoTopoIni.setValue("AUTO_TOPOLOGY_"+mcount,lineVar,resultStr);
								topoCompToDisplay.put("AUTO_TOPOLOGY_"+mcount, componentList);
							}
						}	
						autoTopoIni.saveFile();						
					}		
					ArrayList check = (ArrayList)topoCompToDisplay.get("AUTO_TOPOLOGY_"+mcount);
					if(check==null || check.size()==0)
					{
						String str = "AUTO_TOPOLOGY_"+mcount;
						Object ob = str;
						int index = modifyTopologyList.indexOf(ob);
						modifyTopologyList.remove(index);
						mcount=mcount-1;
						
					}
					else
					{
						if(!finalTopologyList.contains("AUTO_TOPOLOGY_"+mcount))
							finalTopologyList.add("AUTO_TOPOLOGY_"+mcount);
					}
					mcount = searchAvailableTopoName(topoLines,mcount,modifyTopologyList,autoTopoIni,modifiedTopoLines);
				}
				else
				{
					boolean exists = isTopoLinesExist(modifiedTopoLines,topoLines);
					if(!exists)
					{
						autoTopoIni.deleteSubject("AUTO_TOPOLOGY_"+mcount);			
						ArrayList componentList = new ArrayList();
						Enumeration topoKey = topoLines.keys();
						while(topoKey.hasMoreElements())
						{
							String lineVar = (String)topoKey.nextElement();
							String lineVal = (String)topoLines.get(lineVar);
							
							if(!componentList.contains(lineVar))
								componentList.add(lineVar);
							if(!lineVal.equals("null"))	{
								StringTokenizer stVal = new StringTokenizer(lineVal,",");
								while(stVal.hasMoreTokens())
								{
									String token = (String)stVal.nextToken();
									if(token.endsWith(":L") || token.endsWith(":N"))
										token = token.substring(0,token.lastIndexOf(":"));
									if(!componentList.contains(token))
										componentList.add(token);
								}
							}
							topoCompToDisplay.put("AUTO_TOPOLOGY_"+mcount, componentList);					
							autoTopoIni.setValue("AUTO_TOPOLOGY_"+mcount,lineVar,lineVal);					
						}	
						autoTopoIni.setValue("AUTO_TOPOLOGY_LIST", "AUTO_TOPOLOGY_"+mcount, "AUTO_TOPOLOGY_"+mcount);
						if(!finalTopologyList.contains("AUTO_TOPOLOGY_"+mcount))
							finalTopologyList.add("AUTO_TOPOLOGY_"+mcount);
					}
					else
						mcount=mcount-1;
				}				
			}
			autoTopoIni.saveFile();		
		}
		
		// To delete unwanted topologies
		String[] autoListVars = autoTopoIni.getVariables("AUTO_TOPOLOGY_LIST");
		if(autoListVars!=null && autoListVars.length>0)
		{
			for(int v=0;v<autoListVars.length;v++)
			{
				String variable = autoListVars[v];			
				if(!finalTopologyList.contains(variable) && !modifyTopologyList.contains(variable))
				{
					autoTopoIni.deleteValue("AUTO_TOPOLOGY_LIST", variable);
					autoTopoIni.deleteSubject(variable);
					autoTopoIni.saveFile();
				}				
				else if(!finalTopologyList.contains(variable) && modifyTopologyList.contains(variable))
				{
					String allLines[] = autoTopoIni.getLinesUnderSubject(variable);
					autoTopoIni.deleteSubject(variable);			
					if(allLines!=null && allLines.length>0)
					{
						ArrayList componentList = new ArrayList();
						for(int a=0;a<allLines.length;a++)
						{
							String line = allLines[a];
							String lineVar = line.substring(0,line.indexOf("="));
							if(!componentList.contains(lineVar))
								componentList.add(lineVar);
							String lineVal = line.substring(line.indexOf("=")+1);
							autoTopoIni.setValue(variable,lineVar,lineVal);

							if(!lineVal.equals("null"))	{
								StringTokenizer stVal = new StringTokenizer(lineVal,",");
								while(stVal.hasMoreTokens())
								{
									String token = (String)stVal.nextToken();
									if(token.endsWith(":L") || token.endsWith(":N"))
										token = token.substring(0,token.lastIndexOf(":"));
									if(!componentList.contains(token))
									{
										componentList.add(token);
									}
								}
							}
							topoCompToDisplay.put(variable, componentList);
						}	
						autoTopoIni.saveFile();
					}
				}
			}
		}		
		//End
	}
	long t2 = System.currentTimeMillis();
	System.out.println("TIME DIfference-----> "+(t2-t1));
	

	String st_search=request.getParameter("egTitleSearchStr");
	st_search=(st_search!=null && st_search.equals(""))?null:st_search;
	boolean isSearchResult =(st_search!=null);
	ArrayList searchList = new ArrayList();
	if (isSearchResult)
	{
		StringTokenizer st = new StringTokenizer(st_search);
		while (st.hasMoreTokens())
		{
			String thisToken = st.nextToken().trim();
			if (thisToken.equals(""))
				continue;
			searchList.add(thisToken);
		}
	}
	String reqfrom = request.getParameter("reqfrom");
	reqfrom = (reqfrom == null ?"":reqfrom);

%>
<html>
<head>
<title>Show Auto Topology</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<egui:skin ui = "admin"/>

<script language="JavaScript" src="/final/admin/eg_scripts/ajaxutils.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
<script language="JavaScript1.2" src="eg_scripts/validate.js"></script>
<script  src="/final/jquery/jquery.js"></script>
<script  src="/final/jquery/ui/jquery.ui.core.js"></script>
<script  src="/final/jquery/ui/jquery.ui.widget.js"></script> 
<script  src="/final/jquery/ui/jquery.ui.mouse.js"></script>
<script  src="/final/jquery/ui/jquery.ui.draggable.js"></script>
<script  src="/final/jquery/ui/jquery.ui.resizable.js"></script>

<script type="text/javascript">
var $j = jQuery.noConflict();

$j(document).ready(function(){

	$j.globalVars = {
		maxHeight: $j(window).height(),
		maxWidth:  $j(window).width()
	};
	
	$j( "#PreviewDiv" ).draggable({ 
		cancel: "tr.ui-widget-header-temp",
		cursor: "move",
		scroll: false
		//containment: [-parseInt($j.globalVars.maxWidth),0, parseInt($j.globalVars.maxWidth), parseInt($j.globalVars.maxHeight)]
	});

	$j( "#manageAllDiv" ).draggable({ 
		cancel: "tr.ui-widget-header-temp",
		cursor: "move",
		scroll: false
		//containment: [-parseInt($j.globalVars.maxWidth),0, parseInt($j.globalVars.maxWidth), parseInt($j.globalVars.maxHeight)]
	});

});


var customizedPopupDiv="";
var dragStarted=false;
var startX=0;
var startY=0;
var windowWidth="";
var windowHeight="";
function startDrag(event,divId)
{
	if(divId!=null && divId!='undefined')
	{
		customizedPopupDiv=document.getElementById(divId);
		if(!isIE())
		{
			windowHeight = window.innerHeight;
			windowWidth = window.innerWidth;
		}
		else
		{
			windowWidth=document.body.clientWidth;
			windowHeight=document.body.clientHeight;
		}
		document.body.style.cursor="move";
		if(navigator.appName=="Microsoft Internet Explorer")
		{
			event=window.event;
		}
		if(customizedPopupDiv!=null)
		{
			startX=event.clientX-parseInt(customizedPopupDiv.style.left);
			startY=event.clientY-parseInt(customizedPopupDiv.style.top);
		}
		dragStarted=true;
	}
}
function drag(event)
{
	var iframe1=document.getElementById("previewFrame");
	if(navigator.appName=="Microsoft Internet Explorer")
	{
		event=window.event;
	}
	if(dragStarted)
	{
		if(customizedPopupDiv!=null)
		{
			var clickXPos=event.clientX;
			var clickYPos=event.clientY;
			var rightMaxPos=windowWidth;
			var leftMaxPos=0;
			var customizedDivXStartPos=(clickXPos-startX);

			if((customizedDivXStartPos+580)<=rightMaxPos)
			{
				customizedPopupDiv.style.left=customizedDivXStartPos;
				if(iframe1!=null)
					iframe1.style.left=customizedDivXStartPos;
			}
		
			customizedPopupDiv.style.top=(clickYPos-startY);
			if(iframe1!=null)
				iframe1.style.top=(clickYPos-startY);
		}
	}
}

function endDrag(event)
{
	document.body.style.cursor="default";
	if(navigator.appName=="Microsoft Internet Explorer")
	{
		event=window.event;
	}
	startX=0;
	startY=0;
	dragStarted=false;
}

documentView ={
		getObject: function(){
			if(typeof( window.innerWidth) == 'number'){//Firefox
				this.height = window.innerHeight;
				this.width = window.innerWidth;
				this.fireFox = true;
			}
			else if( document.documentElement && ( document.documentElement.clientWidth
				|| document.documentElement.clientHeight )){//IE 6 + in 'standards compliant mode'
				this.height = document.documentElement.clientHeight;
				this.width = document.documentElement.clientWidth;
				this.ie = true;
			}
			else if(document.body && document.body.clientHeight){ //IE 4 compatible
				this.height = document.body.clientHeight;
				this.width = document.body.clientWidth;
				this.ie = true;
			}
			return this;
		},
		getHeight: function(){
			return this.getObject().height;
		},
		getWidth: function(){
			return this.getObject().width;
		},
		isIE: function(){
				return this.getObject().ie;
		},
		isFireFox: function(){
				return this.getObject().fireFox;
		}
};

function createRequestObject()
{
	var request_o;
	var browser = navigator.appName;
	if(browser == "Microsoft Internet Explorer")
		request_o = new ActiveXObject("Microsoft.XMLHTTP");
	else
		request_o = new XMLHttpRequest();
	return request_o;
}

function removeFocus(id){
	return ;
	var obj = document.getElementById(id);
		obj.onmousemove=function(){
			obj.style.display = "block";
			obj.style.visible = "visible";
		}
		obj.onmouseout=function(){
			obj.style.display = "none";
			obj.style.visible = "hidden";
		}
}

function isNetscape() 
{
   // get browser info. 
   appName= navigator.appName;
   appLongVer = navigator.appVersion;
   appVer = appLongVer.substring(0, 1); 

   // check for Navigator ver 4+. 
   if ((appName == "Netscape") && (appVer >= 4)) return true;
   return false;
}

function isIE() 
{
   // get browser info. 
   appName= navigator.appName;
   appLongVer = navigator.appVersion;
   appVer = appLongVer.substring(0, 1); 

   // check for IE ver 4+. 
   if ((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
   return false;
}

function ShowPreview(segmentName,event,position)
{
	var previewFrame = document.getElementById("previewFrame");
	var PreviewTitle = document.getElementById("PreviewTitle");
	var href = 'EgAutoPreviewPage.jsp?segment='+encodeURI(segmentName)+"&preview=true";
	var maxInd = maxIndex();
	
	if(!isIE())
	{
		var frame = document.getElementById("previewFrame"),
		frameDoc = frame.contentDocument || frame.contentWindow.document;
		frameDoc.documentElement.innerHTML = "<table width='100%' border='0' bgcolor='white' height='300px'><tr><td align=center valign=middle><img src=/final/admin/eg_images/indicator_medium.gif></td></tr><tr><td align=center valign=top></td></tr></table>";
	}
	else if(isIE())
	{
		window["previewFrame"].document.body.innerHTML="<table width='100%' border='0' bgcolor='white' height='300px'><tr><td align=center valign=middle><img src=/final/admin/eg_images/indicator_medium.gif></td></tr><tr><td align=center valign=top></td></tr></table>";
	}
	
	$j("#PreviewTitle").text("");
	$j("#PreviewTitle").append(" <egui:intnl text='monitor.layermodel.Topology Preview for '/> "+segmentName);
	$j("#PreviewDiv").css({"display":"block" , "position":"absolute" });
	$j("#PreviewDiv").css({"z-index":maxInd+1});
	$j("#PreviewDiv").show('slow');
	previewFrame.src = href;

	if (!isIE())
	{
		var relatedDiv=document.getElementById('PreviewDiv');
		if(relatedDiv!=null&&relatedDiv!="Undefined")
		{
			if (!event) 
				event = window.event;
			if(position=='mouse')
				relatedDiv.style.left=(event.clientX)+15+document.body.scrollLeft;
			else if(position=='button')
				relatedDiv.style.left=(event.clientX)-700+document.body.scrollLeft;
			relatedDiv.style.top=(event.clientY)-5+document.body.scrollTop;
			relatedDiv.style.visibility='visible';
			relatedDiv.style.display='block';
		}
	}
	if (isIE())
	{
		relatedDiv=document.all['PreviewDiv'];
		if(relatedDiv!=null&&relatedDiv!="Undefined")
		{
			if(position=='mouse')
				relatedDiv.style.left=(event.clientX)+15+document.body.scrollLeft;
			else if(position=='button')
				relatedDiv.style.left=(event.clientX)-700+document.body.scrollLeft;
			relatedDiv.style.top=(event.clientY)-5+document.body.scrollTop;
			relatedDiv.style.visibility='visible';
			relatedDiv.style.display='block';
		}
	}

}
function maxIndex()
{
	var index_highest = 0;
	$j('div').each(function(){
		var index_current = parseInt($j(this).css("z-index"), 10);
		if(index_current > index_highest) {
			index_highest = index_current;
		}
	});
	return index_highest.toString();
}

function hideDivs(divId)
{
	$j("#"+divId).hide("slow");
}

function egTitleSearch()
{
	var searchSt=document.AutoTopologyPreview.egTitleSearchStr.value;
	if(searchSt==null || searchSt=="")
	{
		window.location.href = 'EgDispAutoTopology.jsp?reqfrom=<%=reqfrom%>';
	}
	else
	{
		window.location.href = "EgDispAutoTopology.jsp?egTitleSearchStr="+encodeURI(searchSt)+"&reqfrom=<%=reqfrom%>";
	}
}

jQuery.fn.center = function (){
	this.css("position","absolute");
	this.css("top", (($j(window).height() - this.outerHeight()) / 2) + $j(window).scrollTop() + "px");
	this.css("left", (($j(window).width() - this.outerWidth()) / 2) + $j(window).scrollLeft() + "px");
	return this;
}

function saveOption(thissegment,toSave,event)
{
	$j("#innerManageAllDiv").html("");
	var val='saveAs';
	var urlToDisplay ="EgAutoManagePage.jsp?segment="+encodeURI(thissegment)+"&action="+val+"&zone=-1";
	$j.ajax({	
			type: "POST",
			url: urlToDisplay,
			data: "saveFrom=previewPage",
			success: function(msg) { 
				$j("#innerManageAllDiv").html(msg); 
				var maxInd = maxIndex();
				$j("#manageAllDiv").css({"z-index":maxInd+1});
				$j("#manageAllDiv").css({"display":"block" , "position":"absolute" });
			}
	});
	
	if(toSave =='AutoManageComponent')
		$j("#manageAllDiv").center();
	else
	{
		if (!isIE())
		{
			var relatedDiv=document.getElementById('manageAllDiv');
			if(relatedDiv!=null&&relatedDiv!="Undefined")
			{
				if (!event) 
					event = window.event;
				
				relatedDiv.style.left=(event.clientX)-650+document.body.scrollLeft;
				relatedDiv.style.top=(event.clientY)-5+document.body.scrollTop;
				relatedDiv.style.visibility='visible';
				relatedDiv.style.display='block';
			}
		}
		if (isIE())
		{
			relatedDiv=document.all['manageAllDiv'];
			if(relatedDiv!=null&&relatedDiv!="Undefined")
			{
				relatedDiv.style.left=(event.clientX)-650+document.body.scrollLeft;
				relatedDiv.style.top=(event.clientY)-5+document.body.scrollTop;
				relatedDiv.style.visibility='visible';
				relatedDiv.style.display='block';
			}
		}
	}
}

function hideDivAndRefresh(id)
{
	$j("#"+id).hide("slow");
}

function ReDisplayManageAllDiv(thissegment,str,event)
{
	//saveOption(thissegment,str,event);
	$j("#manageAllDiv").hide("slow");
}

document.onkeydown = KeyCheck;
function KeyCheck(e)
{
	if(!e)
		var e = window.event;
	if (e.keyCode) 
		code = e.keyCode;
	else if (e.which)
		code = e.which;
	if(code==13)
		egTitleSearch();
}

</script>
</head>
<body>
<form name="AutoTopologyPreview" method="post" onSubmit="return false;" style="margin:0px">
<%
	String popup_topright = isMSIE6?"popup_topright_noshade":"popup_topright";
	String popup_rightbg = isMSIE6?"popup_rightbg_noshade":"popup_rightbg";
	String popup_bottomleft = isMSIE6?"popup_bottomleft_noshade":"popup_bottomleft";
	String popup_bottombg = isMSIE6?"popup_bottombg_noshade":"popup_bottombg";
	String popup_bottomright = isMSIE6?"popup_bottomright_noshade":"popup_bottomright";
%>
<!-- Preview Div -->
<div id="PreviewDiv" name="PreviewDiv" class="ui-widget-content" style="display:none;left:10px;top:50px;width:750px;height:450px;border:0px solid #ffff00; position:absolute;">
<table border="0" bordercolor="blue" cellpadding="0" cellspacing="0">
	<tr>
		<td colspan="3" width="100%">
			<table border="0"  cellpadding="0" cellspacing="0" width="100%" >
				<tr>
					<td width="10" height="27" class="popup_topleft"><img src="/final/monitor/eg_images/spacer.gif" width="10" height="27" border="0"></td>
					<td id="PreviewTitle" class="popup_topbg eg_75bold whitefont"  height="27px"><egui:intnl text='monitor.layermodel.Topology Preview '/></td>
					<td align="right" class="popup_topbg"><img class="png" src="/final/monitor/eg_images/<%=admin_Skin%>/popup_close.png" border="0" class="mouse" title="close" vspace="2" onclick="javascript:hideDivs('PreviewDiv');"> </td>
					<td width="17" height="27" class="<%=popup_topright%>"><img src="/final/monitor/eg_images/spacer.gif" width="17" height="27" border="0"></td>
				</tr>
			</table>
		</td>
	</tr>
	<tr class="ui-widget-header-temp">
		<td class="popup_leftbg"  width="7px"><img src="/final/monitor/eg_images/spacer.gif" width="7"></td>
		<td align="center" valign="top" >
				<table border="0" bordercolor="green" cellpadding="0" cellspacing="0" width="100%" height="100%">
					<tr>
						<td class="white_bg">
							<iframe frameborder="0" src="" width="720px" height="400px"  id="previewFrame" name="previewFrame" align="center"> 
							</iframe>
						</td>
					</tr>
				</table>
		</td>
		<td class="<%=popup_rightbg%>" width="14px"><img src="/final/monitor/eg_images/spacer.gif" width="14"></td>
	</tr>
	<tr class="ui-widget-header-temp">
		<td class="<%=popup_bottomleft%>"><img src="/final/monitor/eg_images/spacer.gif" width="7" height="16"></td>
		<td class="<%=popup_bottombg%>" height="16"><img src="/final/monitor/eg_images/spacer.gif"></td>
		<td class="<%=popup_bottomright%>"><img src="/final/monitor/eg_images/spacer.gif" width="14" height="16"></td>
	</tr>
</table>
</div>

<!----- Save Div------>
<div id="manageAllDiv" name="manageAllDiv" style="display:none;left:10px;top:100px;width:670px;height:250px;border:0px solid #ffff00; position:absolute;">
<table border="0" bordercolor="blue" cellpadding="0" cellspacing="0">
	<tr>
		<td colspan="3" width="100%">
			<table border="0"  cellpadding="0" cellspacing="0" width="100%" >
				<tr>
					<td width="10" height="27" class="popup_topleft"><img src="/final/monitor/eg_images/spacer.gif" width="10" height="27" border="0"></td>
					<td id="manageAllDivTitle" class="popup_topbg eg_75bold whitefont"  height="27px"><egui:intnl text='admin.server.Save Topology as'/></td>
					<td align="right" class="popup_topbg"><img class="png" src="/final/monitor/eg_images/<%=admin_Skin%>/popup_close.png" border="0" class="mouse" title="close" vspace="2" onclick="javascript:hideDivs('manageAllDiv');"> </td>
					<td width="17" height="27" class="<%=popup_topright%>"><img src="/final/monitor/eg_images/spacer.gif" width="17" height="27" border="0"></td>
				</tr>
			</table>
		</td>
	</tr>
	<tr class="ui-widget-header-temp">
		<td class="popup_leftbg"  width="7px"><img src="/final/monitor/eg_images/spacer.gif" width="7"></td>
		<td align="center" valign="top" >
				<table border="0" bordercolor="green" cellpadding="0" cellspacing="0" width="100%" height="100%">
					<tr>
						<td class="white_bg">
							<div class="div_scroll" id="innerManageAllDiv" name="innerManageAllDiv" style="left:0px;top:0px;width:650px;height:230px;border:0px solid green;"> </div>
						</td>
					</tr>
				</table>
		</td>
		<td class="<%=popup_rightbg%>" width="14px"><img src="/final/monitor/eg_images/spacer.gif" width="14"></td>
	</tr>
	<tr class="ui-widget-header-temp">
		<td class="<%=popup_bottomleft%>"><img src="/final/monitor/eg_images/spacer.gif" width="7" height="16"></td>
		<td class="<%=popup_bottombg%>" height="16"><img src="/final/monitor/eg_images/spacer.gif"></td>
		<td class="<%=popup_bottomright%>"><img src="/final/monitor/eg_images/spacer.gif" width="14" height="16"></td>
	</tr>
</table>
</div>

<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
<%
	session.setAttribute("egBackComplete","/final/admin/EgDispAutoTopology.jsp");
	session.setAttribute("egTitlehref","/final/admin/EgDispAutoTopology.jsp");
	if(reqfrom.equalsIgnoreCase("navlink"))
	{
%>
<jsp:include page="listSearch.jsp?title=LIST OF DISCOVERED TOPOLOGIES&subtitle=true&searchBox=true&backButton=false"/>
<%
	}
	else
	{
%>
<jsp:include page="listSearch.jsp?title=LIST OF DISCOVERED TOPOLOGIES&subtitle=true&searchBox=true&backButton=true"/>
<%
	}
	
	//if auto topology is enabled, and eg_autotoplogy.ini contains [Topo_Auto]
	EgTesterInfo testsInfo = new EgTesterInfo("manager");
	boolean flag = testsInfo.isTopoDiscoveryEnabled();
	IniFile autoTopoIniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini");
	String[] varArray = autoTopoIniFile.getVariables("Topo_Auto");
	boolean isTopoEntry = false;
	if(varArray!=null && varArray.length > 0)
		isTopoEntry = true;

	if(flag && isTopoEntry)
	{
		String[] vars = autoTopoIni.getVariables("AUTO_TOPOLOGY_LIST");
		Vector v_seg = new Vector(Arrays.asList(vars));

		//Vector v_seg = autoTopoIni.getVariables("AUTO_TOPOLOGY_LIST", true);
		if(vars != null && vars.length > 0)
		{
			String thiselement ="";
			String lastvalue="";
			Vector searchVec=new Vector();
			boolean searchItemFound = false;
			for(int i=0;i<v_seg.size();i++)
			{
				thiselement = ((String)v_seg.elementAt(i)).trim();
				if (isSearchResult && !doesExist(searchList,thiselement))
					continue;
				else
					searchVec.add(thiselement);
				searchItemFound=true;
			}
			int x=searchVec.size();
			if(x!=0)
			{
				lastvalue=(String)searchVec.get(x-1);
			}
%>
	<tr>
		<td>
			<table align="center" cellspacing="0" cellpadding="0" width="85%" border="0">
				<tr>
					<td colspan="7">
						<table align="left" cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td id="eg_blankspace" colspan="6" height="6"></td>
							</tr>
						</table>
					</td>
				</tr>
<%		
			List minusHosts = new ArrayList();
			for(int i=0;i<v_seg.size();i++)
			{
				boolean isLastElement = (i+1)<v_seg.size();
				thiselement = ((String)v_seg.elementAt(i)).trim();
				if (isSearchResult && !doesExist(searchList,thiselement))
				{
					minusHosts.add(thiselement);
					continue;
				}
				searchItemFound=true;
			}
			v_seg.removeAll(minusHosts);

			for(int i=0;i<v_seg.size();i++)
			{
				boolean isLastElement = (i+1)<v_seg.size();
				String topologyName = ((String)v_seg.elementAt(i)).trim();
		
				String thiszone = groupinfo.getZoneNameForComponent("Segment:"+topologyName+":NULL");
				if (thiszone==null)
					thiszone="-1";
%>
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="15" height="6"></td>
					<td height="6" id="eg_subcontentbg" width="100%" colspan="5"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr> 
					<td id="eg_subcontentbg"  >&nbsp;</td> 
					<td width="30" align="left" id="eg_subcontentbg" style="padding-top:6px">
						<!--<a href="javascript:void(0);" onmouseover="ShowPreview('<%=topologyName%>',event,'mouse');" onmouseout="removeFocus('topo<%=i%>')" onClick='javascript:window.location.href="EgTopologyMainPage.jsp?segment=<%=EgURLEncoder.encode(topologyName,"UTF-8")%>&fromPage=modifySegment&zone=-1"'><img src="/final/admin/eg_images/lock.gif" border="0"></a>-->
					</td>
					<td width="40"  style="padding-left:7px" id="eg_subcontentbg"  align="center">			
						<a href="javascript:void(0);" onmouseover="ShowPreview('<%=topologyName%>',event,'mouse');" onmouseout="removeFocus('topo<%=i%>')" onClick=''><img src="eg_images/service_gray.gif"  width="32" height="32"></a>
					</td>
					<td width="80%" id="eg_subcontentbg" valign="middle" height="35">&nbsp;
						<a class="body_link" onmouseover="ShowPreview('<%=topologyName%>',event,'mouse');" onmouseout="removeFocus('topo<%=i%>')" href="javascript: void(0);" title="" onClick='javascript:window.location.href="EgTopologyMainPage.jsp?segment=<%=EgURLEncoder.encode(topologyName,"UTF-8")%>&zone=-1&disableSave=true"'><%=topologyName%></a>&nbsp;
					</td>
					<td width="10%" id="eg_subcontentbg"  align="center">						
					</td> 
					<td width="20%" id="eg_subcontentbg" align="right">
						<table>
							<tr>
								<td><input type="button" value='<egui:intnl text="admin.common.Preview"/>' style="width: 66px;height: 20px;" class="eg_lightbutton" onClick="ShowPreview('<%=topologyName%>',event,'button');"></td>
								<td><input type="button" value='<egui:intnl text="admin.common.Modify"/>' style="width: 66px;height: 20px;" class="eg_lightbutton" onClick='javascript:window.location.href="EgTopologyMainPage.jsp?segment=<%=EgURLEncoder.encode(topologyName,"UTF-8")%>&zone=-1&disableSave=true"' ></td>
								<td><input type="button" value='<egui:intnl text="admin.common.Save"/>' style="width: 66px;height: 20px;" class="eg_lightbutton" onClick="javascript:saveOption('<%=topologyName%>','true',event);"></td> 
							</tr>
						</table>
					</td>
					<td width="7" id="eg_subcontentbg"  align="center">&nbsp;</td>
				</tr>
				 <tr>
					<td colspan="7" id="eg_subcontentbg" style="padding:3px" align="center">
						<table border="0" cellspacing="1" cellpadding="3" width="100%" >
							<tr>
								<td class="eg_75"><strong><egui:intnl text="admin.service.Associated Components"/></strong></td>
							</tr>
							<tr>
								<td class="eg_75"> 
<%
				ArrayList associatedComponents = (ArrayList) topoCompToDisplay.get(topologyName);
				String comps = "";
				if(associatedComponents != null && associatedComponents.size() > 0)
				{
					if(associatedComponents.size()>20)
					{
						List lst = associatedComponents.subList(0,20);
						StringBuffer sb = new StringBuffer();
						for(int j=0;j<lst.size();j++)
						{
							String comp = (String) lst.get(j);
							String cType = comp.substring(0, comp.indexOf(":"));
							String compName = comp.substring(comp.indexOf(":")+1);
							if(compName != null && compName.endsWith(":NULL"))
								compName = compName.substring(0, compName.indexOf(":NULL"));
							String compType = _mapping.getComponentTypeDescription(cType);
							sb.append(compName+":"+compType+", ");							
						}
						sb.append("....");
						comps = sb.toString();
					}
					else
					{
						StringBuffer sb = new StringBuffer();
						for(int j=0;j<associatedComponents.size();j++)
						{
							String comp = (String) associatedComponents.get(j);
							String cType = comp.substring(0, comp.indexOf(":"));
							String compName = comp.substring(comp.indexOf(":")+1);
							if(compName != null && compName.endsWith(":NULL"))
								compName = compName.substring(0, compName.indexOf(":NULL"));
							String compType = _mapping.getComponentTypeDescription(cType);
							sb.append(compName+":"+compType+", ");							
						}
						comps = sb.toString();
					}
					if(comps != null && comps.endsWith(", "))
					{
						comps = comps.substring(0,comps.lastIndexOf(","));
					}
				}
%>
								<%=comps%>
								 </td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%" colspan="5" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
				<tr>
					<td colspan="7"><img src="/final/admin/eg_images/spacer.gif" height="11"></td>
				</tr>

<% 
			}
			if (!searchItemFound&&st_search!=null&&!st_search.equals(""))
			{
%>
				<tr>
					<td colspan="7" height="400">
						<table border="0" cellspacing="0" cellpadding="4" width="100%" >
							<tr> 
								<td width="100%" align="center">
								<img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif">
								</td>
							</tr>
							<tr>
								<td width="100%" align="center">
									<b><egui:intnl text="admin.service.No topologies found for your current search"/>&nbsp;"<%=st_search%>"</b>
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%
			}
%>				
			</table>
<%
		}
	}
	else
	{
%>
	<tr>
		<td colspan="3" height="400" valign="middle">
			<table border="0" cellspacing="0" cellpadding="4" width="100%" >
				<tr> 
					<td width="100%" align="center">
					<img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif">
					</td>
				</tr>
				<tr>
					<td width="100%" align="center" id="eg_errorsmall">
					<egui:intnl text="admin.service.There are no topologies discovered currently!"/>
					</td>
				</tr>
			</table>
		</td>
	</tr>
<%
	}
	EgConfigFilesSync.releaseInstance(autoTopoIni);
%>
</table>
<br>
</form>
</body>
</html>
<%!
	private boolean doesExist(List searchList, String thisPolicy)
	{
		Iterator i = searchList.iterator();
		while(i.hasNext())
		{
			String nextStr = (String) i.next();
			if (thisPolicy.indexOf(nextStr)!=-1||(thisPolicy.toUpperCase().indexOf(nextStr.toUpperCase()))!=-1)
				return true;
		}
		return false;
	}

	public String getDisplayValue(String value, jakarta.servlet.jsp.JspWriter out)
	{
		return "TEST";
	}
	
	public ArrayList getDeletedComponents(String variable,String lineValue)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		String disIniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_discover.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		IniFile disIniFile = new IniFile(disIniFilePath);
		String newstr = "#New|";
		String unmanagestr = "#Unmanage|";
		
		Hashtable result = new Hashtable();
		ArrayList newList = new ArrayList();
		ArrayList unmanageList = new ArrayList();
		ArrayList deletedList = new ArrayList();
		Set newSet = new TreeSet();
		Set unmanageSet = new TreeSet();
		Set deletedSet = new TreeSet();

		if(variable.length()> 0 && !variable.equals("null"))
		{
			String varName = variable;
			StringTokenizer stz = new StringTokenizer(varName,":");
			int count = stz.countTokens();			

			String thisCompName = varName.substring(0,varName.indexOf(":"));
			String newValue = disIniFile.getValue(thisCompName,newstr+varName);
			String unmanageValue = disIniFile.getValue(thisCompName,unmanagestr+varName);
			String deletedValue = disIniFile.getValue(thisCompName,varName);

			if(newValue!=null && newValue.length() > 0)	// Check for new component
			{
				newSet.add(varName);
			}
			else if(unmanageValue!=null && unmanageValue.length() > 0)	// Check for unmanage component
			{
				unmanageSet.add(varName);
			}
			else
			{
				boolean isOracle= false;
				if(count == 4)	
					isOracle = true;
				
				if(!isOracle)
				{
					if(deletedValue==null || deletedValue.length()==0)
					{
						deletedSet.add(varName);
					}
				}
				else if(isOracle)
				{				
					String variable2 = varName.substring(0,varName.lastIndexOf(":"));
					String deletedVals = disIniFile.getValue(thisCompName,variable2);
					String newvals = disIniFile.getValue(thisCompName,newstr+variable2);
					String unmanageVals = disIniFile.getValue(thisCompName,unmanagestr+variable2);
					if((newvals==null || newvals.length()==0)&&(unmanageVals==null || unmanageVals.length()==0))
					{
						if((deletedVals==null || deletedVals.length()==0) && (deletedValue==null || deletedValue.length()==0))
						{
							deletedSet.add(varName);
						}								
					}
				}				
			}
		}
		
		if(lineValue!=null && !lineValue.equals("null"))			
		{
			String valName = lineValue;
			StringTokenizer st = new StringTokenizer(valName,",");
			while(st.hasMoreTokens())
			{
				String tok = st.nextToken();
				String tmpcompname = tok.substring(0,tok.indexOf(":"));
				String tmpvar = tok.substring(0,tok.lastIndexOf(":"));
				StringTokenizer str = new StringTokenizer(tmpvar,":");
				int cnt = str.countTokens();		


				String newval = disIniFile.getValue(tmpcompname,newstr+tmpvar);
				String unmanageVal = disIniFile.getValue(tmpcompname,unmanagestr+tmpvar);
				String deletedVal = disIniFile.getValue(tmpcompname,tmpvar);

				if(newval!=null && newval.length() > 0)
				{
					newSet.add(tmpvar);
				}
				else if(unmanageVal!=null && unmanageVal.length() > 0)
				{
					unmanageSet.add(tmpvar);
				}
				else
				{
					boolean isOracle= false;
					if(cnt == 4)
						isOracle = true;
					
					if(!isOracle)
					{
						if(deletedVal==null || deletedVal.length()==0)
						{
							deletedSet.add(tmpvar);
						}
					}
					else if(isOracle)
					{				
						String variable1 = tmpvar.substring(0,tmpvar.lastIndexOf(":"));
						String newvals = disIniFile.getValue(tmpcompname,newstr+variable1);
						String unmanageVals = disIniFile.getValue(tmpcompname,unmanagestr+variable1);
						String deletedVals = disIniFile.getValue(tmpcompname,variable1);
						if((newvals==null || newvals.length()==0) && (unmanageVals==null || unmanageVals.length()==0))
						//if(newvals==null || unmanageVals==null)
						{
							if((deletedVals==null || deletedVals.length()==0) && (deletedVal==null || deletedVal.length()==0))
							{
								deletedSet.add(tmpvar);
							}								
						}
					}
				}
			}
		}
		
		if(deletedSet!=null && deletedSet.size() > 0)
			deletedList = new ArrayList(deletedSet);
		
		return deletedList;
	}


	
%>
<%
if(request.getQueryString()!=null)
session.setAttribute("adminLastAccessedURL","/final/admin/EgDispAutoTopology.jsp?"+request.getQueryString());
else session.setAttribute("adminLastAccessedURL","/final/admin/EgDispAutoTopology.jsp");
%>



<%!
	public Hashtable joinTopologies(Hashtable topoTable,Hashtable finalTopoTable,ArrayList resultList,String compareKey,Hashtable TopoWithStartComp)
	{
		
		int hashSize = topoTable.size();
		int k=0;
		if(topoTable!=null && topoTable.size()>0)
		{
			Enumeration allKeys = topoTable.keys();
			while(allKeys.hasMoreElements())
			{
				String startComp =  (String)allKeys.nextElement();
				if(resultList.contains(startComp)) //|| startingComponent.equals(startComp))
					continue;
				
				resultList.add(startComp);				
				Hashtable secondLevel = (Hashtable)topoTable.get(startComp); 
				Enumeration e = secondLevel.keys();
				{
					String secondLevelKey="";
					while(e.hasMoreElements())
					{
						secondLevelKey = (String)e.nextElement();						
						if(compareKey.equals(secondLevelKey))
						{
							if(finalTopoTable.containsKey(secondLevelKey))
							{
								ArrayList arr = (ArrayList)finalTopoTable.get(secondLevelKey);
								if(TopoWithStartComp.containsKey(startComp))
								{
									String value = (String)TopoWithStartComp.get(startComp);
									if(!arr.contains(value) && !value.equals(""))
										arr.add(value);
								}
								finalTopoTable.put(compareKey,arr);								
							}
							else
							{
								ArrayList arr = new ArrayList();
								if(TopoWithStartComp.containsKey(startComp))
								{
									String value = (String)TopoWithStartComp.get(startComp);
									if(!arr.contains(value) && !value.equals(""))
										arr.add(value);
								}
								finalTopoTable.put(compareKey,arr);
							}							
						}						
						else
						{
							//Get Third Level
							Hashtable thirdLevelTable = (Hashtable)secondLevel.get(secondLevelKey);
							if(thirdLevelTable!=null && thirdLevelTable.size()>0)
							{
								String thirdLevelKey="";
								Enumeration et = thirdLevelTable.keys();
								while(et.hasMoreElements())
								{
									thirdLevelKey = (String)et.nextElement();
									if(compareKey.equals(thirdLevelKey))
									{
										if(finalTopoTable.containsKey(thirdLevelKey))
										{
											ArrayList arr = (ArrayList)finalTopoTable.get(thirdLevelKey);
											if(TopoWithStartComp.containsKey(startComp))
											{
												String value = (String)TopoWithStartComp.get(startComp);
												if(!arr.contains(value) && !value.equals(""))
													arr.add(value);
											}
											finalTopoTable.put(compareKey,arr);
										}
										else
										{
											ArrayList arr = new ArrayList();
											if(TopoWithStartComp.containsKey(startComp))
											{
												String value = (String)TopoWithStartComp.get(startComp);
												if(!arr.contains(value) && !value.equals(""))
													arr.add(value);
											}
											finalTopoTable.put(compareKey,arr);
										}
									}		
								}
							}
						}
					}
					if(compareKey.equals(""))
						compareKey = secondLevelKey;
					finalTopoTable = joinTopologies(topoTable,finalTopoTable,resultList,compareKey,TopoWithStartComp);
				}
				k++;
			}
		}
		return finalTopoTable;
	}

	
	public int searchAvailableTopoName(Hashtable topoLines,int mcount,ArrayList modifyTopologyList,IniFile autoTopoIni,Hashtable modifiedTopoLines)
	{
		mcount++;
		if(modifyTopologyList.contains("AUTO_TOPOLOGY_"+mcount))
		{
			String allLines[] = autoTopoIni.getLinesUnderSubject("AUTO_TOPOLOGY_"+mcount);
			autoTopoIni.deleteSubject("AUTO_TOPOLOGY_"+mcount);			
			if(allLines!=null && allLines.length>0)
			{
				ArrayList componentList = new ArrayList();
				for(int a=0;a<allLines.length;a++)
				{
					String line = allLines[a];
					String lineVar = line.substring(0,line.indexOf("="));
					String lineVal = line.substring(line.indexOf("=")+1);

					/*ArrayList deletedList = getDeletedComponents(lineVar,lineVal);			
					if(deletedList!=null && deletedList.contains(lineVar))
						continue;*/
					
					if(!componentList.contains(lineVar))
						componentList.add(lineVar);
					String resultStr = "";
					if(!lineVal.equals("null"))	
					{
						if(lineVal.indexOf(",")==-1)
						{
							String val=lineVal;
							if(lineVal.endsWith(":L") || lineVal.endsWith(":N"))
								val = lineVal.substring(0,lineVal.lastIndexOf(":"));

							//if(deletedList!=null && !deletedList.contains(val))
							//{
								resultStr = lineVal;
								if(!componentList.contains(val))
								{
									componentList.add(val);
								}
							//}
								
						}
						else 
						{
							StringTokenizer stVal = new StringTokenizer(lineVal,",");
							while(stVal.hasMoreTokens())
							{
								String tok = (String)stVal.nextToken();
								String tt=tok;
								if(tok.endsWith(":L") || tok.endsWith(":N"))
									tt = tok.substring(0,tok.lastIndexOf(":"));
								//if(deletedList!=null && !deletedList.contains(tt))
								//{
									resultStr = resultStr+","+tok;
									if(!componentList.contains(tt))
										componentList.add(tt);
								//}
							}
						}								
					}
					if(resultStr.startsWith(","))
						resultStr = resultStr.substring(resultStr.indexOf(",")+1);
					resultStr = resultStr.trim();
					if(resultStr.length()>0)
					{
						autoTopoIni.setValue("AUTO_TOPOLOGY_"+mcount,lineVar,resultStr);
						topoCompToDisplay.put("AUTO_TOPOLOGY_"+mcount, componentList);
					}
				}	
				autoTopoIni.saveFile();						
			}		
			ArrayList check = (ArrayList)topoCompToDisplay.get("AUTO_TOPOLOGY_"+mcount);
			if(check==null || check.size()==0)
			{				
				String str = "AUTO_TOPOLOGY_"+mcount;
				Object ob = str;
				int index = modifyTopologyList.indexOf(ob);
				modifyTopologyList.remove(index);
				mcount=mcount-1;
			}
			else
			{
				if(!finalTopologyList.contains("AUTO_TOPOLOGY_"+mcount))
					finalTopologyList.add("AUTO_TOPOLOGY_"+mcount);
			}
			mcount = searchAvailableTopoName(topoLines,mcount,modifyTopologyList,autoTopoIni,modifiedTopoLines);
		}
		else
		{
			boolean exists = isTopoLinesExist(modifiedTopoLines,topoLines);
			if(!exists)
			{
				autoTopoIni.deleteSubject("AUTO_TOPOLOGY_"+mcount);			
				ArrayList componentList = new ArrayList();
				Enumeration topoKey = topoLines.keys();
				while(topoKey.hasMoreElements())
				{
					String lineVar = (String)topoKey.nextElement();
					String lineVal = (String)topoLines.get(lineVar);
					
					if(!componentList.contains(lineVar))
						componentList.add(lineVar);
					if(!lineVal.equals("null"))	{
						StringTokenizer stVal = new StringTokenizer(lineVal,",");
						while(stVal.hasMoreTokens())
						{
							String token = (String)stVal.nextToken();
							if(token.endsWith(":L") || token.endsWith(":N"))
								token = token.substring(0,token.lastIndexOf(":"));
							if(!componentList.contains(token))
								componentList.add(token);
						}
					}
					topoCompToDisplay.put("AUTO_TOPOLOGY_"+mcount, componentList);	
					autoTopoIni.setValue("AUTO_TOPOLOGY_"+mcount,lineVar,lineVal);		
				}	
				autoTopoIni.setValue("AUTO_TOPOLOGY_LIST", "AUTO_TOPOLOGY_"+mcount, "AUTO_TOPOLOGY_"+mcount);
				autoTopoIni.saveFile();

				if(!finalTopologyList.contains("AUTO_TOPOLOGY_"+mcount))
					finalTopologyList.add("AUTO_TOPOLOGY_"+mcount);
			}
			else
				mcount = mcount-1;
		}
		return mcount;
	}

	public boolean isTopoLinesExist(Hashtable modifiedTopoLines,Hashtable topoLines)
	{
		ArrayList previewList = new ArrayList();
		Enumeration topoKey = topoLines.keys();
		while(topoKey.hasMoreElements())
		{
			String lineVar = (String)topoKey.nextElement();
			String lineVal = (String)topoLines.get(lineVar);		
			String wholeLine = lineVar+"="+lineVal;
			if(!previewList.contains(wholeLine))
				previewList.add(wholeLine);
		}	
		if(modifiedTopoLines!=null && modifiedTopoLines.size()>0)
		{
			Enumeration modifyKey = modifiedTopoLines.keys();
			while(modifyKey.hasMoreElements())
			{
				String topoName = (String)modifyKey.nextElement();
				ArrayList topoEntry = (ArrayList)modifiedTopoLines.get(topoName);
				if(topoEntry.size() == previewList.size())
				{	
					List result = new ArrayList(topoEntry);
					result.removeAll(previewList); 
					if(result==null || result.size()==0)
						return true;
				}
			}				
		}
		return false;
	}

%>