<!DOCTYPE html>

<%@ include file="EgTrackerA.jsp" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<html>
<head>
	<meta charset="utf-8">

	<!--Skin color--------->
	<egui:skin ui = "admin"/>

	<!---Components, icons, skin and Core ext script--->
	<script type="text/javascript" src="../extjs/ext-all.js"></script>

	<!-- Fancy Scroll-->
	<script src="/final/jquery/jquery.js"></script>
	<script src="/final/styles/jscrollpane/jquery.jscrollpane.js" ></script>
	<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
	<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>
	<link rel="stylesheet" href="/final/styles/jscrollpane/jquery.jscrollpane.css"/>
	
	<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
	<script language="JavaScript1.2">
		var csrfToken = '<%=strCsrfToken%>';
		var mainPageTitle = '<egui:intnl text="admin.title.Locked Accounts"/>';
		var pageTitle = '<egui:intnl text="admin.title.Locked Accounts"/>';
		var pageDescc = '<egui:intnl description="EgLockedAccounts.jsp"/>';
		var publicJSON = '';
		var appCnt = '';
		// Field Labels
		var Username = '<egui:intnl text="admin.title.User name"/>';
		var noAccMsg = '<egui:intnl text="admin.title.There are no locked accounts available currently"/>';
		var noSearchFound = '<egui:intnl text="admin.common.No user(s) found for your current search"/>';
		var probsErrorMessage = '<egui:intnl text="admin.error.Problem encountered while loading the user interface"/>';
		var requestTimeOut = '<egui:intnl text="admin.error.Response timed out"/>';
		var errorTitle = '<egui:intnl text="admin.user.Error"/>';
		var deleteSingleAckttMsg = '<egui:intnl text="admin.user.Are you sure you want to unlock "/>';
	</script>

	<!-- Application folder -->
	<script type="text/javascript" src="LockedAccounts/app/app.js"></script>

	<script language="javascript">
		Ext.onReady(function(){
			Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};

			Ext.Ajax.on('requestexception', function (conn, response, options) {
				var errorStr = response.responseText;
				if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
				{
					if (errorStr.indexOf("user-session-invalid") != -1)
					{
						callWindow(1);
					}
					else if (errorStr.indexOf("user-deleted") != -1)
					{
						callWindow(2);
					}
					else if (errorStr.indexOf("user-timedout") != -1)
					{
						callWindow(3);
					}
				}
				else
				{
					if (response.status == 302 || (response.timedout != undefined && response.timedout == true))
					{
						Ext.Msg.show({
							title : errorTitle,
							msg : requestTimeOut,
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
					else
					{
						console.log(response.responseText);
						Ext.Msg.show({
							title : errorTitle,
							msg : probsErrorMessage,
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
				}
			});
		});
	</script>
</head>

<body>
<div id="loadmask" class="x-mask-msg x-layer x-mask-msg-default" style="z-index: 19001;left:45%;top:35%;">
	<div class="x-mask-loading" style="position:relative">
		Loading...
	</div>
</div>
</body>

</html>



