<%
/*****************************************************************************************************
* Name				:	EgManagerLogsView.jsp
* Purpose			:	To view the Log Files from the selected Manager.
* @author			:	Munuswamy Reddy T
* @Created Date		:	02-02-2012
* Designing changes :	Jaiwin kumar
******************************************************************************************************/
%>
<%@ include file = "EgTrackerA.jsp"%>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.*"%>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import = "com.eg.EgURLDecoder"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "java.io.*"%>
<%@ page import = "java.text.SimpleDateFormat"%>
<%@ page import = "java.util.ArrayList"%>
<%@ page import = "java.util.StringTokenizer"%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%!
	public ArrayList addFiles(File[] list)
	{
		ArrayList filesList = new ArrayList();
		try
		{
			if(list != null && list.length > 0)
			{
				for(int i=0;i<list.length;i++)
				{
					if(list[i].isFile())
					{
						String mgrLog  = list[i].getName();
						filesList.add(mgrLog);
					}
				}
				Collections.sort(filesList);
			}
		}
		catch(Exception e)
		{
			return filesList;
			//e.printStackTrace();
		}
		return filesList;
	}
%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setDateHeader("Expires", -1);

	User userName = UserRegistry.getInstance().getUser(session.getId());
	String uiFile = "eg_ui.ini";
	String ui_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile uiIniFile = new IniFile(ui_iniFile_dir + uiFile);

	String currentDateFormat = uiIniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	String mgrLogFilePath1 = EgInstallInfo.getInstallDir()+"/manager/logs";
	String mgrLogFilePath2 = EgInstallInfo.getInstallDir()+"/manager/tomcat/logs";

	//get the selected managerIP & log file name
	String managerID = request.getParameter("managerIP");
	String mgrLogFile = request.getParameter("mgrLogFile");
	String downloadFlag = request.getParameter("download");
	String logsDir[] = {"manager/logs"};
	File path2 =new File(mgrLogFilePath2);
	if(path2.isDirectory())
	{
		if( path2 != null && path2.listFiles().length > 0)
			logsDir = new String[]{"manager/logs","tomcat/logs"};
	}
	String logsDirectory = request.getParameter("logsDir");
	if(logsDirectory == null)
		logsDirectory = logsDir[0];

	//Create the instace for getting the manager ip
	EgSpecsInfo specsObj = new EgSpecsInfo("manager");
	if(managerID == null || managerID.length() <= 0)
		managerID = specsObj.getEGServer();

	ArrayList mgrsIPList = new ArrayList();
	ArrayList mgrLogsList = new ArrayList();
	boolean isStandalone = true;
	boolean isPrimary = false;
	boolean isSecondaryManagagerRunning = false;

	//Checking for the manager is cluster supported or not
	if(EgInstallInfo.isClusterSupported)
	{
		EgManagersIniForManager mi = EgManagersIniForManager.getInstance();
		isStandalone = false;
		String pMgrIP = mi.getPrimaryManagerIP();
		mgrsIPList = mi.getSecondaryManagers();
		mgrsIPList.add(pMgrIP+"(Primary)");
		if(managerID != null && !managerID.equals(pMgrIP))
		{
			EgManagerInfo managerInfo = mi.getManagerlInfo(managerID);
			isSecondaryManagagerRunning = managerInfo.isManagerRunning();
			if(isSecondaryManagagerRunning)
			{
				mgrLogFile = EgURLDecoder.decode(request.getParameter("mgrLogFile"),"UTF-8");
				mgrLogsList = PMClusterHelper.getSecondaryManagerLogFiles(managerID ,mgrLogFile, "list","false",logsDirectory);

				if(mgrLogFile == null)
					mgrLogFile = (String)mgrLogsList.get(0);
			}
		}
		else
		{
			isPrimary = true;
		}
	}

	if(isPrimary || isStandalone)
	{
		File mgrLogsPath1 = new File(mgrLogFilePath1);
		File mgrLogsPath2 = new File(mgrLogFilePath2);
		File[] listOfMgrLogFiles1 = mgrLogsPath1.listFiles(); 
		File[] listOfMgrLogFiles2 = mgrLogsPath2.listFiles(); 
		if(logsDirectory.equals("tomcat/logs"))
			mgrLogsList = addFiles(listOfMgrLogFiles2);
		else
			mgrLogsList = addFiles(listOfMgrLogFiles1);

		//Remove the extention type files from manager log filess list(mgrLogsList)
		String fileExtention = uiIniFile.getValue("LOG_FILE_LENGTH", "FileExtention");
		StringTokenizer str = new StringTokenizer(fileExtention , ",");
		while(str.hasMoreTokens())
		{
			String ext = str.nextToken();
			for(int j = 0; j < mgrLogsList.size(); j++)
			{
				String mgrLog = (String)mgrLogsList.get(j);
				if(mgrLog.endsWith(ext))
				{
					mgrLogsList.remove(j);
					j--;
				}
			}
		}
		if(mgrLogFile == null)
			mgrLogFile = (String)mgrLogsList.get(0);
	}

	if(downloadFlag != null && downloadFlag.equalsIgnoreCase("true"))
	{
		String filepath = "";
		if(logsDirectory.equalsIgnoreCase("tomcat/logs"))
			filepath = mgrLogFilePath2+"/"+mgrLogFile;
		else
			filepath = mgrLogFilePath1+"/"+mgrLogFile;
		//String filepath = EgInstallInfo.getInstallDir()+"/"+logsDirectory+"/"+mgrLogFile;
		BufferedReader buf=null;
		PrintWriter myOut=null;
		try
		{
			myOut = response.getWriter();
			File myfile = new File(filepath);
			//set response headers
			response.setContentType("application/text");
			response.setHeader("Content-Disposition","attachment; filename="+mgrLogFile );
			response.setContentLength((int) myfile.length());
			buf = new BufferedReader(new InputStreamReader(new FileInputStream(myfile),"UTF-8"));
			String readBytes = "";
			//read from the file; write to the ServletOutputStream
			if(isSecondaryManagagerRunning)
			{
				ArrayList resultData = PMClusterHelper.getSecondaryManagerLogFiles(managerID ,mgrLogFile,"file","true",logsDirectory);
				if(resultData != null && resultData.size() > 0)
				{
					for(int i = 1;i<resultData.size();i++)
					{
						String data = (String)resultData.get(i);
						data = data.substring(0,data.lastIndexOf("<br>"));
						myOut.write(data+"\n");
					}
				}

			}
			else
			{
				while((readBytes = buf.readLine( )) != null)
				{
					myOut.write(readBytes+"\n");
				}
			}
		}
		catch (IOException ioe)
		{
			throw new ServletException(ioe.getMessage());
		}
		finally
		{
			//close the input/output streams
			if (myOut != null)
				myOut.close();
			if (buf != null)
				buf.close();
		}
		return;
	}

%>
<html>
<head>
<title>eG Manager Logs </title>
<egui:skin ui="admin"/>
<script language="JavaScript1.2" src="/final/jquery/jquery.js"></script>
<script language="JavaScript" src="/final/monitor/eg_scripts/dropdown_menu_hack.js"></script>
<script type="text/javascript">

var loading = false;

//This changeFile() function is used for changing the file names
function changeFile(managerIP,filename,currentDir)
{
	showLoadImage();
	document.getElementById("currentFile").value = filename;
	window.location.href="EgManagerLogsView.jsp?managerIP="+encodeURI(managerIP)+"&mgrLogFile="+encodeURI(filename)+"&logsDir="+encodeURI(currentDir);
}

//This changeIP() function used for change the manager ip's(i.e primary,secondary)
function changeIP(managerIP)
{
	showLoadImage();
	document.getElementById("currentIP").value = managerIP;
	var filename = document.getElementById("currentFile").value;
	var currentDir = document.getElementById("currentDir").value;
	window.location.href="EgManagerLogsView.jsp?managerIP="+encodeURI(managerIP)+"&mgrLogFile="+encodeURI(filename)+"&logsDir="+encodeURI(currentDir);
}

function changeDirectory(managerIP,filename,currentDir)
{
	showLoadImage();
	window.location.href="EgManagerLogsView.jsp?managerIP="+encodeURI(managerIP)+"&mgrLogFile="+encodeURI(filename)+"&logsDir="+encodeURI(currentDir);
}

//This refreshFile() function is used for refresh the file
function refreshFile(managerIP ,filename,currentDir)
{
	if(loading)
	{
		alert('<egui:intnl text="admin.agents.Already Loading a file"/>');
	}
	else
	{
		window.location.href = "EgManagerLogsView.jsp?managerIP="+encodeURI(managerIP)+"&mgrLogFile="+encodeURI(filename)+"&logsDir="+encodeURI(currentDir);
	}
}

function downloadLogFile(managerIP ,filename,currentDir)
{
	if(loading)
	{
		alert('<egui:intnl text="admin.agents.Already Loading a file"/>');
	}
	else
	{
		window.location.href = "EgManagerLogsView.jsp?managerIP="+encodeURI(managerIP)+"&mgrLogFile="+encodeURI(filename)+"&logsDir="+encodeURI(currentDir)+"&download=true";
	}
}


//This showLoadImage() function is used for to show the loading image while loading the file
function showLoadImage()
{
	var loading_image = document.getElementById("loading_image");
	if (loading_image != null)
	{
		selectBoxDisable('true');
		loading_image.style.display = "block";
		loading_image.style.position = 'absolute';
		bringToFront(loading_image);
	}
	var selectObj = document.getElementById("logname");
	var dirObj = document.getElementById("dirId");
	var mgrFlagObj = document.getElementById("mgrFlag");
	if(selectObj != null)
	{
		selectObj.disabled = true;
	}
	if(dirObj != null)
	{
		dirObj.disabled = true;
	}
}

//This selectBoxDisable() funtion is used to disable the list box while loading the file
function selectBoxDisable(value)
{
	var selectFileObj = document.getElementById("logname");
	var dirObj = document.getElementById("dirObj");
	var selectIPObj = document.getElementById("ipname");
	if(selectFileObj!=null)
	{
		if(value == 'true')
		{
			if(selectIPObj != null)
				selectIPObj.disabled = true;
			selectFileObj.disabled = true;
			loading = true;
		}
	}
	if(dirObj != null)
		dirObj.disabled = true;
}

function bringToFront(obj)
{
	if (!document.getElementsByTagName)
		return;
	var divs = getAbsoluteDivs();  
	var max_index = 0;  
	var cur_index;  
	for (i = 0; i < divs.length; i++)
	{
		var item = divs[i];
		if (item == obj || item.style.zIndex == '')
			continue;
		cur_index = parseInt(item.style.zIndex);
		if (max_index < cur_index)
		{
			max_index = cur_index;
		}
	}
		obj.style.zIndex = max_index + 1;
}

function getAbsoluteDivs()  
{
	var arr = new Array();
	var all_divs = document.body.getElementsByTagName("DIV");
	var j = 0;
	for (i = 0; i < all_divs.length; i++)
		if (all_divs.item(i).style.position=='absolute')
		{
			arr[j] = all_divs.item(i);
			j++;
	}
	return arr;
}

var $j = jQuery.noConflict();

	jQuery.fn.egResize = function() {
		var winWidth = $j(window).width();
		var winHeight = $j(window).height();
		
		if (document.all && window.atob)
		{
			$j(".dispDiv").width(winWidth-30);
			$j(".dispDiv").height(winHeight-159);   
		}
		else
		{
			$j(".dispDiv").width(winWidth-30);
			$j(".dispDiv").height(winHeight-135);  
		}
	};

	$j(document).ready(function(){
		$j(document).egResize();
	});

	$j(window).resize(function(){
		$j(document).egResize();
	});
</script>
</head>

<body style="overflow:hidden" scroll="no" leftmargin="0" topmargin="0" marginheight="0" marginwidth="0">
<table border="0" align="center" cellspacing="0" cellpadding="0" width="100%" bordercolor="red">
	<jsp:include page="listSearch.jsp?title=MANAGER - LOGS&leftString=Add User&backButton=false&subtitle=false"/>
	<tr>
		<td width="100%" class="white_bg" valign="top" align="center">
			<table border="0" cellspacing="0" cellpadding="0" class="linesquare" height="100%">
				<tr>
<%
	// Cluster manager (Starts)
	if(EgInstallInfo.isClusterSupported)
	{
%>
					<td width="95%" style="padding-top:3px" class="linebg">
						<div style="float:left;border:0px solid green;padding:4px;width:160px" >&nbsp;&nbsp;
						<egui:intnl text='admin.manager.Manager IP/Nickname'/></div>
						<div style="float:left;border:0px solid green;padding:2px" ></div>
						<div style="float:left;border:0px solid green;padding:2px" ><select id="ipname" name="ipname" onchange="javascript:changeIP(this.value)" style="width:180px;" onfocus="window.dropdown_menu_hack(this);">
<%
		for(int k=0;k<mgrsIPList.size();k++)
		{
			String ip = (String)mgrsIPList.get(k);
			String name = ip;
			if(name.indexOf("(") > 0)
			{
				name = name.substring(0,name.indexOf("("));
			}
			String selected = "";
			if(name.equals(managerID))
				selected="selected";

			if(ip.indexOf("(") > 0)
			{
%>
							<option value="<%=name%>"<%=selected%> title="<%=name%>"><b><%=name%>&nbsp;(<egui:intnl text='admin.manager.Primary'/>)</b></option>
<%
			}
			else
			{
%>
							<option value="<%=name%>"<%=selected%> title="<%=name%>" ><b><%=ip%></b> </option>
<%
			}
		}
%>
						</select>
						<input type="hidden" name="currentDir" id="currentDir" value="<%=logsDirectory%>"/>
						<input type="hidden" name="currentIP" id="currentIP" value="<%=managerID%>"/></div>
<%
	//Cluster manager (End)
	}
	else
	{
%>
					<td width="100%" style="padding-top:3px" class="linebg">
						<div style="float:left;border:0px solid green;padding:4px;width:160px" >&nbsp;&nbsp;
						<egui:intnl text='admin.manager.Manager IP/Nickname'/></div>
						<div style="float:left;border:0px solid green;padding:2px" ></div>
						<div style="float:left;border:0px solid green;padding:2px" ><b><%=managerID%></b></div>
<%
	}
%>

						<div style="float:right;border:0px solid green;padding:2px;width:400px" >
							<div style="float:left;border:0px solid green;padding:2px;width:110px" >
							<egui:intnl text='admin.manager.Log file directory'/></div>
							<div style="float:left;border:0px solid green;padding:2px" ></div>
							<div style="float:left;border:0px solid green" >
<%
	//If there is no file in the managers logs directory then hide the selection box
	if(mgrLogsList == null || mgrLogsList.size() <= 0)
	{
%>
								<select disabled id="logname" name="logname" onchange="javascript:changeFile('<%=managerID%>', this.value,'<%=logsDirectory%>')" style="width:250px;" onfocus="window.dropdown_menu_hack(this);">
									<option><b><egui:intnl text='admin.manager.No log file found'/></b></option>
								</select>
							</div>
							<div id="refreshDiv" style="float:left;border:0px solid green" >&nbsp;
							<a href="javascript:void(0);" class="agent_resetImg"><img src="/final/admin/eg_images/spacer.gif" width="21" height="19" border="0"/></a></div>
<%
	}
	else
	{
%>
								<select id="logname" name="logname" onchange="javascript:changeDirectory('<%=managerID%>', '<%=mgrLogFile%>',this.value)" style="width:250px;" onfocus="window.dropdown_menu_hack(this);">
<%
		for(int k=0;k<logsDir.length;k++)
		{
			String name = logsDir[k];
			String selected = "";
			if(name.equals(logsDirectory))
				selected="selected";
%>
									<option value="<%=name%>"<%=selected%> title="<%=name%>" ><b><%=name%></b>
									</option>
<%
		}
%>
								</select>
								<input type="hidden" name="currentDir" id="currentDir" value="<%=logsDirectory%>">
							</div>
							<div id="downloadDiv" style="float:left;border:0px solid green;padding-left:6px">
							<a href="javascript:void(0);" class="agent_resetImg" title="Refresh" onclick="javascript:refreshFile('<%=managerID%>','<%=mgrLogFile%>','<%=logsDirectory%>')" ><img src="/final/admin/eg_images/spacer.gif" width="21" height="19" border="0"/></a>
						</div>

<%
	}
	File f = null;
	String userDateFormat = "";
	long time = 0;
	java.util.Date dt = null;
	if(isPrimary || isStandalone)
	{
		if(logsDirectory.equals("tomcat/logs"))
		{
			f = new File(mgrLogFilePath2+"/"+mgrLogFile);
			if(!f.exists())
			{
				mgrLogFile = (String)mgrLogsList.get(0);
				f = new File(mgrLogFilePath2+"/"+mgrLogFile);
			}
			time = f.lastModified();
			dt = new Date(time);
		}
		else
		{
			f = new File(mgrLogFilePath1+"/"+mgrLogFile);
			if(!f.exists())
			{
				mgrLogFile = (String)mgrLogsList.get(0);
				f = new File(mgrLogFilePath1+"/"+mgrLogFile);
			}
			time = f.lastModified();
			dt = new Date(time);
		}
	}
	else
	{
		if(isSecondaryManagagerRunning)
		{
			try
			{
				ArrayList resultData = PMClusterHelper.getSecondaryManagerLogFiles(managerID ,mgrLogFile,"file","false",logsDirectory);
				String timeString = (String)resultData.get(0);
				if(timeString != null && timeString.length() > 0)
					time = Long.parseLong(timeString.substring(timeString.indexOf("@#")+2));
			}
			catch(Exception eg)
			{
				//eg.printStackTrace();
			}
				dt = new Date(time);
		}
	}
	if(dt != null)
	{
		SimpleDateFormat sdf = new SimpleDateFormat(currentDateFormat+" "+"HH:mm:ss");
		String dateString = sdf.format(dt);
		EgTimeZoneConverter egconverter = new EgTimeZoneConverter(dateString,userName);
		userDateFormat = egconverter.getDateTime();
	}

%>
						</div>
					</td>
				</tr>
				<tr>
					<td width="100%" style="padding-top:3px" class="linebg">
					<div style="float:left;border:0px solid green;padding:4px;width:160px" >&nbsp;&nbsp;
						<egui:intnl text='admin.manager.Last modified time'/></div>
					<div style="float:left;border:0px solid green;padding:2px" ></div>
					<div style="float:left;border:0px solid green;padding:4px" ><b><%=userDateFormat%></b></div>
					<div style="float:right;border:0px solid green;padding:2px;width:400px" >
						<div style="float:left;border:0px solid green;padding:2px;width:110px" >
							<egui:intnl text='admin.manager.Log file name'/></div>
						<div style="float:left;border:0px solid green;padding:2px" ></div>
						<div style="float:left;border:0px solid green;">
							<select id="dirId" name="dirId" onchange="javascript:changeFile('<%=managerID%>', this.value,'<%=logsDirectory%>')" width="250px" style="width:250px;" onfocus="window.dropdown_menu_hack(this);">
<%
		for(int k=0;k<mgrLogsList.size();k++)
		{
			String name = (String)mgrLogsList.get(k);
			String selected = "";
			if(name.equals(mgrLogFile))
				selected="selected";
%>
								<option value="<%=name%>"<%=selected%> title="<%=name%>" onmouseover="this.title='<%=name%>';" onmouseout="this.title='<%=name%>';"><b><%=name%></b></option>

<%
		}
%>
								</select>
								<input type="hidden" name="currentFile" id="currentFile" value="<%=mgrLogFile%>">
						</div>
						<div id="refreshDiv" style="float:left;border:0px solid green;padding-left:6px" >
							<a href="javascript:void(0);" class="agent_downloadImg" title="Download" onclick="javascript:downloadLogFile('<%=managerID%>','<%=mgrLogFile%>','<%=logsDirectory%>')" ><img src="/final/admin/eg_images/spacer.gif" width="21" height="19" border="0"/></a>
						</div>
					</div>
					</td>
				</tr>
				<tr>
					<td align="center" width="100%" height="100%" class="eg_subcontentbg" valign="top">
					<div align="left"  name="dispDiv" class="dispDiv" style="display:block;padding:4px;border:0px solid green;border-style:solid;overflow:auto;width:990px;height:400px">
						<table border='0' cellpadding='4' cellspacing='0' height='80' width='100%' bordercolor='red'>
							<tr>
								<td align="left" nowrap valign="top" style="padding:0px" height="100%">
								<div id="loading_image"  name="loading_image" class="eg_cellbgmedium linesquare" style="display:block;position:absolute;left:35%;top:50%;width:325px;height:80px">
									<table border='0' cellpadding='4' cellspacing='0' height='80' width='100%'>
										<tr>
											<td align='center' valign='middle'>
												<img src='/final/admin/eg_images/loading-bar.gif' width='143' height='30' border='0'/><br><br>
												<egui:intnl text='admin.manager.Please wait'/>.&nbsp;<egui:intnl text='admin.manager.The log file is being loaded'/>.<br>
											</td>
										</tr>
									</table>
								</div>
								</td>
<%
	//get the resultData from Primary manager...(Start)
	if(isPrimary || isStandalone)
	{
		File file = null;
		if(logsDirectory.equals("tomcat/logs"))
			file = new File(mgrLogFilePath2+"/"+mgrLogFile);
		else
			file = new File(mgrLogFilePath1+"/"+mgrLogFile);
		if((file!=null && file.length() > 0) || (!file.exists()))
		{
			if(!file.exists())
			{
				if(logsDirectory.equals("tomcat/logs"))
				{
					mgrLogFile = (String)mgrLogsList.get(0);
					file = new File(mgrLogFilePath1+"/"+mgrLogFile);
				}
				else
				{
					mgrLogFile = (String)mgrLogsList.get(0);
					file = new File(mgrLogFilePath2+"/"+mgrLogFile);
				}
			}
			//if file size more than 5MB reduce the data...(Start)
			String valStr = uiIniFile.getValue("LOG_FILE_LENGTH", "LengthLimit");
			int value = Integer.parseInt(valStr);
			long skipBytes = 0;
			long fileSize = file.length();
			long limitLength = value * 1024 * 1024;

			BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file),"UTF-8"));
			if(fileSize > limitLength)
			{
				skipBytes = fileSize-limitLength;
				br.skip(skipBytes);
			}
			//if file size more than 5MB reduce the data...(End)
%>
								<td align="left" nowrap valign="top" style="padding:0px" height="100%">
								<pre>
<%
			// Now Read the Lines
			String line = "";
			while((line=br.readLine()) != null)
			{
				line = StringUtils.replace(line,"<", "&lt");
				line = StringUtils.replace(line,">", "&gt");
				out.println(line);
			}
%>
								</pre>
								</td>
<%
				br.close();
		}
		else if(file == null || file.length() <= 0)
		{
%>
								<td align="center" width="100%" height="100%" class="eg_subcontentbg">
									<table cellspacing="0" cellpadding="0" border="0" bordercolor="red" width="100%" style="width:325px;height:432px">
										<tr>
											<td align="center" width="100%" nowrap valign="center">
											<img src="/final/admin/eg_images/blue/exclamation-icon.gif"><br>
											<egui:intnl text='admin.manager.There is no data in'/>&nbsp;"<%=mgrLogFile%>"&nbsp;<egui:intnl text='admin.manager.file'/></div>
											</td>
										</tr>
									</table>
								</td>
<%
		}
	//get the resultData from Primary manager...(End)
	}
	else
	{
		//get the resultData from Secondary manager...(Start)
		if(!isSecondaryManagagerRunning)
		{
%>
								<td align="center" width="100%" height="100%" class="eg_subcontentbg">
									<table cellspacing="0" cellpadding="0" border="0" bordercolor="red" width="100%" style="width:325px;height:432px">
										<tr>
											<td align="center" width="100%" nowrap valign="center">
											<img src="/final/admin/eg_images/blue/exclamation-icon.gif"><br>
											<egui:intnl text='admin.manager.The secondary manager'/>&nbsp;"<%=managerID%>"&nbsp;<egui:intnl text='admin.manager.is not running'/></div>
											</td>
										</tr>
									</table>
								</td>
<%
		}
		else
		{
			
			ArrayList resultData = PMClusterHelper.getSecondaryManagerLogFiles(managerID ,mgrLogFile,"file","false",logsDirectory);
			if(resultData != null && resultData.size() > 0)
			{
				for(int i = 1;i<resultData.size();i++)
				{
					out.println("\t"+resultData.get(i));
				}
			}
			else
			{
%>
								<td align="center" width="100%" height="100%" class="eg_subcontentbg" valign="middle">
									<table cellspacing="0" cellpadding="0" border="0" bordercolor="red" width="100%"		style="width:325px;height:432px">
										<tr>
											<td align="center" width="100%" nowrap valign="center">
											<img src="/final/admin/eg_images/blue/exclamation-icon.gif"><br>
											<egui:intnl text='admin.manager.No data found in'/>&nbsp;"<%=mgrLogFile%>"&nbsp; <egui:intnl text='admin.manager.file'/> !!!</div>
											</td>
										</tr>
									</table>
								</td>
<%
			}
		}
%>
								</td>
<%
	}
	//get the resultData from Secondary manager...(End)
%>
							</tr>
						</table>
					</div>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
<input type="hidden" id="userDate" name="userDate" value="<%=userDateFormat%>">
</body>
</html>

<!-- this hideLoadImage() function is used to hide the image -->
<script type="text/javascript">
function hideLoadImage ()
{
	try
	{
		var loading_image = document.getElementById("loading_image");
		if (loading_image != null){
			loading_image.style.display = "none";
		}
	}
	catch(e){}
}
window.onload = hideLoadImage;
</script>
<%	

		if(request.getQueryString()!=null)
		session.setAttribute("adminLastAccessedURL","/final/admin/EgManagerLogsView.jsp?"+request.getQueryString());
		else session.setAttribute("adminLastAccessedURL","/final/admin/EgManagerLogsView.jsp");
%>

