<%
/**
 *	Shows the server types as a bar chart with each bar divided on the basis of the number of server types
 *	for each alarm state.
 *
 *	@author		Arun Jayaprakash
 *	@version	3.0
 *	
 *	@modified
 *		10/09/2003	Arun	Removed <br> tags to properly align the "No servers are allocated to your login"  
 *							message.
 *		18/09/2003	Arun	Messages are displayed according to eg_ui.ini
 *		22/09/2003	Arun	Fixed display bug that appeared in Mozilla that occurred because the sampleColors 
 *							parameter was repeated
 *		28/10/2003	Arun	Uses IniUI for headings
 *		04/10/2003	Arun	Added <meta> tag for refreshing. Uses eg_ui.ini for refresh time
 *		15/12/2003	Arun	Reverted to version before 11/10/2003. Retrieves the Map object 
 *							using Dashboard.java if null
 */
%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ include file="EgTrackerA.jsp" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.eg.EgDateInfo" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.egurkha.*"	%>
<%@ page import="com.egurkha.ini.*"	%>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import="com.egurkha.monitor.Dashboard"	%>
<%@ page import="egurkha.EgCrawler"	%>
<%@ page import="java.io.File" %>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import="com.eg.MappingNameSorter" %>
<%@ page import="com.eg.EgName" %>
<%@ page import="com.eg.EgInfrastructure" %>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%!
	int compTypeLength = 25;
%>

<%
	IniUI ui = (IniUI)IniUI.getInstance();
	String strSortPerCount = ui.getValue("SERVER_DISP_DETAILS", "SORTPERCOUNT");
	boolean sortPerCount = true;
	if (strSortPerCount == null || !strSortPerCount.equalsIgnoreCase("true"))
	{
		sortPerCount = false;
	}
%>

<egui:skin ui="admin"/>
<html>
<head>
<base target="main">
</head>
<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" style="overflow:auto" id="margin6" >
<center>
<%
	User user = registry.getUser(session.getId());
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	List listManagedComponents = null;
	boolean aggregateSupported = EgInstallInfo.isAggregationSupported();
	String showOnly = request.getParameter("showOnly");
	if(aggregateSupported && showOnly != null && showOnly.equals("aggregate"))
	{
		listManagedComponents = ri.getAllAggregateServers();
	}
	else
	{
		showOnly="individual";
		listManagedComponents = ri.getAllNonAggregateServers();
	}

	String aggregate_class = null;
	String page_tablink_aggregate = null;
	String page_tab_left_curve_aggregate = null;
	String page_tab_right_curve_aggregate = null;

	String individual_class = null;
	String page_tablink_individual = null;
	String page_tab_left_curve_individual = null;
	String page_tab_right_curve_individual = null;

	if(aggregateSupported)
	{
		if(showOnly=="individual")
		{
			//set individual tab dark
			individual_class = "page_tab_bg_dark";
			page_tablink_individual = "page_tablink_dark";
			page_tab_left_curve_individual = "page_tab_left_curve_dark";
			page_tab_right_curve_individual = "page_tab_right_curve_dark";
			
			//set aggregate tab light
			aggregate_class = "page_tab_bg_light";
			page_tablink_aggregate = "page_tablink";
			page_tab_left_curve_aggregate = "page_tab_left_curve_light";
			page_tab_right_curve_aggregate = "page_tab_right_curve_light";
		}
		else
		{
			//set aggregate tab dark
			aggregate_class = "page_tab_bg_dark";
			page_tablink_aggregate = "page_tablink_dark";
			page_tab_left_curve_aggregate = "page_tab_left_curve_dark";
			page_tab_right_curve_aggregate = "page_tab_right_curve_dark";

			//set individual tab light
			individual_class = "page_tab_bg_light";
			page_tablink_individual = "page_tablink";
			page_tab_left_curve_individual = "page_tab_left_curve_light";
			page_tab_right_curve_individual = "page_tab_right_curve_light";
		}
	}
	ArrayList aListManagedComponents = new ArrayList(listManagedComponents);

	if (aListManagedComponents.size() == 0)
	{
		if(aggregateSupported)
		{
			String lablel = "admin.servertypes.No managed components";
			if(showOnly.equalsIgnoreCase("aggregate"))
			{
				lablel = "admin.servertypes.No managed aggregate components";
			}
%>
	<table  style="margin-top:5px;" width="100%" height="96%" border="0" cellspacing="0" cellpadding="0">
		<tr>
			<td valign="top" height="20">
				<table border="0" cellpadding="0" cellspacing="0" >
					<tr>
						<td class="<%=page_tab_left_curve_aggregate%>" width="4" height="20" ><img src="/final/admin/eg_images/spacer.gif" width="4" height="20" border="0"></td>
						<td class="<%=aggregate_class%>"><a href="javascript:void(0);" class="<%=page_tablink_aggregate%>" onclick="javascript:toggleTypes('individual');"><egui:intnl text="admin.test.Individual"/></a></td>
						<td class="<%=page_tab_right_curve_aggregate%>" width="4" height="20"><img src="/final/admin/eg_images/spacer.gif" width="4" height="20" border="0"></td>
						<!-- <td>&nbsp;</td> -->
						<td class="<%=page_tab_left_curve_individual%>" width="4" height="20"><img src="/final/monitor/eg_images/spacer.gif" width="4" height="20" border="0"></td>
						<td class="<%=individual_class%>"><a href="javascript:void(0);" class="<%=page_tablink_individual%>" onclick="javascript:toggleTypes('aggregate');"><egui:intnl text="admin.test.Aggregate"/></a></td>
						<td class="<%=page_tab_right_curve_individual%>" width="4" height="20" ><img src="/final/monitor/eg_images/spacer.gif" width="4" height="20" border="0"></td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td align="center" valign="middle" class="linesquare">
				<img src="eg_images/<%=admin_Skin%>/exclamation-icon.gif"><br><egui:intnl text="<%=lablel%>"/>.
			</td>
		</tr>
	</table>
<%
		}
		else
		{
%>
	<table width="98%" height="98%">
		<tr>
			<td align="center" valign="middle">
				<img src="eg_images/<%=admin_Skin%>/exclamation-icon.gif"><br><egui:intnl text="admin.servertypes.No managed components"/>.
			</td>
		</tr>
	</table>
<%
		}
	}
	else if (sortPerCount)
	{
		EgInfrastructure egInfrastructure = new EgInfrastructure(aListManagedComponents);
		TreeMap tmapComponentsCount = egInfrastructure.getComponentsCount();
		if(aggregateSupported)
		{
%>
		<table style="margin-top:5px" border="0" width="100%" cellspacing="0" cellpadding="0">
			<col width="30%"><col width="70%">
			<tr>
				<td align="left">
					<table border="0" cellpadding="0" cellspacing="0" >
						<tr>
							<td class="<%=page_tab_left_curve_aggregate%>" width="4" height="20" ><img src="/final/admin/eg_images/spacer.gif" width="4" height="20" border="0"></td>
							<td class="<%=aggregate_class%>"><a href="javascript:void(0);" class="<%=page_tablink_aggregate%>" onclick="javascript:toggleTypes('individual');"><egui:intnl text="admin.test.Individual"/></a></td>
							<td class="<%=page_tab_right_curve_aggregate%>" width="4" height="20"><img src="/final/admin/eg_images/spacer.gif" width="4" height="20" border="0"></td>
							<!-- <td>&nbsp;</td> -->
							<td class="<%=page_tab_left_curve_individual%>" width="4" height="20"><img src="/final/monitor/eg_images/spacer.gif" width="4" height="20" border="0"></td>
							<td class="<%=individual_class%>"><a href="javascript:void(0);" class="<%=page_tablink_individual%>" onclick="javascript:toggleTypes('aggregate');"><egui:intnl text="admin.test.Aggregate"/></a></td>
							<td class="<%=page_tab_right_curve_individual%>" width="4" height="20" ><img src="/final/monitor/eg_images/spacer.gif" width="4" height="20" border="0"></td>
						</tr>
					</table>
				</td>
				<td align="center"><b><egui:intnl text="admin.servertypes.Total Components"/></b> : <%=aListManagedComponents.size()%></b></td>
			</tr>
		</table>
<%
		}
		else
		{
%>
	<table border="0" width="100%" cellspacing="0" cellpadding="0">
		<tr>
			<td align="center" id="eg_11" nowrap align="left"> &nbsp; <b><egui:intnl text="admin.servertypes.Total Components"/> : <%=aListManagedComponents.size()%></b></td>
		</tr>
	<table>
<%
		}
%>
	<table width="100%" cellpadding="0" cellspacing="0" border="0" align="center">
<%
		Iterator itrComponentsCount = tmapComponentsCount.keySet().iterator();
		boolean getMaxCount = true;
		int maxCount = 0;
		while (itrComponentsCount.hasNext())
		{
			Integer intCountObj = (Integer)itrComponentsCount.next();
			int size=intCountObj.intValue();
			if (getMaxCount)
			{
				maxCount = size;
				getMaxCount = false;
			}
			ArrayList aListComponentTypes = (ArrayList)tmapComponentsCount.get(intCountObj);
			aListComponentTypes = sorter.getSortedCompTypeList(aListComponentTypes);

			for (int i=0;i<aListComponentTypes.size();i++)
			{
				EgName nameObj = (EgName)aListComponentTypes.get(i);
				String server = nameObj.getActualName();
				String displayServer = nameObj.getLocalName();

				boolean isEnglish = true;
				for (int x=0;x<displayServer.length();x++)
				{
					Character.UnicodeBlock cu = Character.UnicodeBlock.of(displayServer.charAt(x));
					if (!cu.equals(Character.UnicodeBlock.BASIC_LATIN))
					{
						isEnglish = false;
						break;
					}
				}
%>
		<tr>
			<td align="left" height="20" width="190" id="cell_border1" nowrap>&nbsp;
<%
				if (isEnglish)
				{
					if(server.startsWith("Agg_"))
					{
%>
						<a href="/final/admin/EgAggregateTree.jsp?qctr=1&server=<%=EgURLEncoder.encode(server,"UTF-8")%>&reqfrom=home" STYLE="text-decoration:none" class="dash_link" title="<%=displayServer%>"><egui:display name="<%=displayServer%>" length="<%=Integer.toString(compTypeLength)%>"/></a>
<%
					}
					else
					{
%>
						<a href="/final/admin/EgDispServer.jsp?qctr=1&server=<%=EgURLEncoder.encode(server,"UTF-8")%>&reqfrom=home" STYLE="text-decoration:none" class="dash_link" title="<%=displayServer%>"><egui:display name="<%=displayServer%>" length="<%=Integer.toString(compTypeLength)%>"/></a>
<%
					}
				}
				else
				{
					if(server.startsWith("Agg_"))
					{
%>
						<a href="/final/admin/EgAggregateTree.jsp?qctr=1&server=<%=EgURLEncoder.encode(server,"UTF-8")%>&reqfrom=home" STYLE="text-decoration:none" class="dash_link" title="<%=displayServer%>"><egui:display name="<%=displayServer%>" length="14"/></a>
<%
					}
					else
					{
%>
						<a href="/final/admin/EgDispServer.jsp?qctr=1&server=<%=EgURLEncoder.encode(server,"UTF-8")%>&reqfrom=home" STYLE="text-decoration:none" class="dash_link" title="<%=displayServer%>"><egui:display name="<%=displayServer%>" length="14"/></a>
<%
					}
				}
%>
			</td>
			<td>
<%
			int thisWidth = size*100/maxCount;
%>
				<table width="<%=thisWidth%>%" height="20" width="100%" border="0" cellspacing="0" cellpadding="0" >
<%
			if(server.startsWith("Agg_"))
			{
%>
					<tr>
						<td nowrap align="center" width="<%=thisWidth%>%" id="cell_bg_light"  class="mouse" onclick="loadURL('/final/admin/EgAggregateTree.jsp?qctr=1&server=<%=EgURLEncoder.encode(server,"UTF-8")%>&reqfrom=home')" title="<%=size%> servers"><a href="/final/admin/EgAggregateTree.jsp?qctr=1&server=<%=EgURLEncoder.encode(server,"UTF-8")%>&reqfrom=home" class="dash_text  white"><%=size%></a></td>
					</tr>
<%
			}
			else
			{
%>
					<tr>
						<!-- <a href="/final/admin/EgDispServer.jsp?qctr=1&server=<%//=EgURLEncoder.encode(server,"UTF-8")%>&reqfrom=home" STYLE="text-decoration:none" id="dash_text"><span> -->
						
						<td nowrap align="center" width="<%=thisWidth%>%" id="cell_bg_light"  class="mouse" onclick="loadURL('/final/admin/EgDispServer.jsp?qctr=1&server=<%=EgURLEncoder.encode(server,"UTF-8")%>&reqfrom=home')" title="<%=size%> servers"><a href="/final/admin/EgDispServer.jsp?qctr=1&server=<%=EgURLEncoder.encode(server,"UTF-8")%>&reqfrom=home" class="dash_text  white"><%=size%></a></td>
						
						<!-- </span></a> -->
					</tr>
<%
			}
%>
				</table>
			</td>
		</tr>
		<tr>
			<td background="eg_images/in_titleshadowbg1.gif" height="7" id="eg_blankspace">&nbsp;</td>
			<td height="7">
				<table width="<%=(size*100/maxCount)%>%" border="0" cellspacing="0" cellpadding="0"><tr><td id="eg_blankspace" nowrap height="7" background="eg_images/in_titleshadowbg1.gif">&nbsp;</td></tr></table>
			</td>
		</tr>
<%
			}
		}
%>
	</table>
<%
	}
	else
	{
		if(aggregateSupported)
		{
%>
		<table style="margin-top:5px" border="0" width="100%" cellspacing="0" cellpadding="0">
			<col width="30%"><col width="70%">
			<tr>
				<td align="left">
					<table border="0" cellpadding="0" cellspacing="0" >
						<tr>
							<td class="<%=page_tab_left_curve_aggregate%>" width="4" height="20" ><img src="/final/admin/eg_images/spacer.gif" width="4" height="20" border="0"></td>
							<td class="<%=aggregate_class%>"><a href="javascript:void(0);" class="<%=page_tablink_aggregate%>" onclick="javascript:toggleTypes('individual');"><egui:intnl text="admin.test.Individual"/></a></td>
							<td class="<%=page_tab_right_curve_aggregate%>" width="4" height="20"><img src="/final/admin/eg_images/spacer.gif" width="4" height="20" border="0"></td>
							<!-- <td>&nbsp;</td> -->
							<td class="<%=page_tab_left_curve_individual%>" width="4" height="20"><img src="/final/monitor/eg_images/spacer.gif" width="4" height="20" border="0"></td>
							<td class="<%=individual_class%>"><a href="javascript:void(0);" class="<%=page_tablink_individual%>" onclick="javascript:toggleTypes('aggregate');"><egui:intnl text="admin.test.Aggregate"/></a></td>
							<td class="<%=page_tab_right_curve_individual%>" width="4" height="20" ><img src="/final/monitor/eg_images/spacer.gif" width="4" height="20" border="0"></td>
						</tr>
					</table>
				</td>
				<td align="center"><egui:intnl text="admin.servertypes.Total Components"/> : <%=aListManagedComponents.size()%></b></td>
			</tr>
		</table>
<%
		}
		else
		{
%>
	<table border="0" width="100%" cellspacing="0" cellpadding="0">
		<tr>
			<td align="center" id="eg_11" nowrap align="left"> &nbsp; <b><egui:intnl text="admin.servertypes.Total Components"/> : <%=aListManagedComponents.size()%></b></td>
		</tr>
	<table>
<%
		}
%>
	<table width="100%" cellpadding="0" cellspacing="0" border="0" align="center">
<%
		EgInfrastructure egInfrastructure = new EgInfrastructure(aListManagedComponents);
		TreeMap tmapComponents = egInfrastructure.getComponents();
		Iterator itrComponents = tmapComponents.keySet().iterator();
		ArrayList aListComponentTypes = new ArrayList();
		TreeMap tmapCount = new TreeMap();
		int maxCount = 0;
		while (itrComponents.hasNext())
		{
			String strComponentType = (String)itrComponents.next();
			ArrayList aListComponents = (ArrayList)tmapComponents.get(strComponentType);
			int compSize = aListComponents.size();
			if (compSize > maxCount)
			{
				maxCount = compSize;
			}
			aListComponentTypes.add(strComponentType);
			tmapCount.put(strComponentType,new Integer(compSize));
		}

		aListComponentTypes = sorter.getSortedCompTypeList(aListComponentTypes);
		for(int i=0; i<aListComponentTypes.size(); i++)
		{
			EgName nameObj = (EgName)aListComponentTypes.get(i);
			String server = nameObj.getActualName();
			String displayServer = nameObj.getLocalName();
			Integer intObjCount = (Integer)tmapCount.get(server);
			int size = intObjCount.intValue();

			boolean isEnglish = true;
			for (int x=0;x<displayServer.length();x++)
			{
				Character.UnicodeBlock cu = Character.UnicodeBlock.of(displayServer.charAt(x));
				if (!cu.equals(Character.UnicodeBlock.BASIC_LATIN))
				{
					isEnglish = false;
					break;
				}
			}
%>
		<tr>
			<td align="left" height="20" width="190" id="cell_border1" nowrap>&nbsp;
<%
			if (isEnglish)
			{
				if(server.startsWith("Agg_"))
				{
%>
					<a href="/final/admin/EgAggregateTree.jsp?qctr=1&server=<%=EgURLEncoder.encode(server,"UTF-8")%>&reqfrom=home" STYLE="text-decoration:none" class="dash_link" title="<%=displayServer%>"><egui:display name="<%=displayServer%>" length="<%=Integer.toString(compTypeLength)%>"/></a>
<%
				}
				else
				{
%>
					<a href="/final/admin/EgDispServer.jsp?qctr=1&server=<%=EgURLEncoder.encode(server,"UTF-8")%>&reqfrom=home" STYLE="text-decoration:none" class="dash_link" title="<%=displayServer%>"><egui:display name="<%=displayServer%>" length="<%=Integer.toString(compTypeLength)%>"/></a>
<%
				}
			}
			else
			{
				if(server.startsWith("Agg_"))
				{
%>
					<a href="/final/admin/EgAggregateTree.jsp?qctr=1&server=<%=EgURLEncoder.encode(server,"UTF-8")%>&reqfrom=home" STYLE="text-decoration:none" class="dash_link" title="<%=displayServer%>"><egui:display name="<%=displayServer%>" length="14"/></a>
<%
				}
				else
				{
%>
					<a href="/final/admin/EgDispServer.jsp?qctr=1&server=<%=EgURLEncoder.encode(server,"UTF-8")%>&reqfrom=home" STYLE="text-decoration:none" class="dash_link" title="<%=displayServer%>"><egui:display name="<%=displayServer%>" length="14"/></a>
<%
				}
			}
%>
			</td>
			<td>
<%
			int thisWidth = size*100/maxCount;
%>
				<table width="<%=thisWidth%>%" height="20" width="100%" border="0" cellspacing="0" cellpadding="0" >
<%
				if(server.startsWith("Agg_"))
				{
%>
					<tr>
						<td nowrap align="center" width="<%=thisWidth%>%" id="cell_bg_light" class="mouse" onclick="loadURL('/final/admin/EgAggregateTree.jsp?qctr=1&server=<%=EgURLEncoder.encode(server,"UTF-8")%>&reqfrom=home')" title="<%=size%> servers"><a href="/final/admin/EgAggregateTree.jsp?qctr=1&server=<%=EgURLEncoder.encode(server,"UTF-8")%>&reqfrom=home" STYLE="text-decoration:none" class="dash_link"><%=size%></a></td>
					</tr>
<%
				}
				else
				{
%>
					<tr>
						<!-- <a href="/final/admin/EgDispServer.jsp?qctr=1&server=<%//=EgURLEncoder.encode(server,"UTF-8")%>&reqfrom=home" STYLE="text-decoration:none" id="dash_text"><span> -->
						
						<td nowrap align="center" width="<%=thisWidth%>%" id="cell_bg_light"  class="mouse" onclick="loadURL('/final/admin/EgDispServer.jsp?qctr=1&server=<%=EgURLEncoder.encode(server,"UTF-8")%>&reqfrom=home')" title="<%=size%> servers"><a href="/final/admin/EgDispServer.jsp?qctr=1&server=<%=EgURLEncoder.encode(server,"UTF-8")%>&reqfrom=home" class="dash_text  white"><%=size%></a></td>
						
						<!-- </span></a> -->
					</tr>
<%
				}
%>
				</table>
			</td>
		</tr>
		<tr>
			<td background="eg_images/in_titleshadowbg1.gif" height="7" id="eg_blankspace">&nbsp;</td>
			<td height="7">
				<table width="<%=(size*100/maxCount)%>%" border="0" cellspacing="0" cellpadding="0"><tr><td id="eg_blankspace" nowrap height="7" background="eg_images/in_titleshadowbg1.gif">&nbsp;</td></tr></table>
			</td>
		</tr>
<%
		}
%>
	</table>
<%
	}
%>
</center>
</body>
<script language="javascript">
function loadURL(myURL)
{
	if(window.parent!=null)
	{
		window.parent.location.href=myURL;
	}
}
function toggleTypes(sel)
{
	if(sel != "<%=showOnly%>")
	{
		window.location.href="/final/admin/EgShowServerTypes.jsp?showOnly="+sel;
	}
}
</script>
</html>



