<%
/*****************************************************************************
*  File         : EgTestParam.jsp
*  Purpose      : To get all the default parameters for a particular test from
		  eg_specs.ini 
*  Version      : 0.0
*  Creation Date: 21/08/2000
*  Last Modified: 
*		28/07/2004	Arun	Added support for isCitrix
*		24/07/2004	Arun	Field values now allow $ only at the start. Passwords allow $
*		23/06/2004	Arun	Included code to allow # in passwords, and to replace delimiters with
*							commas as specified in eg_specs.ini
		21/08/2003 // textarea validation for hyphen and search paattern field for alertlog test//gopi
		 24/07/2003 Allowing DD Disable by checking normal and bad frequencies of DD
				  and hyphen check for textfield
		  24/07/2003 // Karthick Krishnan - For Fixing Layout issues 
		  19/07/2003 //gopi - DD disable option for tests
		  07/02/2003 //gopi - Formatted Test Period in sec,min and hrs
		  08/11/2002 //sandhya - Validation for search 
		  15/10/2002 //sandhya - Validation for mCount,SNMP Port(WebLogicTest) and EventSrc/EventHost(EventLogTest)
		  20/08/2002 //sandhya - Validation for sendUser,receiveUser,fromId,toId 
		  8/7/2002 //sandhya - To hide url(HttpTest & WapTest). To hide targets(DnsTest)
		  29/05/2002 //sandhya - To hide HOST and PORT variables
		  27/03/2002 //sandhya - Encrypt/Decrypt 
		  26/03/2002 //sandhya - Enable SSL  
		  28/02/2002 //sandhya - validation for url	 
		  19/02/2002 //sandhya - validation for HOST	 
		  19/06/2001 //Sandhya - To allow multiple serviceNames. 
		  15/06/2001 //Sandhya.K - To retrieve $serviceName with space from eg_specs.ini and to check for ',' in serviceName in WinServiceTest
		  17/05/2001 //Sandhya.K - Check for the comment "New code" in
this page 
		  24/03/2001 //Sandhya.K - To add an alert message in function populate
		  22/03/2001 //Sandhya.K - To add protocol parameter in MailTest 
					 - To change pop3Host to receiveHost 
					 - To change pop3Port to receivePort
		  19/03/2001 //Sandhya.K - Validations for MailTest 
		  03/03/2001 //Sandhya.K 
		  21/02/2001 //Sandhya.K - Validations 
		  21/11/2000 //Sandhya.K
*  Author       : Sridevi.T & Sandhya.K

*  Design Changes	:	Jaiwin
******************************************************************************/
%>
<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "com.eg.EgCrypt" %>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import ="com.eg.EgInstallInfo" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.eg.EgUtils" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import="com.eg.EgURLDecoder" %>
<%@ page import = "java.util.*" %>
<%@ taglib prefix = "egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.egurkha.admin.AuditLogHashtable"%>
<%@ page buffer="32kb"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	AuditLogHashtable auditLogHashtable = new AuditLogHashtable();
%>

<html>
<head>
<title>Configure Default Parameters For Tests</title>
<meta name="created" content="28/6/2k">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<egui:skin ui = "admin"/>

<script language="JavaScript" src="eg_scripts/validate.js"></script>
<script language="JavaScript" src="eg_scripts/testvalidate.js"></script>
<script language="JavaScript" src="eg_scripts/eg_configtest.js"></script>
<script language="javascript" src="eg_scripts/ajaxutils.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>

<script language="JavaScript">
function populate(test,server,multiUserMode)
{
	thisForm = document.testconfig;
	var sub = true;
	var userArr = "";
	var passArr = "";
	var parameters="";
	var tcKeywords="";
	var defaultValueFound = false;
	if(thisForm.allowedParams!=null)
	{
		parameters=thisForm.allowedParams.value;
	}
	parameters=parameters.toUpperCase();

	if(thisForm.tcKeywords!=null)
	{
		tcKeywords=thisForm.tcKeywords.value;
		tcKeywords = tcKeywords.split(",");
	}
	//First field - testperiod needs no validation

	for(j=1; j <thisForm.elements.length; j++)
	{

		if(thisForm[j].name == "virtual_center")
		{
			if(thisForm[j].value=='Other')
			{
				alert(_virtualCenterCheck);
				sub = false;
				break;
			}
		}
		else if(thisForm[j].name == "webPort")
		{
			if (!checkNumerical(thisForm[j].value))
			{
				alert(_checkfordecimal);
				thisForm[j].focus();
				sub = false;
				break;
			}
		}

		if (test == "FcDetailsTest" || test == "FcPowerStatusTest")
		{
			if ((thisForm[j].name).toLowerCase() == "criticalerrorcodes" || 
				(thisForm[j].name).toLowerCase() == "majorerrorcodes" || 
				(thisForm[j].name).toLowerCase() == "minorerrorcodes")
			{
				var tempParamValue = (trim(thisForm[j].value)).toLowerCase();
				var maxValue = "";
				if (test == "FcDetailsTest")
				{
					maxValue = 131;
				}
				else
				{
					maxValue = 12;
				}
				if (!checkSpecial(thisForm[j].value,"	`~!@#$%^&*()+={}[]|:;\"\'<>_?\/\\"))
				{
					thisForm[j].focus();
					sub = false;
					break;
				}
				else if (tempParamValue.indexOf(",") > -1)
				{
					if (tempParamValue.indexOf(",") == 0 || 
						tempParamValue.lastIndexOf(",") == tempParamValue.length-1 || 
						tempParamValue.indexOf(",,") > -1)
					{
						alert(_validValue);
						thisForm[j].focus();
						sub = false;
						break;
					}
					else
					{
						var tempValues = tempParamValue.split(",");
						var foundInValidData = false;
						for (var i=0; i<tempValues.length; i++)
						{
							var strValue = tempValues[i];
							var isNumber = checkNumerical(strValue);
							if (isNumber)
							{
								if (parseInt(strValue) < 1 || parseInt(strValue) > maxValue)
								{
									foundInValidData = true;
									break;
								}
							}
							else
							{
								foundInValidData = true;
								break;
							}
						}

						if (foundInValidData)
						{
							if (maxValue == 131)
							{
								alert(_oneToOneThirtyOne);
							}
							else
							{
								alert(_oneToTwelve);
							}
							thisForm[j].focus();
							sub = false;
							break;
						}
					}
				}
				else
				{
					var isNumber = checkNumerical(tempParamValue);
					if (isNumber)
					{
						if (parseInt(tempParamValue) < 1 || parseInt(tempParamValue) > maxValue)
						{
							if (maxValue == 131)
							{
								alert(_oneToOneThirtyOne);
							}
							else
							{
								alert(_oneToTwelve);
							}
							thisForm[j].focus();
							sub = false;
							break;
						}
					}
					else
					{
						if (defaultValueFound && tempParamValue == "default")
						{
							alert(_assignDefault);
							thisForm[j].focus();
							sub = false;
							break;
						}

						if (tempParamValue == "default")
						{
							defaultValueFound = true;
						}

						if (tempParamValue != "none" && tempParamValue != "default")
						{
							alert(_validValue);
							thisForm[j].focus();
							sub = false;
							break;
						}
					}
				}
			}
		}

		//Validations for text fields
		if(thisForm[j].type == "text")
		{
			if(!checkblank(thisForm[j].value))
			{
				alert('<egui:intnl text="admin.test.Field value cannot be blank"/>.');
				thisForm[j].focus();
				sub = false;
				break;
			}
			else if (!checkHyphenText(thisForm[j].value,thisForm[j].name))
			{
				thisForm[j].focus();
				sub = false;
				break;
			}

			if (thisForm[j].name.toLowerCase() == "snmpcommunity")
			{
				if (thisForm[j].value != "")
				{
					var val = thisForm[j].value;
					if (val.indexOf("\"") > -1 || val.indexOf("<") > -1 || val.indexOf(">") > -1 || val.indexOf("|") > -1)
					{
						alert(_snmpcomma);
						thisForm[j].focus();
						sub = false;
						break;
					}else if(val.indexOf("-") == 0 || val.charAt(val.length -1) == '-')
					{
						alert('<egui:intnl text="admin.snmp.First and last characters should not be a hyphen symbol"/>');
						thisForm[j].focus();
						sub = false;
						break;
					}
					
				}
			}
			//Validations for valid integers
			if (thisForm[j].name == "packetSize" 
				|| thisForm[j].name == "packetCount" 
				|| thisForm[j].name == "timeout" 
				|| thisForm[j].name == "webServerPort" 
				|| thisForm[j].name == "receivePort" 
				|| thisForm[j].name == "adminPort")
			{
				if(thisForm[j].value != "")
				{
					var value = thisForm[j].value;
					//check for snmpPort, webServerPort & receivePort
					if(value.indexOf("$") == -1)
					{
						if((!checknumber("+",value)) || value == 0)
						{
							alert('<egui:intnl text="admin.test.Only valid integers are allowed"/>.');
							thisForm[j].focus();
							sub = false;
							break;
						}
						if(!checkfordecimal(value))
						{
							thisForm[j].focus();
							sub = false;
							break;
						}
					}
				}
			}
			else if(thisForm[j].name.toLowerCase() == "snmpport")
			{
				if(thisForm[j].value != "")
				{
					var tmp = thisForm[j].value;
					tmp = tmp.toLowerCase();
					if (((!checknumber("+",thisForm[j].value)) || thisForm[j].value == 0) 
						&& (tmp != "none"))
					{
					alert("<egui:intnl text='admin.test.Only valid integers or  \'none\'  allowed!'/>");
						thisForm[j].focus();
						sub = false;
						break;
					}
					if(!checkfordecimal(thisForm[j].value))
					{
						thisForm[j].focus();
						sub = false;
						break;
					}
				}
			}
			else if (thisForm[j].name == "Esx_user" || 
					thisForm[j].name == "Xen_user" || 
					thisForm[j].name == "Xen_pool_user" || 
					thisForm[j].name == "console_user" || 
					thisForm[j].name == "username" || 
					thisForm[j].name == "userNames" || 
					thisForm[j].name == "proxyUsername" || 
					thisForm[j].name == "USERNAME")
			{
				if (!checkSpecial(thisForm[j].value,"	@#$%^&*+={}|:;\"\'<>,\/"))
				{
					thisForm[j].focus();
					sub = false;
					break;
				}
			}
			else if(thisForm[j].name == "domain")
			{
				var pattern = "`~!@#$%^&*()+={}[]|:;\"\'<>?\\\/_";
				//Should not allow comma for Single user tests. For example, ADServerTest
				if (multiUserMode == "false")
				{
					pattern = pattern + ",";
				}
				if (!checkspecialnomess(thisForm[j].value,pattern))
				{
					alert(_checkspecial);
					updationInProgress = "false";
					thisForm[j].focus();
					sub = false;
					break;
				}
				else if(trim(thisForm[j].value) == "")
				{
					alert(_checkempty);
					updationInProgress = "false";
					thisForm[j].focus();
					sub = false;
					break;
				}
			}
			else if(thisForm[j].name == "admin_user")
			{
				var pattern = "	@#$%^&*+={}|:;\"\'<>\/";
				//Should not allow comma for Single user tests. For example, ADServerTest
				if (multiUserMode == "false")
				{
					pattern = pattern + ",";
				}
				if (!checkspecialnomess(thisForm[j].value,pattern))
				{
					alert(_checkspecial);
					updationInProgress = "false";
					thisForm[j].focus();
					sub = false;
					break;
				}
				else if(trim(thisForm[j].value) == "")
				{
					alert(_checkempty);
					updationInProgress = "false";
					thisForm[j].focus();
					sub = false;
					break;
				}
			}
			else if (thisForm[j].name == "logType" && !checkAlphabets(thisForm[j].value))
			{
				alert(_alphabetsOnly);
				thisForm[j].focus();
				sub = false;
				break;
			}
			else if (thisForm[j].name == "ddFreq" && !DDFreqCheck(thisForm[j].value))
			{
				alert(_validDDPattern);
				thisForm[j].focus();
				sub = false;
				break;
			}
			else
			{
				var s_val = thisForm[j].value;
				if(s_val.indexOf("$") > -1)
				{
					var parameter=parameters.split(",");
					var parameterFound=false;
					var tcKeyWordCaught=false;
					for (parameterCount=0;parameterCount<parameter.length;parameterCount++ )
					{
						temp_parameter=(parameter[parameterCount].toUpperCase());
						if ((temp_parameter.replace(/^\s*/, '').replace(/\s*$/, ''))==(thisForm[j].name).toUpperCase())
						{
							for (var z=0;z<tcKeywords.length;z++)
							{
								if (tcKeywords[z].toLowerCase() == s_val.toLowerCase())
								{
									tcKeyWordCaught = true;
									break;
								}
							}
							parameterFound=true;
							break;
						}
					}
					if(!parameterFound)
					{
						alert(_checkspecial);
						thisForm[j].focus();
						sub = false;
						break;
					}

					if (tcKeyWordCaught)
					{
						alert(_tcKeyword);
						thisForm[j].focus();
						sub = false;
						break;
					}
				}
				if ((s_val.indexOf("$") > -1) 
					|| (s_val.indexOf("%") > -1) 
					|| (s_val.indexOf(":") > -1))
				{
					if(thisForm[j].name == "process")
					{
						var s_valTemp = s_val.replace(/~/g,'');
						if(!processvalidation(s_valTemp, thisForm[j].type))
						{
							thisForm[j].focus();
							sub = false;
							break;
						}
					}
					else if(thisForm[j].name == "content")
					{
						if(!contentvalidation(s_val, thisForm[j].type, "content"))
						{
							thisForm[j].focus();
							sub = false;
							break;
						}
					}
					else if(thisForm[j].name == "credentials")
					{
						if(!contentvalidation(s_val, thisForm[j].type, "credentials"))
						{
							thisForm[j].focus();
							sub = false;
							break;
						}
					}
					else if(thisForm[j].name == "url")
					{
						if(!checkSpecial(s_val,"`~!@#%^&*()+{}[]|;\"\'<>,?"))
						{
							thisForm[j].focus();
							sub = false;
							break;
						}
					}
					else if(thisForm[j].name == "sendUser" || thisForm[j].name == "receiveUser")
					{
						if(!checkSpecial(s_val,"`~!#%^&*()+={}[]|\\:;\"\'<>,?\/"))
						{
							thisForm[j].focus();
							sub = false;
							break;
						}
					}
					//Check for remotefile,localfile,errorpattern, snmpCommunity
					else if(thisForm[j].name !="searchpattern" 
						&& thisForm[j].name !="script"
						&& thisForm[j].name !="userparams"
						&& thisForm[j].name !="recordpattern"
						&& thisForm[j].name !="Xen_PS_Console_File_Path"
						&& thisForm[j].name !="Java_Home"
						&& !checkSpecial(s_val,"`!#^&()+={}[]|\"\'<>?"))
					{
						thisForm[j].focus();
						sub = false;
						break;
					}
					else if(thisForm[j].name == "Xen_PS_Console_File_Path"
						&& !checkSpecial(s_val,"`!#^&+={}[]|\"\'<>?"))
					{
						thisForm[j].focus();
						sub = false;
						break;
					}
					else if(thisForm[j].name =="recordpattern" 
						&& !checkSpecial(s_val,"`!#^&()+[]|\'?"))
					{
						thisForm[j].focus();
						sub = false;
						break;
					}
					else if(thisForm[j].name =="script" 
						&& !checkSpecial(s_val,"`!#^&()+{}[]|\"\'<>?"))
					{
						thisForm[j].focus();
						sub = false;
						break;
					}
					else if(thisForm[j].name == "Java_Home"
						&& !checkSpecial(s_val,"`!#^&+={}[]|\"\'<>?"))
					{
						updationInProgress = "false";
						thisForm[j].focus();
						sub = false;
						break;
					}
					else if(!checkcomma(s_val))
					{
						alert(_checkcomma);
						thisForm[j].focus();
						sub = false;
						break;
					}
				}
				else if(thisForm[j].name == "fromId" || thisForm[j].name == "toId")
				{
					/*
					if(!checkmailid(s_val,"@."))
					{
						thisForm[j].focus();
						sub = false;
						break;
					}
					else
					*/
					if(!checkSpecial(s_val,"`~!#%^&*()+={}[]|\\:;\"\'<>,?\/")
						|| s_val.indexOf("$") > 0)
					{
						thisForm[j].focus();
						sub = false;
						break;
					}
				}
				else if(thisForm[j].name == "duration")
				{
					if(!checknumber("+",thisForm[j].value))
					{
						alert('<egui:intnl text="admin.test.Only valid integers are allowed"/>.');
						thisForm[j].focus();
						sub = false;
						break;
					}
					if(!checkfordecimal(thisForm[j].value))
					{
						thisForm[j].focus();
						sub = false;
						break;
					}
				}
				else if(thisForm[j].name == "proxyPort")
				{
					if ((!checknumber("+",thisForm[j].value) || thisForm[j].value == 0) 
						&& (thisForm[j].value != "none"))
					{
						alert("<egui:intnl text='admin.test.Proxyport can consist of only valid integers or \'none\''/>.");
						thisForm[j].focus();
						sub = false;
						break;
					}
					if(!checkfordecimal(thisForm[j].value))
					{
						thisForm[j].focus();
						sub = false;
						break;
					}
				}
				else if(thisForm[j].name == "port")
				{
					if ((!checknumber("+",thisForm[j].value) || thisForm[j].value == 0) 
						&& (thisForm[j].value != "NULL"))
					{
						alert("<egui:intnl text='admin.test.Port number can consist of only valid integers or \'NULL\''/>.");
						thisForm[j].focus();
						sub = false;
						break;
					}

					if(!checkfordecimal(thisForm[j].value))
					{
						thisForm[j].focus();
						sub = false;
						break;
					}
				}
				else if (thisForm[j].name == "proxyHost" 
						|| thisForm[j].name == "target" 
						|| thisForm[j].name == "url" 
						|| thisForm[j].name == "host" 
						|| thisForm[j].name == "receiveHost" 
						|| thisForm[j].name == "eventhost")
				{
					if(thisForm[j].name == "host"
					|| thisForm[j].name == "proxyHost" 
					|| thisForm[j].name == "receiveHost" 
					|| thisForm[j].name == "eventhost")
					{
						if(!checkspecialnomess(s_val,"`~!@#%^&*()+={}[]|\\;\"\'<>,?/")
							|| s_val.indexOf("$") > 0)
						{
							alert("<egui:intnl text='admin.test.Special characters are not allowed!'/>");
							thisForm[j].focus();
							sub = false;
							break;
						}
					}
					else
					{
						if(!checkspecialnomess(s_val,"`~!@#%^&*()-+={}[]|\\;\"\'<>,?")
							|| s_val.indexOf("$") > 0)
						{
							alert("<egui:intnl text='admin.test.Special characters are not allowed'/>.");
							thisForm[j].focus();
							sub = false;
							break;
						}
					}
				}
				//check for logFile
				else if(thisForm[j].name == "logFile")
				{
					if(!checkspecialnomess(s_val,"`~!#%^&*()+{}[]|;\"\'<>?")
						|| s_val.indexOf("$") > 0)
					{
						alert("<egui:intnl text='admin.test.Special characters are not allowed'/>.");
						thisForm[j].focus();
						sub = false;
						break;
					}
				}
				else if(thisForm[j].name == "process")
				{
					if(s_val!="(EG_RUNTIME)" && s_val.indexOf(":") == -1)
					{
						alert("<egui:intnl text='admin.test.Please enter in this format processName:processPattern'/>.");
						thisForm[j].focus();
						sub = false;
						break;
					}
				}
				else if(thisForm[j].name == "content")
				{
					if(s_val.indexOf(":") == -1)
					{
						alert("<egui:intnl text='admin.test.Please enter in this format name:value'/>.");
						thisForm[j].focus();
						sub = false;
						break;
					}
				}
				else if(thisForm[j].name == "credentials")
				{
					if(s_val.indexOf(":") == -1)
					{
						alert("<egui:intnl text='admin.test.Please enter in this format user:password'/>.");
						thisForm[j].focus();
						sub = false;
						break;
					}
				}
				else if(thisForm[j].name == "search")
				{
					if(!checkSpecial(s_val,"`~!@#%^&*()+-{}[]|:;\"\'<>?")
						|| s_val.indexOf("$") > 0)
					{
						thisForm[j].focus();
						sub = false;
						break;
					}
					if(!checkcomma(s_val))
					{
						alert("<egui:intnl text='admin.test.Please enter a value'/>");
						thisForm[j].focus();
						sub = false;
						break;
					}
				}
				else if(thisForm[j].name == "serviceName")
				{
					if(!checkSpecial(s_val,"`~!@#%^&*-={}[]|:;\"\'<>.?")
						|| s_val.indexOf("$") > 0)
					{
						thisForm[j].focus();
						sub = false;
						break;
					}
					if(!checkcomma(s_val))
					{
						alert("<egui:intnl text='admin.test.Please enter a servicename'/>");
						thisForm[j].focus();
						sub = false;
						break;
					}
				}
				else if(thisForm[j].name == "sendUser" || thisForm[j].name == "receiveUser")
				{
					if(!checkSpecial(s_val,"	@#$%^&*+={}|:;\"\'<>,\/")
						|| s_val.indexOf("$") > 0)
					{
						thisForm[j].focus();
						sub = false;
						break;
					}
				}
				else if(thisForm[j].name == "eventsrc")
				{
					if(!checkSpecial(s_val,"`~!#%^&*()+={}[]|\\:;\"\'<>?\/")
						|| s_val.indexOf("$") > 0)
					{
						thisForm[j].focus();
						sub = false;
						break;
					}
					else if(!checkcomma(s_val))
					{
						alert("<egui:intnl text='admin.test.Please enter a value'/>");
						thisForm[j].focus();
						sub = false;
						break;
					}
				}
				
				//Check for cookiefile, postarguments, snmpcommunity, user, info
				//CODE FOR CTX AUTH TEST STARTS 
				//else if(!checkspecialnomess(thisForm[j].value,"`~!@#%^&*()+={}[]|\\:;\"\'<>,?\/")
				//	|| thisForm[j].value.indexOf("$") > 0)
				//{
					if((test == "CtxAuthTest") || (test == "WinAuthTest") || (test == "TermAuthTest"))
					{
						var pattern = "";
						if (thisForm[j].name == "user")
						{
							pattern = "	@#$%^&*+={}|:;\"\'<>\/";
						}
						else
						{
							pattern = "`~!@#%^&*()+={}[]|\\:;\"\'<>?\/";
						}

						if(!checkSpecial(thisForm[j].value,pattern)
							|| thisForm[j].value.indexOf("$") > 0)
						{
							thisForm[j].focus();
							sub = false;
							break;
						}
						else if(((thisForm[j].value.substring(thisForm[j].value.length-1, 
							thisForm[j].value.length)) == ",") ||
							(thisForm[j].value.charAt(0) == ","))
						{
							alert("<egui:intnl text='admin.test.First and Last character shall not be a comma'/>.");
							thisForm[j].focus();
							sub = false;
							break;
						}
						else
						{
							userArr = thisForm[j].value.split(',');
						}
					}
					/*
					else if(test == 'AlertLogTest')
					{
						if(!checkSpecial(s_val,"`#^&=[]|\"\'<>"))
						{
							thisForm[j].focus();
							sub = false;
							break;
						}
					}*/
				//}
				//CODE FOR CTX AUTH TEST ENDS
			}
			if(test == 'AlertLogTest' && thisForm[j].name == "searchpattern")
			{
				//alert("s_val-->"+s_val+" name -->"+thisForm[j].name);
				if(!checkSpecial(s_val,"`#^&=[]|\"\'<>"))
				{
					thisForm[j].focus();
					sub = false;
					break;
				}
			}

			if(thisForm[j].name == "command")
			{
				var s_command = thisForm[j].value.toUpperCase();
				if(s_command != "")
				{
					if(!(s_command == "GET" || s_command == "POST"))
					{
						alert("<egui:intnl text='admin.test.Only GET or POST allowed'/>.");
						thisForm[j].focus();
						sub = false;
						break;
					}
				}
			}
			if(thisForm[j].name == "protocol")
			{
				var s_protocol = thisForm[j].value;
				if(s_protocol.indexOf("$") == -1)
				{
					s_protocol = thisForm[j].value.toLowerCase();
					if(s_protocol != "")
					{
						if(!(s_protocol == "imap" || s_protocol == "pop3"))
						{
							alert("<egui:intnl text='admin.test.Only imap or pop3 allowed'/>.");
							thisForm[j].focus();
							sub = false;
							break;
						}
					}
				}
			}
		}
		
		//Password Validations
		if(thisForm[j].type == "password")
		{
			if (thisForm[j].value == "")
			{
				alert("<egui:intnl text='admin.test.Field value cannot be blank'/>.");
				thisForm[j].focus();
				sub = false;
				break;
			}
			var pattern = "";
			if((test == "CtxAuthTest") || (test == "WinAuthTest") || (test == "TermAuthTest"))
			{
				pattern = "\",|";
			}
			else
			{
				pattern = "\"|";
			}
			if(!checkspecialnomess(thisForm[j].value,pattern))
			{
				alert(_validatePass);
				thisForm[j].focus();
				sub = false;
				break;
			}
			if(!checkForPassValidity(thisForm[j].value))
			{
				thisForm[j].focus();
				sub = false;
				break;
			}

			//CODE FOR CTXAUTH TEST... STARTS
			//if(!checkspecialnomess(thisForm[j].value,"`~!@#%^&*()+={}[]|\\:;\"\'<>,?\/")
			//	|| thisForm[j].value.indexOf("$") > 0)
			//{
				if((test == "CtxAuthTest") || (test == "WinAuthTest") || (test == "TermAuthTest"))
				{
					/*if(!checkSpecial(thisForm[j].value,"`~!@#%^&*()+={}[]|\\:;\"\'<>?\/")
						|| thisForm[j].value("$") > 0)
					{
						thisForm[j].focus();
						sub = false;
						break;
					}
					else 
					*/
					if(((thisForm[j].value.substring(thisForm[j].value.length-1, 
						thisForm[j].value.length)) == ",") ||
						(thisForm[j].value.charAt(0) == ","))
					{
						alert(_valComma);
						thisForm[j].focus();
						sub = false;
						break;
					}
					else
					{
						passArr = thisForm[j].value.split('#~#');
					}
				}
			//}
			//CODE FOR CTXAUTH TEST... ENDS
			
			//Check for password and confirm password
			if(thisForm[j].name == "cpwd" || thisForm[j].name == "aucon" || thisForm[j].name=="encon")
			{
				cpwd = thisForm[j].value;
				pwd = thisForm[j-1].value;
			
				if(cpwd != pwd)
				{
					alert("<egui:intnl text='admin.test.Passwords do not match'/>");
					thisForm[j].value = "";
					thisForm[j].focus();
					sub = false;
					break;
				}
			}
		}

		//Text area validations
		if(thisForm[j].type == "textarea")
		{
			if((thisForm[j].name).toLowerCase() == "filter")
			{
				var filtersArr = new Array();
				var tempGlobalsplit=thisForm[j].value.split(";");
				var tempFilters = "";
				for(var k=0;k<tempGlobalsplit.length;k++)
				{
					if(tempGlobalsplit[k] != "")
					{
						var mysplit=tempGlobalsplit[k].split(":");
						if(mysplit.length == 7)
						{
							for(var m=0;m<mysplit.length;m++)
							{
								if(mysplit[m] != "")
								{
									if (m>0) continue;
									tempFilters = tempFilters + mysplit[m] + ",";
								}
							}
						}
					}
				}

				if (tempFilters != "")
				{
					tempFilters = tempFilters.substring(0,tempFilters.length-1);
					filtersArr = tempFilters.split(",");
				}

				var globalsplit=thisForm[j].value.split(";");
				for(var k=0;k<globalsplit.length;k++)
				{
					if(globalsplit[k] != "")
					{
						var mysplit=globalsplit[k].split(":");
						if(mysplit.length == 7)
						{
							for(var m=0;m<mysplit.length;m++)
							{
								if(mysplit[m] != "")
								{
									if(m==0)
									{
										var myhypen="-";
										var mycomma=",";
										var reg_expression = /[`~!@#$%^&()|{ }/+=.?\\\"\'><,\:\;]/;
										var policyNameresult=reg_expression.test(mysplit[m]);
										var mylen=mysplit[m].length;
										if(policyNameresult)
										{
											alert(_policySplChar);
											thisForm[j].focus();
											sub = false;
											return;
										}

										if(mysplit[m].charAt(0)==myhypen||mysplit[m].charAt(mylen-1)==myhypen)
										{
											alert(_policyHypen);
											thisForm[j].focus();
											sub = false;
											return;
										}
										if ((trim(mysplit[m])).toLowerCase() == "all")
										{
											if ((trim(mysplit[m])) != "all")
											{
												alert(_allInFilter);
												thisForm[j].focus();
												sub = false;
												return;
											}
										}
										var n = 0;
										for(var i=0;i<filtersArr.length;i++)
										{
											var strFilter = filtersArr[i];
											if (mysplit[m] == strFilter)
											{
												n = n+1;
											}

											if (n > 1)
											{
												alert(_policyFilter + " '" + mysplit[m] + "' " + _duplicated);
												thisForm[j].focus();
												sub = false;
												return;
											}
										}
									}
									else if(m==1 || m==2)
									{
										mycomma=",";
										if(mysplit[m].indexOf(",") == 0||mysplit[m].lastIndexOf(",") ==(mysplit[m].length-1))
										{
											alert(_eventSrcComma);
											thisForm[j].focus();
											sub = false;
											return;
										}
										if(mysplit[m].indexOf(",,")>0)
										{
											alert(_eventSrcConsComma);
											thisForm[j].focus();
											sub = false;
											return;
										}
									}
									else if(m==3 || m==4)
									{
										var eventid_regexp=/^[0-9,]+$/;
										var allowme1="all";
										var allowme2="none";
										mycomma=",";
										var eventidConsec=(mysplit[m].charAt(mysplit[m].search(mycomma))==mysplit[m].charAt(mysplit[m].search(mycomma)+1));
										var eventidresult=eventid_regexp.test(mysplit[m]);
										if(!(eventidresult)&&(mysplit[m]!=allowme1)&&(mysplit[m]!=allowme2))
										{
											alert(_eventIDNumOnly);
											thisForm[j].focus();
											sub = false;
											return;
										}
										if(mysplit[m].indexOf(",")==0||mysplit[m].lastIndexOf(",")==(mysplit[m].length-1))
										{
											alert(_eventIDComma);
											thisForm[j].focus();
											sub = false;
											return;
										}
										if(mysplit[m].indexOf(",,")>0)
										{
											alert(_eventIDConsComma);
											thisForm[j].focus();
											sub = false;
											return;
										}
									}
									else if(m==5 || m==6)
									{
										mycomma=",";
										if(mysplit[m].indexOf(",")==0||mysplit[m].lastIndexOf(",")==(mysplit[m].length-1))
										{
											if (test == 'AppEvtLogTest' || test == 'SystemEvtLogTest')
											{
												alert(_eventDescComma);
											}
											else
											{
												alert(_eventUserComma);
											}
											thisForm[j].focus();
											sub = false;
											return;
										}
										if(mysplit[m].indexOf(",,")>0)
										{
											if (test == 'AppEvtLogTest' || test == 'SystemEvtLogTest')
											{
												alert(_eventDescConsComma);
											}
											else
											{
												alert(_eventUserConsComma);
											}
											thisForm[j].focus();
											sub = false;
											return;
										}
									}
								}
								else
								{
									alert(_validPattern);
									thisForm[j].focus();
									sub = false;
									return;
								}
							}
						}
						else
						{
							alert(_validPattern);
							thisForm[j].focus();
							sub = false;
							return;
						}
					}
					else
					{
						alert(_validPattern);
						thisForm[j].focus();
						sub = false;
						return;
					}
				}
			}

			var textval = thisForm[j].value;
			if(!checkblank(textval))
			{
				alert("<egui:intnl text='admin.test.Field value cannot be blank'/>.");
				thisForm[j].focus();
				sub = false;
				break;
			}
			else
			{
				if(!checkhyphen(textval,thisForm[j].name))
				{
					thisForm[j].focus();
					sub = false;
					break;
				}
			}
			//new code test st for alert log
			//alert("testname : "+testname+ " field name : "+thisForm[j].name);
			if(test == 'AlertLogTest' && thisForm[j].name == "searchpattern")
			{
				if(!checkSpecial(textval,"`#^&=[]|\"\'<>"))
				{
					thisForm[j].focus();
					sub = false;
					break;
				}
			}
			//new code test end for alert log
			if(thisForm[j].name == "process")
			{
				var s_valTemp = textval.replace(/~/g,'');
				if(!processvalidation(s_valTemp,thisForm[j].type))
				{
					thisForm[j].focus();
					sub = false;
					break;
				}
			}
			if(thisForm[j].name == "content")
			{
				if(!contentvalidation(textval,thisForm[j].type,"content"))
				{
					thisForm[j].focus();
					sub = false;
					break;
				}
			}
			if(thisForm[j].name == "credentials")
			{
				if(!contentvalidation(textval,thisForm[j].type,"credentials"))
				{
					thisForm[j].focus();
					sub = false;
					break;
				}
			}
			if((test == "CtxAuthTest") || (test == "WinAuthTest") || (test == "TermAuthTest"))
			{
				var pattern = "";
				if (thisForm[j].name == "user")
				{
					pattern = "	@#$%^&*+={}|:;\"\'<>\/";
				}
				else
				{
					pattern = "`~!@#%^&*()+={}[]|\\:;\"\'<>?\/";
				}

				if(!checkSpecial(thisForm[j].value,pattern)
					|| thisForm[j].value.indexOf("$") > 0)
				{
					thisForm[j].focus();
					sub = false;
					break;
				}
				else if(((thisForm[j].value.substring(thisForm[j].value.length-1, 
					thisForm[j].value.length)) == ",") ||
					(thisForm[j].value.charAt(0) == ","))
				{
					alert("<egui:intnl text='admin.test.First and Last character shall not be a comma'/>.");
					thisForm[j].focus();
					sub = false;
					break;
				}
				else
				{
					userArr = thisForm[j].value.split(',');
				}
			}
			if (thisForm[j].name == "logType" && !checkAlphabets(thisForm[j].value))
			{
				alert(_alphabetsOnly);
				thisForm[j].focus();
				sub = false;
				break;
			}
			else if (thisForm[j].name == "ddFreq" && !DDFreqCheck(thisForm[j].value))
			{
				alert(_validDDPattern);
				thisForm[j].focus();
				sub = false;
				break;
			}
			else if(thisForm[j].name == "Xen_PS_Console_File_Path" && !checkSpecial(thisForm[j].value,"`!#^&+={}[]|\"\'<>?"))
			{
				thisForm[j].focus();
				sub = false;
				break;
			}
		}
	}
	if(sub)
	{
		//CODE FOR CTXAUTH TEST     
		if(userArr.length != passArr.length)
		{
			alert("<egui:intnl text='admin.test.Number of Users and passwords should be same'/>");
			thisForm.user.focus();
			sub = false;
		}
		//CODE FOR CTXAUTH TEST ... ENDS
		else
		{
			//if (isNetscape()) targetObj = document.updateImg;
			//if (isIE()) targetObj = updateImg.style;
			//targetObj.visibility = "hidden";
			if (isNetscape()) targetObj = document.testconfig.updateImg.disabled=true;
			if (isIE()) targetObj = document.testconfig.updateImg.disabled=true;	
			//alert("Please wait...");
			thisForm.updateImg.value="<egui:intnl text='admin.test.Updating'/>"+"...";
			thisForm.submit();
		}
	}
}

function comboChange(type)
{
	var tempType = type.toLowerCase();
	if(tempType=="snmpversion")
	{
		//var ver=document.testconfig.snmpversion.value;
		var ver = document.getElementById(type+"").value;
		var port=document.testconfig.snmpPort.value;
		if (port == null)
		{
			if (document.testconfig.snmpport != null)
			{
				port = document.testconfig.snmpport.value;
			}
			else if (document.testconfig.SnmpPort != null)
			{
				port = document.testconfig.SnmpPort.value;
			}
		}
		var t_period=document.testconfig.testperiod.value;
		window.location.href="EgTestParam.jsp?t_period="+t_period+"&t_name="+'<%=request.getParameter("t_name")%>'+"&server="+'<%=request.getParameter("server")%>'+"&version="+ver+"&port="+port+"&showAll="+'<%=request.getParameter("showAll")%>'+"&mode=true";
	}
}

function encryptFlagChange(value,ver_name,type)
{
	if(type=="encryptflag")
	{
		var authType=document.testconfig.authtype.value;
		var t_period=document.testconfig.testperiod.value;
		var port=document.testconfig.snmpPort.value;
		if (port == null)
		{
			if (document.testconfig.snmpport != null)
			{
				port = document.testconfig.snmpport.value;
			}
			else if (document.testconfig.SnmpPort != null)
			{
				port = document.testconfig.SnmpPort.value;
			}
		}
		var u_name=document.testconfig.username.value;
		var a_pwd=document.testconfig.authpass.value;
		var c_pwd=document.testconfig.aucon.value;
		if(u_name!=null)
		{
			while(u_name.indexOf("#") > -1)
			{
				u_name = u_name.replace("#","~");
			}
		}

		if(a_pwd!=null)
		{
			while(a_pwd.indexOf("#") > -1)
			{
				a_pwd = a_pwd.replace("#","~");
			}
		}

		if(c_pwd!=null)
		{
			while(c_pwd.indexOf("#") > -1)
			{
				c_pwd = c_pwd.replace("#","~");
			}
		}
		window.location.href="EgTestParam.jsp?t_period="+t_period+"&t_name="+'<%=request.getParameter("t_name")%>'+"&server="+'<%=request.getParameter("server")%>'+"&version="+ver_name+"&encryptFlag="+value+"&authType="+authType+"&port="+port+"&u_name="+encodeURI(u_name)+"&authPwd="+encodeURI(a_pwd)+"&con_pwd="+encodeURI(c_pwd)+"&showAll="+'<%=request.getParameter("showAll")%>'+"&mode=true";
	}
}

function configureOSPattern(serverName,testName,stringVar)
{
	window.open("EgRuntimePattern.jsp?servername="+encodeURI(serverName)+"&testname="+encodeURI(testName)+"&testParam="+encodeURI(stringVar),"DataWindow","width=550,height=300,left=0,top=132,scrollbars=0,scrollbars=yes");
}

function checkMode(value,query)
{
	var strQuery = query;
	if (query.indexOf("&mode=") > 0)
	{
		strQuery = query.substring(0,query.indexOf("&mode="));
	}
	strQuery = strQuery + "&mode=" + value;
	window.location.href = "EgTestParam.jsp?" + encodeURI(strQuery);
}

var plusButtonClicked="false";
function config_popup(theURL,winName,features)
{
	plusButtonClicked = "true";
	if(!window.vmgWindow)
	{
		vmgWindow=open(theURL,winName,features);
	}
	else
	{
		if(!vmgWindow.closed)
		{
			vmgWindow.close();
			vmgWindow = open(theURL,winName,features);
			vmgWindow.focus();
		}
		else
		{
			vmgWindow=open(theURL,winName,features);
		}
	}
}

var newDomainValue = "";
//for MultiUserSupportTest
var newAdminUserValue = "";
//for CtxAuthTest,TermAuthTest,WinAuthTest
var newUserValue = "";
function getUserValue(paramName)
{
	var thisForm = document.testconfig;
	if (paramName.toLowerCase() == "domain")
	{
		newDomainValue = thisForm.domain.value;
	}
	else if (paramName.toLowerCase() == "admin_user")
	{
		newAdminUserValue = thisForm.admin_user.value;
	}
	else if (paramName.toLowerCase() == "user")
	{
		newUserValue = thisForm.user.value;
	}
}

var changedDomainValue = "";
var changedAdminUserValue = "";
var changedUserValue = "";
function getUserChangedValue(paramName)
{
	var thisForm = document.testconfig;
	if (paramName.toLowerCase() == "domain")
	{
		changedDomainValue = thisForm.domain.value;
	}
	else if (paramName.toLowerCase() == "admin_user")
	{
		changedAdminUserValue = thisForm.admin_user.value;
	}
	else if (paramName.toLowerCase() == "user")
	{
		changedUserValue = thisForm.user.value;
	}
}

function checkMultipleUser(paramName,paramValue)
{
	var thisForm = document.testconfig;
	var multiUser = "false";
	if (paramName.toLowerCase() == "domain")
	{
		var domainValue = thisForm.domain.value;
		if (domainValue.indexOf(",") > -1)
		{
			multiUser = "true";
		}
	}
	else if (paramName.toLowerCase() == "admin_user")
	{
		var adminUserValue = thisForm.admin_user.value;
		if (adminUserValue.indexOf(",") > -1)
		{
			multiUser = "true";
		}
	}
	else if (paramName.toLowerCase() == "user")
	{
		var userValue = thisForm.user.value;
		if (userValue.indexOf(",") > -1)
		{
			multiUser = "true";
		}
	}

	if (multiUser == "true")
	{
		var orginalDomainValue = "";
		var orginalUserValue = "";
		if (plusButtonClicked == "true")
		{
			if (paramName.toLowerCase() == "domain")
			{
				var domainValue = thisForm.domain.value;
				if (domainValue != newDomainValue && domainValue.indexOf(",") > -1)
				{
					orginalDomainValue = newDomainValue;
				}
			}
			else if (paramName.toLowerCase() == "admin_user")
			{
				var adminUserValue = thisForm.admin_user.value;
				if (adminUserValue != newAdminUserValue && adminUserValue.indexOf(",") > -1)
				{
					orginalUserValue = newAdminUserValue;
				}
			}
			else if (paramName.toLowerCase() == "user")
			{
				var userValue = thisForm.user.value;
				if (userValue != newUserValue && userValue.indexOf(",") > -1)
				{
					orginalUserValue = newUserValue;
				}
			}
		}
		else
		{
			if (paramName.toLowerCase() == "domain")
			{
				var domainValue = thisForm.domain.value;
				if (domainValue != paramValue && domainValue.indexOf(",") > -1)
				{
					orginalDomainValue = paramValue;
				}
			}
			else if (paramName.toLowerCase() == "admin_user")
			{
				var adminUserValue = thisForm.admin_user.value;
				if (adminUserValue != paramValue && adminUserValue.indexOf(",") > -1)
				{
					orginalUserValue = paramValue;
				}
			}
			else if (paramName.toLowerCase() == "user")
			{
				var userValue = thisForm.user.value;
				if (userValue != paramValue && userValue.indexOf(",") > -1)
				{
					orginalUserValue = paramValue;
				}
			}
		}

		if (paramName.toLowerCase() == "domain")
		{
			var domainValue = thisForm.domain.value;
			if (domainValue != newDomainValue && domainValue.indexOf(",") > -1)
			{
				if (thisForm.testname != null && thisForm.testname.value != undefined)
				{
					if (thisForm.testname.value == "CtxAuthTest" || 
						thisForm.testname.value == "WinAuthTest" || 
						thisForm.testname.value == "TermAuthTest")
					{
						alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the USER text box or the \'Click here\' link above the test parameters to configure multiple domains and users'/>.");
					}
					else
					{
						alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the ADMIN USER text box or the \'Click here\' link above the test parameters to configure multiple domains and admin users'/>.");
					}
				}
				else
				{
					alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the USER text box or the \'Click here\' link above the test parameters to configure multiple domains and users'/>.");
				}
				if (changedDomainValue.indexOf(",") > -1)
				{
					thisForm.domain.value = changedDomainValue.substring(0,changedDomainValue.indexOf(","));
				}
				else
				{
					thisForm.domain.value = changedDomainValue;
				}
				tempField = thisForm.domain;
				setTimeout("tempField.focus()",0);
				return false;
			}
		}
		else if (paramName.toLowerCase() == "admin_user")
		{
			var adminUserValue = thisForm.admin_user.value;
			if (adminUserValue != newAdminUserValue && adminUserValue.indexOf(",") > -1)
			{
				alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the ADMIN USER text box or the \'Click here\' link above the test parameters to configure multiple domains and admin users'/>.");
				if (changedAdminUserValue.indexOf(",") > -1)
				{
					thisForm.admin_user.value = changedAdminUserValue.substring(0,changedAdminUserValue.indexOf(","));
				}
				else
				{
					thisForm.admin_user.value = changedAdminUserValue;
				}
				tempField = thisForm.admin_user;
				setTimeout("tempField.focus()",0);
				return false;
			}
		}
		else if (paramName.toLowerCase() == "user")
		{
			var userValue = thisForm.user.value;
			if (userValue != newUserValue && userValue.indexOf(",") > -1)
			{
				alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the USER text box or the \'Click here\' link above the test parameters to configure multiple domains and users'/>.");
				if (changedUserValue.indexOf(",") > -1)
				{
					thisForm.user.value = changedUserValue.substring(0,changedUserValue.indexOf(","));
				}
				else
				{
					thisForm.user.value = changedUserValue;
				}
				tempField = thisForm.user;
				setTimeout("tempField.focus()",0);
				return false;
			}
		}
	}
}

function checkHashTildeHash()
{
	var thisForm = document.testconfig;
	var multiUser = "false";

	if (thisForm.admin_user != null && thisForm.admin_user.value != undefined)
	{
		var adminUserValue = thisForm.admin_user.value;
		if (adminUserValue.indexOf(",") > -1)
		{
			multiUser = "true";
		}

		if (multiUser == "false")
		{
			var admin_passwordValue = thisForm.admin_password.value;

			if (!checkspecialnomess(admin_passwordValue,"\"|"))
			{
				alert("<egui:intnl text='admin.test.Password data should not contain pipe and double quotes' />");
				tempField = thisForm.admin_password;
				setTimeout("tempField.focus()",1);
				return false;
			}

			for(var k=0;k < admin_passwordValue.length;k++)
			{
				if(admin_passwordValue.charAt(k) == '#' && 
					admin_passwordValue.charAt(k + 1) == '~' && 
					admin_passwordValue.charAt(k + 2) == '#')
				{
					alert(_checkHashTildeHash);
					tempField = thisForm.admin_password;
					setTimeout("tempField.focus()",1);
					return false;
				}
			}
		}
	}
	else if (thisForm.user != null && thisForm.user.value != undefined)
	{
		var userValue = thisForm.user.value;
		if (userValue.indexOf(",") > -1)
		{
			multiUser = "true";
		}

		if (multiUser == "false")
		{
			var passwordValue = thisForm.password.value;

			if (!checkspecialnomess(passwordValue,"\",|"))
			{
				alert("<egui:intnl text='admin.test.Password data should not contain pipe, comma and double quotes' />");
				tempField = thisForm.password;
				setTimeout("tempField.focus()",1);
				return false;
			}

			for(var k=0;k < passwordValue.length;k++)
			{
				if (passwordValue.charAt(k) == '#' && 
					passwordValue.charAt(k + 1) == '~' && 
					passwordValue.charAt(k + 2) == '#')
				{
					alert(_checkHashTildeHash);
					tempField = thisForm.password;
					setTimeout("tempField.focus()",1);
					return false;
				}
			}
		}
	}
}

function checkHeap(value,query)
{
	var strQuery = query;
	if (query.indexOf("&javahome=") > 0)
	{
		strQuery = query.substring(0,query.indexOf("&javahome="));
	}

	var mode = "";
	if (document.testconfig.mode[0].checked)
	{
		mode = document.testconfig.mode[0].value
	}
	else if(document.testconfig.mode[1].checked)
	{
		mode = document.testconfig.mode[1].value
	}

	var testPeriod = document.testconfig.testperiod.value;
	//var host = document.testconfig.host.value;
	//var port = document.testconfig.port.value;
	//strQuery = strQuery + "&javahome=" + value + "&testperiod=" + testPeriod + "&host=" + host +"&port=" + port;
	strQuery = strQuery + "&javahome=" + value + "&testperiod=" + testPeriod;
	if (mode=="false")
	{
		var Jmx_Remote_Port = document.testconfig.Jmx_Remote_Port.value;
		var Jndi_Name = "";
		if (document.testconfig.Jndi_Name != null && document.testconfig.Jndi_Name != undefined)
		{
			Jndi_Name = document.testconfig.Jndi_Name.value;
		}
		var user = document.testconfig.user.value;
		var password = document.testconfig.password.value;
		var cpwd = document.testconfig.cpwd.value;
		strQuery = strQuery + "&Jmx_Remote_Port=" + Jmx_Remote_Port + "&Jndi_Name=" + Jndi_Name + "&user=" + user + "&password=" + password + "&cpwd=" + cpwd;
	}
	else if (mode=="true")
	{
		var snmpversion = document.testconfig.snmpversion.value;
		var snmpPort = document.testconfig.snmpPort.value;
		var timeout = document.testconfig.timeout.value;
		strQuery = strQuery + "&version=" + snmpversion + "&snmpPort=" + snmpPort + "&timeout=" + timeout;
		if (snmpversion=="v1" || snmpversion=="v2")
		{
			var snmpCommunity = document.testconfig.snmpCommunity.value;
			strQuery = strQuery + "&snmpCommunity=" + snmpCommunity;
		}

		if (snmpversion=="v3")
		{
			var username = document.testconfig.username.value;
			var authpass = document.testconfig.authpass.value;
			//confirm password for authpass.
			var aucon = document.testconfig.aucon.value;
			var authtype = document.testconfig.authtype.value;
			if (document.testconfig.encryptflag[0].checked)
			{
				var encryptpassword = document.testconfig.encryptpassword.value;
				var encryptconfirmpassword = document.testconfig.encon.value;
				strQuery = strQuery + "&username=" + username + "&authPwd=" + authpass + "&con_pwd=" + aucon +
				"&authType=" + authtype + "&encryptFlag=yes&encryptpassword=" + encryptpassword + "&encon=" + encryptconfirmpassword;
			}
			else if(document.testconfig.encryptflag[1].checked)
			{
				strQuery = strQuery + "&username=" + username + "&authPwd=" + authpass + "&con_pwd=" + aucon +
				"&authType=" + authtype + "&encryptFlag=no";
			}
		}
	}

	window.location.href = "EgTestParam.jsp?" + encodeURI(strQuery);
}

function vc_onChange(query)
{
	var testPeriod=document.testconfig.testperiod.value;
	if (query.indexOf("&vcIP=") > 0)
	{
		query=query.substring(0,query.indexOf("&vcIP="));
	}
	var selectedVcIp=document.testconfig.virtual_center.options[document.testconfig.virtual_center.selectedIndex].value;
	if (selectedVcIp == 'Other')
	{
		openVCDetails(this.event,'EgVcConfig.jsp');
	}
	else
	{
		window.location.href = "EgTestParam.jsp?"+query+"&vcIP="+selectedVcIp+"&t_period="+testPeriod;
	}
}

function InsideViewChange(value)
{
	var thisForm = document.testconfig;

	if (value == "tcp")
	{
		if (thisForm.domain != null && 
			thisForm.domain != undefined && 
			thisForm.domain.value == "$unconfigured")
		{
			thisForm.domain.value = "none";
		}

		if (thisForm.admin_user != null && 
			thisForm.admin_user != undefined && 
			thisForm.admin_user.value == "$unconfigured")
		{
			thisForm.admin_user.value = "none";
		}

		if (thisForm.admin_password != null && 
			thisForm.admin_password != undefined && 
			thisForm.admin_password.value == "$unconfigured")
		{
			thisForm.admin_password.value = "none";
		}

		if (thisForm.Admincpwd != null && 
			thisForm.Admincpwd != undefined && 
			thisForm.Admincpwd.value == "$unconfigured")
		{
			thisForm.Admincpwd.value = "none";
		}
	}
	else
	{
		if (thisForm.domain != null && 
			thisForm.domain != undefined && 
			thisForm.domain.value == "none")
		{
			thisForm.domain.value = "$unconfigured";
		}

		if (thisForm.admin_user != null && 
			thisForm.admin_user != undefined && 
			thisForm.admin_user.value == "none")
		{
			thisForm.admin_user.value = "$unconfigured";
		}

		if (thisForm.admin_password != null && 
			thisForm.admin_password != undefined && 
			thisForm.admin_password.value == "none")
		{
			thisForm.admin_password.value = "$unconfigured";
		}

		if (thisForm.Admincpwd != null && 
			thisForm.Admincpwd != undefined && 
			thisForm.Admincpwd.value == "none")
		{
			thisForm.Admincpwd.value = "$unconfigured";
		}
	}
}

function PolicyFilterEnabled(value,query)
{
	var testPeriod = document.testconfig.testperiod.value;
	var useWmi = "";
	if (document.testconfig.useWmi != null && document.testconfig.useWmi != undefined)
	{
		if (document.testconfig.useWmi[0].checked)
		{
			useWmi = document.testconfig.useWmi[0].value
		}
		else if(document.testconfig.useWmi[1].checked)
		{
			useWmi = document.testconfig.useWmi[1].value
		}
	}
	var query1;
	if(query.indexOf("&policyFlag=")>0)
		query1=query.substring(0,query.indexOf("&policyFlag="));
	else
		query1=query;

	window.location.href="EgTestParam.jsp?"+encodeURI(query1)+"&policyFlag="+value+"&t_period=" + testPeriod+"&useWmi=" + useWmi;
}

</script>
</head>

<body>
<%!
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");

	public final boolean isParameter (String s2)
	{
		String ss = EgCrypt.decrypt(s2);
		if (ss.equals(s2)) // not password
		{
			if (s2.length() > 1)
			{
				return (true);
			}
		}
		return false;
	}
%>

<%
	com.eg.IniFile testparamIni=new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_testparam.ini");
	String allowedParams=testparamIni.getValue("SPECIAL_CHARACTERS","Parameters");

	String[] tcKeywords=testparamIni.getVariables("TEST_CONFIGURATION_PARAM_VALUE_KEYWORDS");
	List listTcKeywords = Arrays.asList(tcKeywords);
	ArrayList aListTcKeywordsLowerCase = new ArrayList();
	for (int i=0;i<listTcKeywords.size();i++)
	{
		String strKeyword = (String)listTcKeywords.get(i);
		strKeyword = strKeyword.trim();
		strKeyword = strKeyword.toLowerCase();
		aListTcKeywordsLowerCase.add(strKeyword);
	}
	String strTcKeywords = listTcKeywords.toString();
	strTcKeywords = strTcKeywords.substring(1,strTcKeywords.length()-1);
	strTcKeywords = StringUtils.replace(strTcKeywords,", ",",");
	session.setAttribute("tcKeywords",tcKeywords);

	com.eg.IniFile testIniFile = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini");
	List listMultipleUserSupportTest = Arrays.asList(testIniFile.getVariables("MULTIPLE_USERS"));

	IniFile  uiIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String[] testFormatPeriod = uiIni.getVariables("TEST_FREQUENCY");
	String[] testPeriodStr = null;
	String[] testperiod = null;
	TreeMap periodMap = new TreeMap();
	if(!EgUtils.isNull((Object) testFormatPeriod))
	{
		int j = 0;
		for (int i=0;i<testFormatPeriod.length;i++)
		{
			String testFreq = uiIni.getValue("TEST_FREQUENCY", testFormatPeriod[i]);
			long lngFreq = Long.parseLong(testFreq);
			if(lngFreq == 5 || lngFreq == 10)
				continue;
			else
			{
				periodMap.put(new Long(lngFreq), testFormatPeriod[i]);
			}
			j++;
		}
		Iterator itr = periodMap.keySet().iterator();
		testperiod = new String[periodMap.size()];
		testPeriodStr = new String[periodMap.size()];
		for(int i=0; i<periodMap.size(); i++)
		{
			Long lngperiod = (Long) itr.next();
			testperiod[i] =lngperiod.toString();
			testPeriodStr[i] = (String) periodMap.get(lngperiod);
		}
	}
	session.setAttribute("periodMap",periodMap);
	Vector test=new Vector();
	String typeOfServer = request.getParameter("server");
	String testName = request.getParameter("t_name");
	String authType=request.getParameter("authType");
	String testPeriod=request.getParameter("t_period");
	String snmpPort=request.getParameter("port");
	String u_name=request.getParameter("u_name");
	String authPwd=request.getParameter("authPwd");
	String conPwd=request.getParameter("con_pwd");
	String snmpVersion="";
	String encryptFlag="";
	if(request.getParameter("version")!=null && request.getParameter("version").length()>0)
		snmpVersion=request.getParameter("version");
	if(request.getParameter("encryptFlag")!=null && request.getParameter("encryptFlag").length()>0)
		encryptFlag=request.getParameter("encryptFlag");
	boolean checkforport = egSpecs.isPortRelevantForTest(testName);
	Hashtable ht_prevValue=new Hashtable();

	String query=request.getQueryString();

	String strTok = "";
	String serverName = typeOfServer;
	StringTokenizer st = null;
	int stCount = 0; 
	String check = "";
	String stringVar = "";
	String stringVal = "";
	String strTemp = null;
	String s_temp = null;
	String strValue = null; 
	String ss_tmp = "";
	Vector vecThrow = new Vector();
	Vector newtest=new Vector();
	String ddval="";
	String borderfortd="formtop_border";
	//Inifile operations

	String testInfoPattern = egSpecs.getTestInfoPattern(testName);
	String testInfoDelimiter = egSpecs.getTestInfoDelimiter(testName);

	String policyFilterValue = "";
	String log = "";

	String compname = "$hostName:$portNo";
	//Check for tests with port number
	if(checkforport)
	{
		if(serverName.equals("Oracle_server"))
		{
			s_temp = testName + "::" + compname + ":" + "$sid";
		}
		else
		{
			s_temp = testName + "::" + compname;
		}
	}
	else
	{
		s_temp = testName + "::" + "$hostName";
	}

	//prgBean.createFile("eg_specs.ini");
	//strIniVar = prgBean.getVariables(EgSpecsInfo.testSpecSection);
	String[] strIniVar = egSpecs.getTestSpecVar();
	boolean cellFlag = false;
	for(int i=0; i<strIniVar.length; i++)
	{
		cellFlag = (i+1)<strIniVar.length;
		if(strIniVar[i].startsWith("Format:testName"))
		{
			continue;
		}
		st = new StringTokenizer(strIniVar[i],":");
		check = st.nextToken() + ":" + st.nextToken();
		if(check.equals(testName+":"+serverName))
		{
			//New code
			if(checkforport)
			{
				check = check+":"+st.nextToken()+":"+st.nextToken();
				if(check.equals(testName+":"+serverName+":"+compname))
				{
					s_temp = testName+":"+serverName+":"+compname;
					if(serverName.equalsIgnoreCase("Oracle_server"))
						s_temp += ":" + st.nextToken();
				}
			}
			else
			{
				check = check+":"+st.nextToken();
				if(check.equals(testName+":"+serverName+":"+"$hostName"))
				{
					s_temp = testName+":"+serverName+":"+"$hostName";
				}
			}
		}
	}

	String strIniVal = egSpecs.getArgsForTest(s_temp);
	if (strIniVal == null || strIniVal.equals(""))
	{
		Vector sess_vec = new Vector();
		sess_vec.addElement(_mapping.getTextDescription("admin.test.Configure Agents!"));
		sess_vec.addElement("EgStypeTlist.jsp?qctr=1&server=" + serverName);
		sess_vec.addElement(_mapping.getTextDescription("admin.test.TEST NOT AVAILABLE FOR CONFIGURATION"));
		sess_vec.addElement("<b>"+_mapping.getTestDescription(testName)+"</b> "+_mapping.getTextDescription("admin.test.for")+" <b>"+_mapping.getComponentTypeDescription(serverName)+"</b> "+_mapping.getTextDescription("admin.test.is currently not available for configuration")+". ");
		sess_vec.addElement("<br>"+_mapping.getTextDescription("admin.test.Please contact System administrator")+".");
		session.setAttribute("vec_Errors",sess_vec);
%>
		<jsp:forward page="EgErrors.jsp"/>
<%
	}
%>

<jsp:useBean id="prgBean" scope="page" class="egurkha.EgTestParamBean"/>

<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" >
	<jsp:include page="listSearch.jsp?title=TEST DETAILS&leftString=Add User&backButton=true&subtitle=false"/>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
		<form name="testconfig" method="post" action="EgTestParampp.jsp" style="margin:0px">
			<table align="center" width="85%" cellspacing="0" cellpadding="0" border="0" style="table-layout:auto"><col width="16"><col width="300"><col width="5"><col width="50%"><col width="7">
				<tr>
					<td colspan="5" align="center" height="20"  nowrap><egui:intnl text="admin.test.Parameters to be configured for"/>&nbsp;<b><egui:intnl test="<%=testName%>"/></b>
<%
	if (checkforport)
	{
%>
						<egui:intnl text="admin.test.of"/>&nbsp;<b><egui:intnl type="<%=typeOfServer%>"/></b>
<%
	}
%>
					</td>
				</tr>
<%
	boolean multiUserMode = false;
%>
				<tr>
					<td height="7" colspan="5" id="eg_blankspace" >&nbsp;</td>
				</tr>
<%
	if (listMultipleUserSupportTest != null && listMultipleUserSupportTest.contains(testName))
	{
		multiUserMode = true;
%>
				<tr>
					<td colspan="5">
						<table>
							<tr>
								<td>
								<th nowrap height="20" align="left"><a name="conf"><egui:intnl text="admin.test.To configure users for this test" /></a>,&nbsp; <a href = "javascript:void(0)" onClick="config_popup('./VmgUsers.jsp?server=<%=typeOfServer%>&test=<%=testName%>&port=<%=checkforport%>&compname=&showAll=<%=request.getParameter("showAll")%>&logtype=','','width=900,height=380,top=150,left=50')"> <b ><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a></th>
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%
	}
	else if (testName.equalsIgnoreCase("CtxAuthTest") || 
			testName.equalsIgnoreCase("WinAuthTest") || 
			testName.equalsIgnoreCase("TermAuthTest"))
	{
		multiUserMode = true;
%>
				<tr>
					<td colspan="5">
						<table>
							<tr>
								<td>
								<th nowrap height="20" align="left"><a name="conf"><egui:intnl text="admin.test.To configure users for this test" /></a>,&nbsp; <a href = "javascript:void(0)" onClick="config_popup('./EgConfigureMultipleUsers.jsp?server=<%=typeOfServer%>&test=<%=testName%>&port=<%=checkforport%>&compname=&showAll=<%=request.getParameter("showAll")%>&logtype=','','width=900,height=380,top=150,left=50')"> <b ><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a></th>
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%
	}

	/* to get remaining variable value pairs  */
	st = new StringTokenizer(strIniVal,",");
	stCount = st.countTokens();
	for(int g=0; g<stCount; g++)
	{
		strTemp = st.nextToken();
		if(g==2)
		{
			strValue = strTemp;
		}
	}
	Vector vecVarPair = new Vector();
	Vector vecValPair = new Vector();

	st = new StringTokenizer(strValue," ");
	stCount = st.countTokens();
	/* to retrieve $serviceName with space from eg_specs.ini */	
	for(int x=0; x<stCount; x++)
	{
		strTok = st.nextToken();
		strTok = strTok.trim();

		if(strTok.startsWith("-") && isParameter(strTok))
		{
			if(!ss_tmp.equals(""))
			{
				vecValPair.addElement(ss_tmp);
				ss_tmp = "";
			}
			vecVarPair.addElement(strTok);
		}
		else
		{
			ss_tmp = ss_tmp + strTok + " ";
		}
	}
	vecValPair.addElement(ss_tmp);
	//..................................SNMP Modification starts here........................//

	Vector tmpVarPair = new Vector();
	for (int i=0;i<vecVarPair.size();i++)
	{
		tmpVarPair.add(vecVarPair.get(i).toString().toLowerCase());
	}

	boolean isSnmp=false;
	isSnmp=tmpVarPair.contains("-snmpport"); 

	//by anand - Start
	boolean isModeParamExist =false;
	isModeParamExist = (isSnmp && tmpVarPair.contains("-mode") && tmpVarPair.contains("-jmx_remote_port"));
	//by anand - End

	String flag="";
	String selection="";
	String[] versions={"v1","v2","v3"};
	String[] authTypes={"MD5","SHA"};
	String[] encryptTypes={"DES","AES"};
	String[] group={""};
	boolean isOlderSnmp = false;
	if(isSnmp)
	{
		int portIdx = tmpVarPair.indexOf("-port");
		String portCase = null;
		if (portIdx != -1)
		{
			portCase = (String)vecVarPair.get(portIdx);
		}

		int timeOutIdx = tmpVarPair.indexOf("-timeout");
		String timeOutCase = null;
		if (timeOutIdx != -1)
		{
			timeOutCase = (String)vecVarPair.get(timeOutIdx);
		}

		int modeIdx = tmpVarPair.indexOf("-mode");
		String modeCase = null;
		if (modeIdx != -1)
		{
			modeCase = (String)vecVarPair.get(modeIdx);
		}

		int comm_index=tmpVarPair.indexOf("-snmpcommunity");
		if (!tmpVarPair.contains("-snmpversion"))
		{
			vecVarPair.add(comm_index+1,"-snmpversion");
			vecValPair.add(comm_index+1,"v1");
			tmpVarPair.add(comm_index+1,"-snmpversion");
			isOlderSnmp = true;
		}
		if(!vecVarPair.contains("-encrypttype"))
		{
			String[] tmpVersions = {"v1","v2"};
			versions = tmpVersions;
		}

		int ver_index=tmpVarPair.indexOf("-snmpversion");
		String tempSnmpVersionCase = (String)vecVarPair.get(ver_index);
		String move=(String)vecVarPair.remove(comm_index);
		String move1=(String)vecValPair.remove(comm_index);
		ver_index=vecVarPair.indexOf(tempSnmpVersionCase);
		vecVarPair.add(ver_index+1,move);
		vecValPair.add(ver_index+1,move1);

		//by anand - starts
		if (isModeParamExist)
		{
			if (timeOutIdx == -1)
			{
				//put mode after port
				//-host,-port,-mode
				int tempModeIdx = vecVarPair.indexOf(modeCase);
				String moveModeParam = (String)vecVarPair.remove(tempModeIdx);
				String moveModeValue = (String)vecValPair.remove(tempModeIdx);

				int tempPortIdx = vecVarPair.indexOf(portCase);
				vecVarPair.add(tempPortIdx+1,moveModeParam);
				vecValPair.add(tempPortIdx+1,moveModeValue);
			}
			else
			{
				int tempTimeOutCaseIdx = vecVarPair.indexOf(timeOutCase);
				String moveTimeOutParam = (String)vecVarPair.remove(tempTimeOutCaseIdx);
				String moveTimeOutValue = (String)vecValPair.remove(tempTimeOutCaseIdx);

				//-host,-port,-timeout,-mode
				//put timeout after port
				int tempPortIdx = vecVarPair.indexOf(portCase);
				vecVarPair.add(tempPortIdx+1,moveTimeOutParam);
				vecValPair.add(tempPortIdx+1,moveTimeOutValue);

				int tempModeCaseIdx = vecVarPair.indexOf(modeCase);
				String moveModeParam = (String)vecVarPair.remove(tempModeCaseIdx);
				String moveModeValue = (String)vecValPair.remove(tempModeCaseIdx);

				//put mode after timeout
				int tempTimeOutCaseIdx1 = vecVarPair.indexOf(timeOutCase);
				vecVarPair.add(tempTimeOutCaseIdx1+1,moveModeParam);
				vecValPair.add(tempTimeOutCaseIdx1+1,moveModeValue);
			}
		}
		//by anand - ends
	}

	//To do the following
	//1.Configure value for virtual centers 
	//2.Change webport value,when its value is default - starts
	TreeMap tmapVc = null;
	String tempSelectedVc = null;
	String esxUserName = null;
	String esxPassword = null;
	String isSSlForEsx = null;
	String webPort = null;
	if (tmpVarPair.contains("-webport") && 
		tmpVarPair.contains("-ssl"))
	{
		if (tmpVarPair.contains("-virtual_center"))
		{
			//To configure value for virtual centers - starts
			tmapVc = new TreeMap();
			com.eg.IniFile servicesIniFile = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
			String[] VcIPs = servicesIniFile.getVariables("VIRTUAL_CENTER");
			ArrayList aListVcIps = new ArrayList(Arrays.asList(VcIPs));
			for (int i=0;i<aListVcIps.size();i++)
			{
				ArrayList aListVcParams = new ArrayList();
				String tempVcIp = (String)aListVcIps.get(i);
				String tempVcParam = servicesIniFile.getValue("VIRTUAL_CENTER",tempVcIp);
				StringTokenizer stVc = new StringTokenizer(tempVcParam,"#");
				String tempSsl = stVc.nextToken();
				String tempUserName = stVc.nextToken();
				String tempPassword = EgCrypt.decrypt(stVc.nextToken());
				String tempIsDiscovery = stVc.nextToken();
				String tempWebPort = stVc.nextToken();

				aListVcParams.add(tempUserName);
				aListVcParams.add(tempPassword);
				aListVcParams.add(tempSsl);
				aListVcParams.add(tempWebPort);

				tmapVc.put(tempVcIp,aListVcParams);
			}

			int virtual_centerIdx = tmpVarPair.indexOf("-virtual_center");
			String virtual_centerValue = ((String)vecValPair.get(virtual_centerIdx)).trim();

			tempSelectedVc = request.getParameter("vcIP");

			if (tempSelectedVc == null)
			{
				if (virtual_centerValue.equalsIgnoreCase("none"))
				{
					int tempIdx = tmpVarPair.indexOf("-webport");
					webPort = ((String)vecValPair.get(tempIdx)).trim();
					if (webPort.equalsIgnoreCase("default"))
					{
						tempIdx = tmpVarPair.indexOf("-ssl");
						String sslValue = ((String)vecValPair.get(tempIdx)).trim();
						if (sslValue.equalsIgnoreCase("true") || 
							sslValue.equalsIgnoreCase("yes"))
						{
							webPort = "443";
						}
						else
						{
							webPort = "80";
						}
					}
				}
			}
			else
			{
				if (tempSelectedVc.equalsIgnoreCase("none"))
				{
					if (virtual_centerValue.equalsIgnoreCase("none"))
					{
						int tempIdx = tmpVarPair.indexOf("-webport");
						webPort = ((String)vecValPair.get(tempIdx)).trim();
						if (webPort.equalsIgnoreCase("default"))
						{
							tempIdx = tmpVarPair.indexOf("-ssl");
							String sslValue = ((String)vecValPair.get(tempIdx)).trim();
							if (sslValue.equalsIgnoreCase("true") || 
								sslValue.equalsIgnoreCase("yes"))
							{
								webPort = "443";
							}
							else
							{
								webPort = "80";
							}
						}
					}
					else
					{
						esxUserName = "$unconfigured";
						esxPassword = "$unconfigured";
						isSSlForEsx = "Yes";
						webPort = "443";
					}
				}
				else
				{
					ArrayList tempVcDetails = (ArrayList)tmapVc.get(tempSelectedVc);
					esxUserName = (String)tempVcDetails.get(0);
					esxPassword = (String)tempVcDetails.get(1);
					isSSlForEsx = (String)tempVcDetails.get(2);
					webPort = (String)tempVcDetails.get(3);
				}
			}
			//To configure value for virtual centers - ends
		}
		else
		{
			int webPortIdx = tmpVarPair.indexOf("-webport");
			webPort = ((String)vecValPair.get(webPortIdx)).trim();
			if (webPort.equalsIgnoreCase("default"))
			{
				int sslIdx = tmpVarPair.indexOf("-ssl");
				String tempSslValue = ((String)vecValPair.get(sslIdx)).trim();
				if (tempSslValue.equalsIgnoreCase("true") || 
					tempSslValue.equalsIgnoreCase("yes"))
				{
					webPort = "443";
				}
				else
				{
					webPort = "80";
				}
			}
		}
	}
	//ends

	if(vecVarPair!=null && vecVarPair.contains("-policyFilter"))
	{
		String tempPolicyFlag = request.getParameter("policyFlag");
		if (tempPolicyFlag == null)
		{
			tempPolicyFlag = "";
		}
		int lognum=vecVarPair.indexOf("-logType");
		log=((String)vecValPair.get(lognum)).trim();
		lognum=vecVarPair.indexOf("-policyFilter");
		session.setAttribute("BackQuery",request.getQueryString().replace('&',','));
		if((((String)vecValPair.get(lognum)).trim().equals("true")&& tempPolicyFlag=="")|| tempPolicyFlag.equalsIgnoreCase("true"))
		{
%>
				<tr>
					<td colspan="5">
						<table>
							<tr>
								<td>
								<th nowrap height="20" align="left"><a name="conf"><egui:intnl text="admin.test.To add/modify Policy"/></a>,&nbsp; <a href = "ViewPolicy.jsp?server=<%=typeOfServer%>&test=<%=testName%>&port=<%=checkforport%>&showAll=&q=<%=request.getQueryString().replace('&',',')%>&logtype=<%=log%>&requestFrom=EgTestParam.jsp"> <b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"> </a></th>
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%
		}
	}

	strTemp = strIniVal.substring(strIniVal.lastIndexOf(",")+1).trim();
	vecThrow.addElement("testperiod");
	vecThrow.addElement("null");
	vecThrow.addElement(strTemp);
	ht_prevValue.put("testperiod",strTemp);
	if(testPeriod!=null && testPeriod.length()>0)
		strTemp=testPeriod;

	auditLogHashtable.put("Test Period","testperiod:"+strTemp);
%>
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td id="eg_subcontentbg" class="form_spacing">&nbsp</td>
					<td id="eg_subcontentbg" class="form_spacing"><egui:intnl text="admin.test.TEST PERIOD"/></td>
					<td  id="eg_subcontentbg" class="form_spacing" height="30">:</td>
					<!-- <%test.add("testperiod");%> -->
					<td id="eg_subcontentbg" class="form_spacing" style="padding-left:12px"><select name="testperiod" class="list"><%=HtmlUtils.setSelectOptions(testPeriodStr, testperiod, strTemp)%></select></td>
					<td id="eg_subcontentbg" class="form_spacing" >&nbsp</td>
				</tr>
<%

	boolean comm_show=false;
	boolean others_show=false;
	boolean encr_info=true;
	for(int g=0; g<vecVarPair.size(); g++)
	{
		boolean combo=false;
		stringVar = (String)vecVarPair.elementAt(g);
		stringVar = stringVar.substring(1).trim();
		if(stringVar.equalsIgnoreCase("mCount") || 
			stringVar.equalsIgnoreCase("rptName") || 
			stringVar.equalsIgnoreCase("Hyperv") || 
			stringVar.equalsIgnoreCase("isLdoms"))
		{
			continue;
		}
		stringVal = (String)vecValPair.elementAt(g);
		stringVal = stringVal.trim();

		if (stringVar.equalsIgnoreCase("process"))
		{
			if (stringVal.indexOf("eGSpHyGe") != -1)
			{
				stringVal = StringUtils.replace(stringVal,"eGSpHyGe"," -");
			}
		}

		if(isSnmp)
		{
			//By Anand - Start
			if (isModeParamExist)
			{
				int modeIdx = vecVarPair.indexOf("-mode");
				String modeValue = ((String)vecValPair.elementAt(modeIdx)).trim();
				String requestModeValue = request.getParameter("mode");
				requestModeValue = (requestModeValue==null)?"":requestModeValue;
				if (!requestModeValue.equals("")) modeValue = requestModeValue;

				if (modeValue.equalsIgnoreCase("true"))
				{
					if (stringVar.equalsIgnoreCase("Jmx_Remote_Port") ||
						stringVar.equalsIgnoreCase("Jndi_Name") ||
						stringVar.equalsIgnoreCase("user") ||
						stringVar.equalsIgnoreCase("password"))
					{
						continue;
					}
				}
				else
				{
					if (stringVar.equalsIgnoreCase("snmpversion") ||
						stringVar.equalsIgnoreCase("snmpcommunity") ||
						stringVar.equalsIgnoreCase("snmpPort") ||
						stringVar.equalsIgnoreCase("authtype") ||
						stringVar.equalsIgnoreCase("authpass") ||
						//stringVar.equalsIgnoreCase("timeout") ||
						stringVar.equalsIgnoreCase("username") ||
						stringVar.equalsIgnoreCase("encryptflag") ||
						stringVar.equalsIgnoreCase("encryptpassword") ||
						stringVar.equalsIgnoreCase("encrypttype"))
					{
						continue;
					}
				}

				if (vecVarPair.contains("-Heap_Analysis"))
				{
					int heapIdx = vecVarPair.indexOf("-Heap_Analysis");
					String heapValue = ((String)vecValPair.elementAt(heapIdx)).trim();
					String requestHeapValue = request.getParameter("javahome");
					requestHeapValue = (requestHeapValue==null)?"":requestHeapValue;
					if (!requestHeapValue.equals("")) heapValue = requestHeapValue;
					if (heapValue.equalsIgnoreCase("false"))
					{
						if (stringVar.equalsIgnoreCase("Java_Home"))
						{
							continue;
						}
					}
				}
			}
			//By Anand - End

			if(stringVar.equalsIgnoreCase("snmpversion") || stringVar.equalsIgnoreCase("authtype") || stringVar.equalsIgnoreCase("encrypttype"))	
			{
				combo=true;
			}

			if(stringVar.equalsIgnoreCase("snmpversion") && (snmpVersion.equalsIgnoreCase("v1") || snmpVersion.equalsIgnoreCase("v2")))
			{
				comm_show=true;
			}
			else
			{
				if(snmpVersion.length()==0 && (stringVal.equalsIgnoreCase("v1") || stringVal.equalsIgnoreCase("v2")))
				{
					comm_show=true;
				}
			}

			if(comm_show==false && stringVar.equalsIgnoreCase("snmpcommunity"))
			{
				continue;
			}
			if (isOlderSnmp && stringVar.equalsIgnoreCase("snmpversion"))
			{
				continue;
			}

			if(stringVar.equalsIgnoreCase("snmpversion"))
			{
				selection=stringVal;
				if(snmpVersion!=null && snmpVersion.length()>0)
				{
					selection=snmpVersion;
				}
			}
			if(stringVar.equalsIgnoreCase("authtype"))
			{
				selection=stringVal;
				if(authType!=null && (authType.length()>0))
				{
					selection=authType;
				}
			}
			if(stringVar.equalsIgnoreCase("encryptflag"))
			{
				if(stringVal.equalsIgnoreCase("false"))
				{
					encr_info=false;
				}
			}
			if(encryptFlag.equalsIgnoreCase("yes"))
			{
				encr_info=true;
			}
			else if(encryptFlag.equalsIgnoreCase("no"))
			{
				encr_info=false;
			}
			if(!encr_info)
			{
				if(stringVar.equalsIgnoreCase("encrypttype") || stringVar.equalsIgnoreCase("encryptpassword"))
					continue;
			}
			if(stringVar.equalsIgnoreCase("snmpPort") && snmpPort!=null && snmpPort.length()>0)
			{
				stringVal=snmpPort;
			}
			if(stringVar.equalsIgnoreCase("username") && u_name!=null && u_name.length()>0)
			{
				stringVal=u_name;
			}
			if(stringVar.equalsIgnoreCase("authpass") && authPwd!=null && authPwd.length()>0)
			{
				stringVal=authPwd;
			}
			if(others_show && (stringVar.equalsIgnoreCase("username") ||stringVar.equalsIgnoreCase("authpass")||stringVar.equalsIgnoreCase("authtype")
				||stringVar.equalsIgnoreCase("encryptflag") ||stringVar.equalsIgnoreCase("encrypttype") ||stringVar.equalsIgnoreCase("encryptpassword")))
			{
				continue;
			}
		}

		ht_prevValue.put(stringVar,stringVal);

		vecThrow.addElement(stringVar);
		String strConv = "-" + stringVar;
		vecThrow.addElement(strConv);

		String capsStringVar = stringVar.toUpperCase();
		if (capsStringVar.indexOf("PASSWORD") > -1 || capsStringVar.indexOf("AUTHPASS") > -1)
		{
			if(stringVal.indexOf("|") > -1)
			{
				String tempStr = "";
				StringTokenizer st1 = new StringTokenizer(stringVal, "|");
				while(st1.hasMoreTokens())
				{
					tempStr += EgCrypt.decrypt(st1.nextToken()) + "#~#";
				}
				stringVal = tempStr.substring(0, tempStr.length()-3);
			}
			else
				stringVal = EgCrypt.decrypt(stringVal);
			vecThrow.addElement(stringVal);
		}
		else
		{
			vecThrow.addElement(stringVal);
		}

		if(stringVar.equals("host") 
			|| stringVar.equals("port") 
			|| stringVar.equals("url") 
			|| stringVar.equals("targets") 
			|| stringVar.equals("content") 
			|| stringVar.equals("credentials"))
		{
			continue;
		}

		//newtest.add(stringVal);
		int y=newtest.size();
		//display of text box if there is no #
		if (stringVar.equalsIgnoreCase("filter") || (stringVal.indexOf("#") < 0 && stringVal.indexOf("|") < 0))
		{
			String plusButton = "";

			if (listMultipleUserSupportTest != null && 
				listMultipleUserSupportTest.contains(testName))
			{
				if (multiUserMode && stringVar.equalsIgnoreCase("admin_user"))
				{
					plusButton = "<img src=\"/final/admin/eg_images/plus.gif\" title=\"Click here to configure user(s)\" class=\"leftmouse\" onClick=\"config_popup(\'./VmgUsers.jsp?server="+typeOfServer+"&test="+testName+"&port="+checkforport+"&compname=&showAll="+request.getParameter("showAll")+"&logtype=\',\'\',\'width=900,height=380,top=150,left=50\')\">";
				}
			}

			if (testName.equalsIgnoreCase("CtxAuthTest") || 
				testName.equalsIgnoreCase("WinAuthTest") || 
				testName.equalsIgnoreCase("TermAuthTest"))
			{
				if (multiUserMode && stringVar.equalsIgnoreCase("user"))
				{
					plusButton = "<img src=\"/final/admin/eg_images/plus.gif\" title=\"Click here to configure user(s)\" class=\"leftmouse\" onClick=\"config_popup(\'./EgConfigureMultipleUsers.jsp?server="+typeOfServer+"&test="+testName+"&port="+checkforport+"&compname=&showAll="+request.getParameter("showAll")+"&logtype=\',\'\',\'width=900,height=380,top=150,left=50\')\">";
				}
			}

			if (capsStringVar.indexOf("ENCRYPTPASSWORD")>-1)
			{
				auditLogHashtable.put(capsStringVar,stringVar+":"+stringVal);
%>
				<tr>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">
					<egui:intnl text='<%="admin.test."+capsStringVar%>'/></td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">:</td>
					<td height="30" id="eg_subcontentbg" class="<%=borderfortd%>" style="padding-left:12px"><input type="password" name="<%=stringVar%>" value="<%=stringVal%>" class="list"></td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" >&nbsp</td>
				</tr>
				<tr>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
					<td  id="eg_subcontentbg" class="<%=borderfortd%>">
					<egui:intnl text="admin.test.CONFIRM PASSWORD"/></td>
					<td  id="eg_subcontentbg" class="<%=borderfortd%>" height="30">:</td>
					<td height="30" id="eg_subcontentbg" class="<%=borderfortd%>" style="padding-left:12px"><input type="password" name="encon" value="<%=stringVal%>" class="list"></td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
				</tr>
<%
			}
			else if (capsStringVar.indexOf("AUTHPASS")>-1)
			{
				String val=stringVal;
				if(conPwd!=null && conPwd.length()>0 )
					val=conPwd;
				auditLogHashtable.put(capsStringVar,stringVar+":"+stringVal);
%>
				<tr>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">
						<egui:intnl text='<%="admin.test."+capsStringVar%>'/>
					</td>
					<!-- <%=capsStringVar%> -->
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">:</td>
					<td height="30"  id="eg_subcontentbg" class="<%=borderfortd%>" style="padding-left:12px"><input type="password" name="<%=stringVar%>" value="<%=stringVal%>" class="list"></td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" >&nbsp;</td>
				</tr>
				<!--Coding for confirm password field-->
				<!--Password-->
				<tr>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">
						<egui:intnl text="admin.test.CONFIRM PASSWORD"/>
					</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">:</td>
					<td height="30" id="eg_subcontentbg" class="<%=borderfortd%>" style="padding-left:12px"><input type="password" name="aucon" value="<%=val%>" class="list"></td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
				</tr>
<%
			}
			else if (capsStringVar.equalsIgnoreCase("admin_password"))
			{
				auditLogHashtable.put(capsStringVar,stringVar+":"+stringVal);
%>
				<!--Password-->
				<tr>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
					<td  id="eg_subcontentbg" class="<%=borderfortd%>">
						<egui:intnl text='<%="admin.test."+capsStringVar%>'/>
					</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">:</td>
					<td height="30" id="eg_subcontentbg" class="<%=borderfortd%>" style="padding-left:12px">
<%
				if (multiUserMode)
				{
%>
						<input type="password" name="<%=stringVar%>" value="<%=stringVal%>" class="list" onblur="javascript:checkHashTildeHash()">
<%
				}
				else
				{
%>
						<input type="password" name="<%=stringVar%>" value="<%=stringVal%>" class="list">
<%
				}
%>
					</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" >&nbsp</td>
				</tr>
				<!--Confirm Password-->
				<tr>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
					<td  id="eg_subcontentbg" class="<%=borderfortd%>" >
						<egui:intnl text="admin.test.CONFIRM PASSWORD"/>
					</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">:</td>
					<td height="30" id="eg_subcontentbg" class="<%=borderfortd%>" style="padding-left:12px"><input type="password" name="Admincpwd" value="<%=stringVal%>" class="list"></td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
				</tr>
<%
			}
			else if (capsStringVar.indexOf("PASSWORD") > -1)
			{
				auditLogHashtable.put(capsStringVar,stringVar+":"+stringVal);
%>
				<!--Password-->
				<tr>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">
						<egui:intnl text='<%="admin.test."+capsStringVar%>'/>
					</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">:</td>
					<td height="30" id="eg_subcontentbg" class="<%=borderfortd%>" style="padding-left:12px">
<%
				if (multiUserMode && stringVar.equalsIgnoreCase("password"))
				{
%>
						<input type="password" name="<%=stringVar%>" value="<%=stringVal%>" class="list" onblur="javascript:checkHashTildeHash()">
<%
				}
				else
				{
					if (stringVar.equalsIgnoreCase("Esx_password"))
					{
						if (esxPassword != null && esxPassword.length() > 0)
						{
							stringVal = esxPassword;
						}
					}
%>
						<input type="password" name="<%=stringVar%>" value="<%=stringVal%>" class="list">
<%
				}
%>
					</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" >&nbsp</td>
				</tr>
				<!--Confirm Password-->
				<tr>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
					<td  id="eg_subcontentbg" class="<%=borderfortd%>" >
						<egui:intnl text="admin.test.CONFIRM PASSWORD"/>
					</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">:</td>
					<td height="30" id="eg_subcontentbg" class="<%=borderfortd%>" style="padding-left:12px"><input type="password" name="cpwd" value="<%=stringVal%>" class="list"></td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
				</tr>
<%
			}
			else if(stringVal.equals("noteditable"))
			{
%>
				<input type="hidden" name="<%=stringVar%>" value="<%=stringVal%>" />
				<input type="hidden" name="showAll" value='<%=session.getAttribute("show")%>'/>
<%
			}
			else if (stringVar.equals("ssl")
				|| stringVar.equals("recursive")
				|| stringVar.equals("isPassive")
				|| stringVar.equals("showServerName")
				|| stringVar.equalsIgnoreCase("encryptPass")
				|| stringVar.equals("isCitrix")
				|| stringVar.equals("onlyUp")
				|| stringVar.equals("fullduplex")
				|| stringVar.equals("includepath")
				|| stringVar.equalsIgnoreCase("encryptFlag")
				|| stringVar.equalsIgnoreCase("ddforinformation")
				|| stringVar.equalsIgnoreCase("ddforwarning")
				|| stringVar.equalsIgnoreCase("ddforsuccess")
				|| stringVar.equalsIgnoreCase("autoDiscovery")
				|| stringVar.equalsIgnoreCase("Report_By_User")
				|| stringVar.equalsIgnoreCase("Report_Powered_Os")
				|| stringVar.equalsIgnoreCase("Report_Powered_On")
				|| stringVar.equalsIgnoreCase("IsVdiServer")
				|| stringVar.equalsIgnoreCase("usewmi")
				|| stringVar.equalsIgnoreCase("restart")
				|| stringVar.equalsIgnoreCase("showFinishedDD")
				|| stringVar.equalsIgnoreCase("useSudo")
				|| stringVar.equalsIgnoreCase("list_all_pools")
				|| stringVar.equalsIgnoreCase("Report_Cluster_ResourcePools")
				|| stringVar.equalsIgnoreCase("Show_information_DD")
				|| stringVar.equalsIgnoreCase("useWarFile")
				|| stringVar.equalsIgnoreCase("rereadLicense")
				|| stringVar.equalsIgnoreCase("Aggregate_user_sessions")
				|| stringVar.equalsIgnoreCase("ignore_winNT")
				|| stringVar.equalsIgnoreCase("discoverByState")
				|| stringVar.equalsIgnoreCase("useAlias")
				|| stringVar.equalsIgnoreCase("useexe")
				|| stringVar.equalsIgnoreCase("Is_XenFarm_server")
				|| stringVar.equalsIgnoreCase("Report_by_groupname")
				|| stringVar.equalsIgnoreCase("Only_PoweredOn_VMs")
				|| stringVar.equalsIgnoreCase("wide"))
			{
				if (request.getParameter(stringVar) != null && !(request.getParameter(stringVar).equals("")))
				{
					stringVal = request.getParameter(stringVar);
				}

				String enablessl = "";
				String disablessl = "";
				if(stringVal.equalsIgnoreCase("false") || stringVal.equalsIgnoreCase("no") || encryptFlag.equalsIgnoreCase("no"))
				{
					disablessl = "checked";
					enablessl = "";
				}
				else
				{
					enablessl = "checked";
					disablessl = "";
				}
				if(encryptFlag.equalsIgnoreCase("yes"))
				{
					enablessl = "checked";
					disablessl = "";
				}

				if(enablessl !=null && enablessl.equalsIgnoreCase("checked"))
					auditLogHashtable.put(capsStringVar,stringVar+":true");

				if(disablessl !=null && disablessl.equalsIgnoreCase("checked"))
					auditLogHashtable.put(capsStringVar,stringVar+":false");

				if (stringVar.equalsIgnoreCase("ssl"))
				{
					if (isSSlForEsx != null && isSSlForEsx.length()>0)
					{
						if (isSSlForEsx.equalsIgnoreCase("true") || 
							isSSlForEsx.equalsIgnoreCase("yes"))
						{
							enablessl = "checked";
							disablessl = "";
						}
						else if(isSSlForEsx.equalsIgnoreCase("false") || 
							isSSlForEsx.equalsIgnoreCase("no"))
						{
							disablessl = "checked";
							enablessl = "";
						}
					}
				}
%>
<!--Passive-->
				<tr>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">
					<egui:intnl text='<%="admin.test."+capsStringVar%>'/>
					</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">:</td>
					<td height="30" width="50%" id="eg_subcontentbg" class="<%=borderfortd%>" style="padding-left:12px"><input id="eg_input" type="radio" name="<%=stringVar%>" value="true" class="list" <%=enablessl%> onClick="javaScript:encryptFlagChange('yes','<%=snmpVersion%>','<%=stringVar%>')"><egui:intnl text="admin.common.YES"/>&nbsp;&nbsp;<input id="eg_input" type="radio" name="<%=stringVar%>" value="false" class="list" <%=disablessl%> onClick="javaScript:encryptFlagChange('no','<%=snmpVersion%>','<%=stringVar%>')"><egui:intnl text="admin.common.NO"/></td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
				</tr>
<%
			}
			else if(stringVar.equalsIgnoreCase("policyFilter"))
			{
				String enablessl = "";
				String disablessl = "";
				String policyFlag = request.getParameter("policyFlag") !=null?request.getParameter("policyFlag"):stringVal;
				policyFilterValue = policyFlag;
				if(policyFlag.equalsIgnoreCase("true"))
				{
					disablessl ="";
					enablessl ="checked";
				}
				else
				{
					disablessl = "checked";
					enablessl = "";
				}
				query = EgURLDecoder.decode(query,"UTF-8");
%>
				<tr>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">
					<egui:intnl text='<%="admin.test."+capsStringVar%>'/>
					</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">:</td>
					<td height="30" width="50%" id="eg_subcontentbg" class="<%=borderfortd%>" style="padding-left:12px"><input type="radio" id="eg_input" name="<%=stringVar%>" value="true" class="list" <%=enablessl%> onClick="javaScript:PolicyFilterEnabled('true','<%=query%>')"><egui:intnl text="admin.common.Yes"/>&nbsp; &nbsp; &nbsp; <input type="radio" id="eg_input" name="<%=stringVar%>" value="false" class="list" <%=disablessl%> onClick="javaScript:PolicyFilterEnabled('false','<%=query%>')">&nbsp; <egui:intnl text="admin.common.No"/></td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
				</tr>
<%
			}
			else if(stringVar.equalsIgnoreCase("mode")) //By Anand - Start
			{
				if (testName.equalsIgnoreCase("OraTablespacesTest"))
				{
					String readOnlySelected = "";
					String rwSelected = "";
					String allSelected = "";
					if (stringVal.equalsIgnoreCase("ReadOnly"))
					{
						readOnlySelected = "selected";
					}
					else if (stringVal.equalsIgnoreCase("Read/Write"))
					{
						rwSelected = "selected";
					}
					else if (stringVal.equalsIgnoreCase("All"))
					{
						allSelected = "selected";
					}
%>
				<tr>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">
					<egui:intnl text='<%="admin.test."+capsStringVar%>'/>
					</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">:</td>
					<td height="30" id="eg_subcontentbg" class="<%=borderfortd%>" width="50%" style="padding-left:12px">
						<select name='<%=stringVar%>'>
						<option value="All" <%=allSelected%>><egui:intnl text="admin.test.All"/></option>
						<option value="ReadOnly" <%=readOnlySelected%>><egui:intnl text="admin.test.ReadOnly"/></option>
						<option value="Read/Write" <%=rwSelected%>><egui:intnl text="admin.test.Read/Write"/></option>
						</select>
					</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
				</tr>
<%
				}
				else
				{
					String snmpSelected = "";
					String jmxSelected = "";
					String modeTempVal = new String(stringVal);
					String requestModeValue = request.getParameter("mode");
					requestModeValue = (requestModeValue==null)?"":requestModeValue;
					if (!requestModeValue.equals("")) modeTempVal = requestModeValue;
					if (modeTempVal.equalsIgnoreCase("true"))
					{
						snmpSelected = "checked";
					}
					else
					{
						jmxSelected = "checked";
					}
					query = EgURLDecoder.decode(query,"UTF-8");
%>
				<tr>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">
					<egui:intnl text='<%="admin.test."+capsStringVar%>'/>
					</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">:</td>
					<td height="30" id="eg_subcontentbg" class="<%=borderfortd%>" width="50%" style="padding-left:12px"><input type="radio" id="eg_input" name="<%=stringVar%>" value="true" <%=snmpSelected%> class="list" onclick="javascript:checkMode(this.value,'<%=query%>')"><egui:intnl text="admin.common.SNMP"/>&nbsp;&nbsp;<input type="radio" id="eg_input" name="<%=stringVar%>" value="false" <%=jmxSelected%> class="list"onclick="javascript:checkMode(this.value,'<%=query%>')"><egui:intnl text="admin.common.JMX"/></td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
				</tr>
<%
				}
			} //By Anand - End
			else if (stringVar.equalsIgnoreCase("Profiler"))
			{
				String profilerOn = "";
				String profilerOff = "";
				if (stringVal.equalsIgnoreCase("true"))
				{
					profilerOn = "checked";
				}
				else if(stringVal.equalsIgnoreCase("false"))
				{
					profilerOff = "checked";
				}
%>
				<tr>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">
					<egui:intnl text='<%="admin.test."+capsStringVar%>'/>
					</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">:</td>
					<td height="30" id="eg_subcontentbg" class="<%=borderfortd%>" width="50%" style="padding-left:12px"><input type="radio" class="eg_input" name="<%=stringVar%>" value="true" <%=profilerOn%>><egui:intnl text="admin.common.On"/>&nbsp;&nbsp;<input type="radio" class="eg_input" name="<%=stringVar%>" value="false" <%=profilerOff%>><egui:intnl text="admin.common.Off"/></td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
				</tr>
<%
			}
			else if (stringVar.equalsIgnoreCase("Heap_Analysis"))
			{
				String heapOn = "";
				String heapOff = "";
				String heapValue = request.getParameter("javahome");
				heapValue = heapValue!=null?heapValue:"";
				if (heapValue.equals(""))
				{
					if (stringVal.equalsIgnoreCase("true"))
					{
						heapOn = "checked";
					}
					else if(stringVal.equalsIgnoreCase("false"))
					{
						heapOff = "checked";
					}
				}
				else
				{
					if (heapValue.equalsIgnoreCase("true"))
					{
						heapOn = "checked";
					}
					else
					{
						heapOff = "checked";
					}
				}
%>
				<tr>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">
					<egui:intnl text='<%="admin.test."+capsStringVar%>'/>
					</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">:</td>
					<td height="30" id="eg_subcontentbg" class="<%=borderfortd%>" width="50%" style="padding-left:12px"><input type="radio" class="eg_input" name="<%=stringVar%>" value="true" <%=heapOn%> onclick="javascript:checkHeap(this.value,'<%=query%>')"><egui:intnl text="admin.common.On"/>&nbsp;&nbsp;<input type="radio" class="eg_input" name="<%=stringVar%>" value="false" <%=heapOff%> onclick="javascript:checkHeap(this.value,'<%=query%>')"><egui:intnl text="admin.common.Off"/></td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
				</tr>
<%
			}
			else if(stringVar.equals("targets") 
				|| stringVar.equals("content") 
				|| stringVar.equals("credentials"))
			{
				if(stringVal.indexOf("!") > -1)
				{
					if(stringVar.equals("content"))
						stringVal = stringVal.replace('!',' ');
					//else
					//	stringVal = stringVal.replace('!','&');
				}
				if(stringVal.indexOf("|") > -1)
				{
					stringVal = stringVal.replace('|',',');
				}
%>
				<tr>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">
						<egui:intnl text='<%="admin.test."+stringVar.toLowerCase()%>'/>
					</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">:</td>
<%
				if(stringVar.equals("content") || stringVar.equals("credentials"))
				{
					auditLogHashtable.put(stringVar.toLowerCase(),stringVar+":"+stringVal);
%>
					<td height="30" width="50%" id="eg_subcontentbg" class="<%=borderfortd%>" style="padding-left:12px"><textarea name="<%=stringVar%>" rows="5" cols="35" class="list"><%=stringVal.trim()%></textarea></td>
<%
				}
				else
				{
					auditLogHashtable.put(stringVar.toLowerCase(),stringVar+":"+stringVal);
%>
					<td height="30" width="50%" id="eg_subcontentbg" class="<%=borderfortd%>" style="padding-left:12px"><input type="text" name="<%=stringVar%>" value="<%=stringVal.trim()%>" class="list"></td>
<%
				}
%>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp;</td>
				</tr>
<%
			}
			else if (stringVar.equals("agentless"))
			{
%>
				<input type="hidden" name="<%=stringVar%>" value="n" />
<%
			}
			else
			{
				if(combo)
				{
					if(stringVar.equalsIgnoreCase("snmpversion"))
					{
						group=versions;
					}
					if(stringVar.equalsIgnoreCase("authtype"))
					{
						group=authTypes;
					}
					if(stringVar.equalsIgnoreCase("encrypttype"))
					{
						group=encryptTypes;
						selection=stringVal;
					}
					String select="";
%>
				<tr>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" >&nbsp</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30" >
						<egui:intnl text='<%="admin.test."+stringVar.toUpperCase()%>'/>
					</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30" >:</td>
					<td height="30" id="eg_subcontentbg" class="<%=borderfortd%>" align="left" style="padding-left:12px" ><select name="<%=stringVar%>" id="<%=stringVar%>" class="list" onChange='javaScript:comboChange("<%=stringVar%>")'>
<%
					for(int i=0;i<group.length;i++)
					{
						if(group[i].equalsIgnoreCase(selection))
						{
							auditLogHashtable.put(stringVar.toUpperCase(),stringVar+":"+group[i]);
							select="selected";
						}
%>
							<option value="<%=group[i]%>" <%=select%>><%=group[i]%></option>
<%
						select="";
					}
%>
						</select>
					</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
				</tr>
<%
				}
				else
				{
					boolean border=true;
					auditLogHashtable.put(stringVar.toUpperCase(),stringVar+":"+stringVal);
					if (!stringVar.equalsIgnoreCase("isCluster") && !stringVar.equalsIgnoreCase("isExternal") && !stringVar.equalsIgnoreCase("info"))
					{
%>
				<!--User -->
				<tr>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp;</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">
						<egui:intnl text='<%="admin.test."+stringVar.toUpperCase()%>'/>
					</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">:</td>
					<td height="30" id="eg_subcontentbg" class="<%=borderfortd%>" style="padding-left:12px">
<%
						if(stringVar.equalsIgnoreCase("aggregateDescriptor"))
						{
							String enablessl = "";
							String disablessl = "";
							if(stringVal.equalsIgnoreCase("false") || stringVal.equalsIgnoreCase("no") || encryptFlag.equalsIgnoreCase("no"))
							{
								disablessl = "checked";
								enablessl = "";
							}
							else
							{
								enablessl = "checked";
								disablessl = "";
							}
%>
						<input type="radio" class="eg_input"name="<%=stringVar%>" value="true" <%=enablessl%>>&nbsp;<egui:intnl text="admin.common.Yes"/>&nbsp;&nbsp;<input type="radio" class="eg_input"name="<%=stringVar%>" value="false" class="list" <%=disablessl%>>&nbsp;<egui:intnl text="admin.common.No"/>
<%
						}
						else
						{
							if (stringVar.equalsIgnoreCase("Inside_view_using"))
							{
								String exeSelected = "";
								String tcpSelected = "";
								if (stringVal.equals("exe"))
								{
									exeSelected = "selected";
								}
								else if(stringVal.equals("tcp"))
								{
									tcpSelected = "selected";
								}
%>
						<select name='<%=stringVar%>' onchange="javascript:InsideViewChange(this.value);">
						<option value="exe" <%=exeSelected%>><egui:intnl text="admin.test.Netbios (Windows)"/></option>
						<option value="tcp" <%=tcpSelected%>><egui:intnl text="admin.test.TCP/WMI (Windows)"/></option>
						</select>
<%
							}
							else if(stringVar.equalsIgnoreCase("Using"))
							{
								String exeSelected = "";
								String apiSelected = "";
								if (stringVal.equals("exe"))
								{
									exeSelected = "selected";
								}
								else if(stringVal.equals("api"))
								{
									apiSelected = "selected";
								}
%>
						<select name='<%=stringVar%>'>
						<option value="api" <%=apiSelected%>><egui:intnl text="admin.test.Web services API"/></option>
						<option value="exe" <%=exeSelected%>><egui:intnl text="admin.test.Command Line Interface"/></option>
						</select>
<%
							}
							else if (testName.equals("RadiusServiceTest") && stringVar.equalsIgnoreCase("AuthType"))
							{
								String chapSelected = "";
								String papSelected = "";
								if (stringVal.equals("chap"))
								{
									chapSelected = "selected";
								}
								else
								{
									papSelected = "selected";
								}
%>
						<select name='<%=stringVar%>'>
						<option value="chap" <%=chapSelected%>>CHAP</option>
						<option value="pap" <%=papSelected%>>PAP</option>
						</select>
<%
							}
							else if (stringVar.equalsIgnoreCase("report_by_file_system"))
							{
								String remoteSelected = "";
								String localSelected = "";
								String bothSelected = "";
								if (stringVal.equals("remote"))
								{
									remoteSelected = "selected";
								}
								else if (stringVal.equals("local"))
								{
									localSelected = "selected";
								}
								else
								{
									bothSelected = "selected";
								}
%>
						<select name='<%=stringVar%>'>
						<option value="remote" <%=remoteSelected%>>Remote Filesystem</option>
						<option value="local" <%=localSelected%>>Local Filesystem</option>
						<option value="both" <%=bothSelected%>>Both</option>
						</select>
<%
							}
							else if (multiUserMode && stringVar.equalsIgnoreCase("domain"))
							{
%>
						<input type="text" name="<%=stringVar%>" value="<%=stringVal%>" class="list" onblur="javascript:checkMultipleUser('<%=stringVar%>','<%=stringVal%>')" onfocus="javascript:getUserValue('<%=stringVar%>')" onchange="javascript:getUserChangedValue('<%=stringVar%>')">
<%
							}
							else if (multiUserMode && (stringVar.equalsIgnoreCase("admin_user") || stringVar.equalsIgnoreCase("user")))
							{
%>
						<table border="0" cellspacing="0" cellpadding="0">
							<tr>
								<td><input type="text" name="<%=stringVar%>" value="<%=stringVal%>" class="list" onblur="javascript:checkMultipleUser('<%=stringVar%>','<%=stringVal%>')" onfocus="javascript:getUserValue('<%=stringVar%>')" onchange="javascript:getUserChangedValue('<%=stringVar%>')"></td>
								<td style="padding-left:4px"><%=plusButton%></td>
							</tr>
						</table>
<%
							}
							else if (stringVar.equalsIgnoreCase("virtual_center"))
							{
								String selectedVc = tempSelectedVc!=null?tempSelectedVc:stringVal;
%>
								<select name="virtual_center" id="virtual_center" onChange="javascript:vc_onChange('<%=query%>')" style="width:150px;">
								<option value='None'><egui:intnl text="admin.test.None"/></option>
<%
								if (tmapVc != null && !tmapVc.isEmpty())
								{
									Iterator itrVc = tmapVc.keySet().iterator();
									while (itrVc.hasNext())
									{
										String tempVc = (String)itrVc.next();
%>
								<option value="<%=tempVc%>" <%=tempVc.equals(selectedVc)?"selected":""%>><%=tempVc%></option>
<%
									}
								}
								else
								{
									if (!selectedVc.equalsIgnoreCase("none"))
									{
%>
								<option value='<%=selectedVc%>' selected><%=selectedVc%></option>
<%
									}
								}
%>
								<option value='Other'><egui:intnl text="admin.test.Other"/></option>
								</select>
<%
							}
							else
							{
								if (stringVar.equalsIgnoreCase("Esx_user"))
								{
									if (esxUserName !=null && esxUserName.length()>0)
									{
										stringVal = esxUserName;
									}
								}
								else if (stringVar.equalsIgnoreCase("webPort"))
								{
									if (webPort !=null && webPort.length()>0)
									{
										stringVal = webPort;
									}
								}

								if (stringVar.equalsIgnoreCase("filter"))
								{
									String tempSelect = "";
									if (policyFilterValue.length() > 0)
									{
										ArrayList aListEventLogPolicies = new ArrayList(Arrays.asList(testIniFile.getVariables("EVENTLOG_POLICIES")));

										ArrayList aListTempPolicies = new ArrayList();
										for (int i=0;i<aListEventLogPolicies.size();i++)
										{
											String strTempPolicy = (String)aListEventLogPolicies.get(i);
											String tempPattern = testName + ":" + log + ":";
											if (strTempPolicy.startsWith(tempPattern))
											{
												String tempPolicy = strTempPolicy.substring(tempPattern.length());
												aListTempPolicies.add(tempPolicy);
											}
										}

										if (policyFilterValue.equalsIgnoreCase("true"))
										{
											ArrayList aListPolicy = new ArrayList();
											String select = "";
											String filterName = stringVal;
											if(filterName.indexOf(":") > -1)
											{
												if(filterName.indexOf(";") > -1)
												{
													StringTokenizer policyTokens = new StringTokenizer(filterName,";");
													while(policyTokens.hasMoreTokens())
													{
														String tempPolicy = policyTokens.nextToken();
														tempPolicy = tempPolicy.substring(0,tempPolicy.indexOf(":"));
														aListPolicy.add(tempPolicy);
													}
												}
												else
												{
													aListPolicy.add(filterName.substring(0,filterName.indexOf(":")));
												}
											}
											else if (filterName.indexOf(";") > -1)
											{
												StringTokenizer policyTokens = new StringTokenizer(filterName,";");
												while(policyTokens.hasMoreTokens())
												{
													String tempPolicy = policyTokens.nextToken();
													aListPolicy.add(tempPolicy);
												}
											}
											else
											{
												aListPolicy.add(filterName);
											}

											if (aListTempPolicies.contains("all"))
											{
												aListTempPolicies.remove("all");
												Collections.sort(aListTempPolicies,String.CASE_INSENSITIVE_ORDER);
												aListTempPolicies.add(0,"all");
											}
											else
											{
												Collections.sort(aListTempPolicies,String.CASE_INSENSITIVE_ORDER);
											}
%>
								<select name="<%=stringVar%>" size="5" width="160" style="width:160px;" multiple>
<%
											for (int j=0;j<aListTempPolicies.size();j++)
											{
												String tempPolicy = (String)aListTempPolicies.get(j);
												if(aListPolicy.contains(tempPolicy))
												{
													tempSelect = "selected";
												}
												else
												{
													tempSelect = "";
												}
%>
									<option value='<%=tempPolicy%>' <%=tempSelect%>><%=tempPolicy%></option>
<%
											}
%>
								</select>
<%
										}
										else
										{
											String tempFilterValue = "";
											if (stringVal.indexOf(":") < 0)
											{
												StringTokenizer strFilterTokens=new StringTokenizer(stringVal,";");
												while(strFilterTokens.hasMoreElements())
												{
													String tempPolicyName=strFilterTokens.nextToken();
													tempFilterValue = tempFilterValue + tempPolicyName + ":";
													String tempCheck=testName + ":" + log + ":" + tempPolicyName;
													tempFilterValue=tempFilterValue + testIniFile.getValue("EVENTLOG_POLICIES",tempCheck.trim());
													tempFilterValue = tempFilterValue +";";
												}
												tempFilterValue = tempFilterValue.substring(0,tempFilterValue.lastIndexOf(";"));
											}
											else
											{
												tempFilterValue = stringVal;
											}

											tempFilterValue = StringUtils.replace(tempFilterValue,"|",",");
											String encodedValue = EgURLEncoder.encode(tempFilterValue.trim(),"UTF-8");
%>
								<textarea name="<%=stringVar%>" rows="5" cols="35" class="list"><%=tempFilterValue.trim()%></textarea>&nbsp;
								<input type="button" class="eg_lightbutton" value='<egui:intnl text="admin.common.View"/>' onClick="javascript:openSmallWindow('<%=stringVar%>')" style="width:60px;">
<%
										}
									}
									else
									{
%>
								<input type="text" name="<%=stringVar%>" value="<%=stringVal%>" class="list">
<%
									}
								}
								else
								{
%>
								<input type="text" name="<%=stringVar%>" value="<%=stringVal%>" class="list">
<%
								}
							}
						}

						// Siva Anand - Code for configuring EG_RUNTIME
						if ((stringVar.equalsIgnoreCase("process") || stringVar.equalsIgnoreCase("serviceName")) && stringVal.equalsIgnoreCase("(EG_RUNTIME)"))
						{
%>
						&nbsp;<input type="button" name="os_pattern" value='<egui:intnl text="admin.common.Configure"/>' class="eg_lightbutton" onclick="javascript:configureOSPattern('<%=serverName%>','<%=testName%>','<%=stringVar%>');" style="width:70px">
<%
						}
%>
					</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp;</td>
				</tr>
<%
					}
					else
					{
%>
				<input type="hidden" name="<%=stringVar%>" value="<%=stringVal%>" class="list">
<%
					}
				}
			}
		}
		else
		{
			/*
			 * Will come here if stringVal contains a # or a | in it. These characters should
			 * be replaced with commas (,).
			 *
			 * eg_specs.ini defines separators in TEST_INFO_DELIMITER. If stringVar matches
			 * the value for TEST_INFO_PATTERN, use the separator defined for the test in 
			 * TEST_INFO_DELIMITER. Otherwise, replace | with a comma.
			 *
			 */
			String strReplace = "";
			if (testInfoDelimiter.length() > 0 && stringVar.equals(testInfoPattern) && stringVal.indexOf(testInfoDelimiter) > -1)
			{
				strReplace = StringUtils.replace(stringVal, testInfoDelimiter, EgConstants.COMMA);
			}
			else if (stringVal.indexOf(EgConstants.PIPE) > -1)
			{
				strReplace = StringUtils.replace(stringVal, EgConstants.PIPE, EgConstants.COMMA);
			}
			else
			{
				strReplace = stringVal;
			}
			//---Replaced by the block above
			//			if(stringVal.indexOf("#") > -1)
			//			{
			//				strReplace = stringVal.replace('#', ',');
			//			}
			//			else if(stringVal.indexOf("|") > -1)
			//			{
			//				strReplace = stringVal.replace('|', ',');
			//			}

			String readOnly = "";
			String plusButton = "";
			if (listMultipleUserSupportTest != null && listMultipleUserSupportTest.contains(testName))
			{
				if (((stringVar.equalsIgnoreCase("domain") || stringVar.equalsIgnoreCase("admin_user")) && strReplace.indexOf(",")>-1) || 
					(stringVar.equalsIgnoreCase("admin_password") && stringVal.indexOf("#~#")>-1))
				{
					readOnly = "readOnly";
				}

				if (multiUserMode && stringVar.equalsIgnoreCase("admin_user"))
				{
					plusButton = "<img src=\"/final/admin/eg_images/plus.gif\" title=\"Click here to configure user(s)\" class=\"leftmouse\" onClick=\"config_popup(\'./VmgUsers.jsp?server="+typeOfServer+"&test="+testName+"&port="+checkforport+"&compname=&showAll="+request.getParameter("showAll")+"&logtype=\',\'\',\'width=900,height=380,top=150,left=50\')\">";
				}
			}

			if (testName.equalsIgnoreCase("CtxAuthTest") || 
				testName.equalsIgnoreCase("WinAuthTest") || 
				testName.equalsIgnoreCase("TermAuthTest"))
			{
				if (((stringVar.equalsIgnoreCase("domain") || stringVar.equalsIgnoreCase("user")) && strReplace.indexOf(",")>-1) || 
					(stringVar.equalsIgnoreCase("password") && stringVal.indexOf("#~#")>-1))
				{
					readOnly = "readOnly";
				}

				if (multiUserMode && stringVar.equalsIgnoreCase("user"))
				{
					plusButton = "<img src=\"/final/admin/eg_images/plus.gif\" title=\"Click here to configure user(s)\" class=\"leftmouse\" onClick=\"config_popup(\'./EgConfigureMultipleUsers.jsp?server="+typeOfServer+"&test="+testName+"&port="+checkforport+"&compname=&showAll="+request.getParameter("showAll")+"&logtype=\',\'\',\'width=900,height=380,top=150,left=50\')\">";
				}
			}
			if(strReplace.indexOf("!") > -1)
			{
				if(stringVar.equals("content"))
					strReplace = strReplace.replace('!', ' ');
				else
				{
					//if(!stringVar.equalsIgnoreCase("searchpattern") && 
					//	!stringVar.equalsIgnoreCase("process"))
					//{
					//	strReplace = strReplace.replace('!', '&');
					//}
				}
			}
%>
				<tr>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">
						<egui:intnl text='<%="admin.test."+capsStringVar%>'/>
					</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">:</td>
					<td height="30" id="eg_subcontentbg" class="<%=borderfortd%>" style="padding-left:12px">
<%
			if (stringVar.equalsIgnoreCase("Esx_password") || 
				stringVar.equalsIgnoreCase("alpassword") || 
				stringVar.equalsIgnoreCase("sendpassword") || 
				stringVar.equalsIgnoreCase("receivepassword") || 
				stringVar.equalsIgnoreCase("proxypassword") || 
				stringVar.equalsIgnoreCase("authpass") || 
				stringVar.equalsIgnoreCase("encryptpassword") || 
				stringVar.equalsIgnoreCase("vc_password") || 
				stringVar.equalsIgnoreCase("xen_password") || 
				stringVar.equalsIgnoreCase("From_User_Password"))
			{
				auditLogHashtable.put(capsStringVar,stringVar+":"+stringVal);

				if (stringVar.equalsIgnoreCase("Esx_password"))
				{
					if (esxPassword != null && esxPassword.length() > 0)
					{
						stringVal = esxPassword;
					}
				}
%>
						<input type="password" name="<%=stringVar%>" value="<%=stringVal%>" class="list"/>
<%
			}
			else if (stringVar.equalsIgnoreCase("password"))
			{
				auditLogHashtable.put(capsStringVar,stringVar+":"+stringVal);

				if (testName.equalsIgnoreCase("CtxAuthTest") || 
					testName.equalsIgnoreCase("WinAuthTest") || 
					testName.equalsIgnoreCase("TermAuthTest"))
				{
%>
						<input type="password" name="<%=stringVar%>" value="<%=stringVal%>" class="list" <%=readOnly%> onblur="javascript:checkHashTildeHash()"/>
<%
				}
				else
				{
%>
						<input type="password" name="<%=stringVar%>" value="<%=stringVal%>" class="list"/>
<%
				}
			}
			else if (stringVar.equalsIgnoreCase("admin_password"))
			{
				auditLogHashtable.put(capsStringVar,stringVar+":"+stringVal);
				if (multiUserMode)
				{
%>
						<input type="password" name="<%=stringVar%>" value="<%=stringVal%>" class="list" <%=readOnly%> onblur="javascript:checkHashTildeHash()"/>
<%
				}
				else
				{
%>
						<input type="password" name="<%=stringVar%>" value="<%=stringVal%>" class="list"/>
<%
				}
			}
			else
			{
				auditLogHashtable.put(capsStringVar,stringVar+":"+strReplace.trim());

				if (plusButton != null && plusButton.equals(""))
				{
					if (stringVar.equalsIgnoreCase("domain"))
					{
						if (listMultipleUserSupportTest != null && 
							listMultipleUserSupportTest.contains(testName))
						{
%>
						<textarea name="<%=stringVar%>" rows="5" cols="35" class="list" <%=readOnly%> onblur="javascript:checkMultipleUser('<%=stringVar%>','<%=strReplace%>')" onfocus="javascript:getUserValue('<%=stringVar%>')" onchange="javascript:getUserChangedValue('<%=stringVar%>')"><%=strReplace.trim()%></textarea>
<%
						}
						else if (testName.equalsIgnoreCase("CtxAuthTest") || 
								testName.equalsIgnoreCase("WinAuthTest") || 
								testName.equalsIgnoreCase("TermAuthTest"))
						{
%>
						<textarea name="<%=stringVar%>" rows="5" cols="35" class="list" <%=readOnly%> onblur="javascript:checkMultipleUser('<%=stringVar%>','<%=strReplace%>')" onfocus="javascript:getUserValue('<%=stringVar%>')" onchange="javascript:getUserChangedValue('<%=stringVar%>')"><%=strReplace.trim()%></textarea>
<%
						}
						else
						{
%>
						<textarea name="<%=stringVar%>" rows="5" cols="35" class="list"><%=strReplace.trim()%></textarea>
<%
						}
					}
					else
					{
%>
						<textarea name="<%=stringVar%>" rows="5" cols="35" class="list"><%=strReplace.trim()%></textarea>
<%
					}
				}
				else
				{
					if (stringVar.equals("admin_user") || stringVar.equals("user"))
					{
%>
						<table border="0" cellspacing="0" cellpadding="0">
							<tr>
								<td> <textarea name="<%=stringVar%>" rows="5" cols="35" class="list" <%=readOnly%> onblur="javascript:checkMultipleUser('<%=stringVar%>','<%=strReplace%>')" onfocus="javascript:getUserValue('<%=stringVar%>')" onchange="javascript:getUserChangedValue('<%=stringVar%>')"><%=strReplace.trim()%></textarea></td>
								<td valign="top" style="padding-left:4px"><%=plusButton%></td>
							</tr>
						</table>
<%
					}
					else
					{
%>
						<textarea name="<%=stringVar%>" rows="5" cols="35" class="list"><%=strReplace.trim()%></textarea>
<%
					}
				}
			}
%>
					</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
				</tr>

<%
			if (stringVar.equalsIgnoreCase("Esx_password") || 
				stringVar.equalsIgnoreCase("alpassword") || 
				stringVar.equalsIgnoreCase("sendpassword") || 
				stringVar.equalsIgnoreCase("receivepassword") || 
				stringVar.equalsIgnoreCase("proxypassword") || 
				stringVar.equalsIgnoreCase("vc_password") || 
				stringVar.equalsIgnoreCase("xen_password") || 
				stringVar.equalsIgnoreCase("From_User_Password"))
			{
				auditLogHashtable.put("Confirm Password",stringVar+":"+stringVal);

				if (stringVar.equalsIgnoreCase("Esx_password"))
				{
					if (esxPassword != null && esxPassword.length() > 0)
					{
						stringVal = esxPassword;
					}
				}
%>
				<tr>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">
					<egui:intnl text="admin.test.CONFIRM PASSWORD"/>
					</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">:</td>
					<td height="30" id="eg_subcontentbg" class="<%=borderfortd%>" style="padding-left:12px"><input type="password" name="cpwd" value="<%=stringVal%>" class="list" />
					</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
				</tr>
<%
			}
			else if (stringVar.equalsIgnoreCase("password")  && !readOnly.equals("readOnly"))
			{
				auditLogHashtable.put(capsStringVar,stringVar+":"+stringVal);
%>
				<tr>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">
						<egui:intnl text="admin.test.CONFIRM PASSWORD"/>
					</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">:</td>
					<td height="30" id="eg_subcontentbg" class="<%=borderfortd%>" style="padding-left:12px"><input type="password" name="cpwd" value="<%=stringVal%>" class="list"></td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
				</tr>
<%
			}
			else if (stringVar.equalsIgnoreCase("admin_password") && !readOnly.equals("readOnly"))
			{
				auditLogHashtable.put(capsStringVar,stringVar+":"+stringVal);
%>
				<tr>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">
						<egui:intnl text="admin.test.CONFIRM PASSWORD"/>
					</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">:</td>
					<td height="30" id="eg_subcontentbg" class="<%=borderfortd%>" style="padding-left:12px"><input type="password" name="Admincpwd" value="<%=stringVal%>" class="list"></td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
				</tr>
<%
			}
			else if (stringVar.equalsIgnoreCase("authpass"))
			{
				String val=stringVal;
				if(conPwd!=null && conPwd.length()>0 )
					val=conPwd;
				auditLogHashtable.put(capsStringVar,stringVar+":"+stringVal);
%>
				<tr>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">
						<egui:intnl text="admin.test.CONFIRM PASSWORD"/>
					</td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>" height="30">:</td>
					<td height="30" id="eg_subcontentbg" class="<%=borderfortd%>" style="padding-left:12px"><input type="password" name="aucon" value="<%=val%>" class="list"></td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
				</tr>
<%
			}
			else if (stringVar.equalsIgnoreCase("encryptpassword"))
			{
				auditLogHashtable.put(capsStringVar,stringVar+":"+stringVal);
%>
				<tr>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
					<td  id="eg_subcontentbg" class="<%=borderfortd%>">
					<egui:intnl text="admin.test.CONFIRM PASSWORD"/></td>
					<td  id="eg_subcontentbg" class="<%=borderfortd%>" height="30">:</td>
					<td height="30" id="eg_subcontentbg" class="<%=borderfortd%>" style="padding-left:12px"><input type="password" name="encon" value="<%=stringVal%>" class="list"></td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
				</tr>
<%
			}
		}
		if(comm_show && stringVar.equalsIgnoreCase("snmpcommunity"))
		{
			others_show=true;
		}
	}
%>
			<!--NEW CODE FOR DETAILED DIAGNOSIS SETTER ON /OFF STARTS-->
<%
		/************************************************************************************
		 *	CODE FOR DISABLE DD WRITES INTO eg_testinfo.ini  ---Gopi(Option setting for DD) *
		 ************************************************************************************/
		//Initial check for DD frequency from eg_tests.ini [FREQUENCY_MAPPING] if normal and bad = 0 no dd option

	boolean b_DDOption = true ;
	prgBean.createFile("eg_tests.ini");
	String s_freqVars [] = prgBean.getVariables("FREQUENCY_MAPPING");
	for(int i=0; i<s_freqVars.length; i+=2)
	{
		String normal = s_freqVars[i];
		String bad = s_freqVars[i+1];

		if (prgBean.getStrValue("FREQUENCY_MAPPING", normal).equalsIgnoreCase("0") 
			&& prgBean.getStrValue("FREQUENCY_MAPPING", bad).equalsIgnoreCase("0"))
		{
			b_DDOption = false ;
		}
	}

	if(b_DDOption)
	{
		prgBean.createFile("eg_format.ini");

		String[] s_ddVars = prgBean.getVariables("FORMAT");
		Vector v_ddtest = new Vector();

		for(int i=0;i<s_ddVars.length ;i++)
		{
			String s_ddtest = s_ddVars[i].substring(0,s_ddVars[i].indexOf(":"));
			if(!v_ddtest.contains(s_ddtest))
				v_ddtest.addElement(s_ddtest);
		}

		Vector v_disableDD = new Vector();
		if(testName != null && v_ddtest.contains(testName))
		{
			prgBean.createFile("eg_testinfo.ini");
			String s_disable_vars[] = prgBean.getVariables("Disable_DD");
			for(int i=0;i<s_disable_vars.length;i++)
			{
				if(!v_disableDD.contains(s_disable_vars[i]))
					v_disableDD.addElement(s_disable_vars[i]);
			}

			String  ddon = null,
			ddoff = null;
			if(v_disableDD.contains(testName))
			{
				ddoff = "checked";
				ddon = "";
				ddval=ddoff;
				auditLogHashtable.put("Detailed Diagnosis","detaileddiagnosis"+":"+"Off");
			}
			else
			{
				ddon = "checked";
				ddoff = "";
				ddval=ddon;
				auditLogHashtable.put("Detailed Diagnosis","detaileddiagnosis"+":"+"On");
			}
%>
				<tr>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
					<td  id="eg_subcontentbg" class="<%=borderfortd%>" height="30">
					<egui:intnl text="admin.test.DETAILED DIAGNOSIS"/></td>
					<td  id="eg_subcontentbg" class="<%=borderfortd%>" height="30">:</td>
					<td height="30" id="eg_subcontentbg" class="<%=borderfortd%>" style="padding-left:12px"><input id="eg_input" type="radio" name="detaileddiagnosis" value="On" <%=ddon%>><egui:intnl text="admin.common.ON"/>&nbsp;&nbsp;<input id="eg_input" type="radio" name="detaileddiagnosis" value="Off" <%=ddoff%>><egui:intnl text="admin.common.OFF"/></td>
					<td id="eg_subcontentbg" class="<%=borderfortd%>">&nbsp</td>
				</tr>
<%
			if(ddval.trim().equals("checked"))
			{
				ddval="On";
			}
			else
			{
				ddval="Off";
			}

			ht_prevValue.put("Detailed Diagnosis",ddval);
			vecThrow.addElement("detaileddiagnosis");
			vecThrow.addElement("-detaileddiagnosis");
			vecThrow.addElement(request.getParameter("detaileddiagnosis"));
		}
	}//b_DDOption check if

	testName = request.getParameter("t_name");
	session.setAttribute("tName",testName);
	session.setAttribute("vec_Return",vecThrow);
	session.setAttribute("serverSess",serverName);
	session.setAttribute("ht_prevValue",ht_prevValue);
	session.setAttribute("auditLogHashtable",auditLogHashtable);
%>
		<!--NEW CODE FOR DETAILED DIAGNOSIS SETTER ON /OFF ENDS-->
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
				<tr>
					<td colspan="5" height="10"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="10" border="0"></td>
				</tr>
				<tr>
					<td height="25" align="center" colspan="5" class="eg_subcontent">
						<input type="hidden" name="allowedParams" value="<%=allowedParams%>">
						<input type="hidden" name="tcKeywords" value="<%=strTcKeywords%>">
						<input type="button" name="updateImg" value='<egui:intnl text="admin.common.Update"/>' style="width: 85px;height: 20px;" class="eg_back" onClick="javascript:populate('<%= testName%>','<%=serverName%>','<%=multiUserMode%>')" />
					</td>
				</tr>
			</table>
		</form>
		</td>
	</tr>
</table>
<%
	session.setAttribute("adminLastAccessedURL","/final/admin/EgTestParam.jsp?"+request.getQueryString());
%>
</body>
</html>



