<%
/*********************************************************************************************************
*	Name					:	EgUnconfigTestsSummary.jsp
*	Purpose					:	Applet to display the list of unconfigured tests summary in admin home page
*	Version					:	eG 3.0
*	Creation Date			:	19/2/2004
*	Last Modified Date		:	
*
*	Author					:	Saravanan.K
********************************************************************************************************/
%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.egurkha.admin.AdminOperations" %>
<%@ page import="com.egurkha.util.StringUtils" %>
<%@ page import="com.eg.EgRoleInfo"%>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%!
	int compTypeLength = 25;
%>

<html>
<head>
<title> eG Manager 3.0 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </title>
<egui:skin ui="admin"/>
</head>

<%
	boolean isCMEnabled = EgInstallInfo.isConfigSupported;
	String value = "normalTest";
	EgRoleInfo ri=EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));//by JJ
	AdminOperations ao = new AdminOperations(ri.getAllServers());
	String[] testInfo = null;
	if(!isCMEnabled)
		testInfo = ao.getUnconfiguredTests();//ri.getUnconfiguredTests(ao.getUnconfiguredTests());
	else
		testInfo =ao.getUnconfiguredTestsSummary();
	int testsCount = ao.getTotalTests();

	/*
	if (testsCount > 0)
	{
		StringTokenizer st = new StringTokenizer(testInfo[0], ",");
		int numOfComps = st.countTokens();
		int appletheight =245;
		if (numOfComps > 7)
			appletheight = numOfComps * 30 + 20;
	}
	*/

	String[] tokens = StringUtils.getTokens(testInfo[0], EgConstants.COMMA);
	String[] tokens1 = StringUtils.getTokens(testInfo[1], EgConstants.COMMA);
	String[] countWithBoth = null;
	ArrayList countList = null;
	if(isCMEnabled)
	{
		countWithBoth = StringUtils.getTokens(testInfo[2],EgConstants.COMMA);
		countList = new ArrayList(Arrays.asList(countWithBoth));
		value = "both";
	}
	int [] countArr=null;
	int max=0;
	if(tokens1!=null)
	{
		countArr = new int[tokens1.length];
		for(int b=0;b<tokens1.length;b++)
		{
			if (tokens1[b].equals(""))
				tokens1[b]="0";
			int thisCount = Integer.parseInt(tokens1[b]);
			countArr[b] = thisCount;
			if(tokens1.length>1)
			{
				//if(b!=tokens1.length-1)
				//{
					max=Math.max(thisCount,max);
				//}
			}
			else
			{
				if (tokens1[0].equals("")) tokens1[0]="0";
					max=Integer.parseInt(tokens1[0]);
			}
		}
	}
	Arrays.sort(countArr);
%>

<body style="overflow:auto" leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" id="margin6" class="eg_whitebg">

<%
	if(testsCount>0)
	{
%>
	<table width="100%" border="0" cellpadding="0" cellspacing="0" align="center">
		<tr>
			<td COLSPAN="2" align="center"  id="eg_11" nowrap align="left"> &nbsp; <b><egui:intnl text="admin.unconfig.Total Unconfigured Tests"/> : <%=testsCount%></b></td>
		</tr>
<%
		if(isCMEnabled)
		{
%>
		<tr>
			<td COLSPAN="2" style="padding-top:2px;padding-bottom:5px">
				<table align="right" cellspacing="0" cellpadding="0" border="0">
					<tr>
						<td width="10" valign="middle"><img src="/final/admin/eg_images/<%=admin_Skin%>/run.gif" border="0" vspace="4"></td>
						<td width="90" id="eg_10" valign="top">&nbsp;<egui:intnl text="admin.dashboard.Performance"/></td>
						<td width="10" valign="middle"><img src="/final/admin/eg_images/<%=admin_Skin%>/notrun.gif" border="0" vspace="4"></td>
						<td width="90" id="eg_10" valign="top">&nbsp;<egui:intnl text="admin.dashboard.Configuration"/></td>
					</tr>
				</table>
			</td>
		</tr>
<%
		}

		int tot = 0;
		ArrayList countTokList = new ArrayList(Arrays.asList(tokens1));
		ArrayList typeTokList = new ArrayList(Arrays.asList(tokens));
		for (int a=countArr.length-1; a>=0; a--)
		{
			//int width=Integer.parseInt(countArr[a]);
			int width=countArr[a];
			int index = countTokList.indexOf(width+"");
			String thisSrvType = (String)typeTokList.get(index);
			//String dispSrvType = (thisSrvType.endsWith("_server"))?thisSrvType.substring(0, thisSrvType.lastIndexOf("_")):thisSrvType;
			String displaySrvType = _mapping.getComponentTypeDescription(thisSrvType);
%>
		<tr>
			<td width="40%" id="cell_border1">&nbsp;
<%
			if (displaySrvType.length() > compTypeLength)
			{
%>
				<a href ="/final/admin/EgUnconfigTests.jsp?serverType=<%=thisSrvType%>&source=dashboard&show=<%=value%>" STYLE="text-decoration:none" class="dash_link" target="_parent" title="<%=displaySrvType%>"><egui:display name="<%=displaySrvType%>" length='<%=compTypeLength+""%>'/></a>
<%
			}
			else
			{
%>
				<a href ="/final/admin/EgUnconfigTests.jsp?serverType=<%=thisSrvType%>&source=dashboard&show=<%=value%>" STYLE="text-decoration:none" class="dash_link" target="_parent"><%=displaySrvType%></a>
<%
			}
%>
			</td>

<%
			if(!isCMEnabled)
			{
%>
			<td>
<%
				int thisWidth=width*100/max;
%>
				<table width="<%=thisWidth%>%" border="0" cellspacing="0" cellpadding="0">
					<tr>
						<a href ="/final/admin/EgUnconfigTests.jsp?serverType=<%=thisSrvType%>&source=dashboard&show=normalTest" STYLE="text-decoration:none" id="dash_text" target="_parent">
							<span>
								<td  id="cell_bg_medium"class="mouse" width="100%" align="center" onclick="loadURL('/final/admin/EgUnconfigTests.jsp?serverType=<%=thisSrvType%>&source=dashboard&show=normalTest')" title="<%=width%> tests">
									<a href ="/final/admin/EgUnconfigTests.jsp?serverType=<%=thisSrvType%>&source=dashboard&show=normalTest" class="dash_textwhite" target="_parent" >
										<%=thisWidth>3?width+"":width+"&nbsp"%>
									</a>
								</td>
							</span>
						</a>
					</tr>
				</table>
			</td>
<%
			}
			else
			{
				String both = (String)countList.get(index);
				int idx = both.indexOf("#");
				int normalWidth = 0;
				int configWidth = 0;
				int thisWidth = 0;
				if(idx > 0)
				{
					normalWidth = Integer.parseInt(both.substring(0,idx));
					configWidth = Integer.parseInt(both.substring(idx+1));
				}
%>
			<td>
<%
				tot = normalWidth+configWidth;
				thisWidth=width*100/max;
				width = normalWidth*thisWidth/tot;
%>
				<table width="<%=thisWidth%>%" border="0" cellspacing="0" cellpadding="0">
					<tr>
<%
				if(normalWidth != 0)
				{
%>
						<a href ="/final/admin/EgUnconfigTests.jsp?serverType=<%=thisSrvType%>&source=dashboard&show=normalTest" STYLE="text-decoration:none" id="dash_text" target="_parent">
							<span>
								<td  id="cell_bg_medium"class="mouse" width='<%=width%>%' align="center" onclick="loadURL('/final/admin/EgUnconfigTests.jsp?serverType=<%=thisSrvType%>&source=dashboard&show=normalTest')" title="<%=normalWidth%> tests">
								<a href ="/final/admin/EgUnconfigTests.jsp?serverType=<%=thisSrvType%>&source=dashboard&show=normalTest" class="dash_textwhite" target="_parent" >
										<%=thisWidth>3?normalWidth+"":normalWidth+"&nbsp"%>
								</a>
								</td>
							</span>
						</a>
<%
				}
				if(configWidth != 0)
				{
					width = configWidth*thisWidth/tot;
%>
						<a href ="/final/admin/EgUnconfigTests.jsp?serverType=<%=thisSrvType%>&source=dashboard&show=configTest" STYLE="text-decoration:none" id="dash_text" target="_parent">
							<span>
								<td  id="cell_bg_light"class="mouse" width='<%=width%>%' align="center" onclick="loadURL('/final/admin/EgUnconfigTests.jsp?serverType=<%=thisSrvType%>&source=dashboard&show=configTest')" title="<%=configWidth%> tests">
								<a href ="/final/admin/EgUnconfigTests.jsp?serverType=<%=thisSrvType%>&source=dashboard&show=configTest" class="dash_text" target="_parent" >
										<%=thisWidth>3?configWidth+"":configWidth+"&nbsp"%>
								</a>
								</td>
							</span>
						</a>
<%
				}
%>
					</tr>
				</table>
			</td>
<%
			}
%>
		</tr>

		<tr>
			<td background="eg_images/in_titleshadowbg1.gif" height="7" id="eg_blankspace">&nbsp;</td>
			<td height="7">
				<table width="<%=tot*100/max%>%" border="0" cellspacing="0" cellpadding="0"><tr><td id="eg_blankspace" nowrap height="7" background="eg_images/in_titleshadowbg1.gif">&nbsp;</td></tr></table>
			</td>
		</tr>
<%
			countTokList.remove(index);
			typeTokList.remove(index);
			if(isCMEnabled)
				countList.remove(index);
		}
%>
	</table>
<%
	}
	else
	{
%>
	<table cellspacing="0" cellpadding="0" border="0" width="100%" height="100%">
		<tr>
			<td align="center" valign="middle">
<%
		if (ao.getTotalServersManaged() == 0)
		{
%>
			<img src="eg_images/<%=admin_Skin%>/exclamation-icon.gif"><br><egui:intnl text="admin.unconfig.No managed components"/>.
<%
		}
		else
		{
%>
			<img src="eg_images/tick-icon.gif"><br><egui:intnl text="admin.unconfig.All components have been configured"/>.
<%
		}
%>
			</td>
		</tr>
	</table>
<%
	}
%>
</body>
<script language="javascript">
function loadURL(myURL)
{
	if(window.parent!=null)
	{
		window.parent.location.href=myURL;
	}
}
</script>
</html>



