<%
/**
 *  File			:	Egmailsettingsp.jsp
 *  Author			:	Sandhya.K
 *  Purpose			:	To update the configured values in eg_services.ini file.
 *  Version			:	0.1
 *  Creation Date	:	23/12/2000
 *  Last Modified	:
 *			22/07/2004	Arun		Writes to MailPasswd instead of MailPassword.
 *			14/07/2004	Arun		Clears mail authentication info in eg_services.ini if set to No
 *			08/07/2004	Arun		Included option for mail authentication
 *			01/07/2004	Arun		Uses StringUtils.removeISOControlChar() to remove Ctrl-M
 *			18/02/2003	sandhya		SmsFormat
 *			03/02/2003	sandhya		Configure Subject
 *			05/06/2001	Bala		IniFile save
 */
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "com.eg.EgCrypt" %>
<%@ page import = "com.eg.EgMemInfo" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<%
	/* code for auditlog starts */
	Hashtable sms = new Hashtable();
	sms.put("cname","Component name");
	sms.put("cname_sms","Component name");
	sms.put("ctype","Component type");
	sms.put("desc","Description");
	sms.put("site","Services");
	sms.put("test","Test");
	sms.put("measure","Measure");
	sms.put("mhost","Measurement host");
	sms.put("layer","Layer");
	sms.put("prior","Priority");
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Mail Settings");
	auditLogThread.setValue("Activity","Mail Configuration");
	Enumeration en = request.getParameterNames();
	while(en.hasMoreElements())
	{
		String name = ((String) en.nextElement()).toString().trim();
		String mailFormat = "";
		if(name.equals("$_password"))
			continue;
		if(name != null && !name.equalsIgnoreCase("null") && name.length()>0 && name.startsWith("$_"))
		{
			String value = request.getParameter(name);
			if(value != null && !value.equalsIgnoreCase("null") && value.length()>0 && value.indexOf("$") !=-1)
			{
				String label = null;
				String labelValue = null;
				StringTokenizer stokens = new StringTokenizer(value,"$");
				if(stokens.countTokens()==2)
				{
					label = stokens.nextToken().toString();
					labelValue = stokens.nextToken();
				}
				else
				{
					label = stokens.nextToken();
					labelValue = "";
				}
				if(label != null && labelValue != null && !labelValue.equalsIgnoreCase("null") && labelValue.trim().length()>0)
				{
					String val = labelValue.startsWith("_")?labelValue.substring(1):labelValue;
					if(val.equalsIgnoreCase("true") || val.equalsIgnoreCase("yes"))
						val = "Yes";
					else if(val.equalsIgnoreCase("false") || val.equalsIgnoreCase("no"))
						val = "No";
					if(sms.containsKey(val))
						auditLogThread.setPreviousValue(label, sms.get(val).toString());
					else
						auditLogThread.setPreviousValue(label, val);
				}
				String currentValue = request.getParameter(name.substring(2));
				if(currentValue == null || currentValue.equalsIgnoreCase("null") && currentValue.trim().length()==0)
					continue;
				currentValue = currentValue.trim();

				if(name.equals("$_MailSubjectFormatToUse"))
				{
					if(currentValue.equals("DefinedFormat"))
					{
						currentValue = "Descriptive";
						mailFormat = "Descriptive";
					}
					else
					{
						currentValue = "Concise";
						mailFormat = "Concise";
					}
				}

				if (name.equals("$_mailSubjectService"))
				{
					currentValue = "Services";
				}
				else if (name.equals("$_mailSubjectCompName"))
				{
					currentValue = "Component name";
				}
				else if (name.equals("$_mailSubjectCompType"))
				{
					currentValue = "Component type";
				}
				else if (name.equals("$_mailSubjectLayer"))
				{
					currentValue = "Layer";
				}
				else if (name.equals("$_mailSubjectTest"))
				{
					currentValue = "Test";
				}
				else if (name.equals("$_mailSubjectDesc"))
				{
					currentValue = "Description";
				}
				else if (name.equals("$_mailSubjectLMV"))
				{
					currentValue = "Last measure value";
				}
				if(mailFormat!=null)
				{
					if(mailFormat.equalsIgnoreCase("Descriptive"))
					{
						if (name.equals("$_mailSubjectPrior"))
						{
							currentValue = "Priority";
						}
						if(name.equals("$_mailSubjectAlarmId"))
						{
							currentValue = "AlarmId";
						}
					}
					else if(mailFormat.equalsIgnoreCase("Concise"))
					{
						if(name.equals("$_mailSubjectCPrior"))
						{
							currentValue = "Priority";
						}
						if(name.equals("$_mailSubjectCAlarmId"))
						{
							currentValue = "AlarmId";
						}
					}
				}
				if(currentValue.length()>0)
				{
					if(currentValue.equalsIgnoreCase("true") || currentValue.equalsIgnoreCase("yes"))
						currentValue = "Yes";
					else if(currentValue.equalsIgnoreCase("false") || currentValue.equalsIgnoreCase("no"))
						currentValue = "No";
					if(sms.containsKey(currentValue))
						auditLogThread.setCurrentValue(label, sms.get(currentValue).toString());
					else
						auditLogThread.setCurrentValue(label, currentValue);
				}
			}
		}
	}
	String currentPassword = request.getParameter("authpassword");
	String previousPassword = request.getParameter("$_password");
	if(currentPassword != null && previousPassword != null && previousPassword.indexOf("$")!=-1)
	{
		String label = previousPassword.substring(0,previousPassword.indexOf("$"));
		previousPassword = previousPassword.substring(previousPassword.indexOf("$")+1);

		if(previousPassword.length() == 0 && currentPassword.length()>0)
		{
			auditLogThread.setCurrentValue(label,"******");
		}
		else if(!previousPassword.equals(currentPassword))
		{
			auditLogThread.setPreviousValue(label,"*****");
			auditLogThread.setCurrentValue(label,"******");
		}
	}
	if(EgMemInfo.smsEnabled)
		auditLogThread.setValue("Description","Mail and SMS settings have been configured");
	else
		auditLogThread.setValue("Description","Mail settings have been configured");
	auditLogThread.sendItToDB();
	/* code for auditlog ends */
%>

<jsp:useBean id="mailconfig" class="egurkha.TransactionBean" scope="page" />

<%!
	String licenseCheck = "me";
	String subject = "MISC_ARGS";
	String strHost = "";
	String strPort = "";
	String strProtocol = "";
	String strSender = "";
	String strmSub = "";
	String strsSub ="";
%>

<%
	strHost = request.getParameter("mailhost");
	strPort = request.getParameter("mailport");
	strProtocol = request.getParameter("mailprotocol");
	strSender = request.getParameter("mailsender");
	strmSub = request.getParameter("mailsub");
	String strmailseparate=request.getParameter("separatemail");
	String strsmsseparate=request.getParameter("separatesms");
	String mailSenders = request.getParameter("mailsenders");
	String normalMail = request.getParameter("normalmail");
	String ddMail = request.getParameter("ddmail");
	String mailAsAttachment = request.getParameter("mailAsAttachment");

	String mailSubjectFormatToUse = request.getParameter("MailSubjectFormatToUse");
	String mailSubjectStart = request.getParameter("MailSubjectStart");
	String mailSubjectLength = request.getParameter("MailSubjectLength");

	boolean smsEnabled = false;
	synchronized(licenseCheck)
	{
		smsEnabled = EgMemInfo.smsEnabled;
	}

	String strsFormat = "";
	if(smsEnabled)
	{
		strsSub = request.getParameter("smssub");

		String cname = request.getParameter("cname");
		String ctype =request.getParameter("ctype");
		String desc = request.getParameter("desc");
		String site = request.getParameter("site");
		String test = request.getParameter("test");
		String measure = request.getParameter("measure");
		String mhost = request.getParameter("mhost");
		String layer = request.getParameter("layer");
		String prior = request.getParameter("prior");
		if(cname != null)
			strsFormat +="cname" + ",";
		if(ctype != null)
			strsFormat += "ctype" + ",";
		if(desc != null)
			strsFormat += "desc" + ",";
		if(site != null)
			strsFormat += "site" + ",";
		if(test != null)
			strsFormat += "test" + ",";
		if(measure != null)
			strsFormat += "measure" + ",";
		if(mhost != null)
			strsFormat += "mHost" + ",";
		if(layer != null)
			strsFormat += "layer" + ",";
		if(prior != null)
			strsFormat += "prior" + ",";

		if(strsFormat.indexOf(",") > -1)
			strsFormat = strsFormat.substring(0,strsFormat.lastIndexOf(","));
		else
			strsFormat = "";
	}

	//Added for mail settings
	String mailcname = request.getParameter("mailcname");
	String mailctype =request.getParameter("mailctype");
	String maildesc = request.getParameter("maildesc");
	String mailsite = request.getParameter("mailsite");
	String mailtest = request.getParameter("mailtest");
	String mailmeasure = request.getParameter("mailmeasure");
	String mailmhost = request.getParameter("mailmhost");
	String maillayer = request.getParameter("maillayer");

	String strmailFormat="";
	if(mailcname != null)
		strmailFormat +="cname" + ",";
	if(mailctype != null)
		strmailFormat += "ctype" + ",";
	if(maillayer != null)
		strmailFormat += "layer" + ",";
	if(maildesc != null)
		strmailFormat += "desc" + ",";
	if(mailsite != null)
		strmailFormat += "site" + ",";
	if(mailtest != null)
		strmailFormat += "test" + ",";
	if(mailmeasure != null)
		strmailFormat += "measure" + ",";
	if(mailmhost != null)
		strmailFormat += "mHost" + ",";

	if(strmailFormat.indexOf(",") > -1)
		strmailFormat = strmailFormat.substring(0,strmailFormat.lastIndexOf(","));
	else
		strmailFormat = "";

	mailconfig.createSyncFile("eg_services.ini", "save");
	mailconfig.setValue(subject,"MailHost", strHost);
	mailconfig.setValue(subject,"MailPort", strPort);
	mailconfig.setValue(subject,"MailHostProtocol", strProtocol);
	mailconfig.setValue(subject,"MailSender", strSender);
	mailconfig.setValue(subject,"MailNormal", normalMail);
	mailconfig.setValue(subject,"ShowDDinMail", ddMail);
	mailconfig.setValue(subject,"SendMailAlertAsAttachment",mailAsAttachment);

	String[] mailIds = null;
	mailconfig.delSubject("MAIL_SENDERS");
	if (mailSenders!=null && mailSenders.length()>0)
	{
		StringTokenizer mailIdTokens = new StringTokenizer(mailSenders,"\n");
		mailIds = new String[mailIdTokens.countTokens()];
		for(int i=0;mailIdTokens.hasMoreElements();i++)
		{
			mailIds[i] = mailIdTokens.nextToken();
		}
	}
	if (mailIds!=null && mailIds.length>0)
	{
		for (int i=0;i<mailIds.length;i++)
		{
			mailconfig.setValue("MAIL_SENDERS", mailIds[i],"1");
		}
	}

	String authenticate = request.getParameter("authenticate");
	if (!StringUtils.isNull(authenticate) && authenticate.equalsIgnoreCase(EgConstants.TRUE))
	{
		mailconfig.setValue(subject,"MailUser", request.getParameter("user"));
		//mailconfig.setValue(subject,"MailPasswd", EgCrypt.encrypt(request.getParameter("userPassword")));
		mailconfig.setValue(subject,"MailPasswd", EgCrypt.encrypt(request.getParameter("authpassword")));
	}
	else
	{
		mailconfig.setValue(subject,"MailUser", "");
		mailconfig.setValue(subject,"MailPasswd", "");
	}

	if(smsEnabled)
	{
		mailconfig.setValue(subject,"SmsSubject",strsSub);
		mailconfig.setValue(subject,"SmsFormat",strsFormat);
		mailconfig.setValue(subject,"SeparateSms",strsmsseparate);
	}

	mailconfig.setValue(subject,"MailSeparate",strmailseparate);
	mailconfig.setValue(subject,"MailFormat",strmailFormat);

	String strMailSubjectFormat = "";
	String strMailSubjectCFormat = "";

	//Added by Maruthupandi (06/12/2007) - Start
	if (mailSubjectFormatToUse.equalsIgnoreCase("CustomFormat"))
	{
		mailSubjectFormatToUse = "";
		mailSubjectStart = "";
		mailSubjectLength = "";
		String mailSubjectCPriority = request.getParameter("mailSubjectCPrior");
		String mailSubjectCAlarmId = request.getParameter("mailSubjectCAlarmId");
		if (mailSubjectCPriority != null)
		{
			strMailSubjectCFormat += mailSubjectCPriority + ":";
		}
		if(mailSubjectCAlarmId != null)
		{
			strMailSubjectCFormat += mailSubjectCAlarmId + ":";
		}
		if (strMailSubjectCFormat.indexOf(":") != -1)
		{
			strMailSubjectCFormat = strMailSubjectCFormat.substring(0,strMailSubjectCFormat.lastIndexOf(":"));
		}
	}
	else //DefinedFormat
	{
		strmSub = "";

		String mailSubjectService = request.getParameter("mailSubjectService");
		String mailSubjectCompName = request.getParameter("mailSubjectCompName");
		String mailSubjectCompType =request.getParameter("mailSubjectCompType");
		String mailSubjectLayer = request.getParameter("mailSubjectLayer");
		String mailSubjectTest = request.getParameter("mailSubjectTest");
		String mailSubjectDesc = request.getParameter("mailSubjectDesc");
		String mailSubjectLMV = request.getParameter("mailSubjectLMV");
		String mailSubjectPriority = request.getParameter("mailSubjectPrior");
		String mailSubjectAlarmId = request.getParameter("mailSubjectAlarmId");

		if (mailSubjectService != null)
		{
			strMailSubjectFormat += mailSubjectService + ":";
		}
		if (mailSubjectCompName != null)
		{
			strMailSubjectFormat += mailSubjectCompName + ":";
		}
		if (mailSubjectCompType != null)
		{
			strMailSubjectFormat += mailSubjectCompType + ":";
		}
		if (mailSubjectLayer != null)
		{
			strMailSubjectFormat += mailSubjectLayer + ":";
		}
		if (mailSubjectTest != null)
		{
			strMailSubjectFormat += mailSubjectTest + ":";
		}
		if (mailSubjectDesc != null)
		{
			strMailSubjectFormat += mailSubjectDesc + ":";
		}
		if (mailSubjectLMV != null)
		{
			strMailSubjectFormat += mailSubjectLMV + ":";
		}
		if (mailSubjectPriority != null)
		{
			strMailSubjectFormat += mailSubjectPriority + ":";
		}
		if (mailSubjectAlarmId != null)
		{
			strMailSubjectFormat += mailSubjectAlarmId + ":";
		}
		if (strMailSubjectFormat.indexOf(":") != -1)
		{
			strMailSubjectFormat = strMailSubjectFormat.substring(0,strMailSubjectFormat.lastIndexOf(":"));
		}
	}

	mailconfig.setValue(subject,"MailSubjectFormatToUse",mailSubjectFormatToUse);
	mailconfig.setValue(subject,"MailSubject", StringUtils.removeISOControlChar(strmSub));
	mailconfig.setValue(subject,"MailSubjectStart",mailSubjectStart);
	mailconfig.setValue(subject,"MailSubjectFormat",strMailSubjectFormat);
	mailconfig.setValue(subject,"MailSubjectCFormat",strMailSubjectCFormat);
	mailconfig.setValue(subject,"MailSubjectLength",mailSubjectLength);
	//Added by Maruthupandi (06/12/2007) - End

	mailconfig.saveFile();
	mailconfig.releaseInstance();
	Vector sess_vec = new Vector();
	sess_vec.addElement(_mapping.getTextDescription("admin.mail.Configure mail settings"));
	sess_vec.addElement("EgMailSettings.jsp");
	sess_vec.addElement(_mapping.getTextDescription("admin.mail.Configure mail settings")+".");
	if(smsEnabled)
		sess_vec.addElement(_mapping.getTextDescription("admin.mail.Mail and SMS settings have been configured successfully")+"...");
	else
		sess_vec.addElement(_mapping.getTextDescription("admin.mail.Mail settings have been configured successfully")+"...");

	session.setAttribute("vec_Results",sess_vec);
	//response.sendRedirect("EgResults.jsp");
%>
<jsp:forward page="EgResults.jsp" />



