<%
/*
 *	Name		:	EgMBeanDisoveryJson.jsp
 *	Purpose		:	IC Test - JMX type 
 */
%>
<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="java.net.URLEncoder"%>
<%@ page import="java.io.*" %>
<%@ page import="egurkha.*" %>
<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJSON = new JSONObject();
	JSONObject hiddens = new JSONObject();
	JSONObject obj = new JSONObject();
	rootJSON.put("success","true");
	ArrayList restrictedExtList = new ArrayList();
	restrictedExtList.add(".dll");
	restrictedExtList.add(".jar");
	restrictedExtList.add(".class");
	restrictedExtList.add(".mib");
	restrictedExtList.add(".gif");
	restrictedExtList.add(".bak");

	Hashtable domainTable = new Hashtable();
	String hostName = request.getParameter("host");
	String jmxPort = request.getParameter("jmxport");
	String jndiName = request.getParameter("jndi");
	String userName = request.getParameter("user");
	String password = request.getParameter("pass");
	String test = request.getParameter("test");
	String option = request.getParameter("option");
	String error = request.getParameter("error");
	String domainName = request.getParameter("domain");
	String filePath = request.getParameter("filepath");
	boolean isDomainConfigured = false;
	TestBean tb = new TestBean(true);
	ArrayList alMeasList = tb.getMeasuresForTest(test);
	if (alMeasList != null && alMeasList.size() > 0)
	{
		rootJSON.put("MeasuresExist",true);
	}
	else
	{
		rootJSON.put("MeasuresExist",false);
	}	
	if(domainName == null || domainName.length() == 0 || domainName.equals("") || domainName.equals("null"))
	{
		domainName = tb.getObject(test);
		if(domainName != null && domainName.length() > 0)
			isDomainConfigured = true;
	}
	if(filePath == null || filePath.length() == 0 || filePath.equals("") || filePath.equalsIgnoreCase("null"))
	{
		filePath="";
		String discoveryStr =  tb.getMbeanDiscovery(test);
		if(discoveryStr!=null && discoveryStr.length()>0)
		{
			StringTokenizer st = new StringTokenizer(discoveryStr,"#");
			if(st.countTokens()==1)
			{
				filePath = st.nextToken();
			}
			else if(st.countTokens() == 2)
			{
				filePath = st.nextToken();
			}
		}
	}

	if(hostName == null || hostName.length() == 0 || hostName.equals("") || hostName.equalsIgnoreCase("null"))
		hostName="";
	if(jmxPort == null || jmxPort.length() == 0 || jmxPort.equals("") || jmxPort.equalsIgnoreCase("null"))
		jmxPort="";
	if(jndiName == null || jndiName.length() == 0 || jndiName.equals("") || jndiName.equalsIgnoreCase("null"))
		jndiName="jmxrmi";
	if(userName == null || userName.length() == 0 || userName.equals("") || userName.equalsIgnoreCase("null"))
		userName="none";
	if(password == null || password.length() == 0 || password.equals("") || password.equalsIgnoreCase("null"))
		password="none";
	if(option == null || option.length() == 0 || option.equals("") || option.equalsIgnoreCase("null"))
	{
		String discoveryStr =  tb.getMbeanDiscovery(test);
		if(discoveryStr!=null && discoveryStr.length()>0)
		{
			StringTokenizer st = new StringTokenizer(discoveryStr,"#");
			if(st.countTokens()==1)
			{
				option = "file";
			}
			else if(st.countTokens() == 2)
			{
				option = "existingMBean";
			}
			else if(st.countTokens()==5)
			{
				option = "disc";
			}
		}
		else
		{
			option = "disc";
		}
	}
	if(error == null || error.equals("") || error.equalsIgnoreCase("null"))
		error = "false";

	boolean errorFlag = false;
	if(!hostName.equals("") && !jmxPort.equals(""))
	{
		DiscoverMBeans dm = new DiscoverMBeans(hostName,jmxPort,jndiName,userName,password);
		domainTable = dm.getData();
	}
	else if(filePath!=null && filePath.length() > 0)
	{
		DiscoverMBeans dm = new DiscoverMBeans();
		domainTable = dm.readFromDiscoveryFile(filePath);
		if(domainTable!=null && domainTable.size()==0)
		{
			errorFlag = true;
		}
		try
		{
			FileReader discoveryFileReader = new FileReader(filePath);
			BufferedReader discoveryFileReaderBuffer = new BufferedReader(discoveryFileReader);
			String line="";
			boolean isDomainExist = false;
			while((line = discoveryFileReaderBuffer.readLine()) != null)
			{
				if(line!=null && line.startsWith("MBean: "+domainName))
				{
					isDomainExist = true;
					break;
				}
			}
			rootJSON.put("SelectedDomainExists",isDomainExist);
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		
	}

	session.setAttribute("MBeanDetails", domainTable);
	hiddens.put("test",test);
	hiddens.put("domain",domainName);
	rootJSON.put("optSelected",option);
	JSONArray opts = new JSONArray();
	obj = new JSONObject();
	obj.put("displayField",_mapping.getTextDescription("admin.ic.Auto Discover MBean"));
	obj.put("valueField","disc");
	opts.add(obj);
	obj = new JSONObject();
	obj.put("displayField",_mapping.getTextDescription("admin.ic.Upload an MBean File"));
	obj.put("valueField","file");
	opts.add(obj);
	obj = new JSONObject();
	obj.put("displayField",_mapping.getTextDescription("admin.ic.Use Existing MBean File"));
	obj.put("valueField","existingMBean");
	opts.add(obj);
	obj = new JSONObject();
	obj.put("displayField",_mapping.getTextDescription("admin.ic.Configure Manually"));
	obj.put("valueField","manual");
	opts.add(obj);
	rootJSON.put("optsList",opts);

	if(option.equals("disc"))
	{
		String discoveryStr =  tb.getMbeanDiscovery(test);
		if(discoveryStr!=null && discoveryStr.length()>0)
		{
			if(hostName.equals("") && jmxPort.equals(""))
			{
				StringTokenizer st = new StringTokenizer(discoveryStr,"#");
				if(st.countTokens()==5)
				{
					hostName = st.nextToken();
					jmxPort = st.nextToken();
					jndiName = st.nextToken();
					userName = st.nextToken();
					password = st.nextToken();
				}
			}
		}
		rootJSON.put("hostName",hostName);
		rootJSON.put("jmxPort",jmxPort);
		rootJSON.put("jndiName",jndiName);
		rootJSON.put("userName",userName);
		rootJSON.put("password",password);
	}
	else if(option.equals("file") || option.equals("existingMBean"))
	{
		if(option != null && option.equals("existingMBean"))
		{
			try
			{
				String installDir = EgInstallInfo.getInstallDir();
				installDir = installDir.replace("\\","/");
				File f = new File(installDir+"/tmp");
				File[]dirList = f.listFiles();
				String mbeanFile = "";

				String file = "";
				JSONArray mbFiles = new JSONArray();
				obj = new JSONObject();
				obj.put("valueField","-1");
				obj.put("displayField",_mapping.getTextDescription("admin.ic.Please select a file"));
				mbFiles.add(obj);
				if(dirList != null && dirList.length > 0)
				{
					rootJSON.put("fileSelected","-1");
					for(int i=0;i<dirList.length;i++)
					{
						if(dirList[i].isFile())
						{
							String fileName = dirList[i].getName();
							file = installDir+"/tmp/"+fileName;
							if(fileName.indexOf(".") > -1)
							{
								String ext = file.substring(file.lastIndexOf("."));
								if(restrictedExtList.contains(ext))
								{
									continue;
								}
							}
							boolean isMbeanExist = readTmpFile(file);
							if(isMbeanExist)
							{
								if (i==0)
								{
									rootJSON.put("fileSelected",file);
								}
								String selected = "";
								if(file.equals(filePath))
								{
									selected = "selected";
									mbeanFile = fileName;
									rootJSON.put("fileSelected",file);
								}
								obj = new JSONObject();
								obj.put("displayField",file);
								obj.put("valueField",file);
								mbFiles.add(obj);
							}
						}
					}
				}
				else
				{
					obj = new JSONObject();
					obj.put("displayField",_mapping.getTextDescription("admin.ic.No MBean file found"));
					obj.put("valueField","-1");
					mbFiles.add(obj);
					rootJSON.put("fileSelected","-1");
				}
				rootJSON.put("mBeanFilesList",mbFiles);

				IniFile egUDTestFile = EgConfigFilesSync.getInstance(installDir + "/manager/config/eg_udtests.ini");
				String testValue = egUDTestFile.getValue("UPLOADED_FILES",test);
				if(testValue != null && testValue.length() > 0)
				{
					StringTokenizer str = new StringTokenizer(testValue,",");
					ArrayList list = new ArrayList();
					while(str.hasMoreTokens())
					{
						list.add(str.nextToken());
					}
					if(mbeanFile != null && mbeanFile.length() > 0 && !(list.contains(mbeanFile)))
					{
						egUDTestFile.setValue("UPLOADED_FILES",test,testValue+","+mbeanFile);
						egUDTestFile.saveFile();
					}
				}
				if(testValue == null || testValue.length()<=0)
				{
					egUDTestFile.setValue("UPLOADED_FILES",test,mbeanFile);
					egUDTestFile.saveFile();
				}
				EgConfigFilesSync.releaseInstance(egUDTestFile);
			}
			catch(Exception eee)
			{
				System.out.println("Exception : "+eee.toString());
			}
		}
		else
		{
			rootJSON.put("filePath",filePath);
			String fileUpl = "/final/admin/Misc/data/EgFileUpload.jsp?title=Uploading eGurkha Files&dispCaption=Fiels&requestFrom=EgMBeanDiscovery.jsp&uploadFor=save&&uploadDir=&mgrLog=true&showDir=true&test="+test+"&fileExt=";
			rootJSON.put("uploadFilePath",fileUpl);
		}
	}
	rootJSON.put("showDomainsList",false);
	if(domainTable != null && domainTable.size() > 0)
	{
		rootJSON.put("showDomainsList",true);
		JSONArray domains = new JSONArray();
		obj = new JSONObject();
		obj.put("valueField","-1");
		obj.put("displayField",_mapping.getTextDescription("admin.ic.Please select a domain"));
		domains.add(obj);
		rootJSON.put("domainSelected","-1");
		if(filePath!=null && !filePath.equals("") && filePath.length() > 0)
		{
			if(option.equals("existingMBean"))
			{
				tb.setMbeanDiscovery(test,filePath+"#"+option);
			}
			else
			{
				tb.setMbeanDiscovery(test,filePath);
			}
		}
		else
			tb.setMbeanDiscovery(test, hostName, jmxPort, jndiName, userName, password);
		Set keys = domainTable.keySet();
		Object [] domain = null;
		if(isDomainConfigured && alMeasList.size() > 0)
		{
			domain = new Object [1];
			domain[0] = domainName;
		}
		else
		{
			domain = new Object [domainTable.size()];
			domain = keys.toArray();
		}
		Arrays.sort(domain);

		for(int i=0;i<domain.length;i++)
		{
			String s = (String) domain[i];
			obj = new JSONObject();
			obj.put("valueField",s);
			obj.put("displayField",s);
			domains.add(obj);
			if(s.equals(domainName))
			{
				rootJSON.put("domainSelected",s);
			}
		}
		rootJSON.put("domainsList",domains);
	}
	else if (error.equals("true") || errorFlag )
	{
		rootJSON.put("showError",true);
	}
	hiddens.put("mbeanPath",filePath);
	rootJSON.put("hiddens",hiddens);
	out.println(rootJSON);
%>



<%!
public boolean readTmpFile(String fileName)
{
	String findWord = "Mbean:";
	boolean check = false;
	try
	{
		FileInputStream fstream = new FileInputStream(fileName);
		BufferedReader br = new BufferedReader(new InputStreamReader(fstream));
		String strLine;        
		while((strLine = br.readLine()) != null)
		{   
			if((strLine.toLowerCase().indexOf(findWord.toLowerCase())) > -1)
			{
				check = true;
				break;
			}                    
		}               
		br.close();
	}
	catch(Exception e)
	{
		e.printStackTrace();
	}
	return check;
}
%>