<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%@ page import="com.eg.*"%>
<%@ page import="com.egurkha.util.*"%>
<%@ page import="com.eg.supermanager.EgSmSuperInfo"%>
<%@ page import="java.util.*"%>
<%@ page import="java.text.*"%>
<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJSON = new JSONObject();
	IniFile egUI = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_ui.ini");
	String s_iniFileDir = EgInstallInfo.getInstallDir();
	String strCommand = s_iniFileDir + "/bin/viewCert" + " " + s_iniFileDir + "/bin/license";
	EgUtilities eG_Utils = EgUtilities.createInstance();

	ArrayList allEnteries = eG_Utils.getExecOutputLines(strCommand);
	if (allEnteries == null || allEnteries.size() < 2)
	{
		return;
	}
	ArrayList licenseInfoLines = (ArrayList) allEnteries.get(0);
	if (licenseInfoLines == null || licenseInfoLines.size() == 0)
	{
		return;
	}

	int eGMgrsCount = 0;
	int licenseUsed = EgSmSuperInfo.getInstance().getManagedManagersCount();
	int licenseAvailable = 0;

	ArrayList aListLicenseEntries = new ArrayList();
	for (int i = 0; i<licenseInfoLines.size(); i++)
	{
		String line = (String) licenseInfoLines.get(i);
		if(line.length()==0)
		{
			continue;
		}
		aListLicenseEntries.add(line);
	}

	HashMap licenseInfoMap = new HashMap();
	for(int i=0; i<aListLicenseEntries.size(); i++)
	{
		String eleme = (String)aListLicenseEntries.get(i);
		int index = eleme.indexOf(":");
		if(index > 0)
		{
			String info=(eleme.substring(0,index)).trim();
			String value=eleme.substring(index+1);
			if(value.indexOf("Not Applicable") >= 0||(value.trim().startsWith("-")))
			{
				value = "-";
			}
			licenseInfoMap.put(info,value.trim());
		}
	}

	String currentDateTime = (String) licenseInfoMap.get("Expiry Date");
	String destDate = "";
	if (currentDateTime != null && !currentDateTime.equals("No expiry date set"))
	{
		//Convert expiry date to user timezone - Start
		SimpleDateFormat sourceformatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy");
		ParsePosition pos = new ParsePosition(0);
		Date parsedDate = sourceformatter.parse(currentDateTime, pos);

		Calendar calObj = Calendar.getInstance();
		calObj.setTime(parsedDate);
		String s_date = checkDate(calObj.get(Calendar.DATE));
		String s_month = checkDate(calObj.get(Calendar.MONTH)+1);
		String s_hourofday = checkDate(calObj.get(Calendar.HOUR_OF_DAY));
		String s_min = checkDate(calObj.get(Calendar.MINUTE));
		String s_sec = checkDate(calObj.get(Calendar.SECOND));
		String s_year = ""+calObj.get(Calendar.YEAR);

		destDate = s_month+"-"+s_date+"-"+s_year;
		String destTime = s_hourofday+":"+s_min+":"+s_sec;

		String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
		if(DateUtil.isDate(destDate,"MM-dd-yyyy"))
		{
			destDate = DateUtil.changeDateFormat(destDate,"MM-dd-yyyy",currentDateFormat);
			EgTimeZoneConverter egtc = new EgTimeZoneConverter(destDate+" "+destTime, _user);
			destDate = egtc.getDateTime();
		}
	}
	else
	{
		destDate = currentDateTime;
	}
	rootJSON.put("product",licenseInfoMap.get("Product"));
	rootJSON.put("version",licenseInfoMap.get("Version"));
	rootJSON.put("IPAddress",licenseInfoMap.get("IP Address"));
	rootJSON.put("hostID",licenseInfoMap.get("Host ID"));
	rootJSON.put("expDate",destDate);
	rootJSON.put("mailSenderID",licenseInfoMap.get("Email Address"));
	rootJSON.put("companyName",licenseInfoMap.get("Company Name"));

	String mgrsCount = (String)licenseInfoMap.get("No of eGManagers");
	if(mgrsCount != null && mgrsCount.trim().length() >0)
	{
		eGMgrsCount = Integer.parseInt(mgrsCount);
		if(licenseUsed <= eGMgrsCount)
		{
			licenseAvailable = eGMgrsCount - licenseUsed;
			rootJSON.put("licenseUsed",String.valueOf(licenseUsed));
			rootJSON.put("licenseAvailable",String.valueOf(licenseAvailable));
		}
	}
	rootJSON.put("eGMgrsCount",String.valueOf(eGMgrsCount));
	out.println(rootJSON);
%>

<%!
	public String checkDate(int dateValue)
	{
		String finalDate = "";
		if (dateValue < 10)
		{
			finalDate = "0"+dateValue;
		}
		else
		{
			finalDate = ""+dateValue;
		}
		return finalDate;
	}
%>



