<%
/*
	Author			:	James Thomas P.
	Creation Date	:	27th October 2006
	Purpose			:	Processing page to update the values of "MISC_ARGS" subject in eg_services.ini file
*/
%>
<%@ include file = "EgTrackerA.jsp"%>
<%@ page errorPage = "EgProbs.jsp"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgCrypt"%>
<%@ page import = "com.eg.EgMemInfo"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.egurkha.EgConstants"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<%!
	public String customizeValue(String array[])
	{
		String value = "";
		if(array != null)
		{
			for(int i=0;i<array.length;i++)
			{
				if(array[i].equalsIgnoreCase("cname"))
				{
					value = value+"Component name"+",";
				}
				if(array[i].equalsIgnoreCase("ctype"))
				{
					value = value+"Component type"+",";
				}
				if(array[i].equalsIgnoreCase("layer"))
				{
					value = value+"Layer name"+",";
				}
				if(array[i].equalsIgnoreCase("test"))
				{
					value = value+"Test name"+",";
				}
				if(array[i].equalsIgnoreCase("desc"))
				{
					value = value+"Description"+",";
				}
				if(array[i].equalsIgnoreCase("alarmdate"))
				{
					value = value+"Start date & time"+",";
				}
			}
			value = value.substring(0,value.length()-1);
		}
		return value;
	}
%>
<%
	Hashtable ht = new Hashtable();
	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();	
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Mail Settings");
	auditLogThread.setValue("Activity","Advanced Options");

	ArrayList dontAllow = new ArrayList();
	dontAllow.add("$_AlarmEscalationType");
	dontAllow.add("$_LogPreferance");
	String heartbeatFreq = request.getParameter("HeartbeatFreq");
	if(heartbeatFreq == null || heartbeatFreq.equals("null") || heartbeatFreq.trim().length()==0)
	{
		dontAllow.add("$_HeartbeatAlways");
		dontAllow.add("$_HeartbeatTo");
		dontAllow.add("$_HeartbeatMailMode");
		dontAllow.add("$_MailReceiverPasswd");
	}

	Enumeration en = request.getParameterNames();
	while(en.hasMoreElements())
	{
		String name = ((String) en.nextElement()).toString().trim();
		if(dontAllow.contains(name))
			continue;
		if(name != null && !name.equalsIgnoreCase("null") && name.length()>0 && name.startsWith("$_"))
		{
			String value = request.getParameter(name);
			if(value != null && !value.equalsIgnoreCase("null") && value.length()>0 && value.indexOf("$") !=-1)
			{
				String label = null;
				String labelValue = null;
				StringTokenizer stokens = new StringTokenizer(value,"$");
				if(stokens.countTokens()==2)
				{
					label = stokens.nextToken().toString();
					labelValue = stokens.nextToken();
				}
				else
				{
					label = stokens.nextToken();
					labelValue = "";
				}
				if(label != null && labelValue != null && !labelValue.equalsIgnoreCase("null") && labelValue.trim().length()>0)
				{
					String show = labelValue.startsWith("_")?labelValue.substring(1):labelValue;
					if(show.equalsIgnoreCase("true") || show.equalsIgnoreCase("yes"))
						show = "Yes";
					else if(show.equalsIgnoreCase("false") || show.equalsIgnoreCase("no"))
						show = "No";
					auditLogThread.setPreviousValue(label, show);
					ht.put(label, show);
				}

				String currentValue = request.getParameter(name.substring(2));
				if(currentValue == null || currentValue.equalsIgnoreCase("null") && currentValue.trim().length()==0)
					continue;
				currentValue = currentValue.trim();
				if(currentValue.length()>0)
				{
					if(currentValue.equalsIgnoreCase("true") || currentValue.equalsIgnoreCase("yes"))
						currentValue = "Yes";
					else if(currentValue.equalsIgnoreCase("false") || currentValue.equalsIgnoreCase("no"))
						currentValue = "No";
					auditLogThread.setCurrentValue(label, currentValue);
					if(ht.containsKey(label))
					{
						if(currentValue.equals(ht.get(label).toString()))
							ht.remove(label);
					}
				}
			}
		}
	}

	String currentAlarmEscalationPeriod = request.getParameter("AlarmEscalationPeriod");
	if(currentAlarmEscalationPeriod != null && !currentAlarmEscalationPeriod.equals("null") && currentAlarmEscalationPeriod.trim().length()>0)
	{
		String previousValue = request.getParameter("$_AlarmEscalationType");
		String currentValue = request.getParameter("selectedAlarms");

		String label = previousValue.substring(0,previousValue.indexOf("$"));
		previousValue = previousValue.substring(previousValue.indexOf("$")+1);

		if(previousValue !=null && !previousValue.equals("null") && previousValue.trim().length()>0)
		{
			String array[] = StringUtils.getTokens(previousValue,",");
			for(int i=0;i<array.length;i++)
			{
				if(array[i].equalsIgnoreCase("High"))
					previousValue = "Critical";
				else if(array[i].equalsIgnoreCase("Medium"))
					previousValue = "Major";
				else if(array[i].equalsIgnoreCase("Low"))
					previousValue = "Minor";
				auditLogThread.setPreviousValue(label, previousValue);
					ht.put(label, previousValue);
			}
		}

		if(currentValue != null && !currentValue.equals("null") && currentValue.trim().length()>0)
		{
			String array[] = StringUtils.getTokens(currentValue,",");
			for(int i=0;i<array.length;i++)
			{
				if(array[i].equalsIgnoreCase("High"))
					currentValue = "Critical";
				else if(array[i].equalsIgnoreCase("Medium"))
					currentValue = "Major";
				else if(array[i].equalsIgnoreCase("Low"))
					currentValue = "Minor";
				auditLogThread.setCurrentValue(label, currentValue);
				if(ht.containsKey(label))
				{
					if(currentValue.equals(ht.get(label).toString()))
						ht.remove(label);
				}
			}
		}
	}

	String mailManagerLogDebug = request.getParameter("maildebug");
	if(mailManagerLogDebug != null && !mailManagerLogDebug.equalsIgnoreCase("null"))
	{
		String previousValue = request.getParameter("$_LogPreferance");
		String currentValue[] = request.getParameterValues("LogPreferance");

		if(previousValue != null)
		{
			String label = previousValue.substring(0,previousValue.indexOf("$"));
			previousValue = previousValue.substring(previousValue.indexOf("$")+1);
			String temp = "cname,ctype,layer,test";
			if(currentValue != null)
			{
				for(int i=0;i<currentValue.length;i++)
				{
					if(currentValue[i].equalsIgnoreCase("desc"))
					{
						temp = temp+","+currentValue[i];
					}
					if(currentValue[i].equalsIgnoreCase("alarmdate"))
					{
						temp = temp+","+currentValue[i];
					}
				}
			}
			String arrayPreviousValue[] = StringUtils.getTokens(previousValue,",");
			String arrayCurrentValue[] = StringUtils.getTokens(temp,",");
			previousValue = customizeValue(arrayPreviousValue);
			temp = customizeValue(arrayCurrentValue);
			if(previousValue.length() > 0 && temp.length() > 0)
			{
				auditLogThread.setPreviousValue(label,previousValue);
					ht.put(label, previousValue);
				auditLogThread.setCurrentValue(label,temp);
				if(ht.containsKey(label))
				{
					if(temp.equals(ht.get(label).toString()))
						ht.remove(label);
				}
			}
		}
	}

	String currentPassword = request.getParameter("MailReceiverPasswd");
	String previousPassword = request.getParameter("$_MailReceiverPasswd");
	if(currentPassword != null && previousPassword != null && previousPassword.indexOf("$")!=-1)
	{
		String label = previousPassword.substring(0,previousPassword.indexOf("$"));
		previousPassword = previousPassword.substring(previousPassword.indexOf("$")+1);
		if(!previousPassword.equals(currentPassword))
		{
			auditLogThread.setPreviousValue(label,"*****");
			ht.put(label, "*****");
			auditLogThread.setCurrentValue(label,"******");
		}
	}

	auditLogThread.setValue("Description","Advanced options has been configured");
	if(ht.size()>0)
	auditLogThread.sendItToDB();
	/* code for auditlog ends */
%>

<jsp:useBean id="transBean" scope="page" class="egurkha.TransactionBean"/> 
<%
	IniUI  iniUI = IniUI.getInstance();
	String userLang = _user.getLanguage();
	userLang = (userLang!=null && userLang.length()>0)?userLang:iniUI.getDefaultLanguage();
	EgMappingInfo mappingInfo = new EgMappingInfo(userLang);

	//IniFile servicesIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini",true);
	IniFile servicesIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
	Enumeration enumeration = request.getParameterNames();
	while(enumeration.hasMoreElements())
	{
		String variable = ((String) enumeration.nextElement()).toString().trim();
		if (variable.startsWith("$_")) continue;
		if (variable.equalsIgnoreCase("MailLastValue"))
		{
			String mailLastValue = request.getParameter("MailLastValue");
			String mailFormat = servicesIni.getValue("MISC_ARGS","MailFormat");
			String smsFormat = servicesIni.getValue("MISC_ARGS","SmsFormat");
			String mailSubjectFormat = servicesIni.getValue("MISC_ARGS","MailSubjectFormat");

			if (mailLastValue.equalsIgnoreCase("Yes"))
			{
				if (mailFormat.indexOf("desc") > 0 && mailFormat.indexOf("measure") == -1)
				{
					mailFormat = mailFormat + ",measure";
				}
				if (smsFormat.indexOf("desc") > 0 && smsFormat.indexOf("measure") == -1)
				{
					smsFormat = smsFormat + ",measure";
				}
				if (mailSubjectFormat.toUpperCase().indexOf("DESCRIPTION") != -1 && mailSubjectFormat.toUpperCase().indexOf("LMV") == -1)
				{
					mailSubjectFormat = mailSubjectFormat + ":LMV";
				}
			}
			else
			{
				if (mailFormat.indexOf("measure") > -1)
				{
					mailFormat = StringUtils.replace(mailFormat,",measure","");
				}
				if (smsFormat.indexOf("measure") > -1)
				{
					smsFormat = StringUtils.replace(smsFormat,",measure","");
				}
				if (mailSubjectFormat.toUpperCase().indexOf("LMV:") != -1)
				{
					mailSubjectFormat = StringUtils.replace(mailSubjectFormat,"LMV:","");
				}
				else if (mailSubjectFormat.toUpperCase().indexOf(":LMV") != -1)
				{
					mailSubjectFormat = StringUtils.replace(mailSubjectFormat,":LMV","");
				}
			}

			servicesIni.setValue("MISC_ARGS","MailFormat",mailFormat);
			servicesIni.setValue("MISC_ARGS","SmsFormat",smsFormat);
			servicesIni.setValue("MISC_ARGS","MailSubjectFormat",mailSubjectFormat);
			servicesIni.saveFile();
		}
		if (variable.equals("shiftPeriodConfig"))
		{
			String shiftPeriodConfig = (String) request.getParameter("shiftPeriodConfig");
			if (shiftPeriodConfig != null)
			{
				if (shiftPeriodConfig.equalsIgnoreCase("Yes"))
				{
					servicesIni.setValue("MISC_ARGS","ShiftPeriodsEnabled","true");
				}
				else
				{
					servicesIni.setValue("MISC_ARGS","ShiftPeriodsEnabled","false");
				}
				servicesIni.saveFile();
			}
			continue;
		}
		if (variable.equals("MaximumShifts"))
		{
			String maximumShifts = (String) request.getParameter("MaximumShifts");
			if (maximumShifts != null)
			{
				servicesIni.setValue("MISC_ARGS","NoOfShiftPeriods",maximumShifts);
				servicesIni.saveFile();
			}
			continue;
		}
		if(variable.equals("selectedAlarms"))
		{
			String tempValue = (String) request.getParameter("selectedAlarms");
			if(tempValue==null || tempValue.length()==0)
			{
				servicesIni.setValue("MISC_ARGS","AlarmEscalationType","");
				servicesIni.saveFile();
			}
			continue;
		}
		if(variable.equals("maildebug"))
		{
			String mailLogDebug = request.getParameter("maildebug");

			if(mailLogDebug == null || mailLogDebug.length() == 0)
				mailLogDebug = "No";

			String logMaxSize = request.getParameter("LogMaxSize");
			String logMaxFile = request.getParameter("LogMaxFile");
			String logPrefer[] = request.getParameterValues("LogPreferance");

			String strLogPrefer = "";
			boolean isMailLogDisabled = mailLogDebug.equalsIgnoreCase("No");

			if(logPrefer == null || logPrefer.length == 0)
			{
				strLogPrefer = "cName,cType,layer,test";
			}
			else
			{
				strLogPrefer = "cName,cType,layer,test";
				for(int i=0;i<logPrefer.length;i++)
				{
					strLogPrefer = strLogPrefer + ","+logPrefer[i].trim();
				}
			}

			if(logMaxSize == null || logMaxSize.length() == 0)
			{
				logMaxSize = "2";
			}

			if(logMaxFile == null || logMaxFile.length() == 0)
			{
				logMaxFile = "10";
			}

			servicesIni.setValue("MISC_ARGS","MailManagerDebug",mailLogDebug);
			servicesIni.setValue("MISC_ARGS","MailmanagerLogMaxRollSize",logMaxSize);
			servicesIni.setValue("MISC_ARGS","Mailmanager_log_max_files",logMaxFile);
			servicesIni.setValue("MISC_ARGS","MailManagerLogPreference",strLogPrefer);
			continue;
		}

		if(variable.equals("LogMaxSize") || variable.equals("LogMaxFile") || variable.equals("LogPreferance"))
		{
			continue;
		}
		String newValue = request.getParameter(variable);
		if(variable.equals("AlarmEscalationType"))
		{
			newValue = request.getParameter("selectedAlarms");
		}
		if(variable.equals("AlarmEscalationPeriod"))
		{
			newValue=request.getParameter("AlarmEscalationPeriod");
			if (newValue.length() > 0)
				newValue = String.valueOf(Long.parseLong(newValue)*60);
		}
		
		if(variable.equals("mailalerts"))
		{
			String mailalertDebug = request.getParameter("mailalerts");
			String Mail_NonAdmins = request.getParameter("mail_NonAdmins");
			if(mailalertDebug == null || mailalertDebug.length() == 0)
				mailalertDebug = "No";
			if(Mail_NonAdmins == null || Mail_NonAdmins.length() == 0)
				Mail_NonAdmins = "No";
			servicesIni.setValue("MISC_ARGS","FilterMailAlerts",mailalertDebug);
			servicesIni.setValue("MISC_ARGS","AllowedForNonAdmins",Mail_NonAdmins);
			continue;
		}
		if(variable.equals("mail_NonAdmins"))
			continue;

		servicesIni.setValue("MISC_ARGS",variable,newValue);
	}

	servicesIni.saveFile();
	EgConfigFilesSync.releaseInstance(servicesIni);
	Vector sess_vec = new Vector();
	sess_vec.addElement(mappingInfo.getTextDescription("admin.mail.Advanced Options settings"));
	sess_vec.addElement("advancedOptions.jsp");
	sess_vec.addElement(mappingInfo.getTextDescription("admin.mail.Advanced Options in mail settings")+".");
	sess_vec.addElement(mappingInfo.getTextDescription("admin.mail.Advanced Options have been configured successfully")+"...");
	session.setAttribute("vec_Results",sess_vec);
%>
<jsp:forward page="EgResults.jsp" />



