<%
/*******************************************************************************
*		Name			:		agentsUpgradeAdvancedSearch.jsp
*		Purpose			:		Used to display and update agent's informations.
*		Version			:		4.0
*		Creation Date	:		29th June, 2007
*		Author			:		James Thomas P.
*******************************************************************************/
%>
<%@ include file = "EgTrackerA.jsp"%>
<%@ page errorPage = "EgProbs.jsp"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.AgentConfig"%>
<%@ page import = "com.eg.EgAgentInfo"%>
<%@ page import = "com.eg.EgLicenseInfo"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgExternalInfo"%>
<%@ page import = "com.eg.EgAggregateInfo"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.admin.AgentsUpgradeVO"%>
<%@ page import = "java.util.List"%>
<%@ page import = "java.util.Date"%>
<%@ page import = "java.util.Arrays"%>
<%@ page import = "java.util.Vector"%>
<%@ page import = "java.util.TreeSet"%>
<%@ page import = "java.util.Hashtable"%>
<%@ page import = "java.util.ArrayList"%>
<%@ page import = "java.util.Collections"%>
<%@ page import = "java.util.StringTokenizer"%>
<%@ page import = "java.text.Format"%>
<%@ page import = "java.text.SimpleDateFormat"%>
<%@ page import = "jakarta.servlet.http.HttpServletRequest"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<%
	Vector aggregateTypes = new Vector();
	if(EgInstallInfo.isAggregationSupported())
		aggregateTypes = new EgAggregateInfo("manager").getAggregateTypes();
	/*-----------This code for single and double byte language support------start-------*/
	String setAutoUpgradeButtonwidth="";
	String disableAutoUpgradeButtonwidth="";
	String upgradeNowButtonwidth="";
	String cancelUpgradeNowButtonwidth="";
	String refreshButtonWidth="";

	if(trackerLanguage!=null && (trackerLanguage.equals("en_US") || trackerLanguage.equals("ch_CH") || trackerLanguage.equals("ja_JP") || trackerLanguage.equals("ko_KR") || trackerLanguage.equals("th_TH")))
	{
		setAutoUpgradeButtonwidth="width:120px;";
		disableAutoUpgradeButtonwidth="width:160px;";
		upgradeNowButtonwidth="width:100px;";
		cancelUpgradeNowButtonwidth="width:160px;";
		refreshButtonWidth="width:120px";
	}
	else if(trackerLanguage!=null && (trackerLanguage.equals("fr_FR") || trackerLanguage.equals("de_DE") || trackerLanguage.equals("es_ES") || trackerLanguage.equals("it_IT") || trackerLanguage.equals("pt_BR")))
	{
		setAutoUpgradeButtonwidth="width:230px;";
		disableAutoUpgradeButtonwidth="width:250px;";
		upgradeNowButtonwidth="width:130px;";
		cancelUpgradeNowButtonwidth="width:190px;";
		refreshButtonWidth="width:160px;";
	}
	/*-----------This code for single and double byte language support-----End--------*/
%>

<%
	int optionCount=5;
	IniFile iniUiObj = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_ui.ini");
	String name_column = iniUiObj.getValue("DISPLAY_CHARACTERS_COUNT","Component_name");
	String type_column = iniUiObj.getValue("DISPLAY_CHARACTERS_COUNT","Component_type");
	String agent_name_column = iniUiObj.getValue("DISPLAY_CHARACTERS_COUNT","Agent_name");
	
	int componentName_columnWidth = getCharactersCountToDisplay(name_column);
	int componentType_columnWidth = getCharactersCountToDisplay(type_column);
	int agentName_columnWidth = getCharactersCountToDisplay(agent_name_column);
	String optionRange = iniUiObj.getValue("RESULTS_PER_PAGE","RANGE");
	int increment = Integer.parseInt(optionRange);
	String rowsPerPage[] = new String[optionCount+1];
	for(int i=0;i<=optionCount;i++)
	{
		int j=i+1;
		if(j==rowsPerPage.length)
			rowsPerPage[i] = "All";
		else
			rowsPerPage[i] = "" + j* increment;
	}
	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Agents Upgrade");
	/* code for auditlog ends */
	EgSpecsInfo egSpecsInfo = new EgSpecsInfo("manager");
	EgExternalInfo egExternalInfo = new EgExternalInfo("manager");
	EgDiscInfo egDiscInfo = new EgDiscInfo("manager");
	Hashtable ipHashtable = new Hashtable();
	String[] est = egSpecsInfo.getAllExternalServerTypes();
	String[] allextagents = egExternalInfo.getAllExternalAgents();
	Hashtable hostAgentMap = new Hashtable();

	String pageNoStr = request.getParameter("pageNo");
	if(pageNoStr == null || pageNoStr.equals("null") || pageNoStr.length() == 0)
	{
		session.removeAttribute("dispTable");
		pageNoStr = "1";
	}
	for(int d=0;d<est.length;d++)
	{
		String[] servers = egDiscInfo.getAllServersOfType (est[d]);
		for(int e=0;e<servers.length;e++)
		{
			String host = servers[e].substring(servers[e].indexOf(":")+1);
			host = host.substring(0,host.indexOf(":"));
			String[] extAgents = egExternalInfo.getExternalAgentsForHost(host);
			if(extAgents !=null && extAgents.length>0)
			{
				hostAgentMap.put(host,java.util.Arrays.asList(extAgents));
				for(int f=0;f<extAgents.length;f++)
				{
					if(!ipHashtable.containsKey(extAgents[f]))
					{
						ArrayList al = new ArrayList();
						al.add(host);
						ipHashtable.put(extAgents[f],al);
					}
					else
					{
						ArrayList al = (ArrayList) ipHashtable.get(extAgents[f]);
						al.add(host);
						ipHashtable.put(extAgents[f],al);
					}
				}
			}
		}
	}
	String[] remComps = egExternalInfo.getRemoteComponents();
	if(remComps != null && remComps.length > 0)
	{
		for(int m=0;m<remComps.length;m++)
		{
			String tmp = remComps[m];
			String tmp1 = egExternalInfo.getRemoteAgentForHost(tmp);
			String tmpIPAddress = egExternalInfo.getIpForRemoteAgent(tmp1);
			if(!ipHashtable.containsKey(tmpIPAddress))
			{
				ArrayList al = new ArrayList();
				al.add(tmp);
				ipHashtable.put(tmpIPAddress,al);
			}
			else
			{
				ArrayList al = (ArrayList) ipHashtable.get(tmpIPAddress);
				al.add(tmp);
				ipHashtable.put(tmpIPAddress,al);
			}
		}
	}
	int max_rows = IniUI.getInstance().getPermittedRowsForSorting();
	boolean agentFound = false;
	String swaped =  request.getParameter("swap_action");
	if(swaped==null || swaped.equalsIgnoreCase("null"))
	swaped = "false";
	IniUI ui = (IniUI)com.egurkha.ini.IniUI.getInstance();
	String refreshTime = ui.getRefreshTime("AutoUpgrade");
	try
	{
		refreshTime = (refreshTime != null && !refreshTime.equalsIgnoreCase("null") && refreshTime.length()>0)?refreshTime:"180";
		long temp = (new Long(refreshTime).longValue()) * 1000L;
		refreshTime = new Long(temp).toString();
	}
	catch(Exception e)
	{
		refreshTime = "180000";//default 3 minutes
	}
	String refreshStatus = 	request.getParameter("refresh_status");
	refreshStatus = (refreshStatus != null && !refreshStatus.equalsIgnoreCase("null") && refreshStatus.equals("on"))?"on":"off";
	String dateString ="";
	String currentTime = request.getParameter("currentTime");
	currentTime = (currentTime != null && !currentTime.equalsIgnoreCase("null"))?currentTime.trim():"";
	if(currentTime !=null && currentTime.length()>0)
	{
		dateString="currentTime";
	}
	AgentConfig agentConfig = AgentConfig.getAgentConfig();
	String sai = request.getParameter("sai");//sai - selected agent ids
	String currentOption = request.getParameter("option");
	String ugne = request.getParameter("default_upgrade_now_enabled");
	ugne = (ugne==null || ugne.equalsIgnoreCase("null")|| ugne.length()==0)?"No":ugne;//ugne - upgrade now enabled

	if(currentOption!=null && !currentOption.equalsIgnoreCase("null") && currentOption.length()>0)
	{
		ArrayList aListUpgradeEnableAgentIds = new ArrayList();
		//Changed By Inbaraj
		String fileName = "";
		IniFile servicesIniRead = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
		String autoUpgradeInfo = servicesIniRead.getValue("MISC_ARGS","AutoUpgradeInfo");
		if(autoUpgradeInfo !=null && !autoUpgradeInfo.equals("") && autoUpgradeInfo.equalsIgnoreCase("eg_autoupgrade"))
		{
			fileName = "eg_autoupgrade.ini";
		}
		else
		{
			fileName = "eg_tests.ini";
		}
		if(currentOption.equalsIgnoreCase("setAutoUpgrade"))
		{
			//IniFile ini_write1 = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/" + fileName, true);
			IniFile ini_write1 = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/" + fileName);
			StringTokenizer stoken = new StringTokenizer(sai,"$");
			boolean success = false;
			while(stoken.hasMoreTokens())
			{
				String aid = (String) stoken.nextToken();
				aListUpgradeEnableAgentIds.add(aid);
				//agentConfig.enableDisableAutoUpgrade(aid,"true");
				StringTokenizer stoken1 = new StringTokenizer(aid,":");
				while(stoken1.hasMoreTokens())
				{
					String temp1 = (String) stoken1.nextToken();
					ini_write1.deleteValue("UPGRADE_NOW",temp1.trim());
					success = true;
				}
				auditLogThread.setCurrentValue("Agent ID",aid);
			}
			if(success)
			{
				auditLogThread.setValue("Activity","Auto upgrade");
				auditLogThread.setValue("Description","Auto upgrade is enabled for agents");
				auditLogThread.sendItToDB();
			}
			if(aListUpgradeEnableAgentIds!=null && aListUpgradeEnableAgentIds.size()>0)
			{
				agentConfig.enableDisableAutoUpgrade(aListUpgradeEnableAgentIds,"true");
			}
			ini_write1.saveFile();
			EgConfigFilesSync.releaseInstance(ini_write1);
		}
		else if(currentOption.equalsIgnoreCase("resetAutoUpgrade"))
		{
			ArrayList aListUpgradeDisableAgentIds = new ArrayList();
			//IniFile ini_write1 = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini", true);
			IniFile ini_write1 = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/"+fileName);
			StringTokenizer stoken = new StringTokenizer(sai,"$");
			boolean success = false;
			while(stoken.hasMoreTokens())
			{
				String aid = (String) stoken.nextToken();
				aListUpgradeDisableAgentIds.add(aid);
				//agentConfig.enableDisableAutoUpgrade(aid,"false");
				StringTokenizer stoken1 = new StringTokenizer(aid,":");
				while(stoken1.hasMoreTokens())
				{
					String temp1 = (String) stoken1.nextToken();
					ini_write1.deleteValue("UPGRADE_NOW",temp1.trim());
					success = true;
				}
				auditLogThread.setCurrentValue("Agent ID",aid);
			}
			if(success)
			{
				auditLogThread.setValue("Activity","Auto upgrade");
				auditLogThread.setValue("Description","Auto upgrade is disabled for agents");
				auditLogThread.sendItToDB();
			}
			if(aListUpgradeDisableAgentIds!=null && aListUpgradeDisableAgentIds.size()>0)
			{
				agentConfig.enableDisableAutoUpgrade(aListUpgradeDisableAgentIds,"false");
			}
			ini_write1.saveFile();
			EgConfigFilesSync.releaseInstance(ini_write1);
		}
		else if(currentOption.equalsIgnoreCase("upgradeNow"))
		{
			aListUpgradeEnableAgentIds = new ArrayList();
			//IniFile ini_write1 = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini", true);
			IniFile ini_write1 = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/"+fileName);
			boolean success = false;
			if(ugne.equalsIgnoreCase("yes"))
			{
				StringTokenizer stoken = new StringTokenizer(sai,"$");
				int i=0;

				String allIds[] = new String[stoken.countTokens()];
				while(stoken.hasMoreTokens())
				{
					allIds[i++] = (String) stoken.nextToken();
				}
				for( i=0;i<allIds.length;i++)
				{
					//agentConfig.enableDisableAutoUpgrade(allIds[i],"true");
					aListUpgradeEnableAgentIds.add(allIds[i]);
					StringTokenizer stoken1 = new StringTokenizer(allIds[i],":");
					while(stoken1.hasMoreTokens())
					{
						String temp1 = (String) stoken1.nextToken();
						ini_write1.setValue("UPGRADE_NOW",temp1,temp1.trim());
						success = true;
					}
					auditLogThread.setCurrentValue("Agent ID",allIds[i]);
				}
				if(aListUpgradeEnableAgentIds!=null && aListUpgradeEnableAgentIds.size()>0)
				{
					agentConfig.enableDisableAutoUpgrade(aListUpgradeEnableAgentIds,"true");
				}
			}
			else
			{
					StringTokenizer stoken = new StringTokenizer(sai,"$");
					while(stoken.hasMoreTokens())
					{
						String aid = (String) stoken.nextToken();
						if(!agentConfig.isAutoUpgradeEnabled(aid.trim()))
						continue;
						StringTokenizer stoken1 = new StringTokenizer(aid,":");
						while(stoken1.hasMoreTokens())
						{
							String temp1 = (String) stoken1.nextToken();
							ini_write1.setValue("UPGRADE_NOW",temp1,temp1.trim());
							success = true;
						}
						auditLogThread.setCurrentValue("Agent ID",aid);
					}
			}
			if(success)
			{
				auditLogThread.setValue("Activity","Upgrade Now");
				auditLogThread.setValue("Description","Upgrade now is enabled for agents");
				auditLogThread.sendItToDB();
			}
			ini_write1.saveFile();
			EgConfigFilesSync.releaseInstance(ini_write1);
		}
		else
		{
			//IniFile ini_write1 = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini", true);
			IniFile ini_write1 = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/"+fileName);
			StringTokenizer stoken = new StringTokenizer(sai,"$");
			boolean success = false;
			while(stoken.hasMoreTokens())
			{
				String aid = (String) stoken.nextToken();
				StringTokenizer stoken1 = new StringTokenizer(aid,":");
				while(stoken1.hasMoreTokens())
				{
					String temp1 = (String) stoken1.nextToken();
					ini_write1.deleteValue("UPGRADE_NOW",temp1.trim());
					success = true;
				}
			}
			if(success)
			{
				auditLogThread.setValue("Activity","Upgrade Now");
				auditLogThread.setValue("Description","Upgrade now is disabled for agents");
				auditLogThread.sendItToDB();
			}
			ini_write1.saveFile();
			EgConfigFilesSync.releaseInstance(ini_write1);
		}
	}
	EgAgentInfo ai = new EgAgentInfo("manager");
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	String status = "";
	String agentName = "";
	Hashtable agentList = new Hashtable(25);
	Vector agentListWithStatus = agentConfig.getUpgradeStatusForAllAgents();
	IniFile externalIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_external.ini");
	IniFile ini_services = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
	IniFile egAgentsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini");
	String defaultUpgradeValue=ini_services.getValue("MISC_ARGS","DefaultAutoUpgrade");
	String allowQualifiedHostNames = ini_services.getValue("MISC_ARGS","AllowQualifiedHostNames");
	allowQualifiedHostNames = StringUtils.isNull(allowQualifiedHostNames)?"yes":allowQualifiedHostNames.trim();
	Hashtable statusHash = new Hashtable();
	ArrayList ipList = new ArrayList();
	for(int i=0;i<agentListWithStatus.size();i++)
	{
		StringTokenizer str1 = new StringTokenizer((String)agentListWithStatus.elementAt(i), ",");
		agentName = str1.nextToken();
		status = str1.nextToken();
		StringTokenizer str2 = new StringTokenizer(agentName, ":");
		String ipStr = "";
		while(str2.hasMoreTokens())
		{
			ipStr = str2.nextToken();
			statusHash.put(ipStr, status);
			ipList.add(ipStr);
		}
	}
	ArrayList validAgents = ai.getValidAgentsFromList (ipList);
	for (int i=0; i<validAgents.size(); i++)
	{
		String me = (String) validAgents.get(i);
		String st = (String) statusHash.get(me);
		if (st != null)
		{
			agentList.put(me,st);
		}
	}
	String selectedNickName = request.getParameter("nickname");
	String selectedTo = request.getParameter("to");
	String selectedFrom = request.getParameter("from");
	String selectedChoice = request.getParameter("choice");
	String selectedServerType = request.getParameter("servertype");
	String selectedStatus = request.getParameter("status");
	Vector v_allComps = discInfo.getAllManagedComponents();
	Vector v_compTypes = new Vector();
	for(int i=0;i<v_allComps.size();i++)
	{
		String s_component = (String)v_allComps.elementAt(i);
		String s_compTy = s_component.substring(0,s_component.indexOf(','));
		if(!v_compTypes.contains(s_compTy))
			v_compTypes.add(s_compTy);
	}
	String allComponents[] = (String[])v_compTypes.toArray(new String[0]);
%>
<html>
<head>
<META HTTP-EQUIV="expires" CONTENT="0">
<egui:skin ui="admin"/>
<script type="text/javascript" src ="/final/jquery/jquery.js"></script>
<script language="JavaScript">
function showImage(index)
{
	var result="asc";
	var hide = new Array();
	hide = document.getElementsByTagName("img");
	for (i=0; i<hide.length; i++)
	{
		img_id = hide[i].id;
		if(img_id==null || img_id.length==0)
			continue;
		img_id = img_id.substring(3);
		if(img_id==index)
		{
			src = hide[i].src;
			if(src.indexOf("headarrow_up.gif")=="-1")
			{
				hide[i].src="/final/admin/eg_images/headarrow_up.gif";
				result = "asc";
			}
			else
			{
				hide[i].src="/final/admin/eg_images/headarrow_down.gif";
				result = "des";
			}
			hide[i].style.display = '';
		}
		else if(img_id=="0")
		{
			// do nothing.
		}
		else
			hide[i].style.display = 'none';
	}
	return result;
}
var reverseSort = new Array(false,false,false,false,false,false,false,false,false,false);
var previousColumn  = 1;
var currentColumn = 1;
var res = "";
function sortTable(col)
{
	currentColumn = col;
	var tblEl = document.getElementById('rsTable');
	if(tblEl.rows.length > <%=max_rows%>)
	{
		clearCurrentLinks();
		return false;
	}
	if (col == previousColumn)
	previousColumn = col;
	var oldDsply = tblEl.style.display;
	tblEl.style.display = "none";
	res = showImage(col);
	if(res=="des")
	{
		reverseSort[col] = true;
	}
	else
	{
		reverseSort[col] = false;
	}
	var tmpEl;
	var i, j;
	var minVal, minIdx;
	var testVal;
	var cmp;

  for (i = 0; i < tblEl.rows.length - 1; i++)
	{
    // Assume the current row has the minimum value.
    minIdx = i;
    minVal = getTextValue(tblEl.rows[i].cells[col]);
    // Search the rows that follow the current one for a smaller value.
    for (j = i + 1; j < tblEl.rows.length; j++) {
      testVal = getTextValue(tblEl.rows[j].cells[col]);
      cmp = compareValues(minVal, testVal);
      // Negate the comparison result if the reverse sort flag is set.
      if (reverseSort[col])
        cmp = -cmp;
      // Sort by the second column (team name) if those values are equal.
      if (cmp == 0 && col != 1)
        cmp = compareValues(getTextValue(tblEl.rows[minIdx].cells[1]),
                            getTextValue(tblEl.rows[j].cells[1]));
      // If this row has a smaller value than the current minimum, remember its
      // position and update the current minimum value.
      if (cmp > 0) {
        minIdx = j;
        minVal = testVal;
      }
    }
    // By now, we have the row with the smallest value. Remove it from the
    // table and insert it before the current row.
    if (minIdx > i) {
      tmpEl = tblEl.removeChild(tblEl.rows[minIdx]);
      tblEl.insertBefore(tmpEl, tblEl.rows[i]);
    }
  }
/* for giving alternate row color */
for (i = 0; i < tblEl.rows.length; i++)
{
	rowEl = tblEl.rows[i];
	rowEl.className = rowEl.className.replace(rowEl.className, "");
	if (i % 2 != 0)
	{
		rowEl.className = "eg_lightlight"
	}
	else
	{
		rowEl.className = "main_bodybg";
	}
	for (j = 1; j < tblEl.rows[i].cells.length; j++)
	{
		cellEl = rowEl.cells[j];
		cellEl.className = cellEl.className.replace(rowEl.className, rowEl.className);
		if (j == col)
		{
			if(res=="asc")
			{
				//cellEl.className = "eg_subcontentbg";//this is for color
				cellEl.className = "vertical_line_border";//this is for line border around selected column
			}
			else
			{
				//cellEl.className = "eg_innerbody";//this is for color
				cellEl.className = "vertical_line_border";//this is for line border around selected column
			}
		}
		else
		{
			cellEl.className = rowEl.className;
		}
		if (i == tblEl.rows.length-1 && j==col)//this is for bottom line to the last cell of selected column
		{
			cellEl = rowEl.cells[j];
			cellEl.className = cellEl.className.replace(rowEl.className, rowEl.className);
			cellEl.className = "bottom_line_border";
		}
	}
}
  // Restore the table's display style.
  tblEl.style.display = oldDsply;
  return false;
}

//-----------------------------------------------------------------------------
// Functions to get and compare values during a sort.
//-----------------------------------------------------------------------------

// This code is necessary for browsers that don't reflect the DOM constants
// (like IE).
if (document.ELEMENT_NODE == null) {
  document.ELEMENT_NODE = 1;
  document.TEXT_NODE = 3;
}

function getTextValue(el) {
  var i;
  var s;

  // Find and concatenate the values of all text nodes contained within the
  // element.
  s = "";
  for (i = 0; i < el.childNodes.length; i++)
    if (el.childNodes[i].nodeType == document.TEXT_NODE)
      s += el.childNodes[i].nodeValue;
    else if (el.childNodes[i].nodeType == document.ELEMENT_NODE &&
             el.childNodes[i].tagName == "BR")
      s += " ";
    else
      // Use recursion to get text within sub-elements.
      s += getTextValue(el.childNodes[i]);

  return normalizeString(s);
}

function compareValues(v1, v2) {
  var f1, f2;
  // If the values are numeric, convert them to ints/floats. ie, parseInt/parseFloat
	if(currentColumn == 6)
	{
		if(v1.indexOf(".")!=-1)
		{
			a = "";
			for(b=0;b<v1.length;b++)
			{
				ch = v1.charAt(b);
				if(ch!='.')
				a=a+ch;
			}
			v1 = a;
		}
		if(v2.indexOf(".")!=-1)
		{
			a = "";
			for(b=0;b<v2.length;b++)
			{
				ch = v2.charAt(b);
				if(ch!='.')
				a=a+ch;
			}
			v2 = a;
		}
	}
	v1 = v1.toUpperCase();
	v2 = v2.toUpperCase();

  f1 = parseFloat(v1);
  f2 = parseFloat(v2);
  if (!isNaN(f1) && !isNaN(f2)) {
    v1 = f1;
    v2 = f2;
  }
  // Compare the two values.
  if (v1 == v2)
    return 0;
  if (v1 > v2)
    return 1
  return -1;
}

// Regular expressions for normalizing white space.
var whtSpEnds = new RegExp("^\\s*|\\s*$", "g");
var whtSpMult = new RegExp("\\s\\s+", "g");
function normalizeString(s) {
  s = s.replace(whtSpMult, " ");  // Collapse any multiple whites space.
  s = s.replace(whtSpEnds, "");   // Remove leading or trailing white space.
  return s;
}

</script>
<script language="JavaScript">
function displayTable(totalPages)
{
		var pageNoFirst = '<%=pageNoStr != null ? pageNoStr : "1"%>';
		var pageNo = parseInt(pageNoFirst);
		var j = parseInt(pageNoFirst);

		if (j > 1)
			j = j - 5;

		if (j < 1)
			j = 1;

		var upperLimit;
		var next = "next";
		var prev = "prev";
		var first = "first";
		var last = "last";
		upperLimit = parseInt(totalPages);

		document.write("<table align=\"center\" border=\"0\" cellpadding=\"6\">");
		document.write("<tr>");
		if (pageNo > 1)
		{
			document.write("<td>");
			document.write("<a id=\"eg_monlink\" href=\"javascript:getPageNo('"+first+"',"+totalPages+")\"><img src=\"/final/admin/eg_images/back-arrow.gif\" border=\"0\"><img src=\"/final/admin/eg_images/back-arrow.gif\" border=\"0\">&nbsp;<b><egui:intnl text='admin.common.First'/></b></a>");
			document.write("</td>");
		}
		else
		{
			document.write("<td>");
			document.write("<img src=\"/final/admin/eg_images/back-arrow.gif\" border=\"0\">");
			document.write("<img src=\"/final/admin/eg_images/back-arrow.gif\" border=\"0\">");
			document.write("&nbsp;");
			document.write("<egui:intnl text='admin.common.First'/>");
			document.write("</td>");
		}
		document.write("<td>&nbsp;");
		document.write("</td>");
		if (pageNo > 1)
		{
			document.write("<td>");
			document.write("&nbsp;<a id=\"eg_monlink\" href=\"javascript:getPageNo('" + prev + "',"+totalPages+")\"><img src=\"/final/admin/eg_images/back-arrow.gif\" border=\"0\">&nbsp;<b><egui:intnl text='admin.common.Prev'/></b></a>");
			document.write("</td>");
		}
		else
		{
			document.write("<td>");
			document.write("<img src=\"/final/admin/eg_images/back-arrow.gif\" border=\"0\">");
			document.write("&nbsp;");
			document.write("<egui:intnl text='admin.common.Prev'/>");
			document.write("</td>");
		}
		document.write("<td>");
		for (var i = 0; i < 10; i++)
		{
			if (j <= upperLimit)
			{
				document.write("&nbsp;&nbsp;");
				if (pageNo != j)
				{
					document.write("<a id=\"eg_monlink\" href=\"javascript:getPageNo("+j+","+totalPages+")\">" + j + "</a>");
				}
				else
				{
					document.write("<span id=\"page_no\">"+j+"</span>");

				}
				document.write("&nbsp;&nbsp;");
			}
			j++;
		}
		document.write("</td>");
		if (pageNo < upperLimit)
		{
			document.write("<td>");
			document.write("<a id=\"eg_monlink\" href=\"javascript:getPageNo('"+next+"',"+totalPages+")\"><b><egui:intnl text='admin.common.Next'/></b>&nbsp;<img src=\"/final/admin/eg_images/forward-arrow.gif\" border=\"0\"></a>");
			document.write("</td>");
		}
		else
		{
			document.write("<td>");
			document.write("<egui:intnl text='admin.common.Next'/>");
			document.write("&nbsp;");
			document.write("<img src=\"/final/admin/eg_images/forward-arrow.gif\" border=\"0\">");
			document.write("</td>");
		}
		document.write("<td>&nbsp;");
		document.write("</td>");
		if (pageNo < upperLimit)
		{
			document.write("<td>");
			document.write("&nbsp;<a id=\"eg_monlink\" href=\"javascript:getPageNo('"+last+"',"+totalPages+")\"><b><egui:intnl text='admin.common.Last'/></b>&nbsp;<img src=\"/final/admin/eg_images/forward-arrow.gif\" border=\"0\"><img src=\"/final/admin/eg_images/forward-arrow.gif\" border=\"0\"></a>");
			document.write("</td>");
		}
		else
		{
			document.write("<td>");
			document.write("&nbsp;<egui:intnl text='admin.common.Last'/>");
			document.write("&nbsp;");
			document.write("<img src=\"/final/admin/eg_images/forward-arrow.gif\" border=\"0\">");
			document.write("<img src=\"/final/admin/eg_images/forward-arrow.gif\" border=\"0\">");
			document.write("</td>");
		}
		document.write("</tr>");
		document.write("</table>");
}
function getPageNo(key,totalPages)
{
		var pagaNoStr = '<%=pageNoStr != null ? pageNoStr :"1"%>';
		var pageNo = parseInt(pagaNoStr);
		var upperLimit;
		upperLimit = parseInt(totalPages);
		if (key == "next")
		{
			if (pageNo >= upperLimit)
				pageNo = upperLimit;
			else
				pageNo = pageNo + 1;
		}
		else if (key == "prev")
		{
			if (pageNo <= 1)
				pageNo = 1;
			else
				pageNo = pageNo - 1;
		}
		else if (key == "first")
		{
			pageNo = 1;
		}
		else if (key == "last")
		{
			pageNo = upperLimit;
		}
		else
		{
			pageNo = key;
		}
		//new change
		document.pagination.pageNo.value = pageNo;
		document.pagination.submit();
	//End of new change
	}

function checkAll()
{
	var thisForm=window.document.aip;
	var select = thisForm.selectAll.checked;
	for(i=0;i<thisForm.elements.length;i++)
	{
		if(thisForm[i].type=="checkbox" && thisForm[i].name!="selectAll")
			thisForm[i].checked = select;
	}
}
function checkAllSelected()
{
	var thisForm=window.document.aip;
	for(i=0;i<thisForm.elements.length;i++)
	{
		if(thisForm[i].type=="checkbox" && thisForm[i].name!="selectAll" && !thisForm[i].checked)
			return false;
	}
	return true;
}
function checkItem(ctrl)
{
	var thisForm=window.document.aip;
	var flag = ctrl.checked;
	if(flag)
		thisForm.selectAll.checked = checkAllSelected();
	else
		thisForm.selectAll.checked = false;
}
function goes()
{
	var to_result = "true";
	var from_result = "true";
	var thisForm = window.document.aip;
	var nickname =  thisForm.nickname.value;
	var to = thisForm.to.value;
	var from =  thisForm.from.value;
	var choice = thisForm.choices.options[thisForm.choices.selectedIndex].value;
	var servertype = thisForm.servertypes.options[thisForm.servertypes.selectedIndex].value;
	var status = thisForm.status.options[thisForm.status.selectedIndex].value;
	var a = '';
	var b = '';
	if(choice=="Range")
	{
		if(from.length==0)
		{
			alert('<egui:intnl text="admin.upgrade.From field cannot be empty" />.');
			thisForm.from.focus();
			return;
		}
		if(to.length==0)
		{
			alert('<egui:intnl text="admin.upgrade.To field cannot be empty" />.');
			thisForm.to.focus();
			return;
		}
	}
	if(from.length > 0 && !isValidIPAddress(from))
	{
		if(document.getElementById("hideto").style.display != 'none')
			alert('<egui:intnl text="admin.upgrade.From IP Address is not valid" />.');
		else
			alert('<egui:intnl text="admin.upgrade.IP Address is not valid" />.');
		from_result = "false";
		thisForm.from.focus();
		document.getElementById("fromid").select();
		return;
	}
	var colon_array1,colon_array2;
	if(from.length > 0 && isValidIPAddress(from))
	{
		colon_array1 = from.split('.');
		//a = '';
		//for(i=0;i<array.length;i++)
		//{
		//	a +=array[i];
		//}
	}
	if(document.getElementById("hideto").style.display != 'none')
	{
		if(to.length > 0 && !isValidIPAddress(to))
		{
			alert('<egui:intnl text="admin.upgrade.To IP Address is not valid" />.');
			to_result = "false";
			thisForm.to.focus();
			document.getElementById("toid").select();
			return;
		}
	}
	if(document.getElementById("hideto").style.display != 'none')
	{
		if(to.length > 0 && isValidIPAddress(to))
		{
			colon_array2 = to.split(".");
			
			//b = '';
			//for(i=0;i<array.length;i++)
			//{
			//	b +=array[i];
			//}
			//aa = parseInt(a);
			//bb = parseInt(b);

			//if(bb-aa < 0)
			//{
			//	alert('<egui:intnl text="Invalid range" />.');
			//	thisForm.to.focus();
			//	document.getElementById("toid").select();
			//	return;
			//} 
			
			var colonArr1, colonArr2;
			for(var m=0;m < colon_array1.length;m++)
			{
				colonArr1 = parseInt(colon_array1[m],10);
				colonArr2 = parseInt(colon_array2[m],10); 
				
				if ( colonArr2 > colonArr1 )
				{
					break;
				}
				else if( colonArr2 < colonArr1 )
				{
					alert('<egui:intnl text="admin.upgrade.Invalid range" />.');
					thisForm.to.focus();
					document.getElementById("toid").select();
					return;
				}
			}
		}
	}
	if(from_result=="true" && to_result=="true")
	{
		if(from.length>0)
		{
			nickname = '';
			servertype = 'all';
			status = 'all';
		}
		thisForm.make_enabled_ids.value = make_enabled_ids;
		var url = "agentsUpgradeAdvancedSearch.jsp?nickname="+encodeURI(nickname)+"&to="+to+"&from="+from+"&choice="+choice+"&servertype="+encodeURI(servertype)+"&status="+status+"&secondtime=true&option="+g_label+"&sai="+encodeURI(selectedAgentIDs)+"&default_upgrade_now_enabled="+default_upgrade_now_enabled;
		thisForm.action = url;
		thisForm.submit();
	}
}

function setRange()
{
	var thisForm = document.aip;
	var choice = thisForm.choices[thisForm.choices.selectedIndex].value;
	if(choice=="Single")
	{
		document.getElementById("hideto").style.display = 'none';
		document.getElementById("hidefrom").style.display = 'none';
	}
	else
	{
		document.getElementById("hideto").style.display = '';
		document.getElementById("hidefrom").style.display = '';
	}
}

function isValidIPAddress(ipAddress)
{
	var a = ipAddress.split(".");
	if(a.length!=4)
		return false;

	for(i=0;i<a.length;i++)
	{
		if(parseInt(a[i]) > 255 || parseInt(a[i]) < 0 )
			return false;
	}
	return checkNumber(a);
}

function checkNumber(a)
{
	var numbers = ".0123456789";
	var result = true;
	for( i=0; i<a.length; i++)
	{
		for(j=0;j<a[i].length;j++)
		{
			cha = numbers.indexOf(a[i].substring(j,1));
			if(cha == -1)
			{
				result = false;
				break;
			}
		}
	}
	return result;
}

var g_label="";
var selectedAgentIDs = "";
var default_upgrade_now_enabled="";
function removeDuplicates(a)
{
	var b = new Array();
	for( i=0; i<a.length; i++ )
	{
		temp = b.toString();
		if(temp.indexOf(a[i])==-1)
		{
			 b.push(a[i]);
		}
	}
	return b;
}

function clearr()
{
	var thisForm = window.document.aip;
	thisForm.from.value = "";
	thisForm.nickname.value = "";
	if(thisForm.to.display!='none')
	thisForm.to.value = "";
	thisForm.status.value = "";
	thisForm.refresh_status.value = "off";
	thisForm.action = "agentsUpgradeAdvancedSearch.jsp";
	thisForm.submit();
}
	var make_enabled_ids = "";
function update(label)
{
	var thisForm = window.document.aip;
	var a = new Array();
	for(i=0;i<thisForm.elements.length;i++)
	{
		if(thisForm[i].type=="checkbox" && thisForm[i].name =="opt" && thisForm[i].checked)
		{
			a.push(thisForm[i].value);
		}
	}
	if(a.length==0)
	{
		alert('<egui:intnl text="admin.upgrade.No agents selected" />.');
		return;
	}
	if(a.length>1)
	{
		a = removeDuplicates(a);
	}

	for(i=0;i<a.length;i++)
	{
		selectedAgentIDs += a[i] + "$"; // dont use # symbol instead of $
	}
	if(selectedAgentIDs.length>0)
	{
		if(label=="upgradeNow")
		{
			selected_indices = tableDetails();
			if(selected_indices.length > 0 )
			{
				if(confirm('Some of the agents that you have selected have auto upgrade disabled.\nAre you sure you want to upgrade all selected agents now?'))
				{
					default_upgrade_now_enabled = "Yes";
				}
				else
				{
					default_upgrade_now_enabled = "No";
				}
				make_enabled_ids = selected_indices;
			}
		}
		selectedAgentIDs = selectedAgentIDs.substring(0,selectedAgentIDs.lastIndexOf("$"));
		g_label = label;
		goes();
	}
}

function tableDetails()
{
	var table = document.getElementById('rsTable');
	var arr = new Array();
	var checked_ids = "";
	for (i=0; i < table.rows.length; i++)
	{
		var row1 = getTableRow ( table, i);
		if ( row1 )
		{
			/* for checked checkbox(s) */
			var cell1 = '';
			if(swapAction=="true")
				cell1 = getTableRowCell(row1, 10);
			else
				cell1 = getTableRowCell(row1, 0);
			if ( cell1 )
			{
				var chkkbox = document.getElementById("eg_input");
				if (chkkbox.type)
				{
					if ( chkkbox.type == 'checkbox')
					{
						if (chkkbox.checked)
						{
							chkvalue =chkkbox.value;
							autoup = getTextValue(table.rows[i].cells[4]);
							upnow = getTextValue(table.rows[i].cells[5]);
							if(autoup.indexOf("Disabled")!=-1 && upnow.indexOf("Disabled")!=-1)
							{
								checked_ids += chkvalue + "$";
							}
						}
					}
				}
			}
		}
	}
	if(checked_ids.length > 0)
	{
		checked_ids = checked_ids.substring(0,checked_ids.lastIndexOf("$"));
	}
	return checked_ids;
}

function getTableRow ( table, rowIndex)
{
	var row = null;
	if (table.rows[rowIndex])
	{
		row = table.rows[rowIndex];
	}
	else
	{
		row = null;
	}
	return row;
}

function getTableRowCell ( row, cellIndex )
{
	var cell = null;
	if ( row.cells[cellIndex] )
	{
		cell = row.cells[cellIndex];
	}
	else
	{
		cell = null;
	}
	return cell;
}

var timerID = 0;
var tStart  = null;
function refresh_this_page()
{
	var thisForm = window.document.aip;
	if(thisForm.refresh_button.value=="<egui:intnl text='admin.upgrade.Set Refresh On'/>")
	{
		thisForm.refresh_button.value = "<egui:intnl text='admin.upgrade.Set Refresh Off'/>";
		thisForm.refresh_status.value="on";
		if(typeof refreshinfo != 'undefined')
		{
			document.getElementById('refreshinfo').style.display='';
		}
		window.document.aip.currentTime.value = "deleteit";
		goes();
	}
	else
	{
		thisForm.refresh_button.value = "<egui:intnl text='admin.upgrade.Set Refresh On'/>";
		thisForm.refresh_status.value="off";
		if(typeof refreshinfo != 'undefined')
		{
			document.getElementById('refreshinfo').style.display='none';
		}
	}
}

function Start()
{
	displayTime();
	tStart   = new Date();
	timerID  = setTimeout("UpdateTimer()", <%=refreshTime%>);
}

	var temp = "<%=refreshTime%>";
function displayTime()
{
	num = parseInt(temp);
	var hour = 0;
	var min = 0;
	var sec = 0;

	tseconds = parseInt(num/1000);
	if(parseInt(tseconds)>=3600)
	hour = parseInt(tseconds /3600);
	tseconds = parseInt(tseconds) - parseInt(hour) * 3600 ;
	if(parseInt(tseconds)>=60)
	min = parseInt(tseconds /60);

	sec = tseconds % 60;

	var timeString="";

	if(parseInt(hour)>0)
	{
		if(parseInt(hour)<10)
		timeString = '0' + hour + " Hrs ";
		else
		timeString = hour + " Hrs ";
	}

	if(parseInt(min)>0)
	{
		if(parseInt(min)<10)
		timeString += '0' + min + " Mins ";
		else
		timeString += min + " Mins ";
	}

	if(parseInt(sec)>0)
	{
		if(parseInt(sec)<10)
		timeString += '0' + sec + " Secs";
		else
		timeString += sec + " Secs";
	}

	if(typeof refreshinfo != 'undefined')
	document.getElementById('refreshinfo').innerHTML = "<table border=\"0\" width=\"100%\" align=\"left\"><tr><td style='padding-left:3px'><strong>Next Refresh in : "+timeString+"</strong></td></tr></table>";

	if(num==0)
	{
		temp = "<%=refreshTime%>";
		num = parseInt(temp);
	}
	temp = (parseInt(temp)-1000);
	window.document.aip.currentTime.value = "deleteit";
	setTimeout('displayTime()', 1000);
}

function Stop()
{
	if(timerID)
	{
		clearTimeout(timerID);
		timerID  = 0;
	}
	tStart = null;
}

function Reset()
{
	tStart = null;
}

function UpdateTimer()
{
	if(timerID)
	{
		clearTimeout(timerID);
	}
	timerID = setTimeout("UpdateTimer()", <%=refreshTime%>);
	window.document.aip.currentTime.value = "deleteit";
	goes();
}

function justcall()
{
	if('<%=refreshStatus%>'=="on")
	{
		Start();
		window.document.aip.refresh_status.value="on";
		window.document.aip.refresh_button.value="<egui:intnl text='admin.upgrade.Set Refresh Off'/>";
		if(typeof refreshinfo != 'undefined')
		{
			document.getElementById('refreshinfo').style.display='';
		}
	}
	else
	{
		if(typeof refresh_status != 'undefined')
		window.document.aip.refresh_status.value="off";
		window.document.aip.refresh_button.value="<egui:intnl text='admin.upgrade.Set Refresh On'/>";
		if(typeof refreshinfo != 'undefined')
		{
			document.getElementById('refreshinfo').style.display='none';
		}
		Reset();
	}
}

var swapAction = "false";
function swapColumns (colIndex1, colIndex2)
{
	if(swapAction=="false")
		swapAction = "true";
	else
		swapAction="false";
	window.document.aip.swap_action.value=swapAction;
	hide = document.getElementsByTagName("img");
	for (i=0; i<hide.length; i++)
	{
		img_id = hide[i].id;
		img_id = img_id.substring(3);
		if(img_id=="0")
		{
			src = hide[i].src;
			if(src.indexOf("headarrow_forward.gif")=="-1")
			{
				hide[i].src="/final/admin/eg_images/headarrow_forward.gif";
			}
			else
			{
				hide[i].src="/final/admin/eg_images/headarrow_back.gif";
			}
		}
	}

	table = document.getElementById('rsTable');
	if (table && table.rows && table.insertBefore && colIndex1 != colIndex2)
	{
		colIndex1 = Number(colIndex1);
		colIndex2 = Number(colIndex2);
		if (colIndex1 == colIndex2 - 1 || colIndex1 == colIndex2 + 1)
		{
			if (colIndex1 > colIndex2)
			{
				var tempIndex = colIndex1;
				colIndex1 = colIndex2;
				colIndex2 = tempIndex;
			}
			for (var i = 0; i < table.rows.length; i++)
			{
				var row = table.rows[i];
				row.insertBefore(row.cells[colIndex2], row.cells[colIndex1]);
			}
		}
		else
		{
			for (var i = 0; i < table.rows.length; i++)
			{
				var row = table.rows[i];
				var cell1 = row.cells[colIndex1];
				var cell2 = row.cells[colIndex2];
				var siblingCell1 = row.cells[colIndex1 + 1];

				var tdId = "tdA"+row.id.substring(row.id.length-1);
				if (document.getElementById(tdId) != null && document.getElementById(tdId) != undefined)
				{
					if (document.getElementById(tdId).style != null && 
						document.getElementById(tdId).style != undefined)
					{
						document.getElementById(tdId).style.borderLeft="0px";
					}
				}

				if (typeof siblingCell1 == 'undefined')
				{
					siblingCell1 = null;
				}
					row.insertBefore(cell1, cell2);
					row.insertBefore(cell2, siblingCell1);
			}
		}
	}

// this is for heading
	table = document.getElementById('thead');
	if (table && table.rows && table.insertBefore && colIndex1 != colIndex2)
	{
		colIndex1 = Number(colIndex1);
		colIndex2 = Number(colIndex2);
		for (var i = 0; i < table.rows.length; i++)
		{
			var row = table.rows[i];
			var cell1 = row.cells[colIndex1];
			var cell2 = row.cells[colIndex2];
			var siblingCell1 = row.cells[colIndex1 + 1];
			if (typeof siblingCell1 == 'undefined')
			{
				siblingCell1 = null;
			}
				row.insertBefore(cell1, cell2);
				row.insertBefore(cell2, siblingCell1);
		}
	}
}
</script>
<script language="JavaScript">
	function clearCurrentLinks()
	{
		j=0;
		table_available = false;

		var a = new Array();
		var arr =  new Array();

		a = document.getElementsByTagName("thead");
		for(i=0;i<a.length;i++)
		{
			if(a[i].id=="thead")
			{
				b = a[0].getElementsByTagName("a");
				table_available = true;
				break;
			}
		}

		if(!table_available)
		return;

		for(i=0;i<b.length;i++)
		{
			if(b[i].id=="vladi")
				arr[j++] = b[i];
		}

		d = (arr.length>0)?true:false;
		while(d)
		{
			removeNode(arr[0]);

			j=0;
			arr =  new Array();

			b = a[0].getElementsByTagName("a");
			for(i=0;i<b.length;i++)
				if(b[i].id=="vladi")
					arr[j++] = b[i];

			d = (arr.length>0)?true:false;
		}
	}

	function removeNode(n)
	{
		if(n.hasChildNodes())
		for(var i=0;i<n.childNodes.length;i++)
		n.parentNode.insertBefore(n.childNodes[i].cloneNode(true),n);
		n.parentNode.removeChild(n);
	}


	var $j = jQuery.noConflict();

	function tdWidth() {

		var winWidth = $j(window).width()-100;
		var winHeight = $j(window).height();

		$j(".tableWidth").width(winWidth+30);

		$j(".divWidth1").width(winWidth *(3/100));
		$j(".divWidth2").width(winWidth *(13/100));
		$j(".divWidth3").width(winWidth *(13/100));
		$j(".divWidth4").width(winWidth *(12/100));
		$j(".divWidth5").width(winWidth *(8/100));
		$j(".divWidth6").width(winWidth *(8/100));
		$j(".divWidth7").width(winWidth *(7/100));
		$j(".divWidth8").width(winWidth *(9/100));
		$j(".divWidth9").width(winWidth *(13/100));
		$j(".divWidth10").width(winWidth *(13/100));
	}

	$j(document).ready(function(){
		tdWidth();
	});

	$j(window).resize(function(){
		tdWidth();
	});


</script>
</head>
<body bgcolor="#FFFFFF" leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" onLoad="justcall()" style="overflow:auto" scroll="auto">
<table border="0" align="center" cellspacing="0" cellpadding="0" width="100%" >
	<jsp:include page="listSearch.jsp?title=AGENTS UPGRADE - ADVANCED SEARCH&leftString=false&backButton=false&subtitle=false"/>
	<tr>
		<td width="100%" align="center" valign="top">
			<form name="aip" method="post" style="margin:0px">
			<table width="100%" border="0" cellpadding="0" cellspacing="0">
				<tr>
					<td valign="top"  width="100%" align="left">
						<table width="85%"  align="center" valign="top" border="0"  class="eg_subcontent tableWidth" cellpadding="0" cellspacing="0">
							<tr>
								<td colspan="3" align="right"> * <egui:intnl text="admin.upgrade.denotes optional"/>
								</td>
							</tr>

							<tr>
								<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg"  width="100%"  valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" id="inner_top_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>

							<tr>
								<td width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td class="eg_subcontentbg">
									<table border="0" cellspacing="0" cellpadding="0" width="100%" style="table-layout:auto">
										<tr>
											<!-- <td align="left" style="width:10px">&nbsp;</td> -->
											<td align="right" height="30" nowrap><b><egui:intnl text="admin.upgrade.Component name"/></b>*&nbsp;<!-- <br> --></td>
											<td align="left" width="125"><input type="text" name="nickname" style='font-size:11px;font-family:Verdana,Arial;' value="<%=(selectedNickName!=null)?selectedNickName:""%>"></td>
											<td align="right"><b><egui:intnl text="admin.upgrade.Component type"/></b>*&nbsp;<!-- <br> --></td>
											<td align="left"  width="150"><select name="servertypes" style='font-size:11px;border:1;font-family:Verdana,Arial;' >
											<option value="all"><egui:intnl text="admin.upgrade.All"/></option>
<%
										ArrayList serverList = new ArrayList();
										String userLanguage = _user.getLanguage();
										IniUI  iniUI = IniUI.getInstance();
										if (userLanguage == null)
											userLanguage = iniUI.getDefaultLanguage();

										MappingNameSorter sorter = new MappingNameSorter(userLanguage);
										serverList = sorter.getSortedCompTypeList(allComponents);
										for(int i=0;i<serverList.size();i++)
										{
											EgName nameObj = (EgName)serverList .get(i);
											String tmpVal = nameObj.getActualName();
											if(aggregateTypes.size()>0 && aggregateTypes.contains(tmpVal))
												continue;
											String tmpDis = nameObj.getLocalName();

											String selected ="";
											selected = (selectedServerType!=null && selectedServerType.trim().equalsIgnoreCase(tmpVal))?"selected":"";
%>
												<option value="<%=tmpVal%>" <%=selected%>><%=tmpDis%></option>
<%
										}
%>
											</select>
											</td>
<%
								String tempStatus[] ={"All","Auto Upgrade Enabled","Auto Upgrade Disabled","Upgrade Now Enabled","Upgrade Now Disabled"};
%>
											<td align="right" ><b><egui:intnl text="admin.upgrade.Status"/></b>*&nbsp;</td>
											<td align="left" width="140">
											<select name="status" style="width:160px">
<%
									for(int i=0;i<tempStatus.length;i++)
									{
										if(tempStatus[i].equalsIgnoreCase("All"))
										{
%>
											<option value="<%=tempStatus[i]%>" <%=(selectedStatus!=null && selectedStatus.trim().equalsIgnoreCase(tempStatus[i]))?"selected":""%>><egui:intnl text="admin.upgrade.All"/></option>
<%
										}
										else
										{
%>
											<option value="<%=tempStatus[i]%>" <%=(selectedStatus!=null && selectedStatus.trim().equalsIgnoreCase(tempStatus[i]))?"selected":""%>><egui:intnl text='<%="admin.upgrade."+tempStatus[i]%>'/></option>
<%
										}
									}
%>
											</select>
											</td>
										</tr>
										<tr>
											<td width="100%" colspan="6" class="main_bodybg"  align="center" height="24"><b>(<egui:intnl text="admin.upgrade.OR"/>)</b></td>
										</tr>
										<tr>
											<!-- <td align="left" style="width:10px">&nbsp;</td> -->
												<td height="30" align="right"><b><egui:intnl text="admin.upgrade.IP address"/></b>*<!-- <br> -->&nbsp;</td>
												<td height="30" colspan="3">
													<table cellpadding="0px" cellspacing="0px" border="0" width="100%">
														<tr>
															<td width="15%">
																<select name="choices" onChange="javascript:setRange();">
																	<option  value="Single" <%=(selectedChoice!=null && selectedChoice.trim().equalsIgnoreCase("Single"))?"selected":""%>><egui:intnl text="admin.upgrade.Single"/></option>
																	<option  value="Range" <%=(selectedChoice!=null && selectedChoice.trim().equalsIgnoreCase("Range"))?"selected":""%>><egui:intnl text="admin.upgrade.Range"/></option>
																</select>
															</td>
															<td width="85%">
																<table cellpadding="0px" cellspacing="0px" border="0">
																	<!-- <td align="left" colspan="2" > -->
																	<!-- <table cellpadding="0px" cellspacing="0px" border="0"> -->
																	<tr>
																		<td align="left" style="padding-left:15px"><b id="hidefrom" style="display:none;"><egui:intnl text="admin.upgrade.From"/>&nbsp;</b><input id="fromid" type="text" name="from" style="" value="<%=(selectedFrom!=null)?selectedFrom:""%>">
																		</td>
																		<td id="hideto" style="display:none;">&nbsp;&nbsp;<b><egui:intnl text="admin.upgrade.To"/>&nbsp;</b><input id="toid" type="text" name="to" style="" value="<%=(selectedTo!=null)?selectedTo:""%>">
																		</td>
																	</tr>
																</table>
															</td>
														</tr>
													</td>
												</tr>
											</table>
											</td>
											<td align="left" colspan="2"><table cellspacing="0" cellpadding="0" border="0"><tr><td> <b><egui:intnl text="admin.upgrade.Results per page"/>&nbsp;</td>
											<td align="left"> <select name="rowsperpage">
<%
												String rowCount = request.getParameter("rowsperpage");
												if(rowCount == null || rowCount.equals("null"))
													rowCount = rowsPerPage[0];
												for(int i=0;i<rowsPerPage.length;i++)
												{
													if(rowsPerPage[i].equalsIgnoreCase("All"))
													{
%>
														<option value="<%=rowsPerPage[i]%>" <%=rowsPerPage[i].equals(rowCount)?"selected":""%>><egui:intnl text="admin.upgrade.All"/></option>
<%
													}
													else
													{
%>
														<option value="<%=rowsPerPage[i]%>" <%=rowsPerPage[i].equals(rowCount)?"selected":""%>><%=rowsPerPage[i]%></option>
<%
													}
												}
%>
												</select>
											</td>
											</tr>
											</table>
											</td>
										</tr>
										<!-- <tr>
											<td width="100%" colspan="7"  height="2" id="eg_blankspace" class="eg_innerbody">&nbsp;</td>
										</tr> -->
									</table>
								</td>
								<td width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
							</tr>
							<tr>
								<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
								<td id="eg_subcontentbg"  width="100%"  valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
								<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td height="10">&nbsp;</td>
				</tr>
				<tr>
					<td align="center" >
					<input type="button" name="go" value='<egui:intnl text="admin.upgrade.Search"/>' style="width:80px" class="eg_darkbutton" onClick="javascript:goes();">&nbsp;&nbsp;
					<input type="button" name="clear" value='<egui:intnl text="admin.upgrade.Clear"/>' style="width:80px" class="eg_darkbutton" onClick="javascript:clearr();">&nbsp;&nbsp;
					<input type="button" name="refresh_button" value='<egui:intnl text="admin.upgrade.Set Refresh On"/>' style="<%=refreshButtonWidth%>" class="eg_darkbutton" onClick="javascript:refresh_this_page();">
					</td>
				</tr>
				<tr>
					<td width="100%"  height="10"  id="eg_blankspace" >&nbsp;</td>
				</tr>
			<%
				if(request.getParameter("secondtime") != null)
				{
					//Hashtable agentDetails = new Hashtable();
					String [] agentDetailsArr = {"AutoUpgrade","LastUpgradedPackage","LastUpgradedTime","HostName","OS","Version","JRE Version","StartupTime"};

					ArrayList dispTable = (ArrayList)session.getAttribute("dispTable");
					if(dispTable == null)
					{
						dispTable = getAgentDetailsToDisplay(request, agentConfig, remComps, egExternalInfo, agentList, hostAgentMap, ipHashtable, allowQualifiedHostNames);
						session.setAttribute("dispTable",dispTable);
					}
					if(dispTable != null && dispTable.size() > 0)
					{
						int totalRecords=dispTable.size();
						if(rowCount != null && rowCount.equalsIgnoreCase("All"))
							rowCount = String.valueOf(totalRecords);
						int rows=Integer.parseInt(rowCount);
						int totalPages=0;
						if (totalRecords % rows != 0)
						{
							totalPages = totalRecords / rows + 1;
						}
						else
						{
							totalPages = totalRecords / rows;
						}

						agentFound = true;
						if(dateString.length()>0)
						{
			%>
				<tr>
					<td align="center" >
						<div name="refreshinfo" id="refreshinfo" style="display:true;" class="tableWidth">
						<egui:intnl text="admin.upgrade.This page will refresh in 3 minutes"/>.
						</div>
					</td>
				</tr>
				<tr>
					<td height="5px;"></td>
				</tr>
			<%
						}
			%>
				<tr>
					<td width="100%">
						<table border="0" cellspacing="0" cellpadding="4" width="85%" class="tableWidth" align="center"><col width="30%"><col width="20%"><col width="50%">
							<tr>
								<td align="left" style="padding-left:0px">
									<b><egui:intnl text="admin.common.Total results" /></b> : <b><%=dispTable.size() %></b>
								</td>
								<td>&nbsp;<td>
								<td align="right" nowrap> <b><egui:intnl text="admin.common.Page"/></b> : <b><%= pageNoStr != null ? pageNoStr : "1" %> <egui:intnl text="admin.common.of"/> <%= totalPages %></b></td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td align="center">
						<table width="85%" border="0"  align="center" cellspacing="0" cellpadding="2" class="table_border"><!-- <col width="30"><col width="150"><col width="130"><col width="120"><col width="60"><col width="60"><col width="55"><col width="70"><col width="120"><col width="120"><col width="30"> -->
						<thead id="thead">
							<tr>
								<td align="left" class="heading" style="padding:0px">
									<table border="0" cellspacing="0" cellpadding="0" id="left" >
										<tr>
											<td><input class="eg_input" type="checkbox" name="selectAll" onClick="checkAll();"></td>
											<td><img id="img0" style="display:true;" src="/final/admin/eg_images/headarrow_forward.gif" align="left"  valign="middle" onClick="javascript:swapColumns(0,10);" border="0">
											</td>
										</tr>
									</table>
								</td>

								<th class="heading">
									<table border="0" cellspacing="0" cellpadding="0" width="100%">
										<tr>
											<td align="center"><a id="vladi"  href="javascript:void(0)" class="eg_monlink" onclick="this.blur(); return sortTable(1);"><b><egui:intnl text="admin.upgrade.Component Name"/></b></a></td>
											<td width="15" valign="middle" style="padding-top:2px"><img id="img1" src="/final/admin/eg_images/headarrow_down.gif" style="display:none" align="absmiddle" onclick="this.blur(); return sortTable(1);"></td>
										</tr>
									</table>
								</th>

								<th align="center"  class="heading">
									<table border="0" cellspacing="0" cellpadding="0" width="100%">
										<tr>
											<td align="center" ><a id="vladi" class="eg_monlink" href="javascript:void(0)" onclick="this.blur(); return sortTable(2);"><b><egui:intnl text="admin.upgrade.Component Type"/></b></a></td>
											<td width="10" valign="middle" style="padding-top:2px"><img id="img2" src="/final/admin/eg_images/headarrow_down.gif" style="display:none" align="absmiddle" onclick="this.blur(); return sortTable(2);"></td>
										</tr>
									</table>
								</th>

								<th align="center"  class="heading" >
									<table border="0" cellspacing="0" cellpadding="0" width="100%">
										<tr>
											<td align="center" ><a id="vladi" class="eg_monlink" href="javascript:void(0);" onclick="this.blur(); return sortTable(3);"><b><egui:intnl text="admin.upgrade.Agent Name"/></b></a></td>
											<td width="10" valign="middle" style="padding-top:2px"><img id="img3" src="/final/admin/eg_images/headarrow_down.gif" style="display:none" align="absmiddle" onclick="this.blur(); return sortTable(3);"></td>
										</tr>
									</table>
								</th>

								<th align="center"  class="heading" >
									<table border="0" cellspacing="0" cellpadding="0" width="100%">
										<tr>
											<th align="center"><a id="vladi" class="eg_monlink" href="javascript:void(0);" onclick="this.blur(); return sortTable(4);"><b><egui:intnl text="admin.upgrade.Auto Upgrade"/></a></th>
											<td align="right" valign="middle" style="padding-top:2px" width="10"><img id="img4" src="/final/admin/eg_images/headarrow_down.gif" style="display:none" align="absmiddle" onclick="this.blur(); return sortTable(4);"></td></tr>
									</table>
								</th>

								<th align="center"  class="heading" >
									<table border="0" cellspacing="0" cellpadding="0" width="100%">
										<tr>
											<th align="center"> <a id="vladi" class="eg_monlink" href="javascript:void(0);" onclick="this.blur(); return sortTable(5);"><b><egui:intnl text="admin.upgrade.Upgrade Now"/></a> </th>
											<td align="right" valign="middle" style="padding-top:2px" width="10"> <img id="img5" src="/final/admin/eg_images/headarrow_down.gif" style="display:none" align="absmiddle" onclick="this.blur(); return sortTable(5);"> </td>
										</tr>
									</table>
								</th>

								<th align="center"  class="heading">
									<table border="0" cellspacing="0" cellpadding="0" width="100%">
										<tr>
											<th align="center"> <a id="vladi" class="eg_monlink" href="javascript:void(0)" onclick="this.blur(); return sortTable(6);"><b><egui:intnl text="admin.upgrade.Version"/></b></a> </th>
											<td align="right" valign="middle" style="padding-top:2px" width="10"> <img id="img6" src="/final/admin/eg_images/headarrow_down.gif" style="display:none" align="absmiddle" onclick="this.blur(); return sortTable(6);"> </td>
										</tr>
									</table>
								</th>
								<th align="center"  class="heading">
									<table border="0" cellspacing="0" cellpadding="0" width="100%">
										<tr>
											<th align="center" > <a id="vladi" class="eg_monlink" href="javascript:void(0)" onclick="this.blur(); return sortTable(7);"><b><egui:intnl text="admin.upgrade.Operating System"/></b></a> </th>
											<th align="right" valign="middle" style="padding-top:2px" width="10"> <img id="img7" src="/final/admin/eg_images/headarrow_down.gif" style="display:none" align="absmiddle" onclick="this.blur(); return sortTable(7);"> </td>
										</tr>
									</table>
								</th>

								<td align="center"  class="heading">
									<table border="0" cellspacing="0" cellpadding="0" width="100%">
										<tr>
											<th align="center"> <a id="vladi" class="eg_monlink" href="javascript:void(0)" onclick="this.blur(); return sortTable(8);"><b><egui:intnl text="admin.upgrade.Last Upgraded Package"/></b></a> </th>
											<td align="right" valign="middle" style="padding-top:2px" width="10"> <img id="img8" src="/final/admin/eg_images/headarrow_down.gif" style="display:none" align="absmiddle" onclick="this.blur(); return sortTable(8);"> </td>
										</tr>
									</table>
								</td>

								<td align="center"  class="heading">
									<table border="0" cellspacing="0" cellpadding="0" width="100%">
										<tr>
											<th align="center"> <a id="vladi" class="eg_monlink" href="javascript:void(0)" onclick="this.blur(); return sortTable(9);"><b><egui:intnl text="admin.upgrade.Last Upgraded Time"/></b></a></th>
											<td align="right" valign="middle" style="padding-top:2px" width="10"><img id="img9" src="/final/admin/eg_images/headarrow_down.gif" style="display:none" align="absmiddle" onclick="this.blur(); return sortTable(9);"></td>
										</tr>
									</table>
								</td>
								<th align="left" class="heading" style="display:none">&nbsp;</th>
							</tr>
						</thead>

						<tbody id="rsTable">
<%
				int pageNo = Integer.parseInt(pageNoStr);
				int inc=0;
				inc = (pageNo - 1) * rows;
				int inc1=inc;
				int inc2 = 0;
				int count=0;
				for(int i=0; i<dispTable.size(); i++)
				{
					if(inc2 >= inc1 && inc < pageNo * rows)
					{
%>
					<tr id="<%="trA"+count%>">
<%
					AgentsUpgradeVO vo = (AgentsUpgradeVO) dispTable.get(i);
%>
						<td align="left" valign="top" id="<%="tdA"+count%>" class="linebottomright" style="border-left-width:1px" ><div class="divWidth1" style="width:35px;overflow:hidden;text-overflow:ellipsis;"><input type="checkbox" name="opt" value="<%=vo.getId()%>" onClick="javascript:checkItem(this)" id="eg_input"></div></td>
<%
							String currentInfo = vo.getComponentName();
							String temp = currentInfo;
							if(currentInfo.length()>componentName_columnWidth)
							{
								currentInfo = currentInfo.substring(0,componentName_columnWidth)+"...";
							}
							if(currentInfo.length()>15)
							{
								String tempDesc = currentInfo;
								String now = "";
								while(tempDesc.length()>15)
								{
									now += tempDesc.substring(0,15)+"<br>";
									tempDesc = tempDesc.substring(15);
									if(tempDesc.length()<=15)
									{
										now += tempDesc;
										break;
									}
								}
								currentInfo = now;
							}
							
%>
						<!-- component name -->
						<td align="left" valign="top" id="linebottomright" title="<%=temp%>"><div class="divWidth2" style="width:150px;overflow:hidden;text-overflow:ellipsis;"><%=currentInfo%></div></td>
<%
							String compTypesTmp = vo.getComponentType();
							String[] compTypeArr = StringUtils.getTokens(compTypesTmp,",");
							String totalStr = "";
							for(int j=0; (compTypeArr != null && j<compTypeArr.length); j++)
							{
								String tmpCompType = compTypeArr[j];
								if(tmpCompType.endsWith("_ex"))
								{
									if(totalStr.length()==0)
									{
										totalStr = tmpCompType;
									}
									else
									{
										totalStr += ", "+tmpCompType;
									}
								}
								else
								{
									if(totalStr.length()==0)
									{
										totalStr = _mapping.getComponentTypeDescription(tmpCompType);
									}
									else
									{
										totalStr += ", "+_mapping.getComponentTypeDescription(tmpCompType);
									}
								}
							}
							currentInfo = totalStr;
							temp = currentInfo;
							if(currentInfo.length()>componentType_columnWidth)
							{
								currentInfo = currentInfo.substring(0,componentType_columnWidth)+"...";
							}
							if(currentInfo.length()>15)
							{
								String tempDesc = currentInfo;
								String now = "";
								while(tempDesc.length()>15)
								{
									now += tempDesc.substring(0,15)+"<br>";
									tempDesc = tempDesc.substring(15);
									if(tempDesc.length()<=15)
									{
										now += tempDesc;
										break;
									}
								}
								currentInfo = now;
							}
%>
						<!-- component type -->
						<td align="left" valign="top" id="linebottomright" title="<%=temp%>"><div class="divWidth3" style="width:130px;overflow:hidden;text-overflow:ellipsis;"><%=currentInfo%></div></td>
<%
							currentInfo = vo.getAgentName();
							currentInfo = StringUtils.replace(currentInfo,"<br>",",");
							temp = currentInfo;
							if(currentInfo.length()>agentName_columnWidth)
							{
								currentInfo = currentInfo.substring(0,agentName_columnWidth)+"...";
							}
							if(currentInfo.length()>14)
							{
								String tempDesc = currentInfo;
								String now = "";

								String array[] = StringUtils.getTokens(currentInfo,",");
								currentInfo="";
								for(int k=0;k<array.length;k++)
								{
									String str = array[k];
									now = "";
									if(str.length()>14)
									{
										while(str.length()>14)
										{
											now += str.substring(0,14)+"<br>";
											str = str.substring(14);
											if(str.length()<=14)
											{
												now += str;
												break;
											}
										}
										if((k+1)==array.length)
										{
											currentInfo += now+"<br>";
										}
										else
										{
											currentInfo += now+",<br>";
										}
									}
									if(now.length()==0)
									{
										if((k+1)==array.length)
										{
											currentInfo += array[k]+"<br>";
										}
										else
										{
											currentInfo += array[k]+",<br>";
										}
									}
								}
							}
							String strEncodeAgentNick = vo.getAgentIP();
							try{
							if(strEncodeAgentNick!=null && strEncodeAgentNick.length()>0)
								strEncodeAgentNick = com.eg.EgURLEncoder.encode(strEncodeAgentNick,"UTF-8");
							}catch(Exception e){}
%>
						<!-- agent name -->
						<td align="left" valign="top" id="linebottomright" title="<%=StringUtils.replace(temp,",",", ")%>"><div class="divWidth4" style="width:120px;overflow:hidden;text-overflow:ellipsis;"><a class="eg_monlink" href='EgAgentInfo.jsp?&abc=d&agentIp=<%=strEncodeAgentNick%>&nickname=<%=selectedNickName%>&to=<%=selectedTo%>&from=<%=selectedFrom%>&choice=<%=selectedChoice%>&servertype=<%=selectedServerType%>&status=<%=selectedStatus%>'><%=currentInfo%></a></div></td>
						<!-- Auto upgrade -->
						<td align="left" id="linebottomright" valign="top"><div class="divWidth5" style="width:60px;overflow:hidden;text-overflow:ellipsis;"><egui:intnl text='<%="admin.upgrade."+vo.getAutoUpgrade()%>'/></div></td>
						<!-- upgrade now -->
						<td align="left" id="linebottomright" valign="top"><div class="divWidth6" style="width:60px;overflow:hidden;text-overflow:ellipsis;"><egui:intnl text='<%="admin.upgrade."+vo.getUpgradeNowFlag()%>'/></div></td>
						<!-- version -->
						<td align="left" id="linebottomright" valign="top"><div class="divWidth7" style="width:55px;overflow:hidden;text-overflow:ellipsis;"><%=vo.getAgentVersion()%></div></td>
<%
						currentInfo = vo.getAgentOS();
						temp = currentInfo;
						if(currentInfo.length()>49)
						{
							currentInfo = currentInfo.substring(0,9)+"...";
%>
						<!-- operating system -->
						<td align="left" id="linebottomright" valign="top" title="<%=temp%>"><div class="divWidth8" style="width:70px;overflow:hidden;text-overflow:ellipsis;"><%=currentInfo%></div></td>
<%
						}
						else
						{
%>
						<!-- operating system -->
						<td  id="linebottomright" valign="top" title="<%=temp%>"><div class="divWidth8" style="width:70px;overflow:hidden;text-overflow:ellipsis;"><%=currentInfo%></div></td>
<%
						}
						currentInfo = vo.getLastUpgradePack();
						temp = currentInfo;
						if(currentInfo.length()>12)
						{
							currentInfo = currentInfo.substring(0,12)+"...";
%>
						<!-- last upgraded package -->
						<td  id="linebottomright" valign="top" title="<%=temp%>"><div class="divWidth9" style="width:70px;overflow:hidden;text-overflow:ellipsis;"><%=currentInfo%></div></td>
<%
						}
						else
						{
%>
						<!-- last upgraded package -->
						<td  id="linebottomright" valign="top" title="<%=temp%>"><div class="divWidth9" style="width:70px;overflow:hidden;text-overflow:ellipsis;"><%=currentInfo%></div></td>
<%
						}
%>
						<!-- last upgraded time -->
						<td id="linebottomright" valign="top" ><div class="divWidth10" style="width:120px;overflow:hidden;text-overflow:ellipsis;"><%=StringUtils.format(vo.getLastUpgradedTime(),10," ")%></div></td>

						<td  id="linebottomright" valign="top" style="display:none"><div class="divWidth1" style="width:35px;overflow:hidden;text-overflow:ellipsis;"><p align="center">&nbsp;</p></div></td>
					</tr>
<%
						inc++;
						count++;
					}// end if paging
					if(inc == pageNo * rows) break;
					inc2++;
				}// end disp table
%>
						</tbody>
						</table>
					</td>
				</tr>
				<script language="JavaScript">
					sortTable(2);
				</script>
				<tr>
					<td width="100%"  height="10" id="eg_blankspace" >&nbsp;</td>
				</tr>
				<tr>
					<td>
						<table width="100%"  align="center">
							<tr>
								<td align="center">
									<input type="button" style="<%=setAutoUpgradeButtonwidth%>" class="eg_lightbutton" value="<egui:intnl text='admin.upgrade.Set Auto Upgrade'/>" onClick="javascript:update('setAutoUpgrade');">&nbsp;&nbsp;
									<input type="button" style="<%=disableAutoUpgradeButtonwidth%>" class="eg_lightbutton" value="<egui:intnl text='admin.upgrade.Disable Auto Upgrade'/>" onClick="javascript:update('resetAutoUpgrade');">&nbsp;&nbsp;
									<input type="button" style="<%=upgradeNowButtonwidth%>" class="eg_lightbutton" value="<egui:intnl text='admin.upgrade.Upgrade Now'/>" onClick="javascript:update('upgradeNow');">&nbsp;&nbsp;
									<input type="button" style="<%=cancelUpgradeNowButtonwidth%>" class="eg_lightbutton" value="<egui:intnl text='admin.upgrade.Cancel Upgrade Now'/>" onClick="javascript:update('cancelUpgradeNow');">
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td width="100%"  height="10" id="eg_blankspace" >&nbsp;</td>
				</tr>
<%
						if(totalPages > 1)
						{
%>
				<tr>
					<td>
					<script language="javascript">
						displayTable("<%=totalPages%>");
					</script>
					</td>
				<tr>
<%
						}
					}
					else
					{
%>
				<tr>
					<td width="100%"  height="150">
						<table cellpadding="0" cellspacing="0" border="0" width="85%" height="100%" align="center">
							<tr>
								<td id="eg_errorsmall" class="cell_border4" style="border-left-width:1px;border-top-width:1px"><img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif"><br><egui:intnl text="admin.upgrade.No agents found"/>.</td>
							</tr>
						</table>
					</td>
				</tr>
				<script language="JavaScript">
					if(document.forms[0].selectAll)
						document.forms[0].selectAll.style.display = 'none';
					if(document.forms[0].img0)
						document.forms[0].img0.style.display = 'none';
				</script>
<%
					}
				}// check for submit
%>
			</table>
				<input type="hidden" name="refresh_status" value="">
				<input type="hidden" name="currentTime" value="">
				<input type="hidden" name="swap_action" value="false">
				<input type="hidden" name="make_enabled_ids" value="">
				</form>
		</td>
	</tr>
</table>
<script language="JavaScript">
	setRange();
</script>
<%
	if(agentFound)
	{
%>
	<script language="JavaScript">
		if("<%=swaped%>"=="true")
		swapColumns(0,10);
	</script>
<%
	}
%>
<form name="pagination" method="post">
<input type="hidden" name="pageNo" value="<%=pageNoStr%>">
<%
	Map requestMap = request.getParameterMap();
	Iterator itr = requestMap.keySet().iterator();
	while(itr.hasNext())
	{
		String key = (String)itr.next();
		String value = request.getParameter(key);
		if(key != null && key.equals("pageNo"))
			continue;
%>
		<input type="hidden" name="<%=key%>" value='<%=value != null ? value : ""%>'>
<%
	}
%>
</form>
</body>
</html>
<%!
	int getCharactersCountToDisplay(String countStr)
	{
		int val = 20;
		try
		{
			val = Math.abs(Integer.parseInt(countStr));
		}
		catch(Exception e)
		{
			val = 20;
		}
		finally
		{
			return val;
		}
	}
	boolean checkIPRange(String fromIP, String toIP, String currentIP)
	{
		StringTokenizer st1 = new StringTokenizer(fromIP,".");
		StringTokenizer st2 = new StringTokenizer(toIP,".");
		StringTokenizer st3 = new StringTokenizer(currentIP,".");
		long ip1 = 0;
		long ip2 = 0;
		long ip3 = 0;
		String str1,str2,str3; 
		
		while(st1.hasMoreTokens())
		{
			str1 = (String) st1.nextToken();
			str2 = (String) st2.nextToken();
			str3 = (String) st3.nextToken();
				
			try
			{
				ip1 = (new Long(str1)).longValue();
				ip2 = (new Long(str2)).longValue();
				ip3 = (new Long(str3)).longValue();
			}
			catch(NumberFormatException e)
			{
				return false;
			}
			if (( ip3 >= ip1 ) && ( ip3 < ip2 ))
			{
				return true;
			}
			else if(( ip3 < ip1 ) || ( ip3 > ip2 ))
			{
				return false;
			}
		}
		return true;
	}

	String checkForRemoteComponent(String[] remComps, EgExternalInfo egExternalInfo, String remoteComponent)
	{
		List list = Arrays.asList(remComps);
		if(list.contains(remoteComponent))
			return egExternalInfo.getRemoteAgentForHost(remoteComponent);
		else
			return "-1";
	}

	String checkForExternalAgent(Hashtable agentIpHashtable, Hashtable hostAgentMap, String host, String ipAddress)
	{
		List list = (List) hostAgentMap.get(host);
		if(list !=null && list.size()>0)
		{
			return (String)agentIpHashtable.get(ipAddress);
		}
		else
			return "-1";
	}

	boolean isValidIPAddress(String ipAddress)
	{
		String a[] = StringUtils.getTokens(ipAddress,".");
		if(a==null || a.length!=4)
			return false;
		for(int i=0;i<a.length;i++)
		{
			try
			{
				if(Integer.parseInt(a[i]) > 255 || Integer.parseInt(a[i]) < 0 )
					return false;
			}
			catch(Exception e)
			{
				return false;
			}
		}
		return true;
	}

	public ArrayList getAgentDetailsToDisplay(HttpServletRequest request, AgentConfig agentConfig, String[] remComps, EgExternalInfo egExternalInfo, Hashtable agentList, Hashtable hostAgentMap, Hashtable ipHashtable, String allowQualifiedHostNames)
	{
		IniFile iniui = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_ui.ini");
		String currentDateFormat = iniui.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
		EgLicenseInfo licenseInfo = new EgLicenseInfo();
		ArrayList listOfExternalAgents = licenseInfo.getExternalAgents();
		ArrayList listOfRemoteAgents = licenseInfo.getRemoteAgents();
		Hashtable agentIpHashtable = new Hashtable();
		Hashtable results = agentConfig.getAllAgentDetails();
		EgDiscInfo discObj = new EgDiscInfo("manager");
		Hashtable htt = discObj.getIpNickMap();
		Hashtable ht = discObj.getNickIpMap();
		String ids[] = 	agentConfig.getArrayOfAgentIDs();
		boolean vladimir = true;
		boolean rowCount = true;
		Format formatter = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
		ArrayList finalResult = new ArrayList();
		//Changed By Inbaraj
		IniFile servicesIniRead = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
		String fileName = "";
		String autoUpgradeInfo = servicesIniRead.getValue("MISC_ARGS","AutoUpgradeInfo");
		if(autoUpgradeInfo != null && !autoUpgradeInfo.equals("") && autoUpgradeInfo.equalsIgnoreCase("eg_autoupgrade"))
		{		
			fileName = "eg_autoupgrade.ini";
		}
		else
		{
			fileName = "eg_tests.ini";
		}
		IniFile ini_read = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/" + fileName);
		String upgradeNowAgents[] = ini_read.getVariables("UPGRADE_NOW");
		Vector aggregateTypes = new Vector();
		if(EgInstallInfo.isAggregationSupported())
			aggregateTypes = new EgAggregateInfo("manager").getAggregateTypes();

		String option = "all";
		String selectedNickName = request.getParameter("nickname");
		String selectedTo = request.getParameter("to");
		String selectedFrom = request.getParameter("from");
		String selectedChoice = request.getParameter("choice");
		String selectedServerType = request.getParameter("servertype");
		String selectedStatus = request.getParameter("status");

		if(selectedFrom !=null && selectedFrom.length()>0)
		{
			option = "onlyIPBased";
		}
		else if(selectedNickName !=null && selectedNickName.length() > 0 && selectedServerType !=null && selectedServerType.equalsIgnoreCase("all") && (selectedFrom ==null || selectedFrom.length()==0))
		{
			option = "onlyNickBased";
		}
		else if((selectedNickName ==null || selectedNickName.length() == 0) && selectedServerType !=null && selectedServerType.equalsIgnoreCase("all") && (selectedFrom ==null || selectedFrom.length()==0))
		{
			option = "onlyAllServerBased";
		}
		else if((selectedNickName !=null && selectedNickName.length() > 0) && selectedServerType !=null && selectedServerType.equalsIgnoreCase("all") && (selectedFrom ==null || selectedFrom.length()==0))
		{
			option = "nickAllServerBased";
		}
		else if((selectedNickName ==null || selectedNickName.length() == 0) && selectedServerType !=null && !selectedServerType.equalsIgnoreCase("all") && (selectedFrom ==null || selectedFrom.length()==0))
		{
			option = "specificServerBased";
		}
		else if((selectedNickName !=null && selectedNickName.length() > 0) && selectedServerType !=null && !selectedServerType.equalsIgnoreCase("all") && (selectedFrom ==null || selectedFrom.length()==0))
		{
			option = "nickSpecifiServerBased";
		}

		Hashtable hh = null;
		boolean chkIPRange = false;
		for(int i=0;i<ids.length;i++)
		{
			String agentsAllInfosString = (String) results.get(ids[i]);
			String agentsAllInfosStringArray[] = StringUtils.getTokens(agentsAllInfosString,",");
			String agentVersion = agentsAllInfosStringArray[5];
			if(agentVersion ==null || agentVersion.equalsIgnoreCase("null"))
				continue;
			Vector nicks = new Vector();
			String allAgents[] = StringUtils.getTokens(ids[i],":");
			String global = allAgents[0];
			String ipAddress = (String) ht.get(allAgents[0]);
			if (ipAddress == null) continue;
			if(allowQualifiedHostNames.equalsIgnoreCase("no"))
			{
				if(ipAddress ==null || ipAddress.equalsIgnoreCase("null") || !isValidIPAddress(ipAddress))
					continue;
			}
			StringBuffer sb = new StringBuffer(ids[i]);
			String sbb="";
			for(int p=0;p<sb.length();p++)
			{
				if(sb.charAt(p)==':')
				{
					sbb = sbb + "<br>";
				}
				else
					sbb = sbb + sb.charAt(p);
			}
			nicks.clear();
			String vNick = (String)htt.get(ipAddress);
			StringTokenizer tokens = new StringTokenizer(vNick,":");
			while(tokens.hasMoreTokens())
			{
				String cToken = (String) tokens.nextToken();
				boolean isAdded = false;
				if(listOfExternalAgents.contains(cToken))
				{
					if(egExternalInfo.getIpForAgent(cToken).equals(ipAddress))
					{
						if(!agentIpHashtable.containsKey(ipAddress))
							agentIpHashtable.put(ipAddress,cToken);
						ArrayList al = (ArrayList)ipHashtable.get(cToken);
						if(al !=null && al.size()>0)
						{
							for(int h=0;h<al.size();h++)
							{
								nicks.add(al.get(h));
								isAdded = true;
							}
						}
					}
				}
				if(!isAdded && listOfRemoteAgents.contains(cToken))
				{
					String tmpIPAddress = egExternalInfo.getIpForRemoteAgent(cToken);
					ArrayList al = null;
					if(ipHashtable.containsKey(tmpIPAddress))
					al = (ArrayList)ipHashtable.get(tmpIPAddress);

					if(al !=null && al.size()>0)
					{
						for(int h=0;h<al.size();h++)
						{
							nicks.add(al.get(h));
							isAdded = true;
						}
					}
				}
				if (!isAdded)
				{
					nicks.add(cToken);
				}
			}
			TreeSet tt = new TreeSet(nicks);
			nicks.clear();
			nicks.addAll(tt);
			allAgents = new String[0];
			allAgents = (String[])nicks.toArray(new String[0]);
			if(selectedChoice.equalsIgnoreCase("Range"))
			{
				chkIPRange = checkIPRange(selectedFrom,selectedTo,ipAddress);
			}
			for(int k=0;k<allAgents.length;k++)
			{
				AgentsUpgradeVO vo = new AgentsUpgradeVO();
				if(option.equals("onlyNickBased") || option.equals("nickAllServerBased")||  option.equals("nickSpecifiServerBased"))
				{
					Vector v = new Vector();
					StringTokenizer st = null;
					if(selectedNickName.indexOf(",")!=-1)
					st = new StringTokenizer(selectedNickName,",");
					else
					st = new StringTokenizer(selectedNickName);
					while(st.hasMoreTokens())
					{
						String temp = (String) st.nextToken();
						if(temp.length()>0)
						{
							v.add(temp.trim());
						}
					}
					String temps[] = (String[])v.toArray(new String[0]);
					boolean t = false;
					for(int m=0;m<temps.length;m++)
					{
						if(allAgents[k].toLowerCase().indexOf(temps[m].toLowerCase())!=-1)
						{
							t = true;
						}
					}
					if(!t)
						continue;
				}
				if(ht.containsKey(allAgents[k]))
				{
					if(option.equals("onlyIPBased"))
					{
						if(selectedChoice.equalsIgnoreCase("Range"))
						{
							if(!chkIPRange)
							continue;
						}
						else
						{
							if(!ipAddress.equalsIgnoreCase(selectedFrom))
							continue;
						}
					}
					if (hh == null)
							hh = discObj.getServerTypesForAllNicks();
					List componentTypes = (List)hh.get(allAgents[k]);
					if(componentTypes!= null && componentTypes.size()>0 && aggregateTypes != null && aggregateTypes.size()>0)
					{
						componentTypes.removeAll(aggregateTypes);
					}
					if(componentTypes==null || componentTypes.size()==0)
					{
						continue;
					}
					if(option.equals("specificServerBased") || option.equals("nickSpecifiServerBased"))
					{
						for(int j=componentTypes.size()-1;j>=0;j--)
						{
							if(!componentTypes.get(j).toString().equalsIgnoreCase(selectedServerType))
							componentTypes.remove(j);
						}
						if(componentTypes.size()==0)
						{
							continue;
						}
					}
					String upgraded = "Yes";
					String lastUpgradedPack = agentsAllInfosStringArray[1];
					if(lastUpgradedPack == null || lastUpgradedPack.equalsIgnoreCase("null") || lastUpgradedPack.length()==0)
						upgraded = "No";
					if(!selectedStatus.equalsIgnoreCase("all") && !option.equals("onlyIPBased"))
					{
						if(selectedStatus.equalsIgnoreCase("Upgraded") && !upgraded.equals("Yes"))
						{
							continue;
						}
						if(selectedStatus.equalsIgnoreCase("Not Upgraded") && !upgraded.equals("No"))
						{
							continue;
						}
					}
					String agentStatus = (String) agentList.get(global);
					agentList.remove(global);
					if(agentStatus == null || agentStatus.equalsIgnoreCase("null") || agentStatus.trim().length()==0)
						continue;

					if(agentStatus.equalsIgnoreCase("true"))
						agentStatus = "Enabled";
					else
						agentStatus = "Disabled";

					if(!selectedStatus.equalsIgnoreCase("all") && !option.equals("onlyIPBased"))
					{
						if(selectedStatus.equalsIgnoreCase("Auto Upgrade Enabled") && !agentStatus.equals("Enabled"))
						{
							continue;
						}
						if(selectedStatus.equalsIgnoreCase("Auto Upgrade Disabled") && !agentStatus.equals("Disabled"))
						{
							continue;
						}
					}
					List list = null;
					if(upgradeNowAgents !=null && upgradeNowAgents.length >0 )
					{
						list = Arrays.asList(upgradeNowAgents);
					}
					if(!selectedStatus.equalsIgnoreCase("all") && !option.equals("onlyIPBased"))
					{
						if(selectedStatus.equalsIgnoreCase("Upgrade Now Enabled"))
						{
							if(list !=null && list.contains(global))
							{
								//do nothing
							}
							else
								continue;
						}
						if(selectedStatus.equalsIgnoreCase("Upgrade Now Disabled"))
						{
							if(list !=null && list.contains(global))
							{
								continue;
							}
						}
					}
					if(vladimir)
					{
						vladimir = false;
					}
					else
					{
						vladimir = true;
					}
					vo.setId(ids[i]);//value to be set in checkbox.
					vo.setComponentName(allAgents[k]);
					TreeSet ts = new TreeSet(componentTypes);
					componentTypes.clear();
					componentTypes.addAll(ts);
					Collections.sort(componentTypes,String.CASE_INSENSITIVE_ORDER);
					String compTypes = null;
					for(int j=0;j<ts.size();j++)
					{
						String tmpCompType = (String)componentTypes.get(j);
						if(compTypes == null)
							compTypes = tmpCompType;
						else
							compTypes = compTypes+","+tmpCompType;
					}
					vo.setComponentType(compTypes);

					String ttmp ="";
					String external = "-1";
					if(agentIpHashtable !=null && agentIpHashtable.size()>0)
						external = checkForExternalAgent(agentIpHashtable, hostAgentMap, allAgents[k], ipAddress);
					String remote = "-1";
					if(remComps !=null && remComps.length>0)
						remote = checkForRemoteComponent(remComps, egExternalInfo, allAgents[k]);
					if(external !=null && !external.equalsIgnoreCase("null") && !external.equals("-1"))
					{
						ttmp = external;
					}
					else if(remote !=null && !remote.equalsIgnoreCase("null") && !remote.equals("-1"))
					{
						ttmp = remote;
					}
					else
					{
						ttmp = allAgents[k];
					}
					vo.setAgentName(sbb);
					vo.setAgentIP(ttmp);
					vo.setAutoUpgrade(agentStatus);
					if(list !=null && list.contains(global) && agentsAllInfosStringArray[0].equalsIgnoreCase("true"))
					{
						vo.setUpgradeNowFlag("Enabled");
					}
					else
					{
						vo.setUpgradeNowFlag("Disabled");
					}
					vo.setAgentVersion(agentsAllInfosStringArray[5]);
					vo.setAgentOS(agentsAllInfosStringArray[4]);
					vo.setLastUpgradePack(agentsAllInfosStringArray[1]);
					String showDate = agentsAllInfosStringArray[2];
					try
					{
						if(!showDate.equalsIgnoreCase("None") && showDate.trim().length()>0)
						{
							showDate = formatter.format(new java.util.Date(Long.parseLong(agentsAllInfosStringArray[2])));
							String firstPart = showDate.substring(0,showDate.indexOf(" "));
							String secondPart = showDate.substring(showDate.indexOf(" "));
							showDate = DateUtil.changeDateFormat(firstPart,"MM/dd/yyyy",currentDateFormat);
							showDate += secondPart;
						}
					}
					catch(Exception e)
					{
						showDate = agentsAllInfosStringArray[2];
					}
					vo.setLastUpgradedTime(showDate);
					rowCount = !rowCount;
					finalResult.add(vo);
				}
			}
			results.remove(ids[i]);
		} // ids
		return finalResult;
	}//end of function
%>
<%
if(request.getQueryString()!=null)
session.setAttribute("adminLastAccessedURL","/final/admin/agentsUpgradeAdvancedSearch.jsp?"+request.getQueryString());
else session.setAttribute("adminLastAccessedURL","/final/admin/agentsUpgradeAdvancedSearch.jsp");
%>