<%
/*
 *   File				:	EcCitrixUserApps.jsp
 *   Purpose			:	Displays the citrix user applications
 *   Creation Date		:	28/11/2006
 *   Author				: 	Krishnamurthi
 *   UI Design			:	Krishnamurthi
 *   UI Design Changes	:	Jaiwin
 */
%>

<%@ include file = "EcTracker.jsp"%>
<%@ page errorPage = "EcProbs.jsp"%>
<%@ page import = "egurkha.config.EcUtils"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.egurkha.pdfmaker.*"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.EgConfigTestsInfo"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "java.text.*"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.eg.EgInstallInfo" %>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	String[] criterias = {"Zone","Service","Segment","Component"};
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	UserRegistry registry = UserRegistry.getInstance();
	User userObj = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();

	//user language
	String userLanguage = iniUI.getDefaultLanguage();
	if (userObj != null)
	{
		userLanguage = userObj.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);

	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgConfigTestsInfo configTestsInfo = new EgConfigTestsInfo("manager");
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	String configSkin = userObj.getConfigSkin();

	String heading = "";
	String componentName = null;
	String componentType = null;
	String farmName = null;
	String serverName = null;
	TreeMap tmapCitrixApplicationsAndUsers = null;
	TreeMap tmapCitrixUsersAndApplications = null;
	String subTitle = ""; //For PDF
	ArrayList serverList = new ArrayList();

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" "+"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);

	/* Added by Prakash.K Starts */
	EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dateString,userObj);
	dateString = timeZoneConverter.getDateTime();
	/* Added by Prakash.K Ends */

	String ec_comptype = request.getParameter("ec_comptype");
	String ec_component = request.getParameter("ec_component");
	String o_comptype = request.getParameter("old_comptype");

	String strThinClients = configTestsInfo.getServerDisplayValue("MISC_ARGS","ThinClients");
	ArrayList aListThinClients = new ArrayList();
	StringTokenizer stringTokens = new StringTokenizer(strThinClients,",");
	while (stringTokens.hasMoreTokens())
	{
		String token = stringTokens.nextToken();
		aListThinClients.add(token);
	}

	Vector vec_componentTypes = new Vector();
	Vector vec_components = new Vector();
	Vector allcomps = new Vector();

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
	String ec_userOptionPrevious = request.getParameter("ec_userOptionPrevious");

	ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");
	allcomps.addAll(aListAssociatedComponents);
	//allcomps.addAll(userObj.getServers(false));

	String request_from = request.getParameter("request_from");
	String submitOrNot = (String) request.getAttribute("isSubmit");
	Map scheduleDetails = (Map) request.getAttribute("ScheduleDetails");
	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		ec_criteria = (String)scheduleDetails.get("ec_criteria");
		ec_criteriaPrevious = (String)scheduleDetails.get("ec_criteriaPrevious");
		submitOrNot = "false";
	}

	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		vecUserOptions = (Vector) scheduleDetails.get("vecUserOptions");
		ec_comptype = (String) scheduleDetails.get("ec_comptype");
		ec_component = (String) scheduleDetails.get("ec_component");
		o_comptype = (String) scheduleDetails.get("old_comptype");
		ec_userOption = (String) scheduleDetails.get("ec_userOption");
		ec_userOptionPrevious = (String) scheduleDetails.get("ec_userOptionPrevious");
	}

	if (submitOrNot == null || "null".equals(submitOrNot))
	{
		submitOrNot = "true";
	}

	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		submitOrNot = "false";
	}

	if (!allcomps.isEmpty())
	{
		for (int i=0;i<allcomps.size();i++)
		{
			String str = (String) allcomps.get(i);
			String component_type = str.substring(0,str.indexOf(":"));

			if (!aListThinClients.contains(component_type)) continue;

			boolean isTestEnabled = specsInfo.isConfigTestEnabled(component_type);
			if (!isTestEnabled) continue;

			if (!vec_componentTypes.contains(component_type))
				vec_componentTypes.add(component_type);

			String component_name = str.substring(str.indexOf(":")+1);
			vec_components.add(component_name+":"+component_type);
		}
		Collections.sort(vec_componentTypes);
	}

	if (ec_component != null && !ec_component.equals("-1"))
	{
		componentName = ec_component.substring(0,ec_component.lastIndexOf(":"));
		componentType = ec_component.substring(ec_component.lastIndexOf(":")+1);
		componentType = mappingInfo.getComponentTypeDescription(componentType);
	}

	if (ec_comptype != null)
	{
		if (ec_comptype.equals("Citrix_server"))
		{
			heading = "Server Application Users";
		}
	}

	Vector v_comp = null;
	if (ec_comptype == null || ec_comptype.equals("-1"))
	{
		v_comp = vec_components;
		Collections.sort(v_comp);
		ec_comptype = "-1";
	}
	else
	{
		v_comp = new Vector();
		for (int i=0;i<vec_components.size();i++)
		{
			String s_comp = (String)vec_components.get(i);
			if (ec_comptype != null && s_comp.endsWith(ec_comptype))
			{
				v_comp.add(s_comp);
			}
		}
		Collections.sort(v_comp);
		if (!ec_comptype.equalsIgnoreCase(o_comptype))
			ec_component = "";
	}

	ArrayList aListCitrixAppUsers = (ArrayList)request.getAttribute("Citrix Application Users");
	if (aListCitrixAppUsers != null && !aListCitrixAppUsers.isEmpty())
	{
		ArrayList aListCitrixFarmDetails = (ArrayList)aListCitrixAppUsers.get(1);
		if (aListCitrixFarmDetails != null)
		{
			TreeMap tmapData = (TreeMap)aListCitrixFarmDetails.get(3);
			ArrayList aListTemp = (ArrayList)tmapData.get("+");

			if (heading.equalsIgnoreCase("List of Applications/Desktops/Contents With Users"))
				farmName = (String)aListTemp.get(0);
			else
				serverName = (String)tmapData.firstKey();
		}
	
		ArrayList aListTemp = null;
		if (heading.equalsIgnoreCase("List of Applications/Desktops/Contents With Users"))
		{
			if (aListCitrixAppUsers.size() > 7)
			{
				aListTemp = (ArrayList)aListCitrixAppUsers.get(7);
			}
		}
		else
		{
			if (aListCitrixAppUsers.size() > 2)
			{
				aListTemp = (ArrayList)aListCitrixAppUsers.get(2);
			}
		}

		if (aListTemp != null)
		{
			tmapCitrixApplicationsAndUsers = (TreeMap)aListTemp.get(3);
		}
	}

	if (tmapCitrixApplicationsAndUsers != null)
	{
		tmapCitrixUsersAndApplications = new TreeMap();

		Iterator applicationAsKeys = tmapCitrixApplicationsAndUsers.keySet().iterator();
		while (applicationAsKeys.hasNext())
		{
			String key_application = (String)applicationAsKeys.next();
			ArrayList aListApplicationValues = (ArrayList)tmapCitrixApplicationsAndUsers.get(key_application);

			StringTokenizer strTokens = new StringTokenizer((String)aListApplicationValues.get(0),",");

			while (strTokens.hasMoreTokens())
			{
				String token = strTokens.nextToken();
				if (token.equals("-")) continue;
				ArrayList aListApplications = (ArrayList)tmapCitrixUsersAndApplications.get(token);

				if (aListApplications == null)
				{
					aListApplications = new ArrayList();
					aListApplications.add(key_application);
					tmapCitrixUsersAndApplications.put(token,aListApplications);
				}
				else
				{
					aListApplications.add(key_application);
				}
			}
		}
	}

	String userName = (String)request.getAttribute("userName");
	ArrayList aListCitrixUserApplications = null;
	if (userName != null && !(userName.equalsIgnoreCase("All") || userName.equals("-1")) && tmapCitrixUsersAndApplications != null && !tmapCitrixUsersAndApplications.isEmpty())
	{
		aListCitrixUserApplications = (ArrayList)tmapCitrixUsersAndApplications.get(userName);
	}

	session.setAttribute("ec_component",ec_component);
	session.setAttribute("heading",heading);
	session.setAttribute("farmName",farmName);
	session.setAttribute("serverName",serverName);
	session.setAttribute("userName",userName);
	session.setAttribute("CitrixUserApplications",tmapCitrixUsersAndApplications);

	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");

	String s_userName = (String)session.getAttribute("sess_auserid");

	String id = request.getParameter("id");

	String strBackRequest = request.getParameter("back_request");
	String strsubmitClicked = request.getParameter("submitClicked");
	if (strsubmitClicked == null)
	{
		strsubmitClicked = "false";
	}
	if (strBackRequest != null && strBackRequest.equalsIgnoreCase("ScheduleConfig") && strsubmitClicked != null && strsubmitClicked.equalsIgnoreCase("false"))
	{
		submitOrNot = "false";
	}
%>

<html>
<egui:skin ui="config"/>
<script language="JavaScript1.2" src="/final/config/scripts/ec_validate.js"></script>
<script type="text/javascript" src="/../final/scripts/screen_display.js"></script>
<script language="JavaScript1.2">
function getData()
{
	var thisForm = document.CitrixUserApps;
	var idForSchedule = '<%=id%>';
	if (idForSchedule != 'null')
	{
		thisForm.action = "../config/EcCitrixUserApps.jsp?id=<%=id%>&request_from=saveSchedule";
	}
	else
	{
		thisForm.action = "../config/EcCitrixUserApps.jsp";
	}
	thisForm.submit();
}

function getUsers()
{
	var thisForm = document.CitrixUserApps;
	var idForSchedule = '<%=id%>';
	if (idForSchedule != 'null')
	{
		thisForm.action = "../servlet/com.eg.EcConfigurationServlet?id=<%=id%>&request_from=saveSchedule";
	}
	else
	{
		var component = thisForm.ec_component.value;
		if (component == -1)
		{
			alert('<egui:intnl text="configmgmt.common.Please select a component" />');
			thisForm.fsctrl.value = '<egui:intnl text="configmgmt.common.Not Applicable" />';
			thisForm.userName.value = "-1";
			return false;
		}
		thisForm.action = "../servlet/com.eg.EcConfigurationServlet";
	}
	thisForm.submit();
}

function getUserApplications()
{
	var thisForm = document.CitrixUserApps;

	var tempCriteria = "";
	var tempUserOption = "";
	if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
	{
		tempCriteria = thisForm.ec_criteria.value;
	}
	if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
	{
		tempUserOption = thisForm.ec_userOption.value;
	}

	if (tempCriteria != null && tempCriteria !=undefined && tempCriteria != -1)
	{
		if (tempUserOption != null && tempUserOption != undefined && tempUserOption == -1)
		{
			if (tempCriteria == "Zone")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
				return false;
			}
			else if (tempCriteria == "Service")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
				return false;
			}
			else if (tempCriteria == "Segment")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
				return false;
			}
		}
	}

	var component = thisForm.ec_component.value;
	var userName = thisForm.userName.value;

	if (component == -1)
	{
		alert('<egui:intnl text="configmgmt.common.Please select a component" />');
		return false;
	}

	if (userName == "-1")
	{
		alert('<egui:intnl text="configmgmt.common.Please select an user" />');
		return false;
	}

	thisForm.action = "../servlet/com.eg.EcConfigurationServlet";
	thisForm.submit();
	thisForm.x.value = '<egui:intnl text="configmgmt.common.Loading" />'+'...';
	thisForm.x.disabled = true;
}

function validateforSchedule()
{
	var thisForm = document.CitrixUserApps;

	var tempCriteria = "";
	var tempUserOption = "";
	if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
	{
		tempCriteria = thisForm.ec_criteria.value;
	}
	if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
	{
		tempUserOption = thisForm.ec_userOption.value;
	}

	if (tempCriteria != null && tempCriteria !=undefined && tempCriteria != -1)
	{
		if (tempUserOption != null && tempUserOption != undefined && tempUserOption == -1)
		{
			if (tempCriteria == "Zone")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
				return false;
			}
			else if (tempCriteria == "Service")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
				return false;
			}
			else if (tempCriteria == "Segment")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
				return false;
			}
		}
	}

	var component = thisForm.ec_component.value;
	var userName = thisForm.userName.value;

	if (component == -1)
	{
		alert('<egui:intnl text="configmgmt.common.Please select a component" />');
		return false;
	}

	if (userName == "-1")
	{
		alert('<egui:intnl text="configmgmt.common.Please select an user" />');
		return false;
	}
}

function getApplicationUsers(applicationname)
{
	var thisForm = document.CitrixUserApps;
	var component = thisForm.ec_component.value;
	if (component == -1)
	{
		alert('<egui:intnl text="configmgmt.common.Please select a component" />');
		return false;
	}
	thisForm.userOption.value = "Application Users";
	thisForm.requestFrom.value = "CitrixUserAppsPage";
	thisForm.action = "../servlet/com.eg.EcConfigurationServlet?applicationName="+applicationname;
	thisForm.submit();
}

function printData()
{
<%
	if (tmapCitrixUsersAndApplications == null || tmapCitrixUsersAndApplications.isEmpty())
	{
%>
	alert('<egui:intnl text="configmgmt.common.No data available" />');
	return;
<%
	}

	StringBuffer printQS = new StringBuffer();
	printQS.append("ec_type=User_Applications");
	printQS.append("&ec_trgttype=REPORT");
	printQS.append("&printData=yes");
	printQS.append("&userName="+EgURLEncoder.encode(s_userName,"UTF-8"));
	printQS.append("&user_language="+userLanguage);
	printQS.append("&ec_criteria="+ec_criteria);
	printQS.append("&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""));
%>
	var s_qryString = "../servlet/com.eg.EcRepoLiteC?<%=printQS.toString()%>&ec_forPDF=No";
	print(s_qryString);
}

function savePdf()
{
<%
	if (tmapCitrixUsersAndApplications == null || tmapCitrixUsersAndApplications.isEmpty())
	{
%>
	alert('<egui:intnl text="configmgmt.common.No data available" />');
	return;
<%
	}
	session.setAttribute("PDF_URL",mngrIProc+"/final/servlet/com.eg.EcRepoLiteC;jsessionid="+session.getId()+"?"+printQS.toString()+"&ec_forPDF=Yes");
	session.setAttribute("REPORT_NAME","ThinClientUsersWithApplications");
	session.setAttribute("REPORT_LAYOUT","Portrait");
	session.setAttribute("PAGE_WIDTH_PDF","1100");
	session.setAttribute("PAGE_WIDTH_MAIL_IMAGE","1300");
	session.setAttribute("PAGE_HEIGHT_MAIL_IMAGE","768");
%>
	getPdf('<%=configSkin%>');
}

function mail()
{
<%
	if (tmapCitrixUsersAndApplications == null || tmapCitrixUsersAndApplications.isEmpty())
	{
%>
	alert('<egui:intnl text="configmgmt.common.No data available" />');
	return;
<%
	}
%>
	sendMail();
}

function getDetails()
{
	thisForm = document.CitrixUserApps;
	var compType = thisForm.ec_comptype.value;
	var component = thisForm.ec_component.value;

	var tempCriteria ="";
	var tempCriteriaPrevious ="";
	var tempUserOption ="";
	var tempUserOptionPrevious ="";
	if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
	{
		tempCriteria = thisForm.ec_criteria.value;
	}
	if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
	{
		tempUserOption = thisForm.ec_userOption.value;
	}
	if (thisForm.ec_criteriaPrevious != null && thisForm.ec_criteriaPrevious != undefined)
	{
		tempCriteriaPrevious = thisForm.ec_criteriaPrevious.value;
	}
	if (thisForm.ec_userOptionPrevious != null && thisForm.ec_userOptionPrevious != undefined)
	{
		tempUserOptionPrevious = thisForm.ec_userOptionPrevious.value;
	}
	if (tempCriteria != "" && tempCriteriaPrevious != "")
	{
		if (tempCriteria == tempCriteriaPrevious)
		{
			if (tempUserOption != tempUserOptionPrevious)
			{
				compType = null;
				component = null;
			}
		}
		else
		{
			compType = null;
			component = null;
		}
	}

	window.location.href = "../servlet/com.eg.EcConfigurationServlet?cmd=ThinClientApplications&ec_criteria="+tempCriteria+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious)+"&id=<%=id%>&request_from=<%=request_from%>";
}

function csv()
{
<%
	if (tmapCitrixUsersAndApplications == null || tmapCitrixUsersAndApplications.isEmpty())
	{
%>
		alert('<egui:intnl text="configmgmt.common.No data available" />');
		return;
<%
	}
%>
	thisForm = document.forms[0];
	thisForm.action = '../servlet/com.eg.EcCSVController?ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
	thisForm.submit();
}

function schedule(op)
{
	var checkFlag = validateforSchedule();
	if(checkFlag == false) return;
	var thisForm = document.CitrixUserApps;
	if (op == "schedule")
	{
<%
		if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
		{
%>
			thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>";
<%
		}
		else
		{
%>
			thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>&request_from=CitrixApplicationsAndUsers";
<%
		}
%>
	}
	else if (op =="favorite")
		thisForm.action = "/final/config/EcSaveFavorite.jsp";
	else
	{
		alert('<egui:intnl text="configmgmt.common.Illegal Access" />');
		return;
	}
	thisForm.submit();
}

function goBackToSaveSchedule()
{
	var thisForm = document.forms[0];
	thisForm.action = "/final/config/EcSaveSchedule.jsp?request_from=<%=request_from%>&id=<%=id%>";
	thisForm.submit();
}
</script>

<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" onLoad="bigScreen();">
<form name="CitrixUserApps" method="post" style="margin:0px">

	<input type="hidden" name="ec_rtype" value="CitrixApplicationsAndUsers">
	<input type="hidden" name="heading" value="<%=heading%>">
	<input type="hidden" name="userOption" value="User Applications">
	<input type="hidden" name="requestFrom" value="CurrentPage">
	<input type="hidden" name="old_comptype" value="<%=ec_comptype%>">
	<input type="hidden" name="ec_criteriaPrevious" value="<%=ec_criteria%>">
	<input type="hidden" name="ec_userOptionPrevious" value="<%=ec_userOption%>">

<table border="0" width="100%" height="100%" cellspacing="0" cellpadding="0" align="center">

	<tr>
		<td align="right" valign="middle" id="layer_headbg" height="18" width="100%" style="padding:0px;border-left-width:0px;border-right-width:0px">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="padding5">
				<tr>
					<td align="left" id="main_head_top" width="100%" nowrap>&nbsp;<b><egui:intnl text="configmgmt.configuration.THIN CLIENT USERS" /></b></td>
					<td>
<%
	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
%>
						<a id='mousehand' onClick="goBackToSaveSchedule();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;&nbsp;
						</a>
<%
	}
%>
					</td>
				</tr>
			</table>
		</td>
	</tr>

	<tr>
		<td valign="top" id="bgmedium" width="100%" height="100%">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">
			<!-- new tab start here -->
				<tr>
					<td id="padding6" style="padding-bottom:0px">
						<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0" id="toptable" style="table-layout:fixed">
							<col width="55"><col width="10"><col width="170">
							<col width="150"><col width="10"><col width="350">
							<tr>
								<td align="right" nowrap><b><egui:intnl text="configmgmt.common.View By" /></b></td>
								<td align="center"><b>:</b></td>
								<td valign="middle">
									<select name="ec_criteria" style="width:170px;" onChange='javascript:getDetails()'>
<%
	if (vecCriterias != null && !vecCriterias.isEmpty())
	{
		for(int i=0; i<vecCriterias.size(); i++)
		{
			String selected = "";
			String strCriteria = (String)vecCriterias.get(i);
			if(ec_criteria != null && strCriteria.equals(ec_criteria))
			{
				selected = "selected";
			}
%>
			<option value="<%=strCriteria%>" <%=selected%>>
				<egui:intnl text='<%="configmgmt.common."+strCriteria%>' />
			</option>
<%
		}
	}
	else
	{
%>
		<option value="-1">
			<egui:intnl text="configmgmt.common.Not Applicable" />
		</option>
<%
	}
%>
									</select>
								</td>
<%
	if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
	{
%>
								<td align="right" nowrap>
<%
		if (ec_criteria.equalsIgnoreCase(criterias[0]))
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[0]%>' /></b>
<%
		}
		else if (ec_criteria.equalsIgnoreCase(criterias[1]))
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[1]%>' /></b>
<%
		}
		else
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[2]%>' /></b>
<%
		}
%>
								</td>
								<td align="center"><b>:</b></td>
								<td>
									<select name="ec_userOption" style="width: 250px;" onChange='javascript:getDetails()'>
<%
		if (vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			for(int i=0; i<vecUserOptions.size(); i++)
			{
				String selected = "";
				String strUserOption = (String)vecUserOptions.get(i);
				if(ec_userOption != null && strUserOption.equals(ec_userOption))
				{
					selected = "selected";
				}
%>
				<option value="<%=strUserOption%>" <%=selected%>>
					<%=strUserOption%>
				</option>
<%
			}
		}
		else
		{
%>
			<option value="-1">
				<egui:intnl text="configmgmt.common.Not Applicable" />
			</option>
<%
		}
%>
									</select>
								</td>
<%
	}
	else
	{
%>
								<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
<%
	}
%>
							</tr>
						</table>
					</td>
				</tr>
				<!-- new tab end here -->
				<tr>
					<td id="padding6">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="toptable">
							<tr>
								<td>
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table-layout:fixed" id="text_bold"><col width="20"><col width="250"><col width="10"><col width="380"><col width="170">
										<tr>
											<td colspan="5" height="5" id="blank">&nbsp; </td>
										</tr>
										<tr>
											<td align="center">&nbsp;</td>
											<td nowrap align="right"><egui:intnl text="configmgmt.common.Component Type" /></td>
											<td align="center">:</td>
											<td nowrap align="left">
												<select name="ec_comptype" style="width:300px" onChange="javascript:getData()">
<%
	if (vec_componentTypes != null && !vec_componentTypes.isEmpty())
	{
%>
		<option value="-1"><egui:intnl text="configmgmt.common.Please choose a component type" /></option>
<%
		if (ec_comptype == null || ec_comptype.equals("-1"))
		{
			serverList = sorter.getSortedCompTypeList(vec_componentTypes);
			for (int i=0;i<serverList.size();i++)
			{
				EgName nameObj = (EgName)serverList.get(i);
				String actualName = nameObj.getActualName();
				String localName = nameObj.getLocalName();
	%>
			<option value="<%=actualName%>"><%=localName%></option>
<%
			}
		}
		else
		{
			serverList = sorter.getSortedCompTypeList(vec_componentTypes);
			for (int i=0;i<serverList.size();i++)
			{
				EgName nameObj = (EgName)serverList.get(i);
				String actualName = nameObj.getActualName();
				String localName = nameObj.getLocalName();
				String selected = "";
				if (actualName != null && actualName.equals(ec_comptype))
				{
					selected = "selected";
				}
%>
			<option value="<%=actualName%>" <%=selected%>><%=localName%></option>
<%
			}
		}
	}
	else
	{
%>
													<option value="-1">
														<egui:intnl text="configmgmt.common.Not Applicable" />
													</option>
<%
	}
%>
												</select>
											</td>
											<td align="center">&nbsp;</td>
										</tr>
										<tr>
											<td colspan="5" height="5" id="blank">&nbsp;</td>
										</tr>
										<tr>
											<td align="center">&nbsp;</td>
											<td nowrap align="right"><egui:intnl text="configmgmt.common.Component" /></td>
											<td align="center">:</td>
											<td nowrap>
												<select name="ec_component" onChange="javascript:getUsers()">
<%
	if (v_comp != null && !v_comp.isEmpty())
	{
%>
		<option value="-1"><egui:intnl text="configmgmt.common.Please choose a component" /></option>
<%
		for (int i=0;i<v_comp.size();i++)
		{
			String componentTemp = (String)v_comp.get(i);
			String tempCompName = "";
			String tempCompType = "";
			String selected = "";
			if (componentTemp != null)
			{
				tempCompName = componentTemp.substring(0,componentTemp.lastIndexOf(":"));
				if (tempCompName.endsWith(":NULL"))
					tempCompName = tempCompName.substring(0,tempCompName.indexOf(":"));
				tempCompType = componentTemp.substring(componentTemp.lastIndexOf(":")+1);
				//getting component type mapping name
				tempCompType = mappingInfo.getComponentTypeDescription(tempCompType);
				if (componentTemp.equals(ec_component))
				{
					selected = "selected";
				}
			}
%>
		<option value="<%=componentTemp%>" <%=selected%>><%=tempCompName + ":"+ tempCompType%></option>
<%
		}
	}
	else
	{
%>
													<option value="-1">
														<egui:intnl text="configmgmt.common.Not Applicable" />
													</option>
<%
	}
%>
												</select>
											</td>
											<td align="center">&nbsp;</td>
										</tr>
<%
	subTitle = mappingInfo.getTextDescription("configmgmt.common.Component") + " : " + componentName + ":" + componentType;
	if (heading.equalsIgnoreCase("List of Applications/Desktops/Contents With Users"))
	{
		subTitle = subTitle + "\n" + mappingInfo.getTextDescription("configmgmt.configuration.Farm name") + " : " + farmName;
%>
										<tr>
											<td colspan="5" height="5" id="blank">&nbsp;</td>
										</tr>

										<tr>
											<td align="center">&nbsp;</td>
											<td align="right"><egui:intnl text="configmgmt.configuration.Farm Name" /></td>
											<td align="center">:</td>
											<td align="left">
<%
		if (farmName == null)
		{
%>
			<input name="fsctrl" type="text" value='<egui:intnl text="configmgmt.common.Not Applicable" />' readonly disabled style="width:300px">
<%
		}
		else
		{
%>
			<input name="fsctrl" type="text" value="<%=farmName%>" readonly disabled style="width:300px">
<%
		}
%>
											</td>
											<td align="center">&nbsp;</td>
										</tr>
<%
	}
	else
	{
		subTitle = subTitle + "\n" + mappingInfo.getTextDescription("configmgmt.configuration.Server name") + " : " + serverName;
%>
										<tr>
											<td colspan="5" height="5" id="blank">&nbsp;</td>
										</tr>

										<tr>
											<td align="center">&nbsp;</td>
											<td align="right"><egui:intnl text="configmgmt.configuration.Server Name" /></td>
											<td align="center">:</td>
											<td align="left">
<%
		if (serverName == null)
		{
%>
			<input name="fsctrl" type="text" value='<egui:intnl text="configmgmt.common.Not Applicable" />' readonly disabled style="width:300px">
<%
		}
		else
		{
%>
			<input name="fsctrl" type="text" value="<%=serverName%>" readonly disabled style="width:300px">
<%
		}
%>
											</td>
											<td align="center">&nbsp;</td>
										</tr>
<%
	}
%>
										<tr>
											<td colspan="5" height="5" id="blank">&nbsp;</td>
										</tr>
										<tr>
											<td align="center">&nbsp;</td>
											<td nowrap align="right"><egui:intnl text="configmgmt.configuration.User" /></td>
											<td align="center">:</td>
											<td nowrap>
												<select name="userName" style="width:300px;">
<%
	if (tmapCitrixUsersAndApplications != null && tmapCitrixUsersAndApplications.size()>0)
	{
%>
		<option value="-1"><egui:intnl text="configmgmt.configuration.Please select an user" /></option>
<%
		if (tmapCitrixUsersAndApplications.size() > 1)
		{
%>
			<option value="All" <%="All".equalsIgnoreCase(userName)?"selected":""%>>All</option>
<%
		}

		Iterator userAsKeys = tmapCitrixUsersAndApplications.keySet().iterator();
		while (userAsKeys.hasNext())
		{
			String userKey = (String)userAsKeys.next();
%>
			<option value="<%=userKey%>" <%=userKey.equalsIgnoreCase(userName)?"selected":""%>><%=userKey%></option>
<%
		}
	}
	else
	{
%>
		<option value= "-1"><egui:intnl text="configmgmt.common.Not Applicable" /></option>
<%
	}
%>
												</select>
											</td>
											<td align="center">&nbsp;</td>
										</tr>
										<tr>
											<td colspan="5" height="5" id="blank">&nbsp;</td>
										</tr>
										<tr>
											<td  colspan="3" align="center">&nbsp;</td>
											<td align="left">
												<table border="0" cellspacing="0" cellpadding="0" width="70%">
													<tr>
														<td align="center" width="100%" height="20">
<%
	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
%>
														<input type="button" name="btnsubmit" value='<egui:intnl text="configmgmt.common.SAVE" />' id="darkbutton" style="width: 75px; height: 20px;" href="" onClick="schedule('schedule');">
<%
	}
	else
	{
%>
														<input type="button" name="x" value='<egui:intnl text="configmgmt.common.SUBMIT" />' id="darkbutton" style="width: 75px; height: 20px;" onClick="javascript:getUserApplications()">
<%
	}
%>
														</td>
													</tr>
												</table>
											</td>
											<td align="right" style="height:24" valign="bottom" >
												<table align="right" cellspacing="0" cellpadding="0" border="0" height="20"> 
													<tr>
														<td width="50" align="center" id="leftcurve"><img src="/final/config/images/spacer.gif" width="50px" height="20px"> </td>
														<td width="2" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif" width="2"></td>
														<td align="center" id="leftcurvebg"><img class="mouse" src="../config/images/print.gif" border="0" title='<egui:intnl text="configmgmt.common.PRINT" />' onClick="javascript:printData()"> </td>
														<td width="12" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif" width="12"></td>
														<td align="center" id="leftcurvebg"><img class="mouse" src= "../config/images/pdf.gif" border="0" title='<egui:intnl text="configmgmt.common.PDF" />' onClick="javascript:savePdf();"> </td>
														<td width="12" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="12"></td>
														<td align="center" id="leftcurvebg"><img class="mouse" src="../config/images/mail.gif" border="0" title='<egui:intnl text="configmgmt.common.MAIL" />' onClick="javascript:mail()"></td>
														<td width="12" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="12"></td>
														<td align="center" id="leftcurvebg"><img class="mouse" src="../config/images/csv.gif" border="0" title='<egui:intnl text="configmgmt.common.CSV" />' onClick="javascript:csv()"></td>
														<td width="12" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="12"></td>
														<td align="center" id="leftcurvebg"><img class="mouse" src="../config/images/schedules.gif" border="0" title='<egui:intnl text="configmgmt.common.ADD TO SCHEDULES" />' onClick="javascript:schedule('schedule')"> </td>
														<td width="12" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="12"></td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>

				<tr>
					<td id="padding6" height="100%" width="100%" style="padding-top:0px">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" id="bottomtable">
							<tr>
								<td align="center" valign="top">
									<table border="0" width="100%" cellspacing="0" cellpadding="0" class="body_text">
<%
	if (aListCitrixUserApplications != null && submitOrNot.equals("true"))
	{
		int applicationSize = aListCitrixUserApplications.size();

		//For New Pdf Framework - Krishnamurthi
		ArrayList aListPdfData = new ArrayList();
		EgPdfData pdfData = new EgPdfData();
	
		EgReportAttributes reportAttributes = new EgReportAttributes();

		String pdfTitle = "";
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.THIN CLIENT USERS REPORT") + " IN" + " '" + ec_userOption + "' "  +  ec_criteria + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		else
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.THIN CLIENT USERS REPORT") + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		reportAttributes.setMainTitle(pdfTitle);

		reportAttributes.setReportName("ThinClientUsers");
		reportAttributes.setModule("CONFIG");
		reportAttributes.setPortrait(true);

		EgTableAttributes egTableAttributes = new EgTableAttributes();
		String user = userName;
		/*
		if (userName.indexOf("\\") != -1)
		{
			StringBuffer strBuffer = new StringBuffer(userName);
			strBuffer.insert(userName.indexOf("\\")+1,"\\");
			user = strBuffer.toString();
		}
		*/
		egTableAttributes.setTitle(mappingInfo.getTextDescription("configmgmt.configuration.Total applications for")+" "+user+" : "+applicationSize);

		subTitle = subTitle + "\n" + mappingInfo.getTextDescription("configmgmt.configuration.User") + " : " + user;
		reportAttributes.setSubTitle(subTitle);

		ArrayList aListColumnNames = new ArrayList();
		ArrayList aListData = new ArrayList();
		ArrayList userColumnNames = new ArrayList();

		for (int x=0; x<4; x++)
			aListColumnNames.add("C"+x);

		userColumnNames.add(mappingInfo.getTextDescription("configmgmt.configuration.List of applications"));
		userColumnNames.add("");
		userColumnNames.add("");
		userColumnNames.add("");
%>
										<input type="hidden" name="submitClicked" value="true">
										<tr>
											<td width="100%"id="bgdark" class="whitefont"  height="20" colspan="4"> &nbsp;<egui:intnl text="configmgmt.configuration.Total applications for" /> <%=userName%>&nbsp;:&nbsp;<%=applicationSize%> </td>
										</tr>

										<tr>
											<td width="100%" height="20" colspan="4" class="bgdarkimg"><b><egui:intnl text="configmgmt.configuration.List of applications" /></b></td>
										</tr>
<%
		for (int d=0; d<applicationSize; d=d+4)
		{
%>
										<tr>
<%
			for (int e=d; e<d+4; e++)
			{
				if (e<applicationSize)
				{
					aListData.add((String)aListCitrixUserApplications.get(e));
%>
											<td id="cell_bg1" width="25%"> <a href="javascript:getApplicationUsers('<%=aListCitrixUserApplications.get(e)%>')" class="eg_monlink"><%=aListCitrixUserApplications.get(e)%></a> </td>
<%
				}
				else
				{
					aListData.add(" ");
%>
											<td id="cell_bg1" width="25%"> &nbsp; </td>
<%
				}
			}
%>
										</tr>
<%
		}

		//For Pdf
		EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);
		egTableAttributes.setColumnNames(userColumnNames);

		EgTable egTable = new EgTable();
		egTable.setModel(egTableModel);
		egTable.setAttributes(egTableAttributes);

		aListPdfData.add(egTable);

		pdfData.setAttributes(reportAttributes);
		pdfData.setData(aListPdfData);
		session.setAttribute("pdfData",pdfData);
	}
	else if (userName != null && userName.equalsIgnoreCase("All") && submitOrNot.equals("true"))
	{
		//For PDF
		ArrayList aListPdfData = new ArrayList();
		EgPdfData pdfData = new EgPdfData();

		EgReportAttributes reportAttributes = new EgReportAttributes();
		reportAttributes.setMainTitle(mappingInfo.getTextDescription("configmgmt.configuration.THIN CLIENT USERS"));
		reportAttributes.setReportName("ThinClientUsers");
		reportAttributes.setModule("CONFIG");
		reportAttributes.setPortrait(true);

		subTitle = subTitle + "\n" + mappingInfo.getTextDescription("configmgmt.configuration.List of users with their associated applications");
		reportAttributes.setSubTitle(subTitle);

		ArrayList aListData = new ArrayList();

		ArrayList aListColumnNames = new ArrayList();
		aListColumnNames.add("User");
		aListColumnNames.add("Application1");
		aListColumnNames.add("Application2");
		aListColumnNames.add("Application3");

		ArrayList userColumnNames = new ArrayList();
		userColumnNames.add("");
		userColumnNames.add(mappingInfo.getTextDescription("configmgmt.configuration.Applications"));
		userColumnNames.add("");
		userColumnNames.add("");

		EgTableAttributes egTableAttributes = new EgTableAttributes();
		egTableAttributes.setColumnNames(userColumnNames);
		egTableAttributes.setStartX(0);
		egTableAttributes.setDataGrouping(true);
		egTableAttributes.setDataGroupingField(0);
%>
										<input type="hidden" name="submitClicked" value="true">
										<tr>
											<td width="100%" id="bgdark" class="whitefont" height="20">&nbsp;<egui:intnl text="configmgmt.configuration.List of users with their associated applications" /></td>
										</tr>

										<tr>
											<td align="center">
												<table border="0" cellspacing="0" cellpadding="0" class="body_text" width="100%">
													<tr>
														<td width="20%" id="tdbacklightcolor3" align="left" class="cell_border" height="20">&nbsp;<b><egui:intnl text="configmgmt.configuration.User" /></b></td>
														<td width="80%" id="tdbacklightcolor3" align="center" height="20">
															<table cellspacing="0" cellpadding="0" border="0" class="body_text">
																<tr>
																	<td valign="top"> <b><egui:intnl text="configmgmt.configuration.Applications" /></b></td>
																</tr>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>

										<tr>
											<td valign="top">
												<table border="0" cellspacing="0" cellpadding="0" width="100%" class="body_text">
<%
		Iterator userAsKeys = tmapCitrixUsersAndApplications.keySet().iterator();
		while (userAsKeys.hasNext())
		{
			String userKey = (String)userAsKeys.next();
			ArrayList aListApplications = (ArrayList)tmapCitrixUsersAndApplications.get(userKey);
%>
													<tr>
														<td width="20%" align="left" valign="top" id="cell_bg1" style="padding-top:0px" height="20"><%=userKey%></td>
														<td width="80%">
															<table cellspacing="0" cellpadding="0" border="0" class="body_text" width="100%">
<%
			for (int d=0; d<aListApplications.size(); d=d+3)
			{
				aListData.add(mappingInfo.getTextDescription("configmgmt.configuration.User")+" : "+userKey);
%>
																<tr>
<%
				for (int e=d; e<d+3; e++)
				{
					if (e<aListApplications.size())
					{
						String applicationKey = (String)aListApplications.get(e);
						aListData.add(applicationKey);
%>
																	<td id="cell_bg1" width="25%" height="20" valign="top"><a href="javascript:getApplicationUsers('<%=applicationKey%>')" class="eg_monlink"><%=applicationKey%></a></td>
<%
					}
					else
					{
						aListData.add("");
%>
																	<td id="cell_bg1" width="25%" height="20">&nbsp;</td>
<%
					}
				}
%>
																</tr>
<%
			}
%>
															</table>
														</td>
													</tr>
<%
		}
%>
												</table>
											</td>
										</tr>
<%
		//For PDF
		EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);
		EgTable egTable = new EgTable();
		egTable.setModel(egTableModel);
		egTable.setAttributes(egTableAttributes);
		aListPdfData.add(egTable);

		pdfData.setAttributes(reportAttributes);
		pdfData.setData(aListPdfData);
		session.setAttribute("pdfData",pdfData);
	}
	else
	{
%>
										<tr>
											<td width="100%" height="100%">
												<table border="0" align="center" width="100%" class="body_text" cellspacing="0" cellpadding="0" height="100%">
													<tr>
														<td align="center"height="100%">
															&nbsp;
														</td>
													</tr>
												</table>
											</td>
										</tr>
<%
	}
%>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</form>
</body>
</html>



