<%
/*
 *   File			:	EcCompareConfiguration.jsp
 *   Purpose		:	To compare component configuration
 *   Creation Date	:	02/10/2009
 *   Author			:	Krishnamurthi
 *   UI Design		:	Krishnamurthi and Vijayakumar
*/
%>

<%@ include file="EcTracker.jsp" %>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import="com.eg.EgSpecsInfo"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.User"%>
<%@ page import="com.egurkha.UserRegistry"%>
<%@ page import="java.util.*"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="com.eg.EgName"%>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<%!
	String[] criterias = {"Zone","Service","Segment","Component"};
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");

	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	String componentType = request.getParameter("componentType");
	String o_componentType = request.getParameter("old_comptype");
	String[] s_selectedInformations = request.getParameterValues("tests");
	String referenceComponent = request.getParameter("referenceComponent");
	String o_referenceComponent = request.getParameter("old_referenceComponent");
	String[] s_otherComponents = request.getParameterValues("otherComponents");

	String requestFrom = (String)request.getParameter("request_from");
	if (requestFrom != null && requestFrom.equalsIgnoreCase("CompareComponentConfigPage"))
	{
		componentType = (String)request.getAttribute("componentType");
		o_componentType = (String)request.getAttribute("old_comptype");
		s_selectedInformations = (String[])request.getAttribute("tests");
		referenceComponent = (String)request.getAttribute("referenceComponent");
		o_referenceComponent = (String)request.getAttribute("old_referenceComponent");
		s_otherComponents = (String[])request.getAttribute("otherComponents");
	}
	String ec_criteria = (String)session.getAttribute("ec_criteria");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");

	if (ec_criteria != null && 
		ec_criteriaPrevious != null && 
		!ec_criteriaPrevious.equals(ec_criteria))
	{
		componentType = null;
		s_selectedInformations = null;
	}

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
	String ec_userOptionPrevious = request.getParameter("ec_userOptionPrevious");

	if (ec_userOption != null && 
		ec_userOptionPrevious != null && !ec_userOptionPrevious.equals(ec_userOption) && 
		ec_criteria != null && ec_criteriaPrevious != null)
	{
		componentType = null;
		s_selectedInformations = null;
	}
	ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");

	ArrayList serverList = new ArrayList();
	ArrayList sortedTestList = new ArrayList();
	Vector vecComponentTypes = new Vector();
	//Vector vec_ctypes = new Vector(user.getServerTypes());
	Vector vec_ctypes = new Vector();
	vec_ctypes.addAll(aListAssociatedComponents);
	for (int i=0; i<vec_ctypes.size(); i++)
	{
		String str = (String) vec_ctypes.get(i);
		String component_type = str.substring(0,str.indexOf(":"));
		//String component_type = (String)vec_ctypes.get(i);
		boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_type);
		if (!isConfigTestEnabled) continue;
		if (!vecComponentTypes.contains(component_type))
		{
			vecComponentTypes.add(component_type);
		}
	}
	if (vecComponentTypes.contains("Host_system"))
	{
		vecComponentTypes.remove("Host_system");
	}

	ArrayList al_components = null;
	if (componentType != null && !componentType.equals("-1"))
	{
		al_components = new ArrayList();
		ArrayList aListTemp = aListAssociatedComponents;
		for (int k=0;k<aListTemp.size();k++)
		{
			String strComp = (String)aListTemp.get(k);
			String component_type = strComp.substring(0,strComp.indexOf(":"));
			if (!component_type.equals(componentType)) continue;
			boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_type);
			if (!isConfigTestEnabled) continue;
			String component_name = strComp.substring(strComp.indexOf(":")+1);
			al_components.add(component_name+":"+component_type);
		}
	}

	if (componentType != null && !componentType.equalsIgnoreCase(o_componentType))
	{
		s_selectedInformations = null;
		referenceComponent = null;
		s_otherComponents = null;
	}

	if (referenceComponent == null || referenceComponent.equals("-1"))
	{
		if (al_components != null && !al_components.isEmpty())
		{
			referenceComponent = (String)al_components.get(0);
		}
	}

	ArrayList aListEnabledConfigTests = null;
	if (componentType != null && !componentType.equals("-1"))
	{
		aListEnabledConfigTests = specsInfo.getEnabledTests(componentType,true);
		if (aListEnabledConfigTests != null)
		{
			sortedTestList = sorter.getSortedTestList(aListEnabledConfigTests);
		}
	}

	List l_selectedInformations = null;
	if (s_selectedInformations != null && !s_selectedInformations[0].equals("-1"))
	{
		l_selectedInformations = Arrays.asList(s_selectedInformations);

		if (aListEnabledConfigTests != null)
		{
			sortedTestList = sorter.getSortedTestList(aListEnabledConfigTests);
		}
	}

	if (referenceComponent != null && !referenceComponent.equalsIgnoreCase(o_referenceComponent))
	{
		s_otherComponents = null;
	}

	List l_otherComponents = null;
	if (s_otherComponents != null && !s_otherComponents[0].equals("-1"))
	{
		l_otherComponents = Arrays.asList(s_otherComponents);
	}
	else if (s_otherComponents == null || s_otherComponents[0].equals("-1"))
	{
		if (al_components != null && al_components.size() > 1)
		{
			ArrayList aList_temp = new ArrayList();
			for (int i=0;i<al_components.size();i++)
			{
				String strComp = (String)al_components.get(i);
				if (strComp.equals(referenceComponent)) continue;
				aList_temp.add(strComp);
				break;
			}
			l_otherComponents = aList_temp;
		}
	}

	ArrayList aListSimilarComponents = (ArrayList)request.getAttribute("aListSimilarComponents");
	ArrayList aListDissimilarComponents = (ArrayList)request.getAttribute("aListDissimilarComponents");

	session.setAttribute("componentType",componentType);
	session.setAttribute("tests",s_selectedInformations);
	session.setAttribute("referenceComponent",referenceComponent);
	session.setAttribute("otherComponents",s_otherComponents);
%>

<!Doctype html>
<head>
<title></title>
<meta name="Author" content="Krishnamurthi">
<style>

body {
	overflow:hidden
}

.div_scroll {
	position:relative;
	overflow:scroll;
	overflow-x:scroll;
	overflow-y:scroll;
	padding:0px;
	margin:0px;
}

table {
	font-family:Verdana,Tahoma,Calibri,Arial,Helvetica,sans-serif;
	font-size:11.5px;
}

#leftDiv {
	border-left: 2px solid #999999;
	border-top: 2px solid #999999;
	border-bottom:2px solid #f2f2f2;
	border-right:2px solid #f2f2f2;
	margin:0px;
	padding:0px;
}

#rightDiv {
	border-left: 2px solid #999999;
	border-top: 2px solid #999999;
	border-bottom:2px solid #f2f2f2;
	border-right:2px solid #f2f2f2;
	margin:0px;
	padding:0px;
}

.bold {
	font-weight:bold;
}

.tableBorder {
	border: 1px solid #BCBABB;
	border-collapse: collapse;
}

.tdBorder {
	border: 1px solid #BCBABB;
	background-color: #ffffff;
}

.tdBorder2 {
	border: 1px solid #BCBABB;
	background-color: #D6D6D6;
}
</style>
<egui:skin ui="config"/>
<script type="text/javascript" src="/final/jquery/jquery.js"></script>
<script language="JavaScript1.2">
function get()
{
	var thisForm = document.forms[0];
	thisForm.action = "../config/EcCompareConfiguration.jsp";
	thisForm.submit();
}

function showDetails(path)
{
	var thisForm = document.forms[0];

	var tempCriteria = "";
	var tempUserOption = "";
	if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
	{
		tempCriteria = thisForm.ec_criteria.value;
	}
	if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
	{
		tempUserOption = thisForm.ec_userOption.value;
	}

	if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
	{
		if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
		{
			if (tempCriteria == "Zone")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
				return false;
			}
			else if (tempCriteria == "Service")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
				return false;
			}
			else if (tempCriteria == "Segment")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
				return false;
			}
		}
	}

	var server = thisForm.componentType.value;
	if (server == -1)
	{
		alert('<egui:intnl text="configmgmt.common.Please select a component type" />');
		return;
	}

	var information = thisForm.tests.value;
	if (information == "-1" || information == '')
	{
		alert('<egui:intnl text="configmgmt.common.Please select atleast one Information for the choosen component type" />');
		return;
	}

	var comps = thisForm.otherComponents.value;
	if (comps == "-1" || comps == '')
	{
		alert('<egui:intnl text="configmgmt.common.Please select atleast one component for comparison with reference component" />');
		return;
	}

	if(path == "submit")
	{
		thisForm.action = "../servlet/com.eg.EcConfigurationServlet";
		thisForm.submit();
		thisForm.x.value = '<egui:intnl text="configmgmt.common.Loading" />'+'...';
		thisForm.x.disabled = true;
	}
}

function showComponentChanges(comp)
{
	window.location.href = '../config/ecCompareComponentConfig.jsp?componentName='+comp+'&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
}

function getDetails()
{
	thisForm = document.CompareConfig;
	thisForm.action = "../servlet/com.eg.EcConfigurationServlet?cmd=CompareConfig";
	thisForm.submit();
}

var $j = jQuery.noConflict();
$j(document).ready(function(){
	$j('#leftDiv') .css({'height': (($j(window).height()) - 380)+'px'});
	$j('#rightDiv') .css({'height': (($j(window).height()) - 380)+'px'});
	$j('#leftDiv') .css({'width': (($j(window).width()/2) - 24)+'px'});
	$j('#rightDiv') .css({'width': (($j(window).width()/2) - 24)+'px'});
	bigScreenPage();
});

$j(window).resize(function(){
	$j('#leftDiv') .css({'height': (($j(window).height()) - 380)+'px'});
	$j('#rightDiv') .css({'height': (($j(window).height()) - 380)+'px'});
	$j('#leftDiv') .css({'width': (($j(window).width()/2) - 24)+'px'});
	$j('#rightDiv') .css({'width': (($j(window).width()/2) - 24)+'px'});
	bigScreenPage();
});

documentView = {
	getObject: function()
	{
		if(typeof( window.innerWidth) == 'number')
		{//Firefox
			this.height = window.innerHeight;
			this.width = window.innerWidth-10;
			this.fireFox = true;
		}
		else if( document.documentElement && ( document.documentElement.clientWidth
			|| document.documentElement.clientHeight ))
		{//IE 6 + in 'standards compliant mode'
			this.height = document.documentElement.clientHeight;
			this.width = document.documentElement.clientWidth;
			this.ie = true;
		}
		else if(document.body && document.body.clientHeight)
		{ //IE 4 compatible
			this.height = document.body.clientHeight;
			this.width = document.body.clientWidth;
			this.ie = true;
		}
		this.screenHeight=window.screen.availHeight;
		this.screenWidth=window.screen.availWidth;
		return this;
	},
	getScreenHeight: function()
	{
		return this.getObject().screenHeight;
	},
	getScreenWidth: function()
	{
		return this.getObject().screenWidth;
	},
	getHeight: function()
	{
		return this.getObject().height;
	},
	getWidth: function()
	{
		return this.getObject().width;
	},
	isIE: function()
	{
		return this.getObject().ie;
	},
	isFireFox: function()
	{
		return this.getObject().fireFox;
	}
};

var old_width=0;
function bigScreenPage()
{
	if(old_width==0)
	{
		old_width=1000;
	}
	var selectEleObj = document.getElementsByTagName('select');
	if(selectEleObj!=null && selectEleObj!=undefined)
	{
		var countSelect=selectEleObj.length;
		for(var i=0;i<countSelect;i++)
		{
			var selectWidth = selectEleObj[i].offsetWidth;
			if(selectWidth!=null && selectWidth!=undefined)
			{
				var newSelectWidth=parseInt((parseInt(selectWidth)/old_width) * documentView.getWidth());
				selectEleObj[i].style.width=(newSelectWidth)+"px";
			}
		}
	}
	old_width=documentView.getWidth();
}
</script>
</head>

<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" scrolling="no" style="overflow:hidden">
<form name="CompareConfig" method="post" style="margin:0px;padding:0px;">
<input type="hidden" name="ec_rtype" value="Comparison">
<input type="hidden" name="ec_trgttype" value="Configuration Report">
<input type="hidden" name="old_comptype" value="<%=componentType%>">
<input type="hidden" name="old_referenceComponent" value="<%=referenceComponent%>">
<input type="hidden" name="ec_criteriaPrevious" value="<%=ec_criteria%>">
<input type="hidden" name="ec_userOptionPrevious" value="<%=ec_userOption%>">

	<table align="center" cellspacing="0" cellpadding="0" border="0" width="100%" height="100%" class="bgmedium">

		<tr>
			<td align="right" valign="middle" id="layer_headbg" height="24" width="100%" style="padding:0px;border-left-width:0px;border-right-width:0px">
				<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
					<tr>
						<td align="left" id="main_head_top" width="77%" nowrap>
							&nbsp;<b><egui:intnl text="configmgmt.compare.COMPONENT CONFIGURATION COMPARISON" /></b>
						</td>
					</tr>
				</table>
			</td>
		</tr>

		<tr>
			<td valign="top" id="bgmedium" width="100%" height="100%">
				<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">
				<!-- new tab start here -->
					<tr>
						<td id="padding6" style="padding-bottom:0px">
							<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0" id="toptable" style="table-layout:fixed">
								<col width="55"><col width="10"><col width="170">
								<col width="150"><col width="10"><col width="350">
								<tr>
									<td align="right" nowrap><b><egui:intnl text="configmgmt.common.View By" /></b></td>
									<td align="center"><b>:</b></td>
									<td valign="middle">
										<select name="ec_criteria" style="width:170px;" onChange='javascript:getDetails()'>
<%
	if (vecCriterias != null && !vecCriterias.isEmpty())
	{
		for(int i=0; i<vecCriterias.size(); i++)
		{
			String selected = "";
			String strCriteria = (String)vecCriterias.get(i);
			if(ec_criteria != null && strCriteria.equals(ec_criteria))
			{
				selected = "selected";
			}
%>
			<option value="<%=strCriteria%>" <%=selected%>>
				<egui:intnl text='<%="configmgmt.common."+strCriteria%>' />
			</option>
<%
		}
	}
	else
	{
%>
		<option value="-1">
			<egui:intnl text="configmgmt.common.Not Applicable" />
		</option>
<%
	}
%>
										</select>
									</td>
<%
	if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
	{
%>
									<td align="right" nowrap>
<%
		if (ec_criteria.equalsIgnoreCase(criterias[0]))
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[0]%>' /></b>
<%
		}
		else if (ec_criteria.equalsIgnoreCase(criterias[1]))
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[1]%>' /></b>
<%
		}
		else
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[2]%>' /></b>
<%
		}
%>
									</td>
									<td align="center"><b>:</b></td>
									<td>
										<select name="ec_userOption" style="width: 250px;" onChange='javascript:getDetails()'>
<%
		if (vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			for(int i=0; i<vecUserOptions.size(); i++)
			{
				String selected = "";
				String strUserOption = (String)vecUserOptions.get(i);
				if(ec_userOption != null && strUserOption.equals(ec_userOption))
				{
					selected = "selected";
				}
%>
				<option value="<%=strUserOption%>" <%=selected%>>
					<%=strUserOption%>
				</option>
<%
			}
		}
		else
		{
%>
			<option value="-1">
				<egui:intnl text="configmgmt.common.Not Applicable" />
			</option>
<%
		}
%>
										</select>
									</td>
<%
	}
	else
	{
%>
									<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
<%
	}
%>
								</tr>
							</table>
						</td>
					</tr>
					<!-- new tab end here -->
					<tr>
						<td width="100%" valign="top">
							<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">
								<tr>
									<td id="padding6" valign="top">
										<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="toptable">
											<tr>
												<td>
													<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text" style="table-layout:fixed">
														<col width="25%"><col width="75%">
														<tr>
															<td  height="5" id="blank" colspan="2">&nbsp; </td>
														</tr>

														<tr>
															<td align="right">&nbsp;&nbsp;<b><egui:intnl text="configmgmt.compare.Component Type" />&nbsp;:&nbsp;</b></td>
															<td align="left">
																<select name="componentType" onChange="javascript:get();" style="width:220px">
<%
	if (vecComponentTypes != null && !vecComponentTypes.isEmpty())
	{
%>
													<option value="-1">
														<egui:intnl text="configmgmt.common.Please choose a component type" />
													</option>
<%
		serverList = sorter.getSortedCompTypeList(vecComponentTypes);
		for (int i=0; i<serverList.size(); i++)
		{
			EgName nameObj = (EgName)serverList.get(i);
			String actualName = nameObj.getActualName();
			String localName = nameObj.getLocalName();
			String selected = "";
			if (actualName.equals(componentType))
			{
				selected = "selected";
			}
%>
			<option value="<%=actualName%>" <%=selected%>><%=localName%></option>
<%
		}
	}
	else
	{
%>
													<option value="-1">
														<egui:intnl text="configmgmt.common.Not Applicable" />
													</option>
<%
	}
%>
																</select>
															</td>
														</tr>
													</table>
												</td>
											</tr>

											<tr>
												<td height="5" id="blank">&nbsp;</td>
											</tr>

											<tr>
												<td align="center">
													<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text" style="table-layout:fixed">
														<col width="25%"><col width="75%">
														<tr>
															<td align="right" nowrap valign="top"><b><egui:intnl text="configmgmt.compare.Information" />&nbsp;:&nbsp;</b></td>
															<td nowrap align="left" valign="top">
																<select name="tests" style="width: 300px;" size="6" multiple>
<%
	if (s_selectedInformations != null)
	{
		for (int i=0;i<sortedTestList.size();i++)
		{
			EgName nameObj = (EgName)sortedTestList.get(i);
			String strTestName = nameObj.getActualName();
			String strDispName = nameObj.getLocalName();
			String tmpSelectedStatus = "";

			if (l_selectedInformations.contains(strTestName))
				tmpSelectedStatus = "selected";
			else
				tmpSelectedStatus = "";
%>
			<option VALUE="<%=strTestName%>" <%=tmpSelectedStatus%>>
				<%=strDispName%>
			</option>
<%
		}
	}
	else
	{
		if (sortedTestList!=null && sortedTestList.size()>0)
		{
			for (int i=0;i<sortedTestList.size();i++)
			{
				EgName nameObj = (EgName)sortedTestList.get(i);
				String strTestName = nameObj.getActualName();
				String strDispName = nameObj.getLocalName();
				String strSelected = "";
				if (i == 0)
				{
					strSelected = "selected";
				}
%>
				<option VALUE="<%=strTestName%>" <%=strSelected%>>
				<%=strDispName%>
				</option>
<%
			}
		}
		else
		{
%>
			<option VALUE= "-1"><egui:intnl text="configmgmt.common.Not Applicable" /></option>
<%
		}
	}
%>
																</select>
															</td>
														</tr>
													</table>
												</td>
											</tr>

											<tr>
												<td height="5" id="blank">&nbsp;</td>
											</tr>

											<tr>
												<td>
													<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text" style="table-layout:fixed">
														<col width="25%"><col width="75%">
														<tr>
															<td align="right">&nbsp;&nbsp;<b><egui:intnl text="configmgmt.compare.Reference Component" />&nbsp;:&nbsp;</b></td>
															<td align="left">
																<select name="referenceComponent" onChange="javascript:get();" style="width:300px;">
<%
	if (al_components != null)
	{
		for (int k=0;k<al_components.size();k++)
		{
			String strComponent = (String)al_components.get(k);
			String tempCompName = strComponent.substring(0,strComponent.lastIndexOf(":"));
			if (tempCompName.endsWith(":NULL"))
			{
				tempCompName = tempCompName.substring(0,tempCompName.indexOf(":"));
			}
			String selected = "";
			if (strComponent.equals(referenceComponent))
			{
				selected = "selected";
			}
%>
							<option value="<%=strComponent%>" <%=selected%>><%=tempCompName%></option>
<%
		}
	}
	else
	{
%>
							<option value= "-1" selected>
								<egui:intnl text="configmgmt.common.Not Applicable" />
							</option>
<%
	}
%>
																</select>
															</td>
														</tr>
													</table>
												</td>
											</tr>

											<tr>
												<td height="5" id="blank">&nbsp;</td>
											</tr>

											<tr>
												<td>
													<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text" style="table-layout:fixed">
														<col width="25%"><col width="75%">
														<tr>
															<td align="right" valign="top">&nbsp;&nbsp;<b><egui:intnl text="configmgmt.compare.Other Components" />&nbsp;:&nbsp;</b></td>
															<td align="left">
																<select name="otherComponents" size="5" multiple style="width:300px;">
<%
	if (al_components != null)
	{
		for (int k=0;k<al_components.size();k++)
		{
			String strComponent = (String)al_components.get(k);
			String tempCompName = strComponent.substring(0,strComponent.lastIndexOf(":"));
			if (tempCompName.endsWith(":NULL"))
			{
				tempCompName = tempCompName.substring(0,tempCompName.indexOf(":"));
			}
			if (strComponent.equals(referenceComponent)) continue;
			String selected = "";
			if (l_otherComponents != null && l_otherComponents.contains(strComponent))
			{
				selected = "selected";
			}
%>
							<option value="<%=strComponent%>" <%=selected%>><%=tempCompName%></option>
<%
		}
	}
	else
	{
%>
							<option value= "-1" selected>
								<egui:intnl text="configmgmt.common.Not Applicable" />
							</option>
<%
	}
%>
																</select>
															</td>
														</tr>
													</table>
												</td>
											</tr>

											<tr>
												<td height="5" id="blank">&nbsp;</td>
											</tr>

											<tr>
												<td align="center">
													<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text" >
														<tr>
															<td align="center" width="70%"><input type="button" name="x" value='<egui:intnl text="configmgmt.common.SUBMIT" />' id="darkbutton" style="width: 75px; height: 20px;" onClick="javascript:showDetails('submit')">
															</td>
														</tr>
													</table>
												</td>
											</tr>

											<tr>
												<td height="5" id="blank">&nbsp;</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>

					<tr>
						<td id="padding6" height="100%" width="100%" valign="top" style="padding-top:0px">
							<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="bottomtable" height="100%" valign="top">
								<tr>
									<td align="center" valign="top" class="cellbglight">
										<table width="100%" cellpadding="6" cellspacing="0" border="0">
											<tr>
												<td class="bgdark whitefont" width="50%" align="left"><egui:intnl text="configmgmt.compare.SIMILAR COMPONENTS" /></td>
												<td class="bgdark whitefont" width="50%" align="left"><egui:intnl text="configmgmt.compare.DISSIMILAR COMPONENTS" /></td>
											</tr>
											<tr>
												<td width="50%" valign="top" style="padding-right:0px;" align="left" class="cellbglight">
												<div id="leftDiv" class="div_scroll eg_whitebg" style="height:243px;width:485px;">
													<table width="100%" cellpadding="2" cellspacing="0" border="0" valign="top">
<%
	if (aListSimilarComponents != null)
	{
		for (int m=0;m<aListSimilarComponents.size();m++)
		{
			String similarComponent = (String)aListSimilarComponents.get(m);
			String tempCompName = similarComponent.substring(0,similarComponent.lastIndexOf(":"));
			if (tempCompName.endsWith(":NULL"))
			{
				tempCompName = tempCompName.substring(0,tempCompName.indexOf(":"));
			}
%>
														<tr>
															<td id="cell_bg1" style="border-right-width:0px">&nbsp;<%=tempCompName%></td>
														</tr>
<%
		}
	}
%>
													</table>
												</div>
												</td>
												<td width="50%" style="padding-left:0px;" class="cellbglight" align="right">
												<div id="rightDiv" class="div_scroll eg_whitebg" style="height:243px;width:485px">
													<table width="100%" cellpadding="2" cellspacing="0" border="0" valign="top">
<%
	if (aListDissimilarComponents != null)
	{
		for (int n=0;n<aListDissimilarComponents.size();n++)
		{
			String dissimilarComponent = (String)aListDissimilarComponents.get(n);
			String tempCompName = dissimilarComponent.substring(0,dissimilarComponent.lastIndexOf(":"));
			if (tempCompName.endsWith(":NULL"))
			{
				tempCompName = tempCompName.substring(0,tempCompName.indexOf(":"));
			}
%>
														<tr>
															<td id="cell_bg1" style="border-right-width:0px"><a href="javascript:void(0)" target="_self" class="eg_monlink" onClick="javascript:showComponentChanges('<%=EgURLEncoder.encode(dissimilarComponent,"UTF-8")%>')">&nbsp;<%=tempCompName%></a></td>
														</tr>
<%
		}
	}
%>
													</table>
												</div>
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</table>
</form>
</body>
</html>



