<%
/*
	File			:	EcCompareView.jsp
	Purpose			:	Consolidated view across test measures for infrastructure components
	Creation Date	:	15-12-2008
	Author			:	Nagarajan,Krishnamurthi
	UI Design		:	Jaiwin
*/
%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EcTracker.jsp"%>
<%@ page errorPage= "EcProbs.jsp"%>
<%@ page import = "com.eg.EgConfigTestsInfo"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "egurkha.config.EcUtils"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.EgConfigConstants"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.egurkha.util.StringUtils"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires",-1);
%>

<html>
<head>
<title><egui:intnl text="configmgmt.configuration.eG Configuration Management" /></title>
<script language="javaScript1.2">

function isIE()
{
	var ver = navigator.appVersion;
	ver = ver.toLowerCase();
	if (ver.indexOf("msie ") > 0 || document.all)
		return true;
	else
		return false;
}

function selectType(isSubmit)
{
	var thisForm = document.vmwareview;
	thisForm.action = "../config/EcCompareView.jsp";
	thisForm.submit();
}

function showDetails()
{
	var thisForm = document.vmwareview;
	var selectObj = thisForm.components;
	var servers = '';
	var reportTypeObj = thisForm.reportType;
	var compTypeObj = thisForm.compType;

	for (var i=0;i<selectObj.options.length;i++ )
	{
		var optObj = selectObj.options[i];
		if (optObj.selected)
		{
			servers += optObj.value+',';
		}
	}
	if (servers.substring(servers.length-1) == ',')
	{
		servers = servers.substring(0,servers.length-1);
	}

	thisForm.selectedservers.value=servers;

	if (reportTypeObj != null && reportTypeObj.value == -1)
	{
		alert('<egui:intnl text="configmgmt.consolidated.Please select a Report type"/>');
	}
	else if (compTypeObj != null && compTypeObj.value == -1)
	{
		alert('<egui:intnl text="configmgmt.consolidated.Please select a Component type"/>');
	}
	else if (servers == '')
	{
		alert('<egui:intnl text="configmgmt.consolidated.Please select a Component"/>');
	}
	else
	{
		thisForm.action = "../servlet/com.eg.EcConfigurationServlet";
		thisForm.submit_button.enabled = false;
		thisForm.submit_button.value = '<egui:intnl text="configmgmt.common.Loading"/>...';
		thisForm.submit();
	}
}

function closeWin()
{
	if(window.newwin !=null)
	{
		newwin.close();
	}
	if(window.datawin !=null)
	{
		datawin.close();
	}
	if(window.mailwin !=null)
	{
		mailwin.close();
	}
	if(window.statusWin!=null)
		statusWin.close();
}

var printWindow = null;
function print(data)
{
	if (data == 'DataAvailable')
	{
		if (printWindow != null)
		{
			printWindow.close();
			printWindow = null;
		}
		printWindow =parent.openWindow("/final/config/EcCompareViewPrint.jsp","PrintWindow","width=792,height=464,left=0,top=85,scrollbars=1,scrollbars=yes,resizable");
	}
	else
	{
		alert('<egui:intnl text="configmgmt.common.No data available"/>!');
	}
}

window.onresize=setHeight;
function setHeight()
{
	var bottomHeight=document.getElementById("bottomHeight");
	if (isIE())
	{
		bottomHeight.style.height = document.body.clientHeight -224+"px";
	}
	else
	{
		bottomHeight.style.height=(window.innerHeight-224)+"px";
	}
}

</script>
<egui:skin ui="config"/>


</head>
<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" onUnLoad="closeWin()" style="overflow:hidden" onLoad="setHeight()">
<form name="vmwareview" method="post" style="margin:0px; padding:0px">
<!-- <input type="hidden" name="serverType" value=""> -->
<input type="hidden" name="selectedservers" value="">
<input type="hidden" name="selectedreport" value="">
<input type="hidden" name="ec_rtype" value="CompareView">
<input type="hidden" name="ec_trgttype" value="Configuration Report">

<%
	String serverType = request.getParameter("compType");
	String reportType = request.getParameter("reportType");
	String selectedServers = request.getParameter("selectedservers");
	serverType = (serverType!=null && serverType.length() > 0)?serverType:"";
	selectedServers = (selectedServers!=null && selectedServers.length() > 0)?selectedServers:"";
	EgConfigTestsInfo configTestsInfo = new EgConfigTestsInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	MappingNameSorter sorter = new MappingNameSorter(trackerLanguage);
	EgMappingInfo mappingInfo = new EgMappingInfo(trackerLanguage);

	EcUtils utils = new EcUtils();
	ArrayList allCompTypes = new ArrayList(this_user.getAllServerType());
	ArrayList serverTypes = new ArrayList();
	if (allCompTypes != null)
	{
		for (int i=0;i<allCompTypes.size();i++)
		{
			String compType = (String)allCompTypes.get(i);
			boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(compType);
			if (isConfigTestEnabled && !serverTypes.contains(compType))
			{
				serverTypes.add(compType);
			}
		}
		String[] vars =  configTestsInfo.getVariables("CONSOLIDATED_VIEW");
		ArrayList configuredCompTypes = new ArrayList();
		configuredCompTypes = getConfiguredCompTypes(vars);
		serverTypes.retainAll(configuredCompTypes);
	}
%>

<table align="center" cellspacing="0" cellpadding="0" border="0" width="100%" height="100%">
	<tr>
		<td align="right" valign="middle" id="layer_headbg" height="18" width="100%" style="padding:0px;border-left-width:0px;border-right-width:0px">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="padding5">
				<tr>
					<td align="left" id="main_head_top" width="95%" nowrap>
						&nbsp;<b><egui:intnl text="configmgmt.configuration.CONSOLIDATED VIEW" /></b>
					</td>
					<td class="body_text" align="right" width="5%"></td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td valign="top" id="bgmedium" width="100%" height="100%">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">
				<tr>
					<td id="padding6">
						<table cellspacing="0" cellpadding="0" width="975px" border="0" id="toptable" >
							<tr>
								<td>
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0"  style="table-layout:fixed" id="text_bold"> <col width="20"><col width="250"><col width="10"><col width="600"><col width="20">
										<tr>
											<td colspan="5" height="5" id="blank">&nbsp;</td>
										</tr>
										<tr height="20"> 
											<td align="center">&nbsp;</td>
											<td nowrap align="right"> <egui:intnl text="configmgmt.common.Component Type" /> </td>
											<td align="center">:</td>
											<td nowrap align="left">
												<select name="compType" style="width: 300px" onChange="javaScript:selectType('yes')">
												<option value="-1"><egui:intnl text="configmgmt.common.Please choose a component type" />
												</option>
<%
	serverTypes = sorter.getSortedCompTypeList(serverTypes);
	for (int a=0;a < serverTypes.size();a++)
	{
		//String tmpStype  = (String)serverTypes.get(a);
		EgName nameObj = (EgName)serverTypes.get(a);
		String actualName = nameObj.getActualName();
		String localName = nameObj.getLocalName();
%>
												<option value="<%=actualName%>" <%=serverType.equals(actualName)?"selected":""%>><%=localName%></option>
<%
	}
%>
												</select>
											</td>
											<td align="center">&nbsp;</td>
										</tr>
										<tr>
											<td colspan="5" height="5" id="blank">&nbsp;</td>
										</tr>
<%
	ArrayList servers = new ArrayList();
	if (this_user != null)
	{
		servers.addAll(this_user.getServersForType(serverType));
	}
%>
										<tr>
											<td align="center">&nbsp;</td>
											<td nowrap align="right" valign="top">
												<egui:intnl text="configmgmt.configuration.Components" />
											</td>
											<td align="center" valign="top">:</td>
											<td nowrap>
												<select name="components"  style="width:350px;height:90px" multiple>
<%
	if (servers.size() > 0)
	{
		for (int i=0; i<servers.size(); i++)
		{
			String server = (String)servers.get(i);
			server = server.substring(server.indexOf(":")+1);
			
			String selected = "";
			if (selectedServers.length() == 0)
			{
				selected = "selected";
			}
			else if (selectedServers.indexOf(server) > -1)
			{
				selected = "selected";
			}
			out.println("<option value=\""+server+"\""+selected+" >"+removeNull(server)+"</option>");
		}
	}
	else
	{
%>
												<option value="-1"><egui:intnl text="configmgmt.common.Not Applicable"/></option>
<%
	}
%>
												</Select>
											</td>
											<td  align="center">&nbsp;</td>
										</tr>
										<tr>
											<td colspan="5" height="10" id="blank">&nbsp;</td>
										</tr>
										<tr>
											<td align="center">&nbsp;</td>
											<td nowrap align="right"><egui:intnl text="configmgmt.common.Report Type" /> </td>
											<td align="center">:</td>
											<td nowrap>
												<select name="reportType" style="width:300px;">
<%
	ArrayList reportTypes = configTestsInfo.getReportTypesForServerType(serverType);
	if (reportTypes != null && reportTypes.size() > 0)
	{
%>
												<option value="-1"> <egui:intnl text="configmgmt.common.Please choose a Report type" />
												</option>
<%
		for (int i=0;i<reportTypes.size();i++)
		{
			String tmpReportType = (String)reportTypes.get(i);
			String selected = "";
			if (tmpReportType.equals(reportType))
			{
				selected = "selected";
			}
%>
												<option value="<%=tmpReportType%>" <%=selected%>><egui:intnl text='<%="configmgmt.configuration."+tmpReportType%>'/></option>
<%
		}
	}
	else
	{
%>
												<option value="-2"><egui:intnl text="configmgmt.common.Not Applicable"/></option>
<%
	}
%>
												</select>
											</td>
											<td align="center">&nbsp;</td>
										</tr>
										<tr>
											<td colspan="5" height="10" id="blank">&nbsp;</td>
										</tr>
<%
	ArrayList al = (ArrayList)request.getAttribute("result");
	String data = "NoData";
	if (al != null && al.size() > 0)
		data = "DataAvailable";
%>
										<tr>
											<td align="center" colspan="5" valign="middle" height="20"> <input type="button" name="submit_button" value='<egui:intnl text="configmgmt.common.SUBMIT" />' id="darkbutton" style="width: 75px; height: 20px;" onClick="javascript:showDetails('submit')"> </td>
										</tr>
										<tr>
											<td colspan="5" height="5" id="blank">&nbsp;</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td id="padding6" height="100%" width="100%"  style="padding-top:0px" valign="top" >
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" >
							<tr>
								<td class="bottomtable" width="100%" height="100%" valign="top">
								<div class="div_scroll" id="bottomHeight" style="border:0px solid #ff0000; height:300px; width:975px">
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" >
<%
	if (al != null && al.size() > 0)
	{
%>
										<tr>
											<td align="center" width="100%" height="100%" valign="top" >
												<table width="100%" border="0" cellspacing="0" cellpadding="0">
													<tr>
														<td width="100%" id="bgdark" class="whitefont" height="20" align="left" >&nbsp;&nbsp;<egui:intnl text="configmgmt.configuration.Configuration Details" /></td>
													</tr>
													<tr>
														<td align="center" width="100%" height="100%" valign="top" colspan="3">
															<table width="100%" border="0" cellspacing="0" cellpadding="4" >
																<tr>
																	<td align="center" valign="top">
																		<table width="99%" border="0" cellspacing="0" cellpadding="0" id="bottomtable">
																			<tr>
																				<td colspan="2" class="bgdarkimg"  height="20" valign="middle"><egui:intnl type="<%=serverType%>"/> : <%=reportType%></td>
																			</tr>
																			<tr>
																				<td width="100%" class="bgmedium">
																					<table border="0" width="100%" cellspacing="0" cellpadding="0" class="body_text">
<%
		if (al.size() > 0 && al.size() == 2)
		{
			ArrayList tableHeadings = (ArrayList)al.get(0);
			ArrayList aListResult = getHeadingsAndSubHeadings(tableHeadings);
			ArrayList aListTests = (ArrayList)aListResult.get(0);
			ArrayList aListDescriptors = (ArrayList)aListResult.get(1);
			Hashtable htableHeadings = (Hashtable)aListResult.get(2);

			boolean nonInfoBasedTests = true;
			for (int i=0;i<aListTests.size();i++)
			{
				ArrayList aListInfos = (ArrayList)aListDescriptors.get(i);

				for (int j=0;j<aListInfos.size();j++)
				{
					String descriptor = (String)aListInfos.get(j);
					if (!descriptor.equals("+") && 
						!utils.getInfoForDisplay(descriptor).equals(EgConfigConstants.CF_EMPTY_WITH_COLON) && 
						!utils.getInfoForDisplay(descriptor).equals(EgConfigConstants.CF_EMPTY))
					{
						nonInfoBasedTests = false;
						break;
					}
				}

				if (!nonInfoBasedTests)
				{
					break;
				}
			}

			int infoCount = 0;
			for (int i=0;i<aListTests.size();i++)
			{
				ArrayList aListInfos = (ArrayList)aListDescriptors.get(i);
				infoCount += aListInfos.size();
			}

			if (aListTests.size() > 1)
			{
%>
																						<tr>
																							<td nowrap>&nbsp;</td>
<%
				for (int i=0;i<aListTests.size();i++)
				{
					String testName = (String)aListTests.get(i);
					ArrayList aListInfos = (ArrayList)aListDescriptors.get(i);

					Hashtable htable = (Hashtable)htableHeadings.get(testName);
					String strInfo = (String)aListInfos.get(0);
					ArrayList aList = (ArrayList)htable.get(strInfo);

					int t_size = htable.size() * aList.size();
%>
																							<td style="padding:2px;text-align:left;font-weight:bold" colspan="<%=t_size%>" id="table_header_dash" nowrap><%=mappingInfo.getTestDescription(testName)%></td>
<%
				}
%>
																						</tr>
<%
			}

			if (!nonInfoBasedTests)
			{
%>
																						<tr>
																							<td nowrap>&nbsp;</td>
<%
				int k = 0;
				for (int i=0;i<aListTests.size();i++)
				{
					String testName = (String)aListTests.get(i);
					ArrayList aListInfos = (ArrayList)aListDescriptors.get(i);

					Hashtable htable = (Hashtable)htableHeadings.get(testName);
					String strInfo = (String)aListInfos.get(0);
					ArrayList aList = (ArrayList)htable.get(strInfo);
					int m_size = aList.size();

					ArrayList aListInfoHeadings = null;
					boolean isDynamicMeasureTest = false;
					int idx_M = strInfo.indexOf("~M~");
					if (idx_M != -1)
					{
						isDynamicMeasureTest = true;

						aListInfoHeadings = new ArrayList();
						String infoHeadings = configTestsInfo.getServerDisplayValue("DYNAMIC_MEASURES_TEST",testName);
						if (infoHeadings != null && infoHeadings.length() > 0)
						{
							StringTokenizer strTokensTemp = new StringTokenizer(infoHeadings,",");
							while (strTokensTemp.hasMoreTokens())
							{
								String str_temp = strTokensTemp.nextToken();
								aListInfoHeadings.add(str_temp);
							}
						}
					}

					for (int j=0;j<aListInfos.size();j++)
					{
						String descriptor = (String)aListInfos.get(j);
						k++;

						if (descriptor.equals("+") || 
							utils.getInfoForDisplay(descriptor).equals(EgConfigConstants.CF_EMPTY_WITH_COLON) || 
							utils.getInfoForDisplay(descriptor).equals(EgConfigConstants.CF_EMPTY))
						{
							if (k == infoCount)
							{
%>
																							<td colspan="<%=m_size%>" align="left" id="eg_calth" style="padding:2px" nowrap>&nbsp;</td>
<%
							}
							else
							{
%>
																							<td colspan="<%=m_size%>" align="left" id="eg_calth" class="lightlineright" style="padding:2px" nowrap>&nbsp;</td>
<%
							}
						}
						else
						{
							if (!isDynamicMeasureTest)
							{
								if (k == infoCount)
								{
%>
																							<td colspan="<%=m_size%>" align="left" id="eg_calth" style="font-weight:bold;padding:2px" nowrap><%=descriptor%></td>
<%
								}
								else
								{
%>
																							<td colspan="<%=m_size%>" align="left" id="eg_calth" class="lightlineright" style="font-weight:bold;padding:2px" nowrap><%=descriptor%></td>
<%
								}
							}
							else
							{
								ArrayList aListTokens = StringUtils.myTokenizer(utils.getInfoForDisplay(descriptor),"~M~");
								int aListTokensSize = aListTokens.size();
								String strData = "";
								for (int x=0;x<aListTokensSize;x++)
								{
									String infoHeading = (String)aListInfoHeadings.get(x);
									String strTemp = (String)aListTokens.get(x);
									if (x == aListTokensSize-1)
									{
										strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
									}
									else
									{
										strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
									}
								}

								if (k == infoCount)
								{
%>
																							<td colspan="<%=m_size%>" align="left" id="eg_calth" style="font-weight:bold;padding:2px" nowrap><%=strData%></td>
<%
								}
								else
								{
%>
																							<td colspan="<%=m_size%>" align="left" id="eg_calth" class="lightlineright" style="font-weight:bold;padding:2px" nowrap><%=strData%></td>
<%
								}
							}
						}
					}
				}
%>
																						</tr>
<%
			}
%>

																						<tr>
																							<td id="cell_header" nowrap><egui:intnl text="configmgmt.configuration.Component Name" /></td>
<%
			for (int i=0;i<aListTests.size();i++)
			{
				String testName = (String)aListTests.get(i);
				Hashtable htable = (Hashtable)htableHeadings.get(testName);

				ArrayList aListInfos = (ArrayList)aListDescriptors.get(i);
				for (int j=0;j<aListInfos.size();j++)
				{
					String descriptor = (String)aListInfos.get(j);
					ArrayList aList_A = (ArrayList)htable.get(descriptor);
					for (int k=0;k<aList_A.size();k++)
					{
						String measure = (String)aList_A.get(k);
%>
																							<td align="left" id="cell_header" nowrap><%=measure%></td>
<%
					}
				}
			}
%>
																						</tr>

<%
			TreeMap tableValues = (TreeMap)al.get(1);
			Iterator it = tableValues.keySet().iterator();
			while (it.hasNext())
			{
				String compName = (String)it.next();
%>
																						<tr>
																							<td id="cell_bg1" align="left" valign="top" nowrap><%=removeNull(compName)%></td>
<%
				ArrayList tds = (ArrayList)tableValues.get(compName);
				for (int j=0;j<tds.size();j++)
				{
					String tdVal = (String)tds.get(j);
					if (tdVal.equalsIgnoreCase(EgConfigConstants.CF_YES))
					{
						tdVal = mappingInfo.getTextDescription("configmgmt.common.Yes");
					}
					else if (tdVal.equalsIgnoreCase(EgConfigConstants.CF_NO))
					{
						tdVal = mappingInfo.getTextDescription("configmgmt.common.No");
					}
%>
																							<td id="cell_bg1" align="left" valign="top" nowrap><%=tdVal%></td>
<%
				}
%>
																						</tr>
<%
			}
		}
%>
																					</table>
																				</td>
																			</tr>
																		</table>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
<%
	}
	else if (al == null)
	{
%>
										<tr>
											<td align="center" height="100%">
												<table border="0" align="center" width="100%"  height="100%" >
													<tr><td>&nbsp;</td></tr>
												</table>
											</td>
										</tr>
<%
	}
	else if (al.size() == 0)
	{
%>
										<tr>
											<td align="center" height="100%">
												<table border="0" align="center" width="100%"  height="100%">
													<tr>
														<td align="center">
															<table border="0" align="center" width="100%" class="body_text" >
																<tr>
																	<td align="center"><img src="/final/config/images/unavailable-data.gif" title='<egui:intnl text="configmgmt.common.No Data" />'></td>
																</tr>
																<tr>
																	<td align="center"><b><egui:intnl text="configmgmt.common.No result found for current selection" /></b></td>
																</tr>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
<%
	}
%>
									</table>
								</div>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</form>
</body>
</html>

<%!
	private String removeNull(String comp)
	{
		String component = "";
		if (comp != null && comp.length() > 0)
		{
			if(comp.endsWith(":Null") || comp.endsWith(":null") || comp.endsWith(":NULL"))
			{
				component = comp.substring(0,comp.indexOf(":"));
			}
			else
			{
				component = comp;
			}
		}
		return component;
	}

	private ArrayList getConfiguredCompTypes(String[] vars)
	{
		ArrayList tmp = new ArrayList();
		if (vars == null || vars.length == 0)
		{
			return tmp;
		}

		for (int i=0;i < vars.length; i++)
		{
			String var = vars[i];
			String cType = var.substring(0,var.indexOf(":"));
			if (!tmp.contains(cType))
			{
				tmp.add(cType);
			}
		}
		return tmp;
	}

	private ArrayList getHeadingsAndSubHeadings(ArrayList aListHeadings)
	{
		ArrayList aListResult = new ArrayList();

		Hashtable htableHeadings = new Hashtable();

		ArrayList aList_T = new ArrayList();
		ArrayList aList_D = null;
		ArrayList aList_DD = new ArrayList();

		for (int i=1;i<aListHeadings.size(); i++)
		{
			String strMeasure = (String)aListHeadings.get(i);

			//ApacheServerInfo_cf@#@::E::~M~@#@DefaultType
			ArrayList aListTokens = StringUtils.myTokenizer(strMeasure,"@#@");
			String testName = (String)aListTokens.get(0);
			String info = (String)aListTokens.get(1);
			String measureName = (String)aListTokens.get(2);

			Hashtable htable_A = (Hashtable)htableHeadings.get(testName);
			if (htable_A == null)
			{
				htable_A = new Hashtable();
				ArrayList aList_B = new ArrayList();
				aList_B.add(measureName);
				htable_A.put(info,aList_B);
				htableHeadings.put(testName,htable_A);
				if (!aList_T.contains(testName))
				{
					aList_T.add(testName);
					aList_D = new ArrayList();
					aList_D.add(info);
					aList_DD.add(aList_D);
				}
			}
			else
			{
				ArrayList aList_A = (ArrayList)htable_A.get(info);
				if (aList_A == null)
				{
					aList_A = new ArrayList();
					aList_A.add(measureName);
					htable_A.put(info,aList_A);
					if (!aList_D.contains(info))
					{
						aList_D.add(info);
					}
				}
				else
				{
					aList_A.add(measureName);
				}
			}
		}

		aListResult.add(aList_T);
		aListResult.add(aList_DD);
		aListResult.add(htableHeadings);

		return aListResult;
	}
%>



