<%
/*
 *   File					:	EcOsComponentTypes.jsp
 *   Purpose				:	Shows the distribution of ComponentTypes across operating environments
 *   Creation Date			:	12-10-2006
 *   Author					:	Balasigamani
 *   UI Design Changes		:	Jaiwin
 */
%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EcTracker.jsp" %>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import="java.util.*" %>
<%@ page import="com.egurkha.User" %>
<%@ page import="com.egurkha.UserRegistry" %>
<%@ page import="com.eg.EgConfigTestsInfo" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="java.net.URLEncoder" %>
<%@ page import="egurkha.config.EcProcessData" %>
<%@ page import="egurkha.config.EcPrintData" %>
<%@ page import="egurkha.config.EcUtils" %>
<%@ page import="com.egurkha.pdfmaker.*"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="com.eg.EgName"%>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import="com.eg.EgURLEncoder"%>
<%@ page import="egurkha.config.EcFusionChartBean" %>
<%@ page import="com.eg.EgConfigConstants"%>
<%@ page import="egurkha.config.ConfigDbSetting" %>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "java.text.*"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.eg.EgInstallInfo" %>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%!
	String[] criterias = {"Zone","Service","Segment","Component"};
%>

<%
	Map dashBoardData=new TreeMap();
	Vector componentTypeList=new Vector();

	EgConfigTestsInfo configTestsInfo=new EgConfigTestsInfo("manager");
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();

	//user language
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	ArrayList serverList = new ArrayList();

	String configSkin = user.getConfigSkin();
	String userName = user.getLoginID();
	EcUtils ecUtils = new EcUtils();
	EcProcessData processData=new EcProcessData();
	EgSpecsInfo specsInfo=new EgSpecsInfo("manager");
	EcPrintData printData=new EcPrintData();

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" "+"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);

	/* Added by Prakash.K Starts */
	EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dateString,user);
	dateString = timeZoneConverter.getDateTime();
	/* Added by Prakash.K Ends */

	Map dashboardSetting = (Hashtable)ConfigDbSetting.getDbSettingData(user.getLoginID(),EgConfigConstants.USER_COMMON_SETTING);
	String barColor = configTestsInfo.getServerDisplayValue("MISC_ARGS","ChartColor");
	String chartDataRepresentation = configTestsInfo.getServerDisplayValue("MISC_ARGS","ChartDataRepresentation");

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");
	String ec_userOptionPrevious = request.getParameter("ec_userOptionPrevious");

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	String configuredComponentType = configTestsInfo.getServerDisplayValue("MISC_ARGS","ComponentTypeForDistributionAcrossOS");
	processData.setUserObject(user);
	ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");
	processData.setAssociatedComponents(aListAssociatedComponents);
	Map hostAgentsMapping = (Map)session.getAttribute("hostAgentsMapping");
	processData.setHostAgentsMapping(hostAgentsMapping);

	for(int i=0;i<aListAssociatedComponents.size();i++)
	{
		String s_component = (String)aListAssociatedComponents.get(i);
		String component_type = s_component.substring(0,s_component.indexOf(":"));
		boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_type);
		if (!isConfigTestEnabled) continue;
		if (!componentTypeList.contains(component_type))
		{
			componentTypeList.add(component_type);
		}
	}
	if (componentTypeList.contains("Host_system"))
	{
		componentTypeList.remove("Host_system");
	}
	Collections.sort(componentTypeList);

	//Code to remove network devices and virtual platforms - Start
	ArrayList aListOthers = new ArrayList();
	aListOthers.addAll(processData.getNetworkDevices());
	aListOthers.addAll(processData.getVirtualComponents());
	ArrayList aListOtherCompTypes = new ArrayList();
	for(int i=0;i<aListOthers.size();i++)
	{
		String s_component = (String)aListOthers.get(i);
		String component_type = s_component.substring(0,s_component.indexOf(":"));
		if (!aListOtherCompTypes.contains(component_type))
		{
			aListOtherCompTypes.add(component_type);
		}
	}
	if (aListOtherCompTypes != null && !aListOtherCompTypes.isEmpty())
	{
		componentTypeList.removeAll(aListOtherCompTypes);
	}
	//Code to remove network devices and virtual platforms - End

	TreeMap tmapOSSystems = (TreeMap)processData.getOSDetails("HomePage");
	Iterator itSyss = tmapOSSystems.keySet().iterator();
	List tempCTypes = new ArrayList();
	while (itSyss.hasNext())
	{
		String osName = (String)itSyss.next();
		TreeMap tmap = new TreeMap();
		Hashtable systems = (Hashtable)tmapOSSystems.get(osName);
		Iterator systemKeys = systems.keySet().iterator();
		while (systemKeys.hasNext())
		{
			String system = (String)systemKeys.next();
			ArrayList aListComponents = (ArrayList)systems.get(system);
			for (int i=0; i<aListComponents.size(); i++)
			{
				String component = (String)aListComponents.get(i);
				String compType = component.substring(component.lastIndexOf(":")+1);
				if (!tempCTypes.contains(compType))
					tempCTypes.add(compType);
			}
		}
	}

	if (componentTypeList != null && componentTypeList.size() > 1 && tempCTypes.size() > 1)
		componentTypeList.add(0,"All");

	//Krishnamurthi - For All option
	TreeMap tmapCtypeOS = null;
	Vector vecOS = null;
	Vector vecComponents = null;

	//Request Information
	Map osDatas=new TreeMap();
	String componentType=request.getParameter("componentType");
	if(componentType==null || componentType.length()==0)
	{
		if(componentTypeList!=null && componentTypeList.size()>0)
		{
			if(componentTypeList.contains(configuredComponentType))
				componentType=configuredComponentType;
			else
				componentType=(String)componentTypeList.get(0);
		}
	}

	if (componentType != null)
	{
		if (componentType.equalsIgnoreCase("All")) //Krishnamurthi
		{
			TreeMap tmapOSCTypes = new TreeMap();
			Iterator osKeys = tmapOSSystems.keySet().iterator();
			while (osKeys.hasNext())
			{
				String os = (String)osKeys.next();
				TreeMap tmap = new TreeMap();
				Hashtable systems = (Hashtable)tmapOSSystems.get(os);
				Iterator systemKeys = systems.keySet().iterator();
				while (systemKeys.hasNext())
				{
					String system = (String)systemKeys.next();
					ArrayList aListComponents = (ArrayList)systems.get(system);
					for (int i=0; i<aListComponents.size(); i++)
					{
						String component = (String)aListComponents.get(i);
						String compType = component.substring(component.lastIndexOf(":")+1);

						TreeMap tmap1 = (TreeMap)tmap.get(compType);
						if (tmap1 == null)
						{
							tmap1 = new TreeMap();
							ArrayList aList = new ArrayList();
							aList.add(component);
							tmap1.put(system,aList);
							tmap.put(compType,tmap1);
						}
						else
						{
							ArrayList aList1 = (ArrayList)tmap1.get(system);
							if (aList1 == null)
							{
								aList1 = new ArrayList();
								aList1.add(component);
								tmap1.put(system,aList1);
							}
							else
							{
								if (!aList1.contains(component))
									aList1.add(component);
							}
						}
					}
				}
				tmapOSCTypes.put(os,tmap);
			}
			
			tmapCtypeOS = new TreeMap();
			osKeys = tmapOSCTypes.keySet().iterator();
			while (osKeys.hasNext())
			{
				String os = (String)osKeys.next();
				TreeMap tmapCTypes = (TreeMap)tmapOSCTypes.get(os);
				Iterator ctypeKeys = tmapCTypes.keySet().iterator();
				while (ctypeKeys.hasNext())
				{
					String ctype = (String)ctypeKeys.next();
					TreeMap tmapSystems = (TreeMap)tmapCTypes.get(ctype);
					TreeMap tmapTemp = (TreeMap)tmapCtypeOS.get(ctype);
					if (tmapTemp == null)
					{
						tmapTemp = new TreeMap();
						tmapTemp.put(os,tmapSystems);
						tmapCtypeOS.put(ctype,tmapTemp);
					}
					else
					{
						tmapTemp.put(os,tmapSystems);
					}
				}
			}

			vecOS = processData.getAllOsName();

			vecComponents = new Vector();
			Vector allComps = new Vector();
			allComps.addAll(user.getServers(false));
			if (!allComps.isEmpty())
			{
				for (int i=0;i<allComps.size();i++)
				{
					String str = (String)allComps.get(i);
					String component_type = str.substring(0,str.indexOf(":"));
					boolean isTestEnabled = specsInfo.isConfigTestEnabled(component_type);
					if (!isTestEnabled) continue;
					vecComponents.add(str);
				}
			}
		}
		else
		{
			osDatas=(TreeMap)processData.getComponentOsData(componentType);
		}
	}

	if (tempCTypes != null && tempCTypes.size() > 0)
	{
		componentTypeList = new Vector(tempCTypes);
	}

	if (componentTypeList != null && componentTypeList.size() > 1)
	{
		componentTypeList.add(0,"All");
	}

	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
%>

<html>
<head>
<title>
	<egui:intnl text="configmgmt.dashboard.eG Configuration" /> : <egui:intnl text="configmgmt.inventory.view.Component Type Distribution" />
</title>
<!-- <link rel="stylesheet" href="/final/config/styles/ec_style_green.css" /> -->
<egui:skin ui="config"/>
<script language="JavaScript1.2" type="text/javascript" src="/final/FusionCharts/scripts/FusionCharts.js"></script>
<script language="JavaScript1.2" src="/final/config/scripts/ec_validate.js"></script>
<script language="JavaScript1.2" src="/../final/scripts/screen_display.js"></script>
<script language="JavaScript1.2">
	
	function componentSearch()
	{
		var thisForm = document.ComponentOSType;

		var tempCriteria = "";
		var tempUserOption = "";
		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}

		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
					return false;
				}
				else if (tempCriteria == "Service")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
					return false;
				}
			}
		}

		var componentName= thisForm.componentSelect.value;
		if(componentName=="-1")
		{
			alert('<egui:intnl text="configmgmt.inventory.view.Please select a component type" />');
			return;
		}
		else
		{
			document.ComponentOSType.submt.value='<egui:intnl text="configmgmt.common.Loading" />'+'...';
			document.ComponentOSType.submt.disabled=true;
			thisForm.action = "../servlet/com.eg.EcConfigurationServlet?cmd=CompTypeInventory&componentType="+componentName;
			thisForm.submit();
		}
	}

	function printData()
	{
<%
		if( (osDatas == null || osDatas .size()==0 ) && (tmapCtypeOS == null || tmapCtypeOS.size() == 0))
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}

		StringBuffer printQS = new StringBuffer();
		printQS.append("printType=INVENTORY_COMPONENTTYPE");
		printQS.append("&printPageTitle=INVENTORY_REPORT_BY_COMPONENT_TYPE");
		printQS.append("&Page=OS");   // Decide file to display for print in the controller
		printQS.append("&printData=yes");
		printQS.append("&userName="+EgURLEncoder.encode(userName,"UTF-8"));
		printQS.append("&user_language="+userLanguage);
		printQS.append("&ec_criteria="+ec_criteria);
		printQS.append("&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""));
%>
		var s_qryString = "../servlet/com.eg.EcRepoLiteC?<%=printQS.toString()%>&ec_forPDF=No";
		print(s_qryString);
	}

	function savePdf()
	{
<%
		if((osDatas == null || osDatas .size()==0) && (tmapCtypeOS == null || tmapCtypeOS.size() == 0))
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
		session.setAttribute("PDF_URL",mngrIProc+"/final/servlet/com.eg.EcRepoLiteC;jsessionid="+session.getId()+"?"+printQS.toString()+"&ec_forPDF=Yes");
		session.setAttribute("REPORT_NAME","InventoryReportByComponentType");
		session.setAttribute("REPORT_LAYOUT","Portrait");
		session.setAttribute("PAGE_WIDTH_PDF","1100");
		session.setAttribute("PAGE_WIDTH_MAIL_IMAGE","1300");
		session.setAttribute("PAGE_HEIGHT_MAIL_IMAGE","768");
%>
		getPdf('<%=configSkin%>');
	}

	function mail()
	{
<%
		if ((osDatas == null || osDatas.size() == 0) && (tmapCtypeOS == null || tmapCtypeOS.size() == 0))
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
%>
		sendMail();
	}

	function getInformations()
	{
		var thisForm = document.ComponentOSType;
		thisForm.action = "../servlet/com.eg.EcConfigurationServlet?cmd=CompTypeInventory";
		thisForm.submit();
	}

	function csv()
	{
<%
		if((osDatas == null || osDatas .size()==0) && (tmapCtypeOS == null || tmapCtypeOS.size() == 0))
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
%>
		thisForm = document.forms[0];
		thisForm.action = '../servlet/com.eg.EcCSVController?ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
		thisForm.submit();
	}
</script>
<!-- Screen width script started here -->
<SCRIPT LANGUAGE="JavaScript">
documentView = {
	getObject: function()
	{
		if(typeof( window.innerWidth) == 'number')
		{//Firefox
			this.height = window.innerHeight;
			this.width = window.innerWidth-10;
			this.fireFox = true;
		}
		else if( document.documentElement && ( document.documentElement.clientWidth
			|| document.documentElement.clientHeight ))
		{//IE 6 + in 'standards compliant mode'
			this.height = document.documentElement.clientHeight;
			this.width = document.documentElement.clientWidth;
			this.ie = true;
		}
		else if(document.body && document.body.clientHeight)
		{ //IE 4 compatible
			this.height = document.body.clientHeight;
			this.width = document.body.clientWidth;
			this.ie = true;
		}
		this.screenHeight=window.screen.availHeight;
		this.screenWidth=window.screen.availWidth;
		return this;
	},
	getScreenHeight: function()
	{
		return this.getObject().screenHeight;
	},
	getScreenWidth: function()
	{
		return this.getObject().screenWidth;
	},
	getHeight: function()
	{
		return this.getObject().height;
	},
	getWidth: function()
	{
		return this.getObject().width;
	},
	isIE: function()
	{
		return this.getObject().ie;
	},
	isFireFox: function()
	{
		return this.getObject().fireFox;
	}
};

var old_width=0;
function bigScreenPage()
{
	if(old_width==0)
	{
		old_width=1000;
	}
	var selectWidth1Obj = document.getElementById('selectWidth1');
	var selectWidth2Obj = document.getElementById('selectWidth2');
	var selectWidth3Obj = document.getElementById('selectWidth3');
	if(selectWidth1Obj!=null && selectWidth1Obj!=undefined)
	{
		var selectWidth = selectWidth1Obj.style.width;
		if(selectWidth!=null && selectWidth!=undefined)
		{
			var newSelectWidth=parseInt((parseInt(selectWidth)/old_width) * documentView.getWidth());
			selectWidth1Obj.style.width=(newSelectWidth)+"px";
		}
	}
	if(selectWidth2Obj!=null && selectWidth2Obj!=undefined)
	{
		var selectWidth = selectWidth2Obj.style.width;
		if(selectWidth!=null && selectWidth!=undefined)
		{
			var newSelectWidth=parseInt((parseInt(selectWidth)/old_width) * documentView.getWidth());
			selectWidth2Obj.style.width=(newSelectWidth)+"px";
		}
	}
	if(selectWidth3Obj!=null && selectWidth3Obj!=undefined)
	{
		var selectWidth = selectWidth3Obj.style.width;
		if(selectWidth!=null && selectWidth!=undefined)
		{
			var newSelectWidth=parseInt((parseInt(selectWidth)/old_width) * documentView.getWidth());
			selectWidth3Obj.style.width=(newSelectWidth)+"px";
		}
	}
	old_width=documentView.getWidth();
}
window.onresize = bigScreenPage;
</script>
</head>

<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" style="overflow:auto" onLoad="bigScreenPage();">
<form name="ComponentOSType" method="POST" style="margin:0px">
<input type="hidden" name="ec_criteriaPrevious" value="<%=ec_criteria%>">
<input type="hidden" name="ec_userOptionPrevious" value="<%=ec_userOption%>">

<table align="center" cellspacing="0" cellpadding="0" border="0" width="100%" height="100%">
	<tr>
		<td align="right" valign="middle" id="layer_headbg" height="18" width="100%" style="padding:0px;border-left-width:0px;border-right-width:0px">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
				<tr>
					<td align="left" id="main_head_top" width="97%" nowrap height="24px">
						&nbsp;<b><egui:intnl text="configmgmt.inventory.view.INVENTORY BY COMPONENT TYPE" /></b>
					</td>
				</tr>
			</table>
		</td>
	</tr>

	<tr>
		<td valign="top" id="bgmedium" width="100%" height="100%">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">
				<!-- new tab start here -->
				<tr>
					<td id="padding6" style="padding-bottom:0px">
						<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0" id="toptable" style="table-layout:fixed">
							<col width="55"><col width="10"><col width="170">
							<col width="150"><col width="10"><col width="350">
							<tr>
								<td align="right" nowrap><b><egui:intnl text="configmgmt.common.View By" /></b></td>
								<td align="center"><b>:</b></td>
								<td valign="middle">
									<select id="selectWidth1" name="ec_criteria" style="width:170px;" onChange='javascript:getInformations()'>
<%
	if (vecCriterias != null && !vecCriterias.isEmpty())
	{
		for(int i=0; i<vecCriterias.size(); i++)
		{
			String selected = "";
			String strCriteria = (String)vecCriterias.get(i);
			if(ec_criteria != null && strCriteria.equals(ec_criteria))
			{
				selected = "selected";
			}
%>
			<option value="<%=strCriteria%>" <%=selected%>>
				<egui:intnl text='<%="configmgmt.common."+strCriteria%>' />
			</option>
<%
		}
	}
	else
	{
%>
		<option value="-1">
			<egui:intnl text="configmgmt.common.Not Applicable" />
		</option>
<%
	}
%>
									</select>
								</td>
<%
	if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
	{
%>
								<td align="right" nowrap>
<%
		if (ec_criteria.equalsIgnoreCase(criterias[0]))
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[0]%>' /></b>
<%
		}
		else if (ec_criteria.equalsIgnoreCase(criterias[1]))
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[1]%>' /></b>
<%
		}
		else
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[2]%>' /></b>
<%
		}
%>
								</td>
								<td align="center"><b>:</b></td>
								<td>
									<select id="selectWidth2" name="ec_userOption" style="width: 250px;" onChange='javascript:getInformations()'>
<%
		if (vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			for(int i=0; i<vecUserOptions.size(); i++)
			{
				String selected = "";
				String strUserOption = (String)vecUserOptions.get(i);
				if(ec_userOption != null && strUserOption.equals(ec_userOption))
				{
					selected = "selected";
				}
%>
				<option value="<%=strUserOption%>" <%=selected%>>
					<%=strUserOption%>
				</option>
<%
			}
		}
		else
		{
%>
			<option value="-1">
				<egui:intnl text="configmgmt.common.Not Applicable" />
			</option>
<%
		}
%>
									</select>
								</td>
<%
	}
	else
	{
%>
								<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
<%
	}
%>
							</tr>
						</table>
					</td>
				</tr>
				<!-- new tab end here -->

				<tr>
					<td id="padding6">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="toptable" >
							<tr>
								<td>
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table-layout:fixed" id="text_bold"> <col width="100"><col width="100"><col width="10"><col width="250"><col width="80"><col width="10"><col width="250"><col width="100">
										<tr>
											<td colspan="8" height="5" id="blank">&nbsp; </td>
										</tr>
										<tr height="20"> 
											<td  align="center">&nbsp;</td>
											<td colspan="6" align="center">
												<egui:intnl text="configmgmt.inventory.view.Component Type" />&nbsp;:&nbsp;
												<select id="selectWidth3" name="componentSelect" style="width:250px;">
<%//=ecUtils.fillSelectBox(componentTypeList,"",componentType)%>
<%
	if (componentTypeList != null && !componentTypeList.isEmpty())
	{
		for(int i=0; i<componentTypeList.size(); i++)
		{
			String compType1 = (String)componentTypeList.get(i);
			if (compType1.equalsIgnoreCase("All"))
			{
%>
													<option value="<%=compType1%>" <%=(componentType != null && componentType.equals(compType1))?"selected":""%>>
														<egui:intnl text="configmgmt.inventory.view.All" />
													</option>
<%
			}
			else
			{
				serverList.add(compType1);
			}
		}
		serverList = sorter.getSortedCompTypeList(serverList);
		for (int j=0; j<serverList.size(); j++)
		{
			EgName nameObj = (EgName)serverList.get(j);
			String actualName = nameObj.getActualName();	
			String localName = nameObj.getLocalName();
			String selected = "";
			if(componentType != null && componentType.equals(actualName))
				selected = "selected";
%>
													<option value="<%=actualName%>" <%=selected%>><%=localName%></option>
<%
		}
	}
	else
	{
%>
													<option value="-1">
														<egui:intnl text="configmgmt.inventory.view.Not Applicable" />
													</option>
<%
	}
%>
												</select>
											</td>
											<td  align="center">&nbsp;</td>
										</tr>
										<tr>
											<td colspan="8" height="10" id="blank">&nbsp;</td>
										</tr>
										<tr>
											<td  align="center" colspan="4">&nbsp;</td>
											<td align="left" colspan="2" valign="middle" height="20"> 
											<input type="button" name="submt" value='<egui:intnl text="configmgmt.common.SUBMIT" />' id="darkbutton" style="width: 75px; height:20px;" onClick="javascript:componentSearch()">
											</td>
											<td align="right"  colspan="2" rowspan="2" style="height:24" valign="bottom">
												<table align="right" cellspacing="0" cellpadding="0" border="0" height="20"> 
													<tr>
														<td width="50" align="center" id="leftcurve" ><img src="/final/config/images/spacer.gif" width="50px" height="20px"> </td>

														<td width="2" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="2" > </td>

														<td align="center"  id="leftcurvebg" > <img class="mouse" src="../config/images/print.gif" border="0" title='<egui:intnl text="configmgmt.common.PRINT" />' onClick="javascript:printData()">  </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif" width="13" > </td>

														<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src= "../config/images/pdf.gif" border="0" title='<egui:intnl text="configmgmt.common.PDF" />' onClick="javascript:savePdf();"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"> </td>

														<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src="../config/images/mail.gif" border="0" title='<egui:intnl text="configmgmt.common.MAIL" />' onClick="javascript:mail()"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"> </td>

														<td width="13" align="center" id="leftcurvebg"><img class="mouse" src="../config/images/csv.gif" border="0" title='<egui:intnl text="configmgmt.common.CSV" />' onClick="javascript:csv()"> </td>

														<td width="13" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"></td>

													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td colspan="6" height="5" id="blank">&nbsp;</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>

				<tr>
					<td id="padding6" height="100%" width="100%" style="padding-top:0px" valign="top">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" id="bottomtable">
<%
	if(osDatas!=null && osDatas.size()>0)
	{
		String countValue="";
		String countName="";
		String colorValue="";
		ArrayList osNameList=new ArrayList();
		Map appletData=new TreeMap();
		String yAxisMaxValue = " ";
		ArrayList aListCount = new ArrayList();
		int coutValue = 0;
		ArrayList aListColors = new ArrayList();
		StringTokenizer stTokColors = new StringTokenizer(barColor,",");
		while (stTokColors.hasMoreTokens())
		{
			String chartColor = stTokColors.nextToken();
			aListColors.add(chartColor);
		}
		String strColors = " ";
		int colorIdx = 0;

		//Krishnamurthi
		int systemCount = 0;
		Iterator os=osDatas.keySet().iterator();
		while(os.hasNext())
		{
			String displayOsName="";
			String osName=(String)os.next();
			osNameList.add(osName);
			if(osName.indexOf(',')>-1)
				displayOsName=osName.replace(',',' ');
			else
				displayOsName=osName;

			if(displayOsName.indexOf("Microsoft")>-1)
			{
				displayOsName=displayOsName.substring(displayOsName.indexOf(' ')+1);
			}
			Hashtable osSystemName=(Hashtable)osDatas.get(osName);
			coutValue = osSystemName.size();
			if (!aListCount.contains(new Integer(coutValue)))
			{
				aListCount.add(new Integer(coutValue));
			}

			String temp_getOsColor = configTestsInfo.getServerDisplayValue("DASHBOARD_OS_COLOR",osName);

			if(countValue=="" && countName=="")
			{
				countValue=""+osSystemName.size();
				countName=displayOsName;
				if (temp_getOsColor == null || temp_getOsColor.length() == 0)
				{
					strColors = (String)aListColors.get(colorIdx);
					colorValue = strColors;
					colorIdx++;
					if (colorIdx >= aListColors.size())
					{
						colorIdx = 0;
					}
				}
				else
				{
					colorValue = temp_getOsColor;
				}
			}
			else
			{
				countValue=countValue+","+osSystemName.size();
				countName=countName+","+displayOsName;
				if (temp_getOsColor == null || temp_getOsColor.length() == 0)
				{
					strColors = (String)aListColors.get(colorIdx);
					colorValue = colorValue + "," + strColors;
					colorIdx++;
					if (colorIdx >= aListColors.size())
					{
						colorIdx = 0;
					}
				}
				else
				{
					colorValue = colorValue + "," + temp_getOsColor;
				}
			}
			appletData.put(osName,new Integer(osSystemName.size()));

			//Krishnamurthi
			systemCount = systemCount + osSystemName.size();
		}
		boolean flagEqualsOne = true;
		for (int i=1; i<aListCount.size(); i++)
		{
			Integer count_Value = (Integer)aListCount.get(i);
			if (count_Value.intValue() > 1)
			{
				flagEqualsOne = false;
				break;
			}
		}
		if (flagEqualsOne)
		{
			yAxisMaxValue = "5";
		}
		else
		{
			yAxisMaxValue = "0";
		}

		//Fusion Bar Chart Data starts--Rekha
		HashMap mapChartAttributes = new HashMap();//map for chart attributes
		mapChartAttributes.put("bgcolor","FFFFFF");
		mapChartAttributes.put("yAxisName","Number of systems");
		mapChartAttributes.put("showToolTip","1");
		mapChartAttributes.put("showValues","1");
		mapChartAttributes.put("showBorder","0");
		mapChartAttributes.put("showShadow","0");
		mapChartAttributes.put("alpha","0");
		mapChartAttributes.put("canvasBgColor","F2F2F2");
		mapChartAttributes.put("canvasBgAlpha","60");
		mapChartAttributes.put("canvasBorderColor","000000");
		mapChartAttributes.put("canvasBorderThickness","1");
		mapChartAttributes.put("canvasBorderAlpha","30");
		mapChartAttributes.put("yAxisMaxValue",yAxisMaxValue);
		mapChartAttributes.put("maxBarHeight","40");

		HashMap mapChartData = new HashMap();//map for chart data
		mapChartData.put("barLabels",countName);
		mapChartData.put("barValues",countValue);
		mapChartData.put("barColors",colorValue);

		HashMap mapProperties = new HashMap();//map for misc properties
		mapProperties.put("showColors","true");
		mapProperties.put("enableLinks","false");

		EcFusionChartBean chartbean = new EcFusionChartBean();
		String xmlString = chartbean.getXMLDataForStackedBarChart(mapChartAttributes,mapChartData,mapProperties);
		//Fusion Bar Chart Data - ends

		Object[] key =appletData.keySet().toArray();
		int maxCount=0;
		for (int a=0; a<key.length; a++)
		{
			String os_name= (String)key[a];
			Integer count = (Integer)appletData.get(os_name);		//Individual states
			int size=count.intValue();
			maxCount = Math.max(maxCount, size);
		}

		String displayName="";
		for(int s=0;s<osNameList.size();s++)
		{
			String os_name=(String)osNameList.get(s);
			if(os_name.indexOf("Microsoft")>-1)
				os_name=os_name.substring(os_name.indexOf(' ')+1);

			if(os_name.indexOf(',')>-1)
				os_name=os_name.replace(',',' ');

			if(s==0)
			{
				displayName=os_name;
			}
			else
			{
				displayName=displayName+","+os_name;
			}
		}

		printData.setSampleValue(countValue);
		printData.setBarLabel(displayName);
		printData.setMaxRange(String.valueOf(maxCount));
		printData.setSampleColor(colorValue);
		printData.setMapData(osDatas);
		printData.setComponent(componentType);
		session.setAttribute("PRINT_INFORMATION",printData);

		//pdf start here!!!!!!!!!!!!!!
		ArrayList tableList = new ArrayList();
		EgPdfData pdfData = new EgPdfData();
		EgReportAttributes reportAttributes = new EgReportAttributes();
		String pdfTitle = "";
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.INVENTORY REPORT BY COMPONENT TYPE") + " IN" + " '" + ec_userOption + "' "  +  ec_criteria + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + " " + dateString;
		}
		else
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.INVENTORY REPORT BY COMPONENT TYPE") + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}

		String pdfSubTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.Distribution of")+ " " + mappingInfo.getComponentTypeDescription(componentType)+ " " + mappingInfo.getTextDescription("configmgmt.inventory.view.across operating environments");

		reportAttributes.setMainTitle(pdfTitle);
		reportAttributes.setSubTitle(pdfSubTitle);
		reportAttributes.setReportName("ComponentTypeInventory");
		reportAttributes.setModule("CONFIG");
		reportAttributes.setPortrait(true);
		pdfData.setAttributes(reportAttributes);

		EgTableAttributes egTableAttributes = new EgTableAttributes();
		ArrayList aListColumnNames = new ArrayList();
		ArrayList aListData = new ArrayList();

		//pdf image
		egTableAttributes.setImageData(true);
		aListColumnNames.add("Image");
		aListData.add(request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+"/final/servlet/com.eg.EcChartController?view=GRAPH&pageName=INVENTORY_COMPONENT_TYPE&chartType=bar&height=250&width=550&sampleValues="+URLEncoder.encode(countValue)+"&barLabels="+URLEncoder.encode(displayName)+"&range="+maxCount+"&sampleColors="+URLEncoder.encode(colorValue)+"&userName="+EgURLEncoder.encode(userName,"UTF-8"));

		EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);

		EgTable egTable = new EgTable();
		egTable.setModel(egTableModel);
		egTable.setAttributes(egTableAttributes);
		tableList.add(egTable);
%>
							<tr>
								<td align="center" width="100%" height="100%" valign="top" class="bgwhite">
								<!-- <div id="div_scroll" style="width:100%;height:390px;border:0px solid #CBD8CC"> -->
									<table width="100%" border="0" cellspacing="0" cellpadding="0" height="100%">
										<tr>
											<td height="20" id="bgdark" class="whitefont" >
												&nbsp;<b><egui:intnl text="configmgmt.inventory.view.Distribution of" /> <egui:intnl type="<%=componentType%>" /> <egui:intnl text="configmgmt.inventory.view.across operating environments" /></b>
											</td>
										</tr>
<%
		boolean flag = false;
		if (chartDataRepresentation != null && chartDataRepresentation.equalsIgnoreCase("3D"))
		{
			flag = true;
		}
		if (flag)
		{
%>
										<tr>
											<td width="100%" align="center">
												<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text">
													<tr>
														<td align="center" width="100%" bgcolor="white" nowrap>
															<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90%" height="250" id="StackedBar3D">
																<param name="movie" value="/final/FusionCharts/swf/StackedBar3D.swf" />
																<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=250" />
																<param name="quality" value="high" />
																<param name="wmode" value="transparent" />
																<embed src="/final/FusionCharts/swf/StackedBar3D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=250" quality="high" width="90%" height="250" wmode="transparent" name="StackedBar3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
															</object> -->

															<div id="chartStackedBarComp3DContainer"  style="height:100%;"></div>
															<script type="text/javascript">
																if  ( FusionCharts( "myStackedBarComp3DChartId" ) )
																		FusionCharts( "myStackedBarComp3DChartId" ).dispose();
																var myChart = new FusionCharts( "/final/FusionCharts/swf/StackedBar3D.swf","myStackedBarComp3DChartId", "650", "250","0","1");
																myChart.setXMLData("<%=xmlString%>");
																myChart.setTransparent(true);
																myChart.render("chartStackedBarComp3DContainer");
															</script>
														</td>
													</tr>
												</table>
											</td>
										</tr>
<%
		}
		else
		{
%>
										<tr>
											<td width="100%" align="center">
												<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text">
													<tr>
														<td align="center" width="100%" bgcolor="white" nowrap>
															<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90%" height="250" id="StackedBar2D">
																<param name="movie" value="/final/FusionCharts/swf/StackedBar2D.swf" />
																<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=250" />
																<param name="quality" value="high" />
																<param name="wmode" value="transparent" />
																<embed src="/final/FusionCharts/swf/StackedBar2D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=250" quality="high" width="90%" height="250"  wmode="transparent" name="StackedBar2D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
															</object> -->

															<div id="chartStackedBarComp2DContainer"  style="height:100%;"></div>
															<script type="text/javascript">
																if  ( FusionCharts( "myStackedBarComp2DChartId" ) )
																		FusionCharts( "myStackedBarComp2DChartId" ).dispose();
																var myChart = new FusionCharts( "/final/FusionCharts/swf/StackedBar2D.swf","myStackedBarComp2DChartId", "650", "250","0","1");
																myChart.setXMLData("<%=xmlString%>");
																myChart.setTransparent(true);
																myChart.render("chartStackedBarComp2DContainer");
															</script>
														</td>
													</tr>
												</table>
											</td>
										</tr>
<%
		}
%>
										<tr>
											<td height="5" id="blank">&nbsp; </td>
										</tr>
										<tr>
											<td align="center" width="100%" valign="top">
												<table width="99%" border="0" cellpadding="0" cellspacing="0" class="body_text" id="bottomtable">
													<tr>
														<td  height="20" class="bgdarkimg" id="white_content"><b><egui:intnl text="configmgmt.inventory.view.List of systems under each operating environment" /></b>
														</td>
													</tr>
													<tr>
														<td  align="center" id="padding3">
															<table border="0" cellspacing="0" cellpadding="0" class="body_text" width="100%">
<%
		//start to get pdf table data
		egTableAttributes = new EgTableAttributes();
		egTableAttributes.setTitle(mappingInfo.getTextDescription("configmgmt.inventory.view.List of systems under each operating environment"));
		egTableAttributes.setStartX(0);
		
		aListColumnNames = new ArrayList();
		aListData = new ArrayList();
		ArrayList userColumnNames = new ArrayList();

		aListColumnNames.add("C0");
		aListColumnNames.add("C1");
		aListColumnNames.add("C2");
		aListColumnNames.add("C3");

		userColumnNames.add("C0");
		userColumnNames.add(mappingInfo.getTextDescription("configmgmt.inventory.view.Systems"));
		userColumnNames.add("");
		userColumnNames.add("");
		//end here!!!!!!!!!!!!!!

		Iterator iteration = osDatas.keySet().iterator();
		int size=0;
		while (iteration.hasNext())
		{
			String osName = (String)iteration.next();
			Hashtable nickNames=(Hashtable)osDatas.get(osName);
			if(nickNames==null || nickNames.size()==0)
				continue;
			size++;
%>
																<tr>
																	<td id="bglight" align="left" width="20%" height="20"> &nbsp;<b><%=osName%>&nbsp;&nbsp;(<egui:intnl text="configmgmt.inventory.view.Count" /> &nbsp;:&nbsp;<%=nickNames.size()%>)</b></td>
																</tr>
<%
			Object[] displayData = nickNames.keySet().toArray();
			if (displayData.length > 0)
			{
				Arrays.sort(displayData);
			}
			int count = displayData.length;
			int j=0;
			if (count <=3)
			{
				count = 3;
			}
			else if(count % 3 != 0)
			{
				count = count +3- count % 3;
			}
%>
																<tr>
																	<td width="100%">
																		<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text">
<%
			if (displayData!= null)
			{
				for (j=0; (j<displayData.length || j < count); j++)
				{
					if (j%3 == 0)
					{
						aListData.add(osName+"  ("+mappingInfo.getTextDescription("configmgmt.inventory.view.Count")+" : "+nickNames.size()+")");
%>
																			<tr>
<%
					}
%>
									
<%
					if ( j <displayData.length)
					{
						String systemName=(String)displayData[j];
						aListData.add(systemName);
%>
																				<td width="30%" id="cell_bg1"> <a href= "../servlet/com.eg.EcConfigurationServlet?request_from=InventoryByCompType&cmd=BoxView&searchValue=&systemName=<%=EgURLEncoder.encode(systemName,"UTF-8")%>&componentType=<%=componentType%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" target="_self" class="eg_monlink"> &nbsp;<%=systemName%> </a> </td>
<%
					}
					else
					{
%>
																				<td width="30%" id="cell_bg1"><%aListData.add("");%>&nbsp;</td>
<%
					}
					if (j%3 == 2)
					{
%>
																			</tr>
<%
					}
				}
			}
%>
																		</table>
																	</td>
																</tr>
<%
			if(size<osDatas.size())
			{
%>
																<tr>
																	<td  height="10" id="blank">&nbsp;</td>
																</tr>

<%
			}
		}

		//pdf data!!!!!
		egTableModel = new EgTableModel(aListData,aListColumnNames);
		egTableAttributes.setColumnNames(userColumnNames);
		egTableAttributes.setDataGrouping(true);
		egTableAttributes.setDataGroupingField(0);

		egTable = new EgTable();
		egTable.setModel(egTableModel);
		egTable.setAttributes(egTableAttributes);
		tableList.add(egTable);
		//!!!!!!!!!!
%>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td height="5" id="blank">&nbsp;</td>
							</tr>
<%
		pdfData.setData(tableList);
		session.setAttribute("pdfData",pdfData);
	}
	else if(componentType!=null && componentType.equalsIgnoreCase("All")) //Krishnamurthi
	{
		//pdf work
		ArrayList tableList = new ArrayList();
		ArrayList aListData = new ArrayList();
		EgPdfData pdfData = new EgPdfData();
		EgTable egTable = new EgTable();
		EgReportAttributes reportAttributes = new EgReportAttributes();
		String pdfTitle = "";
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.INVENTORY REPORT BY COMPONENT TYPE") + " IN" + " '" + ec_userOption + "' "  +  ec_criteria + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + " " + dateString;
		}
		else
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.INVENTORY REPORT BY COMPONENT TYPE") + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}

		String pdfSubTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.Distribution of Component Types across operating systems");

		reportAttributes.setMainTitle(pdfTitle);
		reportAttributes.setSubTitle(pdfSubTitle);
		reportAttributes.setReportName("ComponentTypeInventory");
		reportAttributes.setModule("CONFIG");
		reportAttributes.setPortrait(true);
		pdfData.setAttributes(reportAttributes);

		EgTableAttributes egTableAttributes = new EgTableAttributes();
		String pdfTableName = "Distribution of Component Types across operating systems";
		pdfTableName = mappingInfo.getTextDescription("configmgmt.inventory.view."+pdfTableName);
		egTableAttributes.setTitle(pdfTableName);

		ArrayList userColumnNames = new ArrayList();
		userColumnNames.add("C1");
		userColumnNames.add("C2");

		ArrayList aListColumnNames = new ArrayList();
		aListColumnNames.add(mappingInfo.getTextDescription("configmgmt.inventory.view.Component Type"));
		aListColumnNames.add(mappingInfo.getTextDescription("configmgmt.inventory.view.Component Count"));
%>
							<tr>
								<td height="5" id="blank">&nbsp;</td>
							</tr>
							<tr>
								<td valign="top" align="center">
									<table width="99%" border="0" cellpadding="0" cellspacing="0" class="body_text" id="bottomtable">
										<tr>
											<td id="bgdark" class="whitefont" width="100%" colspan="<%=2+vecOS.size()%>" height="20">&nbsp;<egui:intnl text="configmgmt.inventory.view.Distribution of Component Types across operating systems" /></td>
										</tr>

										<tr>
											<td id="cell_header" width="15%" valign="top">
												&nbsp;<egui:intnl text="configmgmt.inventory.view.Component Type" />
											</td>
											<td id="cell_header" width="5%" style="text-align:center" valign="top">
												<egui:intnl text="configmgmt.inventory.view.Component Count" />
											</td>
<%
		int width = 70/vecOS.size();
		for (int x=0; x<vecOS.size(); x++)
		{
			String os = (String)vecOS.get(x);
			//pdf work
			int k=x+3;
			userColumnNames.add("C"+k);
			aListColumnNames.add(os);
%>
											<td id="cell_header" width="<%=width%>%" style="text-align:center" valign="top">
												<%=os%>
											</td>
<%
		}
		//pdf work
		egTableAttributes.setColumnNames(aListColumnNames);
%>
										</tr>
<%
		Iterator componentTypeKeys = tmapCtypeOS.keySet().iterator();
		while(componentTypeKeys.hasNext())
		{
			String compType = (String)componentTypeKeys.next();
			TreeMap tmapOSData = (TreeMap)tmapCtypeOS.get(compType);
			int totalCount = 0;
			ArrayList aListCount = new ArrayList();
			for (int j=0; j<vecOS.size(); j++)
			{
				int count = 0;
				String os = (String)vecOS.get(j);
				TreeMap tmapData = (TreeMap)tmapOSData.get(os);
				if (tmapData==null || tmapData.isEmpty())
					aListCount.add(""+count);
				else
				{
					Iterator systemKeys = tmapData.keySet().iterator();
					while(systemKeys.hasNext())
					{
						String system = (String)systemKeys.next();
						ArrayList aList = (ArrayList)tmapData.get(system);
						count = count + aList.size();
					}
					aListCount.add(""+count);
				}
				totalCount = totalCount + count;
			}

			int componentCount = 0;
			for (int m=0; m<vecComponents.size(); m++)
			{
				String comp = (String)vecComponents.get(m);
				if (comp.startsWith(compType+":"))
					componentCount++;
			}
			//pdf work
			aListData.add(mappingInfo.getComponentTypeDescription(compType));
			aListData.add(""+componentCount);
%>
										<tr>
											<td id="cell_bg1" width="15%">&nbsp;<egui:intnl type="<%=compType%>"/></td>
											<td id="cell_bg1" width="5%" align="center"><%=componentCount%></td>
<%
			for (int z=0; z<aListCount.size(); z++)
			{
				//pdf work
				aListData.add(""+aListCount.get(z));
%>
											<td id="cell_bg1" align="center">
												<%=aListCount.get(z)%>
											</td>
<%
			}
%>
										</tr>
<%
		}
%>
									</table>
								</td>
							</tr>
<%
		//pdf work
		EgTableModel egTableModel = new EgTableModel(aListData,userColumnNames);
		egTable = new EgTable();
		egTable.setModel(egTableModel);
		egTable.setAttributes(egTableAttributes);
		tableList.add(egTable);

		//pdf work
		pdfData.setData(tableList);
		session.setAttribute("pdfData",pdfData);

		//for print (if component type is 'ALL')
		TreeMap tmapPrintObj = new TreeMap();
		tmapPrintObj.put("data",tmapCtypeOS);
		tmapPrintObj.put("vecOS",vecOS);
		tmapPrintObj.put("vecComponents",vecComponents);

		printData.setMapData(tmapPrintObj);
		printData.setComponent(componentType);
		session.setAttribute("PRINT_INFORMATION",printData);
	}// end ALL comp type
	else if (componentType == null || componentType.equals("-1"))
	{
%>
							<tr>
								<td align="center" >
									<table border="0" align="center" width="100%"  height="100%">
										<tr>
											<td align="center">
												<table border="0" align="center" width="100%" class="body_text" >
													<tr>
														<td align="center">&nbsp;</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
	}
	else
	{
%>
							<tr>
								<td align="center" >
									<table border="0" align="center" width="100%"  height="100%">
										<tr>
											<td align="center">
												<table border="0" align="center" width="100%" class="body_text" >
													<tr>
														<td align="center"> <img src="/final/config/images/unavailable-data.gif" alt='<egui:intnl text="configmgmt.common.No Data" />'> </td>
													</tr>
													<tr>
														<td align="center"><b><egui:intnl text="configmgmt.inventory.view.No components available for this type" /></b></td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
	}
%>
						</table>
						<!-- </div> -->
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</form>
</body>



