<%
/*
	File				:	EcPrintMiscellaneousDataReport.jsp
	Purpose				:	Create print option for the dashboard details pages
	Creation Date		:	12-01-2007
	Author				:	Balasigamani
	UI Design			:	Krishnamurthi
	UI Design Changes		:	Jaiwin
*/
%>

<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "egurkha.config.EcUtils" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "com.eg.EgConfigTestsInfo" %>
<%@ page import = "java.net.URLEncoder"%>
<%@ page import = "egurkha.config.EcProcessData"%>
<%@ page import = "egurkha.config.EcPrintData"%>
<%@ page import = "egurkha.config.EcUserData"%>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.egurkha.util.DateUtil" %>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.IniFile" %>
<%@ page import="java.util.*" %>
<%@ page import="java.text.*"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import="egurkha.config.EcSoftwareHotfixHandler" %>
<%@ page import = "egurkha.EgUIUtils"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import = "com.eg.EgThresholdInfo"%>


<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	String[] criterias = {"Zone","Service","Segment","Component"};
	private int getTestmsrNoForInstldDscrptr(String testName)
	{
		int msrNoForInstldDscrptr = 0;
		if(testName != null)
		{
			EgThresholdInfo egThresholdInfo = new EgThresholdInfo("manager");
			String[] measures = egThresholdInfo.getMeasurementsForTest(testName);
			if(measures != null && measures.length >0)
			{
				msrNoForInstldDscrptr = measures.length-1;
			}
		}
		return msrNoForInstldDscrptr;
	}
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	EgDbInfo dbInfo = new EgDbInfo("manager");
	EgConfigTestsInfo  configTestsInfo=new EgConfigTestsInfo("manager");
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();
	
	String ec_userName = request.getParameter("userName");
	String ec_user_language = request.getParameter("user_language");
	//user language
	String userLanguage = null;
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	else if (user == null)
	{
		EcUserData ecUserData = new EcUserData(ec_userName,false);
		user = ecUserData.getUser(ec_userName);
		userLanguage = ec_user_language;
	}

	if (userLanguage == null)
	{
		userLanguage = iniUI.getDefaultLanguage();
	}

	String userDateFormat = user.getUserDateFormat();
	if (userDateFormat != null && userDateFormat.equalsIgnoreCase("Default"))
	{
		userDateFormat = currentDateFormat;
	}

	// If user date format is set, assign it to current date format.
	if (userDateFormat != null)
	{
		currentDateFormat = userDateFormat;
	}

	String searchValue =request.getParameter("searchValue");
	String showVersion=request.getParameter("showVersion");
	String osName=request.getParameter("osName");
	String printType=request.getParameter("printType");
	String requestFrom = request.getParameter("requestFrom");
	String searchCriteria;
	String testName;
	String showCount;
	String displayName;
	String softwareName;
	
	SimpleDateFormat formatter = new SimpleDateFormat (currentDateFormat+" " +"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);

	/* Added by Prakash.K starts */
	EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dateString,user);
	dateString = (String)timeZoneConverter.getDateTime();
	/* Added by Prakash.K ends */

	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");
	String ec_userOptionPrevious = request.getParameter("ec_userOptionPrevious");	
	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	String ec_forPDF = request.getParameter("ec_forPDF");

	if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
	{
		ec_criteria = request.getParameter("ec_criteria");
		ec_userOption = request.getParameter("ec_userOption");
	}

	String reportTitle = "";
	if (printType != null && printType.equalsIgnoreCase("INVENTORY_COMPONENTTYPE"))
	{
		reportTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.INVENTORY REPORT BY COMPONENT TYPE");
	}
	else if (printType != null && printType.equalsIgnoreCase("OS_INFORMATION"))
	{
		reportTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.INVENTORY REPORT BY OPERATING SYSTEM");
	}
	else if (printType != null && printType.equalsIgnoreCase("SOFTWARE_AVAILABILITY"))
	{
		reportTitle = mappingInfo.getTextDescription("configmgmt.inventory.availability.INVENTORY REPORT BY SOFTWARE AVAILABILITY/UNAVAILABILITY");
	}
	else if (printType != null && printType.equalsIgnoreCase("SERVICE_AVAILABILITY"))
	{
		reportTitle = mappingInfo.getTextDescription("configmgmt.inventory.availability.INVENTORY REPORT BY SERVICE AVAILABILITY/UNAVAILABILITY");
	}
	else if (printType != null && printType.equalsIgnoreCase("HOTFIX_AVAILABILITY"))
	{
		reportTitle = mappingInfo.getTextDescription("configmgmt.inventory.availability.INVENTORY REPORT BY HOTFIX AVAILABILITY/UNAVAILABILITY");
	}
	else if (printType != null && printType.equalsIgnoreCase("SERVICE_STATUS"))
	{
		reportTitle = mappingInfo.getTextDescription("configmgmt.inventory.servicestatus.INVENTORY REPORT BY SERVICE STATUS");
	}
	else if (printType != null && printType.equalsIgnoreCase("DAYWISE_CHANGE_DISTRIBUTION_DATA"))
	{
		reportTitle = mappingInfo.getTextDescription("configmgmt.changes.daywise.TIMELINE OF CHANGES");
	}

	String fontStyle = "";
	if ((dbInfo.doubleByteEnabled || !userLanguage.equals("en_US")) && 
		(ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes")))
	{
		fontStyle = "multi_font";
	}
%>

<html style="background:#ffffff!important">
<head>
<title><egui:intnl text="configmgmt.common.eG Configuration Report" /></title>
<egui:skin ui="config"/>
<link rel="stylesheet" type="text/css" href="/final/styles/eGLightThemeIcons.css" />

<style>
	@media print {body {-webkit-print-color-adjust: exact;}}
	table,tr {page-break-inside: auto !important}

	header {font-size: 15px; }
	.iconPrinter { background-position: 0 -1080px; width: 16px; height: 16px; }
</style>

<script language="Javascript">
	//window.print();
</script>
</head>

<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0">
<form name="printData">
<input type="hidden" name="ec_criteriaPrevious" value="<%=ec_criteria%>">
<input type="hidden" name="ec_userOptionPrevious" value="<%=ec_userOption%>">

<table width="99%" align="center" cellspacing="0" cellpadding="0" border="0">

<%
	if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("No"))
	{
%>
	<tr>
		<td height="5">
			<img src="/final/config/images/spacer.gif" border="0" height="5">
		</td>
	</tr>

	<tr>
		<td align="center">
			<table align="center" cellspacing="0" cellpadding="0" height="24" border="0" width="100%" class="body_text">
				<tr>
					<td align="center">
						<b><egui:intnl text="configmgmt.common.Generated on" />&nbsp;<%=dateString%></b>
					</td>
				</tr>
			</table>
		</td>
	</tr>

	<tr>
		<td>
			<table width="100%" align="center" cellspacing="0" cellpadding="0" border="0" class="body_text">
				<tr>
					<td align="center" height="24" >
						<table align="center" cellspacing="0" cellpadding="5" height="24" border="0" width="100%" id="pageHeader">
							<tr>
<%
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
			ec_criteria = ec_criteria.toUpperCase();
			ec_userOption = ec_userOption.toUpperCase();
%>
								
							<td align="left" width="100%"><div style="float:left"><header><%=reportTitle.toUpperCase()%>&nbsp;<egui:intnl text="IN" />&nbsp;'<%=ec_userOption%>'&nbsp;<%=ec_criteria%></header></div>
<%
		}
		else
		{
%>
								
								<td align="left" width="100%"><div style="float:left"><header><%=reportTitle.toUpperCase()%></header></div>
<%
		}
%>
								
								<div style="float:right"><img class="mouse iconPrinter" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0" onClick="javascript:print()"></div>
									
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>

	<tr><td><table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="15"></td></tr></table></td></tr>
<%
	}
	else if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
	{
		//String imageName = iniUI.getConfigHomeLogo();
		String imageName = user.getConfigLogo();
%>
	<tr>
		<td>
			<table width="100%" border="0" cellspacing="0" cellpadding="0">
				<tr>
					<td align="left" width="30%" valign="bottom"><img src="<%=imageName%>" border="0"></td>
					<td width="70%" align="right" valign="bottom">
						<table width="100%" border="0" cellspacing="0" cellpadding="0">
<%
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
			ec_criteria = ec_criteria.toUpperCase();
			ec_userOption = ec_userOption.toUpperCase();
%>
							<tr>
								<td align="right" class="<%=fontStyle%>"><b><%=reportTitle.toUpperCase()%>&nbsp;<egui:intnl text="IN" />&nbsp;'<%=ec_userOption%>'&nbsp;<%=ec_criteria%></b></td>
							<tr>
<%
		}
		else
		{
%>
							<tr>
								<td align="right" class="<%=fontStyle%>"><b><%=reportTitle.toUpperCase()%></b></td>
							</tr>
<%
		}
%>
							<tr>
								<td>
									<img src="/final/config/images/spacer.gif" border="0">
								</td>
							</tr>
							<tr>
								<td align="right" valign="bottom" class="<%=fontStyle%>"><b><egui:intnl text="configmgmt.configuration.as on" />&nbsp;<%=dateString%></b></td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td height="5">
			<img src="/final/config/images/spacer.gif" border="0" height="50">
		</td>
	</tr>
<%
	}

	if(printType!=null && printType.equalsIgnoreCase("OS_INFORMATION"))
	{
		EcPrintData printData=null;
		if (requestFrom!=null && requestFrom.equals("Schedule"))
		{
			printData=(EcPrintData)request.getAttribute("print_os_information");
		}
		else
		{
			printData=(EcPrintData)session.getAttribute("print_os_information");
		}
		Object []displayData=printData.getDisplayData();
		osName=printData.getOsName();
		searchValue=printData.getSearchValue();
		showVersion=printData.getOsVersion();
		Map resultData=printData.getMapData();
		Map osCount=printData.getMapCountData();
%>
	<tr>
		<td align="center">
			<table border="0" width="100%" cellspacing="0" class="body_text" cellpadding="0">
<%
		if (searchValue!=null && !searchValue.equalsIgnoreCase("null") && !searchValue.equalsIgnoreCase(""))
		{
%>
				<tr>
					<td height="20" align="center" class="<%=fontStyle%>">
<%
			
			if (osName.equalsIgnoreCase("All"))
			{
%>
				<b><egui:intnl text="configmgmt.inventory.view.Systems containing string" /><%=" \"" + searchValue + "\" "%><egui:intnl text="configmgmt.inventory.view.across operating systems" /></b>
<%
			}
			else
			{
%>
				<b><%=osName+" "%><egui:intnl text="configmgmt.inventory.view.Systems containing string" /><%=" \"" + searchValue + "\" "%></b>
<%
			}
%>
					</td>
				</tr>

				<tr><td><table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="20"></td></tr></table></td></tr>
<%
		}

		if(!osName.equalsIgnoreCase("All"))
		{
			Integer osCout=(Integer)osCount.get(osName);
%>
				<tr>
					<td height="20" class="<%=fontStyle%>">
						&nbsp;<b><%=osName%>&nbsp;&nbsp;(<egui:intnl text="configmgmt.inventory.view.Count" />&nbsp;:&nbsp;<%=osCout.intValue()%>)</b>
					</td>
				</tr>
<%
		}
		else
		{
%>
				<tr>
					<td height="20" style="align:center" class="<%=fontStyle%>">
						&nbsp;<b><egui:intnl text="configmgmt.inventory.view.Distribution of systems across operating systems"/></b>
					</td>
				</tr>
<%
		}
%>
				<tr>
					<td colspan="2" align="center">
						<table width="100%" border="0" cellpadding="0" cellspacing="0">
<%
		if(osName!=null && osName.equalsIgnoreCase("All"))  // Display Dashboard for all operating system
		{
%>
							<tr><td><table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="10"></td></tr></table></td></tr>

							<tr>
								<td width="100%" align="center">
									<table cellspacing="0" cellpadding="0" border="0" class="body_text" width="98%" >
										<tr>
											<td width="100%" align="center">
												<table cellspacing="0" cellpadding="0" border="0" class="body_text" width="100%" >
													<tr>
														<td width="100%" align="center">
<%
			String countName=printData.getSampleLabel();
			String countValue=printData.getSampleValue();
			String colorValue=printData.getSampleColor();
			String titleName=printData.getChartTitle();
%>
															<img src="../servlet/com.eg.EcChartController?view=GRAPH&pageName=DASHBOARD_OS&chartType=PieChart&height=360&width=650&chartTitle=<%=EgURLEncoder.encode(titleName,"UTF-8")%>&sampleValues=<%=EgURLEncoder.encode(countValue,"UTF-8")%>&sampleLabels=<%=EgURLEncoder.encode(countName,"UTF-8")%>&sampleColors=<%=EgURLEncoder.encode(colorValue,"UTF-8")%>&userName=<%=EgURLEncoder.encode(ec_userName,"UTF-8")%>" border="0" hspace="0">
														</td>
													</tr>
												</table>
											</td>
										</tr>
										<tr><td><table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="10"></td></tr></table></td></tr>
<%
		}

		int size=0;
		for(int n=0;n<displayData.length;n++)
		{
			size++;
			boolean first=false;
			String selectedOsName =(String)displayData[n];
			Hashtable  versionDetails= (Hashtable)resultData.get(selectedOsName);
			Integer osCout=(Integer)osCount.get(selectedOsName);
			Object[] displayVersion = versionDetails.keySet().toArray();
			if (displayVersion.length > 0)
			{
				Arrays.sort(displayVersion);
			}

			if(osName.equalsIgnoreCase("All"))
			{
%>
										<tr>
											<td width="100%" height="20" class="<%=fontStyle%>">&nbsp;<b><%=selectedOsName%>&nbsp;&nbsp;(<egui:intnl text="configmgmt.inventory.view.Count" />&nbsp;:&nbsp;<%=osCout.intValue()%>)</b></td>
										</tr>
<%
			}
%>
										<tr>
											<td width="100%" align="right">
												<table cellspacing="0" cellpadding="0" border="0" width="100%" id="bottomtable">
													<tr>
														<td width="15%" align="left" id="lineright" height="20" class="<%=fontStyle%>">
															&nbsp;<b><egui:intnl text="configmgmt.inventory.view.Version" /></b>
														</td>
														
														<td align="left" height="20" class="<%=fontStyle%>">&nbsp;<b><egui:intnl text="configmgmt.inventory.view.Systems" /></b></td>
														
													</tr>
												</table>
											</td>
										</tr>

										<tr>
											<td width="100%" align="right" id="lineleft" valign="top">
												<table border="0" cellspacing="0" cellpadding="0" width="100%" class="body_text">
<%
			Iterator verIterate = versionDetails.keySet().iterator();
			while (verIterate.hasNext())
			{
				String versionName = (String)verIterate.next();
				if(showVersion!=null)
				{
					if(!versionName.equalsIgnoreCase(showVersion))
						continue;
				}
				Hashtable nickName=(Hashtable)versionDetails.get(versionName);
				ArrayList component =getSystemNickName(nickName);// 
				Collections.sort(component);
				int count = component.size();
				int j=0;
				if (count <=3)
				{
					count = 3;
				}
				else if(count %3 != 0)
				{
					count = count+3 - count % 3;
				}
%>
													<tr>
														<td width="15%" align="left" id="linebottomright" valign="center" class="<%=fontStyle%>">
															&nbsp;<%=versionName%>
														</td>
									
														<td width="85%">
															<table cellspacing="0" cellpadding="0" border="0" class="body_text" width="100%">
<%
				if (component!= null)
				{
					for (j=0; (j<component.size() || j < count); j++)
					{
						if (j%3 == 0)
						{
%>
																<tr>
<%
						}
						if ( j <component.size())
						{
							String systemName=(String)component.get(j);
%>
																	<td width="30%" id="linebottomright" height="20px" valign="center" class="<%=fontStyle%>">
																		&nbsp;<%=systemName%>
																	</td>
<%						}
						else
						{
%>
																	<td width="30%" id="linebottomright" height="20px">&nbsp;</td>
<%
					}
					if (j%3 == 2)
					{
%>
																</tr>
<%
					}
				}
			}
%>
															</table>
														</td>
													</tr>
<%
			}
%>
												</table>
											</td>
										</tr>
<%
			if(size<displayData.length)
			{
%>
										<tr><td><table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="10"></td></tr></table></td></tr>
<%
			}
		}
%>
									</table>
								</td>
							</tr>
							<tr><td><table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="10"></td></tr></table></td></tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
<%
	}
	else if(printType!=null && printType.equalsIgnoreCase("INVENTORY_COMPONENTTYPE"))
	{
		EcPrintData printData=(EcPrintData)session.getAttribute("PRINT_INFORMATION");
		Map componentOsData=(TreeMap)printData.getMapData();
		String barLabel=printData.getBarLabel();
		String sampleValue=printData.getSampleValue();
		String maxCount=printData.getMaxRange();
		String sampleColor=printData.getSampleColor();
		String componentType=printData.getComponent();

		if(componentType != null && componentType.equalsIgnoreCase("All"))
		{
			//print data starts here
			Vector vecOS = (Vector)componentOsData.get("vecOS");
			Vector vecComponents = (Vector)componentOsData.get("vecComponents");
			componentOsData = (TreeMap)componentOsData.get("data");
			if(componentOsData != null && componentOsData.size()>0)
			{
%>
	<tr>
		<td valign="top">
			<table width="100%" border="0" cellpadding="2" cellspacing="0" class="body_text" id="bottomtable" style="border-bottom-width:0px">
				<tr>
					<td id="linebottom" width="100%" colspan="<%=2+vecOS.size()%>" height="20" class="<%=fontStyle%>">&nbsp;<b><egui:intnl text="configmgmt.inventory.view.Distribution of Component Types across operating systems" /></b></td>
				</tr>

				<tr>
					<td width="15%" id="linebottomright" valign="top" class="<%=fontStyle%>">&nbsp;<b><egui:intnl text="configmgmt.inventory.view.Component Type" /></b></td>
					<td width="5%" style="text-align:center" valign="top" id="linebottomright" class="<%=fontStyle%>"><b><egui:intnl text="configmgmt.inventory.view.Component Count" /></b></td>
<%
				int width = 70/vecOS.size();
				for (int x=0; x<vecOS.size(); x++)
				{
					String os = (String)vecOS.get(x);
					if (x == vecOS.size()-1)
					{
%>
					<td id="linebottom" width="<%=width%>%" style="text-align:center" valign="top" class="<%=fontStyle%>"><b>
						<%=os%></b>
					</td>
<%
					}
					else
					{
%>
					<td id="linebottomright" width="<%=width%>%" style="text-align:center" valign="top" class="<%=fontStyle%>"><b>
						<%=os%></b>
					</td>
<%
					}
				}
%>
				</tr>
<%
				Iterator componentTypeKeys = componentOsData.keySet().iterator();
				while(componentTypeKeys.hasNext())
				{
					String compType = (String)componentTypeKeys.next();
					TreeMap tmapOSData = (TreeMap)componentOsData.get(compType);
					int totalCount = 0;
					ArrayList aListCount = new ArrayList();
					for (int j=0; j<vecOS.size(); j++)
					{
						int count = 0;
						String os = (String)vecOS.get(j);
						TreeMap tmapData = (TreeMap)tmapOSData.get(os);
						if (tmapData==null || tmapData.isEmpty())
							aListCount.add(""+count);
						else
						{
							Iterator systemKeys = tmapData.keySet().iterator();
							while(systemKeys.hasNext())
							{
								String system = (String)systemKeys.next();
								ArrayList aList = (ArrayList)tmapData.get(system);
								count = count + aList.size();
							}
							aListCount.add(""+count);
						}
						totalCount = totalCount + count;
					}

					int componentCount = 0;
					for (int m=0; m<vecComponents.size(); m++)
					{
						String comp = (String)vecComponents.get(m);
						if (comp.startsWith(compType))
							componentCount++;
					}
%>
				<tr>
					<td id="linebottomright" width="15%" class="<%=fontStyle%>">&nbsp;<egui:intnl type="<%=compType%>" /></td>
					<td id="linebottomright" width="5%" align="center" class="<%=fontStyle%>"><%=componentCount%></td>
<%
					for (int z=0; z<aListCount.size(); z++)
					{
						if (z == aListCount.size()-1)
						{
%>
					<td id="linebottom" align="center" class="<%=fontStyle%>">
						<%=aListCount.get(z)%>
					</td>
<%
						}
						else
						{
%>
					<td id="linebottomright" align="center" class="<%=fontStyle%>">
						<%=aListCount.get(z)%>
					</td>
<%
						}
					}
%>
				</tr>
<%
				}
%>
			</table>
		</td>
	</tr>
<%
			}
		}
		else
		{
			if(componentOsData!=null && componentOsData.size()>0)
			{
%>
	<tr>
		<td align="center" width="100%">
			<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text" >
				<tr>
					<td width="100%" height="20" class="<%=fontStyle%>">
						&nbsp;<b><egui:intnl text="configmgmt.inventory.view.Distribution of" /> <egui:intnl type="<%=componentType%>" /> <egui:intnl text="configmgmt.inventory.view.across operating environments" /></b>
					</td>
				</tr>

				<tr>
					<td width="100%" align="center">
						<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text" id="bottomtable">
							<tr>
								<td height="20"><img src="/final/config/images/spacer.gif" border="0">
							</tr>
							<tr>
								<td width="100%" align="center" valign="middle">
									<img src="../servlet/com.eg.EcChartController?view=GRAPH&pageName=INVENTORY_COMPONENT_TYPE&chartType=bar&height=250&width=550&sampleValues=<%=EgURLEncoder.encode(sampleValue,"UTF-8")%>&barLabels=<%=EgURLEncoder.encode(barLabel,"UTF-8")%>&range=<%=maxCount%>&sampleColors=<%=EgURLEncoder.encode(sampleColor,"UTF-8")%>&userName=<%=EgURLEncoder.encode(ec_userName,"UTF-8")%>" border="0" hspace="0">
								</td>
							</tr>

							<tr>
								<td height="0">
									<img src="/final/config/images/spacer.gif" border="0" height="15">
								</td>
							</tr>

							<tr>
								<td width="100%" align="center">
									<table width="98%" border="0" cellpadding="0" cellspacing="0" class="body_text" id="bottomtable" style="border-bottom:0px">
										<tr>
											<td  height="20" id="linebottom" class="<%=fontStyle%>">
											&nbsp;<b><egui:intnl text="configmgmt.inventory.view.List of systems under each operating environment" /></b>
											</td>
										</tr>
										<tr>
											<td align="center" width="100%" >
												<table border="0"  cellspacing="0" cellpadding="0" width="100%" align="center" class="body_text" >
<%
				Iterator iteration = componentOsData.keySet().iterator();
				int size=0;
				while (iteration.hasNext())
				{
					osName = (String)iteration.next();
					Hashtable nickNames=(Hashtable)componentOsData.get(osName);
					if(nickNames==null || nickNames.size()==0)
						continue;
					size++;
%>
													<tr>
														<td width="100%" class="body_text <%=fontStyle%>" height="20" align="left" id="linebottom"> &nbsp;<b><%=osName%>&nbsp;(<egui:intnl text="configmgmt.inventory.view.Count" />&nbsp;:&nbsp;<%=nickNames.size()%>)</b>
														</td>
													</tr>
<%
					Object[] displayData = nickNames.keySet().toArray();
					if (displayData.length > 0)
					{
						Arrays.sort(displayData);
					}
					int count = displayData.length;
					int j=0;
					if (count <=3)
					{
						count = 3;
					}
					else if(count % 3 != 0)
					{
						count = count+3 - count % 3;
					}
%>
													<tr>
														<td width="100%" align="center">
															<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text">
<%
					if (displayData!= null)
					{
						for (j=0; (j<displayData.length || j < count); j++)
						{
							if (j%3 == 0)
							{
%>
																<tr>
<%
							}
							if ( j <displayData.length)
							{
								String systemName=(String)displayData[j];
								if (j%3 == 2)
								{
%>
																	<td width="30%" id="linebottom" height="20" class="<%=fontStyle%>">
																		&nbsp;<%=systemName%>
																	</td>
<%
								}
								else
								{
%>
																	<td width="30%" id="linebottomright" height="20" class="<%=fontStyle%>">
																		&nbsp;<%=systemName%>
																	</td>
<%
								}
							}
							else
							{
								if (j%3 == 2)
								{
%>
																	<td width="30%" id="linebottom" height="20">&nbsp;</td>
<%
								}
								else
								{
%>
																	<td width="30%" id="linebottomright" height="20">&nbsp;</td>
<%
								}
							}
							if (j%3 == 2)
							{
%>
																</tr>
<%
							}
						}
					}
%>
															</table>
														</td>
													</tr>
<%
					//if(size<componentOsData.size())
					//{
	%>
							<!-- <tr><td height="20"><table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0"></td></tr></table></td></tr> -->
<%
					//}
				}
		
%>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<tr><td height="10"><img src="/final/config/images/spacer.gif" border="0"></td></tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
<%
			}
		}
	}
	else if(printType!=null && printType.equalsIgnoreCase("SERVICE_STATUS"))
	{
		EcPrintData printData = null;
		if (requestFrom != null && requestFrom.equals("Schedule"))
		{
			printData=(EcPrintData)request.getAttribute("SERVICE_STATUS");
		}
		else
		{
			printData=(EcPrintData)session.getAttribute("SERVICE_STATUS");
		}
		osName=printData.getOsName();
		searchValue=printData.getSearchValue();
		searchCriteria=printData.getSearchCriteria();
		String selectedServiceName=printData.getAvailableName();
		Map servicesData=(TreeMap)printData.getMapData();
		List displayServicesName=(ArrayList)printData.getListData();
%>
		<tr>
			<td  height="20" align="center">
				<table border="0" cellspacing="0" cellpadding="0" width="100%" class="body_text">
					<tr>
<%
		if (searchValue != null && !searchValue.equals(""))
		{
			if (searchCriteria!=null && searchCriteria.equalsIgnoreCase("contain"))
			{
%>
					<td height="0" align="center" class="<%=fontStyle%>">
						<b><egui:intnl text="configmgmt.inventory.servicestatus.Service names containing" />&nbsp;"<%=searchValue%>"&nbsp;<egui:intnl text="configmgmt.inventory.servicestatus.in" />&nbsp;<%=osName%>&nbsp;<egui:intnl text="configmgmt.inventory.servicestatus.Systems" /></b>
					</td>
<%
			}
			else if (searchCriteria!=null && searchCriteria.equalsIgnoreCase("start"))
			{
%>
					<td height="0" align="center" class="<%=fontStyle%>">
						<b><egui:intnl text="configmgmt.inventory.servicestatus.Service names starting with" />&nbsp;"<%=searchValue%>"&nbsp;<egui:intnl text="configmgmt.inventory.servicestatus.in" />&nbsp;<%=osName%>&nbsp;<egui:intnl text="configmgmt.inventory.servicestatus.Systems" /></b>
					</td>

<%
			}
			else if (searchCriteria!=null && searchCriteria.equalsIgnoreCase("end"))
			{
%>
					<td height="0" align="center" class="<%=fontStyle%>">
						<b><egui:intnl text="configmgmt.inventory.servicestatus.Service names ending with" />&nbsp;"<%=searchValue%>"&nbsp;<egui:intnl text="configmgmt.inventory.servicestatus.in" />&nbsp;<%=osName%>&nbsp;<egui:intnl text="configmgmt.inventory.servicestatus.Systems" /></b>
					</td>
<%
			}
		}
		else if (searchCriteria.equalsIgnoreCase("contain"))
		{
%>
					<td height="0" align="center" class="<%=fontStyle%>">
						<b><egui:intnl text="configmgmt.inventory.servicestatus.All Services in" />&nbsp;<%=osName%>&nbsp;<egui:intnl text="configmgmt.inventory.servicestatus.Systems" /></b>
					</td>
<%
		}

		if (searchCriteria!=null && searchCriteria.equalsIgnoreCase("equals"))
		{
%>
					<td height="0" align="center" class="<%=fontStyle%>">
						<b><egui:intnl text="configmgmt.inventory.servicestatus.Service named" />&nbsp;"<%=selectedServiceName%>"&nbsp;<egui:intnl text="configmgmt.inventory.servicestatus.in" />&nbsp;<%=osName%>&nbsp;<egui:intnl text="configmgmt.inventory.servicestatus.Systems" /></b>
					</td>
<%
		}
%>
				</tr>
			</table>
		</td>
	</tr>

	<tr>
		<td>
			<table border="0" cellspacing="0" cellpadding="0" width="100%">
				<tr>
					<td height="0">
						<img src="/final/config/images/spacer.gif" border="0" height="10">
					</td>
				</tr>
			</table>
		</td>
	</tr>

	<tr>
		<td width="100%" align="center">
			<table align="center" cellspacing="0" cellpadding="0" width="99%" border="0" class="body_text">
				<tr>
					<td height="20" class="<%=fontStyle%>">
						&nbsp;&nbsp;<b><egui:intnl text="configmgmt.inventory.servicestatus.Service status in" />&nbsp;<%=osName%></b>
					</td>
				</tr>
			</table>
		</td>
	</tr>

	<tr>
		<td valign="top" width="100%" align="center">
			<table width="99%" cellpadding="0" cellspacing="0" class="body_text" border="0" >
				<tr><td align="center"><table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text"><tr><td height="5"><img src="/final/config/images/spacer.gif" border="0" height="2"></td></tr></table></td></tr>
<%
	if (displayServicesName != null && !displayServicesName.isEmpty())
	{
		for(int s=0;s<displayServicesName.size();s++)
		{
			String serviceName=(String)displayServicesName.get(s); 
			Hashtable infoStatusList=(Hashtable)servicesData.get(serviceName);
			String running=(String)infoStatusList.get("Running");
			String stopped=(String)infoStatusList.get("Stopped");
			String unavailable=(String)infoStatusList.get("UNAVAILABLE");
%>
				<tr>
					<td align="center">
						<table border="0" width="98%" cellspacing="0" cellpadding="0" class="body_text" id="bottomtable" style="border-bottom-width:0px">
							<tr>
								<td id="linebottom" align="left" height="20" class="<%=fontStyle%>">&nbsp;<b><%=serviceName%></b></td>
							</tr>
							<tr>
								<td align="center" >
									<table border="0" cellspacing="0" cellpadding="0" class="body_text" width="100%" >
<%
			if(running!=null)
			{
				StringTokenizer st=new StringTokenizer(running,"#");
				int count=st.countTokens();
				String temp = "System";
				if (count>1)
					temp = "Systems";
%>
										<tr>
											<td id="linebottom" align="left" width="100%" height="20" class="<%=fontStyle%>">&nbsp;&nbsp;<b><egui:intnl text="configmgmt.inventory.servicestatus.Running on" />&nbsp;<%=st.countTokens()%>&nbsp;<egui:intnl text='<%="configmgmt.inventory.servicestatus."+temp%>' /></b></td>
											<!-- <td height="15"><img src="/final/config/images/cell_corner_green.gif"></td> -->
										</tr>

										<tr>
											<td height="20" align="left" id="linebottom" wrap class="<%=fontStyle%>">&nbsp;
<%
				while(st.hasMoreElements())
				{
					String systemName=(String)st.nextElement();
					systemName=systemName.trim();
					if(count>1)
						out.println(systemName+",");
					else
						out.println(systemName);
					count--;
				}
%>
											</td>
										</tr>

									<!-- 	<tr><td align="center"><table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text"><tr><td height="5"><img src="/final/config/images/spacer.gif" border="0" height="2"></td></tr></table></td></tr> -->
<%
			}

			if(stopped!=null)
			{
				StringTokenizer st=new StringTokenizer(stopped,"#");
				int count=st.countTokens();
				String temp = "System";
				if (count>1)
					temp = "Systems";
%>
										<tr>
											<td id="linebottom" align="left" width="25%" height="20" class="<%=fontStyle%>">&nbsp;&nbsp;<b><egui:intnl text="configmgmt.inventory.servicestatus.Stopped on" />&nbsp;<%=st.countTokens()%>&nbsp;<egui:intnl text='<%="configmgmt.inventory.servicestatus."+temp%>' /></b></td>
											<!-- <td height="15"><img src="/final/config/images/cell_corner_green.gif"></td> -->
										</tr>
										<tr>
											<td id="linebottom" height="20" align="left" wrap class="<%=fontStyle%>">&nbsp;
<%
				while(st.hasMoreElements())
				{
					String systemName=(String)st.nextElement();
					systemName=systemName.trim();
					if(count>1)
						out.println(systemName+",");
					else
						out.println(systemName);
					count--;
				}
%>
											</td>
										</tr>

										<!-- <tr><td align="center"><table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text"><tr><td height="5"><img src="/final/config/images/spacer.gif" border="0" height="2"></td></tr></table></td></tr> -->
<%
			}

			if(unavailable!=null)
			{
				StringTokenizer st=new StringTokenizer(unavailable,"#");
				int count=st.countTokens();
				String temp = "System";
				if (count>1)
					temp = "Systems";
%>
										<tr>
											<td id="linebottom" align="left" width="25%" height="20" class="<%=fontStyle%>">&nbsp;&nbsp;<b><egui:intnl text="configmgmt.inventory.servicestatus.Unavailable in" />&nbsp;<%=st.countTokens()%>&nbsp;<egui:intnl text='<%="configmgmt.inventory.servicestatus."+temp%>' /></b></td>
											<!-- <td height="15"><img src="/final/config/images/cell_corner_green.gif"></td> -->
										</tr>

										<tr>
											<td id="linebottom" align="left" height="20" wrap class="<%=fontStyle%>">&nbsp;
<%
				while(st.hasMoreElements())
				{
					String systemName=(String)st.nextElement();
					systemName=systemName.trim();
					if(count>1)
						out.println(systemName+",");
					else
						out.println(systemName);
					count--;
				}
%>
											</td>
										</tr>

									<!-- 	<tr><td align="center"><table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text"><tr><td height="5"><img src="/final/config/images/spacer.gif" border="0" height="2"></td></tr></table></td></tr> -->
<%
			}
%>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr><td align="center"><table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text"><tr><td height="10"><img src="/final/config/images/spacer.gif" border="0" height="2"></td></tr></table></td></tr>
<%
		}
	}
	else
	{
%>
				<tr>
					<td align="center">
						<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="50"></td></tr></table>
					</td>
				</tr>
				<tr>
					<td align="center">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" valign="top">
							<tr>
								<td width="100%" height="100%">
									<table border="0" align="center" width="100%" class="body_text" cellspacing="0" cellpadding="0" height="100%">
										<tr>
											<td align="center" height="100%">
												<table border="0" align="center" width="100%" height="100%" cellspacing="0" cellpadding="0">
													<tr>
														<td align="center">
															<table border="0" align="center" width="100%" class="body_text" cellspacing="0" cellpadding="0">
																<tr>
																	<td align="center"><img src="/final/config/images/unavailable-data.gif"></td>
																</tr>
																<tr>
																	<td align="center" class="<%=fontStyle%>"><b><%=mappingInfo.getTextDescription("configmgmt.common.No data found")%></b></td>
																</tr>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%
	}
%>
			</table>
		</td>
	</tr>
<%
	}
	else if(printType!=null && printType.equalsIgnoreCase("HOTFIX_AVAILABILITY"))
	{
		EcPrintData printData = null;
		EcProcessData processData = null;
		if (requestFrom != null && "Schedule".equals(requestFrom))
		{
			printData=(EcPrintData)request.getAttribute("HOTFIX_AVAILABILITY");
			processData=(EcProcessData)request.getAttribute("processDataObject");
		}
		else
		{
			printData=(EcPrintData)session.getAttribute("HOTFIX_AVAILABILITY");
			processData=(EcProcessData)session.getAttribute("processDataObject");
		}
		osName=printData.getOsName();
		testName=printData.getTestName();
		showCount=printData.getShowCount();
		softwareName=printData.getAvailableName();
		List softwareCount=(ArrayList)printData.getListData();
		Map finalData=(TreeMap)printData.getMapData();
		Map countData=(TreeMap)printData.getMapCountData();
%>
	<tr>
		<td width="100%" align="center">
			<table align="center" cellspacing="0" cellpadding="0" width="99%" border="0">
				<tr>
<%
		if(softwareName!=null && softwareName.equalsIgnoreCase("All"))
		{
			if(showCount!=null && showCount.equalsIgnoreCase("All"))
			{
%>
					<td height="20" class="<%=fontStyle%>">
						&nbsp;&nbsp;<b><egui:intnl text="configmgmt.inventory.availability.Hotfix/Patch availability/unavailability in" />&nbsp;<%=osName%>&nbsp;<egui:intnl text="configmgmt.inventory.availability.Systems" /></b>
					</td>
<%
			}
			else
			{
%>
					<td height="20" class="<%=fontStyle%>">
						&nbsp;&nbsp;<b><egui:intnl text="configmgmt.inventory.availability.Top" />&nbsp;<%=showCount%>&nbsp;<egui:intnl text="configmgmt.inventory.availability.Hotfix/Patch availability/unavailability in" />&nbsp;<%=osName%>&nbsp;<egui:intnl text="configmgmt.inventory.availability.Systems" /></b>
					</td>
<%
			}
		}
		else
		{
%>
					<td height="20" class="<%=fontStyle%>">
						&nbsp;&nbsp;<b><egui:intnl text="configmgmt.inventory.availability.Availability/Unavailability of" />&nbsp;<%=softwareName%>&nbsp;<egui:intnl text="configmgmt.inventory.availability.hotfix/patch in" />&nbsp;<%=osName%>&nbsp;<egui:intnl text="configmgmt.inventory.availability.Systems" /></b>
					</td>
<%
		}
%>
				</tr>
			</table>
		</td>
	</tr>

	<tr>
		<td width="100%" align="center">
			<table width="99%" cellpadding="0" cellspacing="0" class="body_text" border="0" >
<%
		if(finalData!=null && finalData.size()>0)
		{
			EcUtils ecUtils = new EcUtils();
			if(softwareName!=null)
			{
				String barTitle=printData.getChartTitle();
				String sampleValues=printData.getSampleValue();
				String barLabels=printData.getBarLabel();
				String maxCount=printData.getMaxRange();
				String rangeAxisLabel=printData.getSampleAxisLabel();
				String chartColor=printData.getSampleColor();
				String barHeight = "360";

				if(!("All".equalsIgnoreCase(softwareName)))
				{
					barHeight = "200";
				}
%>
					<tr>
						<td height="0"><img src="/final/config/images/spacer.gif" border="0" height="10">
						</td>
					</tr>
					<tr align="center">
						<td width="100%" align="center">
							<img src="../servlet/com.eg.EcChartController?view=GRAPH&pageName=AVAILABILITY&chartColor=<%=chartColor%>&chartType=bar&height=<%=EgURLEncoder.encode(barHeight,"UTF-8")%>&width=650&chartTitle=<%=EgURLEncoder.encode(barTitle,"UTF-8")%>&sampleValues=<%=EgURLEncoder.encode(sampleValues,"UTF-8")%>&barLabels=<%=EgURLEncoder.encode(EgUIUtils.encodeSecurityChar(barLabels),"UTF-8")%>&rangeAxisLabel=<%=EgURLEncoder.encode(rangeAxisLabel,"UTF-8")%>&range=<%=maxCount%>&userName=<%=EgURLEncoder.encode(ec_userName,"UTF-8")%>" border="0" hspace="0">
						</td>
					</tr>
<%
			}
%>
		
				<tr><td align="center"><table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text"><tr><td height="5"><img src="/final/config/images/spacer.gif" border="0" height="1"></td></tr></table></td></tr>
<%
		}
%>
<!-- No chagen -->

<!-- comments starts -->
<%
			// int selCount=0; 
			// boolean skip=false;
			// for(int n=0;n<softwareCount.size();n++)
			// {
				// Integer count=(Integer)softwareCount.get(n);
				// ArrayList infoName=(ArrayList)countData.get(count);
				// if(!("All".equalsIgnoreCase(softwareName)))
				// {
					// List alist=new ArrayList();
					// alist.add("+"+softwareName);
					// if(infoName!=null && infoName.size()==1)
					// {
						// String tempSoftware=(String)infoName.get(0);
						// if(!tempSoftware.equals("+"+softwareName))
							// continue;
					// }
					// else if(!infoName.retainAll(alist))
						// continue;
				// }

				// //Collections.sort(infoName);
				// for(int n1=0;n1<infoName.size();n1++)
				// {
					// String info=(String)infoName.get(n1);
					// String associatedNickName=(String)finalData.get(info);
					// if(showCount!=null && !showCount.equalsIgnoreCase("All"))
					// {
						// int countInt=Integer.parseInt(showCount);
						// if(countInt==selCount)
						// {
							// skip=true;
							// break;
						// }
						// selCount++;
					// }
%>
				<!-- <tr>
					<td align="center" width="80%" valign="middle">
						<table border="0" width="98%" cellspacing="0" cellpadding="0" style="border-bottom-width:0pt">
							<tr>
								<td id="linebottom" height="20" class="<%--=fontStyle--%>">&nbsp;&nbsp;<b><%--=ecUtils.getInfoForDisplay(info.substring(1))--%></b></td>
							</tr>
							<tr>
								<td align="center">
									<table border="0" cellspacing="0" cellpadding="0" class="bottomtable" width="100%" style="border-top-width:0px;border-bottom-width:0px">-->
<%
					// ArrayList nickList=processData.getInfoNickNames(osName,associatedNickName,true);
					// if(nickList!=null && nickList.size()>0)
					// {
						// String temp = "System";
						// if(nickList.size() > 1) temp = "Systems";
%>
										<!--<tr>
											<td id="linebottom" align="left" width="50%" height="20" class="<%--=fontStyle--%>">&nbsp;&nbsp;<b><egui:intnl text="configmgmt.inventory.availability.Available in" />&nbsp;<%--=nickList.size()--%>&nbsp;<egui:intnl text='<%--="configmgmt.inventory.availability."+temp--%>' /></b></td>-->
											<!-- <td height="15"><img src="/final/config/images/cell_corner_green.gif"></td> -->
										<!--</tr>
										<tr>
											<td align="left" id="linebottom" height="20" wrap class="<%--=fontStyle--%>">&nbsp;-->
<%
						// for(int s=0;s<nickList.size();s++)
						// {
							// String systemName=(String)nickList.get(s);
							// if(s!=nickList.size()-1)
								// out.println(systemName+",");
							// else
								// out.println(systemName);
							// //temp++;
						// }
%>
											<!--</td>
										</tr>-->
<%
					// }
				
					// nickList=processData.getInfoNickNames(osName,associatedNickName,false);
					// if(nickList!=null && nickList.size()>0)
					// {
						// String temp = "System";
						// if(nickList.size() > 1) temp = "Systems";
%>
										<!-- <tr><td align="center"><table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text"><tr><td height="5"><img src="/final/config/images/spacer.gif" border="0" height="1"></td></tr></table></td></tr> -->

										<!--<tr>
											<td align="left" width="50%" id="linebottom" height="20" class="<%--=fontStyle--%>">&nbsp;&nbsp;<b><egui:intnl text="configmgmt.inventory.availability.Unavailable in" />&nbsp;<%--=nickList.size()--%>&nbsp;<egui:intnl text='<%--="configmgmt.inventory.availability."+temp--%>' /></b></td>-->
											<!-- <td height="15"><img src="/final/config/images/cell_corner_green.gif"></td> -->
										<!--</tr>

										<tr>
											<td align="left" id="linebottom" height="20" wrap class="<%--=fontStyle--%>">&nbsp;-->
<%
						// for(int s=0;s<nickList.size();s++)
						// {
							// String systemName=(String)nickList.get(s);
							// if(s!=nickList.size()-1)
								// out.println(systemName+",");
							// else
								// out.println(systemName);
						// }
%>
											<!--</td>
										</tr>-->
<%
				//	}
%>
									<!--</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>

				<tr><td align="center"><table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text"><tr><td height="10"><img src="/final/config/images/spacer.gif" border="0" height="1"></td></tr></table></td></tr>-->
<%
				// }
				// if(skip)
					// break;
			// }
		// }
%>
<!-- End comments--> 

			</table>
<!-- New chages starts -->
<%
		
	LinkedHashMap availableHtfxNameCount = null;
	int ttlCmpntsCount = 0;
		
	if (requestFrom != null && "Schedule".equals(requestFrom))
	{  
		if(testName != null && "HotFix_cf".equalsIgnoreCase(testName))
		{
			int msrNoForInstldDscrptr = getTestmsrNoForInstldDscrptr(testName);
			Map osMap = configTestsInfo.getOSMapping();
			EcSoftwareHotfixHandler ecSoftwareHotfixHandler = new EcSoftwareHotfixHandler();
			
			List allAssctdMngdCmpTypCmpnts = (ArrayList)request.getAttribute("aListAssociatedComponents");
			Map avlblCmpntNmType =ecSoftwareHotfixHandler.extractCmpntNmType(allAssctdMngdCmpTypCmpnts);

			//Total components Details
			Map trgtHostOsNm = ecSoftwareHotfixHandler.getAllTrgtHostsWithOsNm(avlblCmpntNmType);
			Map selectedOsNameWithTrgtHost = new HashMap();
			
			if(osName != null && "All".equalsIgnoreCase(osName))
			{
				ttlCmpntsCount = trgtHostOsNm.size();
			}
			else
			{
				Iterator itr = trgtHostOsNm.keySet().iterator();
				int count =0;
				while (itr.hasNext()) 
				{
					String   curKey = (String) itr.next();
					String curVal = (String)trgtHostOsNm.get(curKey);
					String tempOsName =(String)osMap.get(curVal);
					
					if( tempOsName != null && osName.equalsIgnoreCase(tempOsName))
					{
						count++;
					}
				}
				ttlCmpntsCount = count;	
			}
			availableHtfxNameCount = (LinkedHashMap)ecSoftwareHotfixHandler.getAvailableComponentsInfoCount( avlblCmpntNmType, trgtHostOsNm, "hotfix" ,msrNoForInstldDscrptr, osName, softwareName,showCount);	
		}
	}
	else
	{
		availableHtfxNameCount = (LinkedHashMap)session.getAttribute("availableHtfxNameCount");
		ttlCmpntsCount = ((Integer)session.getAttribute("ttlCmpntsCount")).intValue();		
	}
	
	if(availableHtfxNameCount != null && availableHtfxNameCount.size() >0)
	{
%>
		<div class="printOuterBox" style="margin-top:10px;page-break-inside:avoid"> 
		<div class="newTable">
			<table align="center" style="table-layout:fixed;width:100%;" cellpadding="0" cellspacing="0" border ="1" >
				<!--<thead>
					<tr>
						<th style="width:50%;word-break:break-all"  align="left"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.grid.HotfixName" /></th>
						<th style="width:25%;word-break:break-all"  align="left"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.grid.AvailableCount" /></th>
						<th style="width:25%;word-break:break-all"  align="left"><egui:intnl text="configmgmt.SoftwareHotfix.dashboard.grid.UnAvailableCount" /></th>
					</tr>
				</thead>
				<tbody>-->
					
				<tr>
					<td align="left" height="30" style="width:50%;white-space: normal;"><b><%=mappingInfo.getTextDescription("configmgmt.inventory.availability.Hotfix name")%></b></td>
					<td align="left" height="30" style="width:25%;white-space: normal;"><b><%=mappingInfo.getTextDescription("configmgmt.inventory.availability.Number of components having the hotfixes")%></b></td>
					<td align="left" height="30" style="width:25%;white-space: normal;"><b><%=mappingInfo.getTextDescription("configmgmt.inventory.availability.Number of components not having the hotfixes")%></b></td>
				</tr>
						
<%
		Iterator iterator = availableHtfxNameCount.keySet().iterator();
		while(iterator.hasNext())
		{ 
			String currentSftwrName = (String)iterator.next();
			int availableCount = ((Integer)availableHtfxNameCount.get(currentSftwrName)).intValue();
			int unAvailableCount = ttlCmpntsCount- availableCount;
%>
			<tr>
				<td align="left"  height="25" style="word-break:break-all"><%=currentSftwrName%></td>
				<td align="left"  height="25" style="word-break:break-all"><%=availableCount%></td>
				<td align="left"  height="25" style="word-break:break-all"><%=unAvailableCount%></td>
			</tr>
<%
		}
%>
			<!--</tbody>-->
		</table>
		</div>
		</div>
<%
	}			
%>
<!-- new changes End-->
		</td>
	</tr>
<%
	}
	else if(printType!=null && printType.equalsIgnoreCase("SOFTWARE_AVAILABILITY"))
	{
		EcPrintData printData=null;
		EcProcessData processData=null;		
		if (requestFrom != null && "Schedule".equals(requestFrom))
		{
			printData=(EcPrintData)request.getAttribute("SOFTWARE_AVAILABILITY");
			processData=(EcProcessData)request.getAttribute("processDataObject");		
		}
		else
		{
			printData=(EcPrintData)session.getAttribute("SOFTWARE_AVAILABILITY");
			processData=(EcProcessData)session.getAttribute("processDataObject");
		}
		osName=printData.getOsName();
		testName=printData.getTestName();
		showCount=printData.getShowCount();
		softwareName=printData.getAvailableName();
		List softwareCount=(ArrayList)printData.getListData();
		Map finalData=(TreeMap)printData.getMapData();
		Map countData=(TreeMap)printData.getMapCountData();
%>
	<tr>
		<td width="100%" align="center">
			<table align="center" cellspacing="0" cellpadding="0" width="99%" border="0" class="body_text">
				<tr>
<%
		if(softwareName!=null && softwareName.equalsIgnoreCase("All"))
		{
			if(showCount!=null && showCount.equalsIgnoreCase("All"))
			{
%>
					<td height="20" class="<%=fontStyle%>">
						&nbsp;&nbsp;<b><egui:intnl text="configmgmt.inventory.availability.Software availability/unavailability in" />&nbsp;<%=osName%>&nbsp;<egui:intnl text="configmgmt.inventory.availability.Systems" /></b>
					</td>

<%
			}
			else
			{
%>
					<td height="20" class="<%=fontStyle%>">
						&nbsp;&nbsp;<b><egui:intnl text="configmgmt.inventory.availability.Top" />&nbsp;<%=showCount%>&nbsp;<egui:intnl text="configmgmt.inventory.availability.Software availability/unavailability in" />&nbsp;<%=osName%>&nbsp;<egui:intnl text="configmgmt.inventory.availability.Systems" /></b>
					</td>
<%
			}
		}
		else
		{
%>
					<td height="20" class="<%=fontStyle%>">
						&nbsp;&nbsp;<b><egui:intnl text="configmgmt.inventory.availability.Availability/Unavailability of" />&nbsp;<%=softwareName%>&nbsp;<egui:intnl text="configmgmt.inventory.availability.software in" />&nbsp;<%=osName%>&nbsp;<egui:intnl text="configmgmt.inventory.availability.Systems" /></b>
					</td>
<%
		}
%>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td width="100%" align="center">
			<table width="99%" cellpadding="0" cellspacing="0" class="body_text" border="0" >
<%
		if(finalData!=null && finalData.size()>0)
		{
			if(softwareName!=null)
			{
				String barTitle=printData.getChartTitle();
				String sampleValues=printData.getSampleValue();
				String barLabels=printData.getBarLabel();
				String maxCount=printData.getMaxRange();
				String rangeAxisLabel=printData.getSampleAxisLabel();
				String chartColor=printData.getSampleColor();
				String barHeight = "360";

				if(!("All".equalsIgnoreCase(softwareName)))
				{
					barHeight = "200";
				}
%>
				<tr>
					<td height="0"><img src="/final/config/images/spacer.gif" border="0" height="10">
					</td>
				</tr>
				<tr align="center">
					<td width="100%" align="center">
						<img src="../servlet/com.eg.EcChartController?view=GRAPH&pageName=AVAILABILITY&chartColor=<%=chartColor%>&chartType=bar&height=<%=URLEncoder.encode(barHeight)%>&width=650&chartTitle=<%=EgURLEncoder.encode(barTitle,"UTF-8")%>&sampleValues=<%=EgURLEncoder.encode(sampleValues,"UTF-8")%>&barLabels=<%=EgURLEncoder.encode(EgUIUtils.encodeSecurityChar(barLabels),"UTF-8")%>&rangeAxisLabel=<%=EgURLEncoder.encode(rangeAxisLabel,"UTF-8")%>&range=<%=maxCount%>&userName=<%=EgURLEncoder.encode(ec_userName,"UTF-8")%>" border="0" hspace="0">
					</td>
				</tr>
<%
			}
%>
				<tr>
					<td  height="5" id="blank">&nbsp; </td>
				</tr>
<!--comments starts  -->
	<%
			// int selCount=0;
			// boolean skip=false;
			// for(int n=0;n<softwareCount.size();n++)
			// {
				// Integer count=(Integer)softwareCount.get(n);
				// List infoName=(ArrayList)countData.get(count);
				// if(!("All".equalsIgnoreCase(softwareName)))
				// {
					// List alist=new ArrayList();
					// alist.add("+"+softwareName);
					// if(infoName!=null && infoName.size()==1)
					// {
						// String tempSoftware=(String)infoName.get(0);
						// if(!tempSoftware.equals("+"+softwareName))
							// continue;
					// }
					// else if(!infoName.retainAll(alist))
						// continue;
				// }
				// //Collections.sort(infoName);
				// for(int n1=0;((infoName!=null && infoName.size()>0) && n1<infoName.size());n1++)
				// {
					// String info=(String)infoName.get(n1);
					// String associatedNickName=(String)finalData.get(info);
					// if(showCount!=null && !showCount.equalsIgnoreCase("All"))
					// {
						// int countInt=Integer.parseInt(showCount);
						// if(countInt==selCount)
						// {
							// skip=true;
							// break;
						// }
						// selCount++;
					// }
%>
				<!--<tr>
					<td align="center" width="80%" valign="middle">
						<table border="0" width="98%" cellspacing="0" cellpadding="0" style="border-bottom-width:0px">

							<tr>
								<td id="linebottom" height="20" class="<%--=fontStyle--%>">&nbsp;<b><%--=info.substring(1)--%></b></td>
							</tr>

							<tr>
								<td align="center">
									<table border="0" cellspacing="0" cellpadding="0" class="bottomtable" width="100%" style="border-top-width:0px;border-bottom-width:0px">-->
<%
					// ArrayList nickList=processData.getInfoNickNames(osName,associatedNickName,true);
					// if(nickList!=null && nickList.size()>0)
					// {
						// String temp = "System";
						// if(nickList.size() > 1) temp = "Systems";
%>
										<!--<tr>
											<td align="left" width="50%" height="20" height="15" class="<%--=fontStyle--%>">&nbsp;<b><egui:intnl text="configmgmt.inventory.availability.Available in" />&nbsp;<%--=nickList.size()--%>&nbsp;<egui:intnl text='<%--="configmgmt.inventory.availability."+temp--%>' /></b></td>-->
											<!-- <td height="15">&nbsp;<img src="/final/config/images/cell_corner_green.gif"></td> -->
										<!--</tr>
										<tr>
											<td id="linetopbottom" align="left" width="100%" wrap height="20" class="<%--=fontStyle--%>">&nbsp;-->
<%
						// for(int s=0;s<nickList.size();s++)
						// {
							// String systemName=(String)nickList.get(s);
							// if(s!=nickList.size()-1)
								// out.println(systemName+",");
							// else
								// out.println(systemName);
						// }
%>
											<!--</td>
										</tr>-->
<%
					// }
				
					// nickList=processData.getInfoNickNames(osName,associatedNickName,false);
					// if(nickList!=null && nickList.size()>0)
					// {
						// String temp = "System";
						// if(nickList.size() > 1) temp = "Systems";
%>
							<!--<tr>
								<td align="center">
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text">
										<tr>
											<td height="2"><img src="/final/config/images/spacer.gif" border="0" height="1"></td></tr></table></td>
										</tr>
										
										<tr>
											<td align="left" width="50%" height="20" height="20" class="<%--=fontStyle--%>">&nbsp;<b><egui:intnl text="configmgmt.inventory.availability.Unavailable in" />&nbsp;<%--=nickList.size()--%>&nbsp;<egui:intnl text='<%--="configmgmt.inventory.availability."+temp--%>' /></b></td>
											<!-- <td height="15">&nbsp;<img src="/final/config/images/cell_corner_green.gif"></td> -->
										<!--</tr>
										<tr>
											<td id="linetopbottom" align="left" height="20" wrap class="<%--=fontStyle--%>  ">&nbsp;-->
<%
						// for(int s=0;s<nickList.size();s++)
						// {
							// String systemName=(String)nickList.get(s);
							// if(s!=nickList.size()-1)
								// out.println(systemName+",");
							// else
								// out.println(systemName);
						// }
%>
											<!--</td>
										</tr>-->
<%
					//}
%>
									<!--</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>

				<tr><td align="center"><table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text"><tr><td height="10"><img src="/final/config/images/spacer.gif" border="0" height="1"></td></tr></table></td></tr> -->
<%
				// }

				// if(skip)
					// break;
			// }
		 }
%>
<!-- comment code ends-->
</table>
<!-- New chages starts -->
<%
	LinkedHashMap availableSftwrNameCount = null;
	int ttlCmpntsCount = 0;
	if(requestFrom != null && "Schedule".equals(requestFrom))
	{  
		if(testName != null && "SoftwareList_cf".equalsIgnoreCase(testName))
		{
			int msrNoForInstldDscrptr = getTestmsrNoForInstldDscrptr(testName);
			Map osMap = configTestsInfo.getOSMapping();
		
			EcSoftwareHotfixHandler ecSoftwareHotfixHandler = new EcSoftwareHotfixHandler();
			
			List allAssctdMngdCmpTypCmpnts = (ArrayList)request.getAttribute("aListAssociatedComponents");
			Map avlblCmpntNmType =ecSoftwareHotfixHandler.extractCmpntNmType(allAssctdMngdCmpTypCmpnts);

			//Total components Details
			Map trgtHostOsNm = ecSoftwareHotfixHandler.getAllTrgtHostsWithOsNm(avlblCmpntNmType);
			Map selectedOsNameWithTrgtHost = new HashMap();
		
			if(osName != null && "All".equalsIgnoreCase(osName))
			{
				ttlCmpntsCount = trgtHostOsNm.size();
			}
			else
			{
				Iterator itr = trgtHostOsNm.keySet().iterator();
				int count =0;
				while (itr.hasNext()) 
				{
					String   curKey = (String) itr.next();
					String curVal = (String)trgtHostOsNm.get(curKey);
					String tempOsName =(String)osMap.get(curVal);
					
					if(tempOsName != null && osName.equalsIgnoreCase(tempOsName))
					{
						count++;
					}
				}
				ttlCmpntsCount = count;	
			}
			availableSftwrNameCount = (LinkedHashMap)ecSoftwareHotfixHandler.getAvailableComponentsInfoCount( avlblCmpntNmType, trgtHostOsNm, "Software" ,msrNoForInstldDscrptr, osName, softwareName,showCount);	
		}
	}
	else
	{
		availableSftwrNameCount = (LinkedHashMap)session.getAttribute("availableSftwrNameCount");
		ttlCmpntsCount = ((Integer)session.getAttribute("ttlCmpntsCount")).intValue();
			
	}
			
	if(availableSftwrNameCount != null && availableSftwrNameCount.size() >0)
	{
				
%>
		<div class="printOuterBox" style="margin-top:10px;page-break-inside:avoid"> 
		
		<div class="newTable">
			<table align="center" style="table-layout:fixed;width:100%;" cellpadding="0" cellspacing="0" border ="1">
				<!--<thead>
					<tr>
						<th style="width:20%;white-space: normal;"  align="left"><egui:intnl text="configmgmt.inventory.availability.Software name" /></th>
						
						<th style="width:20%;white-space: normal;"  align="left"><egui:intnl text="configmgmt.inventory.availability.Number of components having the softwares" /></th>
						<th style="width:20%;white-space: normal;"  align="left"><egui:intnl text="configmgmt.inventory.availability.Number of components not having the softwares" /></th>
					</tr>
				</thead>
				<tbody>-->
					
				<tr>
					<td align="left" height="30" style="width:50%;white-space: normal;"><b><%=mappingInfo.getTextDescription("configmgmt.inventory.availability.Software name")%></b></td>
					<td align="left" height="30" style="width:25%;white-space: normal;"><b><%=mappingInfo.getTextDescription("configmgmt.inventory.availability.Number of components having the softwares")%></b></td>
					<td align="left" height="30" style="width:25%;white-space: normal;"><b><%=mappingInfo.getTextDescription("configmgmt.inventory.availability.Number of components not having the softwares")%></b></td>
				</tr>
					
<%
		Iterator iterator = availableSftwrNameCount.keySet().iterator();
		while(iterator.hasNext())
		{ 
			String currentSftwrName = (String)iterator.next();
			int availableCount = ((Integer)availableSftwrNameCount.get(currentSftwrName)).intValue();
			int unAvailableCount = ttlCmpntsCount- availableCount;
%>
			<tr>
				<td align="left" height="25" style="word-break:break-all"><%=currentSftwrName%></td>
				<td align="left" height="25" style="word-break:break-all"><%=availableCount%></td>
				<td align="left" height="25" style="word-break:break-all"><%=unAvailableCount%></td>
			</tr>
<%
		}
%>
			<!--</tbody>-->
		</table>
		</div>
		</div>
<%
	}			
%>
<!-- new changes End-->
		</td>
	</tr>
<%	
	}
	else if(printType!=null && printType.equalsIgnoreCase("SERVICE_AVAILABILITY"))
	{
		EcPrintData printData = null;
		EcProcessData processData = null;
		if (requestFrom != null && "Schedule".equals(requestFrom))
		{
			printData = (EcPrintData)request.getAttribute("SERVICE_AVAILABILITY");
			processData = (EcProcessData)request.getAttribute("processDataObject");
		}
		else
		{
			printData=(EcPrintData)session.getAttribute("SERVICE_AVAILABILITY");
			processData=(EcProcessData)session.getAttribute("processDataObject");
		}
		osName=printData.getOsName();
		testName=printData.getTestName();
		showCount=printData.getShowCount();
		softwareName=printData.getAvailableName();
		List softwareCount=(ArrayList)printData.getListData();
		Map finalData=(TreeMap)printData.getMapData();
		Map countData=(TreeMap)printData.getMapCountData();
%>
	<tr>
		<td width="100%" align="center">
			<table align="center" cellspacing="0" cellpadding="0" width="99%" border="0" class="bottomtable" >
				<tr>
<%
		if(softwareName!=null && softwareName.equalsIgnoreCase("All"))
		{
			if(showCount!=null && showCount.equalsIgnoreCase("All"))
			{
%>
					<td height="20" class="<%=fontStyle%>">
						&nbsp;&nbsp;<b><egui:intnl text="configmgmt.inventory.availability.Service availability/unavailability in" />&nbsp;<%=osName%>&nbsp;<egui:intnl text="configmgmt.inventory.availability.Systems" /></b>
					</td>

<%
			}
			else
			{
%>
					<td height="20" class="<%=fontStyle%>">
						&nbsp;&nbsp;<b><egui:intnl text="configmgmt.inventory.availability.Top" />&nbsp;<%=showCount%>&nbsp;<egui:intnl text="configmgmt.inventory.availability.Service availability/unavailability in" />&nbsp;<%=osName%>&nbsp;<egui:intnl text="configmgmt.inventory.availability.Systems" /></b>
					</td>
<%
			}
		}
		else
		{
%>
					<td height="20" class="<%=fontStyle%>">
						&nbsp;&nbsp;<b><egui:intnl text="configmgmt.inventory.availability.Availability/Unavailability of" />&nbsp;<%=softwareName%>&nbsp;<egui:intnl text="configmgmt.inventory.availability.service in" />&nbsp;<%=osName%>&nbsp;<egui:intnl text="configmgmt.inventory.availability.Systems" /></b>
					</td>
<%
		}
%>
				</tr>
			</table>
		</td>
	</tr>
	
	<tr>
		<td width="100%" align="center">
			<table width="99%" cellpadding="0" cellspacing="0" class="body_text" border="0" >
<%
		if(finalData!=null && finalData.size()>0)
		{
			if(softwareName!=null)
			{
				String barTitle=printData.getChartTitle();
				String sampleValues=printData.getSampleValue();
				String barLabels=printData.getBarLabel();
				String maxCount=printData.getMaxRange();
				String rangeAxisLabel=printData.getSampleAxisLabel();
				String barHeight = "260";

				if(!("All".equalsIgnoreCase(softwareName)))
				{
					barHeight = "200";
				}
%>
					<tr>
						<td height="0"><img src="/final/config/images/spacer.gif" border="0" height="10">
						</td>
					</tr>
					<tr align="center">
						<td width="100%" align="center">
							<img src="../servlet/com.eg.EcChartController?view=GRAPH&pageName=AVAILABILITY&chartType=bar&height=<%=EgURLEncoder.encode(barHeight,"UTF-8")%>&width=650&chartTitle=<%=EgURLEncoder.encode(barTitle,"UTF-8")%>&sampleValues=<%=EgURLEncoder.encode(sampleValues,"UTF-8")%>&barLabels=<%=EgURLEncoder.encode(EgUIUtils.encodeSecurityChar(barLabels),"UTF-8")%>&rangeAxisLabel=<%=EgURLEncoder.encode(rangeAxisLabel,"UTF-8")%>&range=<%=maxCount%>&userName=<%=EgURLEncoder.encode(ec_userName,"UTF-8")%>" border="0" hspace="0">
						</td>
					</tr>
<%
			}
%>
				<tr><td align="center"><table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text"><tr><td height="5"><img src="/final/config/images/spacer.gif" border="0" height="1"></td></tr></table></td></tr>
<%
			int selCount=0; 
			boolean skip=false;
			for(int n=0;n<softwareCount.size();n++)
			{
				Integer count=(Integer)softwareCount.get(n);
				ArrayList infoName=(ArrayList)countData.get(count);
				/*if(!("All".equalsIgnoreCase(softwareName)))
				{
					List alist=new ArrayList();
					alist.add("+"+softwareName);
					//if(!infoName.retainAll(alist))
						//continue;
				}*/
				Collections.sort(infoName);
				for(int n1=0;n1<infoName.size();n1++)
				{
					String info=(String)infoName.get(n1);
					String associatedNickName=(String)finalData.get(info);
					if(showCount!=null && !showCount.equalsIgnoreCase("All"))
					{
						int countInt=Integer.parseInt(showCount);
						if(countInt==selCount)
						{
							skip=true;
							break;
						}
						selCount++;
					}
%>
				<tr>
					<td align="center" width="80%" valign="middle">
						<table border="0" width="98%" cellspacing="0" id="bottomtable" cellpadding="0" class="body_text" style="border-bottom-width:0pt">
							<tr>
								<td id="linebottom" height="20" class="<%=fontStyle%>">&nbsp;&nbsp;<b><%=info.substring(1)%></b></td>
							</tr>
							<tr>
								<td align="center">
									<table border="0" cellspacing="0" cellpadding="0" class="body_text" width="100%">
<%
					ArrayList nickList=processData.getInfoNickNames(osName,associatedNickName,true);
					if(nickList!=null && nickList.size()>0)
					{
						String temp = "System";
						if(nickList.size() > 1) temp = "Systems";

%>
										<tr>
											<td align="left" width="50%" height="20" class="<%=fontStyle%>">&nbsp;&nbsp;<b><egui:intnl text="configmgmt.inventory.availability.Available in" />&nbsp;<%=nickList.size()%>&nbsp;<egui:intnl text='<%="configmgmt.inventory.availability."+temp%>' /></b></td>
											<!-- <td height="15"><img src="/final/config/images/cell_corner_green.gif"></td> -->
										</tr>
										<tr>
											<td id="linetopbottom" align="left" wrap height="20" class="<%=fontStyle%>">&nbsp;
<%
						for(int s=0;s<nickList.size();s++)
						{
							String systemName=(String)nickList.get(s);
							if(s!=nickList.size()-1)
								out.println(systemName+",");
							else
								out.println(systemName);
						}
%>
											</td>
										</tr>
<%
					}
				
					nickList=processData.getInfoNickNames(osName,associatedNickName,false);
					if(nickList!=null && nickList.size()>0)
					{
						String temp = "System";
						if(nickList.size() > 1) temp = "Systems";
%>
										<!-- <tr><td align="center"><table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text"><tr><td height="5"><img src="/final/config/images/spacer.gif" border="0" height="1"></td></tr></table></td></tr> -->
										
										<tr>
											<td align="left" width="50%" height="20" class="<%=fontStyle%>">&nbsp;&nbsp;<b><egui:intnl text="configmgmt.inventory.availability.Unavailable in" />&nbsp;<%=nickList.size()%>&nbsp;<egui:intnl text='<%="configmgmt.inventory.availability."+temp%>' /></b></td>
											<!-- <td height="15"><img src="/final/config/images/cell_corner_green.gif"></td> -->
										</tr>
										<tr>
											<td id="linetopbottom" align="left" wrap height="20" class="<%=fontStyle%>">&nbsp;
<%
						for(int s=0;s<nickList.size();s++)
						{
							String systemName=(String)nickList.get(s);
							if(s!=nickList.size()-1)
								out.println(systemName+",");
							else 
								out.println(systemName);
						}
%>
											</td>
										</tr>
<%
					}
%>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr><td align="center"><table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text"><tr><td height="10"><img src="/final/config/images/spacer.gif" border="0" height="1"></td></tr></table></td></tr>
<%
				}
				if(skip)
					break;
			}
		}
%>
			<!-- </table>
				</td>
				</tr> -->
			</table>
		</td>
	</tr>
<%
	}
	else if(printType!=null && printType.equalsIgnoreCase("DAYWISE_CHANGE_DISTRIBUTION_DATA"))
	{
		EcPrintData printData = null;
		if (requestFrom != null && requestFrom.equals("Schedule"))
		{
			printData = (EcPrintData)request.getAttribute("DAYWISE_CHANGE_DISTRIBUTION_DATA");
		}
		else
		{
			printData = (EcPrintData)session.getAttribute("DAYWISE_CHANGE_DISTRIBUTION_DATA");
		}
		String componentType = printData.getComponent();
		String startDate = printData.getStartDate();
		String endDate = printData.getEndDate();
		String sampleValues = printData.getSampleValue();
		String sampleAxisLabel = printData.getSampleAxisLabel();
		String barLabels = printData.getBarLabel();
		String titleName = printData.getChartTitle();
		String range = printData.getMaxRange();
		String barLabelAngle = printData.getBarLabelAngle();
		String selectedDuration = printData.getSelectedDuration();
		String chartColor = printData.getSampleColor();
%>
	<tr>
		<td height="10" class="cell_layout"><img src="/final/config/images/spacer.gif" border="0"></td>
	</tr>

	<tr>
		<td align="center">
			<table width="90%" border="0" cellpadding="2" cellspacing="0">
				<tr>
<%
		if (sampleValues != null && sampleValues.length() > 0)
		{
			if (!componentType.equalsIgnoreCase("All"))
			{
%>
					<td align="left" class="<%=fontStyle%>">&nbsp;<b><egui:intnl text="configmgmt.changes.detailed.Component Type"/>&nbsp;:&nbsp;<egui:intnl type="<%=componentType%>" /></b></td>
<%
			}
			else
			{
%>
					<td align="left" class="<%=fontStyle%>">&nbsp;<b><egui:intnl text="configmgmt.changes.detailed.All Components" /></b></td>
<%
			}

		/* Added by Prakash.K starts */
		timeZoneConverter = new EgTimeZoneConverter(startDate,user);
		startDate = (String)timeZoneConverter.getDateTime();
		timeZoneConverter = new EgTimeZoneConverter(endDate,user);
		endDate = (String)timeZoneConverter.getDateTime();
		/* Added by Prakash.K ends */

%>
					<td align="right" class="<%=fontStyle%>"><b><egui:intnl text="configmgmt.changes.summary.Between" />&nbsp;<%=startDate%>&nbsp;<egui:intnl text="configmgmt.changes.summary.and" />&nbsp;<%=endDate%></b>&nbsp;</td>
				</tr>
			</table>
		</td>
	</tr>

			<tr><td height="20" class="cell_layout"><img src="/final/config/images/spacer.gif" border="0"></td></tr>

			<tr>
				<td align="center">
					<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text" align="center">
						<tr>
							<td align="center"><img src="../servlet/com.eg.EcChartController?view=GRAPH&pageName=DAYWISE_DISTRIBUTION&chartColor=<%=chartColor%>&chartType=bar&height=435&width=780&chartTitle=<%=EgURLEncoder.encode(titleName,"UTF-8")%>&sampleValues=<%=EgURLEncoder.encode(sampleValues,"UTF-8")%>&barLabels=<%=EgURLEncoder.encode(barLabels,"UTF-8")%>&range=<%=range%>&barLabelAngle=<%=barLabelAngle%>&sampleAxisLabel=<%=EgURLEncoder.encode(EgUIUtils.encodeSecurityChar(sampleAxisLabel),"UTF-8")%>&selectedDuration=<%=EgURLEncoder.encode(selectedDuration,"UTF-8")%>&userName=<%=EgURLEncoder.encode(ec_userName,"UTF-8")%>" border="0" hspace="0"></td>
						</tr>
					</table>
				</td>
			</tr>
<%
		}
		else
		{
%>
			<tr>
				<td align="center">
					<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="50"></td></tr></table>
					</td>
			</tr>
			<tr>
				<td align="center">
					<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" valign="top">
						<tr>
							<td width="100%" height="100%">
								<table border="0" align="center" width="100%" class="body_text" cellspacing="0" cellpadding="0" height="100%">
									<tr>
										<td align="center" height="100%">
											<table border="0" align="center" width="100%" height="100%" cellspacing="0" cellpadding="0">
												<tr>
													<td align="center">
														<table border="0" align="center" width="100%" class="body_text" cellspacing="0" cellpadding="0">
															<tr>
																<td align="center"><img src="/final/config/images/unavailable-data.gif"></td>
															</tr>
															<tr>
																<td align="center" class="<%=fontStyle%>"><b><%=mappingInfo.getTextDescription("configmgmt.common.No data found")%></b></td>
															</tr>
														</table>
													</td>
												</tr>
											</table>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>

<%
		}
	}
%>
</table>

</form>
</body>
</html>

<%!
private ArrayList getSystemNickName(Hashtable name)
{
	ArrayList systemName=new ArrayList();
	Enumeration e=name.keys();
	while(e.hasMoreElements())
	{
		String nick=(String)e.nextElement();
		systemName.add(nick);
	}
	return systemName;
}

private ArrayList getNickName(Hashtable nickList,ArrayList selected,boolean flag)
{
	ArrayList sys_name=new ArrayList();
	Enumeration en=nickList.keys();
	while(en.hasMoreElements())
	{
		String nick=(String)en.nextElement();
		if(flag)
		{
			if(selected.contains(nick))
				sys_name.add(nick);
		}
		else
		{
			if(!selected.contains(nick))
				sys_name.add(nick);

		}
	}
	Collections.sort(sys_name);
	return sys_name;
}

private ArrayList getNickName(Hashtable allList, ArrayList selectedList)
{
	ArrayList systemName=new ArrayList();
	Enumeration en=allList.keys();
	while(en.hasMoreElements())
	{
		String nick=(String)en.nextElement();
		if(selectedList.contains(nick))
			systemName.add(nick);
	}
	Collections.sort(systemName);
	return systemName;
}
%>



