<!DOCTYPE html>

<%@ include file = "EcTracker.jsp"%>
<%@ page errorPage="EcProbs.jsp"%>

<%@ page import = "java.net.URLEncoder"%>
<%@ page import = "java.util.*"%>
<%@ page import = "java.text.*"%>

<%@ page import = "com.eg.*"%>

<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.egurkha.EgUserRole"%>
<%@ page import = "com.egurkha.ini.IniUI"%>

<%@ page import = "egurkha.config.*"%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<%!
	String dashboardIniFileName = EcSoftwareHotfixHandler.iniFileName; //"eg_cnfg_SftwrHotfixDashboard.ini";
	
	public static String prepareEnocodedQueryString(Map params)
	{
		if (params == null || params.size() == 0) return "";
		String queryStr = "";
		try
		{
			Iterator itr = params.keySet().iterator();
			while (itr.hasNext())
			{
				String key = (String)itr.next();
				if (key.trim().length() == 0) continue;
				Object value= params.get(key);

				if (value instanceof String[])
				{
					String val[] =(String[])value;
					for(int i=0;i<val.length;i++)
						//queryStr += key + "=" + EgURLEncoder.encode(val[i],"UTF-8") + "&";
						queryStr += key + "=" + val[i] + "&";
				}
				else
				{
					if (value == null) value = "";
					//queryStr += key + "=" + EgURLEncoder.encode((String)value,"UTF-8") + "&";
					queryStr += key + "=" + (String)value + "&";
				}
			}
			if (queryStr.length() > 0) queryStr = queryStr.substring(0,queryStr.length()-1);
		}
		catch(Exception e)
		{
			queryStr = "";
		}
		return queryStr;
	}
	
	private User getCurrentUser(HttpSession session)
	{
		UserRegistry registry = UserRegistry.getInstance();
		User user = registry.getUser(session.getId());
		return user;
	}
	
	private String getUserLanguage(User user)
	{
		IniUI iniUI = IniUI.getInstance();
		String userLanguage = iniUI.getDefaultLanguage();
		if (user != null)
		{
			userLanguage = user.getLanguage();
		}
		return userLanguage;
	}
	
	private String getCurrentDateFormat(User user)
	{
		String uiFile = "eg_ui.ini";
		String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
		IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
		
		String currentDateFormat = null;
		
		String mgrDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
		String userDateFormat = user.getUserDateFormat();
		
		if (userDateFormat != null && userDateFormat.equalsIgnoreCase("Default"))
		{
			userDateFormat = mgrDateFormat;
		}
		
		if (userDateFormat != null)
		{
			currentDateFormat = userDateFormat;
		}
		else
		{
			currentDateFormat = mgrDateFormat;
		}
		
		return currentDateFormat;
	}
	
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String queryString = prepareEnocodedQueryString(request.getParameterMap());

	User user = getCurrentUser(session);
	String userLanguage = getUserLanguage(user);
	String currentDateFormat = getCurrentDateFormat(user);
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	IniFile dashboardIni = new IniFile(EgConfigInfo.egMgrConfigDir +dashboardIniFileName);

	String reqFrom = request.getParameter("reqFrom");
	String viewBy = request.getParameter("viewBy");
	String softwareOrHotfix = request.getParameter("softwareOrHotfix");
	String timeline = request.getParameter("ec_timeline");
	String ec_userOption = request.getParameter("ec_userOption");
	String ec_criteria = request.getParameter("ec_criteria");
	
	String theCnfgrd = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.The configured"); 
	String name = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.name"); 
	String name_is_Nt_Cnfgrd = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.name is not configured");
	String please_Cnfgr_in= mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Please configure in eg_cnfg_SftwrHotfixDashboard ini file");
	String please_Cnfgr_properly= mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.Please configure properly in eg_cnfg_SftwrHotfixDashboard ini file");
	String name_is_Nt_Avlbl = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.dashboard.is not available");
	
	
	String formItemsValidatinErrorMsg= "";
	if (reqFrom == null)
	{
		reqFrom = "navLink";
		queryString += "&reqFrom="+reqFrom;
	}
	
	if (viewBy == null)
	{
		viewBy = dashboardIni.getValue("DEFAULT_VALUES", "ViewBy");  
		queryString += "&viewBy="+viewBy;
	}
	if (ec_criteria == null)
	{
		queryString += "&ec_criteria="+viewBy;
	}
	if(viewBy != null && !"Component".equalsIgnoreCase(viewBy) && "navLink".equalsIgnoreCase(reqFrom)  )
	{
		if("Zone".equalsIgnoreCase(viewBy))
		{
			String zoneName = dashboardIni.getValue("DEFAULT_VALUES", "ZoneName"); 
			if("".equals(zoneName))
			{
				formItemsValidatinErrorMsg = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.Zone")+" "+name_is_Nt_Cnfgrd+". "+please_Cnfgr_in;	
			}
			else if(zoneName != null )
			{
				formItemsValidatinErrorMsg = theCnfgrd+" "+ mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.Zone")+" "+name +" '"+zoneName+"' "+name_is_Nt_Avlbl+". "+please_Cnfgr_properly;
			}
			queryString += "&ec_userOption="+zoneName;
		}
		else if("Service".equalsIgnoreCase(viewBy))
		{
			String serviceName = dashboardIni.getValue("DEFAULT_VALUES", "ServiceName");  
			if("".equals(serviceName))
			{
				formItemsValidatinErrorMsg = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.Service")+" "+name_is_Nt_Cnfgrd+". "+please_Cnfgr_in;
			}
			else if(serviceName != null )
			{
				formItemsValidatinErrorMsg = theCnfgrd+" "+ mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.Service")+" "+name +" '"+serviceName+"' "+name_is_Nt_Avlbl+". "+please_Cnfgr_properly;
			}
			queryString += "&ec_userOption="+serviceName;
		}
		else if("Segment".equalsIgnoreCase(viewBy))
		{
			String segmentName = dashboardIni.getValue("DEFAULT_VALUES", "SegmentName");
			if("".equals(segmentName))
			{
				formItemsValidatinErrorMsg = mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.Segment")+" "+name_is_Nt_Cnfgrd+". "+please_Cnfgr_in;
			}
			else if(segmentName != null )
			{
				formItemsValidatinErrorMsg = theCnfgrd+" "+ mappingInfo.getTextDescription("configmgmt.SoftwareHotfix.Segment")+" "+name +" '"+segmentName+"' "+name_is_Nt_Avlbl+". "+please_Cnfgr_properly;
			}
			queryString += "&ec_userOption="+segmentName;
		}
	}
	
	if (softwareOrHotfix == null)
	{
		softwareOrHotfix = dashboardIni.getValue("DEFAULT_VALUES", "SoftwareHotfix");
		queryString += "&softwareOrHotfix="+softwareOrHotfix;
	}
	if (timeline == null)
	{
		timeline = dashboardIni.getValue("DEFAULT_VALUES", "TimeLine");
		queryString += "&ec_timeline="+timeline+"&ec_prevtimeline=";
	}
	
	String configServletURL = "../servlet/com.eg.EcConfigurationServletNew";
	String servletURL = configServletURL;
	
	if (queryString == null)
	{	
		queryString = "cmd=SoftwareHotfix&viewBy="+viewBy+"&softwareOrHotfix="+softwareOrHotfix+"&ec_timeline="+timeline+"&ec_prevtimeline=";
	}
%>
<html>
<head>
	<meta charset="utf-8">
	
	<egui:skin ui = "newConfigStyles"/>

	<script type="text/javascript" src="../extjs/ext-all.js"></script>
	<script src="/final/jquery/jquery.js"></script>
	<script src="/final/Highcharts/js/highstock.js"></script>
	
	<script language="Javascript1.2" src="/final/config/utilities/Common.js"></script>
	
	<script  src="/final/monitor/eg_scripts/EgCitrixDashboardHighChart.js"></script>
	<script language="JavaScript1.2" src="/final/scripts/eg_DateUtil.js"></script>
	<script language="Javascript1.2" src="/final/config/scripts/ec_validate.js"></script>
	<script language="Javascript1.2" src="/final/config/scripts/ec_date.js"></script>
	
	<script src="/final/scripts/utilities/EncodeDecodeParams.js"></script>  
	
	
	<script src="../config/InventorySoftwareHotfix/app/app.js"></script>
	
	<script language="JavaScript1.2">
		var publicJSON = "";
		var csrfToken = '<%=strCsrfToken%>';
		var strRequestFrom = '<%=reqFrom%>';
		
		var queryString = '<%=queryString%>';
		
		var mgrDateFormat = getExtjsDateFormat('<%=currentDateFormat%>');
		var currentDateFormat = getExtjsDateFormat('<%=currentDateFormat%>');
		var probsErrorMessage = '<egui:intnl text="config.error.Problem encountered while loading the user interface"/>';
		var errorTitle = '<egui:intnl text="config.user.Error"/>';
		var config = 
		{
			labels : 
			{
				viewBy : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.View By" />',
				zone : '<egui:intnl text="configmgmt.SoftwareHotfix.Zone" />',
				service : '<egui:intnl text="configmgmt.SoftwareHotfix.Service" />',
				segment : '<egui:intnl text="configmgmt.SoftwareHotfix.Segment" />',
				softwareHotfix : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Software/Hotfix" />',
				frm : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.From" />',
				to : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.To" />',
				hr : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Hr" />',
				mins : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Mins" />',
				timeline : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Timeline" />',
				fromDate : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.From Date" />',
				toDate : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.To Date" />',
				showAll : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Show all" />',
				filter : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Filter" />',
				clearFilterData : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Clear Filter Data" />',
				submit : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Submit" />',
				all : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.ALL" />',
				operatingSys : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Operating system" />',
				cmpntName : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Component name" />',
				cmpntType : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Component type" />',
				softwareName : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Software name" />',
				chooseOne : '<egui:intnl text="configmgmt.SoftwareHotfix.Choose one" />',
				notAvailable: '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Unknown" />',
			},
			title : 
			{
				pageTitle : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Configuration > Inventory > Software/Hotfix > Dashboard" />',
				recentlyInstldSoftwares: '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Most recent software installation details on" />',
				recentlyInstldHotfixes: '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Most recent hotfix installation details on" />',
				printPreview : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.SoftwareHotfix Print Info" />',
			},
			msg : 
			{
				noChartDataAvlbl : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.No chart data available!" />',
				noDataAvlbl : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.No data available!" />',
				loading : '<egui:intnl text="monitor.common.Loading..." />',
			},
			defaultValues : 
			{
				timeline : "<%=timeline %>",
				viewBy : "<%=viewBy %>",
				ec_userOption :  "<%=ec_userOption %>",
			},
			errors : 
			{
				ajaxFailed :'<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Ajax Failed" />',
				smtngWntWring :'<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.something went wrong" />',
				errorInUpdtingDtls :'<egui:intnl text="configmgmt.SoftwareHotfix.Error in updating details" />',
				noOfDaysAllwdInDtRng :'<egui:intnl text="configmgmt.SoftwareHotfix.The number of days allowed in the date range is" />',
				days :'<egui:intnl text="configmgmt.SoftwareHotfix.days" />',
				plsPrvdVldDtRng :'<egui:intnl text="configmgmt.SoftwareHotfix.Please provide valid date range" />',
				formItemsValidatinErrorMsg :  "<%=formItemsValidatinErrorMsg %>",
				pleaseSelect : '<egui:intnl text="configmgmt.SoftwareHotfix.dashboard.Please select a" />',
			},
			urls : 
			{	
				configServletURL : "<%=configServletURL%>",
			}
		};
	</script>

	<script language="javascript">
		Ext.onReady(function(){
			Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			
			Ext.Ajax.on('requestexception', function (conn, response, options) {
				var errorStr = response.responseText;
				if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
				{
					if (errorStr.indexOf("user-session-invalid") != -1)
					{
						callWindow(1);
					}
					else if (errorStr.indexOf("user-deleted") != -1)
					{
						callWindow(2);
					}
					else if (errorStr.indexOf("user-timedout") != -1)
					{
						callWindow(3);
					}
				}
				else
				{
					if (response.status == 302 || (response.timedout != undefined && response.timedout == true))
					{
						Ext.Msg.show({
							title : errorTitle,
							msg : requestTimeOut,
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
					else
					{
						Ext.Msg.show({
							title : errorTitle,
							msg : probsErrorMessage,
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
				}
			});
		});
	</script>
</head>

<body>
<div id="loadmask" class="x-mask-msg x-layer x-mask-msg-default" style="z-index: 19001;left:45%;top:35%;">
	<div class="x-mask-loading" style="position:relative">
		Loading...
	</div>
</div>

</body>
</html>