<%@ include file = "../../EcTrackerJson.jsp" %>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import="com.egurkha.User" %>
<%@ page import="com.egurkha.UserRegistry" %>
<%@ page import="java.util.*" %>
<%@ page import="egurkha.config.EcProcessData" %>
<%@ page import="egurkha.config.EcUtils" %>
<%@ page import="com.eg.EgConfigTestsInfo" %>
<%@ page import="java.net.URLEncoder"%>
<%@ page import="com.eg.EgURLEncoder"%>
<%@ page import="egurkha.config.EcPrintData" %>
<%@ page import = "com.egurkha.pdfmaker.*"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import="egurkha.config.EcFusionChartBean" %>
<%@ page import="com.eg.EgConfigConstants"%>
<%@ page import="egurkha.config.ConfigDbSetting" %>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "java.text.*"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "com.eg.EgGroupInfo"%>
<%@ page import = "com.eg.EgTopoInfo"%>
<%@ page import="com.eg.EgURLDecoder"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setContentType("application/json");
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%!
	String[] criterias = {"Zone","Service","Segment","Component"};
%>

<%
	String queryString = EcUtils.prepareQueryString(request.getParameterMap());
	JSONObject rootJson = new JSONObject();
	JSONObject chartData = new JSONObject();
	JSONObject jsonVersionObj = new JSONObject();
	rootJson.put("success","true");

	JSONArray versionAndSysArray = new JSONArray();
	JSONObject hiddenFields = new JSONObject();


	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();

	//user language
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);

	String userName = user.getLoginID();
	EgConfigTestsInfo configTestsInfo=new EgConfigTestsInfo("manager");
	EcUtils ecUtils = new EcUtils();
	EcProcessData processData=new EcProcessData();
	EcPrintData printData=new EcPrintData();

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	String userDateFormat = user.getUserDateFormat();
	if (userDateFormat != null && userDateFormat.equalsIgnoreCase("Default"))
	{
		userDateFormat = currentDateFormat;
	}

	// If user date format is set, assign it to current date format.
	if (userDateFormat != null)
	{
		currentDateFormat = userDateFormat;
	}

	SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" "+"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);

	/* Added by Prakash.K Starts */
	EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dateString,user);
	dateString = timeZoneConverter.getDateTime();

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");
	String ec_userOptionPrevious = request.getParameter("ec_userOptionPrevious");

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	processData.setUserObject(user);
	ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");
	processData.setAssociatedComponents(aListAssociatedComponents);
	Map hostAgentsMapping = (Map)session.getAttribute("hostAgentsMapping");
	processData.setHostAgentsMapping(hostAgentsMapping);

	Vector osList=new Vector();
	String showVersion=null;
	int maxCount = 0;
	Map osCount = new TreeMap();
	ArrayList os_Name=new ArrayList();
	ArrayList countVal=new ArrayList();
	Map withVersionData=new TreeMap();
	Map resultData=new TreeMap();

	Map dashboardSetting = (Hashtable)ConfigDbSetting.getDbSettingData(user.getLoginID(),EgConfigConstants.USER_COMMON_SETTING);
	String barColor = configTestsInfo.getServerDisplayValue("MISC_ARGS","PieChartColors");

	StringTokenizer barColorTkns = new StringTokenizer(barColor,",");
	int maxBarColorCnt = barColorTkns.countTokens();

	String configSkin = user.getConfigSkin();
	String searchValue = request.getParameter("searchValue");
	String osName = request.getParameter("osName");
	String selectedInformation[] = (String[]) request.getAttribute("Selected Informations");
	String searchValueArr[] = (String[]) request.getAttribute("searching");
	String scheduleRequest = (String) request.getAttribute("scheduleRequest");
	Map scheduleDetails = (Map) request.getAttribute("ScheduleDetails");
	if (selectedInformation != null)
	{
		osName = (String) selectedInformation[0];
	}
	if (searchValueArr != null)
	{
		searchValue = (String) searchValueArr[0];
	}
	String sort=configTestsInfo.getServerDisplayValue("SORT_BY_COUNT","InventoryByOperatingSystem");
	boolean sorting =sort.equalsIgnoreCase("true")?true:false;
	boolean goBack = false;
	boolean requestFromDashboard = false;
	String request_from = request.getParameter("request_from");
	String submitOrNot = (String) request.getAttribute("isSubmit");
	if (request_from != null && "OS".equalsIgnoreCase(request_from) || "OSVersion".equalsIgnoreCase(request_from))
	{
		requestFromDashboard = true; 
		goBack = true;
	}
	if ("ScheduleConfig".equalsIgnoreCase(scheduleRequest))
	{
		requestFromDashboard = false;
		goBack = false;
	}
	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		ec_criteria = (String)scheduleDetails.get("ec_criteria");
		ec_criteriaPrevious = (String)scheduleDetails.get("ec_criteriaPrevious");
	}

	boolean isDisplay = true;
	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		vecUserOptions = (Vector) scheduleDetails.get("vecUserOptions");
		osName = (String) scheduleDetails.get("osSelect");
		searchValue = (String) scheduleDetails.get("searching");
		submitOrNot = "false";
		ec_userOption = (String)scheduleDetails.get("ec_userOption");
		ec_userOptionPrevious = (String)scheduleDetails.get("ec_userOptionPrevious");
	}

	if (submitOrNot == null || "null".equals(submitOrNot))
	{
		submitOrNot = "true";
		isDisplay = true;
	}

	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		isDisplay = false;
	}

	String strRequestFrom = "IBOS";
	if (requestFromDashboard)
	{
		strRequestFrom = "HomePage";
	}

	rootJson.put("requestFrom",strRequestFrom);

	//Map osWithOutVersion=(TreeMap)processData.getOSDetails();		//Get with without os version name
	processData.setVersion(true);
	Map osWithVersion = (TreeMap)processData.getOSDetails("HomePage");			//Get with withos version name
	Vector tempOsNameList=processData.getAllOsName();

	if(osName!=null && osName.indexOf("#")>-1)
	{
		StringTokenizer st=new StringTokenizer(osName,"#");
		osName=st.nextToken();
		showVersion=st.nextToken();
	}
	if(tempOsNameList!=null && tempOsNameList.size()>0)
	{
		if(tempOsNameList.size()>1)
			osList.add("All");
		osList.addAll(tempOsNameList);
	}

	if (searchValue == null || searchValue.equals(""))
	{
		searchValue = "";
	}

	rootJson.put("searchValue",searchValue);

	Object[] displayData=null;
	if(osList!=null && osList.size()>0)
	{
		if(osName==null)
		{
			if(osList.size()>2)
				osName="All";
			else
				osName=(String)osList.get(0);
		}

		withVersionData = (TreeMap)processData.getOsWithVersion(osWithVersion,osName);
		resultData = withVersionData;
		if (searchValue != null && !searchValue.equals(""))
		{
			resultData = (TreeMap)processData.getSearchComponentName(withVersionData,searchValue);
		}

		Object[] osKey= resultData.keySet().toArray();
		for (int a=0; a<osKey.length; a++)
		{
			String sysName = (String)osKey[a];
			Hashtable VersionStatus = (Hashtable)resultData.get(sysName);
			int size=0;
			Enumeration verElement=VersionStatus.keys();
			while(verElement.hasMoreElements())
			{
				String version=(String)verElement.nextElement();
				Hashtable systemList=(Hashtable)VersionStatus.get(version);
				size=size+systemList.size();
			}
			os_Name.add(sysName);
			countVal.add(new Integer(size));
			osCount.put(sysName,new Integer(size));
			maxCount = Math.max(maxCount, size);
		}

		displayData = resultData.keySet().toArray();
		if (displayData.length > 0)
		{
			Arrays.sort(displayData);
		}
		if(sorting)
		{
			Object [] tmpArray = countVal.toArray();
			int [] valueArray = new int[tmpArray.length];
			for (int i=0; i<tmpArray.length; i++)
			{
				valueArray[i] = ((Integer)tmpArray[i]).intValue();
			}
			Arrays.sort(valueArray);
			for (int i=valueArray.length-1; i>=0; i--)
			{
				int thisIndex = countVal.indexOf(new Integer(valueArray[i]));
				tmpArray[i] = (String)os_Name.get(thisIndex);
				displayData[valueArray.length-1-i] = tmpArray[i];
				os_Name.remove(tmpArray[i]);
				countVal.remove(new Integer(valueArray[i]));
			}
		}
	}

	//session.setAttribute("OS_DATA",resultData);
	//session.setAttribute("NO_VERSION",osWithOutVersion);

	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");

	String strCategory = request.getParameter("category");
	String id = request.getParameter("id");


	StringBuffer printQS = new StringBuffer();
	printQS.append("printType=OS_INFORMATION");
	printQS.append("&printPageTitle=INVENTORY_REPORT_BY_OPERATING_SYSTEM");
	printQS.append("&Page=OS");
	printQS.append("&printData=yes");
	printQS.append("&userName="+EgURLEncoder.encode(userName,"UTF-8"));
	printQS.append("&user_language="+userLanguage);
	printQS.append("&ec_criteria="+ec_criteria);
	printQS.append("&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""));
	String s_qryString = "../servlet/com.eg.EcRepoLiteC?"+printQS.toString()+"&ec_forPDF=No";
	rootJson.put("printQueryStr",s_qryString);


	session.setAttribute("PDF_URL",mngrIProc+"/final/servlet/com.eg.EcRepoLiteC;jsessionid="+session.getId()+"?"+printQS.toString()+"&ec_forPDF=Yes");
	session.setAttribute("REPORT_NAME","InventoryReportByOS");
	session.setAttribute("REPORT_LAYOUT","Portrait");
	session.setAttribute("PAGE_WIDTH_PDF","1100");
	session.setAttribute("PAGE_WIDTH_MAIL_IMAGE","1300");
	session.setAttribute("PAGE_HEIGHT_MAIL_IMAGE","768");

	hiddenFields.put("ec_rtype","OSInventory");
	hiddenFields.put("ec_trgttype","Configuration_Report");
	hiddenFields.put("ec_criteriaPrevious",ec_criteria);
	hiddenFields.put("isSubmit","true");
	if (submitOrNot.equals("true"))
	{
		hiddenFields.put("submitClicked","true");
	}
	if (ec_userOption == null)
	{
		hiddenFields.put("ec_userOptionPrevious","null");
	}
	else
	{
		hiddenFields.put("ec_userOptionPrevious",ec_userOption);
	}

	JSONObject viewByObj = new JSONObject();
	JSONArray viewByArr = new JSONArray();
	
	JSONObject backOperation = new JSONObject();

	backOperation.put("ec_criteria",ec_criteria);
	backOperation.put("ec_userOption",((ec_userOption != null)?ec_userOption:""));


	if (goBack)
	{
		backOperation.put("home","yes");
	}
	else if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		backOperation.put("schedule","yes");
	}

	rootJson.put("backOperation",backOperation);
	
	if (!requestFromDashboard)
	{
		if (vecCriterias != null && !vecCriterias.isEmpty())
		{
			for(int i=0; i<vecCriterias.size(); i++)
			{
				String selected = "";
				String strCriteria = (String)vecCriterias.get(i);
				if(ec_criteria != null && strCriteria.equals(ec_criteria))
				{
					rootJson.put("selectedEcOpt",ec_criteria);
				}
				viewByObj.put("displayField",_mapping.getTextDescription("configmgmt.common."+strCriteria));
				viewByObj.put("valueField",strCriteria);
				viewByArr.add(viewByObj);
			}
		}
		else
		{
			rootJson.put("selectedEcOpt","-1");
			viewByObj.put("displayField",_mapping.getTextDescription("configmgmt.common.Not Applicable"));
			viewByObj.put("valueField","-1");
			viewByArr.add(viewByObj);
		}
		rootJson.put("viewByList",viewByArr);



		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
			if (ec_criteria.equalsIgnoreCase(criterias[0]))
			{
				rootJson.put("specViewByTitle",_mapping.getTextDescription("configmgmt.common."+criterias[0]));
			}
			else if (ec_criteria.equalsIgnoreCase(criterias[1]))
			{
				rootJson.put("specViewByTitle",_mapping.getTextDescription("configmgmt.common."+criterias[1]));
			}
			else
			{
				rootJson.put("specViewByTitle",_mapping.getTextDescription("configmgmt.common."+criterias[2]));
			}

			JSONObject specviewByObj = new JSONObject();
			JSONArray specviewByArr = new JSONArray();

			if (vecUserOptions != null && !vecUserOptions.isEmpty())
			{
				for(int i=0; i<vecUserOptions.size(); i++)
				{
					String selected = "";
					String strUserOption = (String)vecUserOptions.get(i);
					if(ec_userOption != null && strUserOption.equals(ec_userOption))
					{
						rootJson.put("selectedUserOption",ec_userOption);
					}
					specviewByObj.put("displayField",strUserOption);
					specviewByObj.put("valueField",strUserOption);
					specviewByArr.add(specviewByObj);
				}
			}
			else
			{
				rootJson.put("selectedUserOption","-1");
				specviewByObj.put("displayField",_mapping.getTextDescription("configmgmt.common.Not Applicable"));
				specviewByObj.put("valueField","-1");
				specviewByArr.add(specviewByObj);
			}
			rootJson.put("specViewByList",specviewByArr);
		}
		else
		{
		}

		JSONObject osObj = new JSONObject();
		JSONArray osArr = new JSONArray();
		if (osList != null && !osList.isEmpty())
		{
			for(int i=0; i<osList.size(); i++)
			{
				String selected = "";
				String strOS = (String)osList.get(i);
				if(osName != null && osName.equals(strOS))
				{
					rootJson.put("selectedOsName",osName);
				}
				if (strOS.equalsIgnoreCase("All"))
				{
					//rootJson.put("selectedOsName",osName);
					osObj.put("displayField",strOS);
					osObj.put("valueField",strOS);
					osArr.add(osObj);
				}
				else
				{
					osObj.put("displayField",strOS);
					osObj.put("valueField",strOS);
					osArr.add(osObj);
				}
			}
		}
		else
		{
			rootJson.put("selectedOsName","-1");
			osObj.put("displayField",_mapping.getTextDescription("configmgmt.inventory.view.Not Applicable"));
			osObj.put("valueField","-1");
			osArr.add(osObj);
		}
		rootJson.put("osList",osArr);
	}



	if (resultData!=null && resultData.size()>0 && submitOrNot.equals("true") && isDisplay)
	{
		rootJson.put("hasConfigDetails",true);
		//print data start here
		printData.setMapCountData(osCount);
		printData.setMapData(resultData);
		printData.setDisplayData(displayData);
		printData.setOsVersion(showVersion);
		printData.setOsName(osName);
		printData.setSearchValue(searchValue);
		//print data end here

		//pdf work
		ArrayList aListPdfData = new ArrayList();
		EgPdfData pdfData = new EgPdfData();
		EgTable egTable = new EgTable();
		EgReportAttributes reportAttributes = new EgReportAttributes();

		String pdfTitle = "";
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.INVENTORY REPORT BY OPERATING SYSTEM") + " IN" + " '" + ec_userOption + "' "  +  ec_criteria + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		else
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.INVENTORY REPORT BY OPERATING SYSTEM") + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		reportAttributes.setMainTitle(pdfTitle);

		if(osName != null && osName.equalsIgnoreCase("All"))
		{
			reportAttributes.setSubTitle(mappingInfo.getTextDescription("configmgmt.inventory.view.Distribution of systems across operating systems"));
		}
		else
		{
			reportAttributes.setSubTitle(osName + " " + mappingInfo.getTextDescription("configmgmt.inventory.view.Systems"));
		}

		reportAttributes.setReportName("InventoryByOS");
		reportAttributes.setModule("CONFIG");
		reportAttributes.setPortrait(true);
		pdfData.setAttributes(reportAttributes);
		hiddenFields.put("submitClicked","true");
		rootJson.put("hiddenFields",hiddenFields);

		if(!osName.equalsIgnoreCase("All"))
		{
			Integer osCout=(Integer)osCount.get(osName);
			//rootJson.put("osCout",osCout);
		}
		else
		{
			rootJson.put("containerTitle",mappingInfo.getTextDescription("configmgmt.inventory.view.Distribution of systems across operating systems").toUpperCase());
		}
		int i_max = 7;
		if(osName!=null && osName.equalsIgnoreCase("All"))  // Display Dashboard for all operating system
		{
			String countValue=null;		//os count
			String countName=null;		//os name
			String colorValue=null;		//os color
			int totalCount=0;
			ArrayList aListColors = new ArrayList();
			StringTokenizer stTokColors = new StringTokenizer(barColor,",");
			while (stTokColors.hasMoreTokens())
			{
				String chartColor = stTokColors.nextToken();
				aListColors.add(chartColor);
			}
			String strColors = " ";
			int colorIdx = 0;

			for(int n=0;n<displayData.length;n++)
			{
				String displayOsName="";
				int cout=0;
				String tempName=(String)displayData[n];
				Integer ct=(Integer)osCount.get(tempName);
				cout=ct.intValue();

				if (strCategory != null && strCategory.equalsIgnoreCase("Others"))
				{
					if (n < i_max) continue;
				}

				if(tempName.indexOf(',')>-1)
					displayOsName=tempName.replace(',',' ');
				else
					displayOsName=tempName;
		
				if(displayOsName.indexOf("Microsoft")>-1)
				{
					displayOsName=displayOsName.substring(displayOsName.indexOf(' ')+1);
				}

				String temp_getOsColor = configTestsInfo.getServerDisplayValue("DASHBOARD_OS_COLOR",tempName);
				if(countValue==null || countName==null)
				{
					countValue=""+cout;
					countName=displayOsName;
					if (temp_getOsColor == null || temp_getOsColor.length() == 0)
					{
						strColors = (String)aListColors.get(colorIdx);
						colorValue = strColors;
						colorIdx++;
						if (colorIdx >= aListColors.size())
						{
							colorIdx = 0;
						}
					}
					else
					{
						colorValue = temp_getOsColor;
					}
				}
				else
				{
					countValue=countValue+","+cout;
					countName=countName+","+displayOsName;
					if (temp_getOsColor == null || temp_getOsColor.length() == 0)
					{
						strColors = (String)aListColors.get(colorIdx);
						colorValue = colorValue + "," + strColors;
						colorIdx++;
						if (colorIdx >= aListColors.size())
						{
							colorIdx = 0;
						}
					}
					else
					{
						colorValue = colorValue + "," + temp_getOsColor;
					}
				}
				totalCount=totalCount+cout;
			}

			String titleName=mappingInfo.getTextDescription("configmgmt.inventory.view.Total systems")+" : "+totalCount;

			//ArrayList pieDataList = new ArrayList();//for legend
			//ArrayList piecolorList = new ArrayList(); //color list for legend
			//String legendLabel = "";
			//String legendColor = "";

			//StringTokenizer strColor =  new StringTokenizer(colorValue,",");
			//while (strColor.hasMoreTokens())
			//{
				//String temp_pieColor = strColor.nextToken();
				//piecolorList.add(temp_pieColor.substring(temp_pieColor.indexOf("#")+1,temp_pieColor.length()));
			//}

			//StringTokenizer strToken = new StringTokenizer(countName,",");
			//while (strToken.hasMoreTokens())
			//{
				//String strOs = strToken.nextToken();
				//pieDataList.add(strOs);
			//}

			chartData.put("chartTitle",titleName);

			//Fusion Pie Chart Data starts--Rekha
			HashMap mapChartAttributes = new HashMap();//map for chart attributes
			mapChartAttributes.put("bgcolor","FFFFFF");
			mapChartAttributes.put("enablesmartLabels","0");
			mapChartAttributes.put("showToolTip","0");
			mapChartAttributes.put("showPercentValues","0");
			mapChartAttributes.put("showBorder","0");

			HashMap mapChartData = new HashMap();//map for chart data
			String newCountName = "";
			String newCountValue = "";

			StringTokenizer cntNamesTkns = new StringTokenizer(countName,",");
			StringTokenizer cntValuesTkns = new StringTokenizer(countValue,",");
			int cntNameSize = cntNamesTkns.countTokens();

			if(cntNameSize > maxBarColorCnt)
			{
				for(int g = 0; g < maxBarColorCnt; g++)
				{
					String name = cntNamesTkns.nextToken();
					String value = cntValuesTkns.nextToken();
					if(g == maxBarColorCnt - 1)
					{
						newCountName += name;
						newCountValue += value;
					}
					else
					{
						newCountName += name + ",";
						newCountValue += value + ",";
					}
				}
				mapChartData.put("pieLabels",newCountName);
				mapChartData.put("pieValues",newCountValue);
				printData.setSampleLabel(newCountName);
				printData.setSampleValue(newCountValue);
			}
			else
			{
				mapChartData.put("pieLabels",countName);
				mapChartData.put("pieValues",countValue);
				printData.setSampleLabel(countName);
				printData.setSampleValue(countValue);
			}

			mapChartData.put("pieColors",barColor);

			HashMap mapProperties = new HashMap();//map for misc properties
			mapProperties.put("showLabels","false");
			mapProperties.put("showColors","true");
			mapProperties.put("enableLinks","false");


			EcFusionChartBean chartbean = new EcFusionChartBean();
			String xmlString = chartbean.getXMLDataForPieChart(mapChartAttributes,mapChartData,mapProperties);
			//Fusion Pie Chart Data - ends

			//print data start
			printData.setChartTitle(titleName);
			printData.setSampleColor(barColor);
			//print data end
			chartData.put("xmlString",xmlString);
			chartData.put("DataSet",chartbean.getPieDataSet());
			chartData.put("title",titleName);
			chartData.put("chartType","pie");
			chartData.put("LegendPosition","right");
			chartData.put("legend",true);
			//chartData.put("drilldown","sametab");
			rootJson.put("chartData",chartData);

			// pdf work
			EgTableAttributes egTableAttributes = new EgTableAttributes();
			egTableAttributes.setImageData(true);
			
			ArrayList aListData = new ArrayList();
			aListData.add(request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+"/final/servlet/com.eg.EcChartController?view=GRAPH&pageName=DASHBOARD_OS&chartType=PieChart&height=150&width=400&chartTitle="+EgURLEncoder.encode(titleName,"UTF-8")+"&sampleValues="+URLEncoder.encode(countValue)+"&sampleLabels="+URLEncoder.encode(countName)+"&sampleColors="+URLEncoder.encode(colorValue)+"&userName="+EgURLEncoder.encode(userName,"UTF-8"));
			
			ArrayList userColumnNames = new ArrayList();
			userColumnNames.add("Image");

			EgTableModel egTableModel = new EgTableModel(aListData,userColumnNames);
			egTable = new EgTable();
			egTable.setModel(egTableModel);
			egTable.setAttributes(egTableAttributes);
			
			aListPdfData.add(egTable);
		}

		session.setAttribute("print_os_information",printData);
		for(int n=0;n<displayData.length;n++)
		{
			if (strCategory != null && strCategory.equalsIgnoreCase("Others"))
			{
				if (n < i_max) continue;
			}

			String selectedOsName =(String)displayData[n];
			Hashtable versionDetails = (Hashtable)resultData.get(selectedOsName);
			Integer osCout=(Integer)osCount.get(selectedOsName);

			//pdf work
			ArrayList aListData = new ArrayList();
			ArrayList userColumnNames = new ArrayList();
			userColumnNames.add("Version");
			userColumnNames.add("System1");
			userColumnNames.add("System2");
			userColumnNames.add("System3");

			ArrayList aListColumnNames = new ArrayList();
			aListColumnNames.add("");
			aListColumnNames.add(mappingInfo.getTextDescription("configmgmt.inventory.view.Systems"));
			aListColumnNames.add("");
			aListColumnNames.add("");

			EgTableAttributes egTableAttributes = new EgTableAttributes();
			String tableTitle = selectedOsName+" ("+mappingInfo.getTextDescription("configmgmt.inventory.view.Count")+" : "+osCout+")";
			egTableAttributes.setTitle(tableTitle);

			jsonVersionObj.put("title",tableTitle);

			egTableAttributes.setColumnNames(aListColumnNames);
			egTableAttributes.setStartX(0);
			egTableAttributes.setDataGrouping(true);

			egTableAttributes.setDataGroupingField(0);

			// Sorting the Version Order
			Object[] displayVersion = versionDetails.keySet().toArray();
			if (displayVersion.length > 0)
			{
				Arrays.sort(displayVersion);
			}
			if(osName.equalsIgnoreCase("All"))
			{
			}
			else
			{
			}

			Iterator verIterate = versionDetails.keySet().iterator();
			while (verIterate.hasNext())
			{
				JSONArray systemsArray = new JSONArray();
				String versionName = (String)verIterate.next();

				if(showVersion != null)
				{
					if(!versionName.equalsIgnoreCase(showVersion))
						continue;
				}
				Hashtable nickName=(Hashtable)versionDetails.get(versionName);
				ArrayList component =getSystemNickName(nickName);
				Collections.sort(component);
				int count = component.size();
				int j=0;
				if (count <=3)
				{
					count = 3;
				}
				else if(count % 3 != 0)
				{
					count = count+3 -count % 3;
				}

				if (component!= null)
				{
					for (j=0; (j<component.size() || j < count); j++)
					{
						if (j%3 == 0)
						{
							//pdf work
							aListData.add(mappingInfo.getTextDescription("configmgmt.inventory.view.Version")+" : "+versionName);
						}
						if ( j <component.size())
						{
							String allSystems = "";
							String systemName=(String)component.get(j);
							aListData.add(systemName);

							systemsArray.add(systemName);

							for(int i = 0 ; i < systemsArray.size() ; i++)
							{
								if( i == systemsArray.size() - 1)
								{
									allSystems = allSystems + systemsArray.get(i);
								}
								else
								{
									allSystems = allSystems + systemsArray.get(i) + "|";
								}
							}
							String versionWithSys = versionName + "#$#" + allSystems;
							jsonVersionObj.put("SystemsWithVersion",versionWithSys);
						}
						else
						{
							aListData.add("");
						}
						if (j%3 == 2)
						{
						}
					}
				}
				versionAndSysArray.add(jsonVersionObj);
			}

			//pdf work
			EgTableModel egTableModel = new EgTableModel(aListData,userColumnNames);
			egTable = new EgTable();
			egTable.setModel(egTableModel);
			egTable.setAttributes(egTableAttributes);

			aListPdfData.add(egTable);
			if(n<displayData.length-1)
			{
			}
		}
		//pdf work
		pdfData.setData(aListPdfData);
		session.setAttribute("pdfData",pdfData);
	}
	else if (osName != null && !osName.equals("null") && !osName.equals("-1") && submitOrNot.equals("true") && isDisplay)
	{
		rootJson.put("hasConfigDetails",false);
		rootJson.put("errorText",mappingInfo.getTextDescription("configmgmt.inventory.view.No systems found for the selected OS"));
	}
	else
	{
		hiddenFields.put("submitClicked","false");
		rootJson.put("hiddenFields",hiddenFields);
	}
%>
<%!
	private ArrayList getSystemNickName(Hashtable name)
	{
		ArrayList systemName=new ArrayList();
		Enumeration e=name.keys();
		while(e.hasMoreElements())
		{
			String nick=(String)e.nextElement();
			systemName.add(nick);
		}
		return systemName;
	}
%>



<%
	if(queryString !=null)
	{
		session.setAttribute("configLastAccessedURL","/final/config/EcOsBoxInfoIndex.jsp?"+queryString);
	}
	else
	{
		session.setAttribute("configLastAccessedURL","/final/config/EcOsBoxInfoIndex.jsp?cmd=OSInventory");
	}

	rootJson.put("versionAndSysArray",versionAndSysArray);
	rootJson.put("hiddenFields",hiddenFields);

	out.println(rootJson.toString());
%>

