<%
/**
		File				:	ecComponentChangeSummary.jsp
		Purpose				:	Displays the changes in components
		Creation Date		:	17-01-2007
		Author				:	Krishnamurthi
		UI Design			:	Krishnamurthi
		UI Design Changes	:	Jaiwin
*/
%>

<%@ include file = "EcTracker.jsp" %>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import="com.eg.EgConfigTestsInfo"%>
<%@ page import="java.util.*"%>
<%@ page import="com.eg.EgDateInfo"%>
<%@ page import="egurkha.config.EcCurrentAlertBean"%>
<%@ page import="com.egurkha.User"%>
<%@ page import="com.egurkha.UserRegistry"%>
<%@ page import="com.eg.EgDateInfo"%>
<%@ page import="egurkha.config.EcUtils"%>
<%@ page import="com.egurkha.pdfmaker.*"%>
<%@ page import="egurkha.config.EcPrintData"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.egurkha.ini.IniUI"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
%>

<%
	// Bean Object
	EgConfigTestsInfo configTestsInfo = new EgConfigTestsInfo("manager");
	EgDateInfo egDt = new EgDateInfo();
	EcCurrentAlertBean currentBean = new EcCurrentAlertBean();
	EcUtils ecutils = new EcUtils();
	EcPrintData printData=new EcPrintData();

	// User Object
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();
	
	//user language
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);

	String configSkin = user.getConfigSkin();
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	//Ini File data
	String defaultHours = configTestsInfo.getRefreshValue("ComponentNameNChanges");
	String svalue = configTestsInfo.getServerDisplayValue("DASHBOARD_COUNT_SORT","ComponentNameNChanges");
	boolean sorting = svalue.equalsIgnoreCase("true")?true:false;

	// Variables
	Map finalResult = new TreeMap();
	ArrayList nameValue = new ArrayList();
	ArrayList countValue = new ArrayList();
	Map compNameWithTest = new TreeMap();
	long msecsPerHour = (long) 1000 * 60 * 60;
	int ss = 0;
	int timeCount = 0;
	String hours = "";
	String edate = "";
	String sdate = "";
	String startHour = "";
	String endHour = "";
	String startMinute = "";
	String endMinute = "";

	//Request Data
	String NHourSelect = request.getParameter("NHour");
	if(NHourSelect == null)
	{
		hours = "24";
		NHourSelect = hours;
	}
	else
		hours = "24";

	currentBean.setUserObject(user);
	currentBean.initialize(NHourSelect,"HOURS");
	finalResult = (TreeMap)currentBean.getFinalProcessData();

	// Date for UI purpose
	Date dt_temp = new Date(egDt.egetUTCDate());
	Calendar cal_temp = new GregorianCalendar();
	cal_temp.setTime(dt_temp);
	Date dt_temp1 = cal_temp.getTime();
	long l_temp = dt_temp1.getTime();
	edate = egDt.egetDate(l_temp);

	int num = Integer.parseInt(NHourSelect);
	int start_time = num;
	
	sdate = egDt.egetDate(l_temp -(long)(start_time* msecsPerHour));
	sdate = sdate.substring(0,sdate.lastIndexOf(":")+1) + "00";
	edate = edate.substring(0,edate.lastIndexOf(":")+1) + "00";

	String startDate = sdate.substring(0,sdate.indexOf(' '));
	startDate = startDate.substring(startDate.indexOf('/')+1,startDate.lastIndexOf('/'))+"/"+startDate.substring(0,startDate.indexOf('/'))+"/"+startDate.substring(startDate.lastIndexOf('/')+1);
	
	String endDate = edate.substring(0,edate.indexOf(' '));
	endDate = endDate.substring(endDate.indexOf('/')+1,endDate.lastIndexOf('/'))+"/"+endDate.substring(0,endDate.indexOf('/'))+"/"+endDate.substring(endDate.lastIndexOf('/')+1);

	if(timeCount==0)
	{
		timeCount++;
		String SHours = sdate.substring(sdate.indexOf(' ')+1);
		String EHours = edate.substring(edate.indexOf(' ')+1);
		StringTokenizer startTimeToken = new StringTokenizer(SHours,":");
		StringTokenizer endTimeToken = new StringTokenizer(EHours,":");

		startHour = startTimeToken.nextToken();
		startMinute = startTimeToken.nextToken();
		String startSeconds = startTimeToken.nextToken();
		endHour = endTimeToken.nextToken();
		endMinute = endTimeToken.nextToken();
		String endSeconds = endTimeToken.nextToken();
	}
	
	Hashtable storeData = new Hashtable();

	if (finalResult!=null && finalResult.size()>0)
	{
		session.setAttribute("COMPONENT_CHANGE_SUMMARY",finalResult);
		printData.setStartTime(startDate);
		printData.setEndTime(endDate);
		printData.setStartMinute(startMinute);
		printData.setEndMinute(endMinute);
		printData.setStartHour(startHour);
		printData.setEndHour(endHour);

		session.setAttribute("START_DATE",startDate + " " + startHour+":"+startMinute);
		session.setAttribute("END_DATE",endDate + " " + endHour+":"+endMinute);
		session.setAttribute("printData",printData);
	}

	boolean goBack = false;
	if (request.getParameter("request_from")!=null)
	{
		goBack = true;
	}

	//For Unicode support
	Vector vecTimelineText = new Vector();
	Vector vecTimelineValue = new Vector(); //in hours

	StringTokenizer strTokens = new StringTokenizer(defaultHours,",");
	while (strTokens.hasMoreTokens())
	{
		String hour = strTokens.nextToken().trim();
		int h = Integer.parseInt(hour);

		if (h >= 24) break;

		if (h == 1)
		{
			vecTimelineValue.add("1");
			vecTimelineText.add("1 hour");
		}
		else
		{
			vecTimelineValue.add(""+h);
			vecTimelineText.add(h+" hours");
		}
	}

	//Multiples of 24
	vecTimelineValue.add("24");
	vecTimelineText.add("1 day");
	vecTimelineValue.add("48");
	vecTimelineText.add("2 days");
	vecTimelineValue.add("72");
	vecTimelineText.add("3 days");
	vecTimelineValue.add("96");
	vecTimelineText.add("4 days");
	vecTimelineValue.add("120");
	vecTimelineText.add("5 days");
	vecTimelineValue.add("144");
	vecTimelineText.add("6 days");
	vecTimelineValue.add("168");
	vecTimelineText.add("1 week");
	vecTimelineValue.add("336");
	vecTimelineText.add("2 weeks");
	vecTimelineValue.add("504");
	vecTimelineText.add("3 weeks");
	vecTimelineValue.add("672");
	vecTimelineText.add("4 weeks");
	vecTimelineValue.add("720");
	vecTimelineText.add("1 month");
%>

<html>
<head>
<!-- <link rel="stylesheet" href="/final/config/styles/ec_style_green.css" /> -->
<egui:skin ui="config"/>
<script language="JavaScript1.2" src="../config/scripts/ec_validate.js"></script>
</head>
<script language="JavaScript1.2">

	n = (document.layers) ? 1:0
	ie = (document.all) ? 1:0
	var arr =new Array();

	function show(step)
	{
		var layername="layer"+step;
		if(n) document.layers[layername].visibility = "show";
		if(ie) document.all[layername].style.visibility = "visible";
		if(ie) document.all[layername].style.display= "block";
	}

	function hide(step)
	{
		var layername="layer"+step;
		if(n) document.layers[layername].visibility = "hide";
		if(ie) document.all[layername].style.visibility = "hidden";
	}

	function showNameWiseData()
	{
		var thisForm = document.forms[0];
		var HourChange= thisForm.Hour.options[thisForm.Hour.options.selectedIndex].value;
		if(HourChange!=-1)
		{
			window.location.href="/final/config/ecComponentChangeSummary.jsp?NHour="+HourChange;
		}
		else
		{
			alert('<egui:intnl text="configmgmt.changes.summary.Please choose a timeline"/>');
			return;
		}

		thisForm.submt.value = '<egui:intnl text="configmgmt.common.Loading" />'+'...';
		thisForm.submt.disabled = true;
	}

	function printData()
	{
<%
	if (finalResult == null || finalResult.size() == 0)
	{
%>
		alert('<egui:intnl text="configmgmt.common.No data available" />');
		return;
<%
	}

	StringBuffer printQS = new StringBuffer();
	printQS.append("&ec_type=ComponentChangeSummary");
	printQS.append("&ec_trgttype=Report");
	printQS.append("&printData=yes");
%>
		var s_qryString = "../servlet/com.eg.EcRepoLiteC?<%=printQS.toString()%>";
		printwin = parent.openWindow(s_qryString,"PrintWindow","width=792,height=464,left=0,top=85,scrollbars=1,scrollbars=yes,resizable");
	}

	function savePdf()
	{
<%
	if (finalResult == null || finalResult.size() == 0)
	{
%>
		alert('<egui:intnl text="configmgmt.common.No data available" />');
		return;
<%
	}
%>
		getPdf('<%=configSkin%>');
	}

	function mail()
	{
<%
	if (finalResult == null || finalResult.size()==0)
	{
%>
		alert('<egui:intnl text="configmgmt.common.No data available" />');
		return;
<%
	}
%>
		sendMail();
	}

</script>
<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" >
<form name="componentchanges" style="margin:0px">
<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center" height="100%">
	<tr>
		<td align="right" valign="middle" id="layer_headbg" height="18" width="100%" style="padding:0px;border-left-width:0px;border-right-width:0px">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="padding5">
				<tr>
					<td align="left" id="main_head_top" width="95%" nowrap>
						&nbsp;<b><egui:intnl text="configmgmt.changes.detailed.CONFIGURATION CHANGES" /> : <egui:intnl text="configmgmt.changes.summary.SUMMARY BY COMPONENT NAME" /></b>
					</td>
<%
	if (goBack)
	{
%>
					<td  class="body_text" align="right" width="5%">
						<a id='mousehand' onClick="javascript:history.back();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;
						</a>
					</td>
<%
	}
%>
				</tr>
			</table>
		</td>
	</tr>

	<tr>
		<td valign="top" id="bgmedium" width="100%" height="100%">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">
				<tr>
					<td id="padding6">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="toptable">
							<tr>
								<td>
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table-layout:fixed" id="text_bold"><col width="300"><col width="100"><col width="10"><col width="100"><col width="300">
										<tr>
											<td colspan="5" height="5" id="blank">&nbsp;</td>
										</tr>

										<tr height="20">
											<td  align="center">&nbsp;</td>
											<td align="right"><egui:intnl text="configmgmt.changes.detailed.Timeline" /></td>
											<td align="center">:</td>
											<td>
												<select name="Hour">
<%//=ecutils.fillSelectBox(NHourSelect,"ChangeSummary#"+defaultHours)%>
<%
	for (int u=0;u<vecTimelineValue.size();u++)
	{
		String strTimelineText = (String)vecTimelineText.get(u);
		String strTimelineValue = (String)vecTimelineValue.get(u);

		String selected = "";
		if (strTimelineValue.equals(NHourSelect))
			selected = "selected";

		String strValue = strTimelineText.substring(0,strTimelineText.indexOf(" "));
		String strText = strTimelineText.substring(strTimelineText.indexOf(" ")+1);
%>
													<option value="<%=strTimelineValue%>" <%=selected%> >
														<%=strValue%> <egui:intnl text='<%="configmgmt.common."+strText%>' />
													</option>
<%
	}
%>
												</select>
											</td>
											<td align="center">&nbsp;</td>
										</tr>
										<tr>
											<td colspan="5" height="10" id="blank">&nbsp;</td>
										</tr>
										<tr>
											<td align="center">&nbsp;</td>
											<td align="center" colspan="3" valign="middle" height="20"><input type="button" value='<egui:intnl text="configmgmt.common.SUBMIT" />' name="submt" id="darkbutton" style="width: 75px; height: 20px;" onClick="javascript:showNameWiseData()">
											</td>
											<td align="right" colspan="1" rowspan="2" style="height:24" valign="bottom">
												<table align="right" cellspacing="0" cellpadding="0" border="0" height="20"> 
													<tr>
														<td width="50" align="center" id="leftcurve" > <img src="/final/config/images/spacer.gif" width="50px" height="20px"> </td>

														<td width="2" align="center" id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="2" > </td>

														<td align="center" id="leftcurvebg" > <img class="mouse" src="../config/images/print.gif" border="0" title='<egui:intnl text="configmgmt.common.PRINT" />' onClick="javascript:printData()"> </td>

														<td width="13" align="center" id="leftcurvebg"> <img src="/final/config/images/spacer.gif" width="13" > </td>

														<td width="13" align="center" id="leftcurvebg" > <img class="mouse" src= "../config/images/pdf.gif" border="0" title='<egui:intnl text="configmgmt.common.PDF" />' onClick="javascript:savePdf();"> </td>

														<td width="13" align="center" id="leftcurvebg"> <img src="/final/config/images/spacer.gif" width="13"> </td>

														<td width="13" align="center" id="leftcurvebg" > <img class="mouse" src="../config/images/mail.gif" border="0" title='<egui:intnl text="configmgmt.common.MAIL" />' onClick="javascript:mail()"> </td>

														<td width="13" align="center" id="leftcurvebg"> <img src="/final/config/images/spacer.gif" width="13"> </td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td colspan="4" height="5" id="blank">&nbsp;</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>

				<tr>
					<td id="padding6" height="100%" width="100%" valign="top" style="padding-top:0px">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" id="bottomtable">
<%
	if (finalResult!=null && finalResult.size()>0)
	{
		Map type = new TreeMap();
		Hashtable componentDisplayTestName=new Hashtable();
		Iterator ie2 = finalResult.keySet().iterator();
		int totalChanges = 0;
		while (ie2.hasNext())
		{
			try
			{
				int count = 0;
				String serverName = (String)ie2.next();
				Map gloServerName = (TreeMap)finalResult.get(serverName);
				Iterator ie3 = gloServerName.keySet().iterator();
				String serverTypes = serverName.substring(serverName.lastIndexOf(':')+1);
				String compName = serverName.substring(0,serverName.lastIndexOf(':'));
				ArrayList meas = new ArrayList();
				ArrayList measureTestName=new ArrayList();
				while (ie3.hasNext())
				{
					String test_name = (String)ie3.next();
					ArrayList c_value = (ArrayList)gloServerName.get(test_name);
					//String displayName = configTestsInfo.getDisplayNameForTest(test_name);
					meas.add(test_name);
					measureTestName.add(test_name);
					TreeMap tmapTemp = new TreeMap();
					for (int d=0;d<c_value.size();d++)
					{
						String strValue = (String)c_value.get(d);
						String strInfo = strValue.substring(0,strValue.indexOf("@"));
						String strData = strValue.substring(strValue.indexOf("@")+1);
						ArrayList aListTemp = (ArrayList)tmapTemp.get(strInfo);
						if (aListTemp == null)
						{
							aListTemp = new ArrayList();
							aListTemp.add(strData);
							tmapTemp.put(strInfo,aListTemp);
						}
						else
						{
							aListTemp.add(strData);
						}
					}
					Iterator infoAsKeys = tmapTemp.keySet().iterator();
					while (infoAsKeys.hasNext())
					{
						String keyInfo = (String)infoAsKeys.next();
						ArrayList infoValues = (ArrayList)tmapTemp.get(keyInfo);
						for (int d=0;d<infoValues.size();d++)
						{
							String strValue = (String)infoValues.get(d);
							if (strValue.indexOf("##NEW##") != -1)
							{
								count++;
								break;
							}
							count++;
						}
					}
				}

				compNameWithTest.put(compName,meas);
				componentDisplayTestName.put(compName,measureTestName);
				totalChanges = totalChanges+count;
			
				Map type_name = (TreeMap)type.get(serverTypes);
				if (type_name == null)
				{
					type_name = new TreeMap();
					type_name.put(compName,new Integer(count));
					type.put(serverTypes,(TreeMap)type_name);
				}
				else
				{
					type_name.put(compName,new Integer(count));
					type.put(serverTypes,(TreeMap)type_name);
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}

		// Iterator type Wise
		Iterator itrat = type.keySet().iterator();
		while(itrat.hasNext())
		{
			String sTypes = (String)itrat.next();
			Map hTypes = (TreeMap)type.get(sTypes);
			Iterator itr = hTypes.keySet().iterator();
			int comCount = 0;
			while(itr.hasNext())
			{
				String cName = (String)itr.next();
				int cout = ((Integer)hTypes.get(cName)).intValue();
				storeData.put(cName+":"+sTypes,new Integer(cout));
				nameValue.add(cName+":"+sTypes);
				countValue.add(new Integer(cout));
			}
		}

		Object[] keySet2 = storeData.keySet().toArray();
		if (keySet2.length > 0)
		{
			Arrays.sort(keySet2);
		}

		if(sorting)
		{
			Object [] tmpArray = countValue.toArray();
			int [] valueArray = new int[tmpArray.length];
			for (int i=0; i<tmpArray.length; i++)
			{
				valueArray[i] = ((Integer)tmpArray[i]).intValue();
			}
			Arrays.sort(valueArray);
			for (int i=valueArray.length-1; i>=0; i--)
			{
				int thisIndex = countValue.indexOf(new Integer(valueArray[i]));
				tmpArray[i] = (String)nameValue.get(thisIndex);
				keySet2[valueArray.length-1-i] = tmpArray[i];
				nameValue.remove(tmpArray[i]);
				countValue.remove(new Integer(valueArray[i]));
			}
		}

		//For New Pdf Framework - Krishnamurthi
		ArrayList aListPdfData = new ArrayList();
		EgPdfData pdfData = new EgPdfData();
		
		EgReportAttributes reportAttributes = new EgReportAttributes();

		String mainTitle = mappingInfo.getTextDescription("configmgmt.changes.detailed.CONFIGURATION CHANGES");
		mainTitle = mainTitle + "\n" + mappingInfo.getTextDescription("configmgmt.changes.summary.SUMMARY BY COMPONENT NAME");
		reportAttributes.setMainTitle(mainTitle);

		String tempStartDate = DateUtil.changeDateFormat(startDate,"MM/dd/yyyy",currentDateFormat);
		String tempEndDate = DateUtil.changeDateFormat(endDate,"MM/dd/yyyy",currentDateFormat);

		String subTitle = mappingInfo.getTextDescription("configmgmt.changes.summary.Between") + " " + tempStartDate + " " + startHour + ":" + startMinute + " " + mappingInfo.getTextDescription("configmgmt.common.and") + " " + tempEndDate + " " + endHour + ":" + endMinute;
		reportAttributes.setSubTitle(subTitle);

		reportAttributes.setReportName("ComponentChangeSummary");
		reportAttributes.setModule("CONFIG");
		reportAttributes.setPortrait(true);
		
		pdfData.setAttributes(reportAttributes);

		EgTableAttributes egTableAttributes = new EgTableAttributes();
		egTableAttributes.setTitle(mappingInfo.getTextDescription("configmgmt.changes.detailed.Total Changes") + " : " + totalChanges);

		ArrayList aListColumnNames = new ArrayList();
		ArrayList aListData = new ArrayList();
		ArrayList userColumnNames = new ArrayList();

		aListColumnNames.add("C0");
		aListColumnNames.add("C1");
		aListColumnNames.add("C2");
		aListColumnNames.add("C3");

		userColumnNames.add("C0");
		userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.summary.Changes in"));
		userColumnNames.add("");
		userColumnNames.add("");
%>
							<tr>
								<td align="center" valign="top">
									<table width="100%" class="body_text" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td height="20" class="tdbackcolortop" id="white_content" align="center">
												&nbsp;<b><egui:intnl text="configmgmt.changes.detailed.Total Changes" />&nbsp;:&nbsp;<%=totalChanges%></b>
											</td>
										</tr>
									</table>
								</td>
							</tr>

							<tr>
								<td  height="3" id="blank">&nbsp;</td>
							</tr>

							<tr>
								<td align="center" valign="top" height="100%">
								<!-- <div id="div_scroll" style="width:100%;height:452px;border:0px solid #CBD8CC;"> -->
									<table width="99%" class="body_text" cellspacing="0" cellpadding="0" border="0" align="center" id="bottomtable" >
										<tr>
											<td nowrap height="20" width="18%" id="bgdarkimg">
												<b><egui:intnl text="configmgmt.changes.detailed.Component Name" /></b>
											</td>
											<td width="7%" height="20" id="bgdarkimg" align="center">
												<b><egui:intnl text="configmgmt.changes.summary.Changes" /></b>
											</td>
											<td nowrap width="75%" height="20" id="bgdarkimg" align="center">
												<b><egui:intnl text="configmgmt.changes.summary.Changes in" /></b>
											</td>
										</tr>

<%
		for (int n=0;n<keySet2.length;n++)
		{
			String selectedServerName = (String)keySet2[n];
			String displayName = selectedServerName.substring(0,selectedServerName.lastIndexOf(':'));
			String secondDisplayName = "";
			if (displayName.endsWith("NULL"))
				secondDisplayName = displayName.substring(0,displayName.lastIndexOf(':'));
			else 
				secondDisplayName = displayName;

			ArrayList measurementName = (ArrayList)compNameWithTest.get(displayName);
			ArrayList measureTestName=(ArrayList)componentDisplayTestName.get(displayName);
			/*
			String mName = "";
			for(int s=0;s<measurementName.size();s++)
			{
				if(s==0)
					mName = (String)measurementName.get(s);
				else
					mName = mName+", "+(String)measurementName.get(s);
			}
			*/
			Collections.sort(measurementName);
			int count = measurementName.size();
			int j=0;
			if (count <=3)
			{
				count = 3;
			}
			else if(count % 3 != 0)
			{
				count = count + 3-count % 3;
			}
			
			if(startHour.indexOf('0')>-1 && !startHour.equals("0") && !startHour.equals("10") && !startHour.equals("20"))
				startHour = startHour.substring(startHour.indexOf('0')+1);

			if(endHour.indexOf('0')>-1 && !endHour.equals("0") && !endHour.equals("10") && !endHour.equals("20"))
				endHour = endHour.substring(endHour.indexOf('0')+1);
%>
										<tr>
											<td nowrap width="18%" id="cell_bg1" valign="top" style="padding-top:0px" height="20">
												&nbsp;<a href="/final/servlet/com.eg.EcConfigurationServlet?request_from=HomePage&ec_rtype=Change&ec_option1=Component Name&ec_timeline=Any&ec_prevtimeline=Any&ec_sthr=<%=startHour%>&ec_endhr=<%=endHour%>&ec_stdate=<%=tempStartDate%>&ec_enddate=<%=tempEndDate%>&ec_option2=<%=selectedServerName%>&ec_option1=Component Name&ec_startmin=<%=startMinute%>&ec_endmin=<%=endMinute%>&ec_changetype=Latest&NHour=<%=hours%>&dashboardComponentType=<%=selectedServerName%>&ec_viewchange=byInformation" class="eg_monlink"><%=secondDisplayName%></a>
											</td>
											<td width="7%" align="center" class="cell_border" valign="top" height="20">
												<%=storeData.get(selectedServerName)%>
											</td>
											<td wrap width="75%" align="left" style="padding-left:0px" height="20">
												<table cellspacing="0" cellpadding="0" border="0" class="body_text" width="100%">
<%
			if (measurementName!= null)
			{
				for (j=0; (j<measurementName.size() || j < count); j++)
				{
					if (j%3 == 0)
					{
						aListData.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Component Name") + " : " + secondDisplayName + "  (" + mappingInfo.getTextDescription("configmgmt.changes.summary.Changes") + " : " + storeData.get(selectedServerName) + ")");
%>
													<tr>
<%
					}

					if ( j <measurementName.size())
					{
						String testmeasure=(String)measurementName.get(j);
						aListData.add(mappingInfo.getTestDescription(testmeasure));
%>
														<td width="30%" id="cell_bg1" valign="top" style="padding-top:0px" height="20"><a href="/final/servlet/com.eg.EcConfigurationServlet?request_from=HomePage&ec_rtype=Change&ec_option1=Component Name&ec_timeline=Any&ec_prevtimeline=Any&ec_sthr=<%=startHour%>&ec_endhr=<%=endHour%>&ec_stdate=<%=tempStartDate%>&ec_enddate=<%=tempEndDate%>&ec_option2=<%=selectedServerName%>&ec_option1=Component Name&ec_startmin=<%=startMinute%>&ec_endmin=<%=endMinute%>&ec_changetype=Latest&NHour=<%=hours%>&dashboardComponentType=<%=selectedServerName%>&ec_test=<%=(String)measureTestName.get(j)%>&ec_viewchange=byInformation" class="eg_monlink"><egui:intnl test="<%=testmeasure%>" /></a> </td>
<%
					}
					else
					{
						aListData.add(" ");
%>
														<td width="30%" id="cell_bg1" style="padding-top:0px"" height="20" valign="top">&nbsp;</td>
<%
					}

					if (j%3 == 2)
					{
%>
													</tr>
<%
					}
				}
			}
%>
												</table>
											</td>
										</tr>
<%
		}

		//For new Pdf Framework
		EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);

		egTableAttributes.setColumnNames(userColumnNames);
		egTableAttributes.setDataGrouping(true);
		egTableAttributes.setDataGroupingField(0);

		EgTable egTable = new EgTable();
		egTable.setModel(egTableModel);
		egTable.setAttributes(egTableAttributes);

		aListPdfData.add(egTable);

		pdfData.setData(aListPdfData);
		session.setAttribute("pdfData",pdfData);
%>
									</table>
									<!-- </div> -->
								</td>
							</tr>
							<tr>
								<td height="5" id="blank">&nbsp;</td>
							</tr>
<%
	}
	else
	{
%>
							<tr>
								<td align="center">
									<table border="0" align="center" width="100%" height="100%">
										<tr>
											<td align="center">
												<table border="0" align="center" width="100%" class="body_text">
													<tr>
														<td align="center"> <img src="/final/config/images/unavailable-data.gif" title='<egui:intnl text="configmgmt.common.No Data" />'> </td>
													</tr>
													<tr>
														<td align="center"><b><egui:intnl text="configmgmt.changes.detailed.There were no configuration changes in the selected timeline" /></b></td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
	}
%>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>

</form>
</div>
</body>
</html>



