<%
/*
	File				:	ecHotfixAvailability.jsp
	Purpose				:	Display the hotfix available & unavailable systems for selected operating system
	Creation Date		:	01-08-2006
	Author				:	Balasigamani
	UI Design			:	Krishnamurthi
	UI Design Changes	:	Jaiwin
*/
%>

<%@ include file = "EcTracker.jsp" %>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import="java.util.*"%>
<%@ page import ="egurkha.config.EcProcessData"%>
<%@ page import ="egurkha.config.EcUtils"%>
<%@ page import = "java.net.URLEncoder" %>
<%@ page import = "egurkha.config.EcProcessResult" %>
<%@ page import = "egurkha.config.EcPrintData" %>
<%@ page import = "com.egurkha.pdfmaker.*"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.egurkha.User" %>
<%@ page import = "com.egurkha.UserRegistry" %>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "egurkha.config.EcFusionChartBean" %>
<%@ page import = "egurkha.config.ConfigDbSetting" %>
<%@ page import = "com.eg.EgConfigConstants"%>
<%@ page import = "com.eg.EgConfigTestsInfo"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "java.text.*"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.eg.EgInstallInfo" %>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	String[] arrTopN = {"5","10","20","25","30","40","50","75","100"};
	String[] criterias = {"Zone","Service","Segment","Component"};
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	String userName = (String)session.getAttribute("sess_auserid");

	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();

	//user language
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);

	EcProcessResult processResult=(EcProcessResult)request.getAttribute("Result");
	EcProcessData processData=(EcProcessData)request.getAttribute("dataResult");
	EcUtils ecUtils = new EcUtils();
	EcPrintData printData=new EcPrintData();

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" "+"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);

	/* Added by Prakash.K Starts */
	EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dateString,user);
	dateString = timeZoneConverter.getDateTime();
	/* Added by Prakash.K Ends */

	EgConfigTestsInfo configTestsInfo = new EgConfigTestsInfo("manager");
	Map dashboardSetting = (Hashtable)ConfigDbSetting.getDbSettingData(user.getLoginID(),EgConfigConstants.USER_COMMON_SETTING);
	String barColor = configTestsInfo.getServerDisplayValue("MISC_ARGS","ChartColor");
	String chartDataRepresentation = configTestsInfo.getServerDisplayValue("MISC_ARGS","ChartDataRepresentation");

	String configSkin = user.getConfigSkin();
	String viewCount=request.getParameter("viewCount");
	String softwareName=request.getParameter("softwareName");
	String osOnly=request.getParameter("osOnly");
	String strBackRequest = request.getParameter("back_request");
	String request_from = request.getParameter("request_from");
	String submitOrNot = (String) request.getAttribute("isSubmit");
	if (strBackRequest != null && strBackRequest.equalsIgnoreCase("ScheduleConfig"))
	{
		String[] softwareNameArr = (String[]) request.getAttribute("hotFix");
		softwareName = softwareNameArr[0];
		String[] osOnlyArr = (String[]) request.getAttribute("operatingSystem");
		osOnly = osOnlyArr[0];
		String[] viewCountArr = (String[]) request.getAttribute("count");
		if (viewCountArr != null)
		{
			viewCount = viewCountArr[0];
		}
		else
		{
			viewCount = "All";
		}
		String[] statusCountArr = (String[]) request.getAttribute("statusChoice");
		String statusCount = statusCountArr[0];
	}
	Map finalData=new TreeMap();
	Map countData=new TreeMap();
	ArrayList softwareCount=new ArrayList();

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
	String ec_userOptionPrevious = request.getParameter("ec_userOptionPrevious");

	Vector osList=processResult.getOsList();
	if(osList!=null && osList.size()>0)
	{
		//osList.remove("Linux");
		osList.remove("Unknown");
	}

	String testName=processResult.getTestName();
	String osName=processResult.getOsName();
	int barCount=processResult.getBarCount();

	Map scheduleDetails = (Map)request.getAttribute("ScheduleDetails");
	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		vecUserOptions = (Vector) scheduleDetails.get("vecUserOptions");
		softwareName = (String)scheduleDetails.get("softwareName");
		osOnly = (String)scheduleDetails.get("osName");
		viewCount = (String)scheduleDetails.get("countChoice");
		if (viewCount == null)
		{
			viewCount = "All";
		}
		ec_userOption = (String)scheduleDetails.get("ec_userOption");
		ec_userOptionPrevious = (String)scheduleDetails.get("ec_userOptionPrevious");
	}

	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		ec_criteria = (String)scheduleDetails.get("ec_criteria");
		ec_criteriaPrevious = (String)scheduleDetails.get("ec_criteriaPrevious");
	}

	if(testName!=null && osName!=null)
	{
		finalData=(TreeMap)processResult.getStatusData();
		countData=(TreeMap)processResult.getStatusCount();
		Iterator citerate=countData.keySet().iterator();
		while(citerate.hasNext())
		{
			Integer count=(Integer)citerate.next();
			softwareCount.add(count);
		}
	}
	Vector softwareNameList=processResult.getInfoNameList();

	boolean goBack = false;
	boolean requestFromHotfix = false;
	String scheduleBack = (String) request.getAttribute("schedule");
	if (request_from != null && !request_from.equalsIgnoreCase("HomePage") && !"null".equalsIgnoreCase(request_from))
	{
		goBack = true;
		requestFromHotfix = true;
	}
	if ((scheduleBack != null && scheduleBack.equalsIgnoreCase("scheduleBack")) || (request_from != null && request_from.equalsIgnoreCase("HotfixAvailability")))
	{
		requestFromHotfix = false;
	}
	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		goBack = false;
		requestFromHotfix = false;
		submitOrNot = "false";
	}
	if (submitOrNot == null || "null".equals(submitOrNot))
	{
		submitOrNot = "true";
	}

	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");

	String id = request.getParameter("id");
%>

<html>
<head>
<!-- <link rel="stylesheet" href="/final/config/styles/ec_style_green.css" /> -->
<egui:skin ui="config"/>
<script language="JavaScript1.2" type="text/javascript" src="/final/FusionCharts/scripts/FusionCharts.js"></script>
<script language="JavaScript1.2" src="../config/scripts/ec_validate.js"></script>
<script language="JavaScript1.2" src="/../final/scripts/screen_display.js"></script>
</head>

<script language="JavaScript1.2">

	function showStatusDetails()
	{
		var thisForm = document.statusInfo;
		var testName = thisForm.statusChoice.value;
		var osname = thisForm.osName.value;
		var countValue=thisForm.countChoice.value;
		var softwareName=thisForm.softwareName.value;

		var tempCriteria = "";
		var tempUserOption = "";
		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}

		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
					return false;
				}
				else if (tempCriteria == "Service")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
					return false;
				}
			}
		}

		if(osname== -1)
		{
			alert('<egui:intnl text="configmgmt.inventory.availability.Please select an operating system" />');
			return;
		}
		else if(softwareName==-1)
		{
			alert('<egui:intnl text="configmgmt.inventory.availability.Please select a hotfix/patch name" />');
			return;
		}
		else
		{
			var tempCriteriaPrevious = "";
			var tempUserOptionPrevious = "";
			if (thisForm.ec_criteriaPrevious != null && thisForm.ec_criteriaPrevious != undefined)
			{
				tempCriteriaPrevious = thisForm.ec_criteriaPrevious.value;
			}
			if (thisForm.ec_userOptionPrevious != null && thisForm.ec_userOptionPrevious != undefined)
			{
				tempUserOptionPrevious = thisForm.ec_userOptionPrevious.value;
			}

			softwareName=encodeURIComponent(softwareName);	window.location.href="../servlet/com.eg.EcConfigurationServlet?cmd=Availability&view=Hotfix&osName="+osname+"&testName="+testName+"&viewCount="+countValue+"&softwareName="+softwareName+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious);
			document.statusInfo.secsubmt.value='<egui:intnl text="configmgmt.common.Loading" />'+'...';
			document.statusInfo.secsubmt.disabled=true;
		}
	}

	function validateforSchedule()
	{
		var thisForm = document.statusInfo;
		var testName = thisForm.statusChoice.value;
		var osname = thisForm.osName.value;
		var countValue=thisForm.countChoice.value;
		var softwareName=thisForm.softwareName.value;

		var tempCriteria = "";
		var tempUserOption = "";
		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}

		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
					return false;
				}
				else if (tempCriteria == "Service")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
					return false;
				}
			}
		}

		if(osname== -1)
		{
			alert('<egui:intnl text="configmgmt.inventory.availability.Please select an operating system" />');
			return false;
		}
		else if(softwareName==-1)
		{
			alert('<egui:intnl text="configmgmt.inventory.availability.Please select a hotfix/patch name" />');
			return false;
		}
	}
	
	function getHotfixName()
	{
		var thisForm = document.statusInfo;
		var testName = thisForm.statusChoice.value;
		var osname = thisForm.osName.value;
		if(osname== -1)
		{
			alert('<egui:intnl text="configmgmt.inventory.availability.Please select an operating system" />');
			return;
		}
		else
		{
			var tempCriteria = "";
			var tempUserOption = "";
			var tempCriteriaPrevious = "";
			var tempUserOptionPrevious = "";
			if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
			{
				tempCriteria = thisForm.ec_criteria.value;
			}
			if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
			{
				tempUserOption = thisForm.ec_userOption.value;
			}
			if (thisForm.ec_criteriaPrevious != null && thisForm.ec_criteriaPrevious != undefined)
			{
				tempCriteriaPrevious = thisForm.ec_criteriaPrevious.value;
			}
			if (thisForm.ec_userOptionPrevious != null && thisForm.ec_userOptionPrevious != undefined)
			{
				tempUserOptionPrevious = thisForm.ec_userOptionPrevious.value;
			}

			window.location.href="../servlet/com.eg.EcConfigurationServlet?cmd=Availability&osOnly=Yes&view=Hotfix&osName="+osname+"&testName="+testName+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious)+"&request_from=<%=request_from%>&id=<%=id%>";
		}
	}

	function showOrder()
	{
		var thisForm = document.statusInfo;
		var softwareName = "";
		if (thisForm.softwareName != null && thisForm.softwareName != undefined)
		{
			softwareName=thisForm.softwareName.value;
		}
		if(softwareName != null && !softwareName == "")
		{
			if (softwareName=="All")
			{
				document.getElementById("order").disabled=false;
			}
			else
			{
				document.getElementById("order").disabled=true;
			}
		}
	}

	function printData()
	{
<%
		if(finalData == null || finalData.size()==0 || (osOnly != null && osOnly.equalsIgnoreCase("Yes")))
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}

		StringBuffer printQS = new StringBuffer();
		printQS.append("printType=HOTFIX_AVAILABILITY");
		printQS.append("&printPageTitle=INVENTORY_REPORT_BY_HOTFIX_AVAILABILITY/UNAVAILABILITY");
		printQS.append("&Page=OS");
		printQS.append("&printData=yes");
		printQS.append("&userName="+EgURLEncoder.encode(userName,"UTF-8"));
		printQS.append("&user_language="+userLanguage);
		printQS.append("&ec_criteria="+ec_criteria);
		printQS.append("&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""));
%>
		var s_qryString = "../servlet/com.eg.EcRepoLiteC?<%=printQS.toString()%>&ec_forPDF=No";
		print(s_qryString);
	}

	function savePdf()
	{
<%
		if(finalData == null || finalData.size()==0 || (osOnly != null && osOnly.equalsIgnoreCase("Yes")))
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
		session.setAttribute("PDF_URL",mngrIProc+"/final/servlet/com.eg.EcRepoLiteC;jsessionid="+session.getId()+"?"+printQS.toString()+"&ec_forPDF=Yes");
		session.setAttribute("REPORT_NAME","InventoryReportByHotfix");
		session.setAttribute("REPORT_LAYOUT","Portrait");
		session.setAttribute("PAGE_WIDTH_PDF","1100");
		session.setAttribute("PAGE_WIDTH_MAIL_IMAGE","1300");
		session.setAttribute("PAGE_HEIGHT_MAIL_IMAGE","768");
%>
		getPdf('<%=configSkin%>');
	}

	function mail()
	{
<%
		if (finalData == null || finalData.size() == 0 || (osOnly != null && osOnly.equalsIgnoreCase("Yes")))
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
%>
		sendMail();
	}

	function getInformations()
	{
		var thisForm = document.statusInfo;
		var tempCriteria = "";
		var tempUserOption = "";
		var tempCriteriaPrevious = "";
		var tempUserOptionPrevious = "";
		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}
		if (thisForm.ec_criteriaPrevious != null && thisForm.ec_criteriaPrevious != undefined)
		{
			tempCriteriaPrevious = thisForm.ec_criteriaPrevious.value;
		}
		if (thisForm.ec_userOptionPrevious != null && thisForm.ec_userOptionPrevious != undefined)
		{
			tempUserOptionPrevious = thisForm.ec_userOptionPrevious.value;
		}

		window.location.href = "../servlet/com.eg.EcConfigurationServlet?cmd=Availability&osOnly=Yes&view=Hotfix&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious)+"&request_from=<%=request_from%>&id=<%=id%>";
	}

	function csv()
	{
<%
		if (finalData == null || finalData.size() == 0 || (osOnly != null && osOnly.equalsIgnoreCase("Yes")))
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
%>
		thisForm = document.forms[0];
		thisForm.action = '../servlet/com.eg.EcCSVController?ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
		thisForm.submit();
	}

	function schedule(op)
	{
		var checkFlag = validateforSchedule();
		if(checkFlag == false) return;
		var thisForm = document.statusInfo;
		if (op == "schedule")
		{
<%
			if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
			{
%>
				thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>";
<%
			}
			else
			{
%>
				thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>&request_from=HotfixAvailability";
<%
			}
%>
		}
		else if (op =="favorite")
			thisForm.action = "/final/config/EcSaveFavorite.jsp";
		else
		{
			alert('<egui:intnl text="configmgmt.common.Illegal Access" />');
			return;
		}
		thisForm.submit();
	}

	function goBackToSaveSchedule()
	{
		var thisForm = document.forms[0];
		thisForm.action = "/final/config/EcSaveSchedule.jsp?request_from=<%=request_from%>&id=<%=id%>";
		thisForm.submit();
	}


</script>

<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" style="overflow:auto" onLoad="bigScreen();">
<form name="statusInfo" method="POST" style="margin:0px">
<input type="hidden" name="ec_rtype" value="HotfixAvailability">
<input type="hidden" name="ec_trgttype" value="Configuration_Report">
<input type="hidden" name="isSubmit" value="true">
<input type="hidden" name="statusChoice" value="<%=testName%>">
<input type="hidden" name="ec_criteriaPrevious" value="<%=ec_criteria%>">
<input type="hidden" name="ec_userOptionPrevious" value="<%=ec_userOption%>">

<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center" height="100%">
	<tr>
		<td align="right" valign="middle" id="layer_headbg" height="18" width="100%" style="padding:0px;border-left-width:0px;border-right-width:0px">
			<div style="border:0px blue solid;height:24px">
				<div style="border:0px solid;float:left;padding:5px" class="main_head_top">
					&nbsp;<b><egui:intnl text="configmgmt.inventory.availability.INVENTORY" /> : <egui:intnl text="configmgmt.inventory.availability.HOTFIX/PATCH AVAILABILITY/UNAVAILABILITY" /></b>
				</div>
				<div style="border:0px solid red;float:right">
<%
	if(requestFromHotfix)
	{
%>
					<div style="border:0px solid red;height:22px;float:right;position:relative;margin-top:2px">
						<table cellspacing="0" cellpadding="0" border="0" height="20">
							<tr>
								<td width="50" align="center" id="leftcurve" > <img src="/final/config/images/spacer.gif" width="50px" height="20px"> </td>

								<td width="2" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="2" > </td>

								<td align="center"  id="leftcurvebg" > <img class="mouse" src="../config/images/print.gif" border="0" title='<egui:intnl text="configmgmt.common.PRINT" />' onClick="printData()">  </td>

								<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif" width="13" > </td>

								<td width="13" align="center"  id="leftcurvebg" > <img class="mouse" src= "../config/images/pdf.gif" border="0" title='<egui:intnl text="configmgmt.common.PDF" />' onClick="javascript:savePdf();"> </td>

								<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="13"> </td>

								<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src="../config/images/mail.gif" border="0" title='<egui:intnl text="configmgmt.common.MAIL" />' onClick="javascript:mail()"></td>

								<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="13"> </td>

								<td width="13" align="center" id="leftcurvebg"><img class="mouse" src="../config/images/csv.gif" border="0" title='<egui:intnl text="configmgmt.common.CSV" />' onClick="javascript:csv()"> </td>

								<td width="13" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"></td>
							</tr>
						</table>
					</div>
<%
	}
%>
					<div style="border:0px solid;float:right;padding:5px">
<%
	if (goBack)
	{
%>
						<a id='mousehand' onClick="javascript:history.back();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>
						</a>
<%
	}
	else if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
%>
						<a id='mousehand' onClick="goBackToSaveSchedule();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;&nbsp;
						</a>
<%
	}
%>
					</div>
				</div>
			</div>
		</td>
	</tr>

<%
	if(requestFromHotfix)
	{
%>
	<tr>
		<td valign="top" id="bgmedium" width="100%" height="5px" class="eg_blankspace">&nbsp;</td>
	</tr>
<%
	}
%>

	<tr>
		<td valign="top" id="bgmedium" width="100%" height="100%">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">
				<!-- new tab start here -->
<%
	if (!requestFromHotfix)
	{
%>
				<tr>
					<td id="padding6" style="padding-bottom:0px">
						<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0" id="toptable" style="table-layout:fixed">
							<col width="55"><col width="10"><col width="170">
							<col width="150"><col width="10"><col width="350">
							<tr>
								<td align="right" nowrap><b><egui:intnl text="configmgmt.common.View By" /></b></td>
								<td align="center"><b>:</b></td>
								<td valign="middle">
									<select name="ec_criteria" style="width:170px;" onChange='javascript:getInformations()'>
<%
		if (vecCriterias != null && !vecCriterias.isEmpty())
		{
			for(int i=0; i<vecCriterias.size(); i++)
			{
				String selected = "";
				String strCriteria = (String)vecCriterias.get(i);
				if(ec_criteria != null && strCriteria.equals(ec_criteria))
				{
					selected = "selected";
				}
%>
				<option value="<%=strCriteria%>" <%=selected%>>
					<egui:intnl text='<%="configmgmt.common."+strCriteria%>' />
				</option>
<%
			}
		}
		else
		{
%>
		<option value="-1">
			<egui:intnl text="configmgmt.common.Not Applicable" />
		</option>
<%
		}
%>
									</select>
								</td>
<%
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
%>
								<td align="right" nowrap>
<%
			if (ec_criteria.equalsIgnoreCase(criterias[0]))
			{
%>
				<b><egui:intnl text='<%="configmgmt.common."+criterias[0]%>' /></b>
<%
			}
			else if (ec_criteria.equalsIgnoreCase(criterias[1]))
			{
%>
				<b><egui:intnl text='<%="configmgmt.common."+criterias[1]%>' /></b>
<%
			}
			else
			{
%>
				<b><egui:intnl text='<%="configmgmt.common."+criterias[2]%>' /></b>
<%
			}
%>
								</td>
								<td align="center"><b>:</b></td>
								<td>
									<select name="ec_userOption" style="width: 250px;" onChange='javascript:getInformations()'>
<%
			if (vecUserOptions != null && !vecUserOptions.isEmpty())
			{
				for(int i=0; i<vecUserOptions.size(); i++)
				{
					String selected = "";
					String strUserOption = (String)vecUserOptions.get(i);
					if(ec_userOption != null && strUserOption.equals(ec_userOption))
					{
						selected = "selected";
					}
%>
					<option value="<%=strUserOption%>" <%=selected%>>
						<%=strUserOption%>
					</option>
<%
				}
			}
			else
			{
%>
				<option value="-1">
					<egui:intnl text="configmgmt.common.Not Applicable" />
				</option>
<%
			}
%>
									</select>
								</td>
<%
		}
		else
		{
%>
								<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
<%
		}
%>
							</tr>
						</table>
					</td>
				</tr>
				<!-- new tab end here -->

				<tr>
					<td id="padding6">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="toptable" >
							<tr>
								<td>
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0"  style="table-layout:fixed" id="text_bold"> <col width="160"><col width="140"><col width="10"><col width="400"><col width="100"><col width="10"><col width="50"><col width="20">
										<tr>
											<td colspan="8" height="5" id="blank">&nbsp;
											</td>
										</tr>
										<tr height="20"> 
											<td  align="center">&nbsp;</td>
											<td align="right" nowrap><egui:intnl text="configmgmt.inventory.availability.Operating System"/></td>
											<td  align="center">:</td>
											<td  align="left" nowrap> <select  name="osName" style="width:350px" onChange="javascript:getHotfixName();">
											<%=ecUtils.fillSelectBox(osList,"config","",osName)%> </select> 
											</td>
											<td colspan="4" height="5" id="blank">&nbsp;</td>
										</tr>
										<tr>
											<td colspan="8" height="5" id="blank">&nbsp;</td>
										</tr>
										<tr>
											<td  align="center">&nbsp;</td>
											<td align="right" nowrap><egui:intnl text="configmgmt.inventory.availability.Hotfix/Patch Name"/> </td>
											<td  align="center">:</td>
											<td  align="left" nowrap>
												<select name="softwareName" style="width:350px" onChange="javascript:showOrder();">
<%
		if (softwareNameList != null && !softwareNameList.isEmpty())
		{
			for(int i=0; i<softwareNameList.size(); i++)
			{
				String selected = "";
				String strSoftwareName = (String)softwareNameList.get(i);
				if(softwareName != null && softwareName.equals(strSoftwareName))
				{
					selected = "selected";
				}
%>
													<option value="<%=strSoftwareName%>" <%=selected%>>
<%
				if (strSoftwareName.equalsIgnoreCase("All"))
				{
%>
														<egui:intnl text="configmgmt.inventory.availability.All" />
<%
				}
				else
				{
					out.println(strSoftwareName);
				}
%>
													</option>
<%
			}
		}
		else
		{
%>
													<option value="-1">
														<egui:intnl text="configmgmt.inventory.availability.Not Applicable" />
													</option>
<%
		}
%>
												</select>
												</td>
											<td colspan="4" >&nbsp;</td>
										</tr>
										<tr>
											<td colspan="8" height="5" id="blank">&nbsp;
											</td>
										</tr>
										<tr>
											<td  align="center">&nbsp;</td>
											<td align="right" nowrap><egui:intnl text="configmgmt.inventory.availability.Show" /></td>
											<td align="center">:</td>
											<td align="left" nowrap><select color="#F3FEE9" name="countChoice" style="width:100px" id="order">
												<option value="All">
													<egui:intnl text="configmgmt.inventory.availability.All" />
												</option>
<%
		for (int i=0;i<arrTopN.length;i++)
		{
			String strTopN = arrTopN[i];

			String selected = "";
			if (strTopN.equals(viewCount))
				selected = "selected";
%>
			<option value="<%=strTopN%>" <%=selected%>>
				<egui:intnl text="configmgmt.inventory.availability.Top" /> - <%=strTopN%>
			</option>
<%
		}
%>
											</select></td>
											<td  colspan="4" align="center">&nbsp;</td>
										</tr>
										<tr>
											<td colspan="8" height="10" id="blank">&nbsp;</td>
										</tr>
										<tr>
											<td  align="center">&nbsp;</td>
											<td align="center" colspan="3" valign="middle" height="20"> 
<%
		if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
		{
%>
											<input type="button" name="btnsubmit" value='<egui:intnl text="configmgmt.common.SAVE" />' id="darkbutton" style="width: 75px; height: 20px;" href="" onClick="schedule('schedule');">
<%
		}
		else
		{
%>
											<input type="button" name="secsubmt" value='<egui:intnl text="configmgmt.common.SUBMIT" />' id="darkbutton" style="width: 75px; height: 20px;" onClick="javascript:showStatusDetails()">
<%
		}
%>
											</td>
											<td align="right"  colspan="4" rowspan="2" style="height:24" valign="bottom">
												<table align="right" cellspacing="0" cellpadding="0" border="0" height="20"> 
													<tr>
														<td width="50" align="center" id="leftcurve" ><img src="/final/config/images/spacer.gif" width="50px" height="20px"> </td>

														<td width="2" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="2" > </td>

														<td align="center"  id="leftcurvebg" > <img class="mouse" src="../config/images/print.gif" border="0" title='<egui:intnl text="configmgmt.common.PRINT" />' onClick="javascript:printData()">  </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif" width="13" > </td>

														<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src= "../config/images/pdf.gif" border="0" title='<egui:intnl text="configmgmt.common.PDF" />' onClick="javascript:savePdf();"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"> </td>

														<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src="../config/images/mail.gif" border="0" title='<egui:intnl text="configmgmt.common.MAIL" />' onClick="javascript:mail()"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"> </td>

														<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src="../config/images/csv.gif" border="0" title='<egui:intnl text="configmgmt.common.CSV" />' onClick="javascript:csv()"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"> </td>

														<td align="center" id="leftcurvebg"><img class="mouse" src="../config/images/schedules.gif" border="0" title='<egui:intnl text="configmgmt.common.ADD TO SCHEDULES" />' onClick="javascript:schedule('schedule')"> </td>

														<td width="13" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"></td>

													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td colspan="4" height="5" id="blank">&nbsp;</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%
	}
%>
				<tr>
					<td  id="padding6" height="100%" width="100%" style="padding-top:0px">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" id="bottomtable">
<%
	if(osName!=null && osName.length()>0 && osOnly==null && !osName.equals("null") && submitOrNot.equals("true"))
	{
%>
							<tr>
								<td width="100%" align="center">
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text">
										<tr>
											<td height="20" id="bgdark" class="whitefont" >
												&nbsp;<b><egui:intnl text="configmgmt.inventory.availability.Hotfix/Patch availability/unavailability in" />&nbsp;<%=osName%>&nbsp;<egui:intnl text="configmgmt.inventory.availability.Systems" /></b>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
	}
%>
							<tr>
								<td align="center" width="100%" height="100%" valign="top" class="bgwhite">
								<!-- <div id="div_scroll" style="width:100%;height:405px;border:0px solid #000000"> -->
									<table width="100%" border="0" cellspacing="0" cellpadding="0" height="100%">
<%
	if(finalData!=null && finalData.size()>0 && submitOrNot.equals("true"))
	{
		//pdf work
		ArrayList aListPdfData = new ArrayList();
		EgPdfData pdfData = new EgPdfData();
		EgTable egTable = new EgTable();
		EgReportAttributes reportAttributes = new EgReportAttributes();

		String pdfTitle = "";
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.availability.INVENTORY REPORT BY  ") + " " + mappingInfo.getTextDescription("configmgmt.inventory.availability. HOTFIX/PATCH AVAILABILITY/UNAVAILABILITY") + " IN" + " '" + ec_userOption + "' "  +  ec_criteria + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		else
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.availability.INVENTORY REPORT BY ") + " " + mappingInfo.getTextDescription("configmgmt.inventory.availability. HOTFIX/PATCH AVAILABILITY/UNAVAILABILITY") + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		reportAttributes.setMainTitle(pdfTitle);

		String reportSubTitle = "";
		if (softwareName != null)
		{
			if (softwareName.equalsIgnoreCase("All"))
			{
				reportSubTitle = mappingInfo.getTextDescription("configmgmt.inventory.availability.HOTFIX/PATCH  AVAILABILITY/UNAVAILABILITY") + " IN " + osName +" " + mappingInfo.getTextDescription("configmgmt.inventory.availability.SYSTEMS");
			}
			else
			{
				reportSubTitle = mappingInfo.getTextDescription("configmgmt.inventory.availability.AVAILABILITY/UNAVAILABILITY OF ") + " " + softwareName+" HOTFIX/PATCH IN " + osName + mappingInfo.getTextDescription("configmgmt.inventory.availability. SYSTEMS");
			}
		}

		reportAttributes.setSubTitle(reportSubTitle);
		reportAttributes.setReportName("HotfixAvailability");
		reportAttributes.setModule("CONFIG");
		reportAttributes.setPortrait(true);
		pdfData.setAttributes(reportAttributes);

		if(softwareName!=null)
		{
			String barLabels="";
			String sampleValues="";
			String barColors = "";
			String rangeAxisLabel="No of systems";
			rangeAxisLabel = mappingInfo.getTextDescription("configmgmt.inventory.availability."+rangeAxisLabel);

			int countVal=0;
			int maxCount=0;
			boolean flag=false;
			String barHeight = "260";
			String yAxisMaxValue = " ";
			String barTitle = "";
			ArrayList aListCount = new ArrayList();
			int indexCount = 0;
			barTitle=mappingInfo.getTextDescription("configmgmt.inventory.availability.Top")+" - "+barCount+" "+mappingInfo.getTextDescription("configmgmt.inventory.availability.Hotfix/Patch Availability in") +" "+ osName;

			for(int n=0;n<softwareCount.size();n++)
			{
				Integer count=(Integer)softwareCount.get(n);
				if (!aListCount.contains(count))
				{
					aListCount.add(count);
				}

				List infoName=(ArrayList)countData.get(count);
				//new code
				if(!("All".equalsIgnoreCase(softwareName)))
				{
					List alist=new ArrayList();
					alist.add("+"+softwareName);
					if(infoName!=null && infoName.size()==1)
					{
						String tempSoftware=(String)infoName.get(0);
						if(!tempSoftware.equals("+"+softwareName))
							continue;
					}
					else if(!infoName.retainAll(alist))
						continue;

					barHeight = "200";
				}
				//end !!!!

				Collections.sort(infoName,String.CASE_INSENSITIVE_ORDER);
				int size=count.intValue();
				//maxCount=Math.max(maxCount,size);

				for(int n1=0;((infoName!=null && infoName.size()>0) && n1<infoName.size());n1++)
				{
					String info=(String)infoName.get(n1);

					//code change for maxCount
					if(n1 == 0)
					{
						if(!("All".equalsIgnoreCase(softwareName)))
						{
							barTitle = mappingInfo.getTextDescription("configmgmt.inventory.availability.Hotfix/Patch Availability in") +" "+ osName;
						}
						String associatedNickName=(String)finalData.get(info);
						int availCount = 0;
						int unAvailCount = 0;
						ArrayList nickList1=processData.getInfoNickNames(osName,associatedNickName,true);
						ArrayList nickList2=processData.getInfoNickNames(osName,associatedNickName,false);

						if(nickList1 != null) availCount = nickList1.size();
						if(nickList2 != null) unAvailCount = nickList2.size();
						maxCount = availCount + unAvailCount;
					}
					//End

					if(countVal==0)
					{
						barLabels=info.substring(1);
						sampleValues=""+count.toString();
						barColors = barColor;
					}
					else
					{
						barLabels=barLabels+","+info.substring(1);
						sampleValues=sampleValues+","+count.toString();
						barColors = barColors +"," + barColor;
					}
					countVal++;
					if(countVal==barCount)
					{
						flag=true;
						break;
					}
				}
				if(flag)
				{
					break;
				}
			}

			boolean flagEqualsOne = true;
			for (int i=1; i<aListCount.size(); i++)
			{
				Integer count_Value = (Integer)aListCount.get(i);
				if (count_Value.intValue() > 1)
				{
					flagEqualsOne = false;
					break;
				}
			}
			if (flagEqualsOne)
			{
				yAxisMaxValue = "5";
			}
			else
			{
				yAxisMaxValue = "0";
			}

			//Fusion Bar Chart Data starts--Rekha
			HashMap mapChartAttributes = new HashMap();//map for chart attributes
			mapChartAttributes.put("bgcolor","FFFFFF");
			mapChartAttributes.put("yAxisName","Number of systems");
			mapChartAttributes.put("showToolTip","1");
			mapChartAttributes.put("showValues","1");
			mapChartAttributes.put("showBorder","0");
			mapChartAttributes.put("showShadow","0");
			mapChartAttributes.put("alpha","0");
			mapChartAttributes.put("canvasBgColor","F2F2F2");
			mapChartAttributes.put("canvasBgAlpha","60");
			mapChartAttributes.put("canvasBorderColor","000000");
			mapChartAttributes.put("canvasBorderThickness","1");
			mapChartAttributes.put("canvasBorderAlpha","30");
			mapChartAttributes.put("yAxisMaxValue",yAxisMaxValue);
			mapChartAttributes.put("maxBarHeight","40");

			HashMap mapChartData = new HashMap();//map for chart data
			mapChartData.put("barLabels",barLabels);
			mapChartData.put("barValues",sampleValues);
			mapChartData.put("barColors",barColors);

			HashMap mapProperties = new HashMap();//map for misc properties
			mapProperties.put("showColors","true");
			mapProperties.put("enableLinks","false");

			EcFusionChartBean chartbean = new EcFusionChartBean();
			String xmlString = chartbean.getXMLDataForStackedBarChart(mapChartAttributes,mapChartData,mapProperties);
			//Fusion Bar Chart Data ends

			printData.setChartTitle(barTitle);
			printData.setSampleAxisLabel(rangeAxisLabel);
			printData.setSampleValue(sampleValues);
			printData.setBarLabel(barLabels);
			printData.setMaxRange(String.valueOf(maxCount));

			boolean chartFlag = false;
			if (chartDataRepresentation != null && chartDataRepresentation.equalsIgnoreCase("3D"))
			{
				chartFlag = true;
			}
			if (chartFlag)
			{
%>
										<tr>
											<td height="0"><img src="/final/config/images/spacer.gif" border="0" height="10">
											</td>
										</tr>
										<tr>
											<td align="center" width="100%"><b><%=barTitle%></b></td>
										</tr>
										<tr>
											<td align="center" width="100%" bgcolor="white" nowrap>
												<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90%" height="275" id="StackedBar3D">
													<param name="movie" value="/final/FusionCharts/swf/StackedBar3D.swf" />
													<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=50&chartHeight=50" />
													<param name="quality" value="high" />
													<param name="wmode" value="transparent" />
													<embed src="/final/FusionCharts/swf/StackedBar3D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=50&chartHeight=50" quality="high" width="90%" height="275" name="StackedBar3D" wmode="transparent" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
												</object> -->
												<div id="chartStackedBarHotfix3DContainer"  style="height:100%;"></div>
												<script type="text/javascript">
													if  ( FusionCharts( "myStackedBarHot3DChartId" ) )
															FusionCharts( "myStackedBarHotfix3DChartId" ).dispose();
													var myChart = new FusionCharts( "/final/FusionCharts/swf/StackedBar3D.swf","myStackedBarHotfix3DChartId", "90%", "275","0","1");
													myChart.setXMLData("<%=xmlString%>");
													myChart.setTransparent(true);
													myChart.render("chartStackedBarHotfix3DContainer");
												</script>
											</td>
										</tr>
<%
			}
			else
			{
%>
										<tr>
											<td height="0"><img src="/final/config/images/spacer.gif" border="0" height="10">
											</td>
										</tr>
										<tr>
											<td align="center" width="100%"><b><%=barTitle%></b></td>
										</tr>
										<tr>
											<td align="center" width="100%" bgcolor="white" nowrap>
												<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90%" height="275" id="StackedBar2D">
													<param name="movie" value="/final/FusionCharts/swf/StackedBar2D.swf" />
													<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=50&chartHeight=50" />
													<param name="quality" value="high" />
													<param name="wmode" value="transparent" />
													<embed src="/final/FusionCharts/swf/StackedBar2D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=50&chartHeight=50" quality="high" width="90%" height="275" name="StackedBar2D" wmode="transparent" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
												</object> -->
												<div id="chartStackedBarHotfix2DContainer"  style="height:100%;"></div>
												<script type="text/javascript">
													if  ( FusionCharts( "myStackedBarHotfix2DChartId" ) )
															FusionCharts( "myStackedBarHotfix2DChartId" ).dispose();
													var myChart = new FusionCharts( "/final/FusionCharts/swf/StackedBar2D.swf","myStackedBarHotfix2DChartId", "90%", "275","0","1");
													myChart.setXMLData("<%=xmlString%>");
													myChart.setTransparent(true);
													myChart.render("chartStackedBarHotfix2DContainer");
												</script>
											</td>
										</tr>
<%
			}

			// pdf work
			EgTableAttributes egTableAttributes = new EgTableAttributes();
			egTableAttributes.setImageData(true);
				
			ArrayList aListData = new ArrayList();
			aListData.add(request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+"/final/servlet/com.eg.EcChartController?view=GRAPH&pageName=AVAILABILITY&chartType=bar&height="+URLEncoder.encode(barHeight)+"&width=600&chartTitle="+EgURLEncoder.encode(barTitle,"UTF-8")+"&sampleValues="+URLEncoder.encode(sampleValues)+"&barLabels="+URLEncoder.encode(barLabels)+"&rangeAxisLabel="+EgURLEncoder.encode(rangeAxisLabel,"UTF-8")+"&range="+maxCount+"&userName="+EgURLEncoder.encode(userName,"UTF-8"));
				
			ArrayList userColumnNames = new ArrayList();
			userColumnNames.add("Image");

			EgTableModel egTableModel = new EgTableModel(aListData,userColumnNames);
			egTable = new EgTable();
			egTable.setModel(egTableModel);
			egTable.setAttributes(egTableAttributes);
			aListPdfData.add(egTable);
		}
%>
										<tr>
											<td  height="5" id="blank">&nbsp; </td>
										</tr>
<%
		//Start to assign print data
		printData.setOsName(osName);
		printData.setTestName(testName);
		printData.setMapData(finalData);
		printData.setShowCount(viewCount);
		printData.setAvailableName(softwareName);
		printData.setListData(softwareCount);
		printData.setMapData(finalData);
		printData.setMapCountData(countData);
		session.setAttribute("HOTFIX_AVAILABILITY",printData);
		session.setAttribute("processDataObject",processData);
		//End to assign print data

		int selCount=0; 
		boolean skip=false;
		for(int n=0;n<softwareCount.size();n++)
		{
			Integer count=(Integer)softwareCount.get(n);
			List infoName=(ArrayList)countData.get(count);
			if(!("All".equalsIgnoreCase(softwareName)))
			{
				List alist=new ArrayList();
				alist.add("+"+softwareName);
				if(infoName!=null && infoName.size()==1)
				{
					String tempSoftware=(String)infoName.get(0);
					if(!tempSoftware.equals("+"+softwareName))
						continue;
				}
				else if(!infoName.retainAll(alist))
					continue;
			}

			Collections.sort(infoName,String.CASE_INSENSITIVE_ORDER);
			for(int n1=0;n1<infoName.size();n1++)
			{
				//pdf work
				ArrayList aListData = new ArrayList();
				ArrayList aListColumnNames = new ArrayList();
				ArrayList userColumnNames = new ArrayList();

				aListColumnNames.add("C1");
				aListColumnNames.add("C2");

				userColumnNames.add("");

				EgTableAttributes egTableAttributes = new EgTableAttributes();
				egTableAttributes.setStartX(0);
				egTableAttributes.setDataGrouping(true);
				egTableAttributes.setDataGroupingField(0);
				egTableAttributes.setColumnNames(userColumnNames);

				String info=(String)infoName.get(n1);
				String associatedNickName=(String)finalData.get(info);
				if(viewCount!=null && !viewCount.equalsIgnoreCase("All"))
				{
					int showCount=Integer.parseInt(viewCount);
					if(showCount==selCount)
					{
						skip=true;
						break;
					}
					selCount++;
				}
				//egTableAttributes.setTitle(info.substring(1));
				userColumnNames.add(info.substring(1));
%>
										<tr>
											<td align="center" width="100%" valign="top">
												<table border="0" width="99%" cellspacing="0" cellpadding="0" class="body_text"  id="bottomtable">
													<tr>
														<td class="bgdarkimg"  height="20">
															<b><%=info.substring(1)%></b>
														</td>
													</tr>
													<tr>
														<td  align="center" id="padding3">
															<table border="0" cellspacing="0" cellpadding="0" class="body_text" width="100%">
<%
				ArrayList nickList=processData.getInfoNickNames(osName,associatedNickName,true);
				if(nickList!=null && nickList.size()>0)
				{
					//pdf work
					String temp = null;
					if(nickList.size() > 1)
						temp = "Systems";
					else temp = "System";
					aListData.add(mappingInfo.getTextDescription("configmgmt.inventory.availability.Available in")+" "+nickList.size()+" "+mappingInfo.getTextDescription("configmgmt.inventory.availability."+temp));
%>
																<tr>
																	<td id="bglight" align="left" width="20%" height="15">&nbsp;<b><egui:intnl text="configmgmt.inventory.availability.Available in" />&nbsp;<%=nickList.size()%>&nbsp;<egui:intnl text='<%="configmgmt.inventory.availability."+temp%>' /></b></td>
																	<td height="15"><img src="/final/config/images/gray/cell_corner.gif"></td>
																</tr>
																<tr>
																	<td class="cell_border" id="cell_bg1" align="left" colspan="2" style="border-left-width:1px;border-top-width:1px" wrap>
<%
					String systemNamePdf = null;
					for(int s=0;s<nickList.size();s++)
					{
						String systemName=(String)nickList.get(s);

						//pdf work
						if(systemNamePdf == null){
							systemNamePdf = systemName;
						}else{
							systemNamePdf = systemNamePdf + ", " + systemName;
						}

						if(nickList!=null && (s!=nickList.size()-1))
						{
%>
												<a href="../servlet/com.eg.EcConfigurationServlet?request_from=HomePage&cmd=BoxView&searchValue=&systemName=<%=EgURLEncoder.encode(systemName,"UTF-8")%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" target="_self" class="eg_monlink"><%=systemName%></a>,
<%
						}
						else
						{
%>
												<a href="../servlet/com.eg.EcConfigurationServlet?request_from=HomePage&cmd=BoxView&searchValue=&systemName=<%=EgURLEncoder.encode(systemName,"UTF-8")%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" target="_self" class="eg_monlink"><%=systemName%></a>
<%
						}
					}
%>
																	</td>
																</tr>
<%
					//pdf work
					aListData.add(systemNamePdf);
				}
				
				nickList=processData.getInfoNickNames(osName,associatedNickName,false);
				if(nickList!=null && nickList.size()>0)
				{
					//pdf work
					String temp = null;
					if(nickList.size() > 1)
						temp = "Systems";
					else temp = "System";
					aListData.add(mappingInfo.getTextDescription("configmgmt.inventory.availability.Unavailable in")+" "+nickList.size()+" "+mappingInfo.getTextDescription("configmgmt.inventory.availability."+temp));
%>
																<tr>
																	<td  height="10" id="blank">&nbsp; </td>
																</tr>
										
																<tr>
																	<td id="tdbacklightcolor3"  align="left" width="20%" height="15">&nbsp;<b><egui:intnl text="configmgmt.inventory.availability.Unavailable in" />&nbsp;<%=nickList.size()%>&nbsp;<egui:intnl text='<%="configmgmt.inventory.availability."+temp%>' /></b></td>
																	<td height="15"><img src="/final/config/images/gray/cell_corner.gif"></td>
																</tr>
																<tr>
																	<td class="cell_border" id="cell_bg1" align="left" colspan="2" style="border-left-width:1px;border-top-width:1px" wrap>
<%
					String systemNamePdf = null;
					for(int s=0;s<nickList.size();s++)
					{
						String systemName=(String)nickList.get(s);
						//pdf work
						if(systemNamePdf == null){
							systemNamePdf = systemName;
						}else{
							systemNamePdf = systemNamePdf + ", " + systemName;
						}

						if(nickList!=null && (s!=nickList.size()-1))
						{
%>
									<a href="../servlet/com.eg.EcConfigurationServlet?request_from=HomePage&cmd=BoxView&searchValue=&systemName=<%=EgURLEncoder.encode(systemName,"UTF-8")%>" target="_self" class="eg_monlink"><%=systemName%></a>,
<%
						}
						else
						{
%>
									<a href="../servlet/com.eg.EcConfigurationServlet?request_from=HomePage&cmd=BoxView&searchValue=&systemName=<%=EgURLEncoder.encode(systemName,"UTF-8")%>" target="_self" class="eg_monlink"><%=systemName%></a>
<%
						}
					}
%>
																	</td>
																</tr>
<%
					//pdf work
					aListData.add(systemNamePdf);
				}
%>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td  height="10" id="blank">&nbsp;</td>
										</tr>
<%
				//pdf work
				EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);
				egTable = new EgTable();
				egTable.setModel(egTableModel);
				egTable.setAttributes(egTableAttributes);

				aListPdfData.add(egTable);
			}

			if(skip)
				break;
		}
		//pdf work
		pdfData.setData(aListPdfData);
		session.setAttribute("pdfData",pdfData);
	}
	else if(osName != null && !osName.equals("null") && !osName.equals("-1") && submitOrNot.equals("true"))
	{  // while finalData Loop
%>
										<tr>
											<td align="center" >
												<table border="0" align="center" width="100%"  height="100%">
													<tr>
														<td align="center">
															<table border="0" align="center" width="100%" class="body_text" >
																<tr>
																	<td align="center"> <img src="/final/config/images/unavailable-data.gif" alt='<egui:intnl text="configmgmt.common.No Data" />'> </td>
																</tr>
																<tr>
																	<td align="center"> <b><egui:intnl text="configmgmt.inventory.availability.Hotfix/Patch not available in systems of the selected OS" /></b> </td>
																</tr>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
<%
	}
%>
									</table>
								<!-- </div> -->
								</td>
							</tr>
						</table>
					</tr>
				</td>
			</table>
		</tr>
	</td>
</table>
<%
	if(!("All".equalsIgnoreCase(softwareName)))
	{
%>
		<script>
			showOrder();
		</script>
<%
	}
%>
</form>
</body>
</html>



