<%
/**
 *	File name	:	EgMoreInfos.jsp
 *	Purpose		:	Shows all infos of a test whose info count exceed a specified number. In turn displays
 *					contents of EgMoreInfos.jsp and EgDispMeasure.jsp
 *	Version		:	eG 3.1
 *	Created on	:	25-03-2004
 *	Last Date	:	26-03-2004	Vijaykumar	GUI Changes
 *					05/05/2004	Arun		Modified to enable anchoring of links for DispMeasures if 
 *											the count exceeds 24.
 *					18/05/2004	Arun		Corrected refresh time.
 *					20/05/2004	Arun		Clubbed alarms with more infos now display correctly.
 *					27/05/2004	Arun		Included msmtHost in the URL for EgDispMeasures.jsp
 *	Author		:	Arun Jayaprakash
 */
%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EgMonitorTracker.jsp"%>
<%@ page import = "com.eg.EgDbAdapterTypeUI"%>
<%@ page import = "com.eg.EgConfigInfo" %>
<%@ page import = "com.eg.EgDateInfo" %>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import = "com.egurkha.ini.*" %>
<%@ page import = "com.egurkha.monitor.*" %>
<%@ page import = "com.egurkha.monitor.alarms.*" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "egurkha.EgDbAdapterUI"%>
<%@ page import = "java.sql.*" %>
<%@ page import = "java.util.*" %>
<%@ page import = "com.eg.*" %>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgExternalInfo"%>
<%@ page import = "net.sf.json.*"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.eg.EgURLEncoder"%>
<%!
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgDateInfo dateInfo = new EgDateInfo();
%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	//response.setHeader("Resresh","10");

	JSONObject viewJson = new JSONObject();
	JSONObject viewScreenLabels = new JSONObject();

	IniUI ui = (IniUI)IniUI.getInstance();

	UserRegistry registry = UserRegistry.getInstance();
	User viewUser = registry.getUser(session.getId());

	String thisLanguage = ui.getDefaultLanguage();
	if (viewUser!=null)
	{
		String userLang = viewUser.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}

	String flagValue= (String) session.getAttribute("flagValue");
	String meas= (String) request.getParameter("messy");
	String infoStr= (String) request.getParameter("infoStr");

	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
	boolean isMSIE6 = ( ua != null && ua.indexOf( "MSIE 6.0" ) != -1 );
	boolean isMSIE7 = ( ua != null && ua.indexOf( "MSIE 7.0" ) != -1 );
	boolean isMSIE8 = ( ua != null && ua.indexOf( "MSIE 8.0" ) != -1 );
	boolean isChrome = ( ua != null && ua.indexOf( "Chrome/" ) != -1 );


	boolean isfromSuper = session.getAttribute("fromSuper") != null && session.getAttribute("fromSuper").toString().equalsIgnoreCase("yes");

	String uiFile = "eg_ui.ini";
	String iniFileDir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(iniFileDir + uiFile);
	String subTreeTests=(String)egUI.getValue("TEST_PANEL_SUBTREE","SubTreeTestList");
	ArrayList subTreeTestsList=new ArrayList();
	if(subTreeTests!=null && subTreeTests.trim().length()>0)
	{
		subTreeTestsList =  com.egurkha.util.StringUtils.egTokenizer(subTreeTests,",",false,true,true);//param 3-->includeEmpty,4-->unique,5-->trim
	}

try
{
	String refresh = ui.getRefreshTime("EgMoreInfosView");
	//String refresh = user.getRefreshFrequency();


	String queryString = request.getQueryString();
	String qctr = request.getParameter("qctr");
	String test = request.getParameter("test");
	if (test == null || test.equalsIgnoreCase("null"))
	{
		test = request.getParameter("testName");
		if (test == null || test.equalsIgnoreCase("null"))
		{
			test = "";
		}
	}

	String measure = null;
	int index = test.indexOf("-");
	if (index > -1)
	{
		measure = test.substring(index + 2);
		test = test.substring(0, index);
	}
	else if (qctr != null && qctr.equals("2"))
	{
		measure = request.getParameter("measure");
		if (measure != null && measure.trim().length()>0)
			measure=com.egurkha.util.StringUtils.decodeSecurityChar(measure);
		if (measure == null)
		{
			measure = "";
		}
	}
	else
	{
		measure = "";
	}

	String fromAlarm = request.getParameter("fromalarm");
	/*if (fromAlarm != null && fromAlarm.equals("1"))
	{
		measure = "";
		qctr = "1";
	}*/
	
	String str_site=request.getParameter("site");
	String str_host=request.getParameter("host");
	String str_layer=request.getParameter("layer");
	String str_tstate = request.getParameter("tstate");
	
	String str_host_type = null;
	String fakeType  = request.getParameter("faketype");
	
	/*if (StringUtils.isNull(fakeType) || fakeType.equalsIgnoreCase("null"))
	{
		str_host_type = request.getParameter("comptype");
	}
	else
	{
		str_host_type = fakeType;
	}*/
	str_host_type = request.getParameter("comptype");
	String msmtHost = request.getParameter("msmt_host");

	String isInterface = request.getParameter("isInterface");
	isInterface = (isInterface==null)?"":isInterface;
	String selectedInterface = request.getParameter("selectedInterface");
	selectedInterface=(selectedInterface==null)?"":selectedInterface;

	StringBuffer measuresUrl = new StringBuffer(64);
	//measuresUrl.append("EgDispMeasure.jsp");
	measuresUrl.append("egDashBoardDispCompMeasure.jsp");
	if (qctr != null && qctr.equalsIgnoreCase("2"))
	{
		measuresUrl.append("?qctr=2&msmt_host=");
		measuresUrl.append(EgURLEncoder.encode((msmtHost==null?"":msmtHost),"UTF-8"));
		measuresUrl.append("&test=");
		measuresUrl.append(EgURLEncoder.encode((test==null?"":test),"UTF-8"));
		measuresUrl.append("-+");
		measuresUrl.append(EgURLEncoder.encode((measure==null?"":measure),"UTF-8"));
		measuresUrl.append("&host=");
		measuresUrl.append(EgURLEncoder.encode((str_host==null?"":str_host),"UTF-8"));
		measuresUrl.append("&layer=");
		measuresUrl.append(str_layer);
		measuresUrl.append("&site=");
		measuresUrl.append(EgURLEncoder.encode((str_site==null?"":str_site),"UTF-8"));
		measuresUrl.append("&comptype=");
		measuresUrl.append(EgURLEncoder.encode((str_host_type==null?"":str_host_type),"UTF-8"));
		measuresUrl.append("&tstate=");
		measuresUrl.append(str_tstate);
	}
	else
	{
		measuresUrl.append("?qctr=1&moreinfos=yes");
	}
	measuresUrl.append("&egaggregatedotjs=");
	measuresUrl.append("true");
	measuresUrl.append("&moreInfos=true");

	String requireAnchor = request.getParameter("requireAnchor");
	StringBuffer infosUrl = new StringBuffer(32);
	infosUrl.append("EgMoreInfos.jsp?");
	infosUrl.append(queryString);
	if (!StringUtils.isNull(measure) && (requireAnchor != null && requireAnchor.equalsIgnoreCase("true")))
	{
		infosUrl.append("#");
		infosUrl.append(measure);
	}

	//EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);

	viewScreenLabels.put("egManager",mappingInfo.getTextDescription("monitor.common.eG Manager"));
	viewScreenLabels.put("moreInformation",mappingInfo.getTextDescription("monitor.moreinfo.More Information"));
	viewScreenLabels.put("descriptionList",mappingInfo.getTextDescription("monitor.moreinfo.Complete Description List"));
	viewJson.put("refreshFrequency",refresh);

	String tempComponent = request.getParameter("host");
	boolean hasPortNumber = true;
	if(tempComponent != null && tempComponent.indexOf(":") > -1)
	{
		hasPortNumber =! tempComponent.substring(tempComponent.indexOf(":")+1).equals("NULL") ; 
	}
	String componentStr;
	String layerStr = request.getParameter("layer");
	String testStr = request.getParameter("test");
	if(hasPortNumber)
	{
		componentStr = tempComponent;
	}
	else
	{
		componentStr = 	tempComponent.substring(0,tempComponent.indexOf(":"));
	}
	
	viewScreenLabels.put("component",mappingInfo.getTextDescription("monitor.moreinfo.Component"));

	viewJson.put("component",componentStr);
	viewJson.put("layer",mappingInfo.getLayerDescription(layerStr));
	viewJson.put("test",mappingInfo.getTestDescription(testStr));

	if(subTreeTestsList!=null && subTreeTestsList.size()>0 && testStr!=null && subTreeTestsList.contains(testStr) && (isInterface!=null && isInterface.equalsIgnoreCase("yes") || isInterface.equalsIgnoreCase("true")))
	{
		if(selectedInterface!=null && selectedInterface.trim().length()>0)
		{
			viewScreenLabels.put("descriptor",mappingInfo.getTextDescription("monitor.common.Descriptor"));
			viewJson.put("selectedInferface",selectedInterface);
		}
	}

	viewScreenLabels.put("component",mappingInfo.getTextDescription("monitor.moreinfo.Component"));
	viewScreenLabels.put("layer",mappingInfo.getTextDescription("monitor.moreinfo.Layer"));
	viewScreenLabels.put("test",mappingInfo.getTextDescription("monitor.moreinfo.Test"));

	viewJson.put("measuresUrl",measuresUrl.toString());
	viewJson.put("screenLabels",viewScreenLabels);
	response.getWriter().write(viewJson.toString());
}
catch(Exception e)
{
	System.out.println("EXCEPTION :"+e);
	e.printStackTrace();
}
%>