<%
/********************************************************************************
FileName	:egDesignDashboard.jsp
Purpose		:User can design the dashboard using the tools. Some codes are duplicated in jsp and in javascript for the fast development of Dashboard.
Created by	:Simeon.D
Created on	:22/11/2009
GUI Changed by	:Vijay\Jaiwin
**********************************************************************************/
%>
<%@ include file="EgLoginTracker.jsp"%>
<%@ page errorPage="EgProbsM.jsp"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page import="com.eg.*"%>
<%@ page import="com.egurkha.monitor.*"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.EgUserPermission"%>
<%@ page language="java" contentType="text/html;charSet=UTF-8" pageEncoding="UTF-8"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires",-1);
%>
<%
try
{
	EgMappingInfo mappingInfo=new EgMappingInfo(trackerLanguage);

	EgServerDashboardModel egDashboard=new EgServerDashboardModel();
	EgCustomDashboardModel egCustomDashboard=new EgCustomDashboardModel();
	EgUserRole userRole = u_ser.getUserRole();
	egDashboard.setUser(u_ser);

	String profileName=request.getParameter("profileName");
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";

	IniFile iniObj = new IniFile(s_iniFile_dir+"eg_customdashboard.ini");
	IniFile mappingIni = new IniFile(s_iniFile_dir+"eg_customdashboardTitleMapping.ini");

	String compType=request.getParameter("compType");
	String compName=request.getParameter("compName");

	String subject=u_ser.getLoginID()+"_"+compType+"_"+profileName;
	String s_enabledBlocks=iniObj.getValue(subject,"enabled_block");
	String s_inidcators=iniObj.getValue(subject,"Indicators");
	String s_config=iniObj.getValue(subject,"config");
	String s_dial=iniObj.getValue(subject,"dial");
	String s_digital=iniObj.getValue(subject,"digital");
	String s_history=iniObj.getValue(subject,"history");
	String s_comparision=iniObj.getValue(subject,"comparision");
	String s_tables=iniObj.getValue(subject,"tables");
	String ddcomp_tables=iniObj.getValue(subject,"DDComparisonTables");
	String dashboardIni = "eg_serverdashboard.ini";
	IniFile inifile = new IniFile(s_iniFile_dir + dashboardIni);

	String isCustomDashboard = inifile.getValue("Custom_Dashboard",compType);

	EgMemCheck memCheck = new EgMemCheck();
	boolean hasConfig=memCheck.isCMEnabled();

	if(hasConfig)
		hasConfig=userRole.hasAnyConfigRole(EgUserPermission.CONFIG);

	String defaultHealthDuration=mappingIni.getValue(subject+"_Health_Duration","duration");

	if(defaultHealthDuration==null || defaultHealthDuration.trim().equals(""))
		defaultHealthDuration="24 hours";

	String test="";
	String measure="";

	String s_dialURL="/final/monitor/eg_images/"+monitor_Skin+"/dial_sample.png";

	String s_digitalURL="/final/monitor/eg_images/"+monitor_Skin+"/digital_sample.png";

	String s_historyURL="/final/monitor/eg_images/"+monitor_Skin+"/history_sample.png";

	String s_comparisionURL="/final/monitor/eg_images/"+monitor_Skin+"/comparision_sample.png";

	int divCount=0;

	Vector indicatiors=egDashboard.getTokensAsVector(s_inidcators,",");
	Vector configs=egDashboard.getTokensAsVector(s_config,",");

	int noOfConfig=0;
	int noOfInidicatiors=0;

	if(configs!=null && configs.size()>0)
		noOfConfig=configs.size();

	if(indicatiors!=null && indicatiors.size()>0)
		noOfInidicatiors=indicatiors.size();

	String defaultEventHistTime=mappingIni.getValue(subject+"_HistoricalEvents_Duration","duration");
	if(defaultEventHistTime==null || defaultEventHistTime.trim().equals(""))
		defaultEventHistTime="24 hours";

	Vector infoBasedTests=egCustomDashboard.getInfoBasedTests(compType);
	String s_infoBasedTests=egCustomDashboard.concatTokensAsString(infoBasedTests,",");
	String existingKPITestMeasures="";
	String existingConfigTestMeasures="";
%>
<HTML class="content-frame">
<head>
<egui:skin ui="monitor"/>
<!-- 
<link rel="stylesheet" href="/final/monitor/eg_styles/monstyle_gray.css" />
-->
<script language="javascript">

	var compType='<%=compType%>';
	var divCount=0;
	var upDateingDivId=0;

	var s_infobasedTests='<%=s_infoBasedTests%>';

	function isInfoBasedTest(testName)
	{
		var testArr=s_infobasedTests.split(",");
		for(var i=0;i<testArr.length;i++)
		{
			if(testArr[i]==testName)
				return true;
		}
		return false;
	}

	function hideElement(elmentId)
	{
		var element=document.getElementById(elmentId);
		if(element!=null)
			element.style.display="none";
	}

	function showElement(elmentId)
	{
		var element=document.getElementById(elmentId);
		if(element!=null)
			element.style.display="block";
	}

	function showToolBox()
	{
		var toolsImg=document.getElementById("toolsImg");
		var toolsDiv=document.getElementById("toolsDiv");
		var iconbg=document.getElementById("iconBg");
		if(toolsImg!=null && toolsDiv!=null && iconbg!=null)
		{
			toolsDiv.style.display="block";
			toolsImg.src="/final/monitor/eg_images/<%=monitor_Skin%>/spacer.gif";
			iconbg.style.display="none";
		}
	}

	function hideToolBox()
	{
		var toolsImg=document.getElementById("toolsImg");
		var toolsDiv=document.getElementById("toolsDiv");
		var iconbg=document.getElementById("iconBg");
		if(toolsImg!=null && toolsDiv!=null && iconbg!=null)
		{
			toolsDiv.style.display="none";
			toolsImg.src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_toolbox.png";
			iconbg.style.display="block";
		}
	}

	function GetXmlHttpObject()
	{
		var xmlHttp=null;
		try
		{
			// Firefox, Opera 8.0+, Safari
			xmlHttp=new XMLHttpRequest();
		}
		catch (e)
		{
			// Internet Explorer
			try
			{
				xmlHttp=new ActiveXObject("Microsoft.XMLHTTP");
			}
			catch (e)
			{
				xmlHttp=new ActiveXObject("Msxml2.XMLHTTP");
			}
		}
		return xmlHttp;
	}

	var propertyLeft=0;
	var propertyTop=0;

	function loadPropertyPage(url,divId,event,from)
	{
		var propertyDiv=document.getElementById("propertyDiv");
		var closeImg=document.getElementById("closeImg");
		var showInMousePosition=false;

		if(event!=null && event!='undefined')
			showInMousePosition=true;

		event=(isIE())?window.event:event;

		if(from=="table")
		{
			if(closeImg!=null)
			{
				closeImg.onclick=function(){loadMeasureOnTable(true)};
			}
		}
		else if(from=="DDComparisonTable")
		{
			if(closeImg!=null)
			{
				closeImg.onclick=function(){saveDDComparisonTableConfig(true)};
			}
		}

		if(propertyDiv!=null)
		{
			propertyDiv.style.display="block";

			if(showInMousePosition)
			{
				if(parseInt(event.clientX)+parseInt(propertyDiv.offsetWidth)>document.body.offsetWidth)
				{
					propertyDiv.style.left=event.clientX-propertyDiv.offsetWidth;
				}
				else
				{
					propertyDiv.style.left=event.clientX;
				}

				if(parseInt(event.clientY)+parseInt(propertyDiv.offsetHeight)>document.body.offsetHeight)
				{
					propertyDiv.style.top=event.clientY-propertyDiv.offsetHeight;
				}
				else
				{
					propertyDiv.style.top=event.clientY;
				}

				propertyLeft=propertyDiv.style.left;
				propertyTop=propertyDiv.style.top;
			}
			else
			{
				propertyDiv.style.left=propertyLeft;
				propertyDiv.style.top=propertyTop;
			}
		}

		var xmlHttp=GetXmlHttpObject();
		if (xmlHttp==null)
			return;

		xmlHttp.onreadystatechange = function ()
		{
			var idObj =document.getElementById(divId);

			idObj.innerHTML = '<table height="500px" width="100%"><tr><td height="500px" align=center valign="middle"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/indicator_medium.gif"></td></tr></table>';
			if (xmlHttp.readyState==4)
			{
				if (xmlHttp.status == 200)
				{
					var response=xmlHttp.responseText;
					try
					{
						idObj.innerHTML=response;
					}
					catch(e)
					{
						alert("e--->"+e.description);
					}
				}
			}
		}
		xmlHttp.open("GET",url,true);
		xmlHttp.send(null);
	}

	function isIE()
	{
		var ver = navigator.appVersion;
		ver = ver.toLowerCase();
		if (ver.indexOf("msie ") > 0 || document.all)
			return true;
		else
			return false;
	}

	function isFireFox()
	{
		if (isIE())
			return false;
		else
			return true;
	}

	var startX=0;
	var startY=0;
	var dragStarted=false;
	var dragDiv;

	function startDrag(divId,event)
	{
		dragDiv=document.getElementById(divId);

		document.body.style.cursor="move";
		if(navigator.appName=="Microsoft Internet Explorer")
		{
			event=window.event;
		}
		if(dragDiv!=null)
		{
			startX=event.clientX-parseInt(dragDiv.style.left);
			startY=event.clientY-parseInt(dragDiv.style.top);
		}
		dragStarted=true;
	}

	function drag(event)
	{
		var iframe1=document.getElementById("iframe1");
		if(navigator.appName=="Microsoft Internet Explorer")
		{
			event=window.event;
		}
		if(dragStarted)
		{
			if(dragDiv!=null)
			{
				dragDiv.style.left=event.clientX-startX;
				dragDiv.style.top=event.clientY-startY;
				iframe1.style.left=event.clientX-startX;
				iframe1.style.top=event.clientY-startY;
			}
		}
	}

	function endDrag(event)
	{
		document.body.style.cursor="default";
		if(navigator.appName=="Microsoft Internet Explorer")
		{
			event=window.event;
		}
		startX=0;
		startY=0;
		dragStarted=false;
	}

	function drawTable(tableType)
	{
		var contentDiv=document.getElementById("contentDiv");

		var hidDivCount=document.getElementById("hidDivCount");
		if(hidDivCount!=null && parseInt(hidDivCount.value)>divCount)
			divCount=parseInt(hidDivCount.value);

		if(tableType!=null && tableType=="DDComparisonTable")
		{
			var str='<div id="div'+(++divCount)+'" class="istam_div_scroll istam_vmborder" style="margin-left:10px;margin-top:10px;float:left;width:480px;height:153px;display:block">';
			str+='<table border="0" bordercolor="blue" cellpadding="0" cellspacing="0" width="100%">';
			str+='<tr>';
			str+='<td class="istam_data_headbg1" height="25" style="border-right-width:0px" width="94%"><div id="header'+divCount+'" ondblclick="javascript:editTableTitle('+divCount+',\'ddcomparisontable\');">DD Comparison Table Header</div></td>';
			str+='<td class="istam_data_headbg1" width="20" align="right" style="width:20px;border-right-width:0px"><img class="mouse" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_close_div.png" onclick="javascript:removeTable('+divCount+',\'ddcomparisontable\');"/></td>';
			str+='</tr>';
			str+='<tr>';
			str+='<td width="100%" height="125" colspan="2" valign="top" class="linetop">';
			str+='<div id="contentDiv'+divCount+'" style="width:100%; height:100%"/>';
			str+='<table height="98%" border="0" bordercolor="blue" cellpadding="2" cellspacing="0" width="100%">';
			str+='<tr><td width="100%" height="100%" valign="middle" align="center" class="font_bold11 mouse"  style="border:0px"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_ddcomparision_big.png" title="configure" onclick="javascript:loadTableOnclick('+divCount+',\'DDComparisonTable\',event);"/><br><br><egui:intnl text="monitor.dashboard.Please Click here to Configure"/></td></tr>';
			str+='</table>';
			str+='</div>';
			str+='</td>';
			str+='</tr>';
			str+='</table>';
			str+='<input type="hidden" id="hidTest'+divCount+'"/>';
			str+='<input type="hidden" id="hidTestDDMeasure'+divCount+'"/>';
			str+='<input type="hidden" id="hidTestMapping'+divCount+'"/>';
			str+='</div>';
		}
		else
		{
			var str='<div id="div'+(++divCount)+'" class="istam_div_scroll istam_vmborder" style="margin-left:10px;margin-top:10px;float:left;width:480px;height:153px;display:block">';
			str+='<table class="" border="0" bordercolor="blue" cellpadding="0" cellspacing="0" width="100%">';
			str+='<tr>';
			str+='<td class="istam_data_headbg1" height="25" style="border-right-width:0px" width="94%"><div id="header'+divCount+'" ondblclick="javascript:editTableTitle('+divCount+',\'comparisontable\');">Table Header </div></td>';
			str+='<td class="istam_data_headbg1" width="20" align="right" style="width:20px;border-right-width:0px"><img class="mouse" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_close_div.png" onclick="javascript:removeTable('+divCount+',\'comparisontable\');"/></td>';
			str+='</tr>';
			str+='<tr>';
			str+='<td width="100%" height="125" colspan="2" style="padding:0px" valign="top" class="linetop">';
			str+='<div id="contentDiv'+divCount+'" style="width:100%;height:100%"/>';
			str+='<table height="98%" border="0" bordercolor="blue" cellpadding="2" cellspacing="0" width="100%">';
			str+='<tr><td width="100%" height="100%" valign="middle" align="center" class="font_bold11 mouse"  style="border:0px"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_table_big.png" title="configure" onclick="javascript:loadTableOnclick('+divCount+',\'ComparisonTable\',event);"/><br><br><egui:intnl text="monitor.dashboard.Please Click here to Configure"/></td></tr>';
			str+='</table>';
			str+='</div>';
			str+='</td>';
			str+='</tr>';
			str+='</table>';
			str+='<input type="hidden" id="hidTest'+divCount+'"/>';
			str+='<input type="hidden" id="hidTestMapping'+divCount+'"/>';
			str+='</div>';
		}
		if(contentDiv!=null)
			contentDiv.innerHTML=contentDiv.innerHTML+str;
	}

	function editTableTitle(divId,tableType)
	{
		var header=document.getElementById('header'+divId);

		if(header!=null && header.getElementsByTagName("input").length==0)
		{
			var tempStr=header.innerHTML;
			header.innerHTML='<input type="text" id="txtMapping'+divId+'" value="'+tempStr+'" onblur="javascript:updateTableTitle('+divId+',\''+tableType+'\');" class="egInputText" />';

			var txtMapping=document.getElementById('txtMapping'+divId);
			if(txtMapping!=null)
				txtMapping.focus();
		}
	}

	function updateTableTitle(divId,tableType)
	{
		var header=document.getElementById('header'+divId);
		var hidTest=document.getElementById('hidTest'+divId);
		var hidTestMapping=document.getElementById('hidTestMapping'+divId);
		var txtMapping=document.getElementById('txtMapping'+divId);

		if(txtMapping!=null && header!=null)
		{
			hidTestMapping.value=txtMapping.value;
			header.innerHTML=txtMapping.value;
		}
		var url="";

		if(tableType!=null && tableType=="ddcomparisontable")
		{
			var hidTestDDMeasure=document.getElementById('hidTestDDMeasure'+divId);
			url='<%=response.encodeURL("/final/servlet/com.eg.egCustomDashController?")%>'+"compType="+compType+'&key='+hidTest.value+":"+hidTestDDMeasure.value+'&profileName=<%=EgURLEncoder.encode(profileName,"UTF-8")%>&action=editDDComparisonTableTitle&value='+hidTestMapping.value;
		}
		else
		{
			url='<%=response.encodeURL("/final/servlet/com.eg.egCustomDashController?")%>'+"compType="+compType+'&key='+hidTest.value+'&profileName=<%=EgURLEncoder.encode(profileName,"UTF-8")%>&action=editTableTitle&value='+hidTestMapping.value;
		}

		updateIniFile(url);
	}

	function drawGraph(img)
	{
		var contentDiv=document.getElementById("contentDiv");

		var hidDivCount=document.getElementById("hidDivCount");
		if(hidDivCount!=null && parseInt(hidDivCount.value)>divCount)
			divCount=parseInt(hidDivCount.value);

		if(img!=null && contentDiv)
		{
			var str='<div id="div'+(++divCount)+'"  class="istam_vmborder" style="margin-left:10px;margin-top:10px;float:left;height:153px;">';
			str+='<table border="0" bordercolor="blue" cellpadding="0" cellspacing="0"><col width="90%"><col width="10%">';
			str+='<tr>';
			str+='<td class="istam_data_headbg1" height="25" style="border-right-width:0px">';
			str+='<div id="header'+divCount+'" ondblclick="javascript:editHeader('+divCount+',\''+img.getAttribute("graphType")+'\');");">Unconfigured</div>';
			str+='</td>';
			str+='<td class="istam_data_headbg1" style="border-right-width:0px"><img class="mouse" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_close_div.png" onclick="javascript:removeGraph('+divCount+',\''+img.getAttribute("graphType")+'\');"/></td>';
			str+='</tr>';
			str+='<tr>';
			str+='<td colspan="2" height="125" class="linetop" align="center">';
			str+='<img  class="mouse" src='+img.getAttribute("graphSrc")+'  title="configure" onclick="javascript:loadTestOnclick('+divCount+',\''+img.getAttribute("graphType")+'\',event);"/>';
			str+='</td>';
			str+='</tr>'; 

			str+='</table>';
			str+='<input type="hidden" id="hidTestMsr'+divCount+'"/>';
			str+='<input type="hidden" id="hidTestMsrMapping'+divCount+'"/>';
			str+='</div>';
			contentDiv.innerHTML=contentDiv.innerHTML+str;
		}
	}

	function loadTableOnclick(divId,tableType,event)
	{
		upDateingDivId=divId;
		if(tableType!=null && tableType=="ComparisonTable")
			tableType="table";
		loadPropertyPage('<%=response.encodeURL("/final/monitor/egDashboardProperties.jsp?")%>'+"compType="+compType+'&from='+tableType+'&profileName=<%=EgURLEncoder.encode(profileName,"UTF-8")%>','propertyContentDiv',event,tableType);
	}

	function loadTestOnclick(divId,graphType,event)
	{
		upDateingDivId=divId;
		loadPropertyPage('<%=response.encodeURL("/final/monitor/egDashboardProperties.jsp?")%>'+"compType="+compType+"&graphType="+graphType+"&from=graph&profileName=<%=profileName%>","propertyContentDiv",event);
	}

	function loadTestOnKPI(event)
	{
		loadPropertyPage('<%=response.encodeURL("/final/monitor/egDashboardProperties.jsp?")%>'+"compType="+compType+"&from=kpi&profileName=<%=profileName%>","propertyContentDiv",event);
	}

	function loadTestOnConfig(event)
	{
		loadPropertyPage('<%=response.encodeURL("/final/monitor/egDashboardProperties.jsp?")%>'+"compType="+compType+"&from=config&profileName=<%=profileName%>","propertyContentDiv",event);
	}

	var noOfConfig=<%=noOfConfig%>+1;
	function loadMeasuerOnConfig(flag)
	{
		var testSelect=document.getElementById("testSelect");
		var measureSelect=document.getElementById("measureSelect");
		var configTestMeasuresHid=document.getElementById("configTestMeasuresHid");
		var contentDiv=document.getElementById("contentDivConfig");
		var configConfigImg=document.getElementById("configConfigImg");
		var configaddedmeasure=0;
		var tempStr='';
		var existingmeasuresCount=0;
		tempStr+='<div id="divConfig'+noOfConfig+'" class="istamViewTable" style="padding:2px;border:0px solid #000000">';
		tempStr+='<table width="100%">';
		for(var i=0;i<measureSelect.options.length;i++)
		{
			if(measureSelect.options[i]!=null && measureSelect.options[i].selected)
			{
				var values=testSelect.value+":"+measureSelect.options[i].value;
				if(configTestMeasuresHid!=null && configTestMeasuresHid!="undefined")
				{
					var configHidVal=configTestMeasuresHid.value;
					if(configHidVal!=null && configHidVal.indexOf(values)!=-1)
					{
						existingmeasuresCount++;
						continue;
					}
				}
				
				tempStr+='<tr>';
				tempStr+='<td style="width:20px" class="font_normal11">';
				tempStr+='<input type="checkbox" checked class="eg_input" onclick="javascript:unloadConfigTest(this,'+noOfConfig+');">';
				tempStr+='</td>';
				tempStr+='<td class="font_normal11" id="configTestDisplay'+noOfConfig+'" ondblclick="javascript:editConfigMeasure('+noOfConfig+');">'+measureSelect.options[i].text+'</td>';
				tempStr+='</tr>';
				tempStr+='<input id="hidConfigTstMeasure'+noOfConfig+'" type="hidden" value="'+values+'"/>';
				tempStr+='<input id="hidConfigMeasureMaping'+noOfConfig+'" type="hidden" value="'+measureSelect.options[i].text+'"/>';
				var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomDashController?")%>'+"compType="+compType+"&key=config&value="+values+"&profileName=<%=profileName%>&action=addMeasure";

				noOfConfig++;
				configaddedmeasure++;
				updateIniFile(url);
				if(configTestMeasuresHid!=null && configTestMeasuresHid!="undefined")
				{
					if(configTestMeasuresHid.value=="")
						configTestMeasuresHid.value=values;
					else
						configTestMeasuresHid.value=configTestMeasuresHid.value+","+values;
				}
			}
			
		}
		tempStr+='</table></div>';
		
		if((configaddedmeasure!=null && configaddedmeasure==0) && (existingmeasuresCount!=null && existingmeasuresCount==0))
		{
			alert("<egui:intnl text='monitor.dashboard.Please select a measure' />");
			return;
		}

		if(contentDiv!=null)
		{
			if(configConfigImg!=null && configConfigImg.style.display=="none")
			{
				contentDiv.innerHTML=tempStr;
				configConfigImg.style.display="block";
			}
			else if(configConfigImg!=null && configConfigImg.style.display=="block")
			{
				contentDiv.innerHTML+=tempStr;
			}
			if(flag)
				hideElement("propertyDiv");
		}

		if(values!=null && values.indexOf(",")!=-1)
			values=values.substring(0,values.length-1);
	}

	function editConfigMeasure(measureId)
	{
		var hidConfigTstMeasure=document.getElementById("hidConfigTstMeasure"+measureId);
		var hidConfigMeasureMaping=document.getElementById("hidConfigMeasureMaping"+measureId);
		var divConfig=document.getElementById("divConfig"+measureId);
		var configTestDisplay=document.getElementById("configTestDisplay"+measureId);

		if(hidConfigTstMeasure!=null && hidConfigMeasureMaping!=null && configTestDisplay.getElementsByTagName("input").length==0)
		{
			var tempStr=configTestDisplay.innerHTML;
			configTestDisplay.innerHTML='<input type="text" id="txtMapping" value="'+tempStr+'" onblur="javascript:updateConfigMeasure('+measureId+');"/>';

			var txtMapping=document.getElementById('txtMapping');
			if(txtMapping!=null)
				txtMapping.focus();
		}
	}

	function updateConfigMeasure(measureId)
	{
		var hidConfigTstMeasure=document.getElementById("hidConfigTstMeasure"+measureId);
		var hidConfigMeasureMaping=document.getElementById("hidConfigMeasureMaping"+measureId);
		var divConfig=document.getElementById("divConfig"+measureId);
		var txtMapping=document.getElementById('txtMapping');
		var configTestDisplay=document.getElementById("configTestDisplay"+measureId);

		if(configTestDisplay!=null && txtMapping!=null)
		{
			configTestDisplay.innerHTML=txtMapping.value;
			hidConfigMeasureMaping.value=txtMapping.value;
		}
		var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomDashController?")%>'+"compType="+compType+"&key="+hidConfigTstMeasure.value+"&profileName=<%=profileName%>&action=editMeasure&value="+hidConfigMeasureMaping.value;
		updateIniFile(url);
	}

	function showThreshold(check)
	{
		if(check!=null)
		{
			var url="";
			if(check.checked)
				url='<%=response.encodeURL("/final/servlet/com.eg.egCustomDashController?")%>'+"compType="+compType+"&key=ApplyThreshold&value=yes&profileName=<%=profileName%>&action=addMeasure";
			else
				url='<%=response.encodeURL("/final/servlet/com.eg.egCustomDashController?")%>'+"compType="+compType+"&key=ApplyThreshold&value=no&profileName=<%=profileName%>&action=addMeasure";

			updateIniFile(url);
		}
	}

	var noOfIndicators=<%=noOfInidicatiors%>+1;

	function loadMeasuerOnKPI(flag)
	{
		var testSelect=document.getElementById("testSelect");
		var measureSelect=document.getElementById("measureSelect");
		var contentDiv=document.getElementById("contentDivKPI");
		var configKpiImg=document.getElementById("configKpiImg");
		var kpiaddedmeasure=0;
		var tempStr='';
		var kpiTestMeasuresHid=document.getElementById("kpiTestMeasuresHid");
		var existingkpimeasurecount=0;
		tempStr+='<div id="divKPI'+noOfIndicators+'" class="istamViewTable" style="padding:2px;border:0px solid #000000">';
		tempStr+='<table width="100%">';
		for(var i=0;i<measureSelect.options.length;i++)
		{
			if(measureSelect.options[i]!=null && measureSelect.options[i].selected)
			{
				var values=testSelect.value+":"+measureSelect.options[i].value;
				if(kpiTestMeasuresHid!=null && kpiTestMeasuresHid!="undefined")
				{
					var kpiHidVal=kpiTestMeasuresHid.value;
					if(kpiHidVal!=null && kpiHidVal.indexOf(values)!=-1)
					{
						existingkpimeasurecount++;
						continue;
					}
				}
				tempStr+='<tr>';
				tempStr+='<td style="width:20px"><input type="checkbox" checked class="eg_input" onclick="unloadKPITest(this,'+noOfIndicators+');"/></td>';
				tempStr+='<td ondblclick="javascript:editKPIMeasure('+noOfIndicators+');" id="kpiTestDisplay'+noOfIndicators+'">'+measureSelect.options[i].text+'</td>';
				tempStr+='</tr>';
				tempStr+='<input id="hidKpiTstMeasure'+noOfIndicators+'" type="hidden" value="'+values+'"/>';
				tempStr+='<input id="hidKpiMeasureMaping'+noOfIndicators+'" type="hidden" value="'+measureSelect.options[i].text+'"/>';
				var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomDashController?")%>'+"compType="+compType+"&key=Indicators&value="+values+"&profileName=<%=profileName%>&action=addMeasure";
				noOfIndicators++;
				kpiaddedmeasure++;
				updateIniFile(url);
				if(kpiTestMeasuresHid!=null && kpiTestMeasuresHid!="undefined")
				{
					if(kpiTestMeasuresHid.value=="")
						kpiTestMeasuresHid.value=values;
					else
						kpiTestMeasuresHid.value=kpiTestMeasuresHid.value+","+values;
				}
			}
		}
		tempStr+='</table></div>';
		if((kpiaddedmeasure!=null && kpiaddedmeasure==0) && (existingkpimeasurecount!=null && existingkpimeasurecount==0))
		{
			alert("<egui:intnl text='monitor.dashboard.Please select a measure' />");
			return;
		}

		if(contentDiv!=null)
		{
			if(configKpiImg!=null && configKpiImg.style.display=="none")
			{
				contentDiv.innerHTML=tempStr;
				configKpiImg.style.display="block";
			}
			else
				contentDiv.innerHTML+=tempStr;
			if(flag)
				hideElement("propertyDiv");
		}

		if(values!=null && values.indexOf(",")!=-1)
			values=values.substring(0,values.length-1);
	}

	function editKPIMeasure(measureId)
	{
		var hidKpiTstMeasure=document.getElementById("hidKpiTstMeasure"+measureId);
		var hidKpiMeasureMaping=document.getElementById("hidKpiMeasureMaping"+measureId);
		var divKPI=document.getElementById("divKPI"+measureId);
		var kpiTestDisplay=document.getElementById("kpiTestDisplay"+measureId);

		if(hidKpiTstMeasure!=null && hidKpiMeasureMaping!=null && kpiTestDisplay.getElementsByTagName("input").length==0)
		{
			var tempStr=kpiTestDisplay.innerHTML;
			kpiTestDisplay.innerHTML='<input type="text" id="txtMapping" value="'+tempStr+'" onblur="javascript:updateKPIMeasure('+measureId+');"/>';

			var txtMapping=document.getElementById('txtMapping');
			if(txtMapping!=null)
				txtMapping.focus();
		}
	}

	function updateKPIMeasure(measureId)
	{
		var hidKpiTstMeasure=document.getElementById("hidKpiTstMeasure"+measureId);
		var hidKpiMeasureMaping=document.getElementById("hidKpiMeasureMaping"+measureId);
		var divKPI=document.getElementById("divKPI"+measureId);
		var txtMapping=document.getElementById('txtMapping');
		var kpiTestDisplay=document.getElementById("kpiTestDisplay"+measureId);

		if(kpiTestDisplay!=null && txtMapping!=null)
		{
			kpiTestDisplay.innerHTML=txtMapping.value;
			hidKpiMeasureMaping.value=txtMapping.value;
		}

		var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomDashController?")%>'+"compType="+compType+"&key="+hidKpiTstMeasure.value+"&profileName=<%=profileName%>&action=editMeasure&value="+hidKpiMeasureMaping.value;

		updateIniFile(url);
	}

	function changeProfile()
	{
		var profileSelect=document.getElementById("profileSelect");
		if(profileSelect!=null)
		{
			var url='<%=response.encodeURL("/final/monitor/egDesignDashboard.jsp?")%>'+"profileName="+profileSelect.value;
			window.location.href=url;
		}
	}

	function testOnSelect()
	{
		var testSelect=document.getElementById("testSelect");
		var graphType=document.getElementById("graphType");
		var from=document.getElementById("from");
		var mgraphTimeSelect=document.getElementById("mgraphTimeSelect");
		var measureGraphDuration="";
		if(mgraphTimeSelect!=null)
			measureGraphDuration=mgraphTimeSelect.value;
		if(testSelect!=null)
		{
			var selectedTest=testSelect.value;
			var url='<%=response.encodeURL("/final/monitor/egDashboardProperties.jsp?")%>'+"compType="+compType+"&test="+selectedTest+"&graphType="+graphType.value+"&from="+from.value+"&profileName=<%=profileName%>&measureGraphDuration="+measureGraphDuration;

			loadPropertyPage(url,'propertyContentDiv','event','');
		}
	}
	function changeMeasuresForDD()
	{
		var testSelect=document.getElementById("testSelect");
		var measureSelect=document.getElementById("measureSelect");
		var from=document.getElementById("from");
		if(testSelect!=null && measureSelect!=null)
		{
			var selectedTest=testSelect.value;
			var url='<%=response.encodeURL("/final/monitor/egDashboardProperties.jsp?")%>'+"compType="+compType+"&test="+selectedTest+"&selectedMeasure="+measureSelect.value+"&from="+from.value+"&profileName=<%=profileName%>";

			loadPropertyPage(url,'propertyContentDiv','event','');
		}
	}

	function saveDDComparisonTableConfig(fromRemoveTable)
	{
		var testSelect=document.getElementById("testSelect");
		var measureSelect=document.getElementById("measureSelect");
		var ddColumnsList=document.getElementById("ddColumnsList");
		var values='';
		var header=document.getElementById('header'+upDateingDivId);
		var contentDiv=document.getElementById('contentDiv'+upDateingDivId);

		var hidTest=document.getElementById('hidTest'+upDateingDivId);
		var hidTestDDMeasure=document.getElementById('hidTestDDMeasure'+upDateingDivId);
		var hidTestMapping=document.getElementById('hidTestMapping'+upDateingDivId);

		var tableStr='<table cellspacing="0" cellpadding="2" class="tableborder_jvm"  border="0" width="100%">';

		var isInfoBased=isInfoBasedTest(testSelect!=null && testSelect!="undefined" && testSelect.value);
		var tableEmptyRow="";
		var columnCount=0;
		tableStr+='<tr>';

		var measureaddedCount=0;
		
		if(ddColumnsList!=null && ddColumnsList!="undefined")
		{
			values=testSelect.value+":"+measureSelect.value+"|";
			for(var i=0;i<ddColumnsList.options.length;i++)
			{
				if(ddColumnsList.options[i]!=null && ddColumnsList.options[i].selected)
				{
						tableStr+='<td id="divTable'+upDateingDivId+'Column'+columnCount+'" class="tdborder2_jvm">'
								tableStr+='<table cellpadding="0" cellspacing="0" border="0" width="100%">';
									tableStr+='<thead>';
									tableStr+='<tr>';
									values+=ddColumnsList.options[i].value+",";
									tableStr+='<th width="20px" class="font_bold11"><input type="checkbox" checked class="eg_input" onclick="javascript:unloadTableMeasure('+upDateingDivId+','+columnCount+',\'ddcomparisontable\');"/></th>';
									tableStr+='<th class="font_bold11" id="table'+upDateingDivId+'Column'+columnCount+'" ondblclick="editTableHeader('+upDateingDivId+','+columnCount+',\'ddcomparisontable\');">'+ddColumnsList.options[i].text+'</th>';
									tableStr+='<input type="hidden" id="hidTable'+upDateingDivId+'Column'+columnCount+'TstMsr" value="'+ddColumnsList.options[i].value+'"/>';
									tableStr+='<input type="hidden" id="hidTable'+upDateingDivId+'Column'+columnCount+'TstMsrMaping" value="'+ddColumnsList.options[i].text+'"/>';
									tableStr+='</tr>';
									tableStr+='</thead>';
								tableStr+='</table>';
						tableStr+='</td>';
					columnCount++;
					measureaddedCount++;
					if(!fromRemoveTable && measureaddedCount==11)
					{
						alert("<egui:intnl text='monitor.dashboard.You are allow to configure maximum 10 measures' />");
						return;
					}
				}
			}
			tableStr+='</tr>';
			tableStr+='</table>';
			tableStr+='</div>';
		}

		
		if(!fromRemoveTable && (measureaddedCount!=null && measureaddedCount==0))
		{
			alert("<egui:intnl text='monitor.dashboard.Please select a measure' />");
			return;
		}
		else if(fromRemoveTable)
		{
			hideElement('propertyDiv');
			return;
		}
			tableStr+='</td>';
		tableStr+='</tr>'

		if(header!=null && contentDiv!=null)
		{
			header.innerHTML=testSelect.options[testSelect.selectedIndex].text;
			contentDiv.innerHTML=tableStr;

			hidTest.value=testSelect.value;
			hidTestDDMeasure.value=measureSelect.value;
			hidTestMapping=testSelect.options[testSelect.selectedIndex].text;
		}

		if(values!=null && values.indexOf(",")!=-1)
			values=values.substring(0,values.length-1);

		var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomDashController?")%>'+"compType="+compType+"&key=DDComparisonTables&value="+encodeURIComponent(values)+"&action=addTableMeasure&profileName=<%=profileName%>";
		updateIniFile(url);
		hideElement('propertyDiv');
	}

	function loadMeasureOnTable(fromRemoveTable)
	{
		var testSelect=document.getElementById("testSelect");
		var measureSelect=document.getElementById("measureSelect");
		var values='';
		var header=document.getElementById('header'+upDateingDivId);
		var contentDiv=document.getElementById('contentDiv'+upDateingDivId);

		var hidTest=document.getElementById('hidTest'+upDateingDivId);
		var hidTestMapping=document.getElementById('hidTestMapping'+upDateingDivId);

		var tableStr='<table cellspacing="0" cellpadding="2" class="tableborder_jvm"  border="0" width="100%">';

		var isInfoBased=isInfoBasedTest(testSelect!=null && testSelect!="undefined" && testSelect.value);
		var tableEmptyRow="";
		var columnCount=0;

		if(isInfoBased)
		{
			tableStr+='<tr>';
			tableStr+='<td class="font_bold11 tdborder2_jvm"  ><div id="tableInfo'+upDateingDivId+'" ondblclick="editTableInfo('+upDateingDivId+');">Info</div>';
			tableStr+='<input type="hidden" id="hidTableInfo'+upDateingDivId+'" value="'+testSelect.value+'"/>';
			tableStr+='<input type="hidden" id="hidTableInfoMapping'+upDateingDivId+'" value="Info"/>';
			tableStr+='</td>';

			tableEmptyRow='<tr>';
		}
		else
		{
			tableStr+='<tr>';
				tableStr+='<td >'
		}
		var measureaddedCount=0;
		if(measureSelect!=null && measureSelect!="undefined")
		{
			for(var i=0;i<measureSelect.options.length;i++)
			{
				if(measureSelect.options[i]!=null && measureSelect.options[i].selected)
				{
					values+=testSelect.value+":"+measureSelect.options[i].value+",";
					if(isInfoBased)
					{
						tableStr+='<td id="divTable'+upDateingDivId+'Column'+columnCount+'" class="font_bold11 tdborder2_jvm">';
						tableStr+='<table border="0" cellspacing="0" cellpadding="0">';
						tableStr+='<thead>';
						tableStr+='<tr>';
						tableStr+='<th class="font_bold11 padding4">';
						tableStr+='<input type="checkbox" checked class="eg_input" onclick="javascript:unloadTableMeasure('+upDateingDivId+','+columnCount+',\'comparisontable\');"/>';
						tableStr+='</th>';
						tableStr+='<th class="font_bold11 padding4">';
						tableStr+='<div id="table'+upDateingDivId+'Column'+columnCount+'" ondblclick="editTableHeader('+upDateingDivId+','+columnCount+',\'comparisontable\');">'+measureSelect.options[i].text+'</div></th>';
						tableStr+='</tr>';
						tableStr+='</thead>';
						tableStr+='</table>';
						tableStr+='</td>';
						tableEmptyRow+='<td class="font_normal11">';
						tableEmptyRow+='<input type="hidden" id="hidTable'+upDateingDivId+'Column'+columnCount+'TstMsr" value="'+testSelect.value+':'+measureSelect.options[i].value+'"/>';
						tableEmptyRow+='<input type="hidden" id="hidTable'+upDateingDivId+'Column'+columnCount+'TstMsrMaping" value="'+measureSelect.options[i].text+'"/>';
						tableEmptyRow+='</td>';
					}
					else
					{
						tableStr+='<div id="divTable'+upDateingDivId+'Column'+columnCount+'" style="padding:2px;border:0px solid #000000">';
						tableStr+='<table cellpadding="0" cellspacing="0" border="0" width="100%">';
						tableStr+='<tr>';
						tableStr+='<td width="20px" class="font_normal11"><input type="checkbox" checked class="eg_input" onclick="javascript:unloadTableMeasure('+upDateingDivId+','+columnCount+',\'comparisontable\');"/></td>';
						tableStr+='<td id="table'+upDateingDivId+'Column'+columnCount+'" ondblclick="editTableHeader('+upDateingDivId+','+columnCount+',\'comparisontable\');">'+measureSelect.options[i].text+'</td>';
						tableStr+='<td><img src="/final/servlet/com.egurkha.monitor.egSparkLineGraph?width=100&height=18&data=0,0,0,0,0"/></td>';
						tableStr+='<td>-</td>';
						tableStr+='</tr>';
						tableStr+='</table>';
						tableStr+='<input type="hidden" id="hidTable'+upDateingDivId+'Column'+columnCount+'TstMsr" value="'+testSelect.value+':'+measureSelect.options[i].value+'"/>';
						tableStr+='<input type="hidden" id="hidTable'+upDateingDivId+'Column'+columnCount+'TstMsrMaping" value="'+measureSelect.options[i].text+'"/>';
						tableStr+='</div>';
					}

					columnCount++;
					measureaddedCount++;
					
				if(!fromRemoveTable && measureaddedCount==11)
				{
					alert("<egui:intnl text='monitor.dashboard.You are allow to configure maximum 10 measures' />");
					return;
				}
				}
			}
		}

		
		if(!fromRemoveTable && (measureaddedCount!=null && measureaddedCount==0))
		{
			alert("<egui:intnl text='monitor.dashboard.Please select a measure' />");
			return;
		}
		else if(fromRemoveTable)
		{
			hideElement('propertyDiv');
			return;
		}

		if(isInfoBased)
		{
			tableEmptyRow+='</tr>';
			tableStr+='</tr>'+tableEmptyRow+'</table>';
		}
		else
		{
				tableStr+='</td>';
			tableStr+='</tr>'
		}

		if(header!=null && contentDiv!=null)
		{
			header.innerHTML=testSelect.options[testSelect.selectedIndex].text;
			contentDiv.innerHTML=tableStr;

			hidTest.value=testSelect.value;
			hidTestMapping=testSelect.options[testSelect.selectedIndex].text;
		}

		if(values!=null && values.indexOf(",")!=-1)
			values=values.substring(0,values.length-1);

		var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomDashController?")%>'+"compType="+compType+"&key=tables&value="+values+"&action=addTableMeasure&profileName=<%=profileName%>";
		updateIniFile(url);
		hideElement('propertyDiv');
	}

	function editTableHeader(divId,HeaderId,tableType)
	{
		var header=document.getElementById('table'+divId+'Column'+HeaderId);
		var testMeasure=document.getElementById('hidTable'+divId+'Column'+HeaderId+'TstMsr');
		var testMeasureMapping=document.getElementById('hidTable'+divId+'Column'+HeaderId+'TstMsrMaping');

		if(header!=null && header.getElementsByTagName("input").length==0)
		{
			var tempStr=header.innerHTML;

			header.innerHTML='<input type="text" class="egInputText" id="txtMapping'+divId+'" value="'+tempStr+'" onblur="javascript:updateTableHeader('+divId+','+HeaderId+',\''+tableType+'\');"/>';

			var txtMapping=document.getElementById('txtMapping'+divId);
			if(txtMapping!=null)
				txtMapping.focus();
		}
	}

	function editTableInfo(divId)
	{
		var tableInfo=document.getElementById('tableInfo'+divId);
		var hidTableInfo=document.getElementById('hidTableInfo'+divId);
		var hidTableInfoMapping=document.getElementById('hidTableInfoMapping'+divId);

		if(tableInfo!=null && tableInfo.getElementsByTagName("input").length==0)
		{
			var tempStr=tableInfo.innerHTML;
			tableInfo.innerHTML='<input type="text" class="egInputText" id="txtMapping'+divId+'" value="'+tempStr+'" onblur="javascript:updateTableInfo('+divId+');"/>';

			var txtMapping=document.getElementById('txtMapping'+divId);
			if(txtMapping!=null)
				txtMapping.focus();
		}
	}

	function updateTableInfo(divId)
	{
		var tableInfo=document.getElementById('tableInfo'+divId);
		var hidTableInfo=document.getElementById('hidTableInfo'+divId);
		var hidTableInfoMapping=document.getElementById('hidTableInfoMapping'+divId);
		var txtMapping=document.getElementById('txtMapping'+divId);

		if(txtMapping!=null && tableInfo!=null)
		{
			hidTableInfoMapping.value=txtMapping.value;
			tableInfo.innerHTML=txtMapping.value;
		}
		var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomDashController?")%>'+"compType="+compType+"&key="+hidTableInfo.value+"&profileName=<%=profileName%>&action=editTableInfo&value="+hidTableInfoMapping.value;
		updateIniFile(url);
	}

	function updateTableHeader(divId,HeaderId,tableType)
	{
		var header=document.getElementById('table'+divId+'Column'+HeaderId);
		var testMeasure=document.getElementById('hidTable'+divId+'Column'+HeaderId+'TstMsr');
		var testMeasureMapping=document.getElementById('hidTable'+divId+'Column'+HeaderId+'TstMsrMaping');
		var txtMapping=document.getElementById('txtMapping'+divId);

		if(txtMapping!=null && header!=null)
		{
			testMeasureMapping.value=txtMapping.value;
			header.innerHTML=txtMapping.value;
		}
		var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomDashController?")%>'+"compType="+compType+"&profileName=<%=profileName%>&value="+testMeasureMapping.value;
		if(tableType!=null && tableType=="ddcomparisontable")
		{
			var ddColVal=testMeasure.value;
			if(ddColVal!=null && ddColVal.indexOf(":")>0)
				ddColVal=ddColVal.substr(ddColVal.indexOf(":")+1,ddColVal.length);
			url=url+"&key="+encodeURIComponent(ddColVal)+"&action=editDDComparisonTableMeasure";
		}
		else
		{
			url=url+"&key="+testMeasure.value+"&action=editTableMeasure";
		}
		updateIniFile(url);
	}

	function measureOnSelect()
	{
		var graphType=document.getElementById("graphType");
		var testSelect=document.getElementById("testSelect");
		var measureSelect=document.getElementById("measureSelect");
		var header=document.getElementById('header'+upDateingDivId);

		var hidTestMsr=document.getElementById('hidTestMsr'+upDateingDivId);
		var hidTestMsrMapping=document.getElementById('hidTestMsrMapping'+upDateingDivId);


		if(graphType!=null && graphType!="undefined")
		{
			var selGraphTyp=graphType.value;
			var testMeasureVal=testSelect.value+":"+measureSelect.value;
			if(selGraphTyp!=null && selGraphTyp.toLowerCase()=="comparision")
			{
				var comparisonGraphHid=document.getElementById("comparisonGraphHid");
				if(comparisonGraphHid!=null && comparisonGraphHid!="undefined" && measureSelect.value!=-5)
				{
				var compGraphHidVal=comparisonGraphHid.value;
				var existinggraphhid=compGraphHidVal.split(",");
				for(var v=0;v<existinggraphhid.length;v++)
				{
					var existgraphid=existinggraphhid[v];
					if(compGraphHidVal!=null && existgraphid==testMeasureVal)
					{
						alert("<egui:intnl text='monitor.dashboard.This measure is already configured '/>!");
						return;
					}
				}
					//var comparisonGraphHidVal=comparisonGraphHid.value;
					if(compGraphHidVal!=null && compGraphHidVal=="")
						comparisonGraphHid.value=testMeasureVal;
					else if(compGraphHidVal!=null)
						comparisonGraphHid.value=compGraphHidVal+","+testMeasureVal;

				}				
			}
			else if(selGraphTyp!=null && selGraphTyp.toLowerCase()=="history")
			{
				var historyGraphHid=document.getElementById("historyGraphHid");
				if(historyGraphHid!=null && historyGraphHid!="undefined" && measureSelect.value!=-5)
				{
					var historyGraphHidVal=historyGraphHid.value;
					var existinggraphhishid=historyGraphHidVal.split(",");
					for(var v=0;v<existinggraphhishid.length;v++)
					{
						var existgraphhishid=existinggraphhishid[v];
						if(existgraphhishid!=null && existgraphhishid==testMeasureVal)
						{
							alert("<egui:intnl text='monitor.dashboard.This measure is already configured '/>!");
							return;
						}
					}

					if(historyGraphHidVal!=null && historyGraphHidVal=="")
						historyGraphHid.value=testMeasureVal;
					else if(historyGraphHidVal!=null)
						historyGraphHid.value=historyGraphHidVal+","+testMeasureVal;
				}
			}
			else if(selGraphTyp!=null && selGraphTyp.toLowerCase()=="dial")
			{
				var dialGraphHid=document.getElementById("dialGraphHid");
				if(dialGraphHid!=null && dialGraphHid!="undefined" && measureSelect.value!=-5 )
				{
					var dialGraphHidVal=dialGraphHid.value;
					var existinggraphdialhid=dialGraphHidVal.split(",");
					for(var v=0;v<existinggraphdialhid.length;v++)
					{
						var existgraphdialhid=existinggraphdialhid[v];
						if(existgraphdialhid!=null && existgraphdialhid==testMeasureVal)
						{
							alert("<egui:intnl text='monitor.dashboard.This measure is already configured '/>!");
							return;
						}
					}

					if(dialGraphHidVal!=null && dialGraphHidVal=="")
						dialGraphHid.value=testMeasureVal;
					else if(dialGraphHidVal!=null)
						dialGraphHid.value=dialGraphHidVal+","+testMeasureVal;
				}
			}
			else if(selGraphTyp!=null && selGraphTyp.toLowerCase()=="digital")
			{
				var digitalGraphHid=document.getElementById("digitalGraphHid");
				if(digitalGraphHid!=null && digitalGraphHid!="undefined" && measureSelect.value!=-5)
				{
					var digitalGraphHidVal=digitalGraphHid.value;
					var existinggraphdighid=digitalGraphHidVal.split(",");
					for(var v=0;v<existinggraphdighid.length;v++)
					{
						var existgraphdighid=existinggraphdighid[v];

						if(existgraphdighid!=null && existgraphdighid==testMeasureVal)
						{
							alert("<egui:intnl text='monitor.dashboard.Metric already configured'/>!");
							return;
						}
					}

					if(digitalGraphHidVal!=null && digitalGraphHidVal=="")
						digitalGraphHid.value=testMeasureVal;
					else if(digitalGraphHidVal!=null)
						digitalGraphHid.value=digitalGraphHidVal+","+testMeasureVal;
				}
			}
		}

		if(testSelect!=null && measureSelect!=null)
		{
			if(measureSelect.value=="-5")
			{
				alert("<egui:intnl text='monitor.dashboard.Please select a measure' />");
				return;
			}
			if(hidTestMsr !=null && graphType !=null)
			{
				var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomDashController?")%>'+"compType="+compType+"&key="+graphType.value+"&profileName=<%=profileName%>&action=deleteIniValue&value="+hidTestMsr.value;
				hideElement("propertyDiv");
				updateIniFile(url);
			}
			var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomDashController?")%>'+"compType="+compType+"&key="+graphType.value+"&profileName=<%=profileName%>&action=addMeasure&value="+testSelect.value+":"+measureSelect.value;
			header.innerHTML=measureSelect.options[measureSelect.selectedIndex].text;

			hidTestMsr.value=testSelect.value+":"+measureSelect.value;
			hidTestMsrMapping.value=measureSelect.options[measureSelect.selectedIndex].text;

			updateIniFile(url);
		}
	}

	function editHeader(divId,graphType)
	{
		var header=document.getElementById('header'+divId);

		if(header!=null && header.getElementsByTagName("input").length==0)
		{
			var tempStr=header.innerHTML;
			header.innerHTML='<input type="text" id="txtMapping'+divId+'" value="'+tempStr+'" onblur="javascript:updateMeasureMapping('+divId+',\''+graphType+'\');"/>';
			var txtMapping=document.getElementById('txtMapping'+divId);
			if(txtMapping!=null)
				txtMapping.focus();
		}
	}

	function updateMeasureMapping(divId,graphType)
	{
		var header=document.getElementById('header'+divId);
		var hidTestMsr=document.getElementById('hidTestMsr'+divId);
		var hidTestMsrMapping=document.getElementById('hidTestMsrMapping'+divId);
		var txtMapping=document.getElementById('txtMapping'+divId);
		var action="";
		if(graphType=="comparision")
			action="editCompGraphMeasure";
		else if(graphType=="dial" || graphType=="digital"  || graphType=="history")
			action="editMeasure";
		if(txtMapping!=null)
		{
			hidTestMsrMapping.value=txtMapping.value;
			header.innerHTML=txtMapping.value;
		}
		var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomDashController?")%>'+"compType="+compType+"&key="+hidTestMsr.value+"&profileName=<%=profileName%>&action="+action+"&value="+hidTestMsrMapping.value;
		updateIniFile(url);
	}


	function updateIniFile(url)
	{
		var xmlHTTP=GetXmlHttpObject();
		if(xmlHTTP!=null)
		{
			xmlHTTP.onreadystatechange = function ()
			{
				if(xmlHTTP.readyState==4)
				{
					if(xmlHTTP.status == 200)
					{
						xmlHTTP=null;
					}
				}
			}
			xmlHTTP.open("GET",url,false);
			xmlHTTP.send(null);
		}
	}

	function enableBlocks(divId,block)
	{
		var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomDashController?")%>'+"compType="+compType+"&key=enabled_block&profileName=<%=profileName%>&action=addMeasure&value="+block;
		var kpiTestMeasuresHid=document.getElementById("kpiTestMeasuresHid");
		if(block=="Indicators")
		{
			var contentDivKPI=document.getElementById("contentDivKPI");
			var configKpiImg=document.getElementById("configKpiImg");

			if(contentDivKPI!=null)
			{
				if(configKpiImg!=null && configKpiImg.style.display=="block")
				{
					if(kpiTestMeasuresHid!=null && kpiTestMeasuresHid!="undefined")
						kpiTestMeasuresHid.value="";
				}
				contentDivKPI.innerHTML='<table border="0" cellpadding="0" cellspacing="0" width="100%" height="98%"><tr><td width="100%" height="100%" align="center" valign="middle" class="font_bold11 mouse" style="border:0px" onclick="loadTestOnKPI(event)"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_kpi_big.png" /><br><br><egui:intnl text="monitor.dashboard.Please Click here to Configure"/></td></tr></table>';
				configKpiImg.style.display="none";
			}
		}

		if(block=="config")
		{
			var contentDivConfig=document.getElementById("contentDivConfig");
			var configConfigImg=document.getElementById("configConfigImg");
			var confiTestMeasuresHid=document.getElementById("configTestMeasuresHid");
			if(contentDivConfig!=null)
			{
				if(configConfigImg!=null && configConfigImg.style.display=="block")
				{
					if(configTestMeasuresHid!=null && configTestMeasuresHid!="undefined")
						configTestMeasuresHid.value="";
				}
				contentDivConfig.innerHTML='<table border="0" cellpadding="0" cellspacing="0" width="100%" height="98%"><tr><td width="100%" height="100%" align="center" valign="middle" class="font_bold11 mouse" style="border:0px" onclick="loadTestOnConfig(event)"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_config_big.png"/> <br><br><egui:intnl text="monitor.dashboard.Please Click here to Configure"/></td></tr></table>';
				configConfigImg.style.display="none";
			}
		}

		updateIniFile(url);
		showElement(divId);
	}

	function init()
	{
		var s_enabledBlocks="<%=s_enabledBlocks%>";
		var arrEnabled=s_enabledBlocks.split(",");
		for(var i=0;i<arrEnabled.length;i++)
		{
			var enabledBlock=arrEnabled[i];

			if(enabledBlock=='currentAlerts')
				showElement('currentAlertDiv');
			else if(enabledBlock=='eventHistory')
				showElement('eventHistoryDiv');
			else if(enabledBlock=='health')
				showElement('healthDiv');
			else if(enabledBlock=='Indicators')
				showElement('kpiDiv');
			else if(enabledBlock=='config')
				showElement('configDiv');
		}
		myResize();
	}

	function disableBlocks(divId,block)
	{
		var kpiTestMeasuresHid=document.getElementById("kpiTestMeasuresHid");
		var configTestMeasuresHid=document.getElementById("configTestMeasuresHid");
		if(kpiTestMeasuresHid!=null && kpiTestMeasuresHid!="undefined" && (block!=null && block=="Indicators"))
		{
			kpiTestMeasuresHid.value="";
		}
		if(configTestMeasuresHid!=null && configTestMeasuresHid!="undefined" && (block!=null && block=="config"))
		{
			configTestMeasuresHid.value="";
		}
		var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomDashController?")%>'+"compType="+compType+"&action=deleteBlock&key=enabled_block&profileName=<%=profileName%>&value="+block;
		hideElement(divId);
		hideElement('propertyDiv');
		updateIniFile(url);
	}

	function removeGraph(divCount,graphType)
	{
		var div=document.getElementById("div"+divCount);
		var hidTestMsr=document.getElementById("hidTestMsr"+divCount);
		var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomDashController?")%>'+"compType="+compType+'&key='+graphType+'&action=deleteBlock&profileName=<%=profileName%>&value='+hidTestMsr.value;
		if(graphType!=null && graphType.toLowerCase()=="comparision")
		{
			var comparisonGraphHid=document.getElementById("comparisonGraphHid");
			var tempCompTestMeasures="";
			if(comparisonGraphHid!=null && comparisonGraphHid!="undefined")
			{
				var compgraphs=comparisonGraphHid.value;
				var existingCompGraphs=compgraphs.split(",");
				for(var v=0;v<existingCompGraphs.length;v++)
				{
					var compGraphTestMeasure=existingCompGraphs[v];
					if(compGraphTestMeasure!=null && compGraphTestMeasure!=hidTestMsr.value)
					{
						if(tempCompTestMeasures!=null && tempCompTestMeasures=="")
							tempCompTestMeasures=compGraphTestMeasure;
						else
							tempCompTestMeasures=tempCompTestMeasures+","+compGraphTestMeasure;
					}

				}
				comparisonGraphHid.value=tempCompTestMeasures;
			}
		}
		else if(graphType!=null && graphType.toLowerCase()=="history")
		{
			var historyGraphHid=document.getElementById("historyGraphHid");
			var tempHistoryTestMeasures="";
			if(historyGraphHid!=null && historyGraphHid!="undefined")
			{
				var historygraphs=historyGraphHid.value;
				var existingHistoryGraphs=historygraphs.split(",");
				for(var v=0;v<existingHistoryGraphs.length;v++)
				{
					var historyGraphTestMeasure=existingHistoryGraphs[v];
					if(historyGraphTestMeasure!=null && historyGraphTestMeasure!=hidTestMsr.value)
					{
						if(tempHistoryTestMeasures!=null && tempHistoryTestMeasures=="")
							tempHistoryTestMeasures=historyGraphTestMeasure;
						else
							tempHistoryTestMeasures=tempHistoryTestMeasures+","+historyGraphTestMeasure;
					}

				}
				historyGraphHid.value=tempHistoryTestMeasures;
			}

		}
		else if(graphType!=null && graphType.toLowerCase()=="dial")
		{
			var dialGraphHid=document.getElementById("dialGraphHid");
			var tempDialTestMeasures="";
			if(dialGraphHid!=null && dialGraphHid!="undefined")
			{
				var dialgraphs=dialGraphHid.value;
				var existingDialGraphs=dialgraphs.split(",");
				for(var v=0;v<existingDialGraphs.length;v++)
				{
					var dialGraphTestMeasure=existingDialGraphs[v];
					if(dialGraphTestMeasure!=null && dialGraphTestMeasure!=hidTestMsr.value)
					{
						if(tempDialTestMeasures!=null && tempDialTestMeasures=="")
							tempDialTestMeasures=dialGraphTestMeasure;
						else
							tempDialTestMeasures=tempDialTestMeasures+","+dialGraphTestMeasure;
					}

				}
				dialGraphHid.value=tempDialTestMeasures;
			}

		}
		else if(graphType!=null && graphType.toLowerCase()=="digital")
		{
			var digitalGraphHid=document.getElementById("digitalGraphHid");
			var tempDigitalTestMeasures="";
			if(digitalGraphHid!=null && digitalGraphHid!="undefined")
			{
				var digitalgraphs=digitalGraphHid.value;
				var existingDigitalGraphs=digitalgraphs.split(",");
				for(var v=0;v<existingDigitalGraphs.length;v++)
				{
					var digitalGraphTestMeasure=existingDigitalGraphs[v];
					if(digitalGraphTestMeasure!=null && digitalGraphTestMeasure!=hidTestMsr.value)
					{
						if(tempDigitalTestMeasures!=null && tempDigitalTestMeasures=="")
							tempDigitalTestMeasures=digitalGraphTestMeasure;
						else
							tempDigitalTestMeasures=tempDigitalTestMeasures+","+digitalGraphTestMeasure;
					}

				}
				digitalGraphHid.value=tempDigitalTestMeasures;
			}

		}
		updateIniFile(url);
		hideElement("div"+divCount);
		hideElement('propertyDiv');
	}

	function removeTable(divCount,tableType)
	{
		var div=document.getElementById("div"+divCount);
		if(div!=null)
		{
			var hiddenElements=div.getElementsByTagName("input");
			var tableTestMeasures="";
			var columnCount=0;
			for(i=0;i<hiddenElements.length;i++)
			{
				if(hiddenElements[i]!=null && hiddenElements[i].value!="" && hiddenElements[i].id=="hidTable"+divCount+"Column"+columnCount+"TstMsr")
				{
					columnCount++;
					tableTestMeasures+=hiddenElements[i].value+",";
				}
			}

			if(tableTestMeasures!=null && tableTestMeasures.indexOf(",")!=-1)
				tableTestMeasures=tableTestMeasures.substring(0,tableTestMeasures.length-1);

			div.style.display="none";
			hideElement('propertyDiv');
			var selectedKey="";
			var removeTableValue="";
			if(tableType!=null && tableType=="ddcomparisontable")
			{
				selectedKey='DDComparisonTables';
				var hidTestDDMeasure=document.getElementById("hidTestDDMeasure"+divCount);
				var hidTest=document.getElementById("hidTest"+divCount);
				removeTableValue=hidTest.value+":"+hidTestDDMeasure.value+"|"+tableTestMeasures;
			}
			else
			{
				selectedKey="tables";
				removeTableValue=tableTestMeasures
			}

			var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomDashController?")%>'+"compType="+compType+'&key='+selectedKey+'&action=deleteTable&profileName=<%=profileName%>&value='+encodeURIComponent(removeTableValue);
			updateIniFile(url);
		}
	}

	function unloadConfigTest(checkbox,divId)
	{
		var hidConfigTstMeasure=document.getElementById("hidConfigTstMeasure"+divId);
		var divConfig=document.getElementById("divConfig"+divId);
		var configTestMeasuresHid=document.getElementById("configTestMeasuresHid");
		var existingConfigs="";
		var tempConfigS="";
		if(configTestMeasuresHid!=null &&configTestMeasuresHid!="undefined")
		{
			existingConfigs=configTestMeasuresHid.value;
			var existConfigs=existingConfigs.split(",");
			for(var k=0;k<existConfigs.length;k++)
			{
				var existConfig=existConfigs[k];
				if(existConfig!=null && existConfig==hidConfigTstMeasure.value)
					continue;
				if(existConfig!=null)
				{
					if(existConfig=="")
						tempConfigS=existConfig;
					else
						tempConfigS+=","+existConfig;
				}
			}
			configTestMeasuresHid.value=tempConfigS;
		}
		if(checkbox!=null && !checkbox.checked)
		{
			if(hidConfigTstMeasure!=null && divConfig!=null)
			{
				var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomDashController?")%>'+"compType="+compType+"&key=config&value="+hidConfigTstMeasure.value+"&profileName=<%=profileName%>&action=deleteMeasure";

				updateIniFile(url);
				divConfig.style.display="none";
			}
		}
	}

	function unloadTableMeasure(divId,columnId,tableType)
	{
		var measureDiv=document.getElementById("divTable"+divId+"Column"+columnId);
		var hidMeasure=document.getElementById("hidTable"+divId+"Column"+columnId+"TstMsr");
		var contentDiv=document.getElementById("contentDiv"+divId);
		var compTableDiv=document.getElementById("div"+divId);
		var tds=compTableDiv.getElementsByTagName("table")[0].getElementsByTagName("td");
		var isDDComparisonTable=false;
		if(hidMeasure!=null && measureDiv!=null)
		{
			var selectedKey='tables';
			var selectedAction='removeTableMeasure';
			var valueStr=hidMeasure.value;
			if(tableType!=null && tableType=="ddcomparisontable")
			{
				isDDComparisonTable=true;
				selectedKey='DDComparisonTables';
				selectedAction='removeDDComparisonTableMeasure';
				var hidTestDDMeasure=document.getElementById('hidTestDDMeasure'+divId);
				var hidTest=document.getElementById('hidTest'+divId);
				valueStr=hidTest.value+":"+hidTestDDMeasure.value+"|"+valueStr;
			}
			var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomDashController?")%>'+"compType="+compType+"&key="+selectedKey+"&value="+encodeURIComponent(valueStr)+"&profileName=<%=profileName%>&action="+selectedAction;
			updateIniFile(url);
			measureDiv.style.display="none";
		}
		if(tds!=null)
		{
			var emptyTDSCount=0;
			var divTableCount=0;
			for(var v=0;v<tds.length;v++)
			{
				var tdObj=tds[v];
				if(tdObj!=null && tdObj!="undefined")
				{
					var tdId=tdObj.id;
					if(isDDComparisonTable)
					{
						if(tdId!=null && tdId.indexOf("divTable")!=-1)
						{
							var tdDisp=document.getElementById(tdId);
							divTableCount++;
							if(tdDisp!=null && tdDisp!="undefined")
							{
								if(tdDisp.style.display=="none")
									emptyTDSCount++;
							}
						}
					}
					else
					{
						if(tdId!=null && tdId.indexOf("divTable")!=-1)
						{
							var tdDisp=document.getElementById(tdId);
							divTableCount++;
							if(tdDisp!=null && tdDisp!="undefined")
							{
								if(tdDisp.style.display=="none")
									emptyTDSCount++;
							}
						}
					}
				}				
			}
			if(emptyTDSCount==divTableCount)
			{
				removeTable(divId,tableType);
			}
		}
	}

	function unloadKPITest(checkbox,divId)
	{
		var hidKpiTstMeasure=document.getElementById("hidKpiTstMeasure"+divId);
		var divKPI=document.getElementById("divKPI"+divId);
		var kpiTestMeasuresHid=document.getElementById("kpiTestMeasuresHid");
		var existingKPIs="";
		var tempKPIS="";
		if(kpiTestMeasuresHid!=null && kpiTestMeasuresHid!="undefined")
		{
			existingKPIs=kpiTestMeasuresHid.value;
			var existkpis=existingKPIs.split(",");
			for(var k=0;k<existkpis.length;k++)
			{
				var existKPI=existkpis[k];
				if(existKPI!=null && existKPI==hidKpiTstMeasure.value)
					continue;
				if(existKPI!=null)
				{
					if(existKPI=="")
						tempKPIS=existKPI;
					else
						tempKPIS+=","+existKPI;
				}
			}
			kpiTestMeasuresHid.value=tempKPIS;
		}

		if(checkbox!=null && !checkbox.checked)
		{
			if(hidKpiTstMeasure!=null && divKPI!=null)
			{
				var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomDashController?")%>'+"compType="+compType+"&key=Indicators&value="+hidKpiTstMeasure.value+"&profileName=<%=profileName%>&action=deleteMeasure";

				updateIniFile(url);
				divKPI.style.display="none";
			}
		}
	}

	function eventHistTimeOnchange()
	{
		var eventHistTimeSelect=document.getElementById("eventHistTimeSelect");
		if(eventHistTimeSelect!=null)
		{
			var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomDashController?")%>'+"compType="+compType+"&key=duration&value="+eventHistTimeSelect.value+"&profileName=<%=profileName%>&action=editEventDuration";
			updateIniFile(url);
		}
	}


	function healthTimeOnchange()
	{
		var healthTimeSelect=document.getElementById("healthTimeSelect");
		if(healthTimeSelect!=null)
		{
			var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomDashController?")%>'+"compType="+compType+"&key=duration&value="+healthTimeSelect.value+"&profileName=<%=profileName%>&action=editHealthDuration";
			updateIniFile(url);
		}
	}

	function mgrahTimeChange()
	{
		var mgraphTimeSelect=document.getElementById("mgraphTimeSelect");
		if(mgraphTimeSelect!=null)
		{
			var url='<%=response.encodeURL("/final/servlet/com.eg.egCustomDashController?")%>'+"compType="+compType+"&key=duration&value="+mgraphTimeSelect.value+"&profileName=<%=profileName%>&action=editMeasureGraphDuration";
			updateIniFile(url);
		}
	}
	function customEnable()
	{
			alert("<egui:intnl text='monitor.dashboard.Please enable custom tab to view custom dashboard'/>");

	}

	function myResize()
	{
		var contentDiv=document.getElementById("contentDiv");
		if(contentDiv!=null)
		{
			contentDiv.style.height=document.body.clientHeight-40;
		}
	}

	window.onresize = myResize;

</script>
</head>
<body class="istam_eg_whitebg" style="overflow:hidden;margin:10px 10px 0px 10px" onload="javascript:init();" onmousemove="javascript:drag(event);" onmouseup="javascript:endDrag(event);" >

<div id="dummyDiv" style="display:none;width:200px;height:200px;position:absolute;">Dummy Div</div>
<iframe id="iframe1" name="iframe1" frameborder="0" width="0" height="0" style="display:none;position:absolute;z-index:10"></iframe>

<div id="propertyDiv" class="istam_toolsDiv" style="display:none;left:500px;top:100px;position:absolute;border:0px solid #ff0000;z-index:550;">
<table border="0" bordercolor="blue" cellpadding="0" cellspacing="0">
	<tr>
		<th  onmousedown="javascript:startDrag('propertyDiv',event);">
			<table border="0"  cellpadding="0" cellspacing="0" width="100%">
				<tr>
					<td id="GraphTitle" class="toolsHeader"><egui:intnl text="monitor.dashboard.Properties"/></td>
					<td align="right" class="toolsHeader"><img id="closeImg" src="/final/images/clear.png" class="iconClose3" border="0" class="mouse" title="close" onclick="javascript:hideElement('propertyDiv');"> </td>
				</tr>
			</table>
		</th>
	</tr>
	<tr>
		<td align="center" valign="top" class="firstTd" style="width:300px">
			<table border="0" bordercolor="green" cellpadding="0" cellspacing="0" width="100%" height="100%">
				<tr>
					<td align="center" style="width:300px">
						<div id="propertyContentDiv"></div>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</div>



<div id="toolsDiv" class="istam_toolsDiv" style="display:block;left:50px;top:30px;position:absolute;z-index:500;">
<table border="0" bordercolor="blue" cellpadding="0" cellspacing="0">
	<tr>
		<th width="100%" onmousedown="javascript:startDrag('toolsDiv',event);">
			<table border="0"  cellpadding="0" cellspacing="0" width="100%">
				<tr>
					<td id="GraphTitle" class="toolsHeader" >Tools</td>
					<td align="right" class="toolsHeader"><img src="/final/images/clear.png" class="iconClose3" border="0" class="mouse" title="close" onclick="javascript:hideToolBox('toolsDiv');"> </td>
				</tr>
			</table>
		</th>
	</tr>
	<tr>
		<td align="center" valign="top" class="firstTd">
			<table border="0" bordercolor="green" cellpadding="0" cellspacing="0" width="100%" height="100%">
				<tr>
					<td>
						<table  border="0" cellpadding="1" cellspacing="0">
							<tr>
								<td><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_alarm.png" title="Current Alerts" onmouseover="this.src='/final/monitor/eg_images/<%=monitor_Skin%>/icon_alarm_over.png'" onmouseout="this.src='/final/monitor/eg_images/<%=monitor_Skin%>/icon_alarm.png'" onclick="enableBlocks('currentAlertDiv','currentAlerts')"/></td>
								<td><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_eventhistory.png" onmouseover="this.src='/final/monitor/eg_images/<%=monitor_Skin%>/icon_eventhistory_over.png'" onmouseout="this.src='/final/monitor/eg_images/<%=monitor_Skin%>/icon_eventhistory.png'" title="Event History" onclick="enableBlocks('eventHistoryDiv','eventHistory')"/></td>
							</tr>
							<tr>
<%
		if(hasConfig)
		{
%>		
								<td><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_config.png" title="Configurations" onmouseover="this.src='/final/monitor/eg_images/<%=monitor_Skin%>/icon_config_over.png'" onmouseout="this.src='/final/monitor/eg_images/<%=monitor_Skin%>/icon_config.png'" onclick="enableBlocks('configDiv','config')"/></td>
<%
		}
		else
		{	
%>
								<td><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_config_disable.png" title="Configurations"/></td>
<%
		}
%>
								<td><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_kpi.png" onmouseover="this.src='/final/monitor/eg_images/<%=monitor_Skin%>/icon_kpi_over.png'" onmouseout="this.src='/final/monitor/eg_images/<%=monitor_Skin%>/icon_kpi.png'" title="Performance Indicators" onclick="enableBlocks('kpiDiv','Indicators')"/></td>
							</tr>
							<tr>
								<td><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_table.png" title="Comparison Table" onmouseover="this.src='/final/monitor/eg_images/<%=monitor_Skin%>/icon_table_over.png'" onmouseout="this.src='/final/monitor/eg_images/<%=monitor_Skin%>/icon_table.png'" onclick="drawTable('ComparisonTable')"/></td>
								<td><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_ddcomparision.png" title="DD Comparison Table" onmouseover="this.src='/final/monitor/eg_images/<%=monitor_Skin%>/icon_ddcomparision_over.png'" onmouseout="this.src='/final/monitor/eg_images/<%=monitor_Skin%>/icon_ddcomparision.png'" onclick="drawTable('DDComparisonTable')"/></td>
							</tr>
							<tr>
								<td><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_comparision.png" title="Comparison Chart" graphSrc="<%=s_comparisionURL%>" graphType="comparision" onmouseover="this.src='/final/monitor/eg_images/<%=monitor_Skin%>/icon_comparision_over.png'" onmouseout="this.src='/final/monitor/eg_images/<%=monitor_Skin%>/icon_comparision.png'" onclick="drawGraph(this)"/></td>
								<td><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_history.png" title="Timeline Chart" graphSrc="<%=s_historyURL%>" graphType="history" onmouseover="this.src='/final/monitor/eg_images/<%=monitor_Skin%>/icon_history_over.png'" onmouseout="this.src='/final/monitor/eg_images/<%=monitor_Skin%>/icon_history.png'" onclick="drawGraph(this)"/></td>
							</tr>
							<tr>
								<td><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_digital.png" title="Digital Chart" graphSrc="<%=s_digitalURL%>" graphType="digital" onmouseover="this.src='/final/monitor/eg_images/<%=monitor_Skin%>/icon_digital_over.png'" onmouseout="this.src='/final/monitor/eg_images/<%=monitor_Skin%>/icon_digital.png'" onclick="drawGraph(this)"/></td>
								<td><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_dial.png" title="Dial Chart" graphType="dial" graphSrc="<%=s_dialURL%>" onmouseover="this.src='/final/monitor/eg_images/<%=monitor_Skin%>/icon_dial_over.png'" onmouseout="this.src='/final/monitor/eg_images/<%=monitor_Skin%>/icon_dial.png'" onclick="drawGraph(this)"/></td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</div>




<div class="istam_layer_headbgNew">
	<table  border="0" width="100%" class="padding4" cellspacing="0" cellpadding="0">
	<col width="50"><col width="25%"><col width="120"><col width="60"><col width="100"><col width="30">
		<tr>
			<td class="padding4 font_normal11" nowrap><egui:intnl text="monitor.dashboard.Application"/>&nbsp;:</td>
			<td class="padding4 font_bold11"> <egui:intnl type="<%=compType%>"/></td>
			<td align="right" nowrap class="padding4 font_normal11"><egui:intnl text="monitor.dashboard.Template Name"/>&nbsp;:</td>
			<td align="left" nowrap class="padding4 font_bold11"><%=profileName%></td>
			<td align="center" style="padding:0px"><div id="iconBg" style="display:none;width:23px;height:19px"><img id="toolsImg" src="/final/monitor/eg_images/<%=monitor_Skin%>/spacer.gif" onclick="javascript:showToolBox();" title="Toolbox" border="0"/></div></td>
			<%
				if(!isCustomDashboard.equalsIgnoreCase("No"))
				{ 
					if(StringUtils.isNull(compName))
					{
						compName="";
					}
			%>
			<td style="padding:0px"><div style="padding-top:1px;padding-left:2px" > <a class="eg_monlink"  href='<%=response.encodeURL("/final/servlet/com.eg.EgDashboardController?")%>from=list&comptype=<%=compType%>&backtoDashBoard=true&tab=Custom&profileName=<%=EgURLEncoder.encode(profileName,"UTF-8")%>'><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_preview.png" border="0" onclick="javascript:showElement('toolsDiv');" title="Preview"/></a></div></td>
			<%
				}
			else
				{
			%>
			<td style="padding:0px"><div style="padding-top:1px;padding-left:2px" ><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_preview.png" border="0" onclick="javascript:customEnable();" title="Preview"/></a></div></td>
			<%
				}
			%>

			<td align="right">
				<div style="float:right;" class="istamBackButton"><a onClick='javascript:window.history.back();'><egui:intnl text="monitor.common.Back"/></a></div>
			</td>
		</tr>
	</table>
</div>

<div id="contentDiv" class="istam_div_scroll" style="margin-left:0px;margin-top:0px;width:100%;height:530px;border:0px solid red;">
	
	<div id="currentAlertDiv" style="margin-left:10px;margin-top:10px;float:left;width:24%;height:150px;border:0px solid blue;display:none">
		<table border="0" width="100%" cellpadding="2" cellspacing="0" height="100%" class="istam_vmborder">
			<tr>
				<td height="25px" width="100%" class="istam_data_headbg1" style="border-right-width:0px"> <egui:intnl text="monitor.dashboard.Current Alerts"/></td>
				<td class="istam_data_headbg1" style="border-right-width:0px"> <img class="mouse" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_close_div.png" onclick="disableBlocks('currentAlertDiv','currentAlerts')"/></td>
			</tr>
			<tr>
				<td height="100%" valign="middle" align="center" colspan="2" class="linetop">
					<table border="0" cellpadding="0" cellspacing="0">
						<tr>
							<td style="padding:10px 10px 5px 10px">
								<table  border="0" cellpadding="0" cellspacing="0" height="20px" >
									<tr>
									<td width="5"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_left.png" width="5" height="20"></td>
									<td width="90" class="font_normal11" background="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bg.png" width="75%" ><egui:intnl text="monitor.dashboard.Open Alerts"/></td>
									<td class="istamBarFont font_normal11" width="60" background="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bgdark.png" align="center" valign="middle" > - </td>												
									<td width="5"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bgdarkright.png" width="5" height="20"></td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td style="padding:5px 10px 10px 10px">
								<table  border="0" cellpadding="0" cellspacing="0" height="20px" >
									<tr>
										<tr>
											<td width="5"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_left.png" width="5" height="20"></td>
											<td width="90" class="font_normal11" background="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bg.png" width="75%" ><egui:intnl text="monitor.dashboard.Distribution"/></td>
											<td valign="middle" width="23" align="center" class="bar12_high istamBarFont font_normal11"> -</td>
											<td valign="middle" width="23" align="center" class="bar12_intermediate istamBarFont font_normal11"> - </td>
											<td valign="middle" width="23" align="center" class="bar12_low istamBarFont font_normal11"> - </td>
										</tr>
									</table>
							</td>
						</tr>
					</table>
				</tr>
			</td>
		</table>
	</div>

	<div id="eventHistoryDiv" style="display:none; margin-left:10px;margin-top:10px;float:left;width:48%;height:150px;border:0px solid green;">
	<table border="0" cellpadding="0" cellspacing="0" class="istam_vmborder" width="100%" bordercolor="red" height="100%">
		<tr>
			<td width="100%" class="istam_data_headbg1" align="left" height="25"><egui:intnl text="monitor.dashboard.History of Events during last"/> &nbsp;
<%
	String[] options =new String[] {"1 hour","3 hours","6 hours","9 hours","12 hours","15 hours","18 hours","21 hours","24 hours","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks","3 weeks","4 weeks","1 month","2 months"};
%>
				<select id="eventHistTimeSelect" onchange="javascript:eventHistTimeOnchange()" class="egInputSelect" style="width:80px">
<%
	for(int i=0;i<options.length;i++)
	{
		String option=options[i];
		String selected="";
		if(option!=null && option.equalsIgnoreCase(defaultEventHistTime))
			selected="selected";
%>
				<option value="<%=option%>" <%=selected%>><%=option%></option>
<%
	}
%>
				</select>
			</td>
			<td class="istam_data_headbg1" style="padding-right:4px;border-right-width:0px"><img class="mouse" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_close_div.png" onclick="disableBlocks('eventHistoryDiv','eventHistory')" border="0"/></td>
		</tr>
		<tr>
			<td colspan="2" class="linetop">
				<table border="0" cellpadding="0" cellspacing="0"  width="100%"><col width="50%"><col width="50%">
					<tr>
						<td id="HistoricalEventsBarChart" width="240" height="88" style="border-left-width:0px"> <a href="#" class="eg_monlink" border="0"> <img src="/final/monitor/eg_images/<%=monitor_Skin%>/eventhistory.png" border='0'> </a> </td>
						<td valign="middle" align="center">
							<table  border="0" cellpadding="2" cellspacing="0">
								<tr>
									<td style="padding:10px 10px 5px 10px">
										<table  border="0" cellpadding="0" cellspacing="0" height="20px" >
											<tr>
												<td width="5"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_left.png" width="5" height="20"></td>
												<td width="90" class="font_normal11" background="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bg.png" width="75%" >
												<egui:intnl text="monitor.dashboard.Total Events"/></td>
												<td class="istamBarFont font_normal11" width="60" background="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bgdark.png" align="center" valign="middle" > -  </td>
												<td width="5"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bgdarkright.png" width="5" height="20"></td>
											</tr>
										</table>
									</td>
								</tr>
								<tr>
									<td style="padding:5px 10px 5px 10px">
										<table  border="0" cellpadding="0" cellspacing="0" height="20px" >
											<tr>
												<td width="5"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_left.png" width="5" height="20"></td>
												<td width="90" class="font_normal11" background="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bg.png" width="75%" >
												<egui:intnl text="monitor.dashboard.Avg Duration"/></td>
												<td class="istamBarFont font_normal11" width="60" background="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bgdark.png" align="center" valign="middle" > - </td>
												<td width="5"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bgdarkright.png" width="5" height="20"></td>
											</tr>
										</table>
									</td>
								</tr>
								<tr>
									<td style="padding:5px 10px 5px 10px">
										<table  border="0" cellpadding="0" cellspacing="0" height="20px" >
											<tr>
												<td width="5"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_left.png" width="5" height="20"></td>
												<td width="90" class="font_normal11" background="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bg.png" width="75%" >
												<egui:intnl text="monitor.dashboard.Max Duration"/></td>
												<td class="istamBarFont font_normal11" width="60" background="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bgdark.png" align="center" valign="middle" > - 
												<td width="5"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bgdarkright.png" width="5" height="20"></td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</table>
	</div>

	<!--
	<div id="healthDiv" style="display:none; margin-left:5px;margin-top:5px;float:left;width:24%;height:150px;border:0px solid green;">
	<table border="0" cellpadding="0" cellspacing="0" class="vmborder" width="100%" bordercolor="red" >
		<tr>
			<td  width="100%" class="font_bold11 data_headbg1" align="center" style="border-right-width:0px" height="25"><egui:intnl text="monitor.dashboard.Health"/></td>
			<td  class="font_bold11 data_headbg1" style="padding-right:4px;border-right-width:0px"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_close_div.png" onclick="disableBlocks('healthDiv','health')"/></td>
		</tr>
		<tr>
			<td colspan="2" height="123" class="linetop"><img src="/final/servlet/com.objectplanet.chart.ChartServlet?chart=pie&width=175&height=100&sampleValues=0,0,100&sampleColors=%23FE8243%2C%23FFA0A0%2C%23007D00&selectionStyle=detached&multiColorOn=true&pieRotationOn=true&background=white&depth=0.15&angle=45&valueLabelsOn=false&3dModeOn=true&sampleDecimalCount=2&legendOn=true&legendLabels=0,0,100&gradientSamplesOn=true"/></td>
		</tr>
	</table>
	</div>
	-->
<%
	boolean isConfigFound=(configs!=null && configs.size()>0)?true:false;
%>
	<div id="configDiv" style="display:none;margin-left:10px;margin-top:10px;float:left;width:49%;height:150px;border:0px solid #2B7F82">
		<table border="0" cellpadding="0"  cellspacing="0" height="100%" width="100%" class="istam_vmborder" valign="top"><col width="90%"><col width="5%"><col width="5%">
			<tr>
				<td class="istam_data_headbg1" height="25" style="padding-left:4px;border-right-width:0px"><egui:intnl text="monitor.dashboard.Configuration"/></td>
				<td class="istam_data_headbg1" style="border-right-width:0px"><img id="configConfigImg" class="mouse" style="display:<%=(isConfigFound)?"block":"none"%>;" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_config_small.png" onclick="loadTestOnConfig(event)"/></td>
				<td class="istam_data_headbg1" style="border-right-width:0px"><img class="mouse" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_close_div.png" onclick="disableBlocks('configDiv','config')"/></td>
			</tr>
			<tr>
				<td width="100%" valign="top" colspan="3" class="linetop">
				<div id="contentDivConfig" class="istam_div_scroll istamViewTable" style="border:0px solid #ff0000; height:125px;width:100%">
<%
	if(isConfigFound)
	{
%>
					<table cellpadding="0" cellspacing="0" border="0">
<%
		for(int i=0;i<configs.size();i++)
		{
			String s_testMeasure=(String)configs.get(i);

			if(s_testMeasure!=null && s_testMeasure.indexOf(":")!=-1)
			{
				test=s_testMeasure.substring(0,s_testMeasure.indexOf(":"));
				measure=s_testMeasure.substring(s_testMeasure.indexOf(":")+1);
			}

			String config_measureMapping=mappingIni.getValue(subject+"_measures_mapping",s_testMeasure);
			if(config_measureMapping==null || config_measureMapping.trim().equals(""))
				config_measureMapping=mappingInfo.getMeasureDescription(test,measure);
			if(existingConfigTestMeasures!=null && !existingConfigTestMeasures.equals(""))
				existingConfigTestMeasures+=","+s_testMeasure;
			else
				existingConfigTestMeasures=s_testMeasure;
%>

						<tr id="<%="divConfig"+i%>">
							<td width="20px"><input type="checkbox" checked class="eg_input" onclick="javascript:unloadConfigTest(this,<%=i%>);"></td>
							<td id="configTestDisplay<%=i%>" width="100%" ondblclick="javascript:editConfigMeasure(<%=i%>);"><%=config_measureMapping%></td>
						</tr>
				<input id="<%="hidConfigTstMeasure"+i%>" type="hidden" value="<%=s_testMeasure%>"/>
				<input id="<%="hidConfigMeasureMaping"+i%>" type="hidden" value="<%=config_measureMapping%>"/>
<%
		}
%>
			
					</table>
<%
	}
	else
	{
%>
				<table border="0" cellpadding="0" cellspacing="0" width="100%" height="98%">
					<tr>
						<td width="100%" height="100%" align="center" valign="middle" class="font_bold11 mouse"  style="border:0px" onclick="loadTestOnConfig(event)"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_config_big.png"/> <br><br><egui:intnl text="monitor.dashboard.Please Click here to Configure"/></td>
					</tr>
				</table>
<%
	}
%>
				</div>
				</td>
			</tr>
		</table>
	</div>
<%
	boolean isKpiFound=(indicatiors!=null && indicatiors.size()>0)?true:false;
%>
	<div id="kpiDiv" style="display:none;margin-left:10px;margin-top:10px;float:left;width:49%;height:150px;border:0px solid #2B7F82" >
		<table border="0" cellpadding="0" cellspacing="0" height="100%" width="100%" class="istam_vmborder"><col width="90%"><col width="5%"><col width="5%">
			<tr>
				<td class="istam_data_headbg1" height="25" style="padding-left:4px;border-right-width:0px" ><egui:intnl text="monitor.dashboard.Key Performance Indicators" /> </td>
				<td class="istam_data_headbg1" style="border-right-width:0px"><img id="configKpiImg" class="mouse" style="display:<%=(isKpiFound)?"block":"none"%>" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_config_small.png"  onclick="loadTestOnKPI(event)" /></td>
				<td class="istam_data_headbg1" style="border-right-width:0px"><img class="mouse" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_close_div.png" onclick="disableBlocks('kpiDiv','Indicators')"/></td>
			</tr>
			<tr>
				<td valign="top" width="100%" colspan="3" class="linetop">
				<div id="contentDivKPI" class="istam_div_scroll istamViewTable" style="border:0px solid #ff0000; height:125px;width:100%">

<%
	if(isKpiFound)
	{
%>
					<table cellpadding="0" cellspacing="0" border="0">
<%
		for(int i=0;i<indicatiors.size();i++)
		{
			String s_testMeasure=(String)indicatiors.get(i);

			if(s_testMeasure!=null && s_testMeasure.indexOf(":")!=-1)
			{
				test=s_testMeasure.substring(0,s_testMeasure.indexOf(":"));
				measure=s_testMeasure.substring(s_testMeasure.indexOf(":")+1);
			}

			String kpi_measureMapping=mappingIni.getValue(subject+"_measures_mapping",s_testMeasure);
			if(kpi_measureMapping==null || kpi_measureMapping.trim().equals(""))
				kpi_measureMapping=mappingInfo.getMeasureDescription(test,measure);
			if(existingKPITestMeasures!=null && !existingKPITestMeasures.equals(""))
				existingKPITestMeasures+=","+s_testMeasure;
			else
				existingKPITestMeasures=s_testMeasure;
%>
				
						<tr id="<%="divKPI"+i%>">
							<td style="width:20px"><input type="checkbox" checked class="eg_input" onclick="unloadKPITest(this,<%=i%>);"/></td>
							<td id="kpiTestDisplay<%=i%>" width="100%" ondblclick="javascript:editKPIMeasure(<%=i%>);"><%=kpi_measureMapping%></td>
						</tr>
				<input id="<%="hidKpiTstMeasure"+i%>" type="hidden" value="<%=s_testMeasure%>"/>
				<input id="<%="hidKpiMeasureMaping"+i%>" type="hidden" value="<%=kpi_measureMapping%>"/>
<%
		}
%>
			
			</table>
<%
	}
	else
	{
%>
				<table border="0" cellpadding="0" cellspacing="0" width="100%" height="98%">
					<tr>
						<td width="100%" height="100%" align="center" valign="middle" class="font_bold11 mouse" style="border:0px" onclick="loadTestOnKPI(event)"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_kpi_big.png" /><br><br><egui:intnl text="monitor.dashboard.Please Click here to Configure"/></td>
					</tr>
				</table>
<%
	}
%>

				</div>
				</td>
			</tr>
		</table>
	</div>
<%
	Vector dialTestMeasure=egDashboard.getTokensAsVector(s_dial,",");
	for(int i=0;i<dialTestMeasure.size();i++)
	{
		String s_dialTestMeasure=(String)dialTestMeasure.get(i);

		if(s_dialTestMeasure!=null && s_dialTestMeasure.indexOf(":")!=-1)
		{
			test=s_dialTestMeasure.substring(0,s_dialTestMeasure.indexOf(":"));
			measure=s_dialTestMeasure.substring(s_dialTestMeasure.indexOf(":")+1);
		}

		String dial_measureMapping=mappingIni.getValue(subject+"_measures_mapping",s_dialTestMeasure);
		if(dial_measureMapping==null || dial_measureMapping.trim().equals(""))
			dial_measureMapping=mappingInfo.getMeasureDescription(test,measure);
%>
	<div id="<%="div"+(++divCount)%>" style="margin-left:10px;margin-top:10px;float:left;width:24%;height:150px;border:0px solid orange">
		<table class="istam_vmborder" border="0" bordercolor="blue" cellpadding="2" cellspacing="0" width="100%"><col width="90%"><col width="10%">
			<tr>
				<td class="istam_data_headbg1" style="border-right-width:0px" height="25" nowrap >
					<div id="<%="header"+divCount%>" ondblclick="javascript:editHeader('<%=divCount%>','<%="dial"%>');");"><%=dial_measureMapping%></div>
				</td>
				<td class="istam_data_headbg1" style="border-right-width:0px"><img  class="mouse" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_close_div.png" onclick="javascript:removeGraph('<%=divCount%>','<%="dial"%>');"/></td>
			</tr>
			<tr>
				<td colspan="2" height="125" align="center" class="linetop"><img class="mouse" src="<%=s_dialURL%>"  title="configure" onclick="javascript:loadTestOnclick('<%=divCount%>','<%="dial"%>',event);" height="120"></td>
			</tr>
		</table>
		<input type="hidden" id="<%="hidTestMsr"+divCount%>" value="<%=s_dialTestMeasure%>"/>
		<input type="hidden" id="<%="hidTestMsrMapping"+divCount%>" value="<%=dial_measureMapping%>"/>
	</div>
<%
	}

	Vector digitalTestMeasure=egDashboard.getTokensAsVector(s_digital,",");
	for(int i=0;i<digitalTestMeasure.size();i++)
	{
		String s_digitalTestMeasure=(String)digitalTestMeasure.get(i);

		if(s_digitalTestMeasure!=null && s_digitalTestMeasure.indexOf(":")!=-1)
		{
			test=s_digitalTestMeasure.substring(0,s_digitalTestMeasure.indexOf(":"));
			measure=s_digitalTestMeasure.substring(s_digitalTestMeasure.indexOf(":")+1);
		}

		String digital_measureMapping=mappingIni.getValue(subject+"_measures_mapping",s_digitalTestMeasure);
		if(digital_measureMapping==null || digital_measureMapping.trim().equals(""))
			digital_measureMapping=mappingInfo.getMeasureDescription(test,measure);
%>
	<div id="<%="div"+(++divCount)%>" style="margin-left:10px;margin-top:10px;float:left;width:24%;height:150px;border:0px solid blue">
		<table class="istam_vmborder" border="0" bordercolor="blue" cellpadding="2" cellspacing="0" width="100%"><col width="90%"><col width="10%">
			<tr>
				<td class="istam_data_headbg1" height="25" nowrap style="border-right-width:0px">
					<div id="<%="header"+divCount%>" ondblclick="javascript:editHeader('<%=divCount%>','<%="digital"%>');");"><%=digital_measureMapping%></div>
				</td>
				<td class="istam_data_headbg1" style="border-right-width:0px"><img class="mouse" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_close_div.png" onclick="javascript:removeGraph('<%=divCount%>','<%="digital"%>');"/></td>
			</tr>
			<tr>
				<td colspan="2" height="125" align="center" class="linetop"><img class="mouse" src="<%=s_digitalURL%>" title="configure" onclick="javascript:loadTestOnclick('<%=divCount%>','<%="digital"%>',event);"></td>
			</tr>
		</table>
		<input type="hidden" id="<%="hidTestMsr"+divCount%>" value="<%=s_digitalTestMeasure%>"/>
		<input type="hidden" id="<%="hidTestMsrMapping"+divCount%>" value="<%=digital_measureMapping%>"/>
	</div>
<%
	}

	Vector historyTestMeasure=egDashboard.getTokensAsVector(s_history,",");
	for(int i=0;i<historyTestMeasure.size();i++)
	{
		String s_historyTestMeasure=(String)historyTestMeasure.get(i);

		if(s_historyTestMeasure!=null && s_historyTestMeasure.indexOf(":")!=-1)
		{
			test=s_historyTestMeasure.substring(0,s_historyTestMeasure.indexOf(":"));
			measure=s_historyTestMeasure.substring(s_historyTestMeasure.indexOf(":")+1);
		}

		String history_measureMapping=mappingIni.getValue(subject+"_measures_mapping",s_historyTestMeasure);
		if(history_measureMapping==null || history_measureMapping.trim().equals(""))
			history_measureMapping=mappingInfo.getMeasureDescription(test,measure);
%>
	<div id="<%="div"+(++divCount)%>" style="margin-left:10px;margin-top:10px;float:left;width:24%;height:150px;border:0px solid green">
		<table class="istam_vmborder" border="0" bordercolor="blue" cellpadding="2" cellspacing="0"><col width="90%"><col width="10%">
			<tr>
				<td class="istam_data_headbg1" height="25" nowrap style="border-right-width:0px">
					<div id="<%="header"+divCount%>" ondblclick="javascript:editHeader('<%=divCount%>','<%="dial"%>');"><%=history_measureMapping%></div>
				</td>
				<td class="istam_data_headbg1" style="border-right-width:0px"> <img class="mouse" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_close_div.png" onclick="javascript:removeGraph('<%=divCount%>','<%="history"%>');"/></td>
			</tr>
			<tr>
				<td colspan="2" height="125"  align="center" class="linetop"><img  class="mouse" src="<%=s_historyURL%>"  title="configure" onclick="javascript:loadTestOnclick('<%=divCount%>','<%="history"%>',event);" height="120"></td>
			</tr>
		</table>
		<input type="hidden" id="<%="hidTestMsr"+divCount%>" value="<%=s_historyTestMeasure%>"/>
		<input type="hidden" id="<%="hidTestMsrMapping"+divCount%>" value="<%=history_measureMapping%>"/>
	</div>
<%
	}

	Vector comparisionTestMeasure=egDashboard.getTokensAsVector(s_comparision,",");
	for(int i=0;i<comparisionTestMeasure.size();i++)
	{
		String s_comparisionTestMeasure=(String)comparisionTestMeasure.get(i);

		if(s_comparisionTestMeasure!=null && s_comparisionTestMeasure.indexOf(":")!=-1)
		{
			test=s_comparisionTestMeasure.substring(0,s_comparisionTestMeasure.indexOf(":"));
			measure=s_comparisionTestMeasure.substring(s_comparisionTestMeasure.indexOf(":")+1);
		}

		String comparision_measureMapping=mappingIni.getValue(subject+"_ComparisonGraph_mapping",s_comparisionTestMeasure);
		if(comparision_measureMapping==null || comparision_measureMapping.trim().equals(""))
			comparision_measureMapping=mappingInfo.getMeasureDescription(test,measure);
%>
	<div id="<%="div"+(++divCount)%>" style="margin-left:10px;margin-top:10px;float:left;width:24%;height:150px;border:0px solid red">
		<table class="istam_vmborder" border="0" bordercolor="blue" cellpadding="2" cellspacing="0"><col width="90%"><col width="10%">
			<tr>
				<td class="istam_data_headbg1" height="25" style="border-right-width:0px" nowrap>
					<div id="<%="header"+divCount%>" ondblclick="javascript:editHeader('<%=divCount%>','<%="comparision"%>');");"><%=comparision_measureMapping%></div>
				</td>
				<td class="istam_data_headbg1" style="border-right-width:0px"><img class="mouse" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_close_div.png" onclick="javascript:removeGraph('<%=divCount%>','<%="comparision"%>');"/></td>
			</tr>
			<tr>
				<td colspan="2" height="125" align="center" class="linetop"><img class="mouse" src="<%=s_comparisionURL%>"height="120"  title="configure" onclick="javascript:loadTestOnclick('<%=divCount%>','<%="comparision"%>',event);"></td>
			</tr>
		</table>
		<input type="hidden" id="<%="hidTestMsr"+divCount%>" value="<%=s_comparisionTestMeasure%>"/>
		<input type="hidden" id="<%="hidTestMsrMapping"+divCount%>" value="<%=comparision_measureMapping%>"/>
	</div>
<%
	}

	Vector tables=egDashboard.getTokensAsVector(s_tables,"#");
	for(int i=0;i<tables.size();i++)
	{
		String s_testMeasures=(String)tables.get(i);
		Vector testMeasures=egDashboard.getTokensAsVector(s_testMeasures,",");
		String tempTest="";

		if(testMeasures!=null && testMeasures.size()>0)
		{
			String s_tempTestMeasure=(String)testMeasures.get(0);
			if(s_tempTestMeasure!=null && s_tempTestMeasure.indexOf(":")!=-1)
			{
				tempTest=s_tempTestMeasure.substring(0,s_tempTestMeasure.indexOf(":"));
			}
		}

		String s_tableTitleMapping=iniObj.getValue(subject+"_Comparison_TableTitle",tempTest);

		if(s_tableTitleMapping==null || s_tableTitleMapping.equals(""))
			s_tableTitleMapping=mappingInfo.getTestDescription(tempTest);
%>
	<div id="<%="div"+(++divCount)%>" style="margin-left:10px;margin-top:10px;float:left;width:49%;height:150px;border:0px solid #ff5500;display:block">
		<table class="istam_vmborder" border="0"  cellpadding="0" cellspacing="0" width="100%"><col width="95%"><col width="5%">
			<tr>
				<td class="istam_data_headbg1" height="25" style="border-right-width:0px">
					<div id="header<%=divCount%>" ondblclick="javascript:editTableTitle('<%=divCount%>','comparisontable');"><%=s_tableTitleMapping%>
					</div>
					<input type="hidden" id="hidTest<%=divCount%>" value="<%=tempTest%>"/>
					<input type="hidden" id="hidTestMapping<%=divCount%>" value="<%=s_tableTitleMapping%>"/>
				</td>
				<td class="istam_data_headbg1" style="border-right-width:0px"><img class="mouse" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_close_div.png" onclick="javascript:removeTable('<%=divCount%>','comparisontable');"/></td>
			</tr>
			<tr>
				<td width="100%" height="120" colspan="2" style="padding:0px" valign="top" class="linetop">
					<div id="contentDiv<%=divCount%>" class="istam_div_scroll" style="width:100%;height:120px;border:0px solid #ff0000;"/>
						<table cellspacing="0" cellpadding="2" class="tableborder_jvm"  border="0" width="100%">
<%
		for(int j=0;j<testMeasures.size();j++)
		{
			String s_testMeasure=(String)testMeasures.get(j);

			if(s_testMeasure!=null && s_testMeasure.indexOf(":")!=-1)
			{
				test=s_testMeasure.substring(0,s_testMeasure.indexOf(":"));
				measure=s_testMeasure.substring(s_testMeasure.indexOf(":")+1);
			}

			String s_tableHeaderMapping=mappingIni.getValue(subject+"_tableheader_mapping",s_testMeasure);

			if(s_tableHeaderMapping==null || s_tableHeaderMapping.equals(""))
				s_tableHeaderMapping=mappingInfo.getMeasureDescription(test,measure);

			if(infoBasedTests!=null && infoBasedTests.contains(test))
			{
				if(j==0)
				{
					String s_infoMapping=mappingIni.getValue(subject+"_info_mapping",test);


					if(s_infoMapping==null || s_infoMapping.equals(""))
						s_infoMapping="Info";
%>
							<tr>
								<td class="font_bold11 tdborder2_jvm"  >
								<div id="<%="tableInfo"+divCount%>" ondblclick="editTableInfo('<%=divCount%>','<%=j%>');"> <%=s_infoMapping%></div>
								<input type="hidden" id="<%="hidTableInfo"+divCount%>" value="<%=test%>"/>
								<input type="hidden" id="<%="hidTableInfoMapping"+divCount%>" value="<%=s_infoMapping%>"/>
								</td>
<%
				}
%>
									<td id="<%="divTable"+divCount+"Column"+j%>" class="font_bold11 tdborder2_jvm">
										<table border="0" cellpadding="0" cellspacing="0">
											<thead>
											<tr>
												<th class="font_bold11 padding4"><input type="checkbox" checked class="eg_input" onclick="javascript:unloadTableMeasure('<%=divCount%>','<%=j%>','comparisontable');"/></th>
												<th class="font_bold11 padding4"><div id="<%="table"+divCount+"Column"+j%>" ondblclick="editTableHeader('<%=divCount%>','<%=j%>','comparisontable');"> <%=s_tableHeaderMapping%></div>
												<input type="hidden" id="<%="hidTable"+divCount+"Column"+j+"TstMsr"%>" value="<%=s_testMeasure%>"/>
												<input type="hidden" id="<%="hidTable"+divCount+"Column"+j+"TstMsrMaping"%>" value="<%=s_tableHeaderMapping%>"/>
												</th>
											</tr>
											</thead>
										</table>
									</td>
<%
			}
			else
			{
				if(j==0)
				{
%>
							<tr>
								<td>
<%
				}
%>
									<div id="<%="divTable"+divCount+"Column"+j%>" style="padding:2px;border:0px solid #000000">
										<table cellpadding="0" cellspacing="0" border="0" width="100%">
											<tr>
												<td style="width:20px"><input type="checkbox" checked class="eg_input" onclick="javascript:unloadTableMeasure('<%=divCount%>','<%=j%>','comparisontable');"/></td>
												<td id="<%="table"+divCount+"Column"+j%>" ondblclick="editTableHeader('<%=divCount%>','<%=j%>','comparisontable');"><%=s_tableHeaderMapping%></td>
												<td><img src="/final/servlet/com.egurkha.monitor.egSparkLineGraph?width=100&height=18&data=0,0,0,0,0"/></td>
												<td>-</td>
											</tr>
										</table>
										<input type="hidden" id="<%="hidTable"+divCount+"Column"+j+"TstMsr"%>" value="<%=s_testMeasure%>"/>
										<input type="hidden" id="<%="hidTable"+divCount+"Column"+j+"TstMsrMaping"%>" value="<%=s_tableHeaderMapping%>"/>
									</div>
<%
				if(j+1==testMeasures.size())
				{
%>
								</td>
							</tr>
<%
				}
			}
		}

		//if(infoBasedTests!=null && infoBasedTests.contains(test))
		//{
%>
<!--							</tr>
							<tr>
-->
<%
			//for(int j=0;j<testMeasures.size();j++)
			//{
%>
<!--								<td class="tdborder_jvm">&nbsp;</td>
-->
<%
	//		}
%>
							</tr>
<%
	//	}
%>
						</table>
					</div>
				</td>
			</tr>
		</table>
	</div>
<%
	}
	Vector ddcomptables=egDashboard.getTokensAsVector(ddcomp_tables,"#");
	for(int i=0;i<ddcomptables.size();i++)
	{
		String s_testMeasures=(String)ddcomptables.get(i);
		String ddColumns=s_testMeasures;
		ddColumns=ddColumns.substring(ddColumns.indexOf("|")+1);
		Vector testMeasures=egDashboard.getTokensAsVector(ddColumns,",");
		String tempTest="";
		String s_testMeasure="";
		if(s_testMeasures!=null && s_testMeasures.indexOf(":")!=-1)
		{
			tempTest=s_testMeasures.substring(0,s_testMeasures.indexOf(":"));			measure=s_testMeasures.substring(s_testMeasures.indexOf(":")+1,s_testMeasures.indexOf("|"));
			s_testMeasure=s_testMeasures.substring(0,s_testMeasures.indexOf("|"));
		}
		String s_tableTitleMapping=mappingIni.getValue(subject+"_DDComparisonTableTitle",tempTest+":"+measure);
		if(s_tableTitleMapping==null || (s_tableTitleMapping!=null && s_tableTitleMapping.equals("")))
			s_tableTitleMapping=mappingInfo.getMeasureDescription(tempTest,measure);
%>
	<div id="<%="div"+(++divCount)%>" style="margin-left:10px;margin-top:10px;float:left;width:49%;height:150px;border:0px solid #ff5500;display:block">
		<table class="istam_vmborder" border="0" cellpadding="0" cellspacing="0" width="100%"><col width="95%"><col width="5%">
			<tr>
				<td class="istam_data_headbg1" height="25" style="border-right-width:0px">
					<div id="header<%=divCount%>" ondblclick="javascript:editTableTitle('<%=divCount%>','ddcomparisontable');"><%=s_tableTitleMapping%> </div>
					<input type="hidden" id="hidTest<%=divCount%>" value="<%=tempTest%>"/>
					<input type="hidden" id="hidTestDDMeasure<%=divCount%>" value="<%=measure%>"/>
					<input type="hidden" id="hidTestMapping<%=divCount%>" value="<%=s_tableTitleMapping%>"/>
				</td>
				<td class="istam_data_headbg1" style="border-right-width:0px"><img class="mouse" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_close_div.png" onclick="javascript:removeTable('<%=divCount%>','ddcomparisontable');"/></td>
			</tr>
			<tr>
				<td width="100%" height="120" colspan="2" style="padding:0px" valign="top" class="linetop">
					<div id="contentDiv<%=divCount%>" class="istam_div_scroll" style="overflow:auto;width:100%;height:120px;border:0px solid #ff0000;"/>
						<table cellspacing="0" cellpadding="2" class="tableborder_jvm"  border="0" width="100%">
							<tr>
<%
		for(int j=0;j<testMeasures.size();j++)
		{
			String displayDDColumn=(String)testMeasures.get(j);
			String displayValue=displayDDColumn;

			if(displayDDColumn!=null && displayDDColumn.indexOf(":")!=-1)
			{
				displayValue=displayValue.substring(0,displayValue.indexOf(":"));
				displayDDColumn=displayDDColumn.substring(displayDDColumn.indexOf(":")+1);
			}
			String s_tableColHeaderMapping=mappingIni.getValue(subject+"_DDComparisonTableheader_mapping",displayDDColumn);
			if(s_tableColHeaderMapping==null || (s_tableColHeaderMapping!=null && s_tableColHeaderMapping.equals("")))
				s_tableColHeaderMapping=mappingInfo.getTextDescription("monitor.dashboard."+displayDDColumn);
%>
								<td id="<%="divTable"+divCount+"Column"+j%>" class="font_bold11 tdborder2_jvm">
										<table cellpadding="0" cellspacing="0" border="0" width="100%">
											<thead>
											<tr>
												<th style="width:20px" class="font_bold11 padding4"><input type="checkbox" checked class="eg_input" onclick="javascript:unloadTableMeasure('<%=divCount%>','<%=j%>','ddcomparisontable');"/></th>
												<th class="font_bold11 padding4" id="<%="table"+divCount+"Column"+j%>" ondblclick="editTableHeader('<%=divCount%>','<%=j%>','ddcomparisontable');"><%=s_tableColHeaderMapping%></th>
											</tr>
										</table>
										<input type="hidden" id="<%="hidTable"+divCount+"Column"+j+"TstMsr"%>" value="<%=displayValue+":"+displayDDColumn%>"/>
										<input type="hidden" id="<%="hidTable"+divCount+"Column"+j+"TstMsrMaping"%>" value="<%=s_tableColHeaderMapping%>"/>
								</td>
<%
		}
%>
							</tr>
						</table>
					</div>
				</td>
			</tr>
		</table>
	</div>
<%
	}
%>
		<input id="hidDivCount" type="hidden" value="<%=divCount%>"/>
		<input type="hidden" id="kpiTestMeasuresHid" name="kpiTestMeasuresHid" value="<%=existingKPITestMeasures%>">
		<input type="hidden" id="configTestMeasuresHid" name="configTestMeasuresHid" value="<%=existingConfigTestMeasures%>">
		<input type="hidden" id="comparisonGraphHid" name="comparisonGraphHid" value="<%=s_comparision%>">
		<input type="hidden" id="historyGraphHid" name="historyGraphHid" value="<%=s_history%>">
		<input type="hidden" id="dialGraphHid" name="dialGraphHid" value="<%=s_dial%>">
		<input type="hidden" id="digitalGraphHid" name="digitalGraphHid" value="<%=s_digital%>">
</div>
</body>
</html>
<%
	if(request.getQueryString()!=null)
	{

		String qryStringData=request.getQueryString();
		StringTokenizer stkQryString=new StringTokenizer(qryStringData,"&");
		StringBuffer sb=new StringBuffer();
		while(stkQryString.hasMoreTokens())
		{
			String token=stkQryString.nextToken();
			if(token!=null && token.indexOf("=")>0)
			{
				String param=token.substring(0,token.indexOf("="));
				if(param!=null && !param.equalsIgnoreCase("profilename"))
				{
					if(sb!=null && sb.toString().equals(""))
						sb.append(token);
					else
						sb.append("&"+token);
				}
			}
		}
	session.setAttribute("monitorLastSession","/final/monitor/egDesignDashboard.jsp?"+sb.toString()+"&profileName="+EgURLEncoder.encode(profileName,"UTF-8"));
	}
	else
		session.setAttribute("monitorLastSession","/final/monitor/egDesignDashboard.jsp");
}
catch(Exception ex)
{
	ex.printStackTrace();
}
%>