<%
/********************************************************************************************************
*	Name			:	segmentUsers.jsp
*	Purpose			:	This jsp is used to display segments and the users to which it is associated 
*	Version			:	5.6
*	ModifedDate		:	Feb 20,2012
*	Modified		:	S.Saravanan
*******************************************************************************************************/
%>
<%@ include file = "EgMonitorTracker.jsp" %>
<%@ page errorPage="EgErrorSmall.jsp" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "com.egurkha.monitor.*" %>
<%@ page import = "java.util.*" %>
<%@ page import="com.egurkha.util.*"%>
<%@ page import = "com.egurkha.ini.*" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import = "com.eg.EgTopoInfo"%>
<%@ page import = "com.eg.*"%>
<%@ page import="net.sf.json.*"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%
response.setHeader("Cache-Control","no-store");
response.setHeader("Pragma","no-cache");
response.setDateHeader ("Expires", -1);
response.setContentType("application/json");
UserSegmentsResult r = (UserSegmentsResult) request.getAttribute("result");
String treeFlag=request.getParameter("treeFlag");

IniUI iniUI = IniUI.getInstance();
UserRegistry userReg = UserRegistry.getInstance();
User users = userReg.getUser(session.getId());
EgTopoInfo topoInfo=new EgTopoInfo("manager");
String thisLanguage = iniUI.getDefaultLanguage();
int displayNameLength = 28;
int displayHeadLength = 10;
if (users!=null)
{
	String userLang = users.getLanguage();
	if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
	{
		thisLanguage=userLang;
	}
}
boolean isUserLanguageEnglish=true;
if(thisLanguage!=null && !thisLanguage.equals("en_US"))
{
	isUserLanguageEnglish=false;
}

//EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);

JSONObject json  = new JSONObject();
JSONObject labelObj= new JSONObject();
JSONArray segmentData= new JSONArray(); 
JSONObject segmentDataObject = new JSONObject();

labelObj.put("monitor.associationsservices.Segments",mappingInfo.getTextDescription("monitor.associationsservices.Segments"));

labelObj.put("monitor.associationsservices.Users",mappingInfo.getTextDescription("monitor.associationsservices.Users"));
json.put("screenLabels",labelObj);

if (r.segmentList!=null)
{
	int i = 0;
	ArrayList userList = null;
	EgSegment segment = null;
	ArrayList none = new ArrayList();
	//none.add("None");
	for(i = 0; i < r.segmentList.size(); i++)
	{
		userList = new ArrayList();
		int checkCount=0;
		if(r.showImage)
			checkCount=4;//12;
		else
			checkCount=4;
		segment = (EgSegment) r.segmentList.get(i);
		//userList = none;
		if(r.segmentUsers.get(segment.getName()) != null)
		{
			userList = (ArrayList) r.segmentUsers.get(segment.getName());
		}

		segmentDataObject.put("name",segment.getName());
		segmentDataObject.put("iconClass","state_footer_"+segment.getState().getName());	
	 	segmentDataObject.put("link","/final/monitor/segmentDashboard.jsp?treeFlag="+treeFlag+"&outsideSegment=true&titleText=Segments&selectNode=Segment$cap$"+EgURLEncoder.encode(segment.getName(),"UTF-8")+"&segmentFromZone="+EgURLEncoder.encode(segment.getName(),"UTF-8"));

		if (userList != null && userList.size()>0)
		{
			/*for(int j = 0; j < userList.size(); j++)
			{
				String user = null;
				if(j < userList.size())
				{
					user = (String) userList.get(j);
				}
				segmentDataObject.put("userName",user);
			}*/
			segmentDataObject.put("userName",userList);
		}
		else
		{
			segmentDataObject.put("userName",mappingInfo.getTextDescription("monitor.associationszone.None"));
		}
		segmentData.add(segmentDataObject);
	}
}
else
{
	segmentDataObject.put("error",mappingInfo.getTextDescription("monitor.segments.No segments found"));
	segmentData.add(segmentDataObject);
}

json.put("segmentData",segmentData);

response.getWriter().write(json.toString());
try
{
	session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgMonitorController?monCmd=segmentList&from=MainDashboard&action=segment&openNode=segment&selectedParam=segment&treeFlag="+treeFlag+"&currentTab=association&setAssociate=true");
	
}
catch(Exception e)
{
	System.out.println("Exception in segmentDashboard..");
	e.printStackTrace();
}
%>
