<!DOCTYPE html>

<%@ include file = "ErTracker.jsp" %>
<%@ page import = "java.util.*" %>
<%@ page import = "java.text.*" %>

<%@ page import= "com.eg.EgDbInfo" %>
<%@ page import= "com.eg.EgTablesInfo" %>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "com.eg.EgReportInfo" %>
<%@ page import = "com.eg.EgMappingInfo" %>
<%@ page import= "com.eg.EgServicesInfo" %>
<%@ page import= "com.eg.EgTesterInfo" %>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="egurkha.reporter.ErUtils"%>
<%@ page import = "net.sf.json.*"%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	String strManagerURL = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort();
	EgTablesInfo tablesInfo = new EgTablesInfo ("manager"); 
	
	Map resultMap = (Map) session.getAttribute("CITRIX_CAPACITY_PREDICTION_REPORT_RESULT");
	List keyList = null;
	ErUtils erUtils = new ErUtils();
	boolean noDataFound = false;
	if(resultMap != null)
	{
		String noData = (String) resultMap.get("NO_DATA_FOUND");
		if(noData != null && noData.equalsIgnoreCase("yes"))
			noDataFound = true;
	}
	else
	{
		noDataFound = true;
	}

	EgReportInfo reportInfo = new EgReportInfo("manager");
	String thisLanguage="";
	if (thisuser != null)
	{
		String userLang = thisuser.getLanguage();
		if (userLang != null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage = userLang;
		}
	}

	EgMappingInfo intlmap = new EgMappingInfo(thisuser.getLanguage());

	String s_comptype = request.getParameter("er_comptype");
	String s_component = request.getParameter("er_component");
	
	String s_test = request.getParameter("er_test");
	String s_measure = request.getParameter("er_measure");
	
	String s_info = request.getParameter("er_info");
	
	String s_look_forward = request.getParameter("er_look_forward");
	String s_dataoption = request.getParameter("er_dataoption");
	
	String s_type = request.getParameter("er_type");
	
	String showDetails = request.getParameter("er_show_details");
	String er_timeline = request.getParameter("er_timeline");
	String excludeweekend = request.getParameter("er_excwe");
	String s_st_time = request.getParameter("startdate");
	String s_en_time = request.getParameter("enddate");
	String s_st_hr   = request.getParameter("starthr");
	String s_en_hr   = request.getParameter("endhr");
	String strmin    = request.getParameter("startmin");
	String enmin     = request.getParameter("endmin");
	String er_time   =  request.getParameter("er_time");
	String hourFrom = request.getParameter("timefrom");
	String minFrom = request.getParameter("minfrom");
	String hourTo = request.getParameter("timeto");
	String minTo = request.getParameter("minto");
	String iniDate = request.getParameter("inidate");
	String er_option = request.getParameter("er_option");
	String er_site = request.getParameter("er_site");
	String er_siteDisp = er_site;
	String fromRunButton = request.getParameter("fromRunButton");
	String er_deliveryGrp=request.getParameter("er_deliveryGrp");
	if(fromRunButton==null || fromRunButton.length()==0)
	{
		fromRunButton = "yes";
	}
	if(er_site!=null && er_site.equalsIgnoreCase("--Default--"))
	{
		er_siteDisp = intlmap.getTextDescription("reporter.common.--Default--");
	}
	String incresaseFactor = request.getParameter("increaseBy");
	double incresaseFactorVal = 0.0;
	boolean isNegativefactor = false;
	if(incresaseFactor!=null && incresaseFactor.length()>0)
	{
		try
		{
			if(incresaseFactor.startsWith("-"))
			{
				isNegativefactor = true;
				incresaseFactor = incresaseFactor.substring(1);
			}
			incresaseFactorVal = Double.parseDouble(incresaseFactor);
		}
		catch (Exception ex) 
		{
		}
	}
	JSONObject chartDataObj = null;
	JSONObject barChartDataObj = null;
	String UiTxt = "Additional Capacity";
	String LoadIndexComponents = reportInfo.getValue("CITRIX_CAPACITY_PREDICTION","LoadIndexComponents");
	ArrayList LoadIndexComponentsList = ErUtils.egTokenizer(LoadIndexComponents, ",");
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = strUserDateFormat;
	
	String dispStartDate = DateUtil.changeDateFormat(s_st_time.trim(),iniDate,currentDateFormat);
	String dispEndDate = DateUtil.changeDateFormat(s_en_time.trim(),iniDate,currentDateFormat);
	String timefrom = hourFrom + ":" + minFrom;
	String timeTo = hourTo + ":" + minTo;
	String stTime = "";
	String enTime = "";
	
	String pdfPrint = request.getParameter("pdfPrint");

	if (er_timeline != null)
	{
		stTime = s_st_hr + " " + intlmap.getTextDescription("reporter.common.hrs");
		enTime = s_en_hr + " " +intlmap.getTextDescription("reporter.common.hrs");
	}
	EgTimeZoneConverter converterStart=null;
	EgTimeZoneConverter converterEnd=null;
	String st_dateTime="";
	String en_dateTime="";
	
	converterStart = new EgTimeZoneConverter(dispStartDate+" "+s_st_hr+":"+strmin,thisuser);
	converterEnd = new EgTimeZoneConverter(dispEndDate+" "+s_en_hr+":"+enmin,thisuser);
	
	stTime = (String)converterStart.getDate(false);
	//stTime = (String)converterStart.getDate(false)+" "+converterStart.getHour() +" "+intlmap.getTextDescription("reporter.common.hrs")+" "+converterStart.getMinute()+" "+intlmap.getTextDescription("reporter.common.mins");

	enTime = (String)converterEnd.getDate(false);
	//enTime = (String)converterEnd.getDate(false)+" "+converterEnd.getHour() +" "+intlmap.getTextDescription("reporter.common.hrs")+" "+converterEnd.getMinute()+" "+intlmap.getTextDescription("reporter.common.mins");

	EgDbInfo dbInfo = new EgDbInfo("manager");
	String fontStyleDblSingl = "";
	if((dbInfo.doubleByteEnabled || !thisuser.getLanguage().equals("en_US")) && (pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes")))
	{
		fontStyleDblSingl = "multi_font";
	}
	else
	{
		fontStyleDblSingl = "";
	}
	String er_RmDispName = request.getParameter("er_RmDispName");
	String ChartMaxValue_cpu  = request.getParameter("cpu_usage");
	String ChartMaxValue_memory  = request.getParameter("memory_usage");
	String ChartMaxValue_disk  = request.getParameter("disk_usage");
	String ChartMaxValue_network  = request.getParameter("network_usage");
	String ChartMaxValue_loadIndex  = request.getParameter("loadIndex");
	int totalGraph = 0;
	ArrayList graphKey = new ArrayList();
	ArrayList graphTitle = new ArrayList();

	if(ChartMaxValue_cpu==null)
	{
		ChartMaxValue_cpu = reportInfo.getValue("CITRIX_CAPACITY_PREDICTION","ChartMaxValue_cpu");
	}
	if(ChartMaxValue_disk==null)
	{
		ChartMaxValue_disk = reportInfo.getValue("CITRIX_CAPACITY_PREDICTION","ChartMaxValue_disk");
	}
	if(ChartMaxValue_memory==null)
	{
		ChartMaxValue_memory = reportInfo.getValue("CITRIX_CAPACITY_PREDICTION","ChartMaxValue_memory");
	}
	if(ChartMaxValue_network==null)
	{
		ChartMaxValue_network = reportInfo.getValue("CITRIX_CAPACITY_PREDICTION","ChartMaxValue_network");
	}

%>

<!Doctype html>
<head>
<%
	if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
	{
%>
	<title>
		<egui:intnl text="reporter.common.Capacity Prediction for Virtual Applications"/>
	</title>
<%
	}
	else
	{
%>
	<title>eG Reporter</title>
<%
	}
%>

<meta name="Author" content="">
<meta  charset="UTF-8">
	<link rel="stylesheet" type="text/css" href="/final/styles/eGLightThemeIcons.css" />
	<link rel="stylesheet" type="text/css" href="/final/reporter/styles/printpagestyle.css" />
  
<style type="text/css" media="print">
#printbt{ display:none}
</style>
</head>

<body marginwidth="20" marginheight="20" bgcolor="#FFFFFF">
<%
	String strLogCls = "printHeaderBoxLogo";
	if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
	{
		strLogCls = "printHeaderBoxLogo";
	}
	else
		strLogCls = "printPdfHeaderBoxLogo";

	if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
	{
%>
		<div class="<%=strLogCls%>" style="padding:10px"><img src="<%=imageName%>" border="0"/></div>
<%
	}
	else
	{
%>
		<div class="<%=strLogCls%>"><img src="<%=imageName%>" border="0"/></div>
<%
	}
%>
	<div class="printHeaderBox">
<%
	if (!StringUtils.isNull(er_RmDispName))
	{
%>
			<div class="printHeaderBoxTitle"><%= er_RmDispName %></div>
<%
	}
	else
	{
%>
			<div class="printHeaderBoxTitle"><header><egui:intnl text="reporter.common.CAPACITY PLANNING PREDICTION REPORT"/></header></div>
<%
	}
	if(pdfPrint!=null && pdfPrint.equalsIgnoreCase("yes"))
	{
%>
		<div class="printHeaderBoxPrintIcon" style="float:left"><img class="iconPrinter mouse" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0" onClick="javascript:print()" alt='<egui:intnl text="reporter.common.PRINT"/>' title='<egui:intnl text="reporter.common.PRINT"/>'/></div>
<%
	}
%>
	</div>

	<div class="printOuterBoxNoBorder">
		<div class="printSelectionFields"><%=intlmap.getTextDescription("reporter.common.Analyze By")%> - <span class="bold"><%=intlmap.getTextDescription("reporter.common."+er_option)%></span></div>
	<%
		if(er_option != null && !er_option.equalsIgnoreCase("Component")){
	%>
			<div class="printSelectionFields"><%=intlmap.getTextDescription("reporter.common.Zone")%> - <span class="bold"><%=er_site%></span></div>
	<%
		}
	%>
			<div class="printSelectionFields"><%=intlmap.getTextDescription("reporter.common.Component Type")%> - <span class="bold"><%=intlmap.getComponentTypeDescription(s_comptype)%></span></div>
	<%
		if(er_option != null && er_option.equalsIgnoreCase("Component")){
	%>
			<div class="printSelectionFields"><%=intlmap.getTextDescription("reporter.common.Component")%> - <span class="bold"><%=s_component%></span></div>
	<%
		}
		if(er_deliveryGrp!=null)
		{
%>
			<div class="printSelectionFields"><%=intlmap.getTextDescription("reporter.common.Delivery Group")%> - <span class="bold"><%=er_deliveryGrp%></span></div>
<%
		}
		if(incresaseFactorVal>0)
		{
			if(isNegativefactor)
			{
%>
				<div class="printSelectionFields"><%=intlmap.getTextDescription("reporter.common.Demand")%> - <span class="bold">&nbsp;<egui:intnl text="reporter.common.Decreased by" />&nbsp;<%=incresaseFactor%>%</span></div>
<%
			}
			else
			{
%>
			<div class="printSelectionFields"><%=intlmap.getTextDescription("reporter.common.Demand")%> - <span class="bold">&nbsp;<egui:intnl text="reporter.common.Increase by" />&nbsp;<%=incresaseFactor%>%</span></div>
<%
			}
		}
		else
		{
%>
			<div class="printSelectionFields"><%=intlmap.getTextDescription("reporter.common.Demand")%> - <span class="bold">&nbsp;<egui:intnl text="reporter.common.Current" /></span></div>
<%
		}

	if(resultMap !=null && resultMap.size() != 0 && !noDataFound)
	{
		HashMap resultDataMap = (HashMap)resultMap.get("RESULT_DATA");
		System.out.println("resultDataMap   "+resultDataMap);
		if(resultDataMap!=null)
		{
			JSONObject resultObj = new JSONObject();
			String LOAD_INDEX=(String)resultDataMap.get("LOAD_INDEX");
			String SESSION_CONSUMED_CPU_UTIL=(String)resultDataMap.get("SESSION_CONSUMED_CPU_UTIL");
			if(SESSION_CONSUMED_CPU_UTIL==null)
				SESSION_CONSUMED_CPU_UTIL = "0";
			String SESSION_CONSUMED_DISK_USAGE=(String)resultDataMap.get("SESSION_CONSUMED_DISK_USAGE");
			if(SESSION_CONSUMED_DISK_USAGE==null)
				SESSION_CONSUMED_DISK_USAGE = "0";
			String SESSION_CONSUMED_NETWORK_USAGE=(String)resultDataMap.get("SESSION_CONSUMED_NETWORK_USAGE");
			if(SESSION_CONSUMED_NETWORK_USAGE==null)
				SESSION_CONSUMED_NETWORK_USAGE = "0";
			String SESSION_CONSUMED_MEM_UTIL=(String)resultDataMap.get("SESSION_CONSUMED_MEM_UTIL");
			if(SESSION_CONSUMED_MEM_UTIL==null)
				SESSION_CONSUMED_MEM_UTIL = "0";
			String TOTAL_SERVERS=(String)resultDataMap.get("TOTAL_SERVERS");
			if(TOTAL_SERVERS==null)
				TOTAL_SERVERS = "0";
			String CONCURRENT_SESSIONS=(String)resultDataMap.get("CONCURRENT_SESSIONS");
			if(CONCURRENT_SESSIONS==null)
				CONCURRENT_SESSIONS = "0";
			String UNIQUE_USER=(String)resultDataMap.get("UNIQUE_USER");
			if(UNIQUE_USER==null)
				UNIQUE_USER = "0";
			String LOAD_EVALUATOR_PER_SESSION=(String)resultDataMap.get("LOAD_EVALUATOR_PER_SESSION");
			if(LOAD_EVALUATOR_PER_SESSION==null)
				LOAD_EVALUATOR_PER_SESSION = "0";
			String TOTAL_SESSIONS_MAX=(String)resultDataMap.get("TOTAL_SESSIONS_MAX");
			if(TOTAL_SESSIONS_MAX==null)
				TOTAL_SESSIONS_MAX = "0";
			String TOTAL_MACHINE_ACTIVE=(String)resultDataMap.get("TOTAL_MACHINE_ACTIVE");
			if(TOTAL_MACHINE_ACTIVE==null)
				TOTAL_MACHINE_ACTIVE = "0";
			JSONObject barChart = (JSONObject)resultDataMap.get("barChart");
			barChartDataObj = barChart;

			double CPU_UTIL=Double.parseDouble(SESSION_CONSUMED_CPU_UTIL);
			double DISK_USAGE=Double.parseDouble(SESSION_CONSUMED_DISK_USAGE);
			double NETWORK_USAGE=Double.parseDouble(SESSION_CONSUMED_NETWORK_USAGE);
			double MEM_UTIL=Double.parseDouble(SESSION_CONSUMED_MEM_UTIL);
			double SERVERS=Double.parseDouble(TOTAL_SERVERS);
			double SESSIONS=Double.parseDouble(CONCURRENT_SESSIONS);
			double USER=Double.parseDouble(UNIQUE_USER);
			double LOAD_INDEX_PER_SESSION=Double.parseDouble(LOAD_EVALUATOR_PER_SESSION);
			double TOTAL_SESSIONS=Double.parseDouble(TOTAL_SESSIONS_MAX);
			double TOTAL_ACTIVE_MACHINE=Double.parseDouble(TOTAL_MACHINE_ACTIVE);
			double LOAD_EVALVATOR_INDEX = LOAD_INDEX_PER_SESSION;
			double ADDITIONAL_SERVER=0.0;
 
			if(!noDataFound)
			{
				System.out.println("incresaseFactorVal____________ "+incresaseFactorVal);
				if(LOAD_INDEX!=null && LOAD_INDEX.equalsIgnoreCase("yes"))
				{
					resultObj.put("UNIQUE_USER_ORIGINAL",erUtils.roundOffDigit(USER,0));
					resultObj.put("SESSIONS_ORIGINAL",erUtils.roundOffDigit(TOTAL_SESSIONS,0));
					resultObj.put("TOTAL_SERVERS_ORIGINAL",erUtils.roundOffDigit(TOTAL_ACTIVE_MACHINE,0));
					resultObj.put("LOAD_INDEX","yes");
				}
				else
				{
					resultObj.put("UNIQUE_USER_ORIGINAL",erUtils.roundOffDigit(USER,0));
					resultObj.put("SESSIONS_ORIGINAL",erUtils.roundOffDigit(SESSIONS,0));
					resultObj.put("TOTAL_SERVERS_ORIGINAL",erUtils.roundOffDigit(SERVERS,0));
					resultObj.put("LOAD_INDEX","no");
				}

				String isCustomSlider = request.getParameter("isCustomSlider");
				double chartMaxValueVal_cpu = -1;
				double chartMaxValueVal_disk = -1;
				double chartMaxValueVal_memory = -1;
				double chartMaxValueVal_network = -1;
				double chartMaxValueVal_loadIndex = -1;
				double TOTAL_ACTIVE_MACHINE_TEMP = TOTAL_ACTIVE_MACHINE;
				double LOAD_EVALVATOR_INDEX_DIFF = 0.0;

				if(LOAD_INDEX!=null && LOAD_INDEX.equalsIgnoreCase("yes"))
				{
					if(ChartMaxValue_loadIndex==null)
					{
						ChartMaxValue_loadIndex = (TOTAL_SESSIONS * LOAD_EVALVATOR_INDEX)+"";
					}
					if(ChartMaxValue_loadIndex!=null && ChartMaxValue_loadIndex.length()>0)
					{
						try
						{
							chartMaxValueVal_loadIndex = Double.parseDouble(ChartMaxValue_loadIndex);
						}
						catch (Exception ex) 
						{
						}
					}
					LOAD_EVALVATOR_INDEX_DIFF = chartMaxValueVal_loadIndex-(TOTAL_SESSIONS * LOAD_EVALVATOR_INDEX);
					if(LOAD_EVALVATOR_INDEX_DIFF<0)
					{
						LOAD_EVALVATOR_INDEX_DIFF = -Double.parseDouble(erUtils.roundOffDigit(-LOAD_EVALVATOR_INDEX_DIFF,2));
					}
					else
					{
						LOAD_EVALVATOR_INDEX_DIFF = Double.parseDouble(erUtils.roundOffDigit(LOAD_EVALVATOR_INDEX_DIFF,2));
					}
				}
				else
				{
					if(ChartMaxValue_cpu!=null && ChartMaxValue_cpu.length()>0)
					{
						try
						{
							chartMaxValueVal_cpu = Double.parseDouble(ChartMaxValue_cpu);
						}
						catch (Exception ex) 
						{
						}
					}
					if(ChartMaxValue_disk!=null && ChartMaxValue_disk.length()>0)
					{
						try
						{
							chartMaxValueVal_disk = Double.parseDouble(ChartMaxValue_disk);
						}
						catch (Exception ex) 
						{
						}
					}
					if(ChartMaxValue_memory!=null && ChartMaxValue_memory.length()>0)
					{
						try
						{
							chartMaxValueVal_memory = Double.parseDouble(ChartMaxValue_memory);
						}
						catch (Exception ex) 
						{
						}
					}
					if(ChartMaxValue_network!=null && ChartMaxValue_network.length()>0)
					{
						try
						{
							chartMaxValueVal_network = Double.parseDouble(ChartMaxValue_network);
						}
						catch (Exception ex) 
						{
						}
					}
				}
				if(LOAD_INDEX!=null && LOAD_INDEX.equalsIgnoreCase("yes"))
				{
					double orginalVal = (TOTAL_SESSIONS * LOAD_EVALVATOR_INDEX);
					String orginalValStr = erUtils.roundOffDigit(orginalVal,2);
%>
				<div class="printSelectionFields"><%=intlmap.getTextDescription("reporter.common.Load Evalator")%> - <span class="bold">&nbsp;<%=erUtils.roundOffDigit(Double.parseDouble(ChartMaxValue_loadIndex),2)%> % <%=LOAD_EVALVATOR_INDEX_DIFF>0?"("+orginalValStr+" is increased by "+LOAD_EVALVATOR_INDEX_DIFF:"("+orginalValStr+" is decreased by "+(-LOAD_EVALVATOR_INDEX_DIFF)%>)</span></div>
<%
				}
%>
			</div>
<%
				System.out.println("incresaseFactorVal____________ "+incresaseFactorVal);

				if(incresaseFactorVal>0)
				{
					if(LOAD_INDEX!=null && LOAD_INDEX.equalsIgnoreCase("yes"))
					{
						double factorVal = USER/TOTAL_SESSIONS;
						long increaseUserby = (Math.round((incresaseFactorVal/100)*USER));
						if(isNegativefactor)
						{
							USER = Math.round(USER-increaseUserby); // updated User
						}
						else
						{
							USER = Math.round(USER+increaseUserby); // updated User
						}
						TOTAL_SESSIONS = Math.round(USER/factorVal); //updated Session
					}
					else
					{
						double factorVal = USER/SESSIONS;
						long increaseUserby = (Math.round((incresaseFactorVal/100)*USER));
						if(isNegativefactor)
						{
							USER = Math.round(USER-increaseUserby); // updated User
						}
						else
						{
							USER = Math.round(USER+increaseUserby); // updated User
						}
						SESSIONS = Math.round(USER/factorVal); //updated Session
					}
				}
				// Calculate Merer Gauge Chart Value
				boolean needRecalcultion = false;
				double CPU_UTIL_TEMP = 0;
				double DISK_USAGE_TEMP = 0;
				double NETWORK_USAGE_TEMP = 0;
				double MEM_UTIL_TEMP = 0;
				double LOAD_EVALVATOR_INDEX_TEMP = 0;
				if(LOAD_INDEX!=null && LOAD_INDEX.equalsIgnoreCase("yes"))
				{
					LOAD_EVALVATOR_INDEX_TEMP = (TOTAL_SESSIONS * LOAD_EVALVATOR_INDEX);
					//LOAD_EVALVATOR_INDEX_TEMP = LOAD_EVALVATOR_INDEX_TEMP/TOTAL_ACTIVE_MACHINE;
					//if(chartMaxValueVal_loadIndex>0 && chartMaxValueVal_loadIndex<LOAD_EVALVATOR_INDEX_TEMP)
					{
						needRecalcultion = true;
					}
				}
				else
				{
					CPU_UTIL_TEMP = (SESSIONS * CPU_UTIL)/SERVERS;
					DISK_USAGE_TEMP = (SESSIONS * DISK_USAGE)/SERVERS;
					NETWORK_USAGE_TEMP = (SESSIONS * NETWORK_USAGE)/SERVERS;
					MEM_UTIL_TEMP = (SESSIONS * MEM_UTIL)/SERVERS;
					if(chartMaxValueVal_cpu>0 && chartMaxValueVal_cpu<CPU_UTIL_TEMP)
					{
						needRecalcultion = true;
					}
					if(chartMaxValueVal_disk>0 && chartMaxValueVal_disk<DISK_USAGE_TEMP)
					{
						needRecalcultion = true;
					}
					if(chartMaxValueVal_network>0 && chartMaxValueVal_network<NETWORK_USAGE_TEMP)
					{
						needRecalcultion = true;
					}
					if(chartMaxValueVal_memory>0 && chartMaxValueVal_memory<MEM_UTIL_TEMP)
					{
						needRecalcultion = true;
					}
				}

				if(needRecalcultion)
				{
					// now Re-calculation is based on max val resources
					if(LOAD_INDEX!=null && LOAD_INDEX.equalsIgnoreCase("yes"))
					{
						if(chartMaxValueVal_loadIndex>0 && ADDITIONAL_SERVER < LOAD_EVALVATOR_INDEX_TEMP/chartMaxValueVal_loadIndex)
						{
							if(LOAD_EVALVATOR_INDEX_TEMP>chartMaxValueVal_loadIndex)
							{
								while(LOAD_EVALVATOR_INDEX_TEMP>chartMaxValueVal_loadIndex)
								{
									ADDITIONAL_SERVER = ADDITIONAL_SERVER+1;
									LOAD_EVALVATOR_INDEX_TEMP = (TOTAL_SESSIONS * LOAD_EVALVATOR_INDEX*TOTAL_ACTIVE_MACHINE)/(TOTAL_ACTIVE_MACHINE+ADDITIONAL_SERVER);
								}
								if(barChart!=null)
								{
									barChartDataObj = updateBarChartData(barChart,incresaseFactorVal,reportInfo,ChartMaxValue_loadIndex,isNegativefactor,fromRunButton,LOAD_INDEX_PER_SESSION);
									resultObj.put("barChart",barChartDataObj);
								}
							}
							else if (fromRunButton.equalsIgnoreCase("no"))
							{
								TOTAL_ACTIVE_MACHINE_TEMP = (LOAD_EVALVATOR_INDEX_TEMP*TOTAL_ACTIVE_MACHINE)/chartMaxValueVal_loadIndex;
								TOTAL_ACTIVE_MACHINE_TEMP = Math.ceil(TOTAL_ACTIVE_MACHINE_TEMP); // additional 
								ADDITIONAL_SERVER = -(TOTAL_ACTIVE_MACHINE-TOTAL_ACTIVE_MACHINE_TEMP);
								if(barChart!=null)
								{
									barChartDataObj = updateBarChartData(barChart,incresaseFactorVal,reportInfo,ChartMaxValue_loadIndex,isNegativefactor,fromRunButton,LOAD_INDEX_PER_SESSION);
									resultObj.put("barChart",barChartDataObj);
								}
							}
							else
							{
								
								if(barChart!=null)
								{
									resultObj.put("barChart",barChartDataObj);
								}
							}
							//ADDITIONAL_SERVER = Math.ceil((TOTAL_ACTIVE_MACHINE*ADDITIONAL_SERVER)); // additional server percentage
						}
						else if(barChart!=null)
						{
							resultObj.put("barChart",barChartDataObj);
						}
					}
					else
					{
						if(chartMaxValueVal_cpu>0 && ADDITIONAL_SERVER < CPU_UTIL_TEMP/chartMaxValueVal_cpu)
						{
							ADDITIONAL_SERVER = CPU_UTIL_TEMP/chartMaxValueVal_cpu;
						}
						if(chartMaxValueVal_disk>0 && ADDITIONAL_SERVER < DISK_USAGE_TEMP/chartMaxValueVal_disk)
						{
							ADDITIONAL_SERVER = DISK_USAGE_TEMP/chartMaxValueVal_disk;
						}
						if(chartMaxValueVal_memory>0 && ADDITIONAL_SERVER < MEM_UTIL_TEMP/chartMaxValueVal_memory)
						{
							ADDITIONAL_SERVER = MEM_UTIL_TEMP/chartMaxValueVal_memory;
						}
						if(chartMaxValueVal_network>0 && ADDITIONAL_SERVER < NETWORK_USAGE_TEMP/chartMaxValueVal_network)
						{
							ADDITIONAL_SERVER = NETWORK_USAGE_TEMP/chartMaxValueVal_network;
						}
						ADDITIONAL_SERVER = Math.ceil((SERVERS*ADDITIONAL_SERVER)-SERVERS); // additional server percentage
					}

					if(LOAD_INDEX!=null && LOAD_INDEX.equalsIgnoreCase("yes"))
					{
						if(chartMaxValueVal_loadIndex>0)
						{
							LOAD_EVALVATOR_INDEX_TEMP = (TOTAL_SESSIONS * LOAD_EVALVATOR_INDEX*TOTAL_ACTIVE_MACHINE)/(TOTAL_ACTIVE_MACHINE+ADDITIONAL_SERVER);
						}
					}
					else
					{
						if(chartMaxValueVal_cpu>0)
						{
							CPU_UTIL_TEMP = (SESSIONS * CPU_UTIL)/(SERVERS+ADDITIONAL_SERVER);
						}
						if(chartMaxValueVal_disk>0)
						{
							DISK_USAGE_TEMP = (SESSIONS * DISK_USAGE)/(SERVERS+ADDITIONAL_SERVER);
						}
						if(chartMaxValueVal_memory>0)
						{
							NETWORK_USAGE_TEMP = (SESSIONS * NETWORK_USAGE)/(SERVERS+ADDITIONAL_SERVER);
						}
						if(chartMaxValueVal_network>0)
						{
							MEM_UTIL_TEMP = (SESSIONS * MEM_UTIL)/(SERVERS+ADDITIONAL_SERVER);
						}
					}
				}
				if(LOAD_INDEX!=null && LOAD_INDEX.equalsIgnoreCase("yes"))
				{
					resultObj.put("SESSIONS",erUtils.roundOffDigit(TOTAL_SESSIONS,0));
					resultObj.put("TOTAL_SERVERS",erUtils.roundOffDigit(TOTAL_ACTIVE_MACHINE+ADDITIONAL_SERVER,0));
				}
				else
				{
					resultObj.put("SESSIONS",erUtils.roundOffDigit(SESSIONS,0));
					resultObj.put("TOTAL_SERVERS",erUtils.roundOffDigit(SERVERS+ADDITIONAL_SERVER,0));
				}

				String cupColor = reportInfo.getValue("CITRIX_CAPACITY_PREDICTION","cupColor");
				String memoryColor = reportInfo.getValue("CITRIX_CAPACITY_PREDICTION","memoryColor");
				String diskColor = reportInfo.getValue("CITRIX_CAPACITY_PREDICTION","diskColor");
				String networkColor = reportInfo.getValue("CITRIX_CAPACITY_PREDICTION","networkColor");
				String addtionlServerColor = reportInfo.getValue("CITRIX_CAPACITY_PREDICTION","additionalServerColor");
				if(ADDITIONAL_SERVER<0) 
				{
					addtionlServerColor = reportInfo.getValue("CITRIX_CAPACITY_PREDICTION","excessServerColor");
					resultObj.put("ADDITIONAL_SERVER",erUtils.roundOffDigit(-(ADDITIONAL_SERVER),0));
					UiTxt = "Excess Capacity";
				}
				else
				{
					resultObj.put("ADDITIONAL_SERVER",erUtils.roundOffDigit(ADDITIONAL_SERVER,0));
				}
				resultObj.put("UNIQUE_USER",erUtils.roundOffDigit(USER,0));
				if(chartMaxValueVal_cpu>0)
				{
					resultObj.put("CPU_UTIL",erUtils.roundOffDigit(CPU_UTIL_TEMP,2));
					resultObj.put("CPU_UTIL_CHART",this.getGaugeChartData(erUtils.roundOffDigit(CPU_UTIL_TEMP,2),intlmap.getTextDescription("reporter.common.CPU Usage"),cupColor));
					totalGraph = totalGraph+1;
					graphKey.add("CPU_UTIL_CHART");
					graphTitle.add("CPU Usage");
				}
				if(chartMaxValueVal_memory>0)
				{
					resultObj.put("MEM_UTIL",erUtils.roundOffDigit(MEM_UTIL_TEMP,2));
					resultObj.put("MEM_UTIL_CHART",this.getGaugeChartData(erUtils.roundOffDigit(MEM_UTIL_TEMP,2),intlmap.getTextDescription("reporter.common.Memory Usage"),memoryColor));
					totalGraph = totalGraph+1;
					graphKey.add("MEM_UTIL_CHART");
					graphTitle.add("Memory Usage");
				}
				if(chartMaxValueVal_disk>0)
				{
					resultObj.put("DISK_USAGE",erUtils.roundOffDigit(DISK_USAGE_TEMP,2));
					resultObj.put("DISK_USAGE_CHART",this.getGaugeChartData(erUtils.roundOffDigit(DISK_USAGE_TEMP,2),intlmap.getTextDescription("reporter.common.Disk Usage"),diskColor));
					totalGraph = totalGraph+1;
					graphKey.add("DISK_USAGE_CHART");
					graphTitle.add("Disk Busy");
				}
				if(chartMaxValueVal_network>0)
				{
					resultObj.put("NETWORK_USAGE",erUtils.roundOffDigit(NETWORK_USAGE_TEMP,2));
					resultObj.put("NETWORK_USAGE_CHART",this.getGaugeChartData(erUtils.roundOffDigit(NETWORK_USAGE_TEMP,2),intlmap.getTextDescription("reporter.common.Network Usage"),networkColor));
					totalGraph = totalGraph+1;
					graphKey.add("NETWORK_USAGE_CHART");
					graphTitle.add("Network Usage");
				}
				if(chartMaxValueVal_loadIndex>0)
				{
					resultObj.put("LOAD_EVALVATOR_INDEX",erUtils.roundOffDigit(LOAD_EVALVATOR_INDEX_TEMP,2));
					resultObj.put("LOAD_EVALVATOR_INDEX_CHART",this.getGaugeChartData(erUtils.roundOffDigit(LOAD_EVALVATOR_INDEX_TEMP,2),intlmap.getTextDescription("reporter.common.Laod Evalvotor Index"),cupColor));
					//totalGraph = totalGraph+1;
					//graphKey.add("LOAD_EVALVATOR_INDEX_CHART");
					//graphTitle.add("Laod Evalvotor Index");
				}
				if(chartMaxValueVal_loadIndex>0)
				{
					chartDataObj = this.getChartData((String)resultObj.get("TOTAL_SERVERS_ORIGINAL"),(String)resultObj.get("TOTAL_SERVERS"),ADDITIONAL_SERVER+"","#FF7C78", addtionlServerColor);
					resultObj.put("BarChartData",this.getChartData((String)resultObj.get("TOTAL_SERVERS_ORIGINAL"),(String)resultObj.get("TOTAL_SERVERS"),ADDITIONAL_SERVER+"","#FF7C78", addtionlServerColor));
					totalGraph = totalGraph+1;
					graphKey.add("BarChartData");
					graphTitle.add("");
				}
				
				resultObj.put("factorValue",erUtils.roundOffDigit(incresaseFactorVal,0));
				resultObj.put("totalGraph",totalGraph);

				session.setAttribute("CITRIX_CAPACITY_PREDICTION_CHART",resultObj);
				String servletURL = "/final/servlet/com.eg.ErCitrixCapacityPredictionReportC;jsessionid=" + session.getId() + "?forPrint=yes&er_height=150&er_width=230";
	int additionalPos = 0;
	if(pdfPrint!=null && pdfPrint.equalsIgnoreCase("yes"))
	{
		additionalPos = 20;
	}
				%>
	<div class="printOuterBox" style="margin-bottom:10px">
<%
	if(incresaseFactorVal>0)
	{
%>
	<table align="center" valign="middle" width="100%" style="height:90px;border-spacing:0px;">
		<col width="50%"><col width="50%">
		<tr>
			<td style="border-right:1px solid #cdcdcd"> 
				<table align="center" valign="middle" width="100%" style="height:90px;border-spacing:0px;">
				<col width="50%"><col width="50%">
					<tbody>
					<tr>
<%
		if(isNegativefactor)
		{
%>
						<td colspan="2"><div class="newFont_bold15"><egui:intnl text="reporter.common.Load Decreased by" />&nbsp;<%=incresaseFactor%>%</div></td>
<%
		}
		else
		{
%>
						<td colspan="2"><div class="newFont_bold15"><egui:intnl text="reporter.common.Load Increased by" />&nbsp;<%=incresaseFactor%>%</div></td>
<%
		}
%>
					</tr>
					<tr>
						<td align="center">
							<table  align="center" valign="middle">
								<tr>
									<td align="center">
										<div class="iconLogonUser"/>
									</td>
									<td>
										<div class="newFont_bold25"><%=resultObj.get("UNIQUE_USER")%></div>
									</td>
								</tr>
								<tr>
									<td colspan="2">
										<div class="newFont_bold15"><egui:intnl text="reporter.common.Unique Users" /></div>
									</td>
								</tr>
							</table>
						</td>
						<td align="center">
							<table align="center" valign="middle">
								<tr>
									<td align="center">
										<div class="iconSessionsCompleted"/>
									</td>
									<td>
										<div class="newFont_bold25"><%=resultObj.get("SESSIONS")%></div>
									</td>
								</tr>
								<tr>
									<td colspan="2">
										<div class="newFont_bold15"><egui:intnl text="reporter.common.Concurrent Sessions" /></div>
									</td>
								</tr>
							</table>
						</td>
						</tr>
					</tbody>
				</table>
				</td>
				<td>

<%
	}
%>
				<table align="center" valign="middle" width="100%" style="height:90px;border-spacing:0px;">
				<col width="50%"><col width="50%">
					<tbody>
					<tr>
						<td colspan="2"><div style="margin-left:10px" class="newFont_bold15"><egui:intnl text="reporter.common.Current Load" /></div></td>
					</tr>
					<tr>
						<td align="center">
							<table  align="center" valign="middle">
								<tr>
									<td align="center">
										<div class="iconLogonUser"/>
									</td>
									<td>
										<div class="newFont_bold25"><%=resultObj.get("UNIQUE_USER_ORIGINAL")%></div>
									</td>
								</tr>
								<tr>
									<td colspan="2">
										<div class="newFont_bold15"><egui:intnl text="reporter.common.Unique Users" /></div>
									</td>
								</tr>
							</table>
						</td>
						<td align="center">
							<table align="center" valign="middle">
								<tr>
									<td align="center">
										<div class="iconSessionsCompleted"/>
									</td>
									<td>
										<div class="newFont_bold25"><%=resultObj.get("SESSIONS_ORIGINAL")%></div>
									</td>
								</tr>
								<tr>
									<td colspan="2">
										<div class="newFont_bold15"><egui:intnl text="reporter.common.Concurrent Sessions" /></div>
									</td>
								</tr>
							</table>
						</td>
						</tr>
					</tbody>
				</table>
<%
	if(incresaseFactorVal>0)
	{
%>
				</td>
			</tr>
		</table>
<%
	}
%>
	</div>

	<div style="margin-bottom:10px;display:block">
		<table align="center" valign="middle" width="100%" style="padding:0px;" cellspacing="0px"  style="border-spacing:0px">
<%
	String hei = "420px";
	if(totalGraph>2)
	{
%>
		<col width="70%"><col width="30%">
<%
	}
	else
	{
		hei = "250px";
%>
		<col width="60%"><col width="40%">
<%
	}
%>
			<tr>
				<td style="padding-right:5px">
					<div class="printOuterBox" style="height:<%=hei%>">
						<table align="center" valign="top" width="100%" style="border-spacing:0px">
							<tbody>
<%
							String alignStyle = "center";
							if(LOAD_INDEX!=null && LOAD_INDEX.equalsIgnoreCase("yes"))
							{
								alignStyle = "right";
%>
							<tr>
								<td colspan="2"><div class="newFont_bold15"><egui:intnl text="reporter.common.Capacity Prediction" /></div></td>
							</tr>
<%
							}
							else
							{
%>
							<tr>
								<td colspan="2"><div class="newFont_bold15"><egui:intnl text="reporter.common.Resource Usage Prediction" /></div></td>
							</tr>
							<tr>
								<td colspan="2"><div style="margin:5px 0px 5px 0px"><egui:intnl text="reporter.common.For the increased user load, what will be the predicted resource usage?" /></div></td>
							</tr>
<%
							}
%>
							<tr>
								<td style="text-align:<%=alignStyle%>" valign="top">
<%
								if(((String)graphTitle.get(0)).length()>0)
								{
%>
									<div class="printOuterBoxHeader" style="text-align:left"><%=intlmap.getTextDescription("reporter.common."+graphTitle.get(0))%></div>
<%
								}
%>
									<img src="<%=servletURL+"&resultMapKey="+graphKey.get(0)+""%>" />
<%
								if(LOAD_INDEX!=null && LOAD_INDEX.equalsIgnoreCase("yes"))
								{
									JSONArray LegendAry = (JSONArray)chartDataObj.get("LegendAry");

									if(LegendAry!=null)
									{
%>
									</td><td align="left">
									<table align="left" cellpadding="0" cellspacing="0" border="0">
										<tbody>
<%
										for(int z=0;z<LegendAry.size();z=z+3)
										{
%>
											<tr>
												<td><div style="float:left;"><svg xmlns="http://www.w3.org/2000/svg" height="12" width="12">
												<circle cx="4" cy="6" r="3" fill="<%=LegendAry.get(z)%>" stoke-width="0"></circle></svg></div></td>
												<td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal13"><%=LegendAry.get(z+1)%></td>
												<td class="newFont_bold16" align="left">(<%=LegendAry.get(z+2)%>)</td>
											</tr>
<%
										}
									}
%>
										</tbody>
									</table>
<%
								}
%>

								</td>
<%
								if(totalGraph>=2)
								{
%>
								<td style="border-left:1px solid #e9e9e9;text-align:center" valign="top">
									<div style="padding-left:10px;text-align:left" class="printOuterBoxHeader"><%=intlmap.getTextDescription("reporter.common."+graphTitle.get(1))%> </div>
									<img src="<%=servletURL+"&resultMapKey="+graphKey.get(1)+""%>" />
										
								</td>
<%
								}
								else
								{
%>
								<td><div>&nbsp;</div></td>
<%
								}
%>
							</tr>
<%
							if(totalGraph>=3)
							{
%>
							<tr>
								<td style="padding-top:10px;border-top:1px solid #e9e9e9;text-align:center" valign="top">
									<div class="printOuterBoxHeader" style="text-align:left"><%=intlmap.getTextDescription("reporter.common."+graphTitle.get(2))%></div>
									<img src="<%=servletURL+"&resultMapKey="+graphKey.get(2)+""%>" />
										
								</td>
<%
								if(totalGraph>=4)
								{
%>
								<td style="padding-left:10px;padding-top:10px;border-top:1px solid #e9e9e9;border-left:1px solid #e9e9e9;text-align:center" valign="top">
									<div class="printOuterBoxHeader" style="text-align:left"><%=intlmap.getTextDescription("reporter.common."+graphTitle.get(3))%></div>
									<img src="<%=servletURL+"&resultMapKey="+graphKey.get(3)+""%>" />
								</td>
<%
								}
								else
								{
%>
								<td style="padding-left:10px;padding-top:10px;border-top:1px solid #e9e9e9;border-left:1px solid #e9e9e9;text-align:center" valign="top"><div>&nbsp;</div></td>
<%
								}
%>
							</tr>
<%
							}
%>
							</tbody>
						</table>
					</div>
				</td>
				<td align="center" style="padding-left:5px">
					<div class="printOuterBox" style="height:<%=hei%>;">
						<table align="center" valign="middle" width="100%" style="border-spacing:0px">
							<tr>
								<td colspan="<%=totalGraph<=2?2:1%>" width="100%"><div class="printOuterBoxHeader" style="text-align:left"><egui:intnl text="reporter.common.Capacity Requirement" /></div></td>
							</tr>
							<tr>
								<td colspan="2" >
									<div style="word-wrap:none;text-align:left" class="newFont_bold14"><egui:intnl text="reporter.common.Total Capacity" /></div>
								</td>
							</tr>
							<tr>
								<td height="179px">
									<table align="center" valign="middle">
										<tr>
											<td align="center">
												<div class="iconServerGray"></div>
											</td>
											<td>
												<div class="newFont_bold25"><%=resultObj.get("TOTAL_SERVERS_ORIGINAL")%></div>
											</td>
										</tr>
									</table>
								</td>
<%
							if(totalGraph>2)
							{
%>
							</tr>
							<tr>
								<td >
									<text x="<%=72+additionalPos%>" y="88" font-family="Roboto" font-weight="400" font-size="14" fill="#000000" class="newFont_bold14"><egui:intnl text="<%="reporter.common."+UiTxt%>" /></text>
								</td>
							</tr>
							<tr>
								<td>
								<%
									if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
									{
								%>
									<div class="iconServerGray" style="position:relative;top:70px;left:<%=110+additionalPos%>px"></div>
									<div>
										<svg xmlns="http://www.w3.org/2000/svg" width="300" height="140">
								<%
									}
									else
									{
								%>
									 <div class="iconServerGray" style="position:absolute;z-index:99;top:600px;left:<%=820+additionalPos%>px"></div>
									 <div>
										<svg xmlns="http://www.w3.org/2000/svg" width="300" height="140" style="padding-left:40px">
								<%
									}
								%>
											<g>
												<rect x="<%=35+additionalPos%>" y="13" rx="20" ry="20" width="190" height="110" style="fill:#fff;stroke:<%=addtionlServerColor%>;stroke-width:4;opacity:1.0"></rect>
												<text x="<%=140+additionalPos%>" y="68" font-family="Roboto" font-weight="400" font-size="25" fill="#000000"><%=resultObj.get("ADDITIONAL_SERVER")%></text>
											</g>
										</svg>
									</div>
								</td>
								
<%
							}
							else
							{
%>
								<td>
								<%
								//top : 320px ;left:880px for mail
								int leftPixel = 690;
								int topPixel = 340;
								String to_mail = request.getParameter("to_mail");
								if(to_mail !=null && to_mail.equalsIgnoreCase("yes"))
								{
									leftPixel = 880;
									topPixel = 340;
								}
									if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
									{
								%>
									<div class="iconServerGray" style="position:relative;top:48px;left:<%=51%>px"></div>
									<div>
										<svg xmlns="http://www.w3.org/2000/svg" width="155" height="120">
								<%
									}
									else
									{
								%>
									 <div class="iconServerGray" style="position:absolute;z-index:99;top:<%=topPixel%>px;left:<%=leftPixel%>px"></div>
									 <div>
										<svg xmlns="http://www.w3.org/2000/svg" width="155" height="100" style="padding-left:40px">
								<%
									}
								%>
										<g>
											<rect x="10" y="5" rx="20" ry="20" width="140" height="90" style="fill:#fff;stroke:<%=addtionlServerColor%>;stroke-width:4;opacity:1.0"></rect>
											<text x="90" y="48" font-family="Roboto" font-weight="400" font-size="25" fill="#000000"><%=resultObj.get("ADDITIONAL_SERVER")%></text>
											<text x="20" y="70" font-family="Roboto" font-weight="400" font-size="14" fill="#000000"><%=UiTxt%></text>
										</g>
									</svg>
									</div>
								</td>
<%
							}
%>
								
							</tr>
						</table>
					</div>
				</td>
			</tr>
<%
				if(barChart!=null)
				{
%>
			<tr>
			<td colspan="2" align="center">
				<div class="clearDiv">&nbsp;</div>
				<div class="printOuterBox">
					<div class="printOuterBoxHeader" style="text-align:left"><%=intlmap.getTextDescription("reporter.common.Current Sessions vs Servers Used")%></div>
<%
					if(LOAD_INDEX!=null && LOAD_INDEX.equalsIgnoreCase("yes"))
					{
						JSONArray LegendAry = (JSONArray)barChartDataObj.get("LegendAry");
						System.out.println("LegendAryLegendAry "+LegendAry);

						if(LegendAry!=null)
						{
%>
					<table align="center" cellpadding="0" cellspacing="0" border="0">
						<tbody>
							<tr>
<%
							for(int z=0;z<LegendAry.size();z=z+2)
							{
%>
							<td><div style="float:left;"><svg xmlns="http://www.w3.org/2000/svg" height="12" width="12">
							<circle cx="4" cy="6" r="3" fill="<%=LegendAry.get(z)%>" stoke-width="0"></circle></svg></div></td>
							<td style="padding:5px 20px 5px 5px;float:left" class="newFont_normal13"><%=LegendAry.get(z+1)%></td>
<%
							}
						}
%>
							</tr>
						</tbody>
					</table>
<%
					}
%>
					<img src="<%="/final/servlet/com.eg.ErCitrixCapacityPredictionReportC;jsessionid=" + session.getId() + "?forPrint=yes&er_height=330&er_width=800&resultMapKey=barChart"%>"/>
				</div>
			</td>
			</tr>
<%
				}
%>
			
		</table>
	</div>
<%
			}
			else
			{
%>	</div>
	<table align="center" valign="middle" width="100%" >
		<tr>
			<td align="center"><img src='/final/images/Light/nomeasures_custom.png' /></td>
		</tr>
	</table>
<%
			}
		}
		else
		{
%>	</div>
	<table align="center" valign="middle" width="100%" >
		<tr>
			<td align="center"><img src='/final/images/Light/nomeasures_custom.png' /></td>
		</tr>
	</table>
<%
			}
		}
		else
		{
%>
	</div>
	<table align="center" valign="middle" width="100%" >
		<tr>
			<td align="center"><img src='/final/images/Light/nomeasures_custom.png' /></td>
		</tr>
	</table>
<%
	}
	  

	if (!StringUtils.isNull(er_RmDispName)){
		//For Setting the PDf File Name
		er_RmDispName = er_RmDispName.replace(" ","_");
		HashMap paramVal =new HashMap();
		paramVal.put("fileName",er_RmDispName);
		session.setAttribute("parameters", paramVal);
	} else {
		//For Setting the PDf File Name
		HashMap paramVal =new HashMap();
		paramVal.put("fileName","capacity_planning_prediction_report");
		session.setAttribute("parameters", paramVal);
	}
%>	 
<%
		if(pdfPrint !=null && pdfPrint.equalsIgnoreCase("yes"))
		{%>

		<div class="printFooterText"><%=strPrintFooterText%></div>
		<%}%>
</body>
</html>
<%@ include file="ErRemoveUser.jsp"%>
<%!
	public JSONObject updateBarChartData(JSONObject barObject, double incresaseFactorVal, EgReportInfo reportInfo, String ChartMaxValue_loadIndex, boolean isNegativefactor,String fromRunButton, double LOAD_INDEX_PER_SESSION)
	{
		JSONObject retObj = null;
		try
		{
			retObj = new JSONObject();
			JSONArray LegendAry = new JSONArray();
			Iterator itrs = barObject.keySet().iterator();
			while(itrs.hasNext())
			{
				String key = (String)itrs.next();
				Object vals = barObject.get(key);
				if(key.equalsIgnoreCase("DataSet") && vals!=null)
				{
					JSONArray dataSetAry = (JSONArray)vals;
					JSONArray dataSetAryNew = new JSONArray();
					ArrayList updateServerList = new ArrayList();
					for(int i=0;i<dataSetAry.size();i++)
					{
						JSONObject dataSetObjOld = (JSONObject)dataSetAry.get(i);
						JSONObject dataSetObj = new JSONObject();
						Iterator itr = dataSetObjOld.keySet().iterator();
						while(itr.hasNext())
						{
							String key_ = (String)itr.next();
							dataSetObj.put(key_,dataSetObjOld.get(key_));
						}
						String type = (String)dataSetObj.get("type");
						String color = (String)dataSetObj.get("color");
						String name = (String)dataSetObj.get("name");
						JSONArray dataAry = (JSONArray)dataSetObj.get("data");
						JSONObject dataSetObjNew = new JSONObject();
						System.out.println("dataSetObjOld  "+dataSetObjOld);
						LegendAry.add(color);
						LegendAry.add(name);
						if(type.equalsIgnoreCase("column") && dataAry!=null)
						{
							
							dataSetObjNew.put("type","column");
							dataSetObjNew.put("color","#f2bf1b");
							dataSetObjNew.put("yAxis",0);
							dataSetObj.put("pointWidth",10);
							dataSetObjNew.put("pointWidth",25);
							dataSetObjNew.put("pointPadding",0);
							dataSetObjNew.put("pointPlacement",0.37);
							dataSetObj.put("pointPlacement",-0.2);
							dataSetObj.put("name","Current Load");

							JSONArray dataAryNew = new JSONArray();
							boolean isPositiveSession = true;
							for(int j = 0;j<dataAry.size();j++)
							{
								JSONObject dataObj = (JSONObject)dataAry.get(j);
								JSONObject dataObjNew = new JSONObject();
								Object dataValObj = dataObj.get("y");
								String loadIndexPerSession = (String)dataObj.get("load_index");
								String unique_user = (String)dataObj.get("unique_user");
								String server = (String)dataObj.get("server");
								double dataVal = 0;
								if(dataValObj!=null)
								{
									dataVal = Double.parseDouble(dataValObj+"");
								}
								double USER = Double.parseDouble(unique_user);
								double factorVal = USER/dataVal;
								double LOAD_EVALVATOR_INDEX = Double.parseDouble(loadIndexPerSession);
								double TOTAL_ACTIVE_MACHINE = Double.parseDouble(server);
								double TOTAL_ACTIVE_MACHINE_TEMP = TOTAL_ACTIVE_MACHINE;
								double ADDITIONAL_SERVER=0.0;

								if(LOAD_EVALVATOR_INDEX<=0.0)
								{
									LOAD_EVALVATOR_INDEX = LOAD_INDEX_PER_SESSION;
									/*dataObjNew.put("y",dataVal);
									updateServerList.add(ADDITIONAL_SERVER);
									dataAryNew.add(dataObjNew);
									continue;*/
								}
								long increaseUserby = (Math.round((incresaseFactorVal/100)*USER));
								if(isNegativefactor)
								{
									USER = Math.round(USER-increaseUserby); // updated User
								}
								else
								{
									USER = Math.round(USER+increaseUserby); // updated User
								}
								if(Math.round(USER/factorVal)<dataVal)
								{
									isPositiveSession = false;
								}
								dataVal = Math.round(USER/factorVal); //updated Session
								double chartMaxValueVal_loadIndex = 0.0;
								if(ChartMaxValue_loadIndex==null)
								{
									ChartMaxValue_loadIndex = (dataVal * LOAD_EVALVATOR_INDEX)+"";
								}
								if(ChartMaxValue_loadIndex!=null && ChartMaxValue_loadIndex.length()>0)
								{
									try
									{
										chartMaxValueVal_loadIndex = Double.parseDouble(ChartMaxValue_loadIndex);
									}
									catch (Exception ex) 
									{
									}
								}
								double LOAD_EVALVATOR_INDEX_TEMP = (dataVal * LOAD_EVALVATOR_INDEX);
								if(chartMaxValueVal_loadIndex>0 && ADDITIONAL_SERVER < LOAD_EVALVATOR_INDEX_TEMP/chartMaxValueVal_loadIndex)
								{
									if(LOAD_EVALVATOR_INDEX_TEMP>chartMaxValueVal_loadIndex)
									{
										while(LOAD_EVALVATOR_INDEX_TEMP>chartMaxValueVal_loadIndex)
										{
											ADDITIONAL_SERVER = ADDITIONAL_SERVER+1;
											LOAD_EVALVATOR_INDEX_TEMP = (dataVal * LOAD_EVALVATOR_INDEX*TOTAL_ACTIVE_MACHINE)/(TOTAL_ACTIVE_MACHINE+ADDITIONAL_SERVER);
										}
									}
									else if (fromRunButton.equalsIgnoreCase("no"))
									{
										TOTAL_ACTIVE_MACHINE_TEMP = (LOAD_EVALVATOR_INDEX_TEMP*TOTAL_ACTIVE_MACHINE)/chartMaxValueVal_loadIndex;
										TOTAL_ACTIVE_MACHINE_TEMP = Math.ceil(TOTAL_ACTIVE_MACHINE_TEMP); // additional 
										ADDITIONAL_SERVER = -(TOTAL_ACTIVE_MACHINE-TOTAL_ACTIVE_MACHINE_TEMP);
									}
								}
								double dataValNew = dataVal;
								dataObjNew.put("y",dataValNew);
								updateServerList.add(ADDITIONAL_SERVER);
								dataAryNew.add(dataObjNew);
							}
							dataSetObjNew.put("name","Expected Load");
							LegendAry.add("#f2bf1b");
							LegendAry.add("Expected Load");
							if(!isPositiveSession)
							{
								//dataSetObjNew.put("name","Decreased Concurrent Sessions");
							}
							else
							{
								//dataSetObjNew.put("name","Increased Concurrent Sessions");
							}
							dataSetObjNew.put("data",dataAryNew);
							dataSetAryNew.add(dataSetObjNew);
						}
						else if(type.equalsIgnoreCase("line"))
						{
							dataSetObjNew.put("name","Expected Capacity");
							dataSetObjNew.put("type","line");
							dataSetObjNew.put("yAxis",1);
							JSONArray dataAryNew = new JSONArray();
							boolean isPositiveServer = true;
							for(int j = 0;j<dataAry.size();j++)
							{
								JSONObject dataObj = (JSONObject)dataAry.get(j);
								String updateServer = updateServerList.get(j)+"";
								JSONObject dataObjNew = new JSONObject();
								Object dataValObj = dataObj.get("y");
								double dataVal = 0;
								double ADDITIONAL_SERVER = Double.parseDouble(updateServer);
								if(dataValObj!=null)
								{
									dataVal = Double.parseDouble(dataValObj+"");
								}
								if(ADDITIONAL_SERVER<0)
								{
									isPositiveServer = false;
								}
								double dataValNew = dataVal+ADDITIONAL_SERVER;
								dataObjNew.put("y",dataValNew);
								dataAryNew.add(dataObjNew);
							}
							String addtionlServerColor = reportInfo.getValue("CITRIX_CAPACITY_PREDICTION","additionalServerColor");
							if(!isPositiveServer)
							{
								addtionlServerColor = reportInfo.getValue("CITRIX_CAPACITY_PREDICTION","excessServerColor");
							}
							LegendAry.add(addtionlServerColor);
							LegendAry.add("Expected Capacity");
							dataSetObjNew.put("color",addtionlServerColor);
							dataSetObjNew.put("data",dataAryNew);
							dataSetAryNew.add(dataSetObjNew);
							dataSetObj.put("type","line");
						}
						dataSetAryNew.add(dataSetObj);
					}
					retObj.put(key,dataSetAryNew);
				}
				else
				{
					retObj.put(key,vals);
				}
			}
			retObj.put("LegendAry",LegendAry);
		}
		catch(Exception e)
		{
			e.printStackTrace();
			return barObject;
		}
		System.out.println("barObject   "+retObj);
		return retObj;
	}
	public JSONObject getGaugeChartData(String gaugeValue, String title, String color)
	{
		if(color==null || color.length()==0)
		{
			color = "#7CB5EC";
		}
		JSONObject returnObj = new JSONObject();
		try
		{
			JSONArray dataSetAry = new JSONArray();
			JSONArray jsonDataAry = new JSONArray();
			JSONObject dataSetObj = new JSONObject();
			JSONObject dataObj = new JSONObject();
			JSONObject datalabelobj = new JSONObject();
			//datalabelobj.put("format","<span style='font-family:Roboto;font-weight:400;font-size:24px;color:#2a292a;text-align=center'>"+gaugeValue+"</span><span style='font-family:Roboto;font-size:14px;color:#2a292a;text-align=center'> %</span></span>");
			datalabelobj.put("format","<table style='font-family: Roboto;font-size: 24px;font-weight: 400><tr><td><div style='text-align:center;padding:2px;color:#2a292a;font-size:24px;margin-right:2px'>"+gaugeValue+"</div></td><td><div style='text-align:center;padding:2px;color:#2a292a;font-size:14px;margin-right:2px'>%</div></td></tr></table>");

			dataObj.put("color","#e0e0e0");
			dataObj.put("y",100); // this must be max value
			dataObj.put("radius","112%");
			dataObj.put("innerRadius","88%");
			jsonDataAry.add(dataObj);
			dataSetObj.put("data",jsonDataAry);
			dataSetObj.put("name","");
			dataSetObj.put("dataLabels",datalabelobj);
			dataSetAry.add(dataSetObj);

			jsonDataAry = new JSONArray();
			dataSetObj = new JSONObject();
			dataObj = new JSONObject();
			dataObj.put("color",color);
			dataObj.put("y",Double.parseDouble(gaugeValue));
			dataObj.put("radius","112%");
			dataObj.put("innerRadius","88%");
			jsonDataAry.add(dataObj);
			
			dataSetObj.put("data",jsonDataAry);
			dataSetObj.put("dataLabels",datalabelobj);
			dataSetObj.put("name","");
			dataSetAry.add(dataSetObj);

			returnObj.put("chartType","solidgauge");
			returnObj.put("maxValueForDial",100); // this must be max value
			returnObj.put("title",title);
			returnObj.put("unit","%");
			returnObj.put("isRoundBorder",true);
			returnObj.put("startAngle",-160);
			returnObj.put("endAngle",160);
			returnObj.put("DataSet",dataSetAry);
		}
		catch(Exception ee){
			ee.printStackTrace();
		}
		return returnObj;
	}
	public JSONObject getChartData(String availableServer, String totalServer, String additionalServer, String color1,String color2)
	{
		JSONObject returnObj = new JSONObject();
		try
		{
			String UiTxt = "Additional Capacity";
			if(additionalServer.indexOf("-")>-1)
			{
				additionalServer = additionalServer.substring(1);
				UiTxt = "Excess Capacity";
			}
			JSONArray LegendAry = new JSONArray();
			JSONArray dataSetAry = new JSONArray();
			JSONArray jsonDataAry = new JSONArray();
			JSONObject dataSetObj = new JSONObject();
			JSONObject dataObj = new JSONObject();
			dataObj.put("color",color2); 
			dataObj.put("y",Double.parseDouble(additionalServer)); // this available value
			dataObj.put("name",UiTxt);
			if(Double.parseDouble(additionalServer)>0)
			{
				LegendAry.add(color2);
				LegendAry.add(UiTxt);
				LegendAry.add(Math.round(Double.parseDouble(additionalServer)));
			}
			jsonDataAry.add(dataObj);

			dataObj = new JSONObject();
			dataObj.put("color",color1);
			dataObj.put("y",Double.parseDouble(availableServer));
			dataObj.put("name","Available Capacity");
			LegendAry.add(color1);
			LegendAry.add("Available Capacity");
			LegendAry.add(availableServer);
			jsonDataAry.add(dataObj);

			dataSetObj.put("data",jsonDataAry);
			dataSetAry.add(dataSetObj);

			returnObj.put("chartType","donut");
			returnObj.put("innerSize","70%");
			returnObj.put("pieSize","160%");
			returnObj.put("chartHeight",165);
			returnObj.put("chartWidth",165);
			returnObj.put("pieChartTextAlign",22);//new
			returnObj.put("enableTooltpPercent","false");
			returnObj.put("isShadowEnable",false);
			returnObj.put("DataSet",dataSetAry);
			returnObj.put("LegendAry",LegendAry);
			returnObj.put("title","<span align='center' style='font-size:30px;font-family:Roboto;font-weight:400;'>"+totalServer+"</span>");
			returnObj.put("subTitle","<span style='font-size:12px;font-family:Roboto;font-weight:400;'>Total</span>");
			returnObj.put("isDataLabelEnabled",false);
			returnObj.put("isDoNutTitleNeeded", "true");
		}
		catch(Exception ee){
			ee.printStackTrace();
		}
		System.out.println("returnObj  "+returnObj);
		return returnObj;
	}
%>