package com.egurkha.jsp.indexer;
/*     */ 
/*     */ import com.egurkha.jsp.indexer.parser.PageTagExport;
/*     */ import com.egurkha.jsp.indexer.parser.ParseException;
/*     */ import com.egurkha.jsp.indexer.parser.TagExportParser;
/*     */ import jakarta.servlet.jsp.JspException;
/*     */ import jakarta.servlet.jsp.JspTagException;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public abstract class PageTagSupport
/*     */   extends PagerTagSupport
/*     */ {
/*  28 */   private String export = null;
/*     */   
/*  30 */   private PageTagExport pageTagExport = null;
/*  31 */   private Object oldPageUrl = null;
/*  32 */   private Object oldPageNumber = null;
/*  33 */   private Object oldFirstItem = null;
/*  34 */   private Object oldLastItem = null;
/*     */ 
/*     */   
/*     */   public final void setExport(String value) throws JspException {
/*  38 */     if (this.export != value) {
/*     */       
/*     */       try {
/*     */         
/*  42 */         this.pageTagExport = TagExportParser.parsePageTagExport(value);
/*     */       }
/*  44 */       catch (ParseException ex) {
/*     */         
/*  46 */         throw new JspTagException(ex.getMessage());
/*     */       } 
/*     */     }
/*  49 */     this.export = value;
/*     */   }
/*     */ 
/*     */   
/*     */   public final String getExport() {
/*  54 */     return this.export;
/*     */   }
/*     */ 
/*     */   
/*     */   protected final void setPageAttributes(int page) {
/*  59 */     if (this.pageTagExport == null) {
/*     */       
/*  61 */       this.pageContext.setAttribute(
/*  62 */           "pageUrl", 
/*  63 */           this.pagerTag.getPageUrl(page));
/*     */       
/*  65 */       this.pageContext.setAttribute(
/*  66 */           "pageNumber", 
/*  67 */           this.pagerTag.getPageNumber(page));
/*     */     } else {
/*     */       String name;
/*     */ 
/*     */ 
/*     */       
/*  73 */       if ((name = this.pageTagExport.getPageUrl()) != null) {
/*  74 */         this.pageContext.setAttribute(name, this.pagerTag.getPageUrl(page));
/*     */       }
/*  76 */       if ((name = this.pageTagExport.getPageNumber()) != null) {
/*  77 */         this.pageContext.setAttribute(name, this.pagerTag.getPageNumber(page));
/*     */       }
/*  79 */       int maxPageItems = this.pagerTag.getMaxPageItems();
/*     */       
/*  81 */       if ((name = this.pageTagExport.getFirstItem()) != null) {
/*     */         
/*  83 */         int firstItem = page * maxPageItems + 1;
/*  84 */         this.pageContext.setAttribute(name, new Integer(firstItem));
/*     */       } 
/*     */       
/*  87 */       if ((name = this.pageTagExport.getLastItem()) != null) {
/*     */         
/*  89 */         int lastItem = 
/*  90 */           Math.min((page + 1) * maxPageItems, 
/*  91 */             this.pagerTag.getItemCount());
/*  92 */         this.pageContext.setAttribute(name, new Integer(lastItem));
/*     */       } 
/*     */     } 
/*     */   }
/*     */ 
/*     */   
/*     */   protected final void setOffsetAttributes(int offset) {
/*  99 */     if (this.pageTagExport == null) {
/*     */       
/* 101 */       this.pageContext.setAttribute(
/* 102 */           "pageUrl", 
/* 103 */           this.pagerTag.getOffsetUrl(offset));
/* 104 */       this.pageContext.setAttribute(
/* 105 */           "pageNumber", 
/* 106 */           this.pagerTag.getOffsetPageNumber(offset));
/*     */     } else {
/*     */       String name;
/*     */ 
/*     */ 
/*     */       
/* 112 */       if ((name = this.pageTagExport.getPageUrl()) != null) {
/* 113 */         this.pageContext.setAttribute(name, this.pagerTag.getOffsetUrl(offset));
/*     */       }
/* 115 */       if ((name = this.pageTagExport.getPageNumber()) != null) {
/* 116 */         this.pageContext.setAttribute(
/* 117 */             name, 
/* 118 */             this.pagerTag.getOffsetPageNumber(offset));
/*     */       }
/* 120 */       int maxPageItems = this.pagerTag.getMaxPageItems();
/*     */       
/* 122 */       if ((name = this.pageTagExport.getFirstItem()) != null) {
/*     */         
/* 124 */         int firstItem = offset + 1;
/* 125 */         this.pageContext.setAttribute(name, new Integer(firstItem));
/*     */       } 
/*     */       
/* 128 */       if ((name = this.pageTagExport.getLastItem()) != null) {
/*     */         
/* 130 */         int lastItem = 
/* 131 */           Math.min(offset + maxPageItems, this.pagerTag.getItemCount());
/* 132 */         this.pageContext.setAttribute(name, new Integer(lastItem));
/*     */       } 
/*     */     } 
/*     */   }
/*     */ 
/*     */   
/*     */   protected final void removeAttributes() {
/* 139 */     if (this.pageTagExport == null) {
/*     */       
/* 141 */       this.pageContext.removeAttribute("pageUrl");
/* 142 */       this.pageContext.removeAttribute("pageNumber");
/*     */     } else {
/*     */       String name;
/*     */ 
/*     */ 
/*     */       
/* 148 */       if ((name = this.pageTagExport.getPageUrl()) != null) {
/* 149 */         this.pageContext.removeAttribute(name);
/*     */       }
/* 151 */       if ((name = this.pageTagExport.getPageNumber()) != null) {
/* 152 */         this.pageContext.removeAttribute(name);
/*     */       }
/* 154 */       if ((name = this.pageTagExport.getFirstItem()) != null) {
/* 155 */         this.pageContext.removeAttribute(name);
/*     */       }
/* 157 */       if ((name = this.pageTagExport.getLastItem()) != null) {
/* 158 */         this.pageContext.removeAttribute(name);
/*     */       }
/*     */     } 
/*     */   }
/*     */   
/*     */   public int doStartTag() throws JspException {
/* 164 */     super.doStartTag();
/*     */     
/* 166 */     if (this.pageTagExport == null) {
/*     */       
/* 168 */       this.oldPageUrl = this.pageContext.getAttribute("pageUrl");
/* 169 */       this.oldPageNumber = this.pageContext.getAttribute("pageNumber");
/*     */     } else {
/*     */       String name;
/*     */ 
/*     */ 
/*     */       
/* 175 */       if ((name = this.pageTagExport.getPageUrl()) != null) {
/* 176 */         this.oldPageUrl = this.pageContext.getAttribute(name);
/*     */       }
/* 178 */       if ((name = this.pageTagExport.getPageNumber()) != null) {
/* 179 */         this.oldPageNumber = this.pageContext.getAttribute(name);
/*     */       }
/* 181 */       if ((name = this.pageTagExport.getFirstItem()) != null) {
/* 182 */         this.oldFirstItem = this.pageContext.getAttribute(name);
/*     */       }
/* 184 */       if ((name = this.pageTagExport.getLastItem()) != null) {
/* 185 */         this.oldLastItem = this.pageContext.getAttribute(name);
/*     */       }
/*     */     } 
/* 188 */     return 1;
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   public int doEndTag() throws JspException {
/* 194 */     if (this.pageTagExport == null) {
/*     */       
/* 196 */       restoreAttribute("pageUrl", this.oldPageUrl);
/* 197 */       restoreAttribute("pageNumber", this.oldPageNumber);
/* 198 */       this.oldPageUrl = null;
/* 199 */       this.oldPageNumber = null;
/*     */     } else {
/*     */       String name;
/*     */ 
/*     */ 
/*     */       
/* 205 */       if ((name = this.pageTagExport.getPageUrl()) != null) {
/*     */         
/* 207 */         restoreAttribute(name, this.oldPageUrl);
/* 208 */         this.oldPageUrl = null;
/*     */       } 
/*     */       
/* 211 */       if ((name = this.pageTagExport.getPageNumber()) != null) {
/*     */         
/* 213 */         restoreAttribute(name, this.oldPageNumber);
/* 214 */         this.oldPageNumber = null;
/*     */       } 
/*     */       
/* 217 */       if ((name = this.pageTagExport.getFirstItem()) != null) {
/*     */         
/* 219 */         restoreAttribute(name, this.oldFirstItem);
/* 220 */         this.oldFirstItem = null;
/*     */       } 
/*     */       
/* 223 */       if ((name = this.pageTagExport.getLastItem()) != null) {
/*     */         
/* 225 */         restoreAttribute(name, this.oldLastItem);
/* 226 */         this.oldLastItem = null;
/*     */       } 
/*     */     } 
/*     */     
/* 230 */     super.doEndTag();
/*     */     
/* 232 */     return 6;
/*     */   }
/*     */ 
/*     */   
/*     */   public void release() {
/* 237 */     this.export = null;
/* 238 */     this.pageTagExport = null;
/* 239 */     this.oldPageUrl = null;
/* 240 */     this.oldPageNumber = null;
/* 241 */     this.oldFirstItem = null;
/* 242 */     this.oldLastItem = null;
/* 243 */     super.release();
/*     */   }
/*     */ }


/* Location:              C:\Users\dhanabal\Desktop\Index\!\com\egurkha\jsp\indexer\PageTagSupport.class
 * Java compiler version: 1 (45.3)
 * JD-Core Version:       1.1.3
 */