/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.Repository;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.generic.ReferenceType;

public class ObjectType
extends ReferenceType {
    private final String className;

    public static ObjectType getInstance(String className) {
        return new ObjectType(className);
    }

    public ObjectType(String className) {
        super((byte)14, "L" + className.replace('.', '/') + ";");
        this.className = className.replace('/', '.');
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public int hashCode() {
        return this.className.hashCode();
    }

    @Override
    public boolean equals(Object type) {
        return type instanceof ObjectType ? ((ObjectType)type).className.equals(this.className) : false;
    }

    @Deprecated
    public boolean referencesClass() {
        try {
            JavaClass jc = Repository.lookupClass(this.className);
            return jc.isClass();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Deprecated
    public boolean referencesInterface() {
        try {
            JavaClass jc = Repository.lookupClass(this.className);
            return !jc.isClass();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public boolean referencesClassExact() throws ClassNotFoundException {
        JavaClass jc = Repository.lookupClass(this.className);
        return jc.isClass();
    }

    public boolean referencesInterfaceExact() throws ClassNotFoundException {
        JavaClass jc = Repository.lookupClass(this.className);
        return !jc.isClass();
    }

    public boolean subclassOf(ObjectType superclass) throws ClassNotFoundException {
        if (this.referencesInterfaceExact() || superclass.referencesInterfaceExact()) {
            return false;
        }
        return Repository.instanceOf(this.className, superclass.className);
    }

    public boolean accessibleTo(ObjectType accessor) throws ClassNotFoundException {
        JavaClass jc = Repository.lookupClass(this.className);
        if (jc.isPublic()) {
            return true;
        }
        JavaClass acc = Repository.lookupClass(accessor.className);
        return acc.getPackageName().equals(jc.getPackageName());
    }
}

