/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.algorithms.implementations;

import com.sun.org.apache.xml.internal.security.algorithms.JCEMapper;
import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithmSpi;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class SignatureBaseRSA
extends SignatureAlgorithmSpi {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureBaseRSA.class);
    private final Signature signatureAlgorithm;

    public SignatureBaseRSA() throws XMLSignatureException {
        this(null);
    }

    public SignatureBaseRSA(Provider provider) throws XMLSignatureException {
        String string = JCEMapper.translateURItoJCEID(this.engineGetURI());
        LOG.debug("Created SignatureRSA using {}", string);
        try {
            String string2;
            this.signatureAlgorithm = provider == null ? ((string2 = JCEMapper.getProviderId()) == null ? Signature.getInstance(string) : Signature.getInstance(string, string2)) : Signature.getInstance(string, provider);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException generalSecurityException) {
            Object[] objectArray = new Object[]{string, generalSecurityException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray);
        }
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.setParameter(algorithmParameterSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLSignatureException(invalidAlgorithmParameterException);
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws XMLSignatureException {
        try {
            return this.signatureAlgorithm.verify(byArray);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException(signatureException);
        }
    }

    @Override
    protected void engineInitVerify(Key key) throws XMLSignatureException {
        SignatureBaseRSA.engineInitVerify(key, this.signatureAlgorithm);
    }

    @Override
    protected byte[] engineSign() throws XMLSignatureException {
        try {
            return this.signatureAlgorithm.sign();
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException(signatureException);
        }
    }

    @Override
    protected void engineInitSign(Key key, SecureRandom secureRandom) throws XMLSignatureException {
        SignatureBaseRSA.engineInitSign(key, secureRandom, this.signatureAlgorithm);
    }

    @Override
    protected void engineInitSign(Key key) throws XMLSignatureException {
        this.engineInitSign(key, (SecureRandom)null);
    }

    @Override
    protected void engineUpdate(byte[] byArray) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.update(byArray);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException(signatureException);
        }
    }

    @Override
    protected void engineUpdate(byte by) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.update(by);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException(signatureException);
        }
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.update(byArray, n, n2);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException(signatureException);
        }
    }

    @Override
    protected String engineGetJCEAlgorithmString() {
        return this.signatureAlgorithm.getAlgorithm();
    }

    @Override
    protected String engineGetJCEProviderName() {
        return this.signatureAlgorithm.getProvider().getName();
    }

    @Override
    protected void engineSetHMACOutputLength(int n) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.HMACOutputLengthOnlyForHMAC");
    }

    @Override
    protected void engineInitSign(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.CannotUseAlgorithmParameterSpecOnRSA");
    }

    public static class SignatureRSASSAPSS
    extends SignatureBaseRSA {
        PSSParameterSpec pssParameterSpec;

        public SignatureRSASSAPSS() throws XMLSignatureException {
        }

        public SignatureRSASSAPSS(Provider provider) throws XMLSignatureException {
            super(provider);
        }

        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2007/05/xmldsig-more#rsa-pss";
        }

        @Override
        protected void engineAddContextToElement(Element element) throws XMLSignatureException {
            if (element == null) {
                throw new IllegalArgumentException("null element");
            }
            Document document = element.getOwnerDocument();
            Element element2 = document.createElementNS("http://www.w3.org/2007/05/xmldsig-more#", "pss:RSAPSSParams");
            element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:pss", "http://www.w3.org/2007/05/xmldsig-more#");
            Element element3 = XMLUtils.createElementInSignatureSpace(element2.getOwnerDocument(), "DigestMethod");
            element3.setAttributeNS(null, "Algorithm", DigestAlgorithm.fromDigestAlgorithm(this.pssParameterSpec.getDigestAlgorithm()).getXmlDigestAlgorithm());
            XMLUtils.addReturnToElement(element2);
            element2.appendChild(element3);
            XMLUtils.addReturnToElement(element2);
            Element element4 = element2.getOwnerDocument().createElementNS("http://www.w3.org/2007/05/xmldsig-more#", "pss:SaltLength");
            Text text = element2.getOwnerDocument().createTextNode(String.valueOf(this.pssParameterSpec.getSaltLength()));
            element4.appendChild(text);
            element2.appendChild(element4);
            XMLUtils.addReturnToElement(element2);
            Element element5 = element2.getOwnerDocument().createElementNS("http://www.w3.org/2007/05/xmldsig-more#", "pss:TrailerField");
            Text text2 = element2.getOwnerDocument().createTextNode(String.valueOf(this.pssParameterSpec.getTrailerField()));
            element5.appendChild(text2);
            element2.appendChild(element5);
            XMLUtils.addReturnToElement(element2);
            XMLUtils.addReturnToElement(element);
            element.appendChild(element2);
            XMLUtils.addReturnToElement(element);
        }

        @Override
        protected void engineGetContextFromElement(Element element) throws XMLSignatureException {
            if (this.pssParameterSpec == null) {
                super.engineGetContextFromElement(element);
                Element element2 = XMLUtils.selectNode(element.getFirstChild(), "http://www.w3.org/2007/05/xmldsig-more#", "RSAPSSParams", 0);
                if (element2 == null) {
                    throw new XMLSignatureException("algorithms.MissingRSAPSSParams");
                }
                Element element3 = XMLUtils.selectNode(element2.getFirstChild(), "http://www.w3.org/2007/05/xmldsig-more#", "SaltLength", 0);
                Element element4 = XMLUtils.selectNode(element2.getFirstChild(), "http://www.w3.org/2007/05/xmldsig-more#", "TrailerField", 0);
                int n = 1;
                if (element4 != null) {
                    try {
                        n = Integer.parseInt(element4.getTextContent());
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new XMLSignatureException("empty", new Object[]{"Invalid trailer field value supplied"});
                    }
                }
                String string = XMLUtils.selectDsNode(element2.getFirstChild(), "DigestMethod", 0).getAttribute("Algorithm");
                DigestAlgorithm digestAlgorithm = DigestAlgorithm.fromXmlDigestAlgorithm(string);
                String string2 = digestAlgorithm.getDigestAlgorithm();
                int n2 = digestAlgorithm.getSaltLength();
                if (element3 != null) {
                    try {
                        n2 = Integer.parseInt(element3.getTextContent());
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new XMLSignatureException("empty", new Object[]{"Invalid salt length value supplied"});
                    }
                }
                this.engineSetParameter(new PSSParameterSpec(string2, "MGF1", new MGF1ParameterSpec(string2), n2, n));
            }
        }

        @Override
        protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
            this.pssParameterSpec = (PSSParameterSpec)algorithmParameterSpec;
            super.engineSetParameter(algorithmParameterSpec);
        }

        public static enum DigestAlgorithm {
            SHA256("SHA-256", "http://www.w3.org/2001/04/xmlenc#sha256", 32),
            SHA384("SHA-384", "http://www.w3.org/2001/04/xmldsig-more#sha384", 48),
            SHA512("SHA-512", "http://www.w3.org/2001/04/xmlenc#sha512", 64);

            private final String xmlDigestAlgorithm;
            private final String digestAlgorithm;
            private final int saltLength;

            private DigestAlgorithm(String string2, String string3, int n2) {
                this.digestAlgorithm = string2;
                this.xmlDigestAlgorithm = string3;
                this.saltLength = n2;
            }

            public String getXmlDigestAlgorithm() {
                return this.xmlDigestAlgorithm;
            }

            public String getDigestAlgorithm() {
                return this.digestAlgorithm;
            }

            public int getSaltLength() {
                return this.saltLength;
            }

            public static DigestAlgorithm fromXmlDigestAlgorithm(String string) throws XMLSignatureException {
                for (DigestAlgorithm digestAlgorithm : DigestAlgorithm.values()) {
                    if (!digestAlgorithm.getXmlDigestAlgorithm().equals(string)) continue;
                    return digestAlgorithm;
                }
                throw new XMLSignatureException();
            }

            public static DigestAlgorithm fromDigestAlgorithm(String string) throws XMLSignatureException {
                for (DigestAlgorithm digestAlgorithm : DigestAlgorithm.values()) {
                    if (!digestAlgorithm.getDigestAlgorithm().equals(string)) continue;
                    return digestAlgorithm;
                }
                throw new XMLSignatureException();
            }
        }
    }

    public static class SignatureRSASHA3_512MGF1
    extends SignatureBaseRSA {
        public SignatureRSASHA3_512MGF1() throws XMLSignatureException {
        }

        public SignatureRSASHA3_512MGF1(Provider provider) throws XMLSignatureException {
            super(provider);
        }

        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2007/05/xmldsig-more#sha3-512-rsa-MGF1";
        }
    }

    public static class SignatureRSASHA3_384MGF1
    extends SignatureBaseRSA {
        public SignatureRSASHA3_384MGF1() throws XMLSignatureException {
        }

        public SignatureRSASHA3_384MGF1(Provider provider) throws XMLSignatureException {
            super(provider);
        }

        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2007/05/xmldsig-more#sha3-384-rsa-MGF1";
        }
    }

    public static class SignatureRSASHA3_256MGF1
    extends SignatureBaseRSA {
        public SignatureRSASHA3_256MGF1() throws XMLSignatureException {
        }

        public SignatureRSASHA3_256MGF1(Provider provider) throws XMLSignatureException {
            super(provider);
        }

        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2007/05/xmldsig-more#sha3-256-rsa-MGF1";
        }
    }

    public static class SignatureRSASHA3_224MGF1
    extends SignatureBaseRSA {
        public SignatureRSASHA3_224MGF1() throws XMLSignatureException {
        }

        public SignatureRSASHA3_224MGF1(Provider provider) throws XMLSignatureException {
            super(provider);
        }

        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2007/05/xmldsig-more#sha3-224-rsa-MGF1";
        }
    }

    public static class SignatureRSASHA512MGF1
    extends SignatureBaseRSA {
        public SignatureRSASHA512MGF1() throws XMLSignatureException {
        }

        public SignatureRSASHA512MGF1(Provider provider) throws XMLSignatureException {
            super(provider);
        }

        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2007/05/xmldsig-more#sha512-rsa-MGF1";
        }
    }

    public static class SignatureRSASHA384MGF1
    extends SignatureBaseRSA {
        public SignatureRSASHA384MGF1() throws XMLSignatureException {
        }

        public SignatureRSASHA384MGF1(Provider provider) throws XMLSignatureException {
            super(provider);
        }

        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2007/05/xmldsig-more#sha384-rsa-MGF1";
        }
    }

    public static class SignatureRSASHA256MGF1
    extends SignatureBaseRSA {
        public SignatureRSASHA256MGF1() throws XMLSignatureException {
        }

        public SignatureRSASHA256MGF1(Provider provider) throws XMLSignatureException {
            super(provider);
        }

        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1";
        }
    }

    public static class SignatureRSASHA224MGF1
    extends SignatureBaseRSA {
        public SignatureRSASHA224MGF1() throws XMLSignatureException {
        }

        public SignatureRSASHA224MGF1(Provider provider) throws XMLSignatureException {
            super(provider);
        }

        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2007/05/xmldsig-more#sha224-rsa-MGF1";
        }
    }

    public static class SignatureRSASHA1MGF1
    extends SignatureBaseRSA {
        public SignatureRSASHA1MGF1() throws XMLSignatureException {
        }

        public SignatureRSASHA1MGF1(Provider provider) throws XMLSignatureException {
            super(provider);
        }

        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2007/05/xmldsig-more#sha1-rsa-MGF1";
        }
    }

    public static class SignatureRSAMD5
    extends SignatureBaseRSA {
        public SignatureRSAMD5() throws XMLSignatureException {
        }

        public SignatureRSAMD5(Provider provider) throws XMLSignatureException {
            super(provider);
        }

        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-md5";
        }
    }

    public static class SignatureRSARIPEMD160
    extends SignatureBaseRSA {
        public SignatureRSARIPEMD160() throws XMLSignatureException {
        }

        public SignatureRSARIPEMD160(Provider provider) throws XMLSignatureException {
            super(provider);
        }

        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160";
        }
    }

    public static class SignatureRSASHA512
    extends SignatureBaseRSA {
        public SignatureRSASHA512() throws XMLSignatureException {
        }

        public SignatureRSASHA512(Provider provider) throws XMLSignatureException {
            super(provider);
        }

        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
        }
    }

    public static class SignatureRSASHA384
    extends SignatureBaseRSA {
        public SignatureRSASHA384() throws XMLSignatureException {
        }

        public SignatureRSASHA384(Provider provider) throws XMLSignatureException {
            super(provider);
        }

        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384";
        }
    }

    public static class SignatureRSASHA256
    extends SignatureBaseRSA {
        public SignatureRSASHA256() throws XMLSignatureException {
        }

        public SignatureRSASHA256(Provider provider) throws XMLSignatureException {
            super(provider);
        }

        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
        }
    }

    public static class SignatureRSASHA224
    extends SignatureBaseRSA {
        public SignatureRSASHA224() throws XMLSignatureException {
        }

        public SignatureRSASHA224(Provider provider) throws XMLSignatureException {
            super(provider);
        }

        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha224";
        }
    }

    public static class SignatureRSASHA1
    extends SignatureBaseRSA {
        public SignatureRSASHA1() throws XMLSignatureException {
        }

        public SignatureRSASHA1(Provider provider) throws XMLSignatureException {
            super(provider);
        }

        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        }
    }
}

