/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.LocalVariable;
import com.sun.org.apache.bcel.internal.generic.BranchInstruction;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InstructionTargeter;
import com.sun.org.apache.bcel.internal.generic.NamedAndTyped;
import com.sun.org.apache.bcel.internal.generic.Type;

public class LocalVariableGen
implements InstructionTargeter,
NamedAndTyped,
Cloneable {
    private int index;
    private String name;
    private Type type;
    private InstructionHandle start;
    private InstructionHandle end;
    private int orig_index;
    private boolean live_to_end;

    public LocalVariableGen(int n, String string, Type type, InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        if (n < 0 || n > 65535) {
            throw new ClassGenException("Invalid index index: " + n);
        }
        this.name = string;
        this.type = type;
        this.index = n;
        this.setStart(instructionHandle);
        this.setEnd(instructionHandle2);
        this.orig_index = n;
        this.live_to_end = instructionHandle2 == null;
    }

    public LocalVariableGen(int n, String string, Type type, InstructionHandle instructionHandle, InstructionHandle instructionHandle2, int n2) {
        this(n, string, type, instructionHandle, instructionHandle2);
        this.orig_index = n2;
    }

    public LocalVariable getLocalVariable(ConstantPoolGen constantPoolGen) {
        int n = 0;
        int n2 = 0;
        if (this.start != null && this.end != null) {
            n = this.start.getPosition();
            n2 = this.end.getPosition() - n;
            if (this.end.getNext() == null && this.live_to_end) {
                n2 += this.end.getInstruction().getLength();
            }
        }
        int n3 = constantPoolGen.addUtf8(this.name);
        int n4 = constantPoolGen.addUtf8(this.type.getSignature());
        return new LocalVariable(n, n2, n3, n4, this.index, constantPoolGen.getConstantPool(), this.orig_index);
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    public int getOrigIndex() {
        return this.orig_index;
    }

    public void setLiveToEnd(boolean bl) {
        this.live_to_end = bl;
    }

    public boolean getLiveToEnd() {
        return this.live_to_end;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public InstructionHandle getStart() {
        return this.start;
    }

    public InstructionHandle getEnd() {
        return this.end;
    }

    public void setStart(InstructionHandle instructionHandle) {
        BranchInstruction.notifyTarget(this.start, instructionHandle, this);
        this.start = instructionHandle;
    }

    public void setEnd(InstructionHandle instructionHandle) {
        BranchInstruction.notifyTarget(this.end, instructionHandle, this);
        this.end = instructionHandle;
    }

    @Override
    public void updateTarget(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        boolean bl = false;
        if (this.start == instructionHandle) {
            bl = true;
            this.setStart(instructionHandle2);
        }
        if (this.end == instructionHandle) {
            bl = true;
            this.setEnd(instructionHandle2);
        }
        if (!bl) {
            throw new ClassGenException("Not targeting " + instructionHandle + ", but {" + this.start + ", " + this.end + "}");
        }
    }

    void dispose() {
        this.setStart(null);
        this.setEnd(null);
    }

    @Override
    public boolean containsTarget(InstructionHandle instructionHandle) {
        return this.start == instructionHandle || this.end == instructionHandle;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.type.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof LocalVariableGen)) {
            return false;
        }
        LocalVariableGen localVariableGen = (LocalVariableGen)object;
        return localVariableGen.index == this.index && localVariableGen.start == this.start && localVariableGen.end == this.end;
    }

    public String toString() {
        return "LocalVariableGen(" + this.name + ", " + this.type + ", " + this.start + ", " + this.end + ")";
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Clone Not Supported");
        }
    }
}

