/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import com.sun.org.apache.bcel.internal.Const;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.Code;
import com.sun.org.apache.bcel.internal.classfile.CodeException;
import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantCP;
import com.sun.org.apache.bcel.internal.classfile.ConstantFieldref;
import com.sun.org.apache.bcel.internal.classfile.ConstantInterfaceMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantInvokeDynamic;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantNameAndType;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.LocalVariable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariableTable;
import com.sun.org.apache.bcel.internal.classfile.Method;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.util.ByteSequence;
import com.sun.org.apache.bcel.internal.util.Class2HTML;
import com.sun.org.apache.bcel.internal.util.ConstantHTML;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.BitSet;

final class CodeHTML {
    private final String class_name;
    private final PrintWriter file;
    private BitSet goto_set;
    private final ConstantPool constant_pool;
    private final ConstantHTML constant_html;
    private static boolean wide = false;

    CodeHTML(String string, String string2, Method[] methodArray, ConstantPool constantPool, ConstantHTML constantHTML) throws IOException {
        this.class_name = string2;
        this.constant_pool = constantPool;
        this.constant_html = constantHTML;
        this.file = new PrintWriter(new FileOutputStream(string + string2 + "_code.html"));
        this.file.println("<HTML><BODY BGCOLOR=\"#C0C0C0\">");
        for (int i = 0; i < methodArray.length; ++i) {
            this.writeMethod(methodArray[i], i);
        }
        this.file.println("</BODY></HTML>");
        this.file.close();
    }

    private String codeToHTML(ByteSequence byteSequence, int n) throws IOException {
        int n2;
        int n3;
        short s = (short)byteSequence.readUnsignedByte();
        int n4 = 0;
        int n5 = 0;
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("<TT>").append(Const.getOpcodeName(s)).append("</TT></TD><TD>");
        if (s == 170 || s == 171) {
            n3 = byteSequence.getIndex() % 4;
            n5 = n3 == 0 ? 0 : 4 - n3;
            for (n2 = 0; n2 < n5; ++n2) {
                byteSequence.readByte();
            }
            n4 = byteSequence.readInt();
        }
        switch (s) {
            case 170: {
                int n6 = byteSequence.readInt();
                int n7 = byteSequence.readInt();
                int n8 = byteSequence.getIndex() - 12 - n5 - 1;
                n4 += n8;
                stringBuilder.append("<TABLE BORDER=1><TR>");
                int[] nArray = new int[n7 - n6 + 1];
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    nArray[n3] = n8 + byteSequence.readInt();
                    stringBuilder.append("<TH>").append(n6 + n3).append("</TH>");
                }
                stringBuilder.append("<TH>default</TH></TR>\n<TR>");
                for (int n9 : nArray) {
                    stringBuilder.append("<TD><A HREF=\"#code").append(n).append("@").append(n9).append("\">").append(n9).append("</A></TD>");
                }
                stringBuilder.append("<TD><A HREF=\"#code").append(n).append("@").append(n4).append("\">").append(n4).append("</A></TD></TR>\n</TABLE>\n");
                break;
            }
            case 171: {
                n3 = byteSequence.readInt();
                int n10 = byteSequence.getIndex() - 8 - n5 - 1;
                int[] nArray = new int[n3];
                n4 += n10;
                stringBuilder.append("<TABLE BORDER=1><TR>");
                for (n2 = 0; n2 < n3; ++n2) {
                    int n11 = byteSequence.readInt();
                    nArray[n2] = n10 + byteSequence.readInt();
                    stringBuilder.append("<TH>").append(n11).append("</TH>");
                }
                stringBuilder.append("<TH>default</TH></TR>\n<TR>");
                for (n2 = 0; n2 < n3; ++n2) {
                    stringBuilder.append("<TD><A HREF=\"#code").append(n).append("@").append(nArray[n2]).append("\">").append(nArray[n2]).append("</A></TD>");
                }
                stringBuilder.append("<TD><A HREF=\"#code").append(n).append("@").append(n4).append("\">").append(n4).append("</A></TD></TR>\n</TABLE>\n");
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                int n12 = byteSequence.getIndex() + byteSequence.readShort() - 1;
                stringBuilder.append("<A HREF=\"#code").append(n).append("@").append(n12).append("\">").append(n12).append("</A>");
                break;
            }
            case 200: 
            case 201: {
                n2 = byteSequence.getIndex() + byteSequence.readInt() - 1;
                stringBuilder.append("<A HREF=\"#code").append(n).append("@").append(n2).append("\">").append(n2).append("</A>");
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                int n13;
                if (wide) {
                    n13 = byteSequence.readShort();
                    wide = false;
                } else {
                    n13 = byteSequence.readUnsignedByte();
                }
                stringBuilder.append("%").append(n13);
                break;
            }
            case 196: {
                wide = true;
                stringBuilder.append("(wide)");
                break;
            }
            case 188: {
                stringBuilder.append("<FONT COLOR=\"#00FF00\">").append(Const.getTypeName(byteSequence.readByte())).append("</FONT>");
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                int n14 = byteSequence.readShort();
                ConstantFieldref constantFieldref = (ConstantFieldref)this.constant_pool.getConstant(n14, (byte)9);
                int n15 = constantFieldref.getClassIndex();
                String string = this.constant_pool.getConstantString(n15, (byte)7);
                string = Utility.compactClassName(string, false);
                n14 = constantFieldref.getNameAndTypeIndex();
                String string2 = this.constant_pool.constantToString(n14, (byte)12);
                if (string.equals(this.class_name)) {
                    stringBuilder.append("<A HREF=\"").append(this.class_name).append("_methods.html#field").append(string2).append("\" TARGET=Methods>").append(string2).append("</A>\n");
                    break;
                }
                stringBuilder.append(this.constant_html.referenceConstant(n15)).append(".").append(string2);
                break;
            }
            case 187: 
            case 192: 
            case 193: {
                short s2 = byteSequence.readShort();
                stringBuilder.append(this.constant_html.referenceConstant(s2));
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: {
                String string;
                int n16;
                int n17;
                Constant constant;
                short s3 = byteSequence.readShort();
                if (s == 185) {
                    byteSequence.readUnsignedByte();
                    byteSequence.readUnsignedByte();
                    constant = (ConstantInterfaceMethodref)this.constant_pool.getConstant(s3, (byte)11);
                    n17 = ((ConstantCP)constant).getClassIndex();
                    n16 = ((ConstantCP)constant).getNameAndTypeIndex();
                    string = Class2HTML.referenceClass(n17);
                } else if (s == 186) {
                    byteSequence.readUnsignedByte();
                    byteSequence.readUnsignedByte();
                    constant = (ConstantInvokeDynamic)this.constant_pool.getConstant(s3, (byte)18);
                    n16 = ((ConstantCP)constant).getNameAndTypeIndex();
                    string = "#" + ((ConstantInvokeDynamic)constant).getBootstrapMethodAttrIndex();
                } else {
                    constant = (ConstantMethodref)this.constant_pool.getConstant(s3, (byte)10);
                    n17 = ((ConstantCP)constant).getClassIndex();
                    n16 = ((ConstantCP)constant).getNameAndTypeIndex();
                    string = Class2HTML.referenceClass(n17);
                }
                String string3 = Class2HTML.toHTML(this.constant_pool.constantToString(this.constant_pool.getConstant(n16, (byte)12)));
                constant = (ConstantNameAndType)this.constant_pool.getConstant(n16, (byte)12);
                String string4 = this.constant_pool.constantToString(((ConstantNameAndType)constant).getSignatureIndex(), (byte)1);
                String[] stringArray = Utility.methodSignatureArgumentTypes(string4, false);
                String string5 = Utility.methodSignatureReturnType(string4, false);
                stringBuilder.append(string).append(".<A HREF=\"").append(this.class_name).append("_cp.html#cp").append(s3).append("\" TARGET=ConstantPool>").append(string3).append("</A>").append("(");
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuilder.append(Class2HTML.referenceType(stringArray[i]));
                    if (i >= stringArray.length - 1) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append("):").append(Class2HTML.referenceType(string5));
                break;
            }
            case 19: 
            case 20: {
                short s4 = byteSequence.readShort();
                stringBuilder.append("<A HREF=\"").append(this.class_name).append("_cp.html#cp").append(s4).append("\" TARGET=\"ConstantPool\">").append(Class2HTML.toHTML(this.constant_pool.constantToString(s4, this.constant_pool.getConstant(s4).getTag()))).append("</a>");
                break;
            }
            case 18: {
                int n18 = byteSequence.readUnsignedByte();
                stringBuilder.append("<A HREF=\"").append(this.class_name).append("_cp.html#cp").append(n18).append("\" TARGET=\"ConstantPool\">").append(Class2HTML.toHTML(this.constant_pool.constantToString(n18, this.constant_pool.getConstant(n18).getTag()))).append("</a>");
                break;
            }
            case 189: {
                short s5 = byteSequence.readShort();
                stringBuilder.append(this.constant_html.referenceConstant(s5));
                break;
            }
            case 197: {
                short s6 = byteSequence.readShort();
                byte by = byteSequence.readByte();
                stringBuilder.append(this.constant_html.referenceConstant(s6)).append(":").append(by).append("-dimensional");
                break;
            }
            case 132: {
                short s7;
                int n19;
                if (wide) {
                    n19 = byteSequence.readShort();
                    s7 = byteSequence.readShort();
                    wide = false;
                } else {
                    n19 = byteSequence.readUnsignedByte();
                    s7 = byteSequence.readByte();
                }
                stringBuilder.append("%").append(n19).append(" ").append(s7);
                break;
            }
            default: {
                if (Const.getNoOfOperands(s) <= 0) break;
                int n20 = 0;
                while ((long)n20 < Const.getOperandTypeCount(s)) {
                    switch (Const.getOperandType(s, n20)) {
                        case 8: {
                            stringBuilder.append(byteSequence.readUnsignedByte());
                            break;
                        }
                        case 9: {
                            stringBuilder.append(byteSequence.readShort());
                            break;
                        }
                        case 10: {
                            stringBuilder.append(byteSequence.readInt());
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unreachable default case reached! " + Const.getOperandType(s, n20));
                        }
                    }
                    stringBuilder.append("&nbsp;");
                    ++n20;
                }
                break block0;
            }
        }
        stringBuilder.append("</TD>");
        return stringBuilder.toString();
    }

    private void findGotos(ByteSequence byteSequence, Code code) throws IOException {
        int n;
        int n2;
        this.goto_set = new BitSet(byteSequence.available());
        if (code != null) {
            CodeException[] codeExceptionArray = code.getExceptionTable();
            Cloneable[] cloneableArray = codeExceptionArray;
            int n3 = cloneableArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                CodeException codeException = cloneableArray[n2];
                this.goto_set.set(codeException.getStartPC());
                this.goto_set.set(codeException.getEndPC());
                this.goto_set.set(codeException.getHandlerPC());
            }
            Cloneable[] cloneableArray2 = cloneableArray = code.getAttributes();
            n2 = cloneableArray2.length;
            for (n = 0; n < n2; ++n) {
                LocalVariable[] localVariableArray;
                Cloneable cloneable = cloneableArray2[n];
                if (((Attribute)cloneable).getTag() != 5) continue;
                for (LocalVariable localVariable : localVariableArray = ((LocalVariableTable)cloneable).getLocalVariableTable()) {
                    int n4 = localVariable.getStartPC();
                    int n5 = n4 + localVariable.getLength();
                    this.goto_set.set(n4);
                    this.goto_set.set(n5);
                }
                break;
            }
        }
        block8: while (byteSequence.available() > 0) {
            int n6 = byteSequence.readUnsignedByte();
            switch (n6) {
                case 170: 
                case 171: {
                    int n7;
                    int n8 = byteSequence.getIndex() % 4;
                    int n9 = n8 == 0 ? 0 : 4 - n8;
                    for (n = 0; n < n9; ++n) {
                        byteSequence.readByte();
                    }
                    int n10 = byteSequence.readInt();
                    if (n6 == 170) {
                        n = byteSequence.readInt();
                        int n11 = byteSequence.readInt();
                        n2 = byteSequence.getIndex() - 12 - n9 - 1;
                        this.goto_set.set(n10 += n2);
                        for (int i = 0; i < n11 - n + 1; ++i) {
                            n7 = n2 + byteSequence.readInt();
                            this.goto_set.set(n7);
                        }
                        continue block8;
                    }
                    n = byteSequence.readInt();
                    n2 = byteSequence.getIndex() - 8 - n9 - 1;
                    this.goto_set.set(n10 += n2);
                    for (int i = 0; i < n; ++i) {
                        byteSequence.readInt();
                        n7 = n2 + byteSequence.readInt();
                        this.goto_set.set(n7);
                    }
                    continue block8;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 198: 
                case 199: {
                    int n7 = byteSequence.getIndex() + byteSequence.readShort() - 1;
                    this.goto_set.set(n7);
                    continue block8;
                }
                case 200: 
                case 201: {
                    int n7 = byteSequence.getIndex() + byteSequence.readInt() - 1;
                    this.goto_set.set(n7);
                    continue block8;
                }
            }
            byteSequence.unreadByte();
            this.codeToHTML(byteSequence, 0);
        }
    }

    private void writeMethod(Method method, int n) throws IOException {
        String string = method.getSignature();
        String[] stringArray = Utility.methodSignatureArgumentTypes(string, false);
        String string2 = Utility.methodSignatureReturnType(string, false);
        String string3 = method.getName();
        String string4 = Class2HTML.toHTML(string3);
        String string5 = Utility.accessToString(method.getAccessFlags());
        string5 = Utility.replace(string5, " ", "&nbsp;");
        Attribute[] attributeArray = method.getAttributes();
        this.file.print("<P><B><FONT COLOR=\"#FF0000\">" + string5 + "</FONT>&nbsp;<A NAME=method" + n + ">" + Class2HTML.referenceType(string2) + "</A>&nbsp<A HREF=\"" + this.class_name + "_methods.html#method" + n + "\" TARGET=Methods>" + string4 + "</A>(");
        for (int i = 0; i < stringArray.length; ++i) {
            this.file.print(Class2HTML.referenceType(stringArray[i]));
            if (i >= stringArray.length - 1) continue;
            this.file.print(",&nbsp;");
        }
        this.file.println(")</B></P>");
        Code code = null;
        byte[] byArray = null;
        if (attributeArray.length > 0) {
            this.file.print("<H4>Attributes</H4><UL>\n");
            for (int i = 0; i < attributeArray.length; ++i) {
                byte by = attributeArray[i].getTag();
                if (by != -1) {
                    this.file.print("<LI><A HREF=\"" + this.class_name + "_attributes.html#method" + n + "@" + i + "\" TARGET=Attributes>" + Const.getAttributeName(by) + "</A></LI>\n");
                } else {
                    this.file.print("<LI>" + attributeArray[i] + "</LI>");
                }
                if (by != 2) continue;
                code = (Code)attributeArray[i];
                Attribute[] attributeArray2 = code.getAttributes();
                byArray = code.getCode();
                this.file.print("<UL>");
                for (int j = 0; j < attributeArray2.length; ++j) {
                    by = attributeArray2[j].getTag();
                    this.file.print("<LI><A HREF=\"" + this.class_name + "_attributes.html#method" + n + "@" + i + "@" + j + "\" TARGET=Attributes>" + Const.getAttributeName(by) + "</A></LI>\n");
                }
                this.file.print("</UL>");
            }
            this.file.println("</UL>");
        }
        if (byArray != null) {
            try (ByteSequence byteSequence = new ByteSequence(byArray);){
                byteSequence.mark(byteSequence.available());
                this.findGotos(byteSequence, code);
                byteSequence.reset();
                this.file.println("<TABLE BORDER=0><TR><TH ALIGN=LEFT>Byte<BR>offset</TH><TH ALIGN=LEFT>Instruction</TH><TH ALIGN=LEFT>Argument</TH>");
                while (byteSequence.available() > 0) {
                    int n2 = byteSequence.getIndex();
                    String string6 = this.codeToHTML(byteSequence, n);
                    String string7 = "";
                    if (this.goto_set.get(n2)) {
                        string7 = "<A NAME=code" + n + "@" + n2 + "></A>";
                    }
                    String string8 = byteSequence.getIndex() == byArray.length ? "<A NAME=code" + n + "@" + byArray.length + ">" + n2 + "</A>" : "" + n2;
                    this.file.println("<TR VALIGN=TOP><TD>" + string8 + "</TD><TD>" + string7 + string6 + "</TR>");
                }
            }
            this.file.println("<TR><TD> </A></TD></TR>");
            this.file.println("</TABLE>");
        }
    }
}

